/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.CODER2;
import com.alibaba.fastjson.JSON;

public class StdCoderModelSaveBo {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);
    public static JedisUtil actJedisUtil = new JedisUtil(JedisPoolConf.actJedisConfig);
    public static JedisUtil dpaActJedisUtil = new JedisUtil(JedisPoolConf.dpaActJedisConfig);

    private static String getLastModelKey(String modelKey) {
        return "nz_last_model_new_" + modelKey + "_";
    }

    private static String getADXModelKey(String modelKey) {
        return "TAE:ALGBID:MODEL:" + modelKey;
    }

    public static void saveModelCoderByKeyToJedis(String modelKey, CODER CODER3, String redis) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, CODER3})) {
            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdCoderModelSaveBo.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)CODER3);
            String value2 = StringZIP.zipString((String)value);
            if (redis == "act") {
                actJedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
            } else {
                jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveModelCoderByKeyToJedis(String modelKey, CODER CODER3, JedisUtil redis) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, CODER3})) {
            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdCoderModelSaveBo.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)CODER3);
            String value2 = StringZIP.zipString((String)value);
            redis.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveModelCoderByKeyToJedis(String modelKey, CODER CODER3) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, CODER3})) {
            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdCoderModelSaveBo.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)CODER3);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveADXModelCoderByKeyToJedis(String modelKey, CODER CODER3) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, CODER3})) {
            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdCoderModelSaveBo.getADXModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)CODER3);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static CODER getModelCoderByKeyFromJedis(String modelKey) {
        CODER ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdCoderModelSaveBo.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (CODER)JSON.parseObject((String)ret2, CODER.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static CODER2 getModelCoder2ByKeyFromJedis(String modelKey) {
        CODER2 ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdCoderModelSaveBo.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (CODER2)JSON.parseObject((String)ret2, CODER2.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static CODER getADXModelCoderByKeyFromJedis(String modelKey) {
        CODER ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdCoderModelSaveBo.getADXModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (CODER)JSON.parseObject((String)ret2, CODER.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static CODER getModelCoderByKeyFromJedis(String modelKey, String redis) {
        CODER ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdCoderModelSaveBo.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = null;
            ret1 = redis == "act" ? actJedisUtil.get(key) : (redis == "dpa" ? dpaActJedisUtil.get(key) : jedisUtil.get(key));
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (CODER)JSON.parseObject((String)ret2, CODER.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static CODER getModelCoderByKeyFromJedis(String modelKey, JedisUtil redis) {
        CODER ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdCoderModelSaveBo.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = null;
            ret1 = redis.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (CODER)JSON.parseObject((String)ret2, CODER.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static CODER2 getModelCoder2ByKeyFromJedis(String modelKey, JedisUtil redis) {
        CODER2 ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdCoderModelSaveBo.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = null;
            ret1 = redis.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (CODER2)JSON.parseObject((String)ret2, CODER2.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static CODER getADXModelCoderByKeyFromJedis(String modelKey, JedisUtil redis) {
        CODER ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdCoderModelSaveBo.getADXModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = null;
            ret1 = redis.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (CODER)JSON.parseObject((String)ret2, CODER.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static CODER2 getADXModelCoder2ByKeyFromJedis(String modelKey, JedisUtil redis) {
        CODER2 ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdCoderModelSaveBo.getADXModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = null;
            ret1 = redis.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (CODER2)JSON.parseObject((String)ret2, CODER2.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

