package cn.com.duiba.nezha.alg.example.example;


import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import cn.com.duiba.nezha.alg.example.util.StdModelSave;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import com.alibaba.fastjson.JSON;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ModelReadTest {

    public static FM m = StdModelSave.getModelByKeyFromMD("mid_ftrl_fm_ctr_v006");
    public static void main(String[] args) {

        try {

//            FM m2 = StdModelSave.getModelByKeyFromMD("mid_ftrl_fm_cvr_v009");
//            System.out.println(JSON.toJSONString(m2));


//            StdModelSave.saveModelByKeyToMD("mid_ftrl_fm_cvr_v009",m2);
//
//            FM m3 = StdModelSave.getModelByKeyFromMD("mid_fm_be_cvr_v001");
//            System.out.println(JSON.toJSONString(m3.getUpdateTime()));

//            test(StdModelSave.getModelByKeyFromMD("mid_ftrl_fm_ctr_v001"));
//            test(StdModelSave.getModelByKeyFromMD("mid_fm_ctr_v003"));


            test2(m);






//            test3();
        } catch (Exception e) {
            e.printStackTrace();
        }


    }


    public static void test3() throws Exception {

        ExecutorService executorService = Executors.newFixedThreadPool(30);


        for(int i = 0; i<100; i++)
        {
            RunnableThread thread = new RunnableThread();

            Thread.sleep(10);
            executorService.execute(thread);
        }
        //关闭线程池
        executorService.shutdown();
    }


    static class RunnableThread implements Runnable {
        @Override
        public void run() {
            try {
                test(m);
                System.out.println("通过线程池方式创建的线程：" + Thread.currentThread().getName() + " ");
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }


    public static void test(FM m) throws Exception {
        String featureStr = "{\"f604001\":\"1\",\"f501001\":\"Android\",\"f608001\":\"1\",\"f113001\":\"40104,04.01.0001\",\"f610001\":\"0\",\"f9913\":\"20\",\"f508002\":\"A59s\",\"f806001\":\"15\",\"f508001\":\"OPPO\",\"f9914\":\"com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.documentsui,com.android.dreams.basic,com.android.externalstorage,com.android.htmlviewer,com.android.inputdevices,com.android.keychain,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.redteamobile.virtual.softsim,com.rzwifi.password,com.svox.pico,com.tencent.mm,org.simalliance.openmobileapi.service,se.dirac.acs\",\"f806002\":\"12\",\"f9915\":\"\\\\N,28,1,62,5,19,23,17,60,37,65,40,4,47,21,68,52\",\"f206001\":\"262\",\"f104001\":\"null\",\"f504001\":\"OPPO A59s\",\"f601001\":\"2\",\"f303001\":\"6\",\"f9912\":\"2063\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"11\",\"f502002\":\"4\",\"f611001\":\"2\",\"f206002\":\"260\",\"f403004\":\"0\",\"f9902\":\"android,com.amap.android.location,com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.dlna.service,com.android.documentsui,com.android.dreams.basic,com.android.dreams.phototable,com.android.externalstorage,com.android.htmlviewer,com.android.incallui,com.android.inputdevices,com.android.keychain,com.android.keyguard,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.utk,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.cgshi.fruit1,com.cleanmaster.sdk,com.color.uiengine,com.coloros.activation,com.coloros.alarmclock,com.coloros.appmanager,com.coloros.backup.composer.app,com.coloros.backuprestore,com.coloros.backuprestore.remoteservice,com.coloros.blacklist,com.coloros.bootreg,com.coloros.cloud,com.coloros.compass,com.coloros.exserviceui,com.coloros.feedback,com.coloros.filemanager,com.coloros.findmyphone,com.coloros.fingerprint,com.coloros.flashlight,com.coloros.gallery3d,com.coloros.gesture,com.coloros.keyguard.notification,com.coloros.leather,com.coloros.mcs,com.coloros.newsimdetect,com.coloros.notificationmanager,com.coloros.operationmanual,com.coloros.oppoguardelf,com.coloros.oppomorningsystem,com.coloros.oppomultiapp,com.coloros.phonenoareainquire,com.coloros.photoeffects,com.coloros.pictorial,com.coloros.preventmode,com.coloros.providers.downloads.ui,com.coloros.recents,com.coloros.safe.service.framework,com.coloros.safecenter,com.coloros.sau,com.coloros.screenshot,com.coloros.simsettings,com.coloros.soundrecorder,com.coloros.speechassist,com.coloros.speechassist.engine,com.coloros.usbselection,com.coloros.video,com.coloros.wallpapers,com.coloros.weather,com.coloros.weather.service,com.coloros.widget.smallweather,com.coloros.wirelesssettings,com.criticallog,com.dropboxchmod,com.gnss.power,com.google.android.webview,com.hdkino.browser,com.iflytek.speechcloud,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.miravision.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.mobiletools.systemhelper,com.nearme.atlas,com.nearme.gamecenter,com.nearme.romupdate,com.nearme.statistics.rom,com.nearme.sync,com.nearme.themespace,com.nearme.themespacelib,com.oppo.autotest,com.oppo.bluetooth.pbapclient,com.oppo.c2u,com.oppo.camera,com.oppo.camera.doubleexposure,com.oppo.camera.facebeauty,com.oppo.camera.fastvideomode,com.oppo.camera.filter,com.oppo.camera.gif,com.oppo.camera.panorama,com.oppo.camera.professional,com.oppo.camera.superzoom,com.oppo.ctautoregist,com.oppo.dirac,com.oppo.engineeringmode.specialtest,com.oppo.engineermode,com.oppo.factorygps,com.oppo.fingerprints.fingerprintsensortest,com.oppo.fingerprints.service,com.oppo.gestureservice,com.oppo.launcher,com.oppo.market,com.oppo.music,com.oppo.ota,com.oppo.quicksearchbox,com.oppo.reader,com.oppo.resmonitor,com.oppo.sdcardservice,com.oppo.usagedump,com.oppo.usercenter,com.oppo.webview,com.redteamobile.roaming,com.redteamobile.virtual.softsim,com.rzwifi.password,com.sohu.inputmethod.sogouoem,com.svox.pico,com.ted.number,com.tencent.mm,com.ziipin.softkeyboard,com.zy.org.megabucks.by,oppo,org.simalliance.openmobileapi.eseterminal,org.simalliance.openmobileapi.service,org.simalliance.openmobileapi.uicc1terminal,org.simalliance.openmobileapi.uicc2terminal,se.dirac.acs\",\"f805001\":\"14\",\"f805002\":\"12\",\"f505001\":\"1700-2699\",\"f9906\":\"10,\\\\N,22,32,16,31\",\"f9907\":\"1004,\\\\N,2208,3205,1601,2203,2202,3106\",\"f9908\":\"1\",\"f602001\":\"2\",\"f606001\":\"-1\",\"f205002\":\"55\",\"f205001\":\"27\",\"f201001\":\"21054\",\"f102001\":\"20806,02.15.0008\",\"f106001\":\"5102\",\"f609001\":\"0\",\"f804002\":\"12\",\"f804001\":\"14\",\"f301001\":\"1579\",\"f605001\":\"1\",\"f108001\":\"3408\",\"f807002\":\"12\",\"f101001\":\"20976\",\"f807001\":\"14\",\"f507001\":\"3\",\"f503001\":\"6532\",\"f302001\":\"1579\",\"f306001\":\"2\"}";

        Map<String, String> featureIdxMap = (Map) JSON.parseObject(featureStr);

        TFServingClient tfServingClient = new TFServingClient("10.50.201.66", 9000, "dcn-ctr-001", null);
        Map<String, Map<String, String>> req = new HashMap<>();
        for (int i = 0; i < 50; i++) {
            featureIdxMap.put("f108001", "" + i);
            req.put("a" + i, featureIdxMap);
        }
        Map<String, Double> ret = m.predictWithTF(req, tfServingClient);
        System.out.println("ret=" + JSON.toJSONString(ret));

    }


    public static void test2(FM m) throws Exception {
        String featureStr = "{\"f604001\":\"1\",\"f501001\":\"Android\",\"f608001\":\"1\",\"f113001\":\"40104,04.01.0001\",\"f610001\":\"0\",\"f9913\":\"20\",\"f508002\":\"A59s\",\"f806001\":\"15\",\"f508001\":\"OPPO\",\"f9914\":\"com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.documentsui,com.android.dreams.basic,com.android.externalstorage,com.android.htmlviewer,com.android.inputdevices,com.android.keychain,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.redteamobile.virtual.softsim,com.rzwifi.password,com.svox.pico,com.tencent.mm,org.simalliance.openmobileapi.service,se.dirac.acs\",\"f806002\":\"12\",\"f9915\":\"\\\\N,28,1,62,5,19,23,17,60,37,65,40,4,47,21,68,52\",\"f206001\":\"262\",\"f104001\":\"null\",\"f504001\":\"OPPO A59s\",\"f601001\":\"2\",\"f303001\":\"6\",\"f9912\":\"2063\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"11\",\"f502002\":\"4\",\"f611001\":\"2\",\"f206002\":\"260\",\"f403004\":\"0\",\"f9902\":\"android,com.amap.android.location,com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.dlna.service,com.android.documentsui,com.android.dreams.basic,com.android.dreams.phototable,com.android.externalstorage,com.android.htmlviewer,com.android.incallui,com.android.inputdevices,com.android.keychain,com.android.keyguard,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.utk,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.cgshi.fruit1,com.cleanmaster.sdk,com.color.uiengine,com.coloros.activation,com.coloros.alarmclock,com.coloros.appmanager,com.coloros.backup.composer.app,com.coloros.backuprestore,com.coloros.backuprestore.remoteservice,com.coloros.blacklist,com.coloros.bootreg,com.coloros.cloud,com.coloros.compass,com.coloros.exserviceui,com.coloros.feedback,com.coloros.filemanager,com.coloros.findmyphone,com.coloros.fingerprint,com.coloros.flashlight,com.coloros.gallery3d,com.coloros.gesture,com.coloros.keyguard.notification,com.coloros.leather,com.coloros.mcs,com.coloros.newsimdetect,com.coloros.notificationmanager,com.coloros.operationmanual,com.coloros.oppoguardelf,com.coloros.oppomorningsystem,com.coloros.oppomultiapp,com.coloros.phonenoareainquire,com.coloros.photoeffects,com.coloros.pictorial,com.coloros.preventmode,com.coloros.providers.downloads.ui,com.coloros.recents,com.coloros.safe.service.framework,com.coloros.safecenter,com.coloros.sau,com.coloros.screenshot,com.coloros.simsettings,com.coloros.soundrecorder,com.coloros.speechassist,com.coloros.speechassist.engine,com.coloros.usbselection,com.coloros.video,com.coloros.wallpapers,com.coloros.weather,com.coloros.weather.service,com.coloros.widget.smallweather,com.coloros.wirelesssettings,com.criticallog,com.dropboxchmod,com.gnss.power,com.google.android.webview,com.hdkino.browser,com.iflytek.speechcloud,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.miravision.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.mobiletools.systemhelper,com.nearme.atlas,com.nearme.gamecenter,com.nearme.romupdate,com.nearme.statistics.rom,com.nearme.sync,com.nearme.themespace,com.nearme.themespacelib,com.oppo.autotest,com.oppo.bluetooth.pbapclient,com.oppo.c2u,com.oppo.camera,com.oppo.camera.doubleexposure,com.oppo.camera.facebeauty,com.oppo.camera.fastvideomode,com.oppo.camera.filter,com.oppo.camera.gif,com.oppo.camera.panorama,com.oppo.camera.professional,com.oppo.camera.superzoom,com.oppo.ctautoregist,com.oppo.dirac,com.oppo.engineeringmode.specialtest,com.oppo.engineermode,com.oppo.factorygps,com.oppo.fingerprints.fingerprintsensortest,com.oppo.fingerprints.service,com.oppo.gestureservice,com.oppo.launcher,com.oppo.market,com.oppo.music,com.oppo.ota,com.oppo.quicksearchbox,com.oppo.reader,com.oppo.resmonitor,com.oppo.sdcardservice,com.oppo.usagedump,com.oppo.usercenter,com.oppo.webview,com.redteamobile.roaming,com.redteamobile.virtual.softsim,com.rzwifi.password,com.sohu.inputmethod.sogouoem,com.svox.pico,com.ted.number,com.tencent.mm,com.ziipin.softkeyboard,com.zy.org.megabucks.by,oppo,org.simalliance.openmobileapi.eseterminal,org.simalliance.openmobileapi.service,org.simalliance.openmobileapi.uicc1terminal,org.simalliance.openmobileapi.uicc2terminal,se.dirac.acs\",\"f805001\":\"14\",\"f805002\":\"12\",\"f505001\":\"1700-2699\",\"f9906\":\"10,\\\\N,22,32,16,31\",\"f9907\":\"1004,\\\\N,2208,3205,1601,2203,2202,3106\",\"f9908\":\"1\",\"f602001\":\"2\",\"f606001\":\"-1\",\"f205002\":\"55\",\"f205001\":\"27\",\"f201001\":\"21054\",\"f102001\":\"20806,02.15.0008\",\"f106001\":\"5102\",\"f609001\":\"0\",\"f804002\":\"12\",\"f804001\":\"14\",\"f301001\":\"1579\",\"f605001\":\"1\",\"f108001\":\"3408\",\"f807002\":\"12\",\"f101001\":\"20976\",\"f807001\":\"14\",\"f507001\":\"3\",\"f503001\":\"6532\",\"f302001\":\"1579\",\"f306001\":\"2\"}";

        Map<String, String> featureIdxMap = (Map) JSON.parseObject(featureStr);

        featureIdxMap.put("sub_net_id","10.0");

        double[] ret = m.getParam2(featureIdxMap);
        System.out.println("ret=" + JSON.toJSONString(ret));

    }

    public static void test1(FM m2) throws Exception {


        //String featureStr = "{\"orderId\":\"taw-104985938200462\",\"f608001\":\"0\",\"f113001\":\"04.01.0006\",\"f9913\":\"6\",\"f508002\":\"G5500\",\"f806001\":\"3\",\"f508001\":\"SM\",\"f806002\":\"12\",\"f806003\":\"3\",\"f9916\":\"02.20.0001&4,02.24.0001&5,02.01.0001&2,02.01.0003&2,02.01.0006&2,02.01.0008&11,02.22.0001&4,02.05&7,02.15&4\",\"f806004\":\"7\",\"f9917\":\"02.20.0001&2,02.24.0001&3,02.01.0001&1,02.01.0003&1,02.01.0006&2,02.01.0008&11,02.22.0001&2,02.05&1,02.15&1\",\"f9918\":\"02.20.0001&2,02.24.0001&3,02.01.0001&1,02.01.0003&1,02.01.0006&2,02.01.0008&1,02.22.0001&1,02.05&1,02.15&1\",\"f9919\":\"02.20.0001&10,02.24.0001&11,02.01.0001&8,02.01.0003&8,02.01.0006&10,02.01.0008&2,02.22.0001&7,02.05&6,02.15&6\",\"f104001\":\"null\",\"f603002\":\"7\",\"f603001\":\"7\",\"f110001\":\"1\",\"f502001\":\"14\",\"f502002\":\"0\",\"f611001\":\"31\",\"f505001\":\"600-1099\",\"f809001\":\"2\",\"f809002\":\"9\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"42211\",\"f102001\":\"02.01.0003\",\"f609001\":\"1\",\"f804004\":\"7\",\"f804003\":\"7\",\"f804002\":\"11\",\"f9930\":\"4\",\"f804001\":\"9\",\"f301001\":\"3299\",\"f108001\":\"7260\",\"advertId\":\"28798\",\"f807002\":\"10\",\"f9924\":\"02.15,02.05,02.01.0001,02.01.0008\",\"f807001\":\"4\",\"f507001\":\"4\",\"f807004\":\"5\",\"f807003\":\"4\",\"f9927\":\"2\",\"f810001\":\"1\",\"f9928\":\"1\",\"f810002\":\"0\",\"f9929\":\"2\",\"f9921\":\"02.20.0001,02.01.0006\",\"f306001\":\"2\",\"f9922\":\"02.24.0001\",\"f9923\":\"02.22.0001,02.01.0003\",\"f604002\":\"7\",\"f604001\":\"7\",\"f501001\":\"Android\",\"f610001\":\"0\",\"f206001\":\"262\",\"f504001\":\"SM-G5500\",\"f601001\":\"-1\",\"f601002\":\"14\",\"f303001\":\"6\",\"f114001\":\"118\",\"f607001\":\"0\",\"f114002\":\"134\",\"f206002\":\"260\",\"f811001\":\"104,303,403\",\"f403004\":\"0\",\"f805001\":\"3\",\"f805002\":\"13\",\"f805003\":\"3\",\"f805004\":\"7\",\"f602001\":\"-1\",\"f205002\":\"253\",\"f205001\":\"25\",\"f808002\":\"0_9,02.20.0001_14,02.01.0001_0,02.22.0001_1,02.01.0003_0,02.01.0006_14,02.01.0008_1,02.24.0001_11,02.05_0,02.15_0\",\"f811002\":\"105,403\",\"f106001\":\"7327\",\"f506001\":\"1\",\"f808001\":\"0_2,02.20.0001_6,02.01.0001_1,02.22.0001_6,02.01.0003_1,02.01.0006_13,02.01.0008_1,02.24.0001_11,02.05_1,02.15_1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f101001\":\"28798\",\"f503001\":\"12\",\"time\":\"20180527140014\",\"f302001\":\"3299\",\"f602002\":\"20\"}";
        String featureStr = "{\"f602001\":\"1\",\"f604001\":\"1\",\"f606001\":\"-1\",\"f501001\":\"Android\",\"f608001\":\"0\",\"f113001\":\"40103\",\"f610001\":\"0\",\"cf101201\":\"1565836007\",\"cf101301\":\"156583558\",\"f201001\":\"36007\",\"f102001\":\"22001\",\"f106001\":\"291\",\"f506001\":\"1\",\"f104001\":\"null\",\"f504001\":\"HUAWEINXT-DL00\",\"f609001\":\"0\",\"f601001\":\"1\",\"f301001\":\"3558\",\"f303001\":\"2\",\"f605001\":\"-1\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"8\",\"f108001\":\"3964\",\"f502002\":\"0\",\"f611001\":\"1\",\"f403004\":\"0\",\"f101001\":\"15658\",\"f505001\":\"1700-2699\",\"f503001\":\"31\",\"f302001\":\"3558\",\"f306001\":\"2\"}";
        Map<String, String> featureIdxMap = (Map) JSON.parseObject(featureStr);


        TFServingClient tfServingClient = new TFServingClient("10.50.201.66", 9000, "dcn-ctr-001", null);
//        tfServingClient = null;

        Map<String, Map<String, String>> req = new HashMap<>();
        for (int i = 0; i < 10; i++) {
            featureIdxMap.put("f108001", "" + i);
            req.put("a" + i, featureIdxMap);
        }
        Map<String, Double> ret = m2.predictWithTF(req, tfServingClient);
        System.out.println("ret=" + JSON.toJSONString(ret));


        // m2.predictWithTF
        int times = 1000;

        System.out.println("start " + DateUtil.getCurrentTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        long tStart = System.currentTimeMillis();

        for (int j = 0; j < times; j++) {

            Map<String, Map<String, String>> req2 = new HashMap<>();
            for (int i = 0; i < 100; i++) {
                featureIdxMap.put("f108001", j + "" + i);
                req2.put("a" + i, featureIdxMap);
            }
            Map<String, Double> retTmp = m2.predictWithTF(req2, tfServingClient);
            System.out.println(j);
//            System.out.println("retTmp=" + JSON.toJSONString(retTmp));
        }
        long tEnd = System.currentTimeMillis();
        System.out.println("end " + DateUtil.getCurrentTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("diff=" + (tEnd - tStart) / times);


    }
}
