package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.recallcompare.param.FilterParam;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import com.alibaba.fastjson.JSON;


public class ParamSaver {

    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static void saveFilterParamByKeyToJedis(String modelKey, FilterParam param, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, param)) {
            System.out.println("save empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = modelKey;

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(param);

            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FilterParam getFilterParamByKeyFromJedis(String modelKey, JedisUtil ju) {
        FilterParam ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("get empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = modelKey;
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            ret = JSON.parseObject(ret1, FilterParam.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    public static void main(String[] args) {
        FilterParam filterParam=new FilterParam();
        String key="wangyaole";
        saveFilterParamByKeyToJedis(key,filterParam,jedisUtil);
        FilterParam filterParam1=getFilterParamByKeyFromJedis(key,jedisUtil);
        System.out.println(filterParam1);
    }
}
