package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.alg.vo.adx.rta.RtaRoiControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;

import com.alibaba.fastjson.JSON;

import java.util.*;

//import jdk.nashorn.internal.ir.debug.ObjectSizeCalculator;

public class StatSyncBo {

    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static JedisUtil rtaJedisUtil = new JedisUtil(JedisPoolConf.rtaJedisConfig);

    public static JedisUtil rtaTestJedisUtil = new JedisUtil(JedisPoolConf.rtaTestJedisConfig);


    public static String getModelKey(String modelId, String groupId) {
        String ret = null;

        if (groupId != null) {
            ret = "NZ_K86_nz_alg_s_m_" + modelId + "_" + groupId;
        }
        if (groupId == null) {
            // nz_alg_s_m_strategy_stat_model_v001
            ret = "NZ_K86_nz_alg_s_m_" + modelId;
        }

        return ret;
    }

    /**
     * 存储
     *
     * @param ocpxControlModel
     */
    public static void saveModelToRedis(OcpxControlModel ocpxControlModel, String modelId, int ttl) {

        String key = getModelKey(modelId, null);

        System.out.println("saveModelToRedis key=" + key);

        try {
            String value = JSON.toJSONString(ocpxControlModel);
            String value2 = StringZIP.zipString(value); //压缩

            jedisUtil.setex(key, value2, ttl);

            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS);
            jedisUtil.setex(updateTimeKey, updateTime, ttl);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * @param modelId
     * @return
     */
    public static OcpxControlModel readModelFromRedis(String modelId) {

        String key = getModelKey(modelId, null);
        OcpxControlModel ret = null;
        System.out.println("readModelFromRedis key=" + key);

        try {
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压

            // 解压
            ret = JSON.parseObject(ret2, OcpxControlModel.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * 读取 rta 生产环境
     * @param modelId
     * @return
     */
    public static RtaRoiControlModel readRtaRoiModelFromRedis(String modelId) {

        String key = getModelKey(modelId, null);
        RtaRoiControlModel ret = null;
        System.out.println("readRtaRoiModelFromRedis key=" + key);

        try {
            // 保存
            String ret1 = rtaJedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压

            // 解压
            ret = JSON.parseObject(ret2, RtaRoiControlModel.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * 存储 rta 测试环境
     *
     * @param roiControlModel
     */
    public static void saveRtaTestRoiModelToRedis(RtaRoiControlModel roiControlModel, String modelId, int ttl) {

        String key = getModelKey(modelId, null);

        System.out.println("saveModelToRedis key=" + key);

        try {
            String value = JSON.toJSONString(roiControlModel);
            String value2 = StringZIP.zipString(value); //压缩


            rtaTestJedisUtil.setex(key, value2, ttl);

            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS);
            rtaTestJedisUtil.setex(updateTimeKey, updateTime, ttl);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 读取 rta 测试环境
     * @param modelId
     * @return
     */
    public static RtaRoiControlModel readRtaTestRoiModelFromRedis(String modelId) {

        String key = getModelKey(modelId, null);
        RtaRoiControlModel ret = null;
        System.out.println("readRtaRoiModelFromRedis key=" + key);

        try {
            // 保存
            String ret1 = rtaTestJedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压

            // 解压
            ret = JSON.parseObject(ret2, RtaRoiControlModel.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


}