package cn.com.duiba.nezha.alg.example.example.dpa;

import cn.com.duiba.nezha.alg.alg.dpa.ActRcmderTFServing;
import cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.*;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lijingzhe
 * @description
 * @date 2020/7/27
 */
public class DPAServingTFModelTest {
    @Test
    public void rcmd() {

        String str1 = "{\n" +
                "      \"f332011\": \"3555\",\n" +
                "      \"f332012\": \"2\",\n" +
                "      \"f332013\": \"1615\",\n" +
                "      \"f332001\": \"3506\",\n" +
                "      \"f332002\": \"2\",\n" +
                "      \"f332031\": \"3550\",\n" +
                "      \"f332032\": \"2\",\n" +
                "      \"f332033\": \"1615\",\n" +
                "      \"f301001\": \"17673\",\n" +
                "      \"f332021\": \"3549\",\n" +
                "      \"f332022\": \"2\",\n" +
                "      \"f332023\": \"1615\"\n" +
                "    }";

        String str2 = "{\n" +
                "      \"f415004\": \"0\",\n" +
                "      \"f411001\": \"8\",\n" +
                "      \"f411003\": \"8\",\n" +
                "      \"f411002\": \"8\",\n" +
                "      \"f501001\": \"Android\",\n" +
                "      \"f411005\": \"0\",\n" +
                "      \"f411004\": \"2\",\n" +
                "      \"f213001\": \"229,25,289,217,110,63,205,73,6,265,49,241,37\",\n" +
                "      \"f213002\": \"1213,2617,2161,2413,1297,193,385,205,1717,685,85,25,1969,1861,1909,769,253,721,13,1105,2797,1453,1525,1753,1,505,289,157,1333,709,601,1849,397,2389,2497,2665,2833,973,145,2269,301,181,421,109,169,433,37,589,133,2341,229,1501,1933,121\",\n" +
                "      \"f213003\": \"25,289,73,8,266\",\n" +
                "      \"f213004\": \"1717,37,589,289,2161,85,2797,709,121,253,2665,1754\",\n" +
                "      \"f414003\": \"174\",\n" +
                "      \"f462002\": \"0\",\n" +
                "      \"f414004\": \"2\",\n" +
                "      \"f414001\": \"178\",\n" +
                "      \"f414002\": \"178\",\n" +
                "      \"f410001\": \"1\",\n" +
                "      \"f414007\": \"4\",\n" +
                "      \"f414008\": \"0\",\n" +
                "      \"f414005\": \"0\",\n" +
                "      \"f502001\": \"15\",\n" +
                "      \"f502002\": \"1\",\n" +
                "      \"f811001\": \"103,305,406\",\n" +
                "      \"f332001\": \"3506\",\n" +
                "      \"f332002\": \"2\",\n" +
                "      \"f212004\": \"1930,427,1547,3429,3087,4510,313,335,293,2724,4473,143,45,1227,4397,408,1150,65,941,4454,4437,3713,2786,9,82,828,466,2328,996,1131,198,4227\",\n" +
                "      \"f451003\": \"01050303\",\n" +
                "      \"f212003\": \"140,274,28,46,466,349,449,178,155,103,331,122,217,232,10,428,388,64\",\n" +
                "      \"f451002\": \"010212\",\n" +
                "      \"f212002\": \"1931,3546,2727,2957,3033,3053,411,1855,1149,739,902,2786,11,808,468,2691,964,637,3964,4229,1418,2181,294,1570,3374,181,3108,4117,278,696,3149,942,3981,3717,4152,4383,355,1970,4515,618,334,145,49,3127,3582,4458,4439,1038,2119,240,3678,4400,69,2495,2460,82,374,202,4421,2064,4018,3812,1950,2008,3886,1095,29,260,105,1133,2934,4496,447,1699,482,4474,2327,3432,1020,3825,3089,4247,315,1225,1759,2310,2422,827,2083,3793,2239,429,1551,3604,3474,677,3254,218,2386,996,3244,3068,3699,507\",\n" +
                "      \"f212001\": \"316,145,277,28,369,50,468,352,294,449,182,164,106,331,126,221,236,12,429,87,392,66\",\n" +
                "      \"f451004\": \"05011701\",\n" +
                "      \"f809001\": \"7\",\n" +
                "      \"f809002\": \"1\",\n" +
                "      \"f451001\": \"010101\",\n" +
                "      \"f201001\": \"52999\",\n" +
                "      \"f461002\": \"23,142,42,82\",\n" +
                "      \"f211003\": \"85,169,13,25,290,217,277,109,97,61,212,73,133,145,1,265,241,37\",\n" +
                "      \"f211002\": \"1213,1297,2233,2533,2401,1717,1225,1261,2449,685,1861,1909,1921,253,1165,721,13,565,1753,1,505,289,157,61,709,1693,601,1849,397,2497,2665,2833,277,889,1369,1069,301,181,2825,985,2125,109,1957,2593,169,433,1981,589,2509,2341,1465,2617,2761,2161,637,217,2413,1237,1945,2845,2677,193,385,205,85,25,1969,769,2257,2809,1105,2797,1453,1525,649,517,1333,1309,2389,1405,265,973,145,2317,2269,2185,421,2775,2053,37,133,1573,1549,229,1501,625,2041,1933,121,2785,2329,313\",\n" +
                "      \"f808002\": \"02.04.0001_1,02.07.0004_1,02.22.0001_1,02.22.0005_1,02.07_1,02.06_1,02.01.0009_0,02.16_1,02.04_1,02.15_1,02.09_1,02.19_1,02.02.0005_1,0_1,02.16.0002_1,02.02_1,02.01_0,02.19.0001_1,02.06.0003_1,02.22_1,02.15.0002_1,02.09.0001_1,02.15.0009_1\",\n" +
                "      \"f211001\": \"193,85,169,13,229,25,290,218,181,277,109,97,63,208,73,133,145,1,265,49,241,37\",\n" +
                "      \"f811002\": \"108\",\n" +
                "      \"f471003\": \"123,7,32,147,101,223,79,54,247,199,175\",\n" +
                "      \"f808001\": \"02.04.0001_12,02.07.0004_8,02.22.0001_9,02.22.0005_12,02.07_8,02.06_12,02.01.0009_1,02.16_12,02.04_12,02.15_7,02.09_6,02.19_12,02.02.0005_12,0_7,02.16.0002_12,02.02_12,02.01_1,02.19.0001_12,02.06.0003_12,02.22_10,02.15.0002_7,02.09.0001_6,02.15.0009_12\",\n" +
                "      \"f211004\": \"1213,265,973,2161,1945,2845,193,205,181,1717,2828,85,25,769,2773,253,721,37,589,2809,2797,2341,1753,1,49,517,289,1465,625,709,121,2665\",\n" +
                "      \"f412002\": \"8\",\n" +
                "      \"f412001\": \"8\",\n" +
                "      \"f412004\": \"2\",\n" +
                "      \"f412003\": \"6\",\n" +
                "      \"f412005\": \"0\",\n" +
                "      \"f108001\": \"327485\",\n" +
                "      \"f9924\": \"\",\n" +
                "      \"f503001\": \"110000\",\n" +
                "      \"f214001\": \"211,116,450,47,139,553,415,7,508,96,461,71\",\n" +
                "      \"f214002\": \"2325,5016,4141,4626,2486,370,741,393,3291,1315,162,48,3774,3586,3664,1474,485,25,1382,2118,5360,2785,2924,3361,1,968,554,301,2555,1359,1171,3544,761,4579,4787,5108,5430,1865,278,4356,578,347,807,227,324,830,70,1129,260,4486,458,2878,3705,232\",\n" +
                "      \"f214003\": \"48,139,553,3,508\",\n" +
                "      \"f214004\": \"3292,71,1129,554,4142,163,5360,1359,232,485,5108,3361\",\n" +
                "      \"f9921\": \"02.06,02.16,02.04\",\n" +
                "      \"f9922\": \"\",\n" +
                "      \"f9923\": \"02.07,02.15,02.09\"\n" +
                "    }";

        String str3 = "{\n" +
                "  \"actPackageType\": 1,\n" +
                "  \"activityId\": 21539,\n" +
                "  \"activityMatchScore\": 1.6095641360650956,\n" +
                "  \"mainTitleFeature\": {},\n" +
                "  \"prizeGroup\": [\n" +
                "    {\n" +
                "      \"ad\": false,\n" +
                "      \"adTagId\": \"\",\n" +
                "      \"id\": 3369,\n" +
                "      \"matchScore\": 0.7468535392287502,\n" +
                "      \"prizeFeature\": {},\n" +
                "      \"prizeTagId\": 1615\n" +
                "    },\n" +
                "    {\n" +
                "      \"ad\": false,\n" +
                "      \"adTagId\": \"\",\n" +
                "      \"id\": 222,\n" +
                "      \"matchScore\": 0.561096323924515,\n" +
                "      \"prizeFeature\": {},\n" +
                "      \"prizeTagId\": 1613\n" +
                "    },\n" +
                "    {\n" +
                "      \"ad\": false,\n" +
                "      \"adTagId\": \"\",\n" +
                "      \"id\": 914,\n" +
                "      \"matchScore\": 0.709767198571097,\n" +
                "      \"prizeFeature\": {},\n" +
                "      \"prizeTagId\": 2010\n" +
                "    },\n" +
                "    {\n" +
                "      \"ad\": false,\n" +
                "      \"adTagId\": \"\",\n" +
                "      \"id\": 4069,\n" +
                "      \"matchScore\": 0.7224311624862629,\n" +
                "      \"prizeFeature\": {},\n" +
                "      \"prizeTagId\": 1616\n" +
                "    },\n" +
                "    {\n" +
                "      \"ad\": false,\n" +
                "      \"adTagId\": \"\",\n" +
                "      \"id\": 4723,\n" +
                "      \"matchScore\": 1.497347305283229,\n" +
                "      \"prizeFeature\": {},\n" +
                "      \"prizeTagId\": 1611\n" +
                "    },\n" +
                "    {\n" +
                "      \"ad\": false,\n" +
                "      \"adTagId\": \"\",\n" +
                "      \"id\": 4721,\n" +
                "      \"matchScore\": 0.6807441413788193,\n" +
                "      \"prizeFeature\": {},\n" +
                "      \"prizeTagId\": 2012\n" +
                "    }\n" +
                "  ],\n" +
                "  \"routineActFeature\": {},\n" +
                "  \"skinFeature\": {},\n" +
                "  \"subTitleFeature\": {},\n" +
                "  \"subTitleId\": 458,\n" +
                "  \"subTitleMatchScore\": 2.046189703830131,\n" +
                "  \"titleId\": 252,\n" +
                "  \"titleMatchScore\": 1.1417803141051603,\n" +
                "  \"titleTagId\": \"1657,1655\"\n" +
                "}";
        String str4 = "{\n" +
                "  \"activityChangeVal\": {\n" +
                "    \"changeScoreForms\": 0.0,\n" +
                "    \"changeScoreMerge\": 0.0,\n" +
                "    \"changeScoreNotForms\": 0.0,\n" +
                "    \"sumClickForms\": 0.0,\n" +
                "    \"sumClickNotForms\": 12.0,\n" +
                "    \"sumEffectPVForms\": 0.0,\n" +
                "    \"sumEffectPVNotForms\": 0.0\n" +
                "  },\n" +
                "  \"activityId\": 18753,\n" +
                "  \"activityType\": 0,\n" +
                "  \"appId\": 52999,\n" +
                "  \"changeScore\": 0.0,\n" +
                "  \"cvr\": 0.0,\n" +
                "  \"cvrBias\": 0.000017114125505242337,\n" +
                "  \"excellent\": false,\n" +
                "  \"hisClick\": {\n" +
                "    \"algSlotVal\": 0.0,\n" +
                "    \"appVal\": 263.0,\n" +
                "    \"globalVal\": 6705.0,\n" +
                "    \"slotVal\": 12.0\n" +
                "  },\n" +
                "  \"hisCost\": {\n" +
                "    \"algSlotVal\": 0.0,\n" +
                "    \"appVal\": 250.0,\n" +
                "    \"globalVal\": 149675.0,\n" +
                "    \"slotVal\": 20.0\n" +
                "  },\n" +
                "  \"hisEffect\": {\n" +
                "    \"algSlotVal\": 0.0,\n" +
                "    \"appVal\": 0.0,\n" +
                "    \"globalVal\": 0.0,\n" +
                "    \"slotVal\": 0.0\n" +
                "  },\n" +
                "  \"hisRequest\": {\n" +
                "    \"algSlotVal\": 0.0,\n" +
                "    \"appVal\": 379.0,\n" +
                "    \"globalVal\": 29912.0,\n" +
                "    \"slotVal\": 10.0\n" +
                "  },\n" +
                "  \"nCvr\": 0.0,\n" +
                "  \"nCvrForm\": 0.0,\n" +
                "  \"nCvrNotForm\": 0.0,\n" +
                "  \"nPvClick\": 0.0,\n" +
                "  \"nPvCost\": 0.0,\n" +
                "  \"score\": 0.0,\n" +
                "  \"slotId\": 327485,\n" +
                "  \"subType\": 0,\n" +
                "  \"support\": false,\n" +
                "  \"ucRate\": 0.0,\n" +
                "  \"uvClick\": 0.0,\n" +
                "  \"uvCost\": 0.0\n" +
                "}";

        Map<String, String> dynamicMap = JSON.parseObject(str1, Map.class);
        Map<String, String> staticMap = JSON.parseObject(str2, Map.class);
        CandidateActivityDo candidateActivityDo = JSON.parseObject(str3, CandidateActivityDo.class);
        ActivityMatchInfo activityMatchInfo = JSON.parseObject(str4, ActivityMatchInfo.class);

        List<CandidateActivityDo> candidateActivityDos = new ArrayList<>();
        candidateActivityDos.add(candidateActivityDo);
        List<ActivityMatchInfo> activityMatchInfos = new ArrayList<>();
        activityMatchInfos.add(activityMatchInfo);

        Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setDynamicFeatureMap(dynamicMap);
        featureMapDo.setStaticFeatureMap(staticMap);

        featureMapDoMap.put(1, featureMapDo);
        System.out.println("featureMapDo:" + featureMapDo.getDynamicFeatureMap());

        try {
            //1 编码器获取 缓存
            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_cost_v001", "dpa");
            System.out.println(clickCoderModel.getUpdateTime());
            //2 TFServing获取
            int nLen = 100;
            for (int j = 0; j < nLen; j++) {
                Long t1 = System.currentTimeMillis();
                TFServingClient tfServingClient = new TFServingClient("10.50.203.140", 9000, "deepfm-e2e-dpa-cost-v002", null);
                Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);
                Long t2 = System.currentTimeMillis();
                Long diffT = t2 - t1;
                System.out.println("predict:" + clickPRpmMap+",diffT:"+diffT);
                DPAActFeatureDo dpa = new DPAActFeatureDo();
                SlotActFeature slotActFeature = new SlotActFeature();
                UserProfileFeature userProfileFeature = new UserProfileFeature();
                FeatureDo featureDo = new FeatureDo();
                UserActFeature userActFeature = new UserActFeature();
                Long t3 = System.currentTimeMillis();

                List<CandidateActivityDo> cDos = new ArrayList<>(activityMatchInfos.size());
                for (ActivityMatchInfo aInfo : activityMatchInfos) {
                    CandidateActivityDo cDo = new CandidateActivityDo();
                    cDo.setActivityId(aInfo.getActivityId());
                    double matchScore = ActRcmderTFServing.getMatchScore(aInfo);
                    cDo.setActivityMatchScore(matchScore);
                    cDo.setActPackageType(0);
                    cDos.add(cDo);
                }

                ActRcmdDo actRcmdDo = ActRcmderTFServing.recSort(clickCoderModel,tfServingClient,candidateActivityDos,cDos,dpa,slotActFeature,userProfileFeature,featureDo,userActFeature);
                Long t4 = System.currentTimeMillis();
                Long diffT2 = t4 - t3;
                System.out.println("predict2:" + actRcmdDo.getpCpm()+",diffT2:" + diffT2);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
