package cn.com.duiba.nezha.alg.example.example.model;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class DeepModelV2Test {
    public JedisUtil getJudis() {
        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);
        return juOnline;
    }

    public DeepModelV2 getCoder(String key) {
        JedisUtil juOnline = getJudis();
        DeepModelV2 codeModel = StdCoderModelSaveBo.getModelByKeyFromJedis(key, juOnline, DeepModelV2.class);
        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
        System.out.println("codeModel:" + key + ",codeModel.UpdateTime = " + codeModel.getUpdateTime() + " ,codeModel_ps= " + codeModel.getModelId());
        return codeModel;
    }

    public LocalTFModelV2 getTfModel(String path) throws Exception {
        LocalTFModelV2 ltfModel = new LocalTFModelV2();
        ltfModel.loadModel(path,"202");
        return ltfModel;
    }

    public Map<Long, Double> predict(DeepModelV2 coder, LocalTFModelV2 tfModel, Map<Long, FeatureMapDo> featureMapDoMap) throws Exception {
        Map<Long, Double> ret = new HashMap<>();
        ret = coder.predictWithLocalTFV2(featureMapDoMap, tfModel);
        return ret;
    }

    public Map<Long, FeatureMapDo> getFeatureMapDo() {
        Map<Long, FeatureMapDo> featureMapDoMap = new HashMap<>();

        String str1 = "{\"f9702\": \"0\",\"f205002\": \"1378\",\"f205001\": \"10\",\"f404003\": \"workother\",\"f701002\": \"1061874\"}";
        Map<String, String> featureIdxMap1 = (Map) JSON.parseObject(str1);
        String str2 = "{\"f101001\":\"69442\"}";
        Map<String, String> featureIdxMap2 = (Map) JSON.parseObject(str2);

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureIdxMap1);
        featureMapDo.setDynamicFeatureMap(featureIdxMap2);
        featureMapDoMap.put(69442l, featureMapDo);
        return featureMapDoMap;

    }

    @Test
    public void test() throws Exception {

        DeepModelV2 coder = getCoder("nz_last_model_new_ad_ctr_deep_v1110");

//        LocalTFModelV2 localTFModelCtcvr = new LocalTFModelV2();
//        localTFModelCtcvr.loadModel("/Users/duibagroup/Desktop/lwj/model/mid-cvr-v001","201");

        String path = "/Users/duibagroup/data/model/mid-cvr-v001";
        File file = new File(path);
        if (file.isDirectory()) {

            System.out.println(JSON.toJSONString(file.canRead()));
            System.out.println("ss=" + JSON.toJSONString(file.listFiles()));
//
//            File[] listFiles = file.listFiles();
//
//            System.out.println(listFiles);

        }


        LocalTFModelV2 ltfModel = new LocalTFModelV2();
        System.out.println(ltfModel.getLastVersion(path));


        LocalTFModelV2 tfModel = getTfModel(path);
        Map<Long, FeatureMapDo> featureMapDoMap = getFeatureMapDo();
        Map<Long, Double> ret = predict(coder, tfModel, featureMapDoMap);
        System.out.println(ret);

    }



}
