package cn.com.duiba.nezha.alg.example.example.model;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import cn.com.duiba.nezha.alg.model.vo.CodeDo;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeepModelV2Test {
    public JedisUtil getJudis() {
        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);
        return juOnline;
    }

    public DeepModelV2 getCoder(String key) {
        JedisUtil juOnline = getJudis();
        DeepModelV2 codeModel = StdCoderModelSaveBo.getModelByKeyFromJedis(key, juOnline, DeepModelV2.class);
        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
        System.out.println("codeModel:" + key + ",codeModel.UpdateTime = " + codeModel.getUpdateTime() + " ,codeModel_ps= " + codeModel.getModelId());
        return codeModel;
    }

    public LocalTFModelV2 getTfModel(String path) throws Exception {
        LocalTFModelV2 ltfModel = new LocalTFModelV2();
        ltfModel.loadModel(path,"202301290434");
        return ltfModel;
    }

    public Map<Long, Double> predict(DeepModelV2 coder, LocalTFModelV2 tfModel, Map<Long, FeatureMapDo> featureMapDoMap) throws Exception {
        Map<Long, Double> ret = new HashMap<>();
        ret = coder.predictWithLocalTFV3(featureMapDoMap, tfModel);
        return ret;
    }

    public Map<Long, FeatureMapDo> getFeatureMapDo() {
        Map<Long, FeatureMapDo> featureMapDoMap = new HashMap<>();

        String str1 ="{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11415482669230879\",\"ft400102\":\"15_16\",\"ft400101\":\"15_13\",\"ft100204\":\"rmx2176\",\"ft100203\":\"ANDROID11\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"f8080011\":\"0_12,02.19.0001_12,02.19_12\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100603\":\"1,2,8,10,21\",\"ft100206\":\"4\",\"ft100602\":\"100907_1,101001_1,101005_1,100601_1,100602_1\",\"ft200201\":\"3\",\"ft100205\":\"realme\",\"ft100601\":\"1006_1,1010_1,1009_1\",\"ft500104\":\"27_3\",\"ft500102\":\"43827_3\",\"ft500103\":\"15_3\",\"ft100209\":\"MOB\",\"ft500101\":\"84571_3\",\"ft110001\":\"0\",\"ft110000\":\"4\",\"ft300101\":\"90446\",\"ft300102\":\"1\",\"ft300103\":\"90446\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"0\",\"ft110913\":\"1\",\"ft110912\":\"11\",\"ft110914\":\"2\",\"ft110909\":\"-1\",\"ft300904\":\"3\",\"ft300108\":\"628\",\"ft300901\":\"3\",\"ft300902\":\"37\",\"ft300903\":\"3708\",\"ft300104\":\"27\",\"ft300105\":\"267\",\"ft300106\":\"716\",\"ft300107\":\"696\",\"ft110102\":\"0\",\"ft301003\":\"5\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"1\",\"ft110103\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0127\",\"ft110902\":\"16\",\"ft200104\":\"15\",\"ft110901\":\"32834\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"145952\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft110906\":\"1\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft110907\":\"0\",\"ft400801\":\"13\",\"ft400803\":\"0\",\"ft400802\":\"8\",\"ft200101\":\"84571\",\"ft200102\":\"43827\",\"ft300313\":\"941\",\"ft300201\":\"429637\",\"ft300202\":\"3\",\"ft600204\":\"203971101\",\"ft600203\":\"1000187680\",\"ft600202\":\"213549\",\"advertId\":\"84571\",\"abst\":\"[0,3]\",\"f8080021\":\"0_4,02.19.0001_4,02.19_4\",\"f5090012\":\"15_rmx2176\",\"ft111021\":\"7\",\"ft300204\":\"429637\",\"f306001\":\"2\",\"chargeType\":\"2\",\"f8090011\":\"12\",\"ft100001\":\"12b8bbb9b8a755d41a66f3b6681931e0\",\"ft400302\":\"16\",\"ft400301\":\"12\",\"ft400303\":\"6\",\"ft400702\":\"16\",\"f5070015\":\"43827_移动\",\"ft400701\":\"12\",\"f5070016\":\"15_移动\",\"ft400703\":\"6\",\"f5090022\":\"15_realme\",\"f8100021\":\"0\",\"f5070011\":\"84571_1\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"30974\",\"consumerId\":\"33952245615\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"30974\",\"ft300305\":\"8\",\"ft110302\":\"02.19.0001_7,02.19_7\",\"ft110301\":\"02.19.0001_7,02.19_7\",\"ft110303\":\"02.19.0001_1,02.19_1\",\"ft110702\":\"4\",\"ft110701\":\"12\",\"ft110704\":\"0_4,02.19.0001_4,02.19_4\",\"ft110703\":\"0_12,02.19.0001_12,02.19_12\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"13\",\"ft400202\":\"16\",\"ft400601\":\"8\",\"ft100105\":\"030703,030705,030104,030106,030101,030111,031201\",\"ft400603\":\"7\",\"ft400602\":\"16\",\"ft100505\":\"1006,1010,1009\",\"ft100107\":\"010101\",\"ft100106\":\"01020402\",\"ft500203\":\"15_null\",\"ft500204\":\"27_null\",\"ft500201\":\"84571_null\",\"f8807\":\"1\",\"ft500202\":\"43827_null\",\"ft100506\":\"100907,101001,101005,100601,100602\",\"ft900004\":\"4\",\"ft110014\":\"1\",\"ft900003\":\"84571_1\",\"ft110013\":\"0\",\"ft900006\":\"15_移动\",\"ft900005\":\"43827_移动\",\"ft900008\":\"15_realme\",\"ft900007\":\"15_rmx2176\",\"f8090021\":\"4\",\"time\":\"20221205120458\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";

        String str2 ="{\"ft110003\":\"0\",\"ft110002\":\"4\",\"orderId\":\"taw-11415482332170563\",\"ft200202\":\"23\",\"ft400102\":\"1_15,12_5,3_14,15_18,16_7,17_19,7_2,19_4,9_13,10_18,21_3\",\"ft400101\":\"1_10,12_12,3_13,15_10,16_11,17_14,7_11,19_12,9_10,10_6,21_10\",\"ft100204\":\"spn-al00\",\"ft100203\":\"ANDROID10\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"f8080011\":\"0_12,02.23.0001_12,02.14_12,02.14.0001_12,02.23_12\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"4\",\"ft200201\":\"3\",\"ft100205\":\"huawei\",\"ft500104\":\"27_3\",\"ft500102\":\"44242_3\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"85116_3\",\"ft110001\":\"4\",\"ft300101\":\"89347\",\"ft300102\":\"1\",\"ft300103\":\"89347\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"2\",\"ft110909\":\"-1\",\"ft300904\":\"4\",\"ft300108\":\"628\",\"ft300901\":\"1\",\"ft300109\":\"com.delusiandroid.server.ctsbroch\",\"ft300902\":\"14\",\"ft300903\":\"1410\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"716\",\"ft300107\":\"671\",\"ft110102\":\"3\",\"ft301003\":\"5\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"3\",\"ft301002\":\"1\",\"ft110103\":\"0\",\"ft110502\":\"84465_1,84769_1,85107_1,84863_1\",\"ft110501\":\"84769_1,84465_1,85107_1,84863_1\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0137\",\"ft200104\":\"15\",\"ft110901\":\"32769\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"147421\",\"ft110903\":\"07.09.0224\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft400801\":\"14\",\"ft400803\":\"0\",\"ft400802\":\"13\",\"ft200101\":\"85116\",\"ft200102\":\"44242\",\"ft300313\":\"941\",\"ft300201\":\"417669\",\"ft300202\":\"3\",\"advertId\":\"85116\",\"abst\":\"[0,3]\",\"f8080021\":\"0_1,02.23.0001_1,02.14_1,02.14.0001_1,02.23_1\",\"f5090012\":\"15_spn-al00\",\"ft300204\":\"417669\",\"f306001\":\"2\",\"ft110601\":\"84769,84465,85107,84863\",\"ft110602\":\"84769,84465,85107,84863\",\"ft110605\":\"07.09.0237,07.09.0218,07.26.0145,07.09.0224\",\"chargeType\":\"2\",\"ft110604\":\"44883,45124,45012,45220\",\"ft110606\":\"1,15\",\"f8090011\":\"12\",\"ft100001\":\"d69aafad425bf9ca967637084f3a8eaa\",\"ft400302\":\"13\",\"ft400301\":\"15\",\"ft400303\":\"9\",\"ft400702\":\"15\",\"f5070015\":\"44242_电信\",\"ft400701\":\"13\",\"f5070016\":\"15_电信\",\"ft400703\":\"7\",\"f5090022\":\"15_huawei\",\"ft111011\":\"4\",\"f8100021\":\"1\",\"f5070011\":\"85116_3\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"32769\",\"consumerId\":\"34253958707\",\"f9110031\":\"84769_85116,84465_85116,85107_85116,84863_85116\",\"ft300306\":\"2\",\"f8100011\":\"12\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"32769\",\"ft300305\":\"0\",\"ft300111\":\"1\",\"ft110302\":\"02.23.0001_3,02.14_1,02.14.0001_1,02.23_3\",\"ft110301\":\"02.23.0001_3,02.14_1,02.14.0001_1,02.23_3\",\"ft110303\":\"02.23.0001_0,02.14_0,02.14.0001_0,02.23_0\",\"ft110702\":\"1\",\"ft110701\":\"12\",\"ft300110\":\"1\",\"ft110704\":\"0_1,02.23.0001_1,02.14_1,02.14.0001_1,02.23_1\",\"ft110703\":\"0_12,02.23.0001_12,02.14_12,02.14.0001_12,02.23_12\",\"ft110706\":\"1\",\"ft110705\":\"12\",\"ft400201\":\"10\",\"ft400202\":\"18\",\"ft400601\":\"15\",\"ft400603\":\"9\",\"ft400602\":\"13\",\"ft500203\":\"15_23\",\"ft500204\":\"27_23\",\"ft500201\":\"85116_23\",\"f8807\":\"1\",\"ft500202\":\"44242_23\",\"ft900004\":\"4\",\"ft110014\":\"5\",\"ft900003\":\"85116_3\",\"ft110013\":\"0\",\"ft900006\":\"15_电信\",\"ft900005\":\"44242_电信\",\"ft900008\":\"15_huawei\",\"ft900007\":\"15_spn-al00\",\"f8090021\":\"1\",\"ft900001\":\"84769_85116,84465_85116,85107_85116,84863_85116\",\"time\":\"20221205120444\",\"ft110012\":\"4\",\"ft110011\":\"4\"}";

        String str3 ="{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11415482563561023\",\"ft400102\":\"1_15,12_16,15_16,16_3\",\"ft400101\":\"1_8,12_7,15_8,16_9\",\"ft100204\":\"m2104k10ac\",\"ft100203\":\"ANDROID12\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"f8080011\":\"0_1,02.23.0001_0,02.23_1\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"4\",\"ft100602\":\"101505_1,100406_1,100907_1,101001_1,101102_1,101103_1,101303_1,101105_1,100402_1,100601_1,100602_1\",\"ft200201\":\"3\",\"ft100205\":\"redmi\",\"ft100601\":\"1018_1,1006_1,1017_1,1016_1,1004_1,1013_1,1022_1,1011_1,1010_1,1009_1\",\"ft500104\":\"27_3\",\"ft500102\":\"44948_3\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"85026_3\",\"ft110001\":\"0\",\"ft110000\":\"3\",\"ft300101\":\"90820\",\"ft300102\":\"1\",\"ft300103\":\"90820\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"0\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"1\",\"ft110909\":\"-1\",\"ft300904\":\"3\",\"ft300108\":\"628\",\"ft300901\":\"4\",\"ft300109\":\"com.kuaiyin.player\",\"ft300902\":\"43\",\"ft300903\":\"4302\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"690\",\"ft300107\":\"671\",\"ft110102\":\"0\",\"ft301003\":\"5\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"1\",\"ft110103\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0230\",\"ft110902\":\"15\",\"ft200104\":\"15\",\"ft110901\":\"32343\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"147244\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft110906\":\"0\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"1\",\"ft400801\":\"13\",\"ft400803\":\"0\",\"ft400802\":\"9\",\"ft200101\":\"85026\",\"ft200102\":\"44948\",\"ft300313\":\"941\",\"ft600201\":\"14794768\",\"ft300201\":\"425385\",\"ft300202\":\"3\",\"ft600204\":\"27677048063\",\"ft600203\":\"2241421171\",\"ft600202\":\"3xdpekef7s6j2nk\",\"advertId\":\"85026\",\"abst\":\"[0,3]\",\"f8080021\":\"0_0,02.23.0001_0,02.23_0\",\"ft600208\":\"2\",\"ft600207\":\"0\",\"ft600206\":\"939\",\"f5090012\":\"15_m2104k10ac\",\"ft111021\":\"4\",\"ft300204\":\"425385\",\"f306001\":\"2\",\"chargeType\":\"2\",\"f8090011\":\"1\",\"ft100001\":\"0cf845735771b1b3f263bea176b8f66c\",\"ft400302\":\"16\",\"ft400301\":\"6\",\"ft400303\":\"10\",\"ft400702\":\"16\",\"f5070015\":\"44948_电信\",\"ft400701\":\"9\",\"f5070016\":\"15_电信\",\"ft400703\":\"10\",\"f5090022\":\"15_redmi\",\"ft111011\":\"7\",\"f8100021\":\"0\",\"f5070011\":\"85026_3\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"32825\",\"consumerId\":\"34253321215\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"32825\",\"ft300305\":\"0\",\"ft300111\":\"4\",\"ft110302\":\"02.23.0001_0,02.23_0\",\"ft110301\":\"02.23.0001_0,02.23_1\",\"ft110303\":\"02.23.0001_0,02.23_0\",\"ft110702\":\"0\",\"ft110701\":\"1\",\"ft300110\":\"4\",\"ft110704\":\"0_0,02.23.0001_0,02.23_0\",\"ft110703\":\"0_1,02.23.0001_0,02.23_1\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"8\",\"ft400202\":\"16\",\"ft400601\":\"6\",\"ft100105\":\"030703,030705,030308,03020607,031514,031108,030203,030206,030101,031521,030111,030202,031201,03020604,03020503\",\"ft100501\":\"33002000,34002000,23002000,25002000,41002000,54002000,50002000,28002000,61002000,24002000,39002000,29002000\",\"ft400603\":\"10\",\"ft100103\":\"010501\",\"ft400602\":\"16\",\"ft100505\":\"1018,1006,1017,1016,1004,1013,1022,1011,1010,1009\",\"ft100107\":\"010101\",\"ft100503\":\"34162100,23083100,23022200,50012400,23093700,23092500,23012600,23022300\",\"ft100106\":\"010202\",\"ft100502\":\"33122000,34162000,23082000,23022000,50012000,28292000,23092000,23012000,24012000,34012000,34142000,39062000,23152000,23032000\",\"ft500203\":\"15_null\",\"ft500204\":\"27_null\",\"ft500201\":\"85026_null\",\"f8807\":\"1\",\"ft500202\":\"44948_null\",\"ft100506\":\"101505,100406,100907,101001,101102,101103,101303,101105,100402,100601,100602\",\"ft900004\":\"4\",\"ft110014\":\"2\",\"ft900003\":\"85026_3\",\"ft110013\":\"0\",\"ft900006\":\"15_电信\",\"ft900005\":\"44948_电信\",\"ft900008\":\"15_redmi\",\"ft900007\":\"15_m2104k10ac\",\"f8090021\":\"0\",\"time\":\"20221205120433\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";


        String str4="{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11428420551390741\",\"ft400102\":\"1_15,12_16,3_18,15_18,4_2,16_9,17_19,19_4,9_13,10_18,21_3\",\"ft400101\":\"1_12,12_13,3_15,15_13,4_13,16_11,17_11,19_12,9_12,10_8,21_8\",\"ft100204\":\"lio-an00\",\"ft100203\":\"ANDROID12\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"6\",\"ft200201\":\"3\",\"ft100205\":\"huawei\",\"ft500104\":\"27_3\",\"ft500102\":\"45351_3\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"86054_3\",\"ft110001\":\"0\",\"ft300101\":\"89347\",\"ft300102\":\"1\",\"ft300103\":\"89347\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"4\",\"ft300108\":\"628\",\"ft300901\":\"4\",\"ft300109\":\"com.quliang.smjl\",\"ft300902\":\"41\",\"ft300903\":\"4104\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"716\",\"ft300107\":\"671\",\"ft110102\":\"0\",\"ft301003\":\"18\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"3\",\"ft110103\":\"0\",\"ft301001\":\"8\",\"ft200103\":\"07.09.0192\",\"ft200104\":\"15\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"149876\",\"ft200107\":\"05.02.0020,05.03.0001\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft400801\":\"15\",\"ft400803\":\"5\",\"ft400802\":\"16\",\"ft200101\":\"86054\",\"ft200102\":\"45351\",\"ft300201\":\"417669\",\"ft300202\":\"3\",\"advertId\":\"86054\",\"abst\":\"[0,3]\",\"f5090012\":\"15_lio-an00\",\"ft300204\":\"417669\",\"f306001\":\"2\",\"chargeType\":\"2\",\"ft100001\":\"e23fc3155407fd2b16d56772904b2bdf\",\"ft400302\":\"18\",\"ft400301\":\"16\",\"ft400303\":\"9\",\"ft400702\":\"18\",\"f5070015\":\"45351_未知\",\"ft400701\":\"12\",\"f5070016\":\"15_未知\",\"ft400703\":\"6\",\"f5090022\":\"15_huawei\",\"f8100021\":\"0\",\"f5070011\":\"86054_4\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"33242\",\"consumerId\":\"35112800997\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"33242\",\"ft300305\":\"0\",\"ft300111\":\"12\",\"ft300110\":\"3\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"13\",\"ft400202\":\"18\",\"ft400601\":\"16\",\"ft400603\":\"8\",\"ft400602\":\"18\",\"ft500203\":\"15_null\",\"ft500204\":\"27_null\",\"ft500201\":\"86054_null\",\"f8807\":\"1\",\"ft500202\":\"45351_null\",\"ft900004\":\"4\",\"ft110014\":\"1\",\"ft900003\":\"86054_4\",\"ft110013\":\"0\",\"ft900006\":\"15_未知\",\"ft900005\":\"45351_未知\",\"ft900008\":\"15_huawei\",\"ft900007\":\"15_lio-an00\",\"time\":\"20230118085926\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";



        String str5="{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11430978099720721\",\"ft400102\":\"1_12,12_18,3_2,15_16,16_5,17_0,9_2,10_19,21_1\",\"ft400101\":\"1_10,12_12,3_10,15_15,4_8,16_16,17_9,7_9,9_11,10_15,21_14\",\"ft100204\":\"lon-al00\",\"ft100203\":\"ANDROID9\",\"ft100202\":\"3\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"2016\",\"ft100206\":\"6\",\"ft200201\":\"3\",\"ft100205\":\"huawei\",\"ft500104\":\"38_3\",\"ft500102\":\"45355_3\",\"ft500103\":\"15_3\",\"ft100209\":\"MOB\",\"ft500101\":\"85921_3\",\"ft110001\":\"0\",\"ft300101\":\"83525\",\"ft300102\":\"1\",\"ft300103\":\"83525\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"1\",\"ft300108\":\"628\",\"ft300901\":\"7\",\"ft300902\":\"61\",\"ft300903\":\"6101\",\"ft300104\":\"38\",\"ft300105\":\"365\",\"ft300106\":\"692\",\"ft300107\":\"673\",\"ft110102\":\"0\",\"ft301003\":\"29\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"7\",\"ft110103\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0271\",\"ft200104\":\"15\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"149427\",\"ft200107\":\"05.02.0020,05.03.0001\",\"ft200108\":\"98be4804980643905b78f8dfc8d9ee5\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft400801\":\"14\",\"ft400803\":\"4\",\"ft400802\":\"11\",\"ft200101\":\"85921\",\"ft200102\":\"45355\",\"ft300201\":\"387156\",\"ft300202\":\"1\",\"advertId\":\"85921\",\"abst\":\"[0,3]\",\"f5090012\":\"15_lon-al00\",\"ft300204\":\"387156\",\"f306001\":\"2\",\"coder\":\"null;0.020239;202301290434;:0,21,42,48,73,406,1919,21296,23178,23190,23204,23225,23256,23287,23318,23338,23342,23348,23647,33445,34396,34859,36005,39910,40109,44937,45002,45081,65082,65183,65385,67878,70407,70428,72754,75460,75958,75999,76313,76524,76535,76591,76623,76655,77648,77749,127750:0;9,21\",\"chargeType\":\"2\",\"ft100001\":\"2edad4cb97326181a45503658166aa86\",\"ft400302\":\"17\",\"ft400301\":\"17\",\"ft400303\":\"6\",\"ft400702\":\"17\",\"f5070015\":\"45355_电信\",\"ft400701\":\"16\",\"f5070016\":\"15_电信\",\"ft400703\":\"7\",\"f5090022\":\"15_huawei\",\"ft111011\":\"1\",\"f8100021\":\"0\",\"f5070011\":\"85921_3\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"33207\",\"consumerId\":\"35319648977\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"33207\",\"ft300305\":\"12\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"15\",\"ft400202\":\"16\",\"ft400601\":\"17\",\"ft400603\":\"6\",\"ft400602\":\"17\",\"ft500203\":\"15_null\",\"ft500204\":\"38_null\",\"ft500201\":\"85921_null\",\"f8807\":\"1\",\"ft500202\":\"45355_null\",\"ft900004\":\"4\",\"ft110014\":\"1\",\"ft900003\":\"85921_3\",\"ft110013\":\"0\",\"ft900006\":\"15_电信\",\"ft900005\":\"45355_电信\",\"ft900008\":\"15_huawei\",\"ft900007\":\"15_lon-al00\",\"time\":\"20230129124437\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";




        //featureMapDoMap.put(1L, getFeatureMapDo(str1) );// 0.27
        //featureMapDoMap.put(2L, getFeatureMapDo(str2) );// 0.066
        //featureMapDoMap.put(3L, getFeatureMapDo(str3) );//0.017
        //featureMapDoMap.put(5L, getFeatureMapDo(str5) );//0.016467
        featureMapDoMap.put(4L, getFeatureMapDo(str4) );//0.041171

        featureMapDoMap.put(5L, getFeatureMapDo(str5) );//0.016467

        return featureMapDoMap;


    }

    public FeatureMapDo getFeatureMapDo(String str1) {

        Map<String, String> featureIdxMap1 = (Map) JSON.parseObject(str1);
        //String str2 = "{\"f101001\":\"69442\"}";
        Map<String, String> featureIdxMap2 = new HashMap<>();

        //List<String> a= Arrays.asList("ft200101","ft200102","ft200103","ft200104","ft200106","ft200107","ft400303","ft200201","ft200202","ft500103");
        //List<String> a= Arrays.asList("ft200101","ft200102","ft200103","ft200104","ft200106","ft200107","ft400303","ft200201","ft200202","ft500103");

//        for(String f : a){
//            featureIdxMap2.put(f,featureIdxMap1.getOrDefault(f,null));
//            featureIdxMap1.remove(f);
//        }

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureIdxMap1);
        featureMapDo.setDynamicFeatureMap(featureIdxMap2);
        return featureMapDo;

    }

    @Test
    public void test() throws Exception {

        DeepModelV2 coder = getCoder("nz_last_model_new_ad_ctcvr_deep_v1230_");

//        LocalTFModelV2 localTFModelCtcvr = new LocalTFModelV2();
//        localTFModelCtcvr.loadModel("/Users/duibagroup/Desktop/lwj/model/mid-cvr-v001","201");

        String path = "/Users/duibagroup/data/model/mid-ad-cvr-v010";
//        File file = new File(path);
//        if (file.isDirectory()) {
//
//            System.out.println(JSON.toJSONString(file.canRead()));
//            System.out.println("ss=" + JSON.toJSONString(file.listFiles()));
////
////            File[] listFiles = file.listFiles();
////
////            System.out.println(listFiles);
//
//        }





        LocalTFModelV2 tfModel = getTfModel(path);
        Map<Long, FeatureMapDo> featureMapDoMap = getFeatureMapDo();
        Map<Long, Double> ret = predict(coder, tfModel, featureMapDoMap);
        System.out.println(ret);

        for(Map.Entry<Long,FeatureMapDo> entry :featureMapDoMap.entrySet()){
            Long key = entry.getKey();
            FeatureMapDo value = entry.getValue();

            CodeDo codeDo= coder.getSampleDense(value.getFeatureMap(),null);

            System.out.println(key+"1-----"+coder.toString(codeDo));

            System.out.println(key+"2-----"+JSON.toJSONString(value.getCodeDoStr()));

        }



    }



}
