package cn.com.duiba.nezha.alg.example.example.model;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import cn.com.duiba.nezha.alg.model.vo.CodeDo;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeepModelV2Test {
    public JedisUtil getJudis() {
        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94pd.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6366);
        JedisUtil juOnline = new JedisUtil(jcOnline);
        return juOnline;
    }

    public DeepModelV2 getCoder(String key) {
        JedisUtil juOnline = getJudis();
        DeepModelV2 codeModel = StdCoderModelSaveBo.getModelByKeyFromJedis(key, juOnline, DeepModelV2.class);
        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
        System.out.println("codeModel:" + key + ",codeModel.UpdateTime = " + codeModel.getUpdateTime() + " ,codeModel_ps= " + codeModel.getModelId());
        return codeModel;
    }

    public LocalTFModelV2 getTfModel(String path) throws Exception {
        LocalTFModelV2 ltfModel = new LocalTFModelV2();
        ltfModel.loadModel(path,"202310300935");
        return ltfModel;
    }

    public Map<Long, Double> predict(DeepModelV2 coder, LocalTFModelV2 tfModel, Map<Long, FeatureMapDo> featureMapDoMap) throws Exception {
        Map<Long, Double> ret = new HashMap<>();
        ret = coder.predictWithLocalTFV3(featureMapDoMap, tfModel);
        return ret;
    }

    public Map<Long, FeatureMapDo> getFeatureMapDo() {
        Map<Long, FeatureMapDo> featureMapDoMap = new HashMap<>();

        String str1 ="{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11415482669230879\",\"ft400102\":\"15_16\",\"ft400101\":\"15_13\",\"ft100204\":\"rmx2176\",\"ft100203\":\"ANDROID11\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"f8080011\":\"0_12,02.19.0001_12,02.19_12\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100603\":\"1,2,8,10,21\",\"ft100206\":\"4\",\"ft100602\":\"100907_1,101001_1,101005_1,100601_1,100602_1\",\"ft200201\":\"3\",\"ft100205\":\"realme\",\"ft100601\":\"1006_1,1010_1,1009_1\",\"ft500104\":\"27_3\",\"ft500102\":\"43827_3\",\"ft500103\":\"15_3\",\"ft100209\":\"MOB\",\"ft500101\":\"84571_3\",\"ft110001\":\"0\",\"ft110000\":\"4\",\"ft300101\":\"90446\",\"ft300102\":\"1\",\"ft300103\":\"90446\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"0\",\"ft110913\":\"1\",\"ft110912\":\"11\",\"ft110914\":\"2\",\"ft110909\":\"-1\",\"ft300904\":\"3\",\"ft300108\":\"628\",\"ft300901\":\"3\",\"ft300902\":\"37\",\"ft300903\":\"3708\",\"ft300104\":\"27\",\"ft300105\":\"267\",\"ft300106\":\"716\",\"ft300107\":\"696\",\"ft110102\":\"0\",\"ft301003\":\"5\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"1\",\"ft110103\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0127\",\"ft110902\":\"16\",\"ft200104\":\"15\",\"ft110901\":\"32834\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"145952\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft110906\":\"1\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft110907\":\"0\",\"ft400801\":\"13\",\"ft400803\":\"0\",\"ft400802\":\"8\",\"ft200101\":\"84571\",\"ft200102\":\"43827\",\"ft300313\":\"941\",\"ft300201\":\"429637\",\"ft300202\":\"3\",\"ft600204\":\"203971101\",\"ft600203\":\"1000187680\",\"ft600202\":\"213549\",\"advertId\":\"84571\",\"abst\":\"[0,3]\",\"f8080021\":\"0_4,02.19.0001_4,02.19_4\",\"f5090012\":\"15_rmx2176\",\"ft111021\":\"7\",\"ft300204\":\"429637\",\"f306001\":\"2\",\"chargeType\":\"2\",\"f8090011\":\"12\",\"ft100001\":\"12b8bbb9b8a755d41a66f3b6681931e0\",\"ft400302\":\"16\",\"ft400301\":\"12\",\"ft400303\":\"6\",\"ft400702\":\"16\",\"f5070015\":\"43827_移动\",\"ft400701\":\"12\",\"f5070016\":\"15_移动\",\"ft400703\":\"6\",\"f5090022\":\"15_realme\",\"f8100021\":\"0\",\"f5070011\":\"84571_1\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"30974\",\"consumerId\":\"33952245615\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"30974\",\"ft300305\":\"8\",\"ft110302\":\"02.19.0001_7,02.19_7\",\"ft110301\":\"02.19.0001_7,02.19_7\",\"ft110303\":\"02.19.0001_1,02.19_1\",\"ft110702\":\"4\",\"ft110701\":\"12\",\"ft110704\":\"0_4,02.19.0001_4,02.19_4\",\"ft110703\":\"0_12,02.19.0001_12,02.19_12\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"13\",\"ft400202\":\"16\",\"ft400601\":\"8\",\"ft100105\":\"030703,030705,030104,030106,030101,030111,031201\",\"ft400603\":\"7\",\"ft400602\":\"16\",\"ft100505\":\"1006,1010,1009\",\"ft100107\":\"010101\",\"ft100106\":\"01020402\",\"ft500203\":\"15_null\",\"ft500204\":\"27_null\",\"ft500201\":\"84571_null\",\"f8807\":\"1\",\"ft500202\":\"43827_null\",\"ft100506\":\"100907,101001,101005,100601,100602\",\"ft900004\":\"4\",\"ft110014\":\"1\",\"ft900003\":\"84571_1\",\"ft110013\":\"0\",\"ft900006\":\"15_移动\",\"ft900005\":\"43827_移动\",\"ft900008\":\"15_realme\",\"ft900007\":\"15_rmx2176\",\"f8090021\":\"4\",\"time\":\"20221205120458\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";

        String str2 ="{\"ft110003\":\"0\",\"ft110002\":\"4\",\"orderId\":\"taw-11415482332170563\",\"ft200202\":\"23\",\"ft400102\":\"1_15,12_5,3_14,15_18,16_7,17_19,7_2,19_4,9_13,10_18,21_3\",\"ft400101\":\"1_10,12_12,3_13,15_10,16_11,17_14,7_11,19_12,9_10,10_6,21_10\",\"ft100204\":\"spn-al00\",\"ft100203\":\"ANDROID10\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"f8080011\":\"0_12,02.23.0001_12,02.14_12,02.14.0001_12,02.23_12\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"4\",\"ft200201\":\"3\",\"ft100205\":\"huawei\",\"ft500104\":\"27_3\",\"ft500102\":\"44242_3\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"85116_3\",\"ft110001\":\"4\",\"ft300101\":\"89347\",\"ft300102\":\"1\",\"ft300103\":\"89347\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"2\",\"ft110909\":\"-1\",\"ft300904\":\"4\",\"ft300108\":\"628\",\"ft300901\":\"1\",\"ft300109\":\"com.delusiandroid.server.ctsbroch\",\"ft300902\":\"14\",\"ft300903\":\"1410\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"716\",\"ft300107\":\"671\",\"ft110102\":\"3\",\"ft301003\":\"5\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"3\",\"ft301002\":\"1\",\"ft110103\":\"0\",\"ft110502\":\"84465_1,84769_1,85107_1,84863_1\",\"ft110501\":\"84769_1,84465_1,85107_1,84863_1\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0137\",\"ft200104\":\"15\",\"ft110901\":\"32769\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"147421\",\"ft110903\":\"07.09.0224\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft400801\":\"14\",\"ft400803\":\"0\",\"ft400802\":\"13\",\"ft200101\":\"85116\",\"ft200102\":\"44242\",\"ft300313\":\"941\",\"ft300201\":\"417669\",\"ft300202\":\"3\",\"advertId\":\"85116\",\"abst\":\"[0,3]\",\"f8080021\":\"0_1,02.23.0001_1,02.14_1,02.14.0001_1,02.23_1\",\"f5090012\":\"15_spn-al00\",\"ft300204\":\"417669\",\"f306001\":\"2\",\"ft110601\":\"84769,84465,85107,84863\",\"ft110602\":\"84769,84465,85107,84863\",\"ft110605\":\"07.09.0237,07.09.0218,07.26.0145,07.09.0224\",\"chargeType\":\"2\",\"ft110604\":\"44883,45124,45012,45220\",\"ft110606\":\"1,15\",\"f8090011\":\"12\",\"ft100001\":\"d69aafad425bf9ca967637084f3a8eaa\",\"ft400302\":\"13\",\"ft400301\":\"15\",\"ft400303\":\"9\",\"ft400702\":\"15\",\"f5070015\":\"44242_电信\",\"ft400701\":\"13\",\"f5070016\":\"15_电信\",\"ft400703\":\"7\",\"f5090022\":\"15_huawei\",\"ft111011\":\"4\",\"f8100021\":\"1\",\"f5070011\":\"85116_3\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"32769\",\"consumerId\":\"34253958707\",\"f9110031\":\"84769_85116,84465_85116,85107_85116,84863_85116\",\"ft300306\":\"2\",\"f8100011\":\"12\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"32769\",\"ft300305\":\"0\",\"ft300111\":\"1\",\"ft110302\":\"02.23.0001_3,02.14_1,02.14.0001_1,02.23_3\",\"ft110301\":\"02.23.0001_3,02.14_1,02.14.0001_1,02.23_3\",\"ft110303\":\"02.23.0001_0,02.14_0,02.14.0001_0,02.23_0\",\"ft110702\":\"1\",\"ft110701\":\"12\",\"ft300110\":\"1\",\"ft110704\":\"0_1,02.23.0001_1,02.14_1,02.14.0001_1,02.23_1\",\"ft110703\":\"0_12,02.23.0001_12,02.14_12,02.14.0001_12,02.23_12\",\"ft110706\":\"1\",\"ft110705\":\"12\",\"ft400201\":\"10\",\"ft400202\":\"18\",\"ft400601\":\"15\",\"ft400603\":\"9\",\"ft400602\":\"13\",\"ft500203\":\"15_23\",\"ft500204\":\"27_23\",\"ft500201\":\"85116_23\",\"f8807\":\"1\",\"ft500202\":\"44242_23\",\"ft900004\":\"4\",\"ft110014\":\"5\",\"ft900003\":\"85116_3\",\"ft110013\":\"0\",\"ft900006\":\"15_电信\",\"ft900005\":\"44242_电信\",\"ft900008\":\"15_huawei\",\"ft900007\":\"15_spn-al00\",\"f8090021\":\"1\",\"ft900001\":\"84769_85116,84465_85116,85107_85116,84863_85116\",\"time\":\"20221205120444\",\"ft110012\":\"4\",\"ft110011\":\"4\"}";

        String str3 ="{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11415482563561023\",\"ft400102\":\"1_15,12_16,15_16,16_3\",\"ft400101\":\"1_8,12_7,15_8,16_9\",\"ft100204\":\"m2104k10ac\",\"ft100203\":\"ANDROID12\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"f8080011\":\"0_1,02.23.0001_0,02.23_1\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"4\",\"ft100602\":\"101505_1,100406_1,100907_1,101001_1,101102_1,101103_1,101303_1,101105_1,100402_1,100601_1,100602_1\",\"ft200201\":\"3\",\"ft100205\":\"redmi\",\"ft100601\":\"1018_1,1006_1,1017_1,1016_1,1004_1,1013_1,1022_1,1011_1,1010_1,1009_1\",\"ft500104\":\"27_3\",\"ft500102\":\"44948_3\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"85026_3\",\"ft110001\":\"0\",\"ft110000\":\"3\",\"ft300101\":\"90820\",\"ft300102\":\"1\",\"ft300103\":\"90820\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"0\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"1\",\"ft110909\":\"-1\",\"ft300904\":\"3\",\"ft300108\":\"628\",\"ft300901\":\"4\",\"ft300109\":\"com.kuaiyin.player\",\"ft300902\":\"43\",\"ft300903\":\"4302\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"690\",\"ft300107\":\"671\",\"ft110102\":\"0\",\"ft301003\":\"5\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"1\",\"ft110103\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0230\",\"ft110902\":\"15\",\"ft200104\":\"15\",\"ft110901\":\"32343\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"147244\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft110906\":\"0\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"1\",\"ft400801\":\"13\",\"ft400803\":\"0\",\"ft400802\":\"9\",\"ft200101\":\"85026\",\"ft200102\":\"44948\",\"ft300313\":\"941\",\"ft600201\":\"14794768\",\"ft300201\":\"425385\",\"ft300202\":\"3\",\"ft600204\":\"27677048063\",\"ft600203\":\"2241421171\",\"ft600202\":\"3xdpekef7s6j2nk\",\"advertId\":\"85026\",\"abst\":\"[0,3]\",\"f8080021\":\"0_0,02.23.0001_0,02.23_0\",\"ft600208\":\"2\",\"ft600207\":\"0\",\"ft600206\":\"939\",\"f5090012\":\"15_m2104k10ac\",\"ft111021\":\"4\",\"ft300204\":\"425385\",\"f306001\":\"2\",\"chargeType\":\"2\",\"f8090011\":\"1\",\"ft100001\":\"0cf845735771b1b3f263bea176b8f66c\",\"ft400302\":\"16\",\"ft400301\":\"6\",\"ft400303\":\"10\",\"ft400702\":\"16\",\"f5070015\":\"44948_电信\",\"ft400701\":\"9\",\"f5070016\":\"15_电信\",\"ft400703\":\"10\",\"f5090022\":\"15_redmi\",\"ft111011\":\"7\",\"f8100021\":\"0\",\"f5070011\":\"85026_3\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"32825\",\"consumerId\":\"34253321215\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"32825\",\"ft300305\":\"0\",\"ft300111\":\"4\",\"ft110302\":\"02.23.0001_0,02.23_0\",\"ft110301\":\"02.23.0001_0,02.23_1\",\"ft110303\":\"02.23.0001_0,02.23_0\",\"ft110702\":\"0\",\"ft110701\":\"1\",\"ft300110\":\"4\",\"ft110704\":\"0_0,02.23.0001_0,02.23_0\",\"ft110703\":\"0_1,02.23.0001_0,02.23_1\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"8\",\"ft400202\":\"16\",\"ft400601\":\"6\",\"ft100105\":\"030703,030705,030308,03020607,031514,031108,030203,030206,030101,031521,030111,030202,031201,03020604,03020503\",\"ft100501\":\"33002000,34002000,23002000,25002000,41002000,54002000,50002000,28002000,61002000,24002000,39002000,29002000\",\"ft400603\":\"10\",\"ft100103\":\"010501\",\"ft400602\":\"16\",\"ft100505\":\"1018,1006,1017,1016,1004,1013,1022,1011,1010,1009\",\"ft100107\":\"010101\",\"ft100503\":\"34162100,23083100,23022200,50012400,23093700,23092500,23012600,23022300\",\"ft100106\":\"010202\",\"ft100502\":\"33122000,34162000,23082000,23022000,50012000,28292000,23092000,23012000,24012000,34012000,34142000,39062000,23152000,23032000\",\"ft500203\":\"15_null\",\"ft500204\":\"27_null\",\"ft500201\":\"85026_null\",\"f8807\":\"1\",\"ft500202\":\"44948_null\",\"ft100506\":\"101505,100406,100907,101001,101102,101103,101303,101105,100402,100601,100602\",\"ft900004\":\"4\",\"ft110014\":\"2\",\"ft900003\":\"85026_3\",\"ft110013\":\"0\",\"ft900006\":\"15_电信\",\"ft900005\":\"44948_电信\",\"ft900008\":\"15_redmi\",\"ft900007\":\"15_m2104k10ac\",\"f8090021\":\"0\",\"time\":\"20221205120433\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";


        String str4="{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11428420551390741\",\"ft400102\":\"1_15,12_16,3_18,15_18,4_2,16_9,17_19,19_4,9_13,10_18,21_3\",\"ft400101\":\"1_12,12_13,3_15,15_13,4_13,16_11,17_11,19_12,9_12,10_8,21_8\",\"ft100204\":\"lio-an00\",\"ft100203\":\"ANDROID12\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"6\",\"ft200201\":\"3\",\"ft100205\":\"huawei\",\"ft500104\":\"27_3\",\"ft500102\":\"45351_3\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"86054_3\",\"ft110001\":\"0\",\"ft300101\":\"89347\",\"ft300102\":\"1\",\"ft300103\":\"89347\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"4\",\"ft300108\":\"628\",\"ft300901\":\"4\",\"ft300109\":\"com.quliang.smjl\",\"ft300902\":\"41\",\"ft300903\":\"4104\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"716\",\"ft300107\":\"671\",\"ft110102\":\"0\",\"ft301003\":\"18\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"3\",\"ft110103\":\"0\",\"ft301001\":\"8\",\"ft200103\":\"07.09.0192\",\"ft200104\":\"15\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"149876\",\"ft200107\":\"05.02.0020,05.03.0001\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft400801\":\"15\",\"ft400803\":\"5\",\"ft400802\":\"16\",\"ft200101\":\"86054\",\"ft200102\":\"45351\",\"ft300201\":\"417669\",\"ft300202\":\"3\",\"advertId\":\"86054\",\"abst\":\"[0,3]\",\"f5090012\":\"15_lio-an00\",\"ft300204\":\"417669\",\"f306001\":\"2\",\"chargeType\":\"2\",\"ft100001\":\"e23fc3155407fd2b16d56772904b2bdf\",\"ft400302\":\"18\",\"ft400301\":\"16\",\"ft400303\":\"9\",\"ft400702\":\"18\",\"f5070015\":\"45351_未知\",\"ft400701\":\"12\",\"f5070016\":\"15_未知\",\"ft400703\":\"6\",\"f5090022\":\"15_huawei\",\"f8100021\":\"0\",\"f5070011\":\"86054_4\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"33242\",\"consumerId\":\"35112800997\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"33242\",\"ft300305\":\"0\",\"ft300111\":\"12\",\"ft300110\":\"3\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"13\",\"ft400202\":\"18\",\"ft400601\":\"16\",\"ft400603\":\"8\",\"ft400602\":\"18\",\"ft500203\":\"15_null\",\"ft500204\":\"27_null\",\"ft500201\":\"86054_null\",\"f8807\":\"1\",\"ft500202\":\"45351_null\",\"ft900004\":\"4\",\"ft110014\":\"1\",\"ft900003\":\"86054_4\",\"ft110013\":\"0\",\"ft900006\":\"15_未知\",\"ft900005\":\"45351_未知\",\"ft900008\":\"15_huawei\",\"ft900007\":\"15_lio-an00\",\"time\":\"20230118085926\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";



        String str5="{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11430978099720721\",\"ft400102\":\"1_12,12_18,3_2,15_16,16_5,17_0,9_2,10_19,21_1\",\"ft400101\":\"1_10,12_12,3_10,15_15,4_8,16_16,17_9,7_9,9_11,10_15,21_14\",\"ft100204\":\"lon-al00\",\"ft100203\":\"ANDROID9\",\"ft100202\":\"3\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"2016\",\"ft100206\":\"6\",\"ft200201\":\"3\",\"ft100205\":\"huawei\",\"ft500104\":\"38_3\",\"ft500102\":\"45355_3\",\"ft500103\":\"15_3\",\"ft100209\":\"MOB\",\"ft500101\":\"85921_3\",\"ft110001\":\"0\",\"ft300101\":\"83525\",\"ft300102\":\"1\",\"ft300103\":\"83525\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"1\",\"ft300108\":\"628\",\"ft300901\":\"7\",\"ft300902\":\"61\",\"ft300903\":\"6101\",\"ft300104\":\"38\",\"ft300105\":\"365\",\"ft300106\":\"692\",\"ft300107\":\"673\",\"ft110102\":\"0\",\"ft301003\":\"29\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"7\",\"ft110103\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0271\",\"ft200104\":\"15\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"149427\",\"ft200107\":\"05.02.0020,05.03.0001\",\"ft200108\":\"98be4804980643905b78f8dfc8d9ee5\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft400801\":\"14\",\"ft400803\":\"4\",\"ft400802\":\"11\",\"ft200101\":\"85921\",\"ft200102\":\"45355\",\"ft300201\":\"387156\",\"ft300202\":\"1\",\"advertId\":\"85921\",\"abst\":\"[0,3]\",\"f5090012\":\"15_lon-al00\",\"ft300204\":\"387156\",\"f306001\":\"2\",\"coder\":\"null;0.020239;202301290434;:0,21,42,48,73,406,1919,21296,23178,23190,23204,23225,23256,23287,23318,23338,23342,23348,23647,33445,34396,34859,36005,39910,40109,44937,45002,45081,65082,65183,65385,67878,70407,70428,72754,75460,75958,75999,76313,76524,76535,76591,76623,76655,77648,77749,127750:0;9,21\",\"chargeType\":\"2\",\"ft100001\":\"2edad4cb97326181a45503658166aa86\",\"ft400302\":\"17\",\"ft400301\":\"17\",\"ft400303\":\"6\",\"ft400702\":\"17\",\"f5070015\":\"45355_电信\",\"ft400701\":\"16\",\"f5070016\":\"15_电信\",\"ft400703\":\"7\",\"f5090022\":\"15_huawei\",\"ft111011\":\"1\",\"f8100021\":\"0\",\"f5070011\":\"85921_3\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"33207\",\"consumerId\":\"35319648977\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"33207\",\"ft300305\":\"12\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"15\",\"ft400202\":\"16\",\"ft400601\":\"17\",\"ft400603\":\"6\",\"ft400602\":\"17\",\"ft500203\":\"15_null\",\"ft500204\":\"38_null\",\"ft500201\":\"85921_null\",\"f8807\":\"1\",\"ft500202\":\"45355_null\",\"ft900004\":\"4\",\"ft110014\":\"1\",\"ft900003\":\"85921_3\",\"ft110013\":\"0\",\"ft900006\":\"15_电信\",\"ft900005\":\"45355_电信\",\"ft900008\":\"15_huawei\",\"ft900007\":\"15_lon-al00\",\"time\":\"20230129124437\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";

        //0.045901	1	1	2023-04-11 18:34:13
//        String str7 = "{\"orderId\":\"taw-11442290516880259\",\"ft100204\":\"rte-al00\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.3827154\",\"ft100205\":\"huawei\",\"ft500103\":\"15_3\",\"ft100209\":\"MOB\",\"ft500101\":\"87240_3\",\"ft300101\":\"85261\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"1\",\"ft300901\":\"3\",\"ft300109\":\"com.kxandroid.server.ctswalk\",\"ft300902\":\"33\",\"ft300903\":\"3301\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"985\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.09.0122\",\"ft200104\":\"15\",\"ft200106\":\"152827\",\"ft200107\":\"05.02.0020,05.03.0013\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"87240\",\"ft200102\":\"44042\",\"fd_1602_04\":\"0.0428277\",\"fd_1602_03\":\"0.3668731\",\"ft600201\":\"13294934\",\"ft300201\":\"413904\",\"ft300202\":\"3\",\"advertId\":\"87240\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0192055\",\"fd_1506_07\":\"0.2603112\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.4339977\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"33485\",\"ft6002021\":\"3xcke9tfv7ib87s\",\"consumerId\":\"36123403523\",\"fd_1501\":\"85561\",\"fd_1502\":\"85561\",\"fd_1505\":\"15\",\"ft300306\":\"2\",\"fd_1506\":\"15\",\"fd_1503\":\"87243\",\"fd_1504\":\"85561\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"15\",\"ft300304\":\"33485\",\"fd_1508\":\"15\",\"ft300305\":\"0\",\"ft6002031\":\"1856531648\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"ft500203\":\"15_null\",\"ft500201\":\"87240_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"25382667655\",\"fd_1502_04\":\"0.0268779\",\"fd_1005\":\"1,23,2,47,27,18,40,30,10\",\"fd_1007\":\"100802,101002,100302,101502,100205\",\"fd_1502_03\":\"0.3196281\",\"fd_1006\":\"1008,1015,1003,1002,1010\",\"fd_1601_02\":\"0.6100162\",\"time\":\"20230411183413\"}";
        //0.128552	1	1	2023-04-11 18:32:35
        String str8 = "{\"orderId\":\"taw-11442290129270317\",\"ft100204\":\"v2002a\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"fd_1310\":\"16\",\"ft100208\":\"android\",\"fd_1710\":\"16\",\"ft100207\":\"2020\",\"ft100206\":\"4\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.8515154\",\"ft100205\":\"vivo\",\"ft500103\":\"16_3\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_16_1,30_2_16_1,180_1_16_1,180_2_16_1\",\"fd_1807_01\":\"4\",\"ft500101\":\"86879_3\",\"ft300101\":\"93332\",\"fd_1810_01\":\"1\",\"fd_1709\":\"16\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"fd_1208_01\":\"2\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"fd_1709_01\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"4\",\"fd_1306\":\"6\",\"ft300901\":\"6\",\"ft300109\":\"com.dz.hmjc\",\"fd_1305\":\"24\",\"ft300902\":\"51\",\"fd_1308\":\"4\",\"ft300903\":\"5117\",\"fd_1307\":\"6\",\"ft300104\":\"27\",\"fd_1707\":\"4\",\"ft300105\":\"268\",\"fd_1708\":\"2\",\"fd_1309\":\"16\",\"ft300106\":\"985\",\"fd_1705\":\"7\",\"ft300107\":\"671\",\"fd_1706\":\"4\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[3]\",\"ft301002\":\"2\",\"fd_1809_01\":\"1\",\"fd_1209_01\":\"1\",\"ft301001\":\"18\",\"ft200103\":\"07.07.0017\",\"ft200104\":\"16\",\"ft200106\":\"152026\",\"ft200107\":\"05.03.0001,05.02.0001,05.02.0023,05.02.0008\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"fd_1210\":\"16\",\"fd_1308_01\":\"4\",\"fd_1308_02\":\"4\",\"fd_1214\":\"131047,131040,135192\",\"ft200101\":\"86879\",\"ft200102\":\"46016\",\"fd_1602_04\":\"0.0405353\",\"fd_1602_03\":\"0.0798899\",\"ft300201\":\"443894\",\"ft300202\":\"8\",\"fd_1707_01\":\"4\",\"advertId\":\"86879\",\"abst\":\"[3]\",\"fd_1506_08\":\"0.0346128\",\"fd_1506_07\":\"0.1296843\",\"fd_1205\":\"9\",\"fd_1207\":\"4\",\"fd_1710_01\":\"1\",\"fd_1206\":\"4\",\"fd_1209\":\"16\",\"fd_1208\":\"2\",\"fd_1305_01\":\"8\",\"fd_1207_01\":\"4\",\"fd_1708_01\":\"2\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.7973383\",\"linkageSubtype\":\"0-9,0-6,0-8,3-6,3-8,3-9\",\"ft300301\":\"33781\",\"fd_1705_01\":\"6\",\"fd_1210_01\":\"1\",\"consumerId\":\"36068876605\",\"fd_1307_01\":\"6\",\"fd_1501\":\"80238\",\"fd_1502\":\"80238\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"fd_1503\":\"86992\",\"fd_1504\":\"86992\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"16\",\"ft300304\":\"33781\",\"fd_1808_01\":\"2\",\"fd_1508\":\"16\",\"ft300305\":\"1\",\"ft200301\":\"0\",\"fd_1310_01\":\"1\",\"fd_1310_02\":\"1\",\"fd_1810\":\"16\",\"fd_1205_01\":\"6\",\"ft500203\":\"16_null\",\"ft500201\":\"86879_null\",\"f8807\":\"1\",\"fd_1805_01\":\"6\",\"ft110014\":\"1\",\"fd_1808\":\"2\",\"fd_1809\":\"16\",\"fd_1502_04\":\"0.0703416\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"1\",\"fd_1002\":\"010202\",\"fd_1005\":\"135192,17,131047,18,7,131040,10\",\"fd_1007\":\"100802,100102,100202,101502\",\"fd_1502_03\":\"2.185E-4\",\"fd_1006\":\"1008,1015,1002,1001\",\"fd_1601_02\":\"0.5165907\",\"time\":\"20230411183235\",\"fd_1806\":\"4\",\"fd_1807\":\"4\",\"fd_1805\":\"9\"}";
        //0.483627	1	1	2023-04-11 18:31:02
        String str9 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-11442290168770454\",\"fd_1108_01\":\"1\",\"ft100204\":\"hebe-bd00\",\"fd_1117_01\":\"1\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"0\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"5\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7598539\",\"ft100205\":\"Hi nova\",\"ft500103\":\"19_0\",\"ft100209\":\"DYN\",\"ft500101\":\"84395_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"87715\",\"ft110911\":\"1\",\"ft110910\":\"1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"2\",\"ft110909\":\"-1\",\"ft300904\":\"2\",\"ft300901\":\"3\",\"ft300109\":\"com.shuqu.banyan\",\"ft300902\":\"37\",\"ft300903\":\"3706\",\"ft300104\":\"35\",\"ft300105\":\"356\",\"ft300106\":\"981\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.16.0068\",\"ft200104\":\"19\",\"ft110901\":\"33714\",\"ft200106\":\"151564\",\"ft110903\":\"07.19.0043\",\"ft200107\":\"05.02.0020\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"84395\",\"ft200102\":\"44876\",\"fd_1602_04\":\"5.97E-5\",\"fd_1602_03\":\"0.3530676\",\"ft300201\":\"409578\",\"ft300202\":\"11\",\"fd_1107_01\":\"1\",\"advertId\":\"84395\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.782E-4\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.3528329\",\"chargeType\":\"2\",\"fd_1120\":\"33714\",\"fd_1111\":\"20\",\"fd_1110\":\"1681208968\",\"fd_1113\":\"33714\",\"fd_1112\":\"1681208971\",\"fd_1115\":\"750543844110282752\",\"fd_1505_06\":\"0.7112957\",\"fd_1114\":\"750543844110282752\",\"fd_1117\":\"20\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-8,0-6,2-,3-8,3-6,5-6,5-8,8-\",\"ft300301\":\"33714\",\"consumerId\":\"36123378118\",\"fd_1501\":\"85249\",\"fd_1502\":\"85249\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"20\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"20\",\"fd_1107\":\"1\",\"fd_1503\":\"84395\",\"fd_1504\":\"86915\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"19\",\"ft300304\":\"33714\",\"fd_1508\":\"1\",\"ft300305\":\"12\",\"fd_1106_02\":\"1\",\"ft200301\":\"0\",\"ft500203\":\"19_null\",\"ft500201\":\"84395_null\",\"f8807\":\"1\",\"ft110014\":\"2\",\"fd_1502_04\":\"3.054E-4\",\"fd_1502_03\":\"0.4597924\",\"fd_1601_02\":\"0.7116811\",\"time\":\"20230411183102\"}";
//        pre_cvr	coupon_effect_click_pv	is_target_convert	time
//        0.013997	1	\N	2023-04-11 18:35:23
        String str10 = "{\"orderId\":\"taw-11442290343150908\",\"fd_1108_01\":\"0\",\"ft100204\":\"pot-al00a\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"3\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.2437592\",\"ft100205\":\"huawei\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"87193_3\",\"fd_1105_01\":\"1\",\"ft300101\":\"90618\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"1\",\"ft300901\":\"3\",\"ft300902\":\"31\",\"ft300903\":\"31\",\"ft300104\":\"33\",\"ft300105\":\"347\",\"ft300106\":\"985\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.09.0325\",\"ft200104\":\"15\",\"ft200106\":\"152682\",\"ft200107\":\"05.02.0014\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"87193\",\"ft200102\":\"46034\",\"ft300201\":\"424469\",\"ft300202\":\"8\",\"fd_1107_01\":\"0\",\"advertId\":\"87193\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0097035\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1970214\",\"chargeType\":\"2\",\"fd_1120\":\"33485\",\"fd_1110\":\"1681209313\",\"fd_1505_06\":\"0.3614506\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"33485\",\"consumerId\":\"36123414412\",\"fd_1501\":\"85561\",\"fd_1502\":\"85561\",\"fd_1105\":\"1\",\"fd_1505\":\"15\",\"ft300306\":\"2\",\"fd_1506\":\"15\",\"fd_1503\":\"87243\",\"fd_1504\":\"85561\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"15\",\"ft300304\":\"33485\",\"fd_1508\":\"15\",\"ft300305\":\"0\",\"ft200301\":\"0\",\"ft500203\":\"15_null\",\"ft500201\":\"87193_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"fd_1502_04\":\"0.0138889\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1002\":\"01020401\",\"fd_1502_03\":\"0.0138889\",\"time\":\"20230411183524\"}";
//        pre_cvr	coupon_effect_click_pv	is_target_convert	time
//        0.002531	1	1	2023-04-11 18:35:08
        String str11 = "{\"fd_1108_02\":\"2\",\"orderId\":\"taw-11442290658580336\",\"fd_1108_01\":\"2\",\"ft100204\":\"wkg-an00\",\"fd_1117_01\":\"1\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"1\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100206\":\"2\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5386302\",\"ft100205\":\"huawei\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"ft500101\":\"87264_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"93230\",\"ft110911\":\"1\",\"ft110910\":\"1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"2\",\"ft110909\":\"-1\",\"ft300904\":\"4\",\"ft300901\":\"1\",\"ft300902\":\"14\",\"ft300903\":\"1408\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"986\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft110901\":\"33781\",\"ft200106\":\"152867\",\"ft110903\":\"07.10.0146\",\"ft200107\":\"05.02.0020\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"87264\",\"ft200102\":\"45987\",\"ft300201\":\"444877\",\"ft300202\":\"8\",\"fd_1107_01\":\"2\",\"advertId\":\"87264\",\"abst\":\"[0]\",\"fd_1506_08\":\"0.0363228\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1003092\",\"chargeType\":\"2\",\"fd_1120\":\"33781\",\"fd_1111\":\"16\",\"fd_1110\":\"1681209155\",\"fd_1113\":\"33781\",\"fd_1112\":\"1681209244\",\"fd_1115\":\"750544987095871488\",\"fd_1505_06\":\"0.8011462\",\"fd_1114\":\"750544987095871488\",\"fd_1117\":\"16\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-9,0-6,0-8,3-6,3-8,3-9\",\"ft300301\":\"33781\",\"consumerId\":\"36123391312\",\"fd_1501\":\"84746\",\"fd_1502\":\"84746\",\"fd_1106\":\"3\",\"fd_1105\":\"1\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1108\":\"2\",\"fd_1506\":\"16\",\"fd_1107\":\"2\",\"fd_1503\":\"86992\",\"fd_1504\":\"86992\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"16\",\"ft300304\":\"33781\",\"fd_1508\":\"16\",\"ft300305\":\"1\",\"fd_1106_02\":\"3\",\"ft200301\":\"0\",\"ft500203\":\"16_null\",\"ft500201\":\"87264_null\",\"f8807\":\"1\",\"ft110014\":\"3\",\"fd_1502_04\":\"3.468E-4\",\"fd_1502_03\":\"0.0011557\",\"time\":\"20230411183508\"}";
//        pre_cvr	coupon_effect_click_pv	is_target_convert	time
//        0.031594	1	\N	2023-04-11 18:35:53
        String str12 = "{\"orderId\":\"taw-11442290529040157\",\"chargeType\":\"2\",\"ft100204\":\"jsn-al00\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.8102532\",\"ft100207\":\"2018\",\"ft100206\":\"3\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.8548551\",\"ft100205\":\"honor\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"ft500101\":\"84746_0\",\"linkageSubtype\":\"0-9,0-6,0-8,3-6,3-8,3-9\",\"ft300101\":\"84436\",\"ft300301\":\"33885\",\"ft110911\":\"0\",\"consumerId\":\"36123415709\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"fd_1501\":\"86209\",\"ft300904\":\"1\",\"fd_1502\":\"86209\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"ft300901\":\"3\",\"fd_1503\":\"86157\",\"ft300902\":\"31\",\"fd_1504\":\"86157\",\"ft300903\":\"31\",\"ft300302\":\"1\",\"ft300104\":\"27\",\"ft300303\":\"1\",\"ft300105\":\"268\",\"fd_1507\":\"16\",\"ft300304\":\"33885\",\"ft300106\":\"987\",\"fd_1508\":\"16\",\"ft300305\":\"1\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"ft6002031\":\"2459670321\",\"ft301001\":\"18\",\"ft200103\":\"07.10.0146\",\"ft200301\":\"0\",\"ft200104\":\"16\",\"ft200106\":\"149822\",\"ft200107\":\"05.03.0013,05.02.0001,05.02.0019\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"84746\",\"ft200102\":\"41435\",\"ft500203\":\"16_null\",\"ft500201\":\"84746_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft600201\":\"16368657\",\"ft300201\":\"439625\",\"ft6002041\":\"29698738238\",\"ft300202\":\"8\",\"advertId\":\"84746\",\"abst\":\"[0]\",\"fd_1502_04\":\"1.973E-4\",\"fd_1506_08\":\"0.0115001\",\"fd_1506_07\":\"0.0443854\",\"fd_1502_03\":\"0.0254438\",\"time\":\"20230411183554\"}";
//        pre_cvr	alg_type	coupon_effect_click_pv	is_target_convert	time
//        0.072531	416	1	\N	2023-04-11 18:35:02
        String str13 = "{\"orderId\":\"taw-11442290430100022\",\"chargeType\":\"2\",\"ft100204\":\"m2101k9c\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7012611\",\"ft100207\":\"2021\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7416431\",\"ft100205\":\"xiaomi\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"65521_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"86650\",\"ft300301\":\"34221\",\"ft600303\":\"0\",\"ft110911\":\"0\",\"ft600302\":\"420592\",\"consumerId\":\"36123408406\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"fd_1501\":\"85629\",\"ft300904\":\"1\",\"fd_1502\":\"85629\",\"fd_1505\":\"1\",\"ft300306\":\"2\",\"fd_1506\":\"1\",\"ft300901\":\"3\",\"fd_1503\":\"85629\",\"ft300902\":\"32\",\"fd_1504\":\"87247\",\"ft600305\":\"4594\",\"ft300903\":\"3201\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"352\",\"fd_1507\":\"1\",\"ft300304\":\"34221\",\"ft300106\":\"979\",\"fd_1508\":\"15\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200106\":\"139426\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"65521\",\"ft200102\":\"29932\",\"ft500203\":\"9_null\",\"ft500201\":\"65521_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"420592\",\"ft300202\":\"12\",\"advertId\":\"65521\",\"abst\":\"[0]\",\"fd_1502_04\":\"2.26E-5\",\"fd_1506_08\":\"5.5E-6\",\"fd_1506_07\":\"0.0693929\",\"fd_1502_03\":\"0.0778845\",\"time\":\"20230411183502\"}";
//        pre_cvr	alg_type	coupon_effect_click_pv	is_target_convert	time
//        0.071837	416	1	1	2023-04-11 18:35:16
        String str14 = "{\"orderId\":\"taw-11442290524500411\",\"chargeType\":\"2\",\"ft100204\":\"koz-al40\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7012611\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7416431\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"65521_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"86650\",\"ft300301\":\"34221\",\"ft600303\":\"0\",\"ft110911\":\"0\",\"ft600302\":\"420592\",\"consumerId\":\"36123408795\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"fd_1501\":\"85629\",\"ft300904\":\"2\",\"fd_1502\":\"85629\",\"fd_1505\":\"1\",\"ft300306\":\"2\",\"fd_1506\":\"1\",\"ft300901\":\"5\",\"fd_1503\":\"85629\",\"ft300902\":\"44\",\"fd_1504\":\"87247\",\"ft600305\":\"4594\",\"ft300903\":\"4413\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"352\",\"fd_1507\":\"1\",\"ft300304\":\"34221\",\"ft300106\":\"979\",\"fd_1508\":\"15\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200106\":\"139426\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"65521\",\"ft200102\":\"29932\",\"ft500203\":\"9_null\",\"ft500201\":\"65521_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"420592\",\"ft300202\":\"12\",\"advertId\":\"65521\",\"abst\":\"[0]\",\"fd_1502_04\":\"2.26E-5\",\"fd_1506_08\":\"5.5E-6\",\"fd_1506_07\":\"0.0693929\",\"fd_1502_03\":\"0.0778845\",\"time\":\"20230411183517\"}";
        //featureMapDoMap.put(1L, getFeatureMapDo(str1) );// 0.27
        //featureMapDoMap.put(2L, getFeatureMapDo(str2) );// 0.066
//        featureMapDoMap.put(3L, getFeatureMapDo(str3));//0.017
        //featureMapDoMap.put(5L, getFeatureMapDo(str5) );//0.016467
//        featureMapDoMap.put(4L, getFeatureMapDo(str4) );//0.041171
//
//        featureMapDoMap.put(5L, getFeatureMapDo(str5) );//0.016467
//        featureMapDoMap.put(6L, getFeatureMapDo(str6));
//        featureMapDoMap.put(7L, getFeatureMapDo(str7));
//        featureMapDoMap.put(8L, getFeatureMapDo(str8));
//        featureMapDoMap.put(9L, getFeatureMapDo(str9));
//        featureMapDoMap.put(10L, getFeatureMapDo(str10));
//        featureMapDoMap.put(11L, getFeatureMapDo(str11));
//        featureMapDoMap.put(12L, getFeatureMapDo(str12));
//        featureMapDoMap.put(13L, getFeatureMapDo(str13));
//        featureMapDoMap.put(14L, getFeatureMapDo(str14));

        // Check原始样本进行编码后的样本，进行筛选样本
        String str15 = "{\"orderId\":\"taw-11526989472100154\",\"fd_1108_01\":\"0\",\"ft100204\":\"rmx3122\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"3\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.9320423\",\"ft100205\":\"realme\",\"ft500103\":\"16_3\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1,180_1_15_2\",\"fd_1807_01\":\"1\",\"ft500101\":\"88327_3\",\"fd_1105_01\":\"1\",\"ft300101\":\"92751\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"1\",\"ft300904\":\"3\",\"fd_1302\":\"0\",\"fd_1301\":\"2\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"23\",\"ft300901\":\"3\",\"fd_1305\":\"41\",\"ft300902\":\"34\",\"fd_1308\":\"19\",\"ft300903\":\"3407\",\"fd_1307\":\"21\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"fd_1309\":\"10,15\",\"ft300106\":\"985\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[3]\",\"ft301002\":\"2\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"1\",\"ft200103\":\"07.07.0066\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0001\",\"ft200106\":\"155967\",\"ft200107\":\"05.03.0001,05.02.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"7\",\"fd_1308_02\":\"10\",\"ft200101\":\"88327\",\"ft200102\":\"46016\",\"ft300201\":\"447055\",\"ft300202\":\"3\",\"fd_1107_01\":\"0\",\"advertId\":\"88327\",\"abst\":\"[3]\",\"fd_1506_08\":\"0.0566103\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.117101\",\"fd_1205\":\"3\",\"fd_1207\":\"1\",\"fd_1206\":\"1\",\"fd_1208\":\"1\",\"fd_1305_01\":\"8\",\"fd_1207_01\":\"1\",\"chargeType\":\"2\",\"fd_1120\":\"32031\",\"fd_1110\":\"1689010649\",\"fd_1505_06\":\"0.9212351\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,0-8,0-23,3-6,3-8,3-23\",\"ft300301\":\"32031\",\"fd_1210_01\":\"0\",\"consumerId\":\"36398758042\",\"fd_1307_01\":\"7\",\"fd_1501\":\"86157\",\"fd_1502\":\"86157\",\"fd_1105\":\"1\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"fd_1503\":\"86157\",\"fd_1504\":\"88327\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"32031\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"1\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"3\",\"ft500203\":\"16_null\",\"ft500201\":\"88327_null\",\"f8807\":\"1\",\"fd_1805_01\":\"3\",\"ft110014\":\"1\",\"fd_1808\":\"1\",\"fd_1502_04\":\"0.391917\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"6\",\"fd_1002\":\"01020401\",\"fd_1005\":\"1,34,14,5,17,18,7,10,21\",\"fd_1007\":\"100604,100802,101002,100102,100202,100301,101502\",\"fd_1502_03\":\"0.0011124\",\"fd_1006\":\"1008,1006,1015,1003,1002,1001,1010\",\"fd_1008\":\"61002000,80282000,46032100,80062100,34002000,24082000,61032500,46032000,24025000,24002000,61032000,80113200,80012200,70002000,39002000,36082000,80052300,10001004,80132202,26002000,36082300,36082500,36002000,46002000,39062000,10001132,10000000,80122300,80302300,24022000\",\"time\":\"20230711013734\",\"fd_1806\":\"1\",\"fd_1807\":\"1\",\"fd_1805\":\"3\"}";
//        featureMapDoMap.put(15L, getFeatureMapDo(str15));



        // advert =88658 bad case check
        String str16 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-11554548374970439\",\"fd_1108_01\":\"1\",\"backTimeConsume\":\"{\\\"0\\\":1712.19,\\\"3\\\":40.16,\\\"19\\\":4450.55,\\\"10\\\":194973.79}\",\"ft100204\":\"oppo a79\",\"fd_1117_01\":\"1\",\"ft100203\":\"ANDROID7\",\"fd_1011_01\":\"1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.6513555\",\"ft500103\":\"10_3\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_10_1,30_1_3_2,180_1_10_1,180_1_3_2\",\"fd_1807_01\":\"11\",\"ft500101\":\"88658_3\",\"fd_1105_01\":\"1\",\"ft300101\":\"92966\",\"fd_1810_01\":\"0\",\"fd_1709\":\"10\",\"fd_1208_01\":\"10\",\"fd_1709_01\":\"9\",\"ft300904\":\"4\",\"fd_1306\":\"687\",\"ft300901\":\"7\",\"fd_1305\":\"1303\",\"ft300902\":\"65\",\"fd_1308\":\"477\",\"ft300903\":\"6505\",\"fd_1307\":\"518\",\"ft300104\":\"33\",\"fd_1707\":\"59\",\"ft300105\":\"347\",\"fd_1708\":\"56\",\"fd_1309\":\"10,3\",\"ft300106\":\"987\",\"fd_1705\":\"75\",\"ft300107\":\"696\",\"fd_1706\":\"63\",\"ft301003\":\"19\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"3\",\"fd_1809_01\":\"10\",\"fd_1209_01\":\"10\",\"ft301001\":\"7\",\"ft200103\":\"07.10.0375\",\"ft200104\":\"10\",\"ft200105\":\"02.22.0001\",\"ft200106\":\"156962\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft200109\":\"2\",\"fd_1308_01\":\"12\",\"fd_1308_02\":\"13\",\"fd_1214\":\"5387\",\"ft200101\":\"88658\",\"ft200102\":\"46471\",\"ft300201\":\"450917\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"fd_1707_01\":\"9\",\"advertId\":\"88658\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0091397\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"1.1768043\",\"fd_1205\":\"230\",\"fd_1207\":\"114\",\"fd_1710_01\":\"0\",\"fd_1206\":\"133\",\"fd_1209\":\"10,3\",\"fd_1208\":\"100\",\"fd_1305_01\":\"12\",\"fd_1207_01\":\"10\",\"fd_1708_01\":\"9\",\"chargeType\":\"2\",\"fd_1120\":\"33687\",\"fd_1111\":\"10\",\"fd_1110\":\"1689723789\",\"fd_1113\":\"33687\",\"fd_1112\":\"1689723800\",\"fd_1115\":\"786257600954384384\",\"fd_1505_06\":\"0.6709232\",\"fd_1114\":\"786257600954384384\",\"fd_1117\":\"10\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-6,3-6\",\"ft300301\":\"33687\",\"fd_1705_01\":\"9\",\"ft6002021\":\"212572\",\"fd_1210_01\":\"0\",\"consumerId\":\"35742273975\",\"fd_1307_01\":\"12\",\"fd_1501\":\"88758\",\"fd_1502\":\"88758\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"10\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"10\",\"fd_1107\":\"1\",\"fd_1503\":\"88758\",\"fd_1504\":\"88758\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"33687\",\"fd_1808_01\":\"11\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"fd_1106_02\":\"1\",\"ft6002031\":\"1000245089\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"11\",\"ft500203\":\"10_null\",\"ft500201\":\"88658_null\",\"f8807\":\"1\",\"fd_1805_01\":\"12\",\"ft110014\":\"1\",\"ft6002041\":\"206594926\",\"fd_1808\":\"181\",\"fd_1809\":\"10,3\",\"fd_1502_04\":\"0.010929\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"10\",\"fd_1002\":\"01020302\",\"fd_1005\":\"5387\",\"fd_1502_03\":\"0.8349727\",\"time\":\"20230719075017\",\"fd_1806\":\"236\",\"fd_1807\":\"201\",\"fd_1805\":\"380\"}";
//        featureMapDoMap.put(16L, getFeatureMapDo(str16));


        // 模型版本 v1016/202310300936
        // 验证417实验组，加入多值特征后，线上预估偏高的原因，样本为2023-10-30 09:40:46产生的一条样本，线上预估值0.119741
        // 本地验证 0.124595，模型版本202310300936
        String str17 = "{\"orderId\":\"taw-12248426181580860\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"34235\",\"backTimeConsume\":\"{\\\"0\\\":143.31,\\\"11\\\":225460.25,\\\"15\\\":23244.54,\\\"18\\\":1922.35,\\\"19\\\":143.27,\\\"9\\\":370701.48}\",\"ft100204\":\"iphone\",\"fd_1117_01\":\"0\",\"ft100203\":\"IOS16\",\"fd_1110\":\"1698630020\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"ios\",\"fd_1505_06\":\"0.5333645\",\"ft100207\":\"-1\",\"ft100206\":\"6\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5564797\",\"ft100205\":\"iphone\",\"fd_1116\":\"0\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"89588_0\",\"fd_1105_01\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"94078\",\"ft300301\":\"34235\",\"consumerId\":\"37523170140\",\"fd_1501\":\"88903\",\"ft300904\":\"2\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"3\",\"fd_1503\":\"88903\",\"ft300902\":\"35\",\"fd_1504\":\"87271\",\"ft300903\":\"3505\",\"ft300302\":\"1\",\"ft300104\":\"35\",\"ft300303\":\"1\",\"ft300105\":\"358\",\"fd_1507\":\"9\",\"ft300304\":\"34235\",\"ft300106\":\"981\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"159858\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"89588\",\"ft200102\":\"44445\",\"ft500203\":\"9_null\",\"ft500201\":\"89588_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"447720\",\"ft300202\":\"12\",\"fd_1107_01\":\"0\",\"advertId\":\"89588\",\"abst\":\"[0]\",\"fd_1502_04\":\"4.322E-4\",\"fd_1506_08\":\"4.96E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1063338\",\"fd_1502_03\":\"0.1407376\",\"time\":\"20231030094046\"}";
//        featureMapDoMap.put(17L, getFeatureMapDo(str17));
        // 线上预估0.03927，样本时间为 2023-10-30 09:40:10
        String str18 = "{\"orderId\":\"taw-12248432159770336\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":143.1,\\\"15\\\":68819.0,\\\"18\\\":739.25,\\\"19\\\":48.99}\",\"ft100204\":\"pgt-an10\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5233088\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"89121_0\",\"fd_1105_01\":\"4\",\"ft300101\":\"94078\",\"ft300904\":\"1\",\"ft300901\":\"6\",\"ft300902\":\"50\",\"ft300903\":\"50\",\"ft300104\":\"35\",\"ft300105\":\"358\",\"ft300106\":\"981\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"158490\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"89121\",\"ft200102\":\"47301\",\"ft300201\":\"447721\",\"ft300202\":\"12\",\"fd_1107_01\":\"1\",\"advertId\":\"89121\",\"abst\":\"[0]\",\"fd_1506_08\":\"3.66E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0907673\",\"chargeType\":\"2\",\"fd_1120\":\"34235\",\"fd_1111\":\"9\",\"fd_1110\":\"1698629911\",\"fd_1113\":\"34235\",\"fd_1112\":\"1698629941\",\"fd_1505_06\":\"0.529432\",\"fd_1114\":\"823612685972234240\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"34235\",\"consumerId\":\"37523166544\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"2\",\"fd_1105\":\"4\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"fd_1503\":\"88903\",\"fd_1504\":\"87271\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"9\",\"ft300304\":\"34235\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"fd_1106_02\":\"2\",\"ft300113\":\"1\",\"ft200301\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"89121_null\",\"f8807\":\"1\",\"ft110014\":\"3\",\"fd_1502_04\":\"3.506E-4\",\"fd_1502_03\":\"0.096974\",\"time\":\"20231030094010\"}";
//        featureMapDoMap.put(18L, getFeatureMapDo(str18));

        // 线上预估0.026582，样本时间为2023-10-30 09:40:39
        String str19 = "{\"orderId\":\"taw-12248432162420971\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":175.39,\\\"15\\\":2080.0,\\\"19\\\":91.14}\",\"ft100204\":\"brq-an00\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"2\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.6145073\",\"ft100207\":\"2020\",\"ft100206\":\"5\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5580559\",\"ft100205\":\"huawei\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"ft500101\":\"89960_0\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300101\":\"84799\",\"ft300301\":\"34348\",\"consumerId\":\"37523174347\",\"fd_1501\":\"88903\",\"ft300904\":\"4\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"1\",\"fd_1503\":\"88903\",\"ft300902\":\"15\",\"fd_1504\":\"87271\",\"ft300903\":\"1525\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"350\",\"fd_1507\":\"9\",\"ft300304\":\"34348\",\"ft300106\":\"977\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.07.0056\",\"ft200301\":\"0\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0004\",\"ft200106\":\"161100\",\"ft200107\":\"05.02.0022,05.03.0002\",\"ft200109\":\"0\",\"ft200101\":\"89960\",\"ft200102\":\"46889\",\"ft500203\":\"16_null\",\"ft500201\":\"89960_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"423588\",\"ft300202\":\"1\",\"advertId\":\"89960\",\"abst\":\"[0]\",\"fd_1502_04\":\"0.0044777\",\"fd_1506_08\":\"0.0168852\",\"fd_1506_07\":\"0.0285614\",\"fd_1502_03\":\"0.0179105\",\"time\":\"20231030094039\"}";
//        featureMapDoMap.put(19L, getFeatureMapDo(str19));

        // 线上预估0.007295，样本时间为 2023-10-30 09:41:51
        String str20 = "{\"orderId\":\"taw-12248429122800242\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":52.2,\\\"19\\\":70.24}\",\"ft100204\":\"yal-al50\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6453901\",\"ft100205\":\"honor\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"ft500101\":\"90027_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"94981\",\"ft300904\":\"1\",\"ft300901\":\"4\",\"ft300902\":\"41\",\"ft300903\":\"4101\",\"ft300104\":\"33\",\"ft300105\":\"346\",\"ft300106\":\"987\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"161274\",\"ft200107\":\"05.03.0001,05.02.0018,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"90027\",\"ft200102\":\"41435\",\"ft300313\":\"939\",\"ft300201\":\"452305\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"advertId\":\"90027\",\"abst\":\"[0]\",\"fd_1506_08\":\"0.0054603\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0147606\",\"chargeType\":\"2\",\"fd_1120\":\"33613\",\"fd_1111\":\"16\",\"fd_1110\":\"1698630098\",\"fd_1113\":\"33613\",\"fd_1112\":\"1698630103\",\"fd_1505_06\":\"0.7611544\",\"fd_1114\":\"823613356939223040\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"33613\",\"consumerId\":\"37523172594\",\"fd_1501\":\"89552\",\"fd_1502\":\"89552\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"fd_1107\":\"1\",\"fd_1503\":\"84506\",\"fd_1504\":\"86991\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"16\",\"ft300304\":\"33613\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"1\",\"ft300113\":\"2\",\"ft200301\":\"0\",\"ft500203\":\"16_null\",\"ft500201\":\"90027_null\",\"f8807\":\"1\",\"ft110014\":\"2\",\"fd_1502_04\":\"0.009288\",\"fd_1502_03\":\"0.012384\",\"time\":\"20231030094151\"}";
//        featureMapDoMap.put(20L, getFeatureMapDo(str20));
        // 本地验证 ，{17=0.125696, 18=0.046367, 19=0.023646, 20=0.009097}

        // 线上预估0.062445， 样本时间为 2023-10-30 09:40:33
        String str201 = "{\"orderId\":\"taw-12248444884440055\",\"backTimeConsume\":\"{\\\"0\\\":73.65,\\\"3\\\":73.25,\\\"19\\\":46.58}\",\"ft100204\":\"ann-an00\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"fd_1310\":\"16\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.5167198\",\"ft100205\":\"honor\",\"ft500103\":\"16_3\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1,180_1_16_2,180_1_9_3,180_2_16_1\",\"fd_1807_01\":\"5\",\"ft500101\":\"86991_3\",\"ft300101\":\"90800\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"3\",\"fd_1709_01\":\"0\",\"ft300904\":\"3\",\"fd_1302\":\"0\",\"fd_1301\":\"7\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"84\",\"ft300901\":\"3\",\"fd_1305\":\"92\",\"ft300902\":\"32\",\"fd_1308\":\"46\",\"ft300903\":\"3208\",\"fd_1307\":\"71\",\"ft300104\":\"33\",\"fd_1707\":\"5\",\"ft300105\":\"346\",\"fd_1708\":\"3\",\"fd_1309\":\"10,16,9\",\"ft300106\":\"986\",\"fd_1705\":\"3\",\"ft300107\":\"671\",\"fd_1706\":\"5\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"1\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"152173\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft200109\":\"0\",\"fd_1308_01\":\"9\",\"fd_1308_02\":\"12\",\"ft200101\":\"86991\",\"ft200102\":\"45859\",\"ft600201\":\"41986354\",\"ft300201\":\"425625\",\"ft300202\":\"3\",\"fd_1707_01\":\"5\",\"advertId\":\"86991\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0143457\",\"fd_1506_07\":\"0.0300451\",\"fd_1205\":\"3\",\"fd_1207\":\"5\",\"fd_1710_01\":\"0\",\"fd_1206\":\"5\",\"fd_1208\":\"3\",\"fd_1305_01\":\"10\",\"fd_1207_01\":\"5\",\"fd_1708_01\":\"3\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.5628742\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"34919\",\"fd_1705_01\":\"3\",\"fd_1210_01\":\"0\",\"consumerId\":\"37180886071\",\"fd_1307_01\":\"9\",\"fd_1501\":\"83175\",\"fd_1502\":\"83175\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89986\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"34919\",\"fd_1808_01\":\"3\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft6002031\":\"8425132590\",\"ft200301\":\"0\",\"fd_1310_01\":\"2\",\"fd_1310_02\":\"2\",\"fd_1205_01\":\"3\",\"ft500203\":\"16_null\",\"ft500201\":\"86991_null\",\"f8807\":\"1\",\"fd_1805_01\":\"3\",\"ft110014\":\"1\",\"ft6002041\":\"615946152144\",\"fd_1808\":\"3\",\"fd_1502_04\":\"0.0276612\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"7\",\"fd_1002\":\"01020402\",\"fd_1005\":\"1,3,16,65236,8,63942,10\",\"fd_1007\":\"100802,101002,101005,101502,100502\",\"fd_1502_03\":\"0.0268982\",\"fd_1006\":\"1008,1005,1015,1010\",\"fd_1008\":\"198,201,571\",\"time\":\"20231030094033\",\"fd_1806\":\"5\",\"fd_1807\":\"5\",\"fd_1805\":\"3\"}";
//        featureMapDoMap.put(201L, getFeatureMapDo(str201));

        // 线上预估0.254667, 样本时间为 2023-10-30 09:41:27
        String str202 = "{\"orderId\":\"taw-12248444889280038\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":143.1,\\\"15\\\":68819.0,\\\"18\\\":739.25,\\\"19\\\":48.99}\",\"ft100204\":\"ntn-an20\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7099692\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_9_1,180_1_9_1\",\"fd_1807_01\":\"1\",\"ft500101\":\"89121_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"90799\",\"fd_1810_01\":\"0\",\"fd_1709\":\"9\",\"fd_1208_01\":\"1\",\"fd_1709_01\":\"1\",\"ft300904\":\"3\",\"fd_1306\":\"1\",\"ft300901\":\"4\",\"fd_1305\":\"1\",\"ft300902\":\"42\",\"fd_1308\":\"1\",\"ft300903\":\"4210\",\"fd_1307\":\"1\",\"ft300104\":\"33\",\"fd_1707\":\"1\",\"ft300105\":\"346\",\"fd_1708\":\"1\",\"fd_1309\":\"9\",\"ft300106\":\"986\",\"fd_1705\":\"1\",\"ft300107\":\"671\",\"fd_1706\":\"1\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"1\",\"fd_1209_01\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"158490\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"1\",\"fd_1308_02\":\"1\",\"ft200101\":\"89121\",\"ft200102\":\"47301\",\"ft600201\":\"41986346\",\"ft300201\":\"427220\",\"ft300202\":\"3\",\"fd_1107_01\":\"0\",\"fd_1707_01\":\"1\",\"advertId\":\"89121\",\"abst\":\"[0]\",\"fd_1506_08\":\"3.33E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0785993\",\"fd_1205\":\"1\",\"fd_1207\":\"1\",\"fd_1710_01\":\"0\",\"fd_1206\":\"1\",\"fd_1209\":\"9\",\"fd_1208\":\"1\",\"fd_1305_01\":\"1\",\"fd_1207_01\":\"1\",\"fd_1708_01\":\"1\",\"chargeType\":\"2\",\"fd_1120\":\"34919\",\"fd_1110\":\"1698630084\",\"fd_1505_06\":\"0.7139666\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"34919\",\"fd_1705_01\":\"1\",\"fd_1210_01\":\"0\",\"consumerId\":\"37523172390\",\"fd_1307_01\":\"1\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89819\",\"fd_1504\":\"88845\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"34919\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft6002031\":\"8801766618\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"1\",\"ft500203\":\"9_null\",\"ft500201\":\"89121_null\",\"f8807\":\"1\",\"fd_1805_01\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"656804860877\",\"fd_1808\":\"1\",\"fd_1809\":\"9\",\"fd_1502_04\":\"9.178E-4\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"1\",\"fd_1002\":\"010202\",\"fd_1005\":\"1,16,17,7,8,10,21\",\"fd_1007\":\"100604,100802,101002,100102,100202,101502,100502\",\"fd_1502_03\":\"0.0617926\",\"fd_1006\":\"1008,1006,1005,1015,1002,1001,1010\",\"fd_1008\":\"385,202,378,192,927\",\"time\":\"20231030094127\",\"fd_1806\":\"1\",\"fd_1807\":\"1\",\"fd_1805\":\"1\"}";
//        featureMapDoMap.put(202L, getFeatureMapDo(str202));
//        {17=0.125696, 18=0.046367, 19=0.023646, 20=0.009097, 201=0.056087, 202=0.07048}
        //{17=0.124595, 18=0.046057, 19=0.024758, 201=0.051885, 202=0.182658}
        //{202=0.249079}



        // v1018 model
        // 验证416实验组（不加入多值特征），线上线下预估是否一致，2023-10-30 09:40:51，线上预估值0.099065
        // 本地验证模型版本：v1018/202310300935

        //线上预估0.099065，样本时间 2023-10-30 09:40:51，线上线下一致
        String str21 = "{\"orderId\":\"taw-12248429117690112\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"34348\",\"backTimeConsume\":\"{\\\"0\\\":109.92,\\\"15\\\":24134.0,\\\"18\\\":819.8,\\\"19\\\":85.54}\",\"ft100204\":\"pdkt00\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1110\":\"1698630047\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.6726164\",\"ft100207\":\"2020\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6836708\",\"ft100205\":\"oppo\",\"fd_1116\":\"0\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"83756_0\",\"fd_1105_01\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"84799\",\"ft300301\":\"34348\",\"consumerId\":\"37523174512\",\"fd_1501\":\"88903\",\"ft300904\":\"4\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"6\",\"fd_1503\":\"88903\",\"ft300902\":\"53\",\"fd_1504\":\"87271\",\"ft300903\":\"5304\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"350\",\"fd_1507\":\"9\",\"ft300304\":\"34348\",\"ft300106\":\"977\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"157736\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"83756\",\"ft200102\":\"29932\",\"ft500203\":\"9_null\",\"ft500201\":\"83756_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"423588\",\"ft300202\":\"1\",\"fd_1107_01\":\"0\",\"advertId\":\"83756\",\"abst\":\"[0]\",\"fd_1502_04\":\"2.928E-4\",\"fd_1506_08\":\"1.68E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1195466\",\"fd_1502_03\":\"0.1250854\",\"time\":\"20231030094051\"}";
//        featureMapDoMap.put(21L, getFeatureMapDo(str21));

        // 线上预估 0.046339 ，样本时间 2023-10-30 09:40:32 ，线上线下一致
        String str22 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-12248439791780236\",\"fd_1108_01\":\"1\",\"backTimeConsume\":\"{\\\"0\\\":140.82,\\\"11\\\":240187.89,\\\"15\\\":33015.76,\\\"18\\\":6587.14,\\\"19\\\":47.94,\\\"9\\\":388732.74}\",\"ft100204\":\"pbem00\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2018\",\"ft100206\":\"5\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7811209\",\"ft100205\":\"oppo\",\"ft500103\":\"9_0\",\"ft100209\":\"IDC\",\"fd_1318\":\"30_1_10_1,180_1_10_1\",\"fd_1807_01\":\"1\",\"ft500101\":\"83175_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"90446\",\"fd_1810_01\":\"0\",\"ft300904\":\"1\",\"fd_1306\":\"1\",\"ft300901\":\"5\",\"fd_1305\":\"1\",\"ft300902\":\"44\",\"fd_1308\":\"1\",\"ft300903\":\"4419\",\"fd_1307\":\"1\",\"ft300104\":\"27\",\"ft300105\":\"267\",\"fd_1309\":\"10\",\"ft300106\":\"987\",\"ft300107\":\"696\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"153601\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"1\",\"fd_1308_02\":\"1\",\"ft200101\":\"83175\",\"ft200102\":\"44445\",\"ft300201\":\"455690\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"advertId\":\"83175\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.18E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0773683\",\"fd_1305_01\":\"1\",\"chargeType\":\"2\",\"fd_1120\":\"35249\",\"fd_1111\":\"9\",\"fd_1110\":\"1698629978\",\"fd_1113\":\"35249\",\"fd_1112\":\"1698629988\",\"fd_1115\":\"823612857804472320\",\"fd_1505_06\":\"0.8031188\",\"fd_1114\":\"823612857804472320\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35249\",\"ft6002021\":\"212406\",\"consumerId\":\"37523169516\",\"fd_1307_01\":\"1\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"fd_1503\":\"89986\",\"fd_1504\":\"86991\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35249\",\"fd_1808_01\":\"1\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"fd_1106_02\":\"1\",\"ft300113\":\"4\",\"ft6002031\":\"1000221779\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"83175_null\",\"f8807\":\"1\",\"fd_1805_01\":\"1\",\"ft110014\":\"2\",\"ft6002041\":\"207519184\",\"fd_1808\":\"1\",\"fd_1809\":\"10\",\"fd_1502_04\":\"4.64E-5\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"1\",\"fd_1002\":\"01020301\",\"fd_1005\":\"1,65483,2,14,5,17,18,19,10,21\",\"fd_1007\":\"100604,100802,101002,100202,100301,101502\",\"fd_1502_03\":\"0.0729434\",\"fd_1006\":\"1008,1006,1015,1003,1002,1010\",\"fd_1008\":\"452,394\",\"time\":\"20231030094033\",\"fd_1806\":\"1\",\"fd_1807\":\"1\",\"fd_1805\":\"1\"}";
//        featureMapDoMap.put(22L, getFeatureMapDo(str22));

        // 线上预估 0.002458 , 样本时间 2023-10-30 09:41:42
        String str23 = "{\"orderId\":\"taw-12248443452430778\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":12.83,\\\"3\\\":71.45,\\\"19\\\":55.67}\",\"ft100204\":\"phj110\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.7314366\",\"ft100205\":\"oppo\",\"ft500103\":\"10_3\",\"ft100209\":\"DYN\",\"fd_1807_01\":\"6\",\"ft500101\":\"89986_3\",\"fd_1105_01\":\"2\",\"ft300101\":\"90790\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"0\",\"fd_1709_01\":\"0\",\"ft300904\":\"4\",\"fd_1306\":\"8\",\"ft300901\":\"4\",\"ft300109\":\"com.meijie.qipai.box\",\"fd_1305\":\"42\",\"ft300902\":\"41\",\"fd_1308\":\"1\",\"ft300903\":\"4102\",\"fd_1307\":\"6\",\"ft300104\":\"27\",\"fd_1707\":\"0\",\"ft300105\":\"268\",\"fd_1708\":\"0\",\"ft300106\":\"987\",\"fd_1705\":\"2\",\"ft300107\":\"671\",\"fd_1706\":\"0\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"1\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0396\",\"ft200104\":\"10\",\"ft200105\":\"02.22.0001\",\"ft200106\":\"161187\",\"ft200107\":\"05.02.0018\",\"ft200109\":\"0\",\"fd_1308_01\":\"1\",\"fd_1308_02\":\"1\",\"fd_1214\":\"162591\",\"ft200101\":\"89986\",\"ft200102\":\"47025\",\"fd_1602_04\":\"0.0104896\",\"fd_1602_03\":\"0.5244756\",\"ft600201\":\"22551270\",\"ft300201\":\"456687\",\"ft300202\":\"3\",\"fd_1107_01\":\"0\",\"fd_1707_01\":\"0\",\"advertId\":\"89986\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0046423\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.8530495\",\"fd_1205\":\"23\",\"fd_1207\":\"2\",\"fd_1710_01\":\"0\",\"fd_1206\":\"2\",\"fd_1208\":\"0\",\"fd_1305_01\":\"8\",\"fd_1207_01\":\"2\",\"fd_1708_01\":\"0\",\"chargeType\":\"2\",\"fd_1120\":\"34904,35381\",\"fd_1110\":\"1698599957\",\"fd_1505_06\":\"0.7864214\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,3-6,4-6,6-6\",\"ft300301\":\"34904\",\"fd_1705_01\":\"2\",\"ft6002021\":\"3x2rr68a6dj7nhq\",\"fd_1210_01\":\"0\",\"consumerId\":\"37523175178\",\"fd_1307_01\":\"6\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1105\":\"2\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89986\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"34904\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300113\":\"4\",\"ft6002031\":\"3167143503\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"8\",\"ft500203\":\"10_null\",\"ft500201\":\"89986_null\",\"f8807\":\"1\",\"fd_1805_01\":\"8\",\"ft110014\":\"1\",\"ft6002041\":\"36363219303\",\"fd_1808\":\"1\",\"fd_1502_04\":\"0.0054348\",\"fd_1001\":\"010101\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"0\",\"fd_1002\":\"01020301\",\"fd_1005\":\"1,34,2,16,17,19,8,162591,10,21\",\"fd_1007\":\"100604,100802,101002,100102,100202,101502,100502\",\"fd_1502_03\":\"1.4927537\",\"fd_1006\":\"1008,1006,1005,1015,1002,1001,1010\",\"fd_1008\":\"385,202,378,193\",\"fd_1601_02\":\"0.5827161\",\"time\":\"20231030094142\",\"fd_1806\":\"8\",\"fd_1807\":\"6\",\"fd_1805\":\"42\"}";
//        featureMapDoMap.put(23L, getFeatureMapDo(str23));

        // 线上预估 0.037614， 样本时间 2023-10-30 09:41:10
        String str24 = "{\"fd_1108_02\":\"2\",\"orderId\":\"taw-12248443449550551\",\"fd_1108_01\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":143.31,\\\"11\\\":225460.25,\\\"15\\\":23244.54,\\\"18\\\":1922.35,\\\"19\\\":143.27,\\\"9\\\":370701.48}\",\"ft100204\":\"cma-an40\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"0\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6531748\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"fd_1318\":\"180_1_10_1\",\"fd_1807_01\":\"2\",\"ft500101\":\"89588_0\",\"fd_1105_01\":\"3\",\"ft300101\":\"90800\",\"fd_1810_01\":\"0\",\"ft300904\":\"4\",\"fd_1306\":\"12\",\"ft300901\":\"4\",\"fd_1305\":\"13\",\"ft300902\":\"41\",\"fd_1308\":\"8\",\"ft300903\":\"4102\",\"fd_1307\":\"12\",\"ft300104\":\"33\",\"ft300105\":\"346\",\"fd_1309\":\"10\",\"ft300106\":\"986\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"0\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"159858\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"6\",\"fd_1308_02\":\"7\",\"ft200101\":\"89588\",\"ft200102\":\"44445\",\"ft600201\":\"41986363\",\"ft300201\":\"425969\",\"ft300202\":\"3\",\"fd_1107_01\":\"2\",\"advertId\":\"89588\",\"abst\":\"[0]\",\"fd_1506_08\":\"3.2E-6\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0826438\",\"fd_1305_01\":\"7\",\"chargeType\":\"2\",\"fd_1120\":\"35771,34919\",\"fd_1111\":\"16\",\"fd_1110\":\"1698629723\",\"fd_1113\":\"35771\",\"fd_1112\":\"1698629760\",\"fd_1115\":\"823611900265811968\",\"fd_1505_06\":\"0.6600061\",\"fd_1114\":\"823611900265811968\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35771\",\"consumerId\":\"37523157543\",\"fd_1307_01\":\"7\",\"fd_1501\":\"83175\",\"fd_1502\":\"83175\",\"fd_1106\":\"4\",\"fd_1105\":\"3\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"2\",\"fd_1506\":\"9\",\"fd_1107\":\"2\",\"fd_1503\":\"89819\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35771\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"0\",\"fd_1106_02\":\"4\",\"ft300113\":\"4\",\"ft6002031\":\"8493232947\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"89588_null\",\"f8807\":\"1\",\"fd_1805_01\":\"1\",\"ft110014\":\"3\",\"ft6002041\":\"623017566881\",\"fd_1808\":\"1\",\"fd_1502_04\":\"3.65E-5\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"6\",\"fd_1002\":\"010202\",\"fd_1005\":\"1,2,7,19,149797,21\",\"fd_1007\":\"100604,101002,100102,100202\",\"fd_1502_03\":\"0.1000949\",\"fd_1006\":\"1006,1002,1001,1010\",\"fd_1008\":\"385,441,202,248,337,91,910,92,192,393,790,571\",\"time\":\"20231030094110\",\"fd_1806\":\"2\",\"fd_1807\":\"2\",\"fd_1805\":\"1\"}";
//        featureMapDoMap.put(24L, getFeatureMapDo(str24));
        // 本地验证 {21=0.099065, 22=0.046339, 23=0.002771, 24=0.042951}

        // 线上预估 0.204775 ， 样本时间 2023-10-30 09:41:58
        String str25 = "{\"orderId\":\"taw-12248439799090477\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":133.95,\\\"15\\\":18799.33,\\\"18\\\":751.2,\\\"19\\\":57.08}\",\"ft100204\":\"vie-al10\",\"ft100203\":\"ANDROID8\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7889513\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.8255697\",\"ft100205\":\"huawei\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"80766_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"94776\",\"ft300301\":\"34992\",\"consumerId\":\"37523172829\",\"fd_1501\":\"87682\",\"ft300904\":\"4\",\"fd_1502\":\"87682\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"ft300901\":\"3\",\"fd_1503\":\"80766\",\"ft300902\":\"36\",\"fd_1504\":\"87682\",\"ft300903\":\"3610\",\"ft300302\":\"1\",\"ft300104\":\"40\",\"ft300303\":\"1\",\"ft300105\":\"388\",\"fd_1507\":\"9\",\"ft300304\":\"34992\",\"ft300106\":\"981\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"673\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"4\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"139428\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"80766\",\"ft200102\":\"29932\",\"ft500203\":\"9_null\",\"ft500201\":\"80766_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"447957\",\"ft300202\":\"12\",\"advertId\":\"80766\",\"abst\":\"[0]\",\"fd_1502_04\":\"9.061E-4\",\"fd_1506_08\":\"4.926E-4\",\"fd_1506_07\":\"0.1543261\",\"fd_1502_03\":\"0.1715494\",\"time\":\"20231030094158\"}";
//        featureMapDoMap.put(25L, getFeatureMapDo(str25));

        // 线上预估 0.014765，样本时间 2023-10-30 09:41:35
        String str26 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-12248444890140085\",\"fd_1108_01\":\"1\",\"backTimeConsume\":\"{\\\"0\\\":63.49,\\\"3\\\":63.72,\\\"10\\\":16983.79}\",\"ft100204\":\"pct-al10\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2018\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7312424\",\"ft100205\":\"honor\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_10_1,180_1_10_1\",\"fd_1807_01\":\"6\",\"ft500101\":\"84940_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"90800\",\"fd_1810_01\":\"0\",\"fd_1709\":\"10\",\"fd_1208_01\":\"4\",\"fd_1709_01\":\"5\",\"ft300904\":\"2\",\"fd_1302\":\"1\",\"fd_1301\":\"84\",\"fd_1304\":\"0\",\"fd_1303\":\"1\",\"fd_1306\":\"31\",\"ft300901\":\"3\",\"fd_1305\":\"38\",\"ft300902\":\"37\",\"fd_1308\":\"5\",\"ft300903\":\"3706\",\"fd_1307\":\"27\",\"ft300104\":\"33\",\"fd_1707\":\"5\",\"ft300105\":\"346\",\"fd_1708\":\"4\",\"fd_1309\":\"10\",\"ft300106\":\"986\",\"fd_1705\":\"4\",\"ft300107\":\"671\",\"fd_1706\":\"7\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"1\",\"fd_1809_01\":\"5\",\"fd_1209_01\":\"5\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"148491\",\"ft200107\":\"05.03.0012,05.02.0023,05.02.0001,05.02.0019\",\"ft200109\":\"0\",\"fd_1308_01\":\"5\",\"fd_1308_02\":\"5\",\"ft200101\":\"84940\",\"ft200102\":\"44840\",\"ft600201\":\"41986363\",\"ft300201\":\"425969\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"fd_1707_01\":\"5\",\"advertId\":\"84940\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0216025\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0374175\",\"fd_1205\":\"4\",\"fd_1207\":\"5\",\"fd_1710_01\":\"0\",\"fd_1206\":\"7\",\"fd_1209\":\"10\",\"fd_1208\":\"4\",\"fd_1305_01\":\"8\",\"fd_1207_01\":\"5\",\"fd_1708_01\":\"4\",\"chargeType\":\"2\",\"fd_1120\":\"34919\",\"fd_1111\":\"16\",\"fd_1110\":\"1698630068\",\"fd_1113\":\"34919\",\"fd_1112\":\"1698630077\",\"fd_1115\":\"823613233119166464\",\"fd_1505_06\":\"0.705182\",\"fd_1114\":\"823613233119166464\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"34919\",\"fd_1705_01\":\"4\",\"fd_1210_01\":\"0\",\"consumerId\":\"37083977813\",\"fd_1307_01\":\"8\",\"fd_1501\":\"83175\",\"fd_1502\":\"83175\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"fd_1503\":\"89819\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"34919\",\"fd_1808_01\":\"4\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"1\",\"ft300113\":\"4\",\"ft6002031\":\"8493232947\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"4\",\"ft500203\":\"16_null\",\"ft500201\":\"84940_null\",\"f8807\":\"1\",\"fd_1805_01\":\"4\",\"ft110014\":\"2\",\"ft6002041\":\"623017566881\",\"fd_1808\":\"4\",\"fd_1809\":\"10\",\"fd_1502_04\":\"0.0172985\",\"fd_1001\":\"010102\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"6\",\"fd_1002\":\"01020301\",\"fd_1005\":\"1,34,15,17,148514,10,21\",\"fd_1007\":\"100604,101002,100102,100202,101502\",\"fd_1502_03\":\"0.0172985\",\"fd_1006\":\"1006,1015,1002,1001,1010\",\"fd_1008\":\"89,193,790,571,386,474,771,397,399,202,521,731,711,92,737,528,518,606,508,718\",\"time\":\"20231030094135\",\"fd_1806\":\"9\",\"fd_1807\":\"7\",\"fd_1805\":\"4\"}";
//        featureMapDoMap.put(26L, getFeatureMapDo(str26));

        // 线上预估0.165602, 样本时间2023-10-30 09:41:26，线上线下一致
        String str27 = "{\"orderId\":\"taw-12248418284400335\",\"backTimeConsume\":\"{\\\"0\\\":143.31,\\\"11\\\":225460.25,\\\"15\\\":23244.54,\\\"18\\\":1922.35,\\\"19\\\":143.27,\\\"9\\\":370701.48}\",\"ft100204\":\"chl-an00\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6531748\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"89588_0\",\"ft300101\":\"90800\",\"ft300904\":\"1\",\"fd_1306\":\"1\",\"ft300901\":\"3\",\"fd_1305\":\"2\",\"ft300902\":\"33\",\"fd_1308\":\"0\",\"ft300903\":\"3302\",\"fd_1307\":\"0\",\"ft300104\":\"33\",\"ft300105\":\"346\",\"ft300106\":\"986\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"159858\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"0\",\"fd_1308_02\":\"0\",\"ft200101\":\"89588\",\"ft200102\":\"44445\",\"ft600201\":\"41986363\",\"ft300201\":\"425969\",\"ft300202\":\"3\",\"advertId\":\"89588\",\"abst\":\"[0]\",\"fd_1506_08\":\"3.2E-6\",\"fd_1506_07\":\"0.0826438\",\"fd_1305_01\":\"2\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.6600061\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35771\",\"consumerId\":\"36999343439\",\"fd_1307_01\":\"0\",\"fd_1501\":\"83175\",\"fd_1502\":\"83175\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89819\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35771\",\"fd_1508\":\"16\",\"ft300305\":\"0\",\"ft300113\":\"4\",\"ft6002031\":\"8493227869\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"89588_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"623017142215\",\"fd_1502_04\":\"3.65E-5\",\"fd_1001\":\"010102\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"0\",\"fd_1002\":\"01020301\",\"fd_1005\":\"1,34,2,5,17\",\"fd_1007\":\"101002,100102,100202,101502\",\"fd_1502_03\":\"0.1000949\",\"fd_1006\":\"1015,1002,1001,1010\",\"fd_1008\":\"193,393,790,571,561,386,441,397,266,399,202,444,137,446,303,535,91,738,508,927\",\"time\":\"20231030094126\"}";
//        featureMapDoMap.put(27L, getFeatureMapDo(str27));
        //{23=0.002771, 24=0.042951, 25=0.209805, 26=0.020263, 27=0.165602}

        // 线上预估 0.01817 ， 样本时间 2023-10-30 09:40:12
        String str30 = "{\"orderId\":\"taw-12248418278090672\",\"backTimeConsume\":\"{\\\"0\\\":146.94,\\\"11\\\":143086.69,\\\"13\\\":110.0,\\\"15\\\":15482.39,\\\"18\\\":1909.12,\\\"19\\\":41.78,\\\"9\\\":296680.2}\",\"ft100204\":\"sea-al00\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6204664\",\"ft100205\":\"huawei\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1\",\"fd_1807_01\":\"6\",\"ft500101\":\"88903_0\",\"ft300101\":\"90618\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"1\",\"fd_1709_01\":\"0\",\"ft300904\":\"4\",\"fd_1302\":\"0\",\"fd_1301\":\"20\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"10\",\"ft300901\":\"1\",\"ft300109\":\"com.huawei.fastapp\",\"fd_1305\":\"12\",\"ft300902\":\"14\",\"fd_1308\":\"3\",\"ft300903\":\"1404\",\"fd_1307\":\"9\",\"ft300104\":\"33\",\"fd_1707\":\"1\",\"ft300105\":\"347\",\"fd_1708\":\"0\",\"fd_1309\":\"10\",\"ft300106\":\"985\",\"fd_1705\":\"2\",\"ft300107\":\"671\",\"fd_1706\":\"1\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"3\",\"fd_1308_02\":\"3\",\"fd_1214\":\"65576,1622\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"fd_1215\":\"100205\",\"fd_1602_04\":\"3.97E-5\",\"fd_1602_03\":\"0.0238332\",\"ft300201\":\"424469\",\"ft300202\":\"8\",\"fd_1707_01\":\"1\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.47E-5\",\"fd_1506_07\":\"0.0420264\",\"fd_1205\":\"5\",\"fd_1207\":\"2\",\"fd_1710_01\":\"0\",\"fd_1206\":\"2\",\"fd_1208\":\"1\",\"fd_1305_01\":\"7\",\"fd_1207_01\":\"2\",\"fd_1708_01\":\"0\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.5430181\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35940\",\"fd_1705_01\":\"2\",\"fd_1210_01\":\"0\",\"consumerId\":\"37523167904\",\"fd_1307_01\":\"6\",\"fd_1501\":\"83175\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89986\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35940\",\"fd_1808_01\":\"2\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300111\":\"12\",\"ft300113\":\"8\",\"ft300110\":\"3\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"5\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"fd_1805_01\":\"6\",\"ft110014\":\"1\",\"fd_1808\":\"2\",\"fd_1502_04\":\"3.78E-5\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"1\",\"fd_1002\":\"01020401\",\"fd_1005\":\"1,1622,15,65576,83083,10\",\"fd_1007\":\"101002,101302,101502,100205\",\"fd_1502_03\":\"0.0404817\",\"fd_1006\":\"1015,1002,1013,1010\",\"fd_1008\":\"386\",\"fd_1601_02\":\"0.4985342\",\"time\":\"20231030094012\",\"fd_1806\":\"6\",\"fd_1807\":\"6\",\"fd_1805\":\"8\"}";
//        featureMapDoMap.put(30L, getFeatureMapDo(str30));
//
        // 线上预估 0.139153 ， 样本时间 2023-10-30 09:41:29，线上线下一致
        String str31 = "{\"orderId\":\"taw-12248426185470690\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":146.94,\\\"11\\\":143086.69,\\\"13\\\":110.0,\\\"15\\\":15482.39,\\\"18\\\":1909.12,\\\"19\\\":41.78,\\\"9\\\":296680.2}\",\"ft100204\":\"pftm20\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7765863\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.8363263\",\"ft100205\":\"oppo\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"89546\",\"ft300301\":\"35944\",\"consumerId\":\"37523175090\",\"fd_1501\":\"89588\",\"ft300904\":\"2\",\"fd_1502\":\"89588\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"3\",\"fd_1503\":\"89588\",\"ft300902\":\"34\",\"ft300903\":\"3401\",\"ft300302\":\"1\",\"ft300104\":\"39\",\"ft300303\":\"1\",\"ft300105\":\"378\",\"fd_1507\":\"9\",\"ft300304\":\"35944\",\"ft300106\":\"986\",\"ft300305\":\"2\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"2\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft300313\":\"939\",\"ft110014\":\"1\",\"ft300201\":\"456922\",\"ft300202\":\"3\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_07\":\"0.0967583\",\"fd_1502_03\":\"0.1003533\",\"time\":\"20231030094129\"}";
//        featureMapDoMap.put(31L, getFeatureMapDo(str31));

        //线上预估 0.008805，样本时间 2023-10-30 09:41:42，线上线下一致
        String str32 = "{\"fd_1108_02\":\"3\",\"orderId\":\"taw-12248444890820010\",\"fd_1108_01\":\"3\",\"backTimeConsume\":\"{\\\"0\\\":83.84,\\\"15\\\":1943.83,\\\"18\\\":347.0,\\\"19\\\":136.02}\",\"ft100204\":\"m2006c3lc\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100206\":\"6\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5360825\",\"ft100205\":\"xiaomi\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_10_1,30_1_16_2,30_1_9_3,30_1_1_4,30_1_21_5,180_1_10_1,180_1_16_2,180_1_9_3,180_1_1_4,180_1_21_5\",\"fd_1807_01\":\"11\",\"ft500101\":\"89815_0\",\"fd_1105_01\":\"4\",\"ft300101\":\"94664\",\"fd_1810_01\":\"0\",\"fd_1709\":\"10,16,9,1,21\",\"fd_1208_01\":\"11\",\"fd_1709_01\":\"8\",\"ft300904\":\"4\",\"fd_1306\":\"228\",\"ft300901\":\"6\",\"fd_1305\":\"270\",\"ft300902\":\"51\",\"fd_1308\":\"197\",\"ft300903\":\"5109\",\"fd_1307\":\"224\",\"ft300104\":\"38\",\"fd_1707\":\"216\",\"ft300105\":\"369\",\"fd_1708\":\"189\",\"fd_1309\":\"10,16,9,1,21\",\"ft300106\":\"985\",\"fd_1705\":\"262\",\"ft300107\":\"671\",\"fd_1706\":\"219\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"8\",\"fd_1209_01\":\"8\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"160674\",\"ft200107\":\"05.03.0002,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"11\",\"fd_1308_02\":\"13\",\"ft200101\":\"89815\",\"ft200102\":\"47663\",\"ft300201\":\"456965\",\"ft300202\":\"3\",\"fd_1107_01\":\"3\",\"fd_1707_01\":\"11\",\"advertId\":\"89815\",\"abst\":\"[0]\",\"fd_1506_08\":\"0.0010707\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0206996\",\"fd_1205\":\"270\",\"fd_1207\":\"224\",\"fd_1710_01\":\"0\",\"fd_1206\":\"228\",\"fd_1209\":\"10,16,9,1,21\",\"fd_1208\":\"197\",\"fd_1305_01\":\"11\",\"fd_1207_01\":\"11\",\"fd_1708_01\":\"11\",\"chargeType\":\"2\",\"fd_1120\":\"35940,35581\",\"fd_1111\":\"9\",\"fd_1110\":\"1698629571\",\"fd_1113\":\"35940\",\"fd_1112\":\"1698630064\",\"fd_1115\":\"823613174960951296\",\"fd_1505_06\":\"0.7376039\",\"fd_1114\":\"823613174960951296\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35940\",\"fd_1705_01\":\"11\",\"fd_1210_01\":\"0\",\"consumerId\":\"37482273802\",\"fd_1307_01\":\"11\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"3\",\"fd_1105\":\"4\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"3\",\"fd_1506\":\"9\",\"fd_1107\":\"3\",\"fd_1503\":\"89819\",\"fd_1504\":\"88845\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35940\",\"fd_1808_01\":\"11\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"3\",\"ft300113\":\"4\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"11\",\"ft500203\":\"9_null\",\"ft500201\":\"89815_null\",\"f8807\":\"1\",\"fd_1805_01\":\"11\",\"ft110014\":\"2\",\"fd_1808\":\"197\",\"fd_1809\":\"10,16,9,1,21\",\"fd_1502_04\":\"0.0194806\",\"fd_1001\":\"010102\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"8\",\"fd_1002\":\"010202\",\"fd_1005\":\"2,144112,21\",\"fd_1007\":\"100604,101002\",\"fd_1502_03\":\"0.0389611\",\"fd_1006\":\"1006,1010\",\"fd_1008\":\"386,452,89,201,378,303,558,192,291,518,508,394\",\"time\":\"20231030094142\",\"fd_1806\":\"228\",\"fd_1807\":\"224\",\"fd_1805\":\"270\"}";
        featureMapDoMap.put(32L, getFeatureMapDo(str32));

        // 线上预估0.00061, 样本时间2023-10-30 09:39:38，线上线下一致
        String str33 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-12248439786850573\",\"fd_1108_01\":\"1\",\"backTimeConsume\":\"{\\\"0\\\":12.83,\\\"3\\\":71.45,\\\"19\\\":55.67}\",\"ft100204\":\"stk-al00\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"0\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"3\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.5284553\",\"ft100205\":\"huawei\",\"ft500103\":\"10_3\",\"ft100209\":\"DYN\",\"ft500101\":\"89986_3\",\"fd_1105_01\":\"1\",\"ft300101\":\"90115\",\"ft300904\":\"1\",\"ft300901\":\"4\",\"ft300109\":\"com.ss.android.ugc.aweme.lite\",\"ft300902\":\"42\",\"ft300903\":\"4201\",\"ft300104\":\"33\",\"ft300105\":\"346\",\"ft300106\":\"985\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0396\",\"ft200104\":\"10\",\"ft200105\":\"02.22.0001\",\"ft200106\":\"161187\",\"ft200107\":\"05.02.0018\",\"ft200109\":\"0\",\"ft200101\":\"89986\",\"ft200102\":\"47025\",\"fd_1602_04\":\"0.0021127\",\"fd_1602_03\":\"0.7539907\",\"ft600201\":\"51069066\",\"ft300201\":\"457082\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"advertId\":\"89986\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0082816\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.8902692\",\"chargeType\":\"2\",\"fd_1120\":\"33758\",\"fd_1111\":\"9\",\"fd_1110\":\"1698613859\",\"fd_1113\":\"33758\",\"fd_1112\":\"1698613870\",\"fd_1115\":\"823545252297105408\",\"fd_1505_06\":\"0.5204327\",\"fd_1114\":\"823545252297105408\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-6,3-6,4-6,6-6\",\"ft300301\":\"33758\",\"consumerId\":\"37411756605\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"fd_1503\":\"89986\",\"fd_1504\":\"88985\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"33758\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"ft300111\":\"7\",\"fd_1106_02\":\"1\",\"ft300113\":\"8\",\"ft6002031\":\"9101924050\",\"ft300110\":\"4\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"ft500203\":\"10_null\",\"ft500201\":\"89986_null\",\"f8807\":\"1\",\"ft110014\":\"2\",\"ft6002041\":\"694491194457\",\"fd_1502_04\":\"0.0122449\",\"fd_1502_03\":\"0.9265307\",\"fd_1601_02\":\"0.5917909\",\"time\":\"20231030093938\"}";
//        featureMapDoMap.put(33L, getFeatureMapDo(str33));

        // 线上预估 0.005871, 样本时间 2023-10-30 09:41:32。 线上线下不一致，本地预估 0.006934
        String str34 = "{\"orderId\":\"taw-12248425555310642\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":79.8,\\\"19\\\":88.25}\",\"ft100204\":\"m2007j22c\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100206\":\"3\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6292683\",\"ft100205\":\"redmi\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1\",\"fd_1807_01\":\"2\",\"ft500101\":\"89187_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"84494\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"2\",\"ft300904\":\"4\",\"fd_1302\":\"0\",\"fd_1301\":\"128\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"41\",\"ft300901\":\"6\",\"ft300109\":\"cn.etouch.ecalendar\",\"fd_1305\":\"56\",\"ft300902\":\"52\",\"fd_1308\":\"15\",\"ft300903\":\"5206\",\"fd_1307\":\"28\",\"ft300104\":\"39\",\"ft300105\":\"370\",\"fd_1309\":\"10\",\"ft300106\":\"980\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"158677\",\"ft200107\":\"05.03.0012,05.02.0001,05.02.0019\",\"ft200109\":\"0\",\"fd_1308_01\":\"7\",\"fd_1308_02\":\"9\",\"ft200101\":\"89187\",\"ft200102\":\"47359\",\"fd_1602_04\":\"0.0079399\",\"fd_1602_03\":\"0.0346467\",\"ft300201\":\"393407\",\"ft300202\":\"2\",\"fd_1107_01\":\"0\",\"advertId\":\"89187\",\"abst\":\"[0]\",\"fd_1506_08\":\"0.008977\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0239387\",\"fd_1205\":\"2\",\"fd_1207\":\"2\",\"fd_1206\":\"2\",\"fd_1208\":\"2\",\"fd_1305_01\":\"9\",\"fd_1207_01\":\"2\",\"chargeType\":\"2\",\"fd_1120\":\"34387\",\"fd_1110\":\"1698630084\",\"fd_1505_06\":\"0.6865846\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"34387\",\"fd_1210_01\":\"0\",\"consumerId\":\"37523177090\",\"fd_1307_01\":\"8\",\"fd_1501\":\"83756\",\"fd_1502\":\"83175\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"83175\",\"fd_1504\":\"86991\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"9\",\"ft300304\":\"34387\",\"fd_1808_01\":\"2\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300111\":\"18\",\"ft300113\":\"4\",\"ft300110\":\"3\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"2\",\"ft500203\":\"16_null\",\"ft500201\":\"89187_null\",\"f8807\":\"1\",\"fd_1805_01\":\"5\",\"ft110014\":\"1\",\"fd_1808\":\"2\",\"fd_1502_04\":\"0.0167598\",\"fd_1001\":\"010101\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"2\",\"fd_1002\":\"01020301\",\"fd_1005\":\"145487,10\",\"fd_1007\":\"101502\",\"fd_1502_03\":\"0.027933\",\"fd_1006\":\"1015\",\"fd_1008\":\"193,391,393,263,385,397,399,202,378,521,148,303,436,528,927\",\"fd_1601_02\":\"0.6467536\",\"time\":\"20231030094132\",\"fd_1806\":\"7\",\"fd_1807\":\"2\",\"fd_1805\":\"5\"}";
        featureMapDoMap.put(34L, getFeatureMapDo(str34));

        // 线上预估 0.302104 , 样本时间 2023-10-30 09:41:19。 线上线下不一致，本地预估 0.310085
        String str35 = "{\"orderId\":\"taw-12248429120110413\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"35860\",\"backTimeConsume\":\"{\\\"0\\\":146.94,\\\"11\\\":143086.69,\\\"13\\\":110.0,\\\"15\\\":15482.39,\\\"18\\\":1909.12,\\\"19\\\":41.78,\\\"9\\\":296680.2}\",\"ft100204\":\"v2123a\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID11\",\"fd_1110\":\"1698630058\",\"fd_1011_01\":\"-1\",\"ft100202\":\"2\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7620717\",\"ft100207\":\"2021\",\"ft100206\":\"3\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.8237742\",\"ft100205\":\"vivo\",\"fd_1116\":\"0\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"fd_1105_01\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"95668\",\"ft300301\":\"35860\",\"consumerId\":\"37523170717\",\"fd_1501\":\"88903\",\"ft300904\":\"4\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"3\",\"fd_1503\":\"88903\",\"ft300902\":\"37\",\"fd_1504\":\"88883\",\"ft300903\":\"3709\",\"ft300302\":\"1\",\"ft300104\":\"39\",\"ft300303\":\"1\",\"ft300105\":\"831\",\"fd_1507\":\"9\",\"ft300304\":\"35860\",\"ft300106\":\"981\",\"fd_1508\":\"1\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"7\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"456368\",\"ft300202\":\"12\",\"fd_1107_01\":\"0\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1502_04\":\"3.31E-5\",\"fd_1506_08\":\"8.8E-6\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1957313\",\"fd_1502_03\":\"0.2280441\",\"time\":\"20231030094119\"}";
//        featureMapDoMap.put(35L, getFeatureMapDo(str35));

        return featureMapDoMap;


    }

    public FeatureMapDo getFeatureMapDo(String str1) {

        Map<String, String> featureIdxMap1 = (Map) JSON.parseObject(str1);
        //String str2 = "{\"f101001\":\"69442\"}";
        Map<String, String> featureIdxMap2 = new HashMap<>();

        //List<String> a= Arrays.asList("ft200101","ft200102","ft200103","ft200104","ft200106","ft200107","ft400303","ft200201","ft200202","ft500103");
        //List<String> a= Arrays.asList("ft200101","ft200102","ft200103","ft200104","ft200106","ft200107","ft400303","ft200201","ft200202","ft500103");

//        for(String f : a){
//            featureIdxMap2.put(f,featureIdxMap1.getOrDefault(f,null));
//            featureIdxMap1.remove(f);
//        }

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureIdxMap1);
        featureMapDo.setDynamicFeatureMap(featureIdxMap2);
        return featureMapDo;

    }

    @Test
    public void test() throws Exception {

        DeepModelV2 coder = getCoder("nz_last_model_new_ad_ctcvr_deep_v0919");

//        LocalTFModelV2 localTFModelCtcvr = new LocalTFModelV2();
//        localTFModelCtcvr.loadModel("/Users/duibagroup/Desktop/lwj/model/mid-cvr-v001","201");

        String path = "/Users/panhangyi/data/serving-model/mid-ad-cvr-v1018";
//        File file = new File(path);
//        if (file.isDirectory()) {
//
//            System.out.println(JSON.toJSONString(file.canRead()));
//            System.out.println("ss=" + JSON.toJSONString(file.listFiles()));
////
////            File[] listFiles = file.listFiles();
////
////            System.out.println(listFiles);
//
//        }





        LocalTFModelV2 tfModel = getTfModel(path);
        Map<Long, FeatureMapDo> featureMapDoMap = getFeatureMapDo();
        Map<Long, Double> ret = predict(coder, tfModel, featureMapDoMap);
        System.out.println(ret);

        for(Map.Entry<Long,FeatureMapDo> entry :featureMapDoMap.entrySet()){
            Long key = entry.getKey();
            FeatureMapDo value = entry.getValue();

            CodeDo codeDo= coder.getSampleDense(value.getFeatureMap(),null);

            System.out.println(key+"1-----"+coder.toString(codeDo));

            System.out.println(key+"2-----"+JSON.toJSONString(value.getCodeDoStr()));

        }



    }



}
