package cn.com.duiba.nezha.alg.example.example.dpa;

import cn.com.duiba.nezha.alg.alg.dpa.ActRcmder;
import cn.com.duiba.nezha.alg.alg.plugins.ActPlugInDQNRcmder;
import cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.*;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeepFmE2eDpaClickV001 {

    @Test
    public void rcmd() {

        String dpaPath = "/Users/lijingzhe/codes/duiba_sql/ActRcmdDoTest";
        BufferedReader dpaR = null;
        String dpaJs = "";
        try {
            FileInputStream alg40Fs = new FileInputStream(dpaPath);
            InputStreamReader alg40Ir = new InputStreamReader(alg40Fs, "UTF-8");
            dpaR = new BufferedReader(alg40Ir);
            String alg40 = null;
            while ((alg40 = dpaR.readLine()) != null) {
                dpaJs += alg40;
            }
            dpaR.close();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (dpaR != null) {
                try {
                    dpaR.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        Map<Integer, FeatureMapDo> featureDoMap = new HashMap<>();


        Map<String, String> map = JSON.parseObject(dpaJs, Map.class);
        Map<Integer, Map<String, String>> featureMap = new HashMap<>();
        for (int i = 0; i < 300; i++) {
            featureMap.put(i, map);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(map);
            featureDoMap.put(i, featureMapDo);
        }

        //1 编码器获取 缓存
        CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_click_v001", "dpa");
        CODER costCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_cost_v001", "dpa");


        //2 TF本地模型获取  缓存
        LocalTFModel clickLtfModel = new LocalTFModel();
        LocalTFModel costLtfModel = new LocalTFModel();
        try {
            clickLtfModel.loadModel("/Users/lijingzhe/codes/sample");
            costLtfModel.loadModel("/Users/lijingzhe/codes/sample");
            for (int j = 0; j < 100; j++) {
                Long t1 = System.currentTimeMillis();
                Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithLocalTF(featureMap, clickLtfModel);
                Long t2 = System.currentTimeMillis();
                Map<Integer, Double> costPRpmMap = costCoderModel.predictWithLocalTF(featureMap, costLtfModel);
                Long t3 = System.currentTimeMillis();

                System.out.println("click time consume:" + (t2 - t1) + ",cost time consume:" + (t3 - t2));
                System.out.println("clickPRpmMap=" + JSON.toJSONString(clickPRpmMap));
                System.out.println("clickPRpmMap=" + JSON.toJSONString(clickPRpmMap));
            }


        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);

        }
    }

}