package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFlowFilterAlg;
import cn.com.duiba.nezha.alg.alg.adx.rcmd.IdeaRcmdAlg;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmd;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRecommend;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.Model;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.PredictType;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxResourceRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.*;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.kaihu.RoiControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import cn.com.duiba.nezha.alg.api.model.AdxLocalTFModel;
import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.*;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.*;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.junit.Test;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.file.Paths;
import java.util.*;

import java.lang.management.ManagementFactory;

import com.sun.management.OperatingSystemMXBean;

import static cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmd2.predictCtrClick;
import static cn.com.duiba.nezha.alg.alg.adx.rcmd2.PredictType.CTR;
import static cn.com.duiba.nezha.alg.example.util.StatSyncBo.jedisUtil;

public class AdxModelTest {

    public static void main(String[] args) throws Exception {

//        test1();
        testModel();
//        test4();
//        test5();
//        test6();

    }


    @Test
    public void test() throws Exception {
        testModel();
    }

    public static void test6() throws Exception{
        AdxLocalTFModel adxLocalTFModel = new AdxLocalTFModel();
        adxLocalTFModel.loadLatestModel("/Users/panhangyi/mid-adx-esmm-ctclk-phy-v2");
        Model model = new Model();
        model.setEsmmTFModelV2(adxLocalTFModel);
        String str = "{\"f7020010\":\"aaaaa,bbbbb,ccccc\",\"f309040\":\"0.0\",\"f414004\":\"0\",\"f3010010\":\"32545\",\"f5020101\":\"0\",\"f5020103\":\"0\",\"f309050\":\"0.0\",\"f5020102\":\"0\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f413004\":\"0\",\"f2010010\":\"2636\",\"f5020010\":\"0\",\"f1010020\":\"44\",\"f7040050\":\"0\",\"f3016024\":\"221290\",\"f3016025\":\"120527\",\"f3016022\":\"1261178\",\"f4010010\":\"Mozilla/5.0 (iPhone; CPU iPhone OS 15_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 MicroMessenger/8.0.28(0x18001c2c) NetType/4G Language/zh_CN\",\"f3016023\":\"457932\",\"f7040060\":\"0\",\"f409004\":\"0\",\"f3016020\":\"113899\",\"f3010161\":\"113899\",\"f3016021\":\"62498\",\"f3010160\":\"234457\",\"f5020030\":\"0\",\"f4010121\":\"15\",\"f5010110\":\"1\",\"f2010060\":\"411143\",\"f410004\":\"0\",\"f5020020\":\"0\",\"f4010122\":\"7\",\"f4010030\":\"0\",\"f7040080\":\"0\",\"f3010144\":\"9\",\"f3010143\":\"10\",\"f3010142\":\"7\",\"f3010141\":\"8\",\"f5020050\":\"0\",\"f3010149\":\"78286\",\"f3010148\":\"220104\",\"f0001\":\"15\",\"f3010147\":\"7173\",\"f3010146\":\"69150\",\"f3010145\":\"7\",\"f0003\":\"1\",\"f0002\":\"7\",\"f5010135\":\"\",\"f3016013\":\"7778\",\"f5010134\":\"\",\"f3016014\":\"220104\",\"f5010133\":\"\",\"f3016011\":\"25292\",\"f3016012\":\"12710\"}";
        String str1 = "{\"f3016017\":\"23726\",\"f3016018\":\"666218\",\"f7040090\":\"0\",\"f3016015\":\"78286\",\"f5010136\":\"\",\"f3016016\":\"39700\",\"f3010155\":\"457932\",\"f3010154\":\"1261178\",\"f3010153\":\"62498\",\"f3010152\":\"666218\",\"f3010151\":\"23726\",\"f5020040\":\"0\",\"f3010150\":\"39700\",\"f3016010\":\"75969\",\"f3010159\":\"11655\",\"f3010158\":\"23170\",\"f3010157\":\"120527\",\"f6060011\":\"0\",\"f3010156\":\"221290\",\"f6060012\":\"0\",\"f6060013\":\"0\",\"f6060014\":\"1\",\"f6060015\":\"1\",\"f3016019\":\"234457\",\"f5010010\":\"010105\",\"f0309\":\"0\",\"f0308\":\"0\",\"f0307\":\"0\",\"f411004\":\"0\",\"f5020070\":\"0\",\"f3030011\":\"\",\"f0302\":\"0\",\"f0301\":\"0\",\"f0306\":\"0\",\"f0305\":\"0\",\"f0304\":\"0\",\"f0303\":\"0\",\"f5010036\":\"0\",\"f5010035\":\"0\",\"f5010034\":\"0\",\"f5010033\":\"0\",\"f5020060\":\"0\",\"f6010102\":\"[1]\",\"f4010070\":\"[189,129]\",\"f5020090\":\"0\",\"f0320\":\"0\",\"f307040\":\"0.0\",\"f0203\":\"0\",\"f0324\":\"0\",\"f0202\":\"0\",\"f0323\":\"0\",\"f0201\":\"0\",\"f0322\":\"0\",\"f0321\":\"0\",\"f0327\":\"0\",\"f0326\":\"0\",\"f0204\":\"0\",\"f0325\":\"0\",\"f0319\":\"0\",\"f0318\":\"0\",\"f5020080\":\"0\",\"f3060017\":\"1\",\"f3060016\":\"1\",\"f307050\":\"0.0\",\"f3060013\":\"1\",\"f5010050\":\"8e3H3Ny3GBDTLn3T\",\"f0313\":\"0\",\"f3060012\":\"1\",\"f0312\":\"0\",\"f3060015\":\"1\",\"f0311\":\"0\",\"f3060014\":\"1\",\"f0310\":\"0\",\"f0317\":\"0\",\"f0316\":\"0\",\"f3060011\":\"1\",\"f0315\":\"0\",\"f0314\":\"0\",\"f4010091\":\"0\",\"f1010010\":\"190\",\"f5010060\":\"0\",\"f3020000\":\"0\",\"f5010079\":\"0\",\"f5010078\":\"0\",\"f5010077\":\"0\",\"f5030101\":\"190&1000\",\"f5030102\":\"2636&1000\",\"f5030103\":\"32545&1000\",\"f4010080\":\"0\",\"f5010070\":\"0\",\"f5010076\":\"0\",\"f5010075\":\"0\",\"f5010074\":\"0\",\"f6010090\":\"411143\",\"f5010082\":\"0\",\"f5010081\":\"0\",\"f5010080\":\"0\",\"f412004\":\"0\",\"f5010090\":\"0\"}";
        HashMap<String, String> staticFeatureMap = JSON.parseObject(str, HashMap.class);
        HashMap<String, String> dynamicFeatureMap = JSON.parseObject(str1, HashMap.class);
//        featureMap.put("ft1","aaa");
        Map<Long, FeatureMapDo> featureMap = new HashMap<>();
        FeatureMapDo featuremapdo = new FeatureMapDo();
        featuremapdo.setStaticFeatureMap(staticFeatureMap);
        featuremapdo.setDynamicFeatureMap(dynamicFeatureMap);
        featureMap.put(123L,featuremapdo);
        Map<String, Map<Long, Double>> predict = predictCtrClick(featureMap, model, PredictType.ESMMV2);
        System.out.println(predict);
    }
    public static void testDmp1() throws Exception {
//        String key = "mid_ftrl_fm_bcvr_v007";
//
//
//
//        FM model = StdModelSave.getModelByKeyFromJedis(key);
//
//        System.out.println(model.getUpdateTime());
//
//        String str = "{\"f608001\":\"0\",\"f104001\":\"58215\",\"f603002\":\"2\",\"f603001\":\"2\",\"f110001\":\"0\",\"f505001\":\"1700-2699\",\"f770102\":\"2\",\"f809001\":\"1\",\"f809002\":\"0\",\"f201001\":\"52999\",\"f660001\":\"\",\"f609001\":\"1\",\"f804004\":\"1\",\"f804003\":\"7\",\"f804002\":\"0\",\"f804001\":\"9\",\"f810001\":\"null\",\"f770001\":\"07.10.0004\",\"f810002\":\"null\",\"f306001\":\"2\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"OPPO R11 Plusk\",\"f601001\":\"2\",\"f601002\":\"2\",\"f607001\":\"0\",\"f206002\":\"260\",\"f811001\":\"104\",\"f403004\":\"0\",\"f805001\":\"9\",\"f805002\":\"0\",\"f805003\":\"7\",\"f805004\":\"1\",\"f770302\":\"0\",\"f770301\":\"0\",\"f9940\":\"2,14,27,37,52,66,73,86,100,113,122,133,145,157,170\",\"f9941\":\"90,11698||4011,5891,2754,2750|8674,7860,4011,7422,8852,1220,1165,5083,1081,90,8604,7856,4582,5891,7751,2187,2515,2754,2753,2774,2773,2750,7607|7589|429|8674,7860,4011,7422,7589,8852,1220,1165,5083,1081,90,10099,8604,3895,7856,4582,5891,3692,7751,2187,1490,2515,3726,5409,3108,2754,2753,2774,2773,2750,429,64,7607|10099,4582,3726,2753,2774,2750||8674,7860,4011,7422,7589,8852,1220,1165,5083,1081,90,10099,8604,3895,7856,4582,5891,3692,7751,2187,2515,3726,5409,3108,2754,2753,2774,2773,2750,429,64,7607|8674,7860,4011,7422,7589,8852,1220,1165,5083,1081,90,10099,8604,3895,7856,4582,5891,3692,7751,2187,1490,2515,3726,5409,3108,2754,2753,2774,2773,2750,429,64,7607|8674,7860,4011,7422,7589,8852,1220,1165,5083,1081,90,10099,8604,3895,7856,4582,5891,3692,7751,2187,2515,3726,5409,2754,2753,2774,2773,2750,429,64,7607|8674,7860,4011,7422,7589,8852,1220,1165,5083,1081,90,10099,8604,3895,7856,4582,5891,7751,2187,2515,3726,5409,2754,2753,2774,2773,2750,11698,7607\",\"f9942\":\"0.522612,0.401063,0.593885,0.429044,0.588687,0.597908,0.607017,0.478813\",\"f9701\":\"01040218,020101,020105,020112,020114,020307,020408,020601,020710,020714,020801,021009,02110101,02110102,021107,021111,021120,021308,021404,021405,02140601,02140603,02140604,02140701,021408,022406,0225,03010105,03010108,05011701,05011804,0503\",\"f9943\":\"3692,8674,5083,7607,90,7856,1220,4582,10099,8852,64,4011,7589,3726,2750,2753,7860,3895,7422,429,5409,1165,1490,7751,2187\",\"f9702\":\"7\",\"f9944\":\"3692,8674,5083,7607,90,7856,1220,4582,10099,8852,64,4011,7589,3726,2750,2753,7860,3895,7422,429,5409,1165,1490,7751,2187\",\"f602001\":\"10\",\"f205002\":\"253\",\"f205001\":\"25\",\"f701001\":\"1043532\",\"f811002\":\"104\",\"f404003\":\"workother\",\"f106001\":\"12918\",\"f112001\":\"05.02.0014,05.02.0018\",\"f101001\":\"43532\",\"f701002\":\"1052999\",\"f9607\":\"null\",\"f9608\":\"null\",\"f9609\":\"null,10540_07.10.0004,15567_07.10.0004,15743_07.10.0004,18505_07.10.0004,9982_07.10.0004\",\"f503001\":\"3401\",\"f770202\":\"4\",\"time\":\"20200403065132\",\"f9601\":\"null\",\"f9602\":\"null,01040218_07.10.0004,020101_07.10.0004,020105_07.10.0004,020112_07.10.0004,020114_07.10.0004,020307_07.10.0004,020408_07.10.0004,020601_07.10.0004,020710_07.10.0004,020714_07.10.0004,020801_07.10.0004,021009_07.10.0004,02110101_07.10.0004,02110102_07.10.0004,021107_07.10.0004,021111_07.10.0004,021120_07.10.0004,021308_07.10.0004,021404_07.10.0004,021405_07.10.0004,02140601_07.10.0004,02140603_07.10.0004,02140604_07.10.0004,02140701_07.10.0004,021408_07.10.0004,022406_07.10.0004,0225_07.10.0004,03010105_07.10.0004,03010108_07.10.0004,05011701_07.10.0004,05011804_07.10.0004,0503_07.10.0004\",\"f602002\":\"9\",\"f9603\":\"null,01040218_43532,020101_43532,020105_43532,020112_43532,020114_43532,020307_43532,020408_43532,020601_43532,020710_43532,020714_43532,020801_43532,021009_43532,02110101_43532,02110102_43532,021107_43532,021111_43532,021120_43532,021308_43532,021404_43532,021405_43532,02140601_43532,02140603_43532,02140604_43532,02140701_43532,021408_43532,022406_43532,0225_43532,03010105_43532,03010108_43532,05011701_43532,05011804_43532,0503_43532\",\"orderId\":\"taw-773336807860705\",\"f113001\":\"04.03.0013,04.01.0008,04.03.0017\",\"f9913\":\"6\",\"f508002\":\"R11Plusk\",\"f806001\":\"9\",\"f508001\":\"OPPO\",\"f9914\":\"\",\"f806002\":\"0\",\"f9915\":\"\",\"f806003\":\"7\",\"f830101\":\"null,60505_43532,61071_43532\",\"f9916\":\"02.24.0001&2,02.01.0003&2,02.01.0008&4,02.06&4\",\"f806004\":\"1\",\"f830102\":\"null,22412_12918,22412_12918\",\"f9917\":\"02.24.0001&1,02.01.0003&1,02.01.0008&1,02.06&1\",\"f830103\":\"null,07.10.0004_07.10.0004,07.10.0004_07.10.0004\",\"f9918\":\"02.24.0001&1,02.01.0003&1,02.01.0008&1,02.06&1\",\"f830104\":\"null\",\"f9919\":\"02.24.0001&8,02.01.0003&8,02.01.0008&6,02.06&6\",\"f502001\":\"6\",\"f502002\":\"5\",\"f611001\":\"2\",\"f9902\":\"3692,3108,8674,5083,7607,90,7856,11698,1220,4582,10099,2515,8852,64,4011,7589,2774,3726,2750,2753,7860,3895,7422,2773,8604,2754,429,5891,5409,1165,1490,1081,7751,2187\",\"f9903\":\"11\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770501\":\"1\",\"f606002\":\"1\",\"f606001\":\"1\",\"f102001\":\"02.01.0009\",\"f9935\":\"3692,3108,8674,5083,7607,90,7856,11698,1220,4582,10099,2515,8852,64,4011,7589,2774,3726,2750,2753,7860,3895,7422,2773,8604,2754,429,5891,5409,1165,1490,1081,7751,2187\",\"f9936\":\"3692,5083,7607,90,7856,1220,4582,10099,8852,64,4011,7589,3726,2750,2753,7860,3895,7422,429,5409,1165,1490,7751,2187\",\"f830001\":\"60505,61071\",\"f9937\":\"3108,11698,2515,8604,1081\",\"f830002\":\"22412,22412\",\"f830003\":\"07.10.0004,07.10.0004\",\"f830004\":\"\",\"f9930\":\"2\",\"f9931\":\"-1\",\"f301001\":\"12501\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"330817\",\"advertId\":\"43532\",\"f807002\":\"0\",\"f9924\":\"02.01.0008,02.06\",\"f9803\":\"34-2,43-1\",\"f807001\":\"10\",\"f507001\":\"3\",\"f9804\":\"18312,59543,66568,43870,3124,63802\",\"f807004\":\"1\",\"f830111\":\"null\",\"f807003\":\"7\",\"f830112\":\"null\",\"f9927\":\"0\",\"f830113\":\"null\",\"f9928\":\"0\",\"f830114\":\"null\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"\",\"f9922\":\"\",\"f9801\":\"10540,15567,15743,18505,9982\",\"f770402\":\"0\",\"f9923\":\"02.01.0003\",\"f9802\":\"5\",\"f604002\":\"6\",\"f604001\":\"6\",\"f501001\":\"Android\",\"f610001\":\"0\",\"f303001\":\"28\",\"consumerId\":\"20389566145\",\"f406001\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f830012\":\"{0=, 2=, 3=}\",\"f830013\":\"{0=, 2=, 3=}\",\"f830014\":\"{0=, 2=, 3=}\",\"f115001\":\"0\",\"f808002\":\"0_0,02.01.0003_0,02.01.0008_0,02.06_0,02.24.0001_0\",\"f506001\":\"1\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"0_1,02.01.0003_1,02.01.0008_1,02.06_1,02.24.0001_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f302001\":\"12501\"}";
//
//
//        Map<String, String> map = (Map)JSON.parse(str);
//
//        System.out.println(model.predict(map));
//        OcpxControlSubModel ocpxControlParams = readModelFromRedis2("strategy_stat_model_v001",1);
//        System.out.println("1:" + ocpxControlParams);
//        System.out.println("11:" + ocpxControlParams.getOcpxControlParams());
//        System.out.println("21:" + ocpxControlParams.getOcpx2ControlParams());
//        System.out.println("31:" + ocpxControlParams.getOcpx3ControlParams());
//
//
//        OcpxControlModel ocpxControlModel = StatSyncBo.readModelFromRedis("strategy_stat_model_v001");
////        OcpxControlModel ocpxControlModel = new OcpxControlModel();
//        System.out.println("1:" + ocpxControlModel.getOcpxControlSubModel(72943L, 177246L).getOcpxControlParams());
//        System.out.println("2:" + ocpxControlModel.getOcpxControlSubModel(72943L, 177246L).getOcpx2ControlParams());
//        System.out.println("3:" + ocpxControlModel.getOcpxControlSubModel(72943L, 177246L).getOcpx3ControlParams());

//        RoiControlModel params = readModelFromRedis3("slot_stat_model_v101",1);
//        System.out.println("RoiControlModel:" + params);

        String str1 = "{\"bidMode\":1,\"billType\":1,\"dpa\":false,\"ideaId\":27253,\"ideaUnitDos\":[{\"adIdeaId\":27253,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":1927,\"activiyJoin\":1957,\"advertClick\":1059,\"advertConsume\":36232,\"advertExposure\":1782,\"advertLaunch\":1955,\"adxConsume\":242416480000,\"adxConsume2\":24241.649,\"adxConsume3\":2.4241648E7,\"bias\":0.0,\"bid\":5403870,\"bidSuc\":1605818,\"click\":1434,\"exp\":1192480}},\"ideaUnitId\":10252,\"isNew\":true,\"materialIds\":[34213],\"type\":1}],\"priceType\":1,\"resId\":890,\"roi\":115.0,\"unitPutType\":1}";
        AdIdeaDo r1 = JSONObject.parseObject(str1, AdIdeaDo.class);
        String str2 = "{\"bidMode\":1,\"billType\":1,\"dpa\":false,\"ideaId\":31861,\"ideaUnitDos\":[{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":5,\"activiyJoin\":1,\"advertClick\":1,\"advertConsume\":20,\"advertExposure\":1,\"advertLaunch\":1,\"adxConsume\":912580000,\"adxConsume2\":91.258,\"adxConsume3\":91258.0,\"bias\":0.0,\"bid\":14666,\"bidSuc\":5253,\"click\":3,\"exp\":3978}},\"ideaUnitId\":10857,\"isNew\":true,\"materialIds\":[38266],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":4,\"activiyJoin\":4,\"advertClick\":1,\"advertConsume\":125,\"advertExposure\":4,\"advertLaunch\":4,\"adxConsume\":1741800000,\"adxConsume2\":174.181,\"adxConsume3\":174180.0,\"bias\":0.0,\"bid\":26664,\"bidSuc\":9808,\"click\":4,\"exp\":7311}},\"ideaUnitId\":10856,\"isNew\":true,\"materialIds\":[38265],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":4,\"activiyJoin\":4,\"advertClick\":3,\"advertConsume\":26,\"advertExposure\":3,\"advertLaunch\":4,\"adxConsume\":3193790000,\"adxConsume2\":319.38,\"adxConsume3\":319379.0,\"bias\":0.0,\"bid\":44941,\"bidSuc\":16800,\"click\":3,\"exp\":12770}},\"ideaUnitId\":10855,\"isNew\":true,\"materialIds\":[38264],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":0,\"activiyJoin\":0,\"advertClick\":0,\"advertConsume\":0,\"advertExposure\":0,\"advertLaunch\":0,\"adxConsume\":637570000,\"adxConsume2\":63.757,\"adxConsume3\":63757.0,\"bias\":0.0,\"bid\":10780,\"bidSuc\":3759,\"click\":1,\"exp\":2754}},\"ideaUnitId\":10854,\"isNew\":true,\"materialIds\":[38263],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":0,\"activiyJoin\":0,\"advertClick\":0,\"advertConsume\":0,\"advertExposure\":0,\"advertLaunch\":0,\"adxConsume\":16380000,\"adxConsume2\":1.638,\"adxConsume3\":1638.0,\"bias\":0.0,\"bid\":170,\"bidSuc\":73,\"click\":0,\"exp\":57}},\"ideaUnitId\":10853,\"isNew\":true,\"materialIds\":[38262],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":0,\"activiyJoin\":0,\"advertClick\":0,\"advertConsume\":0,\"advertExposure\":0,\"advertLaunch\":0,\"adxConsume\":1870000,\"adxConsume2\":0.187,\"adxConsume3\":187.0,\"bias\":0.0,\"bid\":8,\"bidSuc\":5,\"click\":0,\"exp\":3}},\"ideaUnitId\":10852,\"isNew\":true,\"materialIds\":[38261],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":15,\"activiyJoin\":17,\"advertClick\":8,\"advertConsume\":204,\"advertExposure\":15,\"advertLaunch\":17,\"adxConsume\":2051250000,\"adxConsume2\":205.125,\"adxConsume3\":205125.0,\"bias\":0.0,\"bid\":30395,\"bidSuc\":11234,\"click\":11,\"exp\":8525}},\"ideaUnitId\":10851,\"isNew\":true,\"materialIds\":[38260],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":5,\"activiyJoin\":3,\"advertClick\":2,\"advertConsume\":43,\"advertExposure\":2,\"advertLaunch\":3,\"adxConsume\":1491370000,\"adxConsume2\":149.138,\"adxConsume3\":149137.0,\"bias\":0.0,\"bid\":23110,\"bidSuc\":8439,\"click\":4,\"exp\":6327}},\"ideaUnitId\":10850,\"isNew\":true,\"materialIds\":[38259],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":3,\"activiyJoin\":1,\"advertClick\":0,\"advertConsume\":0,\"advertExposure\":0,\"advertLaunch\":1,\"adxConsume\":319770000,\"adxConsume2\":31.978,\"adxConsume3\":31977.0,\"bias\":0.0,\"bid\":5601,\"bidSuc\":1940,\"click\":2,\"exp\":1450}},\"ideaUnitId\":10849,\"isNew\":true,\"materialIds\":[38258],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"activityRequest\":4,\"activiyJoin\":2,\"advertClick\":2,\"advertConsume\":81,\"advertExposure\":2,\"advertLaunch\":2,\"adxConsume\":425920000,\"adxConsume2\":42.592,\"adxConsume3\":42592.0,\"bias\":0.0,\"bid\":7434,\"bidSuc\":2640,\"click\":2,\"exp\":1898}},\"ideaUnitId\":10847,\"isNew\":true,\"materialIds\":[38256],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10846,\"isNew\":true,\"materialIds\":[38255],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10833,\"isNew\":true,\"materialIds\":[38254],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10832,\"isNew\":true,\"materialIds\":[38253],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10831,\"isNew\":true,\"materialIds\":[38252],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10830,\"isNew\":true,\"materialIds\":[38251],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10829,\"isNew\":true,\"materialIds\":[38250],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10828,\"isNew\":true,\"materialIds\":[38249],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10825,\"isNew\":true,\"materialIds\":[38246],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10824,\"isNew\":true,\"materialIds\":[38245],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10823,\"isNew\":true,\"materialIds\":[38244],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10822,\"isNew\":true,\"materialIds\":[38243],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10821,\"isNew\":true,\"materialIds\":[38242],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10820,\"isNew\":true,\"materialIds\":[38241],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10819,\"isNew\":true,\"materialIds\":[38240],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10818,\"isNew\":true,\"materialIds\":[38239],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10817,\"isNew\":true,\"materialIds\":[38238],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10816,\"isNew\":true,\"materialIds\":[38237],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10815,\"isNew\":true,\"materialIds\":[38236],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10814,\"isNew\":true,\"materialIds\":[38235],\"type\":1},{\"adIdeaId\":31861,\"adxStatsDo\":{\"last1DayStat\":{\"actCpc\":0.0,\"actRoi\":0.0,\"actValue\":0.0,\"bias\":0.0}},\"ideaUnitId\":10813,\"isNew\":true,\"materialIds\":[38234],\"type\":1}],\"priceType\":1,\"resId\":890,\"roi\":120.0,\"unitPutType\":1}";
        AdIdeaDo r2 = JSONObject.parseObject(str2, AdIdeaDo.class);

        List<AdIdeaDo> adIdeaDos = new ArrayList<>();
        adIdeaDos.add(r1);
        adIdeaDos.add(r2);

        List<AdIdeaDo> ret = AdxRecommend.rawRank(adIdeaDos, null, 10);
        System.out.println("ret:" + ret);


    }

    public static void testDmp() throws Exception {
        String key = "mid_ftrl_fm_ctr_v010";
        String key1 = "mid_ftrl_fm_ctr_v711";
        String key2 = "mid_ftrl_fm_ctr_v712";
        String key3 = "mid_ftrl_fm_ctr_v713";

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);

        /*
        FM model = StdModelSave.getADXModelByKeyFromJedis(key);
        FM model1 = StdModelSave.getADXModelByKeyFromJedis(key1);
        FM model2 = StdModelSave.getADXModelByKeyFromJedis(key2);
        */

        FM model = StdModelSave.getModelByKeyFromJedis(key, juOnline);
        FM model1 = StdModelSave.getModelByKeyFromJedis(key1, juOnline);
        FM model2 = StdModelSave.getModelByKeyFromJedis(key2, juOnline);
        FM model3 = StdModelSave.getModelByKeyFromJedis(key3, juOnline);


        String str = "{\"f608001\":\"0\",\"f104001\":\"89505\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f505001\":\"\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f201001\":\"69636\",\"f660001\":\"17\",\"f609001\":\"1\",\"f804004\":\"1\",\"f804003\":\"3\",\"f804002\":\"0\",\"f804001\":\"3\",\"f810001\":\"1\",\"f770001\":\"07.14.0051\",\"f810002\":\"0\",\"f306001\":\"2\",\"chargeType\":\"1\",\"f206001\":\"540\",\"f504001\":\"\",\"f601001\":\"1\",\"f601002\":\"1\",\"f607001\":\"0\",\"f206002\":\"538\",\"f811001\":\"102\",\"f403004\":\"0\",\"f805001\":\"3\",\"f805002\":\"0\",\"f805003\":\"3\",\"f805004\":\"1\",\"f9940\":\"2,13,25,37,49,61,73,85,97,109,121,133,145,157,169\",\"f9941\":\"|||5337|||5337|||5337|5337||5337\",\"f9942\":\"0.618099,0.526595,0.465138,0.358335,0.530794,0.503094,0.525437,0.370032\",\"f9943\":\"5337\",\"f9702\":\"0\",\"f9944\":\"5337\",\"f602001\":\"1\",\"f205002\":\"197\",\"f205001\":\"196\",\"f701001\":\"1061178\",\"f811002\":\"102\",\"f404003\":\"workother\",\"f106001\":\"22597\",\"f660201\":\"0\",\"f112001\":\"\",\"f101001\":\"61178\",\"f701002\":\"1069636\",\"f9607\":\"null\",\"f9608\":\"null\",\"f9609\":\"null\",\"f503001\":\"4509\",\"time\":\"20200406160207\",\"f9601\":\"null\",\"f9602\":\"null\",\"f602002\":\"1\",\"f9603\":\"null\",\"orderId\":\"taw-810035721541023\",\"f113001\":\"04.01.0006,04.03.0013,04.03.0017\",\"f806001\":\"3\",\"f806002\":\"0\",\"f806003\":\"3\",\"f830101\":\"null\",\"f9916\":\"02.24.0001&2\",\"f806004\":\"1\",\"f830102\":\"null\",\"f9917\":\"02.24.0001&1\",\"f830103\":\"null\",\"f9918\":\"02.24.0001&1\",\"f830104\":\"null\",\"f9919\":\"02.24.0001&8\",\"adxRid\":\"0011d50b4e90e08a9b8795a588d309ff-k8ls9qnq-28499299_1000000000381\",\"f502001\":\"16\",\"f502002\":\"1\",\"f611001\":\"1\",\"f9902\":\"5337\",\"f9903\":\"1\",\"f770501\":\"0\",\"f606002\":\"10\",\"f606001\":\"99\",\"f102001\":\"02.24.0001\",\"f9930\":\"0\",\"f9931\":\"-1\",\"f301001\":\"999999\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"326766\",\"advertId\":\"61178\",\"f807002\":\"0\",\"f9924\":\"\",\"f807001\":\"3\",\"f507001\":\"3\",\"f807004\":\"1\",\"f830111\":\"null\",\"f807003\":\"3\",\"f830112\":\"null\",\"f9927\":\"0\",\"f830113\":\"null\",\"f9928\":\"0\",\"f830114\":\"null\",\"f9929\":\"0\",\"f770401\":\"0\",\"f9921\":\"\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"\",\"f9802\":\"0\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"unknow\",\"f610001\":\"0\",\"f303001\":\"1\",\"f114001\":\"119\",\"consumerId\":\"1190868170313727\",\"f114002\":\"227\",\"f406001\":\"1\",\"f830011\":\"null\",\"f830012\":\"null\",\"f830013\":\"null\",\"f830014\":\"null\",\"f115001\":\"0\",\"f808002\":\"0_0,02.24.0001_0\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"0_1,02.24.0001_1\",\"f8803\":\"1\",\"f605001\":\"99\",\"f605002\":\"10\",\"f302001\":\"-1\"}\n";


        Map<String, String> map = (Map) JSON.parse(str);

        System.out.println("v010:" + model.getUpdateTime() + " ,model_ps= " + model.getModelId() + " ,pre_ctr:" + model.predict(map));
        System.out.println("v711:" + model1.getUpdateTime() + " ,model1_ps= " + model1.getModelId() + " ,pre_ctr:" + model1.predict(map));
        System.out.println("v712:" + model2.getUpdateTime() + " ,model2_ps= " + model2.getModelId() + " ,pre_ctr:" + model2.predict(map));
        System.out.println("v713:" + model3.getUpdateTime() + " ,model3_ps= " + model3.getModelId() + " ,pre_ctr:" + model3.predict(map));

    }

    public static void testAdx11() {

        JedisConfig jcOnline = new JedisConfig();
        //spark-redis
//        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
//        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        //adx-redis
        jcOnline.setIp("r-bp1p7jdgwk8c6ybmzk.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("pMuMLAD3g8K63k7qCKzZeZ7");
        jcOnline.setPort(6379);

        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("47.111.157.152");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);


        try {

            /*
            String key = "adx_mid_ftrl_fm_ctr_v002";
            String key2 = "adx_mid_ftrl_fm_ctr_v003";
            FM model = StdModelSave.getADXModelByKeyFromJedis(key, juOffline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("model=" + key + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());

            StdModelSave.saveADXModelByKeyToJedis(key2, model, juOffline);
            FM modelTest = StdModelSave.getADXModelByKeyFromJedis(key2, juOffline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("modelTest=" + key2 + ",model.UpdateTime = " + modelTest.getUpdateTime() + ",model_ps = " + modelTest.getModelId());
            */

            String key = "adx_mid_ftrl_fm_ctr_v004";
            String key2 = "adx_mid_ftrl_fm_ctr_v004";
            FM model = StdModelSave.getADXModelByKeyFromJedis(key, juOnline);
            //FM model = StdModelSave.getModelByKeyFromJedis(key2, juOnline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("model=" + key + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());

            //StdModelSave.saveModelByKeyToJedis(key2, model, juOffline);
            //FM modelTest = StdModelSave.getModelByKeyFromJedis(key2, juOffline);
            StdModelSave.saveADXModelByKeyToJedis(key2, model, juOffline);
            FM modelTest = StdModelSave.getADXModelByKeyFromJedis(key2, juOffline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("modelTest=" + key2 + ",model.UpdateTime = " + modelTest.getUpdateTime() + ",model_ps = " + modelTest.getModelId());

            String str = "{\"f3040055\":\"0\",\"f3040054\":\"0\",\"f3040057\":\"0\",\"f3040056\":\"0\",\"f3050017\":\"0\",\"f4010050\":\"HONOR\",\"f411004\":\"0\",\"f3050016\":\"0\",\"f3050015\":\"0\",\"f3050014\":\"0\",\"f5020070\":\"0\",\"f6010070\":\"\",\"f3030011\":\"\",\"f3040044\":\"0\",\"f5010036\":\"0\",\"f5010035\":\"0\",\"f414004\":\"0\",\"f3040046\":\"0\",\"f5010034\":\"0\",\"f3040045\":\"0\",\"f5010033\":\"0\",\"f3040047\":\"0\",\"f6010100\":\"1\",\"f3010010\":\"31826\",\"f5020060\":\"0\",\"f5020101\":\"0\",\"f5020103\":\"0\",\"f5020102\":\"0\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f4010070\":\"0\",\"f413004\":\"0\",\"f5020090\":\"0\",\"f2010010\":\"1120\",\"f5020010\":\"0\",\"f3040022\":\"0\",\"f3040024\":\"0\",\"f3040026\":\"0\",\"f4010060\":\"JSN-AL00a\",\"f3040025\":\"0\",\"f3040027\":\"0\",\"f5020080\":\"0\",\"f1010020\":\"19\",\"f3060017\":\"1\",\"f3060016\":\"1\",\"f3060013\":\"1\",\"f5010050\":\"785be58b2bee5c17d3c4cce8066f6591\",\"f3060012\":\"1\",\"f3060015\":\"1\",\"f7040050\":\"0\",\"f3060014\":\"1\",\"f3060011\":\"1\",\"f3060010\":\"31826&b191bf85\",\"f3040012\":\"0\",\"f4010010\":\"Dalvik/2.1.0 (Linux; U; Android 10; JSN-AL00a Build/HONORJSN-AL00a)\",\"f7040060\":\"0\",\"f4010091\":\"2\",\"f409004\":\"0\",\"f5020030\":\"0\",\"f1010010\":\"129\",\"f5010060\":\"0\",\"f3020000\":\"0\",\"f5010079\":\"0\",\"f4010121\":\"18\",\"f5010078\":\"0\",\"f5010077\":\"0\",\"f5030101\":\"129&1000\",\"f5030102\":\"1120&1000\",\"f2010060\":\"7772015\",\"f5030103\":\"31826&1000\",\"f410004\":\"0\",\"f2010062\":\"3204\",\"f2010061\":\"b191bf85\",\"f4010080\":\"3\",\"f5020020\":\"0\",\"f6010020\":\"com.baidu.video\",\"f5010070\":\"0\",\"f5010076\":\"0\",\"f4010122\":\"1\",\"f5010075\":\"0\",\"f5010074\":\"0\",\"f4010031\":\"82\",\"f4010030\":\"3717\",\"f4010032\":\"3\",\"f7040080\":\"0\",\"f3010144\":\"0\",\"f3050037\":\"0\",\"f3010143\":\"0\",\"f3050036\":\"0\",\"f3010142\":\"0\",\"f6010010\":\"b191bf85\",\"f3050035\":\"0\",\"f3010141\":\"0\",\"f3050034\":\"0\",\"f5020050\":\"0\",\"f6010090\":\"80088008880\",\"f3010145\":\"1\",\"f5010082\":\"0\",\"f5010081\":\"0\",\"f5010080\":\"0\",\"f4010020\":\"222.133.95.39\",\"f412004\":\"0\",\"f7040090\":\"0\",\"f3050027\":\"0\",\"f3050026\":\"0\",\"f3050025\":\"0\",\"f3050024\":\"0\",\"f5020040\":\"0\",\"f5010090\":\"0\",\"f6060010\":\"1120&b191bf85\",\"f6060011\":\"0\",\"f6060012\":\"0\",\"f6060013\":\"0\",\"f6060014\":\"1\",\"f6060015\":\"1\",\"f5010010\":\"010105\"}";
            Map<String, String> map = (Map) JSON.parse(str);
            Map ret = modelTest.featureParamsTest(map);
            System.out.println("start1:" + System.currentTimeMillis());
            System.out.println("model:" + modelTest.getUpdateTime() + " ,model_ps= " + modelTest.getModelId() + " ,pre_ctr:" + modelTest.predict(map));
            System.out.println("end1:" + System.currentTimeMillis());


            Model model2 = new Model();
            model2.setCtrModel(model);
            Map<Long, FeatureMapDo> featureMap = new HashMap<>();
            String str2 = "{\"dynamicFeatureMap\":{\"f3040055\":\"0\",\"f3040054\":\"0\",\"f3040057\":\"0\",\"f3040012\":\"0\",\"f3040056\":\"0\",\"f3050017\":\"0\",\"f3050016\":\"0\",\"f3010144\":\"0\",\"f3050015\":\"0\",\"f3050037\":\"0\",\"f3010143\":\"0\",\"f3050014\":\"0\",\"f3050036\":\"0\",\"f3010142\":\"1\",\"f3050035\":\"0\",\"f3010141\":\"4\",\"f3050034\":\"0\",\"f3030011\":\"\",\"f3010145\":\"2\",\"f3040022\":\"0\",\"f3040044\":\"0\",\"f3040024\":\"0\",\"f3040046\":\"0\",\"f3040045\":\"0\",\"f3040026\":\"0\",\"f3040025\":\"0\",\"f3040047\":\"0\",\"f3040027\":\"0\",\"f3050027\":\"0\",\"f3050026\":\"0\",\"f3010010\":\"31698\",\"f3050025\":\"0\",\"f3050024\":\"0\",\"f3060017\":\"1\",\"f3060016\":\"1\",\"f3060013\":\"1\",\"f3060012\":\"1\",\"f3060015\":\"1\",\"f3060014\":\"1\",\"f3060011\":\"1\",\"f3060010\":\"31698&c52f59c5\"},\"staticFeatureMap\":{\"f4010050\":\"OPPO\",\"f411004\":\"0\",\"f5020070\":\"0\",\"f6010070\":\"\",\"f5010036\":\"0\",\"f5010035\":\"0\",\"f414004\":\"0\",\"f5010034\":\"0\",\"f5010033\":\"0\",\"f6010100\":\"1\",\"f5020060\":\"0\",\"f5020101\":\"0\",\"f5020103\":\"0\",\"f5020102\":\"0\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f4010070\":\"0\",\"f413004\":\"0\",\"f5020090\":\"0\",\"f2010010\":\"1120\",\"f5020010\":\"0\",\"f4010060\":\"PCHM10\",\"f5020080\":\"0\",\"f1010020\":\"19\",\"f5010050\":\"2fdc11e27328c33773f0a5b429487fc9\",\"f7040050\":\"0\",\"f4010010\":\"Dalvik/2.1.0 (Linux; U; Android 11; PCHM10 Build/RKQ1.200903.002)\",\"f7040060\":\"0\",\"f4010091\":\"6\",\"f409004\":\"0\",\"f5020030\":\"0\",\"f1010010\":\"129\",\"f5010060\":\"0\",\"f3020000\":\"0\",\"f5010079\":\"0\",\"f4010121\":\"11\",\"f5010078\":\"0\",\"f5010077\":\"0\",\"f5030101\":\"129&1000\",\"f5030102\":\"1120&1000\",\"f2010060\":\"7582422\",\"f5030103\":\"31698&1000\",\"f410004\":\"0\",\"f2010062\":\"2499\",\"f2010061\":\"c52f59c5\",\"f4010080\":\"1\",\"f5020020\":\"0\",\"f6010020\":\"com.snda.wifilocating\",\"f5010070\":\"0\",\"f5010076\":\"0\",\"f4010122\":\"1\",\"f5010075\":\"0\",\"f5010074\":\"0\",\"f4010031\":\"81\",\"f4010030\":\"2101\",\"f4010032\":\"1\",\"f7040080\":\"0\",\"f6010010\":\"c52f59c5\",\"f5020050\":\"0\",\"f6010090\":\"80088008880\",\"f5010082\":\"0\",\"f5010081\":\"0\",\"f5010080\":\"0\",\"f4010020\":\"223.104.175.86\",\"f412004\":\"0\",\"f7040090\":\"0\",\"f5020040\":\"0\",\"f5010090\":\"0\",\"f6060010\":\"1120&c52f59c5\",\"f6060011\":\"0\",\"f6060012\":\"0\",\"f6060013\":\"0\",\"f6060014\":\"1\",\"f6060015\":\"1\",\"f5010010\":\"010105\"}}";
            FeatureMapDo featureMapDo2 = JSON.parseObject(str2, FeatureMapDo.class);
            featureMap.put(31698L, featureMapDo2);
            System.out.println("start2:" + System.currentTimeMillis());
            Map<Long, Double> retMap = AdxRcmd.predict(featureMap, model2, CTR);
            System.out.println("end2:" + System.currentTimeMillis());
            System.out.println("retMap:" + JSON.toJSONString(retMap));


        } catch (Exception e) {
            e.printStackTrace();
        }


    }


    public static void testAdxWeight() throws Exception {

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);


        String key = "adx_mid_ftrl_fm_ctr_v006";
        String str = "{\"f6050010\":\"0\",\"f3010010\":\"9403\",\"f4010050\":\"HUAWEI\",\"f3010120\":\"1\",\"f2010030\":\"0\",\"f5020070\":\"22\",\"f6010070\":\"晋中\",\"f7020011\":\"0\",\"f6020050\":\"129&13\",\"f6010100\":\"1\",\"f2010020\":\"0\",\"f5020060\":\"0\",\"f3010010\":\"31746\",\"f5020101\":\"1\",\"f5020103\":\"0\",\"f5020102\":\"1\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f4010110\":\"1.2488125E7\",\"f4010070\":\"0\",\"f5020090\":\"0\",\"f2010010\":\"999\",\"f3010060\":\"720\",\"f5020010\":\"22\",\"f6010050\":\"中国\",\"f3010070\":\"1280\",\"f6050020\":\"40016,40026,40027,40029\",\"f6020070\":\"129&山西\",\"f4010060\":\"FIG-AL10\",\"f5020080\":\"0\",\"f1010020\":\"19\",\"f5010050\":\"95b0c59293d965aaaf672a348454ebf0\",\"f4010100\":\"4449421.5\",\"f6020080\":\"129&晋中\",\"f4010010\":\"Dalvik/2.1.0 (Linux; U; Android 9; FIG-AL10 Build/HUAWEIFIG-AL10)\",\"f7030011\":\"0\",\"f4010091\":\"0\",\"f5020030\":\"0\",\"f1010010\":\"129\",\"f7010010\":\"021111,0501101205,05011313,0503\",\"f7010011\":\"1\",\"f5010060\":\"9\",\"f3020000\":\"0\",\"f6020090\":\"129&平遥县\",\"f4010121\":\"12\",\"f5030101\":\"129&1000\",\"f5030102\":\"999&1000\",\"f5030103\":\"10972&1000\",\"f4010080\":\"2\",\"f5020020\":\"0\",\"f6010020\":\"com.hunting.matrix_callershow\",\"f6020010\":\"\",\"f5010070\":\"0\",\"f4010122\":\"1\",\"f4010031\":\"80\",\"f4010030\":\"1401\",\"f4010032\":\"2\",\"f6010010\":\"e3742d6c\",\"f5020050\":\"0\",\"f6010090\":\"10011001110\",\"f6020020\":\"\",\"f5010080\":\"9\",\"f4010020\":\"218.26.54.202\",\"f6020030\":\"0\",\"f5020040\":\"22\",\"f3010030\":\"0\",\"f5010090\":\"0\",\"f5010010\":\"O\"}\n";

        FM model = StdModelSave.getADXModelByKeyFromJedis(key, juOnline);
        Map<String, String> map = (Map) JSON.parse(str);
        Map ret = model.featureParamsTest(map);

        System.out.println("model:" + model.getUpdateTime() + " ,model_ps= " + model.getModelId() + " ,pre_ctr:" + model.predict(map));
        System.out.println("model params:" + JSON.toJSONString(model.getParamsDo()));
        System.out.println("model params:" + JSON.toJSONString(ret));

    }


    public static void testAdxCoder() throws Exception {

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("47.111.157.152");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);

        String fmKey = "adx_mid_ftrl_fm_ctr_v006";
        FM fmModel = StdModelSave.getADXModelByKeyFromJedis(fmKey, juOnline);
        System.out.println("model:" + fmKey + ",model.UpdateTime = " + fmModel.getUpdateTime() + " ,model_ps= " + fmModel.getModelId());
        StdModelSave.saveADXModelByKeyToJedis(fmKey, fmModel, juOffline);

        String key = "adx_click_value_coder_dqn_v001";
        CODER2 model = StdCoderModelSaveBo.getADXModelCoder2ByKeyFromJedis(key, juOnline);
        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
        System.out.println("model:" + key + ",model.UpdateTime = " + model.getUpdateTime() + " ,model_ps= " + model.getModelId());
        saveAdxModelCoder2ByKeyToJedis(key, model, juOffline);

        //saveAdxModelCoderByKeyToJedis(key, model, juOffline);
        //CODER model2 = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOffline);
        //System.out.println("model2:"  + key + ",model2.UpdateTime = "+ model2.getUpdateTime() + " ,model2_ps= " + model2.getModelId());


        //2 TF本地模型获取  缓存
        LocalTFModel ltfModel = new LocalTFModel();
        ltfModel.loadModel("C:\\Users\\wjw\\Desktop\\mid-adx-click-value-dqn-v001");


        //3 创意特征对象List
        List<AdxIdeaFeatureDo> ideaFeatureList = new ArrayList<>();
        AdxIdeaFeatureDo i1 = new AdxIdeaFeatureDo();
        i1.setIdeaId(15565L);
//        i1.setIdeaPicNum(1);
        ideaFeatureList.add(i1);

        /*AdxIdeaFeatureDo i2 = new AdxIdeaFeatureDo();
        i2.setIdeaId(14093L);
        i2.setIdeaPicNum(1);
        i2.setIdeaPicW1(60);
        i2.setIdeaPicH1(60);
        ideaFeatureList.add(i2);

        AdxIdeaFeatureDo i3 = new AdxIdeaFeatureDo();
        i3.setIdeaId(14463L);
        ideaFeatureList.add(i3);

        AdxIdeaFeatureDo i4 = new AdxIdeaFeatureDo();
        i4.setIdeaId(14672L);
        ideaFeatureList.add(i4);

        AdxIdeaFeatureDo i5 = new AdxIdeaFeatureDo();
        i5.setIdeaId(14772L);
        ideaFeatureList.add(i5);*/

        AdxFeatureDo adxFeatureDo = new AdxFeatureDo();
        adxFeatureDo.setResourceId(1285L);
        adxFeatureDo.setAreaCode(101L);
        adxFeatureDo.setImeiDayBidTimes(null);

        AdxIdeaRcmdRequestDo rcmdRequestDo = new AdxIdeaRcmdRequestDo();
        rcmdRequestDo.setStaticIdeaFeatureList(ideaFeatureList);
        rcmdRequestDo.setAdxFeatureDo(adxFeatureDo);
        rcmdRequestDo.setFmModel(fmModel);
        rcmdRequestDo.setCoderModel(model);
        rcmdRequestDo.setLtfModel(ltfModel);
        rcmdRequestDo.setPutType(3);
        //rcmdRequestDo.setManualIdeaId(14672L);

        /*List<AdxIdeaFeatureDo> ideaFeatureList2 = new ArrayList<>();
        AdxIdeaFeatureDo i6 = new AdxIdeaFeatureDo();
        i6.setIdeaId(15392L);
        i6.setMaterialId(1538L);
        ideaFeatureList2.add(i6);

        AdxIdeaFeatureDo i7 = new AdxIdeaFeatureDo();
        i7.setIdeaId(15392L);
        i7.setMaterialId(1584L);
        ideaFeatureList2.add(i7);
        rcmdRequestDo.setDynamicIdeaFeatureList(ideaFeatureList2);*/

        /*String str111 = "{\"ctrFilterList\":[1538,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612],\"materialSize\":31,\"materialStatsList\":[{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1538,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1584,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1585,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1586,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1587,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1588,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1589,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1590,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1591,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1592,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1593,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1594,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1595,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1596,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1597,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1598,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1599,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1600,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1601,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1602,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1603,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1604,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1605,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1606,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1607,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1608,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1609,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1610,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1611,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1612,\"rpm\":0.0,\"wilsonCtr\":0.0},{\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"click\":0,\"exp\":0,\"materialId\":1613,\"rpm\":0.0,\"wilsonCtr\":0.0}],\"rawList\":[1600,1601,1538,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599],\"recallList\":[1600,1601,1538,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599],\"rpmFilterList\":[1538,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612],\"tagFilterList\":[{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1538},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1584},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1585},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1586},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1587},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1588},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1589},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1590},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1591},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1592},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1593},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1594},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1595},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1596},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1597},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1598},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1599},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1600},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1601},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1602},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1603},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1604},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1605},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1606},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1607},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1608},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1609},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1610},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1611},{\"hitTag\":[],\"hitTagCnt\":0,\"materialId\":1612}],\"topTagList\":[]}";
        AdxMaterialRecallDo recallDo = JSONObject.parseObject(str111, AdxMaterialRecallDo.class);
        rcmdRequestDo.setMaterialRecallList(recallDo);*/

        String str = "{\"ideaParamsMap\":{15554:{\"advertConsume\":4213,\"adxConsume\":29217301455,\"bidPv\":11485,\"currentRoi\":1.347,\"currentTimes\":2239,\"fused\":false,\"giveUpRatio\":0.0,\"historyTimes\":2663,\"ideaId\":15554,\"lastUpdateTime\":\"20201109105002\",\"rpm\":0.06465,\"weight\":74.37},15564:{\"advertConsume\":1760,\"adxConsume\":21785986922,\"bidPv\":36602,\"currentRoi\":0.418,\"currentTimes\":1464,\"fused\":false,\"giveUpRatio\":0.0,\"historyTimes\":2270,\"ideaId\":15564,\"lastUpdateTime\":\"20201109105002\",\"rpm\":-0.0177,\"weight\":2.47},15565:{\"advertConsume\":1901,\"adxConsume\":18681485819,\"bidPv\":12145,\"currentRoi\":0.688,\"currentTimes\":2270,\"fused\":false,\"giveUpRatio\":0.06701295312499998,\"historyTimes\":2270,\"ideaId\":15565,\"lastUpdateTime\":\"20201109105002\",\"rpm\":-0.0177,\"weight\":23.01},15566:{\"advertConsume\":1962,\"adxConsume\":22124663984,\"bidPv\":9141,\"currentTimes\":0,\"fused\":true,\"giveUpRatio\":0.0,\"historyTimes\":2270,\"ideaId\":15566,\"lastUpdateTime\":\"20201109105002\",\"rpm\":-0.05535,\"weight\":0.017}}}";
        AdxResourceRcmdDo r1 = JSONObject.parseObject(str, AdxResourceRcmdDo.class);
        rcmdRequestDo.setAdxResourceRcmdDo(r1);

        AdxIdeaRcmdResultDo ret = IdeaRcmdAlg.getIdeaRcmd(rcmdRequestDo);
        System.out.println("RET:" + JSON.toJSONString(ret));

        /*String str11 = "{\"f3030090\":\"\",\"f4010050\":\"MEIZU\",\"f3010120\":\"1\",\"f5020070\":\"0\",\"f3030091\":\"\",\"f3030010\":\"\",\"f3030131\":\"\",\"f3030130\":\"\",\"f6010070\":\"\",\"f3030011\":\"\",\"f7020011\":\"0\",\"f6010100\":\"1\",\"f5020060\":\"0\",\"f3010010\":\"9983\",\"f3030081\":\"\",\"f3030080\":\"\",\"f3030120\":\"1&1917|1918|1923\",\"f5020101\":\"0\",\"f3030121\":\"\",\"f5020103\":\"0\",\"f5020102\":\"0\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f4010110\":\"0.0\",\"f4010070\":\"0\",\"f5020090\":\"0\",\"f3030071\":\"\",\"f3030070\":\"\",\"f2010010\":\"999\",\"f3010060\":\"640\",\"f5020010\":\"0\",\"f3030111\":\"\",\"f3030110\":\"\",\"f6010050\":\"中国\",\"f3010070\":\"960\",\"f4010060\":\"BOWAY-U12\",\"f5020080\":\"0\",\"f3030061\":\"\",\"f3030060\":\"\",\"f1010020\":\"19\",\"f3030101\":\"\",\"f3030100\":\"\",\"f5010050\":\"71b5a38efa32604e6f2fd743574f4987\",\"f7040050\":\"0\",\"f4010100\":\"0.0\",\"f4010010\":\"Apache-HttpClient/4.5.5 (Java/1.8.0_171)\",\"f7040060\":\"0\",\"f7030011\":\"0\",\"f3030050\":\"\",\"f3030171\":\"\",\"f3030170\":\"\",\"f4010091\":\"0\",\"f5020030\":\"0\",\"f3030051\":\"\",\"f1010010\":\"129\",\"f7010011\":\"0\",\"f5010060\":\"0\",\"f3020000\":\"0\",\"f4010121\":\"18\",\"f5030101\":\"129&1000\",\"f5030102\":\"999&1000\",\"f5030103\":\"9983&1000\",\"f3030160\":\"\",\"f4010080\":\"0\",\"f5020020\":\"0\",\"f3030041\":\"\",\"f3030040\":\"\",\"f3030161\":\"\",\"f6010020\":\"\",\"f5010070\":\"0\",\"f4010122\":\"4\",\"f4010031\":\"82\",\"f4010030\":\"3208\",\"f4010032\":\"3\",\"f7040080\":\"0\",\"f6010010\":\"dce366ea\",\"f5020050\":\"0\",\"f3030031\":\"\",\"f3030030\":\"\",\"f3030151\":\"\",\"f3030150\":\"\",\"f6010090\":\"10011001110\",\"f5010080\":\"0\",\"f4010020\":\"183.208.75.87\",\"f7040090\":\"0\",\"f5020040\":\"0\",\"f3010030\":\"0\",\"f3030021\":\"\",\"f3030020\":\"\",\"f3030141\":\"\",\"f3030140\":\"\",\"f5010090\":\"0\",\"f5010010\":\"010105\"}\n";
        FeatureMapDo featureMapDo = JSONObject.parseObject(str11, FeatureMapDo.class);
        Map<Long, Double> preClickValueMap = new HashMap<>();
        Map<Long, FeatureMapDo> featureMap = new HashMap<>();
        featureMap.put(9983L, featureMapDo);


        for (int i = 0; i < 1; ++i) {
            preClickValueMap = model.predictWithLocalTFNew(featureMap, ltfModel);
            if (AssertUtil.isEmpty(preClickValueMap) || preClickValueMap.size() == 0) {
                System.out.println("i:"  + i);
                System.out.println("RET11:"  + JSON.toJSONString(preClickValueMap));
            }
        }
        System.out.println("RET11:"  + JSON.toJSONString(preClickValueMap));
        System.out.println("RET11:"  + JSON.toJSONString(ltfModel.getVersion()));

        String str1111 = "f1010010:0;f2010010:47;f3010010:0;f4010030:0;f4010031:1;f4010032:1;f4010050:1;f4010060:1;f4010070:0;f4010080:13;f4010121:0;f4010122:0;f5010060:0;f5010070:0;f5010080:0;f5010090:0;f5020070:0;f5020080:0;f5020090:0;f5020104:0;f5020105:0;f5020106:0;f6010090:0;f6010100:1;f5030101:0;f5030102:1225;f4010091:1;f6010010:2;f6020040:2;f6020050:1;f3020000:1;f3020010:1;f3020020:1";
        Map<Long, String> fMap = new HashMap<>();
        fMap.put(15022L, str1111);
        System.out.println("RET12:"  + JSON.toJSONString(ltfModel.predictStr(fMap)));

        String str1112 = "f1010010:7;f2010010:117;f3010010:844;f4010030:124;f4010031:4;f4010032:4;f4010050:1;f4010060:1;f4010070:1;f4010080:10;f4010121:16;f4010122:5;f5010060:5;f5010070:1;f5010080:3;f5010090:1;f5020070:15;f5020080:1;f5020090:1;f5020104:202;f5020105:202;f5020106:202;f6010090:346;f6010100:1;f5030101:93;f5030102:1324;f4010091:4;f6010010:892;f6020040:2;f6020050:1;f3020000:1;f3020010:1;f3020020:1, 15023=f1010010:7;f2010010:117;f3010010:844;f4010030:124;f4010031:4;f4010032:4;f4010050:1;f4010060:1;f4010070:1;f4010080:10;f4010121:16;f4010122:5;f5010060:5;f5010070:1;f5010080:3;f5010090:1;f5020070:15;f5020080:1;f5020090:1;f5020104:202;f5020105:202;f5020106:202;f6010090:346;f6010100:1;f5030101:93;f5030102:1324;f4010091:4;f6010010:892;f6020040:2;f6020050:1;f3020000:1;f3020010:1;f3020020:1, 8955=f1010010:7;f2010010:117;f3010010:844;f4010030:124;f4010031:4;f4010032:4;f4010050:1;f4010060:1;f4010070:1;f4010080:10;f4010121:16;f4010122:5;f5010060:5;f5010070:1;f5010080:3;f5010090:1;f5020070:15;f5020080:1;f5020090:1;f5020104:202;f5020105:202;f5020106:202;f6010090:346;f6010100:1;f5030101:93;f5030102:1324;f4010091:4;f6010010:892;f6020040:2;f6020050:1;f3020000:1;f3020010:1;f3020020:1";
        Map<Long, String> fMap2 = new HashMap<>();
        fMap2.put(15022L, str1112);
        System.out.println("RET13:"  + JSON.toJSONString(fMap2));
        System.out.println("RET13:"  + JSON.toJSONString(ltfModel.predictStr(fMap2)));*/
    }


    public static void testModel() throws Exception {
        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);

        JedisConfig jcOffline = new JedisConfig();
        jcOffline.setIp("47.111.157.152");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);

        JedisConfig jcOfflineAdx = new JedisConfig();
        jcOfflineAdx.setIp("10.172.58.137");
        jcOfflineAdx.setPassWord("duiba123");
        jcOfflineAdx.setPort(6379);
        JedisUtil juOfflineAdx = new JedisUtil(jcOfflineAdx);

        JedisConfig jcOnlineAdx = new JedisConfig();
        jcOnlineAdx.setIp("r-bp1p7jdgwk8c6ybmzk.redis.rds.aliyuncs.com");
        jcOnlineAdx.setPassWord("pMuMLAD3g8K63k7qCKzZeZ7");
        jcOnlineAdx.setPort(6379);
        JedisUtil juOnlineAdx = new JedisUtil(jcOnlineAdx);

        String key = "adx_coder_v003";
        DeepModel deepModel = StdCoderSaveBo.getCoderByKeyFromJedis("adx", "TAE:ALGBID:MODEL:adx_coder_v001");
//        CODER codeModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOnline);
        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
        System.out.println("codeModel:" + key + ",codeModel.UpdateTime = " + deepModel.getUpdateTime() + " ,codeModel_ps= " + deepModel.getModelId());
        System.out.println("getFeatureList:" + deepModel.getFeatureList());
        DeepModelV2 deepModelV2 = StdCoderModelSaveBo.getADXModelFromRedis("TAE:ALGBID:MODEL:adx_coder_v003", DeepModelV2.class);




//        saveAdxModelCoderByKeyToJedis(key, codeModel, juOffline);

////        saveAdxModelCoderByKeyToJedis(key, codeModel, juOffline);

//        saveAdxModelCoderByKeyToJedisDeepModel(key, deepModel, juOfflineAdx); //deepModel
//        DeepModel deepModel2 = getADXDeepModelByKeyFromJedis(key, juOfflineAdx);
//        System.out.println("getFeatureList:" + deepModel2.getFeatureList());
//
        saveAdxModelCoderByKeyToJedisDeepModel(key, deepModelV2, juOfflineAdx); //deepModelV2
        DeepModel deepModelV22 = getADXDeepModelByKeyFromJedis(key, juOfflineAdx);
        System.out.println("getFeatureList:" + deepModelV22.getFeatureList());


//        CODER codeModel2 = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOffline);
//        System.out.println("codeModel2:"  + key + ",codeModel2.UpdateTime = "+ codeModel2.getUpdateTime() + " ,codeModel2_ps= " + codeModel2.getModelId());


        Map<Long, FeatureMapDo> featureMap = new HashMap<>();
        String str1 = "{\"dynamicFeatureMap\":{\"f3030011\":\"\",\"f3010010\":\"3837\",\"f307040\":\"0.0\",\"f3060017\":\"1\",\"f3060016\":\"1\",\"f307050\":\"0.0\",\"f3060013\":\"1\",\"f3060012\":\"1\",\"f3060015\":\"1\",\"f3060014\":\"1\",\"f3060011\":\"1\",\"f3060010\":\"3837&f0dd3041\",\"f3010144\":\"0\",\"f3010143\":\"0\",\"f3010142\":\"0\",\"f3010141\":\"0\",\"f3010145\":\"0\"},\"featureMap\":{\"f4010010\":\"Mozilla/5.0 (Linux; U; Androi d 2.3.6; zh-cn; GT-S5660 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1 MicroMessenger/4.5.255\",\"f7040060\":\"0\",\"f411004\":\"0\",\"f4010050\":\"华为\",\"f4010091\":\"0\",\"f409004\":\"0\",\"f5020070\":\"0\",\"f5020030\":\"0\",\"f1010010\":\"364\",\"f309040\":\"0.0\",\"f5010060\":\"0\",\"f3020000\":\"0\",\"f5010036\":\"0\",\"f5010079\":\"0\",\"f414004\":\"0\",\"f5010035\":\"0\",\"f5010078\":\"0\",\"f4010121\":\"16\",\"f5010034\":\"0\",\"f5010077\":\"0\",\"f5010033\":\"0\",\"f5030101\":\"364&1000\",\"f5030102\":\"1503&1000\",\"f5030103\":\"3837&1000\",\"f2010060\":\"8523123\",\"f410004\":\"0\",\"f2010062\":\"2402\",\"f6010100\":\"1\",\"f2010061\":\"f0dd3041\",\"f3010010\":\"3837\",\"f4010080\":\"1\",\"f5020060\":\"0\",\"f5020020\":\"0\",\"f5020101\":\"0\",\"f309050\":\"0.0\",\"f5020103\":\"0\",\"f6010020\":\"com.shyz.toutiao\",\"f5020102\":\"0\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f5010070\":\"0\",\"f5010076\":\"0\",\"f5010075\":\"0\",\"f4010122\":\"4\",\"f5010074\":\"0\",\"f4010030\":\"0\",\"f4010070\":\"1\",\"f413004\":\"0\",\"f7040080\":\"0\",\"f3010144\":\"0\",\"f3010143\":\"0\",\"f5020090\":\"0\",\"f3010142\":\"0\",\"f6010010\":\"f0dd3041\",\"f3010141\":\"0\",\"f5020050\":\"0\",\"f2010010\":\"1503\",\"f5020010\":\"0\",\"f6010090\":\"10001010001010100\",\"f3010145\":\"0\",\"f307040\":\"0.0\",\"f5010082\":\"0\",\"f5010081\":\"0\",\"f5010080\":\"0\",\"f4010020\":\"127.0.0.1\",\"f412004\":\"0\",\"f4010060\":\"ldn-al20\",\"f7040090\":\"0\",\"f5020080\":\"0\",\"f5020040\":\"0\",\"f1010020\":\"19\",\"f3060017\":\"1\",\"f5010090\":\"0\",\"f3060016\":\"1\",\"f6060010\":\"1503&f0dd3041\",\"f6060011\":\"0\",\"f307050\":\"0.0\",\"f6060012\":\"0\",\"f3060013\":\"1\",\"f6060013\":\"0\",\"f5010050\":\"00322e329d44e4d7ada38c4df80011da\",\"f3060012\":\"1\",\"f6060014\":\"1\",\"f3060015\":\"1\",\"f6060015\":\"1\",\"f7040050\":\"0\",\"f3060014\":\"1\",\"f5010010\":\"010105\",\"f3060011\":\"1\",\"f3060010\":\"3837&f0dd3041\"},\"staticFeatureMap\":{\"f4010050\":\"华为\",\"f411004\":\"0\",\"f5020070\":\"0\",\"f6010070\":\"\",\"f309040\":\"0.0\",\"f5010036\":\"0\",\"f5010035\":\"0\",\"f414004\":\"0\",\"f5010034\":\"0\",\"f5010033\":\"0\",\"f6010100\":\"1\",\"f5020060\":\"0\",\"f5020101\":\"0\",\"f5020103\":\"0\",\"f309050\":\"0.0\",\"f5020102\":\"0\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f4010070\":\"1\",\"f413004\":\"0\",\"f5020090\":\"0\",\"f2010010\":\"1503\",\"f5020010\":\"0\",\"f4010060\":\"ldn-al20\",\"f5020080\":\"0\",\"f1010020\":\"19\",\"f5010050\":\"00322e329d44e4d7ada38c4df80011da\",\"f7040050\":\"0\",\"f4010010\":\"Mozilla/5.0 (Linux; U; Androi d 2.3.6; zh-cn; GT-S5660 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1 MicroMessenger/4.5.255\",\"f7040060\":\"0\",\"f4010091\":\"0\",\"f409004\":\"0\",\"f5020030\":\"0\",\"f1010010\":\"364\",\"f5010060\":\"0\",\"f3020000\":\"0\",\"f5010079\":\"0\",\"f4010121\":\"16\",\"f5010078\":\"0\",\"f5010077\":\"0\",\"f5030101\":\"364&1000\",\"f5030102\":\"1503&1000\",\"f2010060\":\"8523123\",\"f5030103\":\"3837&1000\",\"f410004\":\"0\",\"f2010062\":\"2402\",\"f2010061\":\"f0dd3041\",\"f4010080\":\"1\",\"f5020020\":\"0\",\"f6010020\":\"com.shyz.toutiao\",\"f5010070\":\"0\",\"f5010076\":\"0\",\"f4010122\":\"4\",\"f5010075\":\"0\",\"f5010074\":\"0\",\"f4010030\":\"0\",\"f7040080\":\"0\",\"f6010010\":\"f0dd3041\",\"f5020050\":\"0\",\"f6010090\":\"10001010001010100\",\"f5010082\":\"0\",\"f5010081\":\"0\",\"f5010080\":\"0\",\"f4010020\":\"127.0.0.1\",\"f5010135\":\"\",\"f5010134\":\"\",\"f5010133\":\"\",\"f4010021\":\"\",\"f412004\":\"0\",\"f7040090\":\"0\",\"f5010136\":\"\",\"f5020040\":\"0\",\"f5010090\":\"0\",\"f6060010\":\"1503&f0dd3041\",\"f6060011\":\"0\",\"f6060012\":\"0\",\"f6060013\":\"0\",\"f6060014\":\"1\",\"f6060015\":\"1\",\"f5010010\":\"010105\"}}";
        FeatureMapDo featureMapDo2 = JSON.parseObject(str1, FeatureMapDo.class);
        featureMap.put(3837L, featureMapDo2);

        LocalTFModel launchModelTF = new LocalTFModel();
        launchModelTF.loadModel("/Users/wjw/Desktop/mid-adx-launch-fm-v003", "1652694124");
        LocalTFModel arpuModelTF = new LocalTFModel();
        arpuModelTF.loadModel("/Users/wjw/Desktop/mid-adx-arpu-fm-v003", "1652692928");

        LocalTFModelV2 launchModelTFV2 = new LocalTFModelV2();
        launchModelTFV2.loadModel("/Users/lwj/Desktop/mid-adx-click-fm-v003", null);
        LocalTFModelV2 arpuModelTFV2 = new LocalTFModelV2();

//        arpuModelTFV2.loadModel("/Users/lwj/Desktop/mid-adx-click-fm-v003", null);//"202206021806" /Users/lwj/Documents/pythonProjectFiles/tf/data/serving-model/mt_click_test_19
//
//        arpuModelTFV2.loadModel("/Users/wjw/Desktop/mid-adx-arpu-fm-v004", "202205190900");
        LocalTFModelV2 clickModelTFV2 = new LocalTFModelV2();
        clickModelTFV2.loadModel("/Users/wjw/Desktop/mid-adx-click-fm-v003");


        Model model = new Model();
//        model.setLaunchPvCoder(deepModel);
//        model.setLaunchPvTFModel(launchModelTF);
//        model.setARPUCoder(deepModel);
//        model.setArpuTFModel(arpuModelTF);

        model.setLaunchPvCoderV2(deepModelV2);
        model.setLaunchPvTFModelV2(launchModelTFV2);

        model.setARPUCoderV2(deepModelV2);
        model.setArpuTFModelV2(arpuModelTFV2);
        model.setARPUCoderV2(deepModelV2);
        model.setArpuTFModelV2(clickModelTFV2);


//        Map<Long, Double> launchPreValue = AdxRcmd.predict(featureMap, model, PredictType.PVLAUNCH);
//        System.out.println("launchPreValue: " + launchPreValue);
//        Map<Long, Double> arpuPreValue = AdxRcmd.predict(featureMap, model, PredictType.ARPU);
//        System.out.println("arpuPreValue: " + arpuPreValue);
        Map<Long, Double> launchPreValueV2 = AdxRcmd.predict(featureMap, model, PredictType.PVLAUNCHV2);
        System.out.println("launchPreValueV2: " + launchPreValueV2);
        Map<Long, Double> arpuPreValueV2 = AdxRcmd.predict(featureMap, model, PredictType.ARPUV2);
        System.out.println("arpuPreValueV2: " + arpuPreValueV2);
        Map<Long, Double> clickPreValueV2 = AdxRcmd.predict(featureMap, model, PredictType.CLICKPV);
        System.out.println("clickPreValueV2: " + clickPreValueV2);

    }



    @Test
    public void testAdxFilter() throws Exception {

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("47.111.157.152");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);

//        String fmKey = "adx_mid_ftrl_fm_ctr_v005";
//        FM fmModel = StdModelSave.getADXModelByKeyFromJedis(fmKey, juOnline);

        String key = "mid_adx_launch_pv_sample_dqn_v013";
//        CODER codeModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOnline);
//        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
//        System.out.println("codeModel:"  + key + ",codeModel.UpdateTime = "+ codeModel.getUpdateTime() + " ,codeModel_ps= " + codeModel.getModelId());
//
//        saveAdxModelCoderByKeyToJedis(key, codeModel, juOffline);
        CODER codeModel2 = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOffline);
        System.out.println("codeModel2:" + key + ",codeModel2.UpdateTime = " + codeModel2.getUpdateTime() + " ,codeModel2_ps= " + codeModel2.getModelId());

//        String key22 = "adx_charge_pv_coder_dqn_v001";
//        CODER2 codeModel22 = StdCoderModelSaveBo.getADXModelCoder2ByKeyFromJedis(key22, juOnline);
//        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
//        System.out.println("codeModel22:"  + key22 + ",codeModel22.UpdateTime = "+ codeModel22.getUpdateTime() + " ,codeModel22_ps= " + codeModel22.getModelId());

        //saveAdxModelCoder2ByKeyToJedis(key22, codeModel22, juOffline);
        //CODER2 codeModel221 = StdCoderModelSaveBo.getADXModelCoder2ByKeyFromJedis(key22, juOffline);
        //System.out.println("codeModel221:"  + key22 + ",codeModel221.UpdateTime = "+ codeModel221.getUpdateTime() + " ,codeModel221_ps= " + codeModel221.getModelId());


        //2 TF本地模型获取  缓存
        LocalTFModel ltfModel = new LocalTFModel();
        //ltfModel.loadModel("C:\\Users\\wjw\\Desktop\\mid-adx-launch-pv-dqn-v002");
        ltfModel.loadModel("/Users/pengzhixiong/Downloads/testArpuModel/arpu_old");

//        LocalTFModel ltfModel2 = new LocalTFModel();
        //ltfModel2.loadModel("C:\\Users\\wjw\\Desktop\\mid-adx-charge-pv-dqn-v001");
/*
        TFServingClient tfServingClient = new TFServingClient("10.50.203.154", 9000, "deepfm-e2e-ctr-101", null);

        String str1 = "{\"f9702\": \"0\",\"f205002\": \"1378\",\"f205001\": \"10\",\"f404003\": \"workother\",\"f701002\": \"1061874\"}";
        Map<String, String> featureIdxMap1 = (Map) JSON.parseObject(str1);
        String str2 = "{\"f101001\":\"69442\"}";
        Map<String, String> featureIdxMap2 = (Map) JSON.parseObject(str2);

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureIdxMap1);
        featureMapDo.setDynamicFeatureMap(featureIdxMap2);
        Map<String, FeatureMapDo> featureMap = new HashMap<>();
        featureMap.put("69442", featureMapDo);

        //Map<String, Double> ret = coderModel.predictWithTFNew(featureMap, tfServingClient);
        Map<String, Double> ret = coderModel.predictWithLocalTFNew(featureMap, ltfModel);
        System.out.println(JSON.toJSONString(ret));

*/
        String str11 = "{\"f9702\": \"0\",\"f205002\": \"1378\",\"f205001\": \"10\",\"f404003\": \"workother\",\"f701002\": \"1061874\"}";
        Map<String, String> featureIdxMap1 = (Map) JSON.parseObject(str11);
        String str21 = "{\"f101001\":\"69442\"}";
        Map<String, String> featureIdxMap2 = (Map) JSON.parseObject(str21);

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureIdxMap1);
        featureMapDo.setDynamicFeatureMap(featureIdxMap2);
//        Map<String, FeatureMapDo> featureMap = new HashMap<>();
//        featureMap.put("69442", featureMapDo);


        //3
        AdxFeatureDo adxFeatureDo = new AdxFeatureDo();
        adxFeatureDo.setGroupId(129L);
        adxFeatureDo.setResourceId(999L);
        adxFeatureDo.setIdeaId(9983L);
//        adxFeatureDo.setIdeaPicNum(1);
        adxFeatureDo.setAreaCode(3301L);


        //4.
        String str1 = "{\"currentPreValue\":0.07,\"historyImeiBid\":7,\"historyImeiExp\":0,\"historyImeiClick\":0,\"groupId\":157,\"ideaDayStats\":{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},\"ideaHourStats\":{},\"ideaId\":1953,\"minRoi\":1.1,\"preIntervalDayStats\":{1:{},2:{},3:{},4:{},5:{},6:{}},\"preIntervalHourStats\":{1:{},2:{},3:{},4:{},5:{},6:{}},\"resoPreIntervalDayStats\":{0:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},1:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},2:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},3:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},4:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},5:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},6:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},7:{},8:{},9:{},10:{},11:{},12:{},13:{},14:{},15:{}},\"resoPreIntervalHourStats\":{0:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},1:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},2:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},3:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},4:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},5:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},6:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},7:{},8:{},9:{},10:{},11:{},12:{},13:{},14:{},15:{}},\"resourceId\":917,\"testRate\":{1:14,2:13,3:74}}";
        //AdxFlowInfoDo flowInfoDo1 = new AdxFlowInfoDo();
        AdxFlowInfoDo flowInfoDo1 = JSONObject.parseObject(str1, AdxFlowInfoDo.class);
        flowInfoDo1.setIdeaMinStats(flowInfoDo1.getIdeaDayStats());

        String str2 = "{\"ctrDayInterval\":{},\"ctrHourInterval\":{},\"currentMinRoi\":1.0,\"dayConfident\":false,\"filterMap\":{1:0.0,2:0.9,3:0.9,4:0.9,5:0.0,6:0.0},\"roiDayInterval\":{},\"roiHourInterval\":{}}";
        //AdxFilterInfoDo filterInfoDo1 = new AdxFilterInfoDo();
        AdxFilterInfoDo filterInfoDo1 = JSONObject.parseObject(str2, AdxFilterInfoDo.class);

        String str3 = "{\"ctrDayInterval\":{0:0.75,1:0.75,2:0.75,3:0.75,4:0.75,5:0.75,6:0.75},\"ctrHourInterval\":{0:0.75,1:0.75,2:0.75,3:0.75,4:0.75,5:0.75,6:0.75},\"currentMinRoi\":1.1,\"dayConfident\":false,\"filterMap\":{0:0.0,1:0.0,2:0.0,3:0.0,4:0.0,5:0.0,6:0.0,7:0.0,8:0.0,9:0.0,10:0.0,11:0.0,12:0.9,13:0.0,14:0.0,15:0.0},\"roiDayInterval\":{0:1.5,1:1.5,2:1.5,3:1.5,4:1.5,5:1.5,6:1.5},\"roiHourInterval\":{0:1.5,1:1.5,2:1.5,3:1.5,4:1.5,5:1.5,6:1.5}}";
        //AdxFilterInfoDo filterInfoDo2 = new AdxFilterInfoDo();
        AdxFilterInfoDo filterInfoDo2 = JSONObject.parseObject(str3, AdxFilterInfoDo.class);

        FlowFilterRequestDo flowFilterRequestDo = new FlowFilterRequestDo();
        flowFilterRequestDo.setFlowInfo(flowInfoDo1);
        flowFilterRequestDo.setFilterInfo1(filterInfoDo1);
        flowFilterRequestDo.setFilterInfo2(filterInfoDo2);
        flowFilterRequestDo.setGroupTag(7);

        flowFilterRequestDo.setPreCtr(0.10);
        flowFilterRequestDo.setFeatureMapDo(featureMapDo);
        flowFilterRequestDo.setLaunchPvCoderModel(codeModel2);
        flowFilterRequestDo.setLaunchPvLtfModel(ltfModel);
        flowFilterRequestDo.setAdxFeatureDo(adxFeatureDo);

        flowFilterRequestDo.setLaunchPvLimit(3.8);
        flowFilterRequestDo.setAlgoBidMode(2);

//        flowFilterRequestDo.setChargePvCoderModel(codeModel22);
//        flowFilterRequestDo.setChargePvLtfModel(ltfModel2);
//        flowFilterRequestDo.setChargePvLimit(2.0);

        flowFilterRequestDo.setBaseFilterFlag(1);
        flowFilterRequestDo.setFlowGroup(2);


        for (int i = 0; i < 15; ++i) {
            long t1 = System.currentTimeMillis();
            FlowFilterResultDo result = AdxFlowFilterAlg.adxFlowFiltering(flowFilterRequestDo, null);
            //FlowFilterResultDo result = LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
            long t2 = System.currentTimeMillis();
            System.out.println("launchPv time cost: " + (t2 - t1));
//            System.out.println(JSON.toJSONString(result));
        }
//        ltfModel.close();
//        System.out.println(getMemory());


//        FlowFilterResultDo result = AdxFlowFilterAlg.adxFlowFiltering(flowFilterRequestDo, null);
//        //FlowFilterResultDo result = LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
//        System.out.println(JSON.toJSONString(result));


    }


    @Test
    public void testAdxDeepModel() throws Exception {

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("47.111.157.152");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);

//        String fmKey = "adx_mid_ftrl_fm_ctr_v005";
//        FM fmModel = StdModelSave.getADXModelByKeyFromJedis(fmKey, juOnline);

        String key = "TAE:ALGBID:MODEL:adx_coder_v001";
//        CODER codeModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOnline);
//        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
//        System.out.println("codeModel:"  + key + ",codeModel.UpdateTime = "+ codeModel.getUpdateTime() + " ,codeModel_ps= " + codeModel.getModelId());
//
//        saveAdxModelCoderByKeyToJedis(key, codeModel, juOffline);
//        CODER codeModel2 = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOffline);
        DeepModel codeModel2 = StdCoderSaveBo.getCoderByKeyFromJedis("adx", key);
        System.out.println("codeModel2:" + key + ",codeModel2.UpdateTime = " + codeModel2.getUpdateTime() + " ,codeModel2_ps= " + codeModel2.getModelId() + " featureList: " + codeModel2.getFeatureList());

//        String key22 = "adx_charge_pv_coder_dqn_v001";
//        CODER2 codeModel22 = StdCoderModelSaveBo.getADXModelCoder2ByKeyFromJedis(key22, juOnline);
//        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
//        System.out.println("codeModel22:"  + key22 + ",codeModel22.UpdateTime = "+ codeModel22.getUpdateTime() + " ,codeModel22_ps= " + codeModel22.getModelId());

        //saveAdxModelCoder2ByKeyToJedis(key22, codeModel22, juOffline);
        //CODER2 codeModel221 = StdCoderModelSaveBo.getADXModelCoder2ByKeyFromJedis(key22, juOffline);
        //System.out.println("codeModel221:"  + key22 + ",codeModel221.UpdateTime = "+ codeModel221.getUpdateTime() + " ,codeModel221_ps= " + codeModel221.getModelId());


        //2 TF本地模型获取  缓存
        LocalTFModel ltfModel = new LocalTFModel();
        //ltfModel.loadModel("C:\\Users\\wjw\\Desktop\\mid-adx-launch-pv-dqn-v002");
        ltfModel.loadModel("/Users/pengzhixiong/Downloads/testArpuModel/arpu_opt");

//        LocalTFModel ltfModel2 = new LocalTFModel();
        //ltfModel2.loadModel("C:\\Users\\wjw\\Desktop\\mid-adx-charge-pv-dqn-v001");
/*
        TFServingClient tfServingClient = new TFServingClient("10.50.203.154", 9000, "deepfm-e2e-ctr-101", null);

        String str1 = "{\"f9702\": \"0\",\"f205002\": \"1378\",\"f205001\": \"10\",\"f404003\": \"workother\",\"f701002\": \"1061874\"}";
        Map<String, String> featureIdxMap1 = (Map) JSON.parseObject(str1);
        String str2 = "{\"f101001\":\"69442\"}";
        Map<String, String> featureIdxMap2 = (Map) JSON.parseObject(str2);

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureIdxMap1);
        featureMapDo.setDynamicFeatureMap(featureIdxMap2);
        Map<String, FeatureMapDo> featureMap = new HashMap<>();
        featureMap.put("69442", featureMapDo);

        //Map<String, Double> ret = coderModel.predictWithTFNew(featureMap, tfServingClient);
        Map<String, Double> ret = coderModel.predictWithLocalTFNew(featureMap, ltfModel);
        System.out.println(JSON.toJSONString(ret));

*/
        String str11 = "{\"f9702\": \"0\",\"f205002\": \"1378\",\"f205001\": \"10\",\"f404003\": \"workother\",\"f701002\": \"1061874\"}";
        Map<String, String> featureIdxMap1 = (Map) JSON.parseObject(str11);
        String str21 = "{\"f101001\":\"69442\"}";
        Map<String, String> featureIdxMap2 = (Map) JSON.parseObject(str21);

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureIdxMap1);
        featureMapDo.setDynamicFeatureMap(featureIdxMap2);
//        Map<String, FeatureMapDo> featureMap = new HashMap<>();
//        featureMap.put("69442", featureMapDo);


        //3
        AdxFeatureDo adxFeatureDo = new AdxFeatureDo();
        adxFeatureDo.setGroupId(129L);
        adxFeatureDo.setResourceId(999L);
        adxFeatureDo.setIdeaId(9983L);
//        adxFeatureDo.setIdeaPicNum(1);
        adxFeatureDo.setAreaCode(3301L);


        //4.
        String str1 = "{\"currentPreValue\":0.07,\"historyImeiBid\":7,\"historyImeiExp\":0,\"historyImeiClick\":0,\"groupId\":157,\"ideaDayStats\":{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},\"ideaHourStats\":{},\"ideaId\":1953,\"minRoi\":1.1,\"preIntervalDayStats\":{1:{},2:{},3:{},4:{},5:{},6:{}},\"preIntervalHourStats\":{1:{},2:{},3:{},4:{},5:{},6:{}},\"resoPreIntervalDayStats\":{0:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},1:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},2:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},3:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},4:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},5:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},6:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},7:{},8:{},9:{},10:{},11:{},12:{},13:{},14:{},15:{}},\"resoPreIntervalHourStats\":{0:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},1:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},2:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},3:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},4:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},5:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},6:{\"advertClick\":800,\"advertConsume\":60000,\"advertLaunch\":900,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},7:{},8:{},9:{},10:{},11:{},12:{},13:{},14:{},15:{}},\"resourceId\":917,\"testRate\":{1:14,2:13,3:74}}";
        //AdxFlowInfoDo flowInfoDo1 = new AdxFlowInfoDo();
        AdxFlowInfoDo flowInfoDo1 = JSONObject.parseObject(str1, AdxFlowInfoDo.class);
        flowInfoDo1.setIdeaMinStats(flowInfoDo1.getIdeaDayStats());

        String str2 = "{\"ctrDayInterval\":{},\"ctrHourInterval\":{},\"currentMinRoi\":1.0,\"dayConfident\":false,\"filterMap\":{1:0.0,2:0.9,3:0.9,4:0.9,5:0.0,6:0.0},\"roiDayInterval\":{},\"roiHourInterval\":{}}";
        //AdxFilterInfoDo filterInfoDo1 = new AdxFilterInfoDo();
        AdxFilterInfoDo filterInfoDo1 = JSONObject.parseObject(str2, AdxFilterInfoDo.class);

        String str3 = "{\"ctrDayInterval\":{0:0.75,1:0.75,2:0.75,3:0.75,4:0.75,5:0.75,6:0.75},\"ctrHourInterval\":{0:0.75,1:0.75,2:0.75,3:0.75,4:0.75,5:0.75,6:0.75},\"currentMinRoi\":1.1,\"dayConfident\":false,\"filterMap\":{0:0.0,1:0.0,2:0.0,3:0.0,4:0.0,5:0.0,6:0.0,7:0.0,8:0.0,9:0.0,10:0.0,11:0.0,12:0.9,13:0.0,14:0.0,15:0.0},\"roiDayInterval\":{0:1.5,1:1.5,2:1.5,3:1.5,4:1.5,5:1.5,6:1.5},\"roiHourInterval\":{0:1.5,1:1.5,2:1.5,3:1.5,4:1.5,5:1.5,6:1.5}}";
        //AdxFilterInfoDo filterInfoDo2 = new AdxFilterInfoDo();
        AdxFilterInfoDo filterInfoDo2 = JSONObject.parseObject(str3, AdxFilterInfoDo.class);

        FlowFilterRequestDo flowFilterRequestDo = new FlowFilterRequestDo();
        flowFilterRequestDo.setFlowInfo(flowInfoDo1);
        flowFilterRequestDo.setFilterInfo1(filterInfoDo1);
        flowFilterRequestDo.setFilterInfo2(filterInfoDo2);
        flowFilterRequestDo.setGroupTag(7);

        flowFilterRequestDo.setPreCtr(0.10);
        flowFilterRequestDo.setFeatureMapDo(featureMapDo);
        flowFilterRequestDo.setLaunchCoderModel(codeModel2);
        flowFilterRequestDo.setLaunchPvLtfModel(ltfModel);
        flowFilterRequestDo.setAdxFeatureDo(adxFeatureDo);

        flowFilterRequestDo.setLaunchPvLimit(3.8);
        flowFilterRequestDo.setAlgoBidMode(2);

//        flowFilterRequestDo.setChargePvCoderModel(codeModel22);
//        flowFilterRequestDo.setChargePvLtfModel(ltfModel2);
//        flowFilterRequestDo.setChargePvLimit(2.0);

        flowFilterRequestDo.setBaseFilterFlag(1);
        flowFilterRequestDo.setFlowGroup(2);


        for (int i = 0; i < 15; ++i) {
            long t1 = System.currentTimeMillis();
            FlowFilterResultDo result = AdxFlowFilterAlg.adxFlowFiltering(flowFilterRequestDo, null);
//            FlowFilterResultDo result = LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
            long t2 = System.currentTimeMillis();
            System.out.println("launchPv time cost: " + (t2 - t1));
            System.out.println(JSON.toJSONString(result));
        }
//        ltfModel.close();
//        System.out.println(getMemory());


//        FlowFilterResultDo result = AdxFlowFilterAlg.adxFlowFiltering(flowFilterRequestDo, null);
//        //FlowFilterResultDo result = LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
//        System.out.println(JSON.toJSONString(result));


    }


    public static boolean getMemory() {
        // 虚拟机级内存情况查询
        long vmFree = 0;
        long vmUse = 0;
        long vmTotal = 0;
        long vmMax = 0;
        int byteToMb = 1024 * 1024;
        Runtime rt = Runtime.getRuntime();
        vmTotal = rt.totalMemory() / byteToMb;
        vmFree = rt.freeMemory() / byteToMb;
        vmMax = rt.maxMemory() / byteToMb;
        vmUse = vmTotal - vmFree;
        System.out.println("JVM内存已用的空间为：" + vmUse + " MB");
        System.out.println("JVM内存的空闲空间为：" + vmFree + " MB");
        System.out.println("JVM总内存空间为：" + vmTotal + " MB");
        System.out.println("JVM总内存空间为：" + vmMax + " MB");

        System.out.println("======================================");
        // 操作系统级内存情况查询
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();
        String os = System.getProperty("os.name");
        long physicalFree = osmxb.getFreePhysicalMemorySize() / byteToMb;
        long physicalTotal = osmxb.getTotalPhysicalMemorySize() / byteToMb;
        long physicalUse = physicalTotal - physicalFree;
        System.out.println("操作系统的版本：" + os);
        System.out.println("操作系统物理内存已用的空间为：" + physicalFree + " MB");
        System.out.println("操作系统物理内存的空闲空间为：" + physicalUse + " MB");
        System.out.println("操作系统总物理内存：" + physicalTotal + " MB");

        // 获得线程总数
        ThreadGroup parentThread;
        int totalThread = 0;
        for (parentThread = Thread.currentThread().getThreadGroup(); parentThread
                .getParent() != null; parentThread = parentThread.getParent()) {
            totalThread = parentThread.activeCount();
        }
        System.out.println("获得线程总数:" + totalThread);
        return false;
    }


    /**
     * @param modelKey
     * @param CODER
     * @return
     */
    public static void saveAdxModelCoderByKeyToJedis(String modelKey, CODER CODER, JedisUtil redis) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, CODER)) {
            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = "TAE:ALGBID:MODEL:" + modelKey;
            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(CODER);
            String value2 = StringZIP.zipString(value); //压缩

            redis.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveAdxModelCoderByKeyToJedisDeepModel(String modelKey, DeepModel deepModel, JedisUtil redis) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, deepModel)) {
            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = "TAE:ALGBID:MODEL:" + modelKey;
            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(deepModel);
            String value2 = StringZIP.zipString(value); //压缩

            redis.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveAdxModelCoderByKeyToJedisDeepModel(String modelKey, DeepModelV2 deepModel, JedisUtil redis) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, deepModel)) {
            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = "TAE:ALGBID:MODEL:" + modelKey;
            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(deepModel);
            String value2 = StringZIP.zipString(value); //压缩

            redis.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * @param modelKey
     * @param CODER2
     * @return
     */
    public static void saveAdxModelCoder2ByKeyToJedis(String modelKey, CODER2 CODER2, JedisUtil redis) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, CODER2)) {
            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = "TAE:ALGBID:MODEL:" + modelKey;
            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(CODER2);
            String value2 = StringZIP.zipString(value); //压缩

            redis.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * @param modelId
     * @return
     */
    public static OcpxControlSubModel readModelFromRedis2(String modelId, int a) {

        String key = "NZ_K112_1_72943_177246";
        OcpxControlSubModel ret = null;
        System.out.println("readModelFromRedis key=" + key);

        try {
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压

            // 解压
            ret = JSON.parseObject(ret2, OcpxControlSubModel.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     * @param modelId
     * @return
     */
    public static RoiControlModel readModelFromRedis3(String modelId, int a) {

        String key = "NZ_K86_nz_alg_s_m_slot_stat_model_v101";
        RoiControlModel ret = null;
        System.out.println("readModelFromRedis key=" + key);

        try {
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压

            // 解压
            ret = JSON.parseObject(ret2, RoiControlModel.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }



    /**
     * @param modelKey
     * @return
     */
    public static DeepModel getADXDeepModelByKeyFromJedis(String modelKey, JedisUtil redis) {
        DeepModel ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = "TAE:ALGBID:MODEL:" + modelKey;
            System.out.println("read model with key=" + key);
            // 保存


            String ret1 = null;

            ret1 = redis.get(key);

            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, DeepModel.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

}
