/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFeatureParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(AdxFeatureParse.class);
    public static Integer[] HUABEI_REGION = new Integer[]{80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = new Integer[]{81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = new Integer[]{82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = new Integer[]{83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = new Integer[]{84, 44, 45, 46};
    public static Integer[] XINAN_REGION = new Integer[]{85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = new Integer[]{86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = new Integer[]{87, 71, 8100, 8200};
    public static Integer[] FIRST_TIER_CITY = new Integer[]{11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = new Integer[]{1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = new Integer[]{1309, 1303, 1502, 2202, 3207, 3209, 3305, 3412, 3509, 3611, 3708, 3703, 4114, 4110, 4210, 4307, 4306, 4407, 4408, 4601, 5107, 6104, 1304, 1302, 1501, 2306, 3212, 3210, 3403, 3407, 3503, 3607, 3609, 3713, 4103, 4107, 4108, 4206, 4304, 4302, 4452, 4412, 4503, 4602, 5203, 6301, 1310, 1305, 2103, 3208, 3213, 3211, 3411, 3402, 3506, 3604, 3717, 3710, 4113, 4115, 4211, 4205, 4303, 4451, 4405, 4404, 4502, 5106, 5303, 6401};

    public static Map<String, String> generateFeatureMapStatic(AdxFeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                cf.setCurrentCreatTime(AdxFeatureParse.getStringToTimeStamp());
                retMap.put("f1010010", DataUtil.Long2String((Long)cf.getGroupId()));
                retMap.put("f1010020", DataUtil.Integer2String((Integer)cf.getAdxType()));
                retMap.put("f1010030", cf.getCat());
                retMap.put("f1010031", cf.getTuiaCat());
                retMap.put("f1010040", cf.getSectionCat());
                retMap.put("f1010041", cf.getTuiaSectionCat());
                retMap.put("f1010050", cf.getKeywords());
                retMap.put("f2010010", DataUtil.Long2String((Long)cf.getResourceId()));
                retMap.put("f2010020", DataUtil.Integer2String((Integer)cf.getAdvertType()));
                retMap.put("f2010030", DataUtil.Integer2String((Integer)cf.getPosType()));
                retMap.put("f2010040", DataUtil.Integer2String((Integer)cf.getPosStyle()));
                retMap.put("f4010010", cf.getUa());
                retMap.put("f4010020", cf.getIp());
                retMap.put("f4010030", DataUtil.Long2String((Long)cf.getAreaCode()));
                Long regionLevel = AdxFeatureParse.getRegionLevel(cf.getAreaCode());
                retMap.put("f4010031", DataUtil.Long2String((Long)regionLevel));
                Long tierCityLevel = AdxFeatureParse.getTierCityLevel(cf.getAreaCode());
                retMap.put("f4010032", DataUtil.Long2String((Long)tierCityLevel));
                retMap.put("f4010040", DataUtil.Integer2String((Integer)cf.getDeviceType()));
                retMap.put("f4010041", DataUtil.Integer2String((Integer)cf.getTuiaDeviceType()));
                retMap.put("f4010050", cf.getMake());
                retMap.put("f4010060", cf.getModel());
                retMap.put("f4010070", cf.getOs());
                retMap.put("f4010080", cf.getCarrier());
                retMap.put("f4010090", DataUtil.Integer2String((Integer)cf.getConnectionType()));
                retMap.put("f4010091", DataUtil.Integer2String((Integer)cf.getTuiaConnectionType()));
                retMap.put("f4010100", AdxFeatureParse.getFloat2String(cf.getLat()));
                retMap.put("f4010110", AdxFeatureParse.getFloat2String(cf.getLon()));
                Integer hour = AdxFeatureParse.getTimeStampToHour(cf.getCurrentCreatTime());
                retMap.put("f4010121", DataUtil.Integer2String((Integer)hour));
                Integer weekDay = AdxFeatureParse.getTimeStampToWeekDay(cf.getCurrentCreatTime());
                retMap.put("f4010122", DataUtil.Integer2String((Integer)weekDay));
                retMap.put("f5010010", cf.getGender());
                retMap.put("f5010020", cf.getInterestKeyWords());
                retMap.put("f5010030", cf.getYob());
                retMap.put("f6010010", cf.getAppName());
                retMap.put("f6010020", cf.getAppBundle());
                retMap.put("f6010030", cf.getAppPageCat());
                retMap.put("f6010040", DataUtil.Integer2String((Integer)cf.getAppPaid()));
                retMap.put("f6010050", cf.getGeoCountry());
                retMap.put("f6010060", cf.getGeoRegion());
                retMap.put("f6010070", cf.getGeoCity());
                retMap.put("f6010080", DataUtil.Integer2String((Integer)cf.getGeoType()));
            }
        }
        catch (Exception e) {
            logger.error("AdxFeatureParse.generateFeatureMapStatic error:" + e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(AdxFeatureDo cf, AdxFeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f3010010", DataUtil.Long2String((Long)cf.getIdeaId()));
                retMap.put("f3010020", cf.getButtonText());
                retMap.put("f3010030", DataUtil.Integer2String((Integer)cf.getIconH()));
                retMap.put("f3010040", DataUtil.Integer2String((Integer)cf.getIconW()));
                retMap.put("f3010050", DataUtil.Integer2String((Integer)cf.getMjPicType()));
                retMap.put("f3010060", DataUtil.Integer2String((Integer)cf.getIdeaPicH1()));
                retMap.put("f3010070", DataUtil.Integer2String((Integer)cf.getIdeaPicW1()));
                retMap.put("f3010080", DataUtil.Integer2String((Integer)cf.getIdeaPicH2()));
                retMap.put("f3010090", DataUtil.Integer2String((Integer)cf.getIdeaPicW2()));
                retMap.put("f3010100", DataUtil.Integer2String((Integer)cf.getIdeaPicH3()));
                retMap.put("f3010110", DataUtil.Integer2String((Integer)cf.getIdeaPicW3()));
                retMap.put("f3010120", DataUtil.Integer2String((Integer)cf.getIdeaPicNum()));
                Long ideaExpTimes = AdxFeatureParse.getIdeaExpTime(cf.getIdeaId(), staticCf.getExpTimeMap());
                retMap.put("f5010040", DataUtil.Long2String((Long)ideaExpTimes));
            }
        }
        catch (Exception e) {
            logger.error("AdxFeatureParse.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static Integer getTimeStampToHour(Long timeStamp) {
        LocalDateTime localDate;
        Date date;
        Integer ret = null;
        if (timeStamp != null && (date = new Date(timeStamp)) != null && (localDate = LocalDateUtil.dateToLocal((Date)date)) != null) {
            ret = LocalDateUtil.getHour((LocalDateTime)localDate);
        }
        return ret;
    }

    public static Integer getTimeStampToWeekDay(Long timeStamp) {
        LocalDateTime localDate;
        Date date;
        Integer ret = null;
        if (timeStamp != null && (date = new Date(timeStamp)) != null && (localDate = LocalDateUtil.dateToLocal((Date)date)) != null) {
            ret = LocalDateUtil.getDayOfWeek((LocalDateTime)localDate);
        }
        return ret;
    }

    public static Long getStringToTimeStamp() {
        Long ret = null;
        String currentTime = LocalDateUtil.getCurrentLocalDateTime((String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        if (currentTime != null) {
            ret = LocalDateUtil.getTimeMillis((String)currentTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        }
        return ret;
    }

    public static String getFloat2String(Float src) {
        String ret = null;
        if (src != null) {
            ret = Float.toString(src.floatValue());
        }
        return ret;
    }

    public static Long getObject2Long(Object src) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)src)) {
            ret = DataUtil.string2Long((String)String.valueOf(src));
        }
        return ret;
    }

    public static Long getIdeaExpTime(Long ideaId, Map<Long, Object> expTimeMap) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ideaId, expTimeMap})) {
            Long cnt = AdxFeatureParse.getObject2Long(expTimeMap.get(ideaId));
            ret = cnt == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= 7L ? cnt : Long.valueOf(-1L));
        }
        return ret;
    }

    public static Long getRegionLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area = DataUtil.toInt((Long)(areaCode / 100L));
            }
            if (Arrays.asList(HUABEI_REGION).contains(area)) {
                ret = 80L;
            } else if (Arrays.asList(DONGBEI_REGION).contains(area)) {
                ret = 81L;
            } else if (Arrays.asList(HUADONG_REGION).contains(area)) {
                ret = 82L;
            } else if (Arrays.asList(HUAZHONG_REGION).contains(area)) {
                ret = 83L;
            } else if (Arrays.asList(HUANAN_REGION).contains(area)) {
                ret = 84L;
            } else if (Arrays.asList(XINAN_REGION).contains(area)) {
                ret = 85L;
            } else if (Arrays.asList(XIBEI_REGION).contains(area)) {
                ret = 86L;
            } else if (Arrays.asList(HMT_REGION).contains(area)) {
                ret = 87L;
            }
        }
        return ret;
    }

    public static Long getTierCityLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) {
                ret = 1L;
            } else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) {
                ret = 2L;
            } else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) {
                ret = 3L;
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        Long currentGmtCreateTime1 = new Date().getTime();
        System.out.println("time:" + currentGmtCreateTime1);
        Integer hour = AdxFeatureParse.getTimeStampToHour(currentGmtCreateTime1);
        System.out.println("hour:" + DataUtil.Integer2String((Integer)hour));
        Integer weekDay = AdxFeatureParse.getTimeStampToWeekDay(currentGmtCreateTime1);
        System.out.println("weekday:" + DataUtil.Integer2String((Integer)weekDay));
        Long currentTime1 = AdxFeatureParse.getStringToTimeStamp();
        System.out.println("time1:" + currentTime1);
        System.out.println("ret1:" + AdxFeatureParse.getFloat2String(null));
        System.out.println("ret2:" + AdxFeatureParse.getObject2Long(null));
        System.out.println("getRegionLevel:" + AdxFeatureParse.getRegionLevel(4690L));
        System.out.println("getTierCityLevel:" + AdxFeatureParse.getTierCityLevel(null));
        AdxFeatureDo adxFeatureDo1 = new AdxFeatureDo();
        adxFeatureDo1.setCurrentCreatTime(new Date().getTime());
        Map<Object, Object> staticMap1 = new HashMap();
        staticMap1 = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo1);
        System.out.println("staticMap1=" + JSON.toJSONString(staticMap1));
    }
}

