/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureBaseParse;
import cn.com.duiba.nezha.alg.feature.vo.DmpFeature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.ItemProfileFeature;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(FeatureParse.class);
    public static int[] dayOrderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 60, 100};
    public static int[] orderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 25, 30, 35, 50, 70, 100, 200, 500};
    public static int[] dayActOrderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 20};
    public static int[] orderActRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 50};
    public static int[] orderGmtIntervelBucket = new int[]{1, 2, 3, 4, 5, 10, 60, 720, 1440, 10080};
    public static int[] orderActGmtIntervelBucket = new int[]{1, 2, 3, 4, 5, 10, 60, 720, 1440, 10080};
    public static double[] userCtrBucket = new double[]{0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userCvrBucket = new double[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userSignRatioBucket = new double[]{0.001, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 0.075, 0.1, 0.125, 0.15, 0.175, 0.2, 0.225, 0.25, 0.275, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static int[] cntBucket = new int[]{0, 1, 3, 5, 10, 15, 20};
    public static int[] bigCntBucket = new int[]{0, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 500000, 1000000};
    public static int[] ctrAndCvrLevelBucket = new int[]{1, 4, 8};
    public static int[] videoDurationBucket = new int[]{0, 15, 30, 60, 300, 600, 900, 1800, 2700, 3600, 5400, 7200};
    public static int[] colorRBGBucket = new int[]{0, 25, 50, 75, 100, 125, 150, 175, 200, 225};
    public static int[] priceBucket = new int[]{0, 5000, 10000, 20000, 50000, 100000, 200000};
    public static int[] totalPriceBucket = new int[]{0, 10000, 50000, 100000, 200000, 500000, 1000000};
    public static int[] cateScoreBucket = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    public static double[] statCtrBucket = new double[]{0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] statCvrBucket = new double[]{0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] cntRatioBucket = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>(){
        {
            this.put("8", 0);
            this.put("14", 1);
            this.put("15", 2);
            this.put("21", 3);
            this.put("20", 4);
            this.put("3", 5);
            this.put("5", 6);
            this.put("12", 7);
            this.put("2", 8);
            this.put("1", 9);
            this.put("24", 10);
            this.put("6", 11);
            this.put("7", 12);
            this.put("11", 13);
            this.put("13", 14);
            this.put("18", 15);
            this.put("22", 16);
            this.put("4", 17);
            this.put("17", 18);
            this.put("25", 19);
            this.put("10", 20);
            this.put("23", 21);
            this.put("9", 22);
            this.put("19", 23);
            this.put("16", 24);
        }
    };
    public static Map<String, Integer> resourceCodes = new HashMap<String, Integer>(){
        {
            this.put("07.23.0008", 0);
            this.put("07.23.0019", 1);
            this.put("07.23.0010", 2);
            this.put("07.24.0001", 3);
            this.put("07.23.0013", 4);
            this.put("07.23.0018", 5);
            this.put("07.23.0009", 6);
            this.put("07.23.0030", 7);
            this.put("07.23.0012", 8);
            this.put("07.23.0036", 9);
            this.put("07.23.0021", 10);
        }
    };
    public static Map<String, Integer> appCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
            this.put("8", 8);
            this.put("9", 9);
            this.put("10", 10);
            this.put("11", 11);
            this.put("12", 12);
            this.put("13", 13);
            this.put("14", 14);
        }
    };
    public static Map<String, Integer> msgSigCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
            this.put("8", 8);
            this.put("9", 9);
            this.put("10", 10);
            this.put("11", 11);
            this.put("12", 12);
            this.put("13", 13);
            this.put("14", 14);
            this.put("15", 15);
            this.put("16", 16);
            this.put("17", 17);
            this.put("18", 18);
            this.put("19", 19);
            this.put("20", 20);
            this.put("21", 21);
            this.put("22", 22);
            this.put("23", 23);
            this.put("24", 24);
            this.put("25", 25);
            this.put("26", 26);
            this.put("27", 27);
            this.put("28", 28);
            this.put("29", 29);
            this.put("30", 30);
            this.put("31", 31);
            this.put("32", 32);
            this.put("33", 33);
            this.put("34", 34);
            this.put("35", 35);
            this.put("36", 36);
            this.put("37", 37);
            this.put("38", 38);
            this.put("39", 39);
            this.put("40", 40);
            this.put("41", 41);
            this.put("42", 42);
            this.put("43", 43);
        }
    };
    public static Map<String, Integer> keywordCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
            this.put("8", 8);
            this.put("9", 9);
            this.put("10", 10);
            this.put("11", 11);
            this.put("12", 12);
            this.put("13", 13);
            this.put("14", 14);
            this.put("15", 15);
            this.put("16", 16);
            this.put("17", 17);
            this.put("18", 18);
            this.put("19", 19);
            this.put("20", 20);
            this.put("21", 21);
            this.put("22", 22);
            this.put("23", 23);
            this.put("24", 24);
            this.put("25", 25);
            this.put("26", 26);
            this.put("27", 27);
            this.put("28", 28);
            this.put("29", 29);
            this.put("30", 30);
        }
    };
    public static Map<String, Integer> videoCateCodes = new HashMap<String, Integer>(){
        {
            this.put("1273152", 0);
            this.put("1273153", 1);
            this.put("1273154", 2);
            this.put("1273155", 3);
            this.put("1273158", 4);
            this.put("1273163", 5);
            this.put("1273166", 6);
            this.put("1273190", 7);
            this.put("1273380", 8);
            this.put("1273399", 9);
            this.put("1275055", 10);
            this.put("1275060", 11);
            this.put("1275378", 12);
            this.put("1275381", 13);
            this.put("1275605", 14);
            this.put("1275609", 15);
            this.put("1275699", 16);
            this.put("1275850", 17);
            this.put("1276159", 18);
            this.put("1276427", 19);
            this.put("1277341", 20);
            this.put("1277350", 21);
            this.put("1277354", 22);
            this.put("1277360", 23);
            this.put("1277373", 24);
            this.put("1278212", 25);
            this.put("1279265", 26);
            this.put("1279863", 27);
            this.put("1281970", 28);
            this.put("1281978", 29);
            this.put("1282468", 30);
            this.put("1282983", 31);
            this.put("1283091", 32);
            this.put("1283242", 33);
            this.put("1284864", 34);
            this.put("1284891", 35);
            this.put("1284979", 36);
            this.put("1288586", 37);
            this.put("1289618", 38);
            this.put("1289633", 39);
            this.put("1289641", 40);
            this.put("1289642", 41);
            this.put("1291079", 42);
            this.put("1307098", 43);
            this.put("1307103", 44);
            this.put("1308055", 45);
            this.put("1310272", 46);
            this.put("1310276", 47);
            this.put("1311366", 48);
            this.put("1316217", 49);
            this.put("1323164", 50);
            this.put("1333414", 51);
            this.put("1343852", 52);
            this.put("1345203", 53);
            this.put("1345206", 54);
            this.put("1345801", 55);
            this.put("1347029", 56);
            this.put("1348464", 57);
            this.put("1348469", 58);
            this.put("1348589", 59);
            this.put("1348767", 60);
            this.put("1351397", 61);
            this.put("1362094", 62);
            this.put("1392855", 63);
            this.put("1399467", 64);
            this.put("1457705", 65);
            this.put("1506926", 66);
            this.put("1509530", 67);
            this.put("1652670", 68);
            this.put("1657117", 69);
            this.put("1657120", 70);
            this.put("1786669", 71);
            this.put("1791134", 72);
            this.put("1887279", 73);
            this.put("2289121", 74);
            this.put("2289182", 75);
            this.put("2289191", 76);
            this.put("2289194", 77);
            this.put("2289198", 78);
            this.put("2400701", 79);
            this.put("2422552", 80);
            this.put("2423962", 81);
            this.put("2425625", 82);
            this.put("2454957", 83);
            this.put("2456790", 84);
            this.put("2456802", 85);
            this.put("2456895", 86);
            this.put("2466968", 87);
            this.put("2469508", 88);
            this.put("2485369", 89);
            this.put("2577550", 90);
            this.put("2818641", 91);
            this.put("2820598", 92);
            this.put("2821045", 93);
            this.put("2821232", 94);
            this.put("2821234", 95);
            this.put("2823069", 96);
            this.put("2824674", 97);
            this.put("2825127", 98);
            this.put("2825132", 99);
            this.put("2825152", 100);
            this.put("2825153", 101);
            this.put("2825156", 102);
            this.put("2825165", 103);
            this.put("2825674", 104);
            this.put("2828097", 105);
            this.put("2829161", 106);
            this.put("2829647", 107);
            this.put("2830002", 108);
            this.put("2830311", 109);
            this.put("2830346", 110);
            this.put("2830613", 111);
            this.put("2830805", 112);
            this.put("2831234", 113);
            this.put("2831373", 114);
            this.put("2831480", 115);
            this.put("2832492", 116);
            this.put("2833635", 117);
            this.put("2834198", 118);
            this.put("2834248", 119);
            this.put("2834252", 120);
            this.put("2834254", 121);
            this.put("2834359", 122);
            this.put("2834697", 123);
            this.put("2834810", 124);
            this.put("2834931", 125);
            this.put("2835040", 126);
            this.put("2835116", 127);
            this.put("2835117", 128);
            this.put("2835164", 129);
            this.put("2835165", 130);
            this.put("2835495", 131);
            this.put("2835521", 132);
            this.put("2835645", 133);
            this.put("2835728", 134);
            this.put("2835738", 135);
            this.put("2835744", 136);
            this.put("2836094", 137);
            this.put("2836607", 138);
            this.put("2836677", 139);
            this.put("2837050", 140);
            this.put("2837679", 141);
            this.put("2837825", 142);
            this.put("2838438", 143);
            this.put("2838626", 144);
            this.put("2838627", 145);
            this.put("2838628", 146);
            this.put("2838680", 147);
            this.put("2839215", 148);
            this.put("2839217", 149);
            this.put("2839264", 150);
            this.put("2839388", 151);
            this.put("2840307", 152);
            this.put("2840460", 153);
            this.put("2840461", 154);
            this.put("2840492", 155);
            this.put("2840499", 156);
            this.put("2840500", 157);
            this.put("2840501", 158);
            this.put("2840502", 159);
            this.put("2840504", 160);
            this.put("2840944", 161);
            this.put("2841365", 162);
            this.put("2841425", 163);
            this.put("2841426", 164);
            this.put("2844458", 165);
            this.put("2844459", 166);
            this.put("2844461", 167);
            this.put("2844477", 168);
            this.put("2844488", 169);
            this.put("2844489", 170);
            this.put("2845047", 171);
            this.put("2847235", 172);
            this.put("2847874", 173);
            this.put("2847916", 174);
            this.put("2848190", 175);
            this.put("2848215", 176);
            this.put("2848229", 177);
            this.put("2848330", 178);
            this.put("2849576", 179);
            this.put("2850987", 180);
            this.put("2859501", 181);
            this.put("2859502", 182);
            this.put("2859503", 183);
            this.put("2859504", 184);
            this.put("2859505", 185);
            this.put("2859506", 186);
            this.put("2859507", 187);
            this.put("2859508", 188);
            this.put("2859509", 189);
            this.put("2859510", 190);
            this.put("2859511", 191);
            this.put("2859512", 192);
            this.put("2859513", 193);
            this.put("2859588", 194);
            this.put("2859785", 195);
            this.put("2860991", 196);
            this.put("2860992", 197);
            this.put("2923465", 198);
            this.put("2923466", 199);
            this.put("2924524", 200);
            this.put("2924526", 201);
            this.put("2924527", 202);
            this.put("2924539", 203);
            this.put("2924541", 204);
            this.put("2924542", 205);
            this.put("2924543", 206);
            this.put("2924965", 207);
            this.put("2924966", 208);
            this.put("2924967", 209);
            this.put("2924968", 210);
            this.put("2924969", 211);
            this.put("2924970", 212);
        }
    };
    public static Map<String, Integer> videoChannelCodes = new HashMap<String, Integer>(){
        {
            this.put("aiqiyi--1", 0);
            this.put("aiqiyi-0", 1);
            this.put("aiqiyi-1", 2);
            this.put("aiqiyi-10", 3);
            this.put("aiqiyi-11", 4);
            this.put("aiqiyi-12", 5);
            this.put("aiqiyi-13", 6);
            this.put("aiqiyi-14", 7);
            this.put("aiqiyi-15", 8);
            this.put("aiqiyi-16", 9);
            this.put("aiqiyi-17", 10);
            this.put("aiqiyi-18", 11);
            this.put("aiqiyi-19", 12);
            this.put("aiqiyi-2", 13);
            this.put("aiqiyi-20", 14);
            this.put("aiqiyi-21", 15);
            this.put("aiqiyi-22", 16);
            this.put("aiqiyi-23", 17);
            this.put("aiqiyi-24", 18);
            this.put("aiqiyi-25", 19);
            this.put("aiqiyi-26", 20);
            this.put("aiqiyi-27", 21);
            this.put("aiqiyi-28", 22);
            this.put("aiqiyi-29", 23);
            this.put("aiqiyi-3", 24);
            this.put("aiqiyi-30", 25);
            this.put("aiqiyi-30003", 26);
            this.put("aiqiyi-30005", 27);
            this.put("aiqiyi-30008", 28);
            this.put("aiqiyi-30010", 29);
            this.put("aiqiyi-31", 30);
            this.put("aiqiyi-32", 31);
            this.put("aiqiyi-33", 32);
            this.put("aiqiyi-34", 33);
            this.put("aiqiyi-4", 34);
            this.put("aiqiyi-40004", 35);
            this.put("aiqiyi-49999", 36);
            this.put("aiqiyi-5", 37);
            this.put("aiqiyi-6", 38);
            this.put("aiqiyi-7", 39);
            this.put("aiqiyi-8", 40);
            this.put("aiqiyi-9", 41);
            this.put("aiqiyi-97", 42);
            this.put("aiqiyi-99", 43);
            this.put("mango-0", 44);
            this.put("mango-1", 45);
            this.put("mango-105", 46);
            this.put("mango-111", 47);
            this.put("mango-116", 48);
            this.put("mango-117", 49);
            this.put("mango-120", 50);
            this.put("mango-2", 51);
            this.put("mango-20", 52);
            this.put("mango-3", 53);
            this.put("mango-50", 54);
        }
    };
    public static Map<String, Integer> colorCodes = new HashMap<String, Integer>(){
        {
            this.put("color0_r", 0);
            this.put("color0_g", 1);
            this.put("color0_b", 2);
            this.put("color1_r", 3);
            this.put("color1_g", 4);
            this.put("color1_b", 5);
            this.put("color2_r", 6);
            this.put("color2_g", 7);
            this.put("color2_b", 8);
        }
    };
    public static Map<String, Integer> accountCodes = new HashMap<String, Integer>(){
        {
            this.put("18125", 0);
            this.put("18943", 1);
            this.put("22005", 2);
            this.put("21563", 3);
            this.put("17196", 4);
            this.put("29815", 5);
            this.put("27419", 6);
            this.put("25874", 7);
            this.put("30539", 8);
            this.put("27295", 9);
            this.put("30037", 10);
            this.put("24035", 11);
            this.put("23882", 12);
            this.put("29932", 13);
            this.put("19317", 14);
            this.put("10971", 15);
            this.put("27486", 16);
            this.put("12311", 17);
            this.put("22597", 18);
            this.put("21330", 19);
            this.put("26598", 20);
            this.put("30371", 21);
            this.put("19941", 22);
            this.put("27605", 23);
            this.put("17270", 24);
            this.put("12234", 25);
            this.put("17878", 26);
            this.put("28257", 27);
            this.put("30632", 28);
            this.put("25991", 29);
            this.put("30701", 30);
            this.put("30336", 31);
            this.put("12796", 32);
            this.put("29379", 33);
            this.put("30495", 34);
            this.put("29758", 35);
            this.put("19316", 36);
            this.put("14355", 37);
            this.put("29001", 38);
            this.put("30126", 39);
            this.put("30892", 40);
            this.put("26320", 41);
            this.put("18489", 42);
            this.put("14164", 43);
            this.put("24696", 44);
            this.put("28941", 45);
            this.put("30511", 46);
            this.put("5713", 47);
            this.put("30928", 48);
            this.put("19761", 49);
            this.put("30592", 50);
            this.put("30081", 51);
            this.put("28769", 52);
            this.put("29788", 53);
            this.put("21133", 54);
            this.put("30679", 55);
            this.put("30393", 56);
            this.put("26323", 57);
            this.put("29336", 58);
            this.put("29935", 59);
            this.put("29030", 60);
            this.put("26550", 61);
            this.put("30394", 62);
            this.put("30823", 63);
            this.put("28466", 64);
            this.put("8340", 65);
            this.put("30460", 66);
            this.put("30739", 67);
            this.put("26048", 68);
            this.put("30765", 69);
            this.put("30596", 70);
            this.put("25809", 71);
            this.put("30808", 72);
            this.put("30605", 73);
            this.put("27165", 74);
            this.put("30868", 75);
            this.put("30518", 76);
            this.put("29408", 77);
            this.put("30601", 78);
            this.put("30900", 79);
            this.put("25984", 80);
            this.put("27568", 81);
            this.put("23937", 82);
            this.put("15334", 83);
            this.put("30345", 84);
            this.put("26595", 85);
            this.put("8154", 86);
            this.put("28264", 87);
            this.put("30848", 88);
            this.put("13566", 89);
            this.put("26726", 90);
            this.put("8302", 91);
            this.put("29406", 92);
            this.put("16315", 93);
            this.put("30625", 94);
            this.put("20619", 95);
            this.put("28528", 96);
            this.put("30253", 97);
            this.put("29808", 98);
            this.put("30809", 99);
            this.put("6286", 100);
            this.put("22757", 101);
            this.put("9876", 102);
            this.put("24779", 103);
            this.put("25806", 104);
            this.put("30929", 105);
            this.put("30956", 106);
            this.put("30691", 107);
            this.put("29706", 108);
            this.put("29651", 109);
            this.put("30438", 110);
            this.put("27911", 111);
            this.put("30493", 112);
            this.put("29519", 113);
            this.put("30220", 114);
            this.put("30812", 115);
            this.put("27684", 116);
            this.put("30636", 117);
            this.put("17638", 118);
            this.put("28594", 119);
            this.put("29558", 120);
            this.put("27463", 121);
            this.put("28925", 122);
            this.put("28420", 123);
            this.put("30099", 124);
            this.put("28523", 125);
            this.put("30688", 126);
            this.put("28432", 127);
            this.put("18028", 128);
            this.put("6209", 129);
            this.put("30783", 130);
            this.put("22412", 131);
            this.put("30684", 132);
            this.put("30621", 133);
            this.put("30734", 134);
            this.put("30807", 135);
            this.put("30794", 136);
            this.put("28180", 137);
            this.put("28544", 138);
            this.put("30186", 139);
            this.put("24090", 140);
            this.put("30111", 141);
            this.put("8657", 142);
            this.put("23977", 143);
            this.put("29491", 144);
            this.put("30327", 145);
            this.put("30249", 146);
            this.put("23461", 147);
            this.put("28597", 148);
            this.put("30498", 149);
            this.put("30109", 150);
            this.put("30279", 151);
            this.put("30100", 152);
            this.put("30732", 153);
            this.put("23031", 154);
            this.put("30497", 155);
            this.put("25886", 156);
            this.put("27453", 157);
            this.put("29845", 158);
            this.put("30378", 159);
            this.put("30257", 160);
            this.put("28881", 161);
            this.put("27241", 162);
            this.put("30219", 163);
            this.put("22006", 164);
            this.put("30217", 165);
            this.put("25215", 166);
            this.put("19217", 167);
            this.put("28515", 168);
            this.put("30185", 169);
            this.put("29858", 170);
            this.put("27452", 171);
            this.put("18089", 172);
            this.put("30411", 173);
            this.put("26151", 174);
            this.put("29699", 175);
            this.put("29889", 176);
            this.put("30573", 177);
            this.put("30017", 178);
            this.put("2292", 179);
            this.put("29427", 180);
            this.put("30560", 181);
            this.put("30626", 182);
            this.put("28628", 183);
            this.put("29534", 184);
            this.put("30515", 185);
            this.put("30023", 186);
            this.put("30374", 187);
            this.put("21271", 188);
            this.put("27321", 189);
            this.put("30290", 190);
            this.put("28643", 191);
            this.put("14356", 192);
            this.put("23880", 193);
            this.put("30836", 194);
            this.put("30569", 195);
            this.put("29900", 196);
            this.put("29879", 197);
            this.put("30499", 198);
            this.put("29894", 199);
            this.put("28970", 200);
            this.put("21944", 201);
            this.put("30705", 202);
            this.put("30187", 203);
            this.put("28503", 204);
            this.put("29028", 205);
            this.put("30128", 206);
            this.put("30182", 207);
            this.put("30237", 208);
            this.put("29448", 209);
            this.put("30825", 210);
            this.put("27884", 211);
            this.put("27932", 212);
            this.put("30704", 213);
            this.put("30695", 214);
            this.put("30461", 215);
            this.put("30218", 216);
            this.put("29862", 217);
            this.put("25509", 218);
            this.put("30329", 219);
            this.put("26077", 220);
            this.put("25495", 221);
            this.put("30115", 222);
            this.put("27002", 223);
            this.put("30935", 224);
            this.put("23469", 225);
            this.put("30331", 226);
            this.put("30188", 227);
            this.put("24296", 228);
            this.put("22042", 229);
            this.put("7962", 230);
            this.put("323", 231);
            this.put("30272", 232);
            this.put("18071", 233);
            this.put("18072", 234);
            this.put("8220", 235);
            this.put("8331", 236);
            this.put("23680", 237);
            this.put("6419", 238);
        }
    };
    public static Map<String, Integer> priceCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
        }
    };

    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                cf.setCurrentGmtCreateTime(LocalDateUtil.getCurrentLocalDateTime((String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
                retMap.put("f108001", DataUtil.Long2String((Long)cf.getSlotId()));
                retMap.put("f108003", DataUtil.Long2String((Long)cf.getSlotId()));
                retMap.put("f109001", DataUtil.Integer2String((Integer)cf.getSlotType()));
                retMap.put("f201001", DataUtil.Long2String((Long)cf.getAppId()));
                retMap.put("f202001", cf.getAppCategory());
                retMap.put("f301001", DataUtil.Long2String((Long)cf.getOperatingActivityId()));
                retMap.put("f302001", DataUtil.Long2String((Long)cf.getActivityId()));
                retMap.put("f303001", DataUtil.Long2String((Long)cf.getActivityType()));
                retMap.put("f501001", cf.getUa());
                Integer hour = LocalDateUtil.getHour((String)cf.getCurrentGmtCreateTime(), (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                retMap.put("f502001", DataUtil.Integer2String((Integer)hour));
                Integer weekDay = LocalDateUtil.getDayOfWeek((String)cf.getCurrentGmtCreateTime(), (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                retMap.put("f502002", DataUtil.Integer2String((Integer)weekDay));
                retMap.put("f503001", DataUtil.Long2String((Long)cf.getCityId()));
                retMap.put("f601001", DataUtil.Long2String((Long)FeatureParse.getDayRankLevel(cf.getDayOrderRank())));
                retMap.put("f602001", DataUtil.Long2String((Long)FeatureParse.getRankLevel(cf.getOrderRank())));
                retMap.put("f603001", DataUtil.Long2String((Long)FeatureParse.getDayRankLevel(cf.getDayActivityOrderRank())));
                retMap.put("f604001", DataUtil.Long2String((Long)FeatureParse.getRankLevel(cf.getActivityOrderRank())));
                Long orderGmtIntervelLevel = FeatureParse.getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605001", DataUtil.Long2String((Long)orderGmtIntervelLevel));
                Long activityOrderGmtIntervelLevel = FeatureParse.getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606001", DataUtil.Long2String((Long)activityOrderGmtIntervelLevel));
                Long activityLastChargeStatus = FeatureParse.getChargeStatus(cf.getActivityLastChargeNums());
                retMap.put("f607001", DataUtil.Long2String((Long)activityLastChargeStatus));
                Long lastChargeStatus = FeatureParse.getChargeStatus(cf.getLastChargeNums());
                retMap.put("f608001", DataUtil.Long2String((Long)lastChargeStatus));
                Long activityChangeStatus = FeatureParse.getActivityChangeStatus(cf.getOperatingActivityId(), cf.getLastOperatingActivityId());
                retMap.put("f609001", DataUtil.Long2String((Long)activityChangeStatus));
                retMap.put("f504001", cf.getModel());
                retMap.put("f505001", cf.getPriceSection());
                retMap.put("f506001", cf.getConnectionType());
                retMap.put("f507001", cf.getOperatorType());
                retMap.put("f508003", cf.getPhoneBrand());
                retMap.put("f508004", cf.getPhoneModelNum());
                retMap.put("f508005", cf.getBrandName());
                retMap.put("f508006", cf.getDeviceTrademark());
                retMap.put("f507003", cf.getOsVersion());
                retMap.put("f611001", DataUtil.Long2String((Long)cf.getPutIndex()));
                retMap.put("f306001", cf.getActivityUseType());
                retMap.put("f403001", cf.getMemberId());
                retMap.put("f403005", cf.getMobile());
                Long iso = FeatureParse.isOld(cf.getUserLastlogbigintime(), cf.getUserRegtime());
                retMap.put("f403004", DataUtil.Long2String((Long)iso));
                retMap.put("f114001", cf.getSlotIndustryTagPid());
                retMap.put("f114002", cf.getSlotIndustryTagId());
                retMap.put("f205001", cf.getAppIndustryTagPid());
                retMap.put("f205002", cf.getAppIndustryTagId());
                retMap.put("f206001", cf.getTrafficTagPid());
                retMap.put("f206002", cf.getTrafficTagId());
                retMap.put("f9902", cf.getAppList2());
                retMap.put("f9906", cf.getCategoryIdList1());
                retMap.put("f9907", cf.getCategoryIdList2());
                retMap.put("f9908", cf.getIsGame());
                retMap.put("f508001", cf.getPhoneBrand());
                retMap.put("f508002", cf.getPhoneModelNum());
                retMap.put("f9914", cf.getImportantApp());
                retMap.put("f9915", cf.getClusterId());
                retMap.put("f9916", FeatureParse.getLevel("launch_pv", cf.getUIIds(), cf.getUILaunchPV()));
                retMap.put("f9917", FeatureParse.getLevel("click_pv", cf.getUIIds(), cf.getUIClickPv()));
                retMap.put("f9918", FeatureParse.getLevel("effect_pv", cf.getUIIds(), cf.getUIEffectPv()));
                retMap.put("f9919", FeatureParse.getLevel("score", cf.getUIIds(), cf.getUIScore()));
                retMap.put("f9921", cf.getUICtr());
                retMap.put("f9922", cf.getUICvr());
                retMap.put("f9923", cf.getUUnICtr());
                retMap.put("f9924", cf.getUUnICvr());
                retMap.put("f9927", FeatureParse.countFeatures(cf.getUICtr()) + "");
                retMap.put("f9928", FeatureParse.countFeatures(cf.getUICvr()) + "");
                retMap.put("f9929", FeatureParse.countFeatures(cf.getUUnICtr()) + "");
                retMap.put("f9930", FeatureParse.countFeatures(cf.getUUnICvr()) + "");
                retMap.put("f404001", cf.getSex());
                retMap.put("f404002", cf.getAge());
                retMap.put("f404003", cf.getWorkStatus());
                retMap.put("f404004", cf.getStudentStatus());
                retMap.put("f404005", cf.getMarriageStatus());
                retMap.put("f404006", cf.getBear());
                retMap.put("f404007", cf.getInterestList());
                retMap.put("f601002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getDayOrderRank(), dayOrderRankBucket)));
                retMap.put("f602002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getOrderRank(), orderRankBucket)));
                retMap.put("f603002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getDayActivityOrderRank(), dayActOrderRankBucket)));
                retMap.put("f604002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getActivityOrderRank(), orderActRankBucket)));
                Long orderGmtIntervel = FeatureParse.getOrderGmtIntervel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605002", DataUtil.Long2String((Long)FeatureParse.bucket(orderGmtIntervel, orderGmtIntervelBucket)));
                Long activityOrderGmtIntervel = FeatureParse.getOrderGmtIntervel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606002", DataUtil.Long2String((Long)FeatureParse.bucket(activityOrderGmtIntervel, orderActGmtIntervelBucket)));
                retMap.put("f9925", FeatureParse.categoryIdAndCnt(cf.getCategory1idCntList(), 1));
                retMap.put("f9926", FeatureParse.categoryIdAndCnt(cf.getCategory2idCntList(), 2));
                Map<String, Map<String, Long>> ubpMap = FeatureParse.getUserBehavioralPreference(cf.getUIIds(), cf.getUILaunchPV(), cf.getUIClickPv(), cf.getUIEffectPv());
                retMap.put("f809001", FeatureParse.getUserBehavioralPreference(0, "ctr", ubpMap, null));
                retMap.put("f809002", FeatureParse.getUserBehavioralPreference(0, "cvr", ubpMap, null));
                retMap.put("f808001", FeatureParse.getUserBehavioralPreference(2, "ctr", ubpMap, null));
                retMap.put("f808002", FeatureParse.getUserBehavioralPreference(2, "cvr", ubpMap, null));
                retMap.put("f811001", FeatureParse.getUserBehavioralPreference(3, "ctr", ubpMap, null));
                retMap.put("f811002", FeatureParse.getUserBehavioralPreference(3, "cvr", ubpMap, null));
                cf.setUbpMap(ubpMap);
                retMap.put("f406001", FeatureParse.getSlotAreaType(cf.getSlotHeight(), cf.getSlotWidth()));
                retMap.put("f406002", DataUtil.Long2String((Long)cf.getMediaTag1()));
                retMap.put("f406003", DataUtil.Long2String((Long)cf.getMediaTag2()));
                retMap.put("f9934", DataUtil.Long2String((Long)cf.getPerformance()));
                retMap.put("f9931", DataUtil.Long2String((Long)cf.getLaunchInfo()));
                retMap.put("f9932", DataUtil.Long2String((Long)cf.getBasicInfo()));
                retMap.put("f9933", DataUtil.Long2String((Long)cf.getTotalInfo()));
                retMap.put("f9701", cf.getUserBasicTags());
                retMap.put("f9801", cf.getSigList());
                retMap.put("f9903", FeatureBaseParse.getLengthLevel(cf.getAppList2(), 5, 100, 5));
                retMap.put("f9802", FeatureBaseParse.getLengthLevel(cf.getSigList(), 15, 1));
                retMap.put("f9702", FeatureBaseParse.getLengthLevel(cf.getUserBasicTags(), 50, 5));
                retMap.put("f8801", DataUtil.Long2String((Long)cf.getCurrentDayLaunchIndex()));
                retMap.put("f8802", DataUtil.Long2String((Long)cf.getCurrentDayLaunchBatch()));
                retMap.put("f8803", DataUtil.Long2String((Long)cf.getAlgStartPosition()));
                retMap.put("f8804", DataUtil.Long2String((Long)cf.getDayLastLaunchIndexAdLaunchCnt()));
                retMap.put("f8805", DataUtil.Long2String((Long)cf.getDayLaunchIndexAdExportCnt()));
                retMap.put("f8806", DataUtil.Long2String((Long)cf.getDayLaunchIndexAdClickCnt()));
                String appTagInNewTradeCtr = FeatureParse.getStatInNewTrade("ctr", cf.getAppTagInNewTrade());
                retMap.put("f550101", appTagInNewTradeCtr);
                String appTagInNewTradeCvr = FeatureParse.getStatInNewTrade("cvr", cf.getAppTagInNewTrade());
                retMap.put("f550102", appTagInNewTradeCvr);
                String appInNewTradeCtr = FeatureParse.getStatInNewTrade("ctr", cf.getAppInNewTrade());
                retMap.put("f550301", appInNewTradeCtr);
                String appInNewTradeCvr = FeatureParse.getStatInNewTrade("cvr", cf.getAppInNewTrade());
                retMap.put("f550302", appInNewTradeCvr);
                retMap.put("f404100", DataUtil.Integer2String((Integer)cf.getLayerGender()));
                retMap.put("f404101", DataUtil.Integer2String((Integer)cf.getLayerIsStudent()));
                retMap.put("f830001", cf.getClickAdIds());
                retMap.put("f830002", cf.getClickAcIds());
                retMap.put("f830003", cf.getClickReIds());
                retMap.put("f830004", cf.getClickTrIds());
                retMap.put("f830011", cf.getConvAdIds() == null ? "null" : cf.getConvAdIds().toString());
                retMap.put("f830012", cf.getConvAcIds() == null ? "null" : cf.getConvAcIds().toString());
                retMap.put("f830013", cf.getConvReIds() == null ? "null" : cf.getConvReIds().toString());
                retMap.put("f830014", cf.getConvTrIds() == null ? "null" : cf.getConvTrIds().toString());
                retMap.put("f831001", cf.getConvertAdverts());
                retMap.put("f831002", cf.getConvertAccounts());
                retMap.put("f831003", cf.getConvertResources());
                retMap.put("f831004", cf.getConvertTrades());
                retMap.put("f832001", cf.getBConvertAdverts());
                retMap.put("f832002", cf.getBConvertAccounts());
                retMap.put("f832003", cf.getBConvertResources());
                retMap.put("f832004", cf.getBConvertTrades());
                DmpFeature dmpFeature = Optional.ofNullable(cf.getDmpFeature()).orElse(new DmpFeature());
                retMap.put("f9935", dmpFeature.getValidAppList());
                retMap.put("f9936", dmpFeature.getTopAppList());
                retMap.put("f9937", dmpFeature.getMidAppList());
                retMap.put("f9938", dmpFeature.getInstallAppList());
                retMap.put("f9939", dmpFeature.getUninstallAppList());
                String appCategoryLevel = FeatureBaseParse.getCategoryLevel(dmpFeature.getAppCategory(), 10, 1);
                retMap.put("f9940", appCategoryLevel);
                retMap.put("f9941", dmpFeature.getTradeAppList());
                String appVectorLevel = FeatureBaseParse.getAppVectorLevel(dmpFeature.getAppVector(), 200);
                retMap.put("f9942", appVectorLevel);
                retMap.put("f9943", dmpFeature.getTopAppList2());
                retMap.put("f9944", dmpFeature.getTopAppList3());
                retMap.put("f9803", dmpFeature.getMsgCategory());
                retMap.put("f9804", dmpFeature.getMsgKeyword());
                String msgVectorLevel = FeatureBaseParse.getAppVectorLevel(dmpFeature.getMsgVector(), 200);
                retMap.put("f9805", msgVectorLevel);
                String msgListEmbed8Level = FeatureBaseParse.getAppVectorLevel(dmpFeature.getmsgListEmbed8(), 200);
                retMap.put("f9806", msgListEmbed8Level);
                String appListEmbed32Level = FeatureBaseParse.getAppVectorLevel(dmpFeature.getAppListEmbed32(), 200);
                retMap.put("f9807", appListEmbed32Level);
                retMap.put("f701002", FeatureParse.getAdAndSubType(cf.getAppId(), cf.getBankEndType()));
                UserActFeature userActFeature = Optional.ofNullable(cf.getUserActFeature()).orElse(new UserActFeature());
                retMap.put("f410001", FeatureParse.bucket(userActFeature.getUserActiveDays(), cntBucket).toString());
                retMap.put("f411001", FeatureParse.bucket(userActFeature.getActivityRequest(), cntBucket).toString());
                retMap.put("f411002", FeatureParse.bucket(userActFeature.getWeekActivityRequest(), cntBucket).toString());
                retMap.put("f411003", FeatureParse.bucket(userActFeature.getDayActivityRequest(), cntBucket).toString());
                retMap.put("f411004", FeatureParse.bucket(userActFeature.getIntervalActivityRequest(), cntBucket).toString());
                retMap.put("f411005", userActFeature.getPeriodActivityRequest());
                retMap.put("f412001", FeatureParse.bucket(userActFeature.getActivityJoin(), cntBucket).toString());
                retMap.put("f412002", FeatureParse.bucket(userActFeature.getWeekActivityJoin(), cntBucket).toString());
                retMap.put("f412003", FeatureParse.bucket(userActFeature.getDayActivityJoin(), cntBucket).toString());
                retMap.put("f412004", FeatureParse.bucket(userActFeature.getIntervalActivityJoin(), cntBucket).toString());
                retMap.put("f412005", userActFeature.getPeriodActivityJoin());
                retMap.put("f412006", FeatureParse.bucket(userActFeature.getActivityPageStay(), cntBucket).toString());
                Map launchTradeActMap = DataUtil.stringToMap((String)userActFeature.getLaunchTrade(), (Object)0);
                retMap.put("f413001", FeatureParse.getUserCategoryActLevelByBucket(launchTradeActMap, tradeCodes, cntBucket));
                Map weekLaunchTradeActMap = DataUtil.stringToMap((String)userActFeature.getWeekLaunchTrade(), (Object)0);
                retMap.put("f413002", FeatureParse.getUserCategoryActLevelByBucket(weekLaunchTradeActMap, tradeCodes, cntBucket));
                retMap.put("f413003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayLaunchTrade(), tradeCodes, cntBucket));
                retMap.put("f413004", FeatureParse.bucket(userActFeature.getIntervalLaunchTrade(), cntBucket).toString());
                retMap.put("f413005", userActFeature.getPeriodLaunchTrade());
                retMap.put("f413006", FeatureParse.bucket(userActFeature.getAvgLaunchStay(), cntBucket).toString());
                retMap.put("f413007", userActFeature.getLastLaunchTrade());
                retMap.put("f413008", userActFeature.getClickLaunchTrade() == null ? null : userActFeature.getClickLaunchTrade().toString());
                Map clickTraceActMap = DataUtil.stringToMap((String)userActFeature.getClickTrade(), (Object)0);
                retMap.put("f414001", FeatureParse.getUserCategoryActLevelByBucket(clickTraceActMap, tradeCodes, cntBucket));
                Map weekClickTradeActMap = DataUtil.stringToMap((String)userActFeature.getWeekClickTrade(), (Object)0);
                retMap.put("f414002", FeatureParse.getUserCategoryActLevelByBucket(weekClickTradeActMap, tradeCodes, cntBucket));
                retMap.put("f414003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayClickTrade(), tradeCodes, cntBucket));
                retMap.put("f414004", FeatureParse.bucket(userActFeature.getIntervalClickTrade(), cntBucket).toString());
                retMap.put("f414005", userActFeature.getPeriodClickTrade());
                retMap.put("f414007", userActFeature.getLastClickTrade());
                retMap.put("f414008", userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade().toString());
                Map effectTradeActMap = DataUtil.stringToMap((String)userActFeature.getEffectTrade(), (Object)0);
                retMap.put("f415001", FeatureParse.getUserCategoryActLevelByBucket(effectTradeActMap, tradeCodes, cntBucket));
                Map weekEffectTradeActMap = DataUtil.stringToMap((String)userActFeature.getWeekEffectTrade(), (Object)0);
                retMap.put("f415002", FeatureParse.getUserCategoryActLevelByBucket(weekEffectTradeActMap, tradeCodes, cntBucket));
                retMap.put("f415003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayEffectTrade(), tradeCodes, cntBucket));
                retMap.put("f415004", FeatureParse.bucket(userActFeature.getIntervalEffectTrade(), cntBucket).toString());
                retMap.put("f415005", userActFeature.getPeriodEffectTrade());
                retMap.put("f415007", userActFeature.getLastEffectTrade());
                Map launchCateActMap = DataUtil.stringToMap((String)userActFeature.getLaunchCategory(), (Object)0);
                retMap.put("f423001", FeatureParse.getUserCategoryActLevelByBucket(launchCateActMap, resourceCodes, cntBucket));
                Map weekLaunchCateActMap = DataUtil.stringToMap((String)userActFeature.getWeekLaunchCategory(), (Object)0);
                retMap.put("f423002", FeatureParse.getUserCategoryActLevelByBucket(weekLaunchCateActMap, resourceCodes, cntBucket));
                retMap.put("f423003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayLaunchCategory(), resourceCodes, cntBucket));
                retMap.put("f423004", FeatureParse.bucket(userActFeature.getIntervalLaunchCategory(), cntBucket).toString());
                retMap.put("f423005", userActFeature.getPeriodLaunchCategory());
                retMap.put("f423006", FeatureParse.bucket(userActFeature.getAvgLaunchCategoryStay(), cntBucket).toString());
                retMap.put("f423007", userActFeature.getLastLaunchCategory());
                retMap.put("f423008", userActFeature.getClickLaunchCategory() == null ? null : userActFeature.getClickLaunchCategory().toString());
                retMap.put("f423009", userActFeature.getLastLaunchBrand());
                Map clickCateActMap = DataUtil.stringToMap((String)userActFeature.getClickCategory(), (Object)0);
                retMap.put("f424001", FeatureParse.getUserCategoryActLevelByBucket(clickCateActMap, resourceCodes, cntBucket));
                Map weekClickCateActMap = DataUtil.stringToMap((String)userActFeature.getWeekClickCategory(), (Object)0);
                retMap.put("f424002", FeatureParse.getUserCategoryActLevelByBucket(weekClickCateActMap, resourceCodes, cntBucket));
                retMap.put("f424003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayClickCategory(), resourceCodes, cntBucket));
                retMap.put("f424004", FeatureParse.bucket(userActFeature.getIntervalClickCategory(), cntBucket).toString());
                retMap.put("f424005", userActFeature.getPeriodClickCategory());
                retMap.put("f424006", FeatureParse.bucket(userActFeature.getAvgLandpageStay(), cntBucket).toString());
                retMap.put("f424007", userActFeature.getLastClickCategory());
                retMap.put("f424008", userActFeature.getEffectClickCategory() == null ? null : userActFeature.getEffectClickCategory().toString());
                retMap.put("f424009", userActFeature.getLastClickBrand());
                retMap.put("f424010", userActFeature.getIssueEffectClickCategory() == null ? null : userActFeature.getIssueEffectClickCategory().toString());
                Map effectCateActMap = DataUtil.stringToMap((String)userActFeature.getEffectCategory(), (Object)0);
                retMap.put("f425001", FeatureParse.getUserCategoryActLevelByBucket(effectCateActMap, resourceCodes, cntBucket));
                Map weekEffectCateActMap = DataUtil.stringToMap((String)userActFeature.getWeekEffectCategory(), (Object)0);
                retMap.put("f425002", FeatureParse.getUserCategoryActLevelByBucket(weekEffectCateActMap, resourceCodes, cntBucket));
                retMap.put("f425003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayEffectCategory(), resourceCodes, cntBucket));
                retMap.put("f425004", FeatureParse.bucket(userActFeature.getIntervalEffectCategory(), cntBucket).toString());
                retMap.put("f425005", userActFeature.getPeriodEffectCategory());
                retMap.put("f425007", userActFeature.getLastEffectCategory());
                retMap.put("f425009", userActFeature.getLastEffectBrand());
                retMap.put("f425011", FeatureParse.bucket(userActFeature.getAddressCount(), cntBucket).toString());
                retMap.put("f425012", FeatureParse.bucket(userActFeature.getNumberCount(), cntBucket).toString());
                Map issueEffectCateActMap = DataUtil.stringToMap((String)userActFeature.getIssueEffectCategory(), (Object)0);
                retMap.put("f426001", FeatureParse.getUserCategoryActLevelByBucket(issueEffectCateActMap, resourceCodes, cntBucket));
                Map weekIssueEffectCateActMap = DataUtil.stringToMap((String)userActFeature.getWeekIssueEffectCategory(), (Object)0);
                retMap.put("f426002", FeatureParse.getUserCategoryActLevelByBucket(weekIssueEffectCateActMap, resourceCodes, cntBucket));
                retMap.put("f426004", FeatureParse.bucket(userActFeature.getIntervalIssueEffectCategory(), cntBucket).toString());
                retMap.put("f426005", userActFeature.getPeriodIssueEffectCategory());
                retMap.put("f426007", userActFeature.getLastIssueEffectCategory());
                retMap.put("f426009", userActFeature.getLastIssueEffectBrand());
                Long signEffect = DataUtil.str2Long((String)userActFeature.getScoreEffectCategory(), (Long)0L);
                retMap.put("f431001", FeatureParse.bucket(signEffect, cntBucket).toString());
                Long issueEffect = DataUtil.str2Long((String)userActFeature.getScoreIssueEffectCategory(), (Long)0L);
                retMap.put("f431002", FeatureParse.bucket(issueEffect, cntBucket).toString());
                retMap.put("f431003", FeatureParse.getUserSignRatioBucket(signEffect, issueEffect, userSignRatioBucket).toString());
                retMap.put("f432001", FeatureParse.bucket(userActFeature.getOrderFee(), totalPriceBucket).toString());
                retMap.put("f432002", FeatureParse.bucket(userActFeature.getWeekOrderFee(), totalPriceBucket).toString());
                retMap.put("f432003", FeatureParse.bucket(userActFeature.getMaxOrderFee(), priceBucket).toString());
                retMap.put("f432004", FeatureParse.bucket(userActFeature.getMinOrderFee(), priceBucket).toString());
                retMap.put("f432005", FeatureParse.bucket(userActFeature.getAvgOrderFee(), priceBucket).toString());
                retMap.put("f432006", FeatureParse.bucket(userActFeature.getLastOrderFee(), priceBucket).toString());
                retMap.put("f433001", FeatureParse.bucket(userActFeature.getZeroLaunch(), cntBucket).toString());
                retMap.put("f433002", FeatureParse.bucket(userActFeature.getNonZeroLaunch(), cntBucket).toString());
                retMap.put("f433003", FeatureParse.bucket(userActFeature.getZeroClick(), cntBucket).toString());
                retMap.put("f433004", FeatureParse.bucket(userActFeature.getNonZeroClick(), cntBucket).toString());
                retMap.put("f433005", FeatureParse.bucket(userActFeature.getZeroEffect(), cntBucket).toString());
                retMap.put("f433006", FeatureParse.bucket(userActFeature.getNonZeroEffect(), cntBucket).toString());
                retMap.put("f433007", FeatureParse.bucket(userActFeature.getZeroIssueEffect(), cntBucket).toString());
                retMap.put("f433008", FeatureParse.bucket(userActFeature.getNonZeroIssueEffect(), cntBucket).toString());
                retMap.put("f434001", FeatureParse.bucket(userActFeature.getVouchFailed(), cntBucket).toString());
                retMap.put("f434002", FeatureParse.bucket(userActFeature.getWeekVouchFailed(), cntBucket).toString());
                retMap.put("f434003", FeatureParse.bucket(userActFeature.getIntervalVouchFailed(), cntBucket).toString());
                retMap.put("f434004", FeatureParse.bucket(userActFeature.getReject(), cntBucket).toString());
                retMap.put("f434005", FeatureParse.bucket(userActFeature.getWeekReject(), cntBucket).toString());
                retMap.put("f434006", FeatureParse.bucket(userActFeature.getIntervalReject(), cntBucket).toString());
                retMap.put("f434007", FeatureParse.bucket(userActFeature.getComplaint(), cntBucket).toString());
                retMap.put("f434008", FeatureParse.bucket(userActFeature.getWeekComplaint(), cntBucket).toString());
                retMap.put("f434009", FeatureParse.bucket(userActFeature.getIntervalComplaint(), cntBucket).toString());
                retMap.put("f434010", FeatureParse.bucket(userActFeature.getAddressException(), cntBucket).toString());
                retMap.put("f434011", FeatureParse.bucket(userActFeature.getWeekAddressException(), cntBucket).toString());
                retMap.put("f434012", FeatureParse.bucket(userActFeature.getIntervalAddressException(), cntBucket).toString());
                retMap.put("f434013", FeatureParse.bucket(userActFeature.getNumberEmpty(), cntBucket).toString());
                retMap.put("f434014", FeatureParse.bucket(userActFeature.getWeekNumberEmpty(), cntBucket).toString());
                retMap.put("f434015", FeatureParse.bucket(userActFeature.getIntervalNumberEmpty(), cntBucket).toString());
                retMap.put("f434016", FeatureParse.bucket(userActFeature.getCheat(), cntBucket).toString());
                retMap.put("f434017", FeatureParse.bucket(userActFeature.getWeekCheat(), cntBucket).toString());
                retMap.put("f434018", FeatureParse.bucket(userActFeature.getIntervalCheat(), cntBucket).toString());
                retMap.put("f462001", userActFeature.getLastApp());
                retMap.put("f462002", FeatureParse.bucket(userActFeature.getLastVideoTime(), videoDurationBucket).toString());
                retMap.put("f462003", userActFeature.getLastVideoChannel());
                retMap.put("f462004", userActFeature.getLastVideoInfo());
                retMap.put("f462005", userActFeature.getLastVideoCategory());
                retMap.put("f462006", userActFeature.getLastVideoArea());
                retMap.put("f462007", userActFeature.getLastVideoYears());
                UserProfileFeature userProfileFeature = Optional.ofNullable(cf.getUserProfileFeature()).orElse(new UserProfileFeature());
                retMap.put("f451001", userProfileFeature.getSex());
                retMap.put("f451002", userProfileFeature.getAge());
                retMap.put("f451003", userProfileFeature.getMarry());
                retMap.put("f451004", userProfileFeature.getConsumeLevel());
                retMap.put("f451005", userProfileFeature.getPermanentProvince());
                retMap.put("f451006", userProfileFeature.getPermanentCity());
                retMap.put("f453001", userProfileFeature.getPriceTag());
                retMap.put("f453002", userProfileFeature.getEffectPrefTag());
                retMap.put("f453003", userProfileFeature.getRiskTag());
                Map appCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getAppCatePref(), (Object)0);
                retMap.put("f461001", FeatureParse.getUserCategoryActLevelByBucket(appCatePrefMap, appCodes, cntBucket));
                Map recentAppCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getRecentAppCatePref(), (Object)0);
                retMap.put("f461002", FeatureParse.getUserCategoryActLevelByBucket(recentAppCatePrefMap, appCodes, cntBucket));
                Map textCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getTextCatePref(), (Object)0);
                retMap.put("f461003", FeatureParse.getUserCategoryActLevelByBucket(textCatePrefMap, msgSigCodes, cntBucket));
                Map recentTextCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getRecentTextCatePref(), (Object)0);
                retMap.put("f461004", FeatureParse.getUserCategoryActLevelByBucket(recentTextCatePrefMap, msgSigCodes, cntBucket));
                Map keywordCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getKeywordCatePref(), (Object)0);
                retMap.put("f461005", FeatureParse.getUserCategoryActLevelByBucket(keywordCatePrefMap, keywordCodes, cntBucket));
                Map recentKeywordCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getRecentKeywordCatePref(), (Object)0);
                retMap.put("f461006", FeatureParse.getUserCategoryActLevelByBucket(recentKeywordCatePrefMap, keywordCodes, cntBucket));
                Map videoCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getVideoCatePref(), (Object)0);
                retMap.put("f461007", FeatureParse.getUserCategoryActLevelByBucket(videoCatePrefMap, videoCateCodes, cntBucket));
                Map recentVideoCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getRecentVideoCatePref(), (Object)0);
                retMap.put("f461008", FeatureParse.getUserCategoryActLevelByBucket(recentVideoCatePrefMap, videoCateCodes, cntBucket));
                Map videoChannelPrefMap = DataUtil.stringToMap((String)userProfileFeature.getVideoChannelPref(), (Object)0);
                retMap.put("f461009", FeatureParse.getUserCategoryActLevelByBucket(videoChannelPrefMap, videoChannelCodes, cntBucket));
                Map recentVideoChannelPrefMap = DataUtil.stringToMap((String)userProfileFeature.getRecentVideoChannelPref(), (Object)0);
                retMap.put("f461010", FeatureParse.getUserCategoryActLevelByBucket(recentVideoChannelPrefMap, videoChannelCodes, cntBucket));
                retMap.put("f461011", userProfileFeature.getRecentVideoKeywordPref());
                retMap.put("f471001", userProfileFeature.getHistoryCateInterest());
                retMap.put("f471002", userProfileFeature.getRecentCateInterest());
                Map scoreCateInterestMap = DataUtil.stringToMap((String)userProfileFeature.getScoreCateInterest(), (Object)0);
                retMap.put("f471003", FeatureParse.getUserCategoryActLevelByBucket(scoreCateInterestMap, resourceCodes, cateScoreBucket));
                Map trendCateInterestMap = DataUtil.stringToMap((String)userProfileFeature.getTrendCateInterest(), (Object)0);
                retMap.put("f471004", FeatureParse.getUserCategoryActLevelByBucket(trendCateInterestMap, resourceCodes, cateScoreBucket));
                retMap.put("f471005", userProfileFeature.getSeasonConsumPref());
                retMap.put("f471006", userProfileFeature.getHolidayConsumPref());
                retMap.put("f471007", userProfileFeature.getPromotionSalesPref());
                retMap.put("f471008", userProfileFeature.getPromotionSalesLevelPref());
                retMap.put("f472001", userProfileFeature.getDiscountSensitivity());
                retMap.put("f472002", userProfileFeature.getGiftSensitivity());
                SlotActFeature slotActFeature = Optional.ofNullable(cf.getSlotActFeature()).orElse(new SlotActFeature());
                JSONObject launchCntRatioTradeMap = DataUtil.stringToJson((String)slotActFeature.getLaunchCntRatioTrade());
                retMap.put("f210001", FeatureParse.getUserCategoryActLevelByBucket(launchCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject launchCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getLaunchCntRatioAccount());
                retMap.put("f210002", FeatureParse.getUserCategoryActLevelByBucket(launchCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject weekLaunchCntRatioTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekLaunchCntRatioTrade());
                retMap.put("f210003", FeatureParse.getUserCategoryActLevelByBucket(weekLaunchCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject weekLaunchCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekLaunchCntRatioAccount());
                retMap.put("f210004", FeatureParse.getUserCategoryActLevelByBucket(weekLaunchCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject clickCntRatioTradeMap = DataUtil.stringToJson((String)slotActFeature.getClickCntRatioTrade());
                retMap.put("f211001", FeatureParse.getUserCategoryActLevelByBucket(clickCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject clickCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getClickCntRatioAccount());
                retMap.put("f211002", FeatureParse.getUserCategoryActLevelByBucket(clickCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject weekClickCntRatioTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekClickCntRatioTrade());
                retMap.put("f211003", FeatureParse.getUserCategoryActLevelByBucket(weekClickCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject weekClickCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekClickCntRatioAccount());
                retMap.put("f211004", FeatureParse.getUserCategoryActLevelByBucket(weekClickCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject ctrTradeMap = DataUtil.stringToJson((String)slotActFeature.getCtrTrade());
                retMap.put("f212001", FeatureParse.getUserCategoryActLevelByBucket(ctrTradeMap, tradeCodes, statCtrBucket));
                JSONObject ctrAccountMap = DataUtil.stringToJson((String)slotActFeature.getCtrAccount());
                retMap.put("f212002", FeatureParse.getUserCategoryActLevelByBucket(ctrAccountMap, accountCodes, statCtrBucket));
                JSONObject weekCtrTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekCtrTrade());
                retMap.put("f212003", FeatureParse.getUserCategoryActLevelByBucket(weekCtrTradeMap, tradeCodes, statCtrBucket));
                JSONObject weekCtrAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekCtrAccount());
                retMap.put("f212004", FeatureParse.getUserCategoryActLevelByBucket(weekCtrAccountMap, accountCodes, statCtrBucket));
                JSONObject convertCntRatioTradeMap = DataUtil.stringToJson((String)slotActFeature.getConvertCntRatioTrade());
                retMap.put("f213001", FeatureParse.getUserCategoryActLevelByBucket(convertCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject convertCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getConvertCntRatioAccount());
                retMap.put("f213002", FeatureParse.getUserCategoryActLevelByBucket(convertCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject weekConvertCntRatioTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekConvertCntRatioTrade());
                retMap.put("f213003", FeatureParse.getUserCategoryActLevelByBucket(weekConvertCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject weekConvertCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekConvertCntRatioAccount());
                retMap.put("f213004", FeatureParse.getUserCategoryActLevelByBucket(weekConvertCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject cvrTradeMap = DataUtil.stringToJson((String)slotActFeature.getCvrTrade());
                retMap.put("f214001", FeatureParse.getUserCategoryActLevelByBucket(cvrTradeMap, tradeCodes, statCvrBucket));
                JSONObject cvrAccountMap = DataUtil.stringToJson((String)slotActFeature.getCvrAccount());
                retMap.put("f214002", FeatureParse.getUserCategoryActLevelByBucket(cvrAccountMap, accountCodes, statCvrBucket));
                JSONObject weekCvrTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekCvrTrade());
                retMap.put("f214003", FeatureParse.getUserCategoryActLevelByBucket(weekCvrTradeMap, tradeCodes, statCvrBucket));
                JSONObject weekCvrAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekCvrAccount());
                retMap.put("f214004", FeatureParse.getUserCategoryActLevelByBucket(weekCvrAccountMap, accountCodes, statCvrBucket));
                JSONObject launchCntRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getLaunchCntRatioCate());
                retMap.put("f220001", FeatureParse.getUserCategoryActLevelByBucket(launchCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject weekLaunchCntRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getWeekLaunchCntRatioCate());
                retMap.put("f220002", FeatureParse.getUserCategoryActLevelByBucket(weekLaunchCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject clickCntRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getClickCntRatioCate());
                retMap.put("f221001", FeatureParse.getUserCategoryActLevelByBucket(clickCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject weekClickCntRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getWeekClickCntRatioCate());
                retMap.put("f221002", FeatureParse.getUserCategoryActLevelByBucket(weekClickCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject ctrCateMap = DataUtil.stringToJson((String)slotActFeature.getCtrCate());
                retMap.put("f221003", FeatureParse.getUserCategoryActLevelByBucket(ctrCateMap, resourceCodes, statCtrBucket));
                JSONObject weekCtrCateMap = DataUtil.stringToJson((String)slotActFeature.getWeekCtrCate());
                retMap.put("f221004", FeatureParse.getUserCategoryActLevelByBucket(weekCtrCateMap, resourceCodes, statCtrBucket));
                JSONObject convertCntRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getConvertCntRatioCate());
                retMap.put("f222001", FeatureParse.getUserCategoryActLevelByBucket(convertCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject weekConvertCntRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getWeekConvertCntRatioCate());
                retMap.put("f222002", FeatureParse.getUserCategoryActLevelByBucket(weekConvertCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject cvrCateMap = DataUtil.stringToJson((String)slotActFeature.getCvrCate());
                retMap.put("f222003", FeatureParse.getUserCategoryActLevelByBucket(cvrCateMap, resourceCodes, statCvrBucket));
                JSONObject weekCvrCateMap = DataUtil.stringToJson((String)slotActFeature.getWeekCvrCate());
                retMap.put("f222004", FeatureParse.getUserCategoryActLevelByBucket(weekCvrCateMap, resourceCodes, statCvrBucket));
                retMap.put("f222005", slotActFeature.getConvertAdSet());
                JSONObject issueCntRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getIssueCntRatioCate());
                retMap.put("f223001", FeatureParse.getUserCategoryActLevelByBucket(issueCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject issueCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getIssueCntRatioAccount());
                retMap.put("f223002", FeatureParse.getUserCategoryActLevelByBucket(issueCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject weekIssueCntRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getWeekIssueCntRatioCate());
                retMap.put("f223003", FeatureParse.getUserCategoryActLevelByBucket(weekIssueCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject weekIssueCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekIssueCntRatioAccount());
                retMap.put("f223004", FeatureParse.getUserCategoryActLevelByBucket(weekIssueCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject issueRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getIssueRatioCate());
                retMap.put("f223005", FeatureParse.getUserCategoryActLevelByBucket(issueRatioCateMap, resourceCodes, userSignRatioBucket));
                JSONObject issueRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getIssueRatioAccount());
                retMap.put("f223006", FeatureParse.getUserCategoryActLevelByBucket(issueRatioAccountMap, accountCodes, userSignRatioBucket));
                JSONObject weekIssueRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getWeekIssueRatioCate());
                retMap.put("f223007", FeatureParse.getUserCategoryActLevelByBucket(weekIssueRatioCateMap, resourceCodes, userSignRatioBucket));
                JSONObject weekIssueRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekIssueRatioAccount());
                retMap.put("f223008", FeatureParse.getUserCategoryActLevelByBucket(weekIssueRatioAccountMap, accountCodes, userSignRatioBucket));
                retMap.put("f223009", slotActFeature.getIssueAdSet());
                JSONObject signCntRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getSignCntRatioCate());
                retMap.put("f224001", FeatureParse.getUserCategoryActLevelByBucket(signCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject signCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getSignCntRatioAccount());
                retMap.put("f224002", FeatureParse.getUserCategoryActLevelByBucket(signCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject signRatioCateMap = DataUtil.stringToJson((String)slotActFeature.getSignRatioCate());
                retMap.put("f224003", FeatureParse.getUserCategoryActLevelByBucket(signRatioCateMap, resourceCodes, userSignRatioBucket));
                JSONObject signRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getSignRatioAccount());
                retMap.put("f224004", FeatureParse.getUserCategoryActLevelByBucket(signRatioAccountMap, accountCodes, userSignRatioBucket));
                retMap.put("f224005", slotActFeature.getSignAdSet());
                JSONObject priceRegionCntRatioMap = DataUtil.stringToJson((String)slotActFeature.getPriceRegionCntRatio());
                retMap.put("f225001", FeatureParse.getUserCategoryActLevelByBucket(priceRegionCntRatioMap, priceCodes, cntRatioBucket));
                retMap.put("f225002", slotActFeature.getAvgPrice() == null ? null : FeatureParse.bucket(slotActFeature.getAvgPrice().longValue(), priceBucket).toString());
                retMap.put("f225003", FeatureParse.bucket(slotActFeature.getZeroClickCntRatio(), cntRatioBucket).toString());
                retMap.put("f225004", FeatureParse.bucket(slotActFeature.getZeroConvertCntRatio(), cntRatioBucket).toString());
                retMap.put("f225005", FeatureParse.bucket(slotActFeature.getZeroIssueCntRatio(), cntRatioBucket).toString());
                retMap.put("f225006", FeatureParse.bucket(slotActFeature.getZeroSignCntRatio(), cntRatioBucket).toString());
                retMap.put("f226001", FeatureParse.bucket(slotActFeature.getVouchFailedCntRatio(), cntRatioBucket).toString());
                retMap.put("f226002", FeatureParse.bucket(slotActFeature.getWeekVouchFailedCntRatio(), cntRatioBucket).toString());
                retMap.put("f226003", FeatureParse.bucket(slotActFeature.getRejectCntRatio(), cntRatioBucket).toString());
                retMap.put("f226004", FeatureParse.bucket(slotActFeature.getWeekRejectCntRatio(), cntRatioBucket).toString());
                retMap.put("f226005", FeatureParse.bucket(slotActFeature.getAddressExpCntRatio(), cntRatioBucket).toString());
                retMap.put("f226006", FeatureParse.bucket(slotActFeature.getWeekAddressExpCntRatio(), cntRatioBucket).toString());
                retMap.put("f226007", FeatureParse.bucket(slotActFeature.getNumberEmptyCntRatio(), cntRatioBucket).toString());
                retMap.put("f226008", FeatureParse.bucket(slotActFeature.getWeekNumberEmptyCntRatio(), cntRatioBucket).toString());
                retMap.put("f312001", DataUtil.Long2String((Long)cf.getDsm2A()));
                retMap.put("f311001", DataUtil.Long2String((Long)cf.getActivityPage()));
                retMap.put("f331001", cf.getActivitySkinType());
                retMap.put("f331002", cf.getTitleId());
                retMap.put("f331003", cf.getSubTitleId());
            }
        }
        catch (Exception e) {
            logger.error("FeatureParse.generateFeatureMapStatic error:" + e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f101001", DataUtil.Long2String((Long)cf.getAdvertId()));
                retMap.put("f106001", DataUtil.Long2String((Long)cf.getAccountId()));
                retMap.put("f111001", cf.getPromoteUrl());
                retMap.put("f102001", cf.getMatchTagNums());
                retMap.put("f801001", cf.getGoodsId());
                retMap.put("f802001", cf.getCatId());
                retMap.put("f802002", cf.getBrandId());
                retMap.put("f803001", DataUtil.Long2String((Long)FeatureParse.getCost(cf.getCost(), cf.getPrice())));
                retMap.put("f803002", DataUtil.Long2String((Long)FeatureParse.getLog(cf.getPrice())));
                retMap.put("f803003", DataUtil.Long2String((Long)FeatureParse.getCost(cf.getViewCount(), cf.getBuyCount())));
                retMap.put("f803004", DataUtil.Long2String((Long)FeatureParse.getLog(cf.getBuyCount())));
                retMap.put("f110001", DataUtil.Long2String((Long)cf.getTimes()));
                Long tagChangeStatus = FeatureParse.getLastTagChangeStatus(cf.getMatchTagNums(), cf.getDayLastMatchTagNums());
                retMap.put("f610001", DataUtil.Long2String((Long)tagChangeStatus));
                retMap.put("f104001", cf.getMaterialId());
                retMap.put("f112001", cf.getMaterialTags());
                retMap.put("f113001", cf.getAdvertTags());
                retMap.put("f804001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertCtr())));
                retMap.put("f804002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertCvr())));
                retMap.put("f805001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertAppCtr())));
                retMap.put("f805002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertAppCvr())));
                retMap.put("f806001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertSlotCtr())));
                retMap.put("f806002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertSlotCvr())));
                retMap.put("f807001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertActivityCtr())));
                retMap.put("f807002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertActivityCvr())));
                retMap.put("f804003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertCtr(), statCtrBucket)));
                retMap.put("f804004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertCvr(), statCvrBucket)));
                retMap.put("f805003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertAppCtr(), statCtrBucket)));
                retMap.put("f805004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertAppCvr(), statCvrBucket)));
                retMap.put("f806003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertSlotCtr(), statCtrBucket)));
                retMap.put("f806004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertSlotCvr(), statCvrBucket)));
                retMap.put("f807003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertActivityCtr(), statCtrBucket)));
                retMap.put("f807004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertActivityCvr(), statCvrBucket)));
                retMap.put("f9912", cf.getTradeId());
                retMap.put("f9913", cf.getTradeId2());
                Map<String, Map<String, Long>> ubpMap = staticCf.getUbpMap();
                retMap.put("f810001", FeatureParse.getUserBehavioralPreference(1, "ctr", ubpMap, cf.getMatchTagNums()));
                retMap.put("f810002", FeatureParse.getUserBehavioralPreference(1, "cvr", ubpMap, cf.getMatchTagNums()));
                retMap.put("f115001", cf.getBankEndType());
                retMap.put("f701001", FeatureParse.getAdAndSubType(cf.getAdvertId(), cf.getBankEndType()));
                retMap.put("f121001", cf.getAtmosphere());
                retMap.put("f121002", cf.getBackgroundColour());
                retMap.put("f121003", cf.getIfPrevalent());
                retMap.put("f121004", cf.getDescribeKeywords());
                retMap.put("f121005", cf.getDynamicEffect());
                retMap.put("f121006", cf.getBodyElement());
                retMap.put("f8807", DataUtil.Long2String((Long)cf.getBatchIndex()));
                retMap.put("f770001", cf.getOperatingResource());
                Long dayResourceOrderRankLevel = FeatureParse.getResourceOrderRank(cf.getOperatingResource(), staticCf.getDayResourceOrderRank());
                retMap.put("f770102", DataUtil.Long2String((Long)dayResourceOrderRankLevel));
                Long resourceOrderGmtIntervelLevel = FeatureParse.getResourceOrderGmtIntervelLevel(cf.getOperatingResource(), staticCf.getCurrentGmtCreateTime(), staticCf.getResourceLastGmtCreateTime());
                retMap.put("f770202", DataUtil.Long2String((Long)resourceOrderGmtIntervelLevel));
                Long resourceLastOrderIsClick = FeatureParse.getResourceLastOrderIsClick(cf.getOperatingResource(), staticCf.getResourceLastLaunchOrderId(), staticCf.getResourceLastClickOrderId());
                retMap.put("f770301", DataUtil.Long2String((Long)resourceLastOrderIsClick));
                Long resourceLastOrderIsConvert = FeatureParse.getResourceLastOrderIsConvert(cf.getOperatingResource(), staticCf.getResourceLastLaunchOrderId(), staticCf.getResourceLastConvertOrderId());
                retMap.put("f770302", DataUtil.Long2String((Long)resourceLastOrderIsConvert));
                Long dayResourceChargeCnt = FeatureParse.getResourceChargeCnt(cf.getOperatingResource(), staticCf.getDayResourceChargeCnt());
                retMap.put("f770401", DataUtil.Long2String((Long)dayResourceChargeCnt));
                Long dayResourceConvertCnt = FeatureParse.getResourceConvertCnt(cf.getOperatingResource(), staticCf.getDayResourceConvertCnt());
                retMap.put("f770402", DataUtil.Long2String((Long)dayResourceConvertCnt));
                Long lastResourceEqualStatus = FeatureParse.getLastResourceEqualStatus(cf.getOperatingResource(), staticCf.getLastOperatingResource());
                retMap.put("f770501", DataUtil.Long2String((Long)lastResourceEqualStatus));
                retMap.put("f660001", cf.getOperatingNewTrade());
                Long newTradeDayOrderRankLevel = FeatureParse.getNewTradeOrderRank(cf.getOperatingNewTrade(), cf.getNewTradeDayOrderRank());
                retMap.put("f660102", DataUtil.Long2String((Long)newTradeDayOrderRankLevel));
                Long lastNewTradeEqualStatus = FeatureParse.getLastNewTradeEqualStatus(cf.getOperatingNewTrade(), cf.getLastOperatingNewTrade());
                retMap.put("f660201", DataUtil.Long2String((Long)lastNewTradeEqualStatus));
                Long lastNewTradeGmtIntervelLevel = FeatureParse.getLastNewTradeGmtIntervelLevel(cf.getOperatingNewTrade(), staticCf.getCurrentGmtCreateTime(), cf.getNewTradeLastGmtCreateTime());
                retMap.put("f660302", DataUtil.Long2String((Long)lastNewTradeGmtIntervelLevel));
                String newTradeInAppTagCtr = FeatureParse.getStatInAppTag("ctr", cf.getNewTradeInAppTag());
                retMap.put("f550201", newTradeInAppTagCtr);
                String newTradeInAppTagCvr = FeatureParse.getStatInAppTag("cvr", cf.getNewTradeInAppTag());
                retMap.put("f550202", newTradeInAppTagCvr);
                String advertInAppTagCtr = FeatureParse.getStatInAppTag("ctr", cf.getAdvertInAppTag());
                retMap.put("f550401", advertInAppTagCtr);
                String advertInAppTagCvr = FeatureParse.getStatInAppTag("cvr", cf.getAdvertInAppTag());
                retMap.put("f550402", advertInAppTagCvr);
                retMap.put("f830101", FeatureParse.getCrossFeature(staticCf.getClickAdIds(), DataUtil.Long2String((Long)cf.getAdvertId())));
                retMap.put("f830102", FeatureParse.getCrossFeature(staticCf.getClickAcIds(), DataUtil.Long2String((Long)cf.getAccountId())));
                retMap.put("f830103", FeatureParse.getCrossFeature(staticCf.getClickReIds(), cf.getOperatingResource()));
                retMap.put("f830104", FeatureParse.getCrossFeature(staticCf.getClickTrIds(), cf.getOperatingNewTrade()));
                String backCvrType = cf.getBankEndType();
                String convAdIds = staticCf.getConvAdIds() == null ? null : (String)staticCf.getConvAdIds().getOrDefault(backCvrType, null);
                String convAcIds = staticCf.getConvAcIds() == null ? null : (String)staticCf.getConvAcIds().getOrDefault(backCvrType, null);
                String convReIds = staticCf.getConvReIds() == null ? null : (String)staticCf.getConvReIds().getOrDefault(backCvrType, null);
                String convTrIds = staticCf.getConvTrIds() == null ? null : (String)staticCf.getConvTrIds().getOrDefault(backCvrType, null);
                retMap.put("f830111", FeatureParse.getCrossFeature(convAdIds, DataUtil.Long2String((Long)cf.getAdvertId())));
                retMap.put("f830112", FeatureParse.getCrossFeature(convAcIds, DataUtil.Long2String((Long)cf.getAccountId())));
                retMap.put("f830113", FeatureParse.getCrossFeature(convReIds, cf.getOperatingResource()));
                retMap.put("f830114", FeatureParse.getCrossFeature(convTrIds, cf.getOperatingNewTrade()));
                DmpFeature dmpFeature = Optional.ofNullable(staticCf.getDmpFeature()).orElse(new DmpFeature());
                retMap.put("f9601", FeatureParse.getCrossFeature(staticCf.getUserBasicTags(), cf.getOperatingNewTrade()));
                retMap.put("f9602", FeatureParse.getCrossFeature(staticCf.getUserBasicTags(), cf.getOperatingResource()));
                retMap.put("f9603", FeatureParse.getCrossFeature(staticCf.getUserBasicTags(), DataUtil.Long2String((Long)cf.getAdvertId())));
                retMap.put("f9607", FeatureParse.getCrossFeature(dmpFeature.getValidAppList(), cf.getOperatingNewTrade()));
                retMap.put("f9608", FeatureParse.getCrossFeature(staticCf.getSigList(), cf.getOperatingNewTrade()));
                retMap.put("f9609", FeatureParse.getCrossFeature(staticCf.getSigList(), cf.getOperatingResource()));
                ItemProfileFeature itemProfileFeature = Optional.ofNullable(cf.getItemProfileFeature()).orElse(new ItemProfileFeature());
                retMap.put("f141001", itemProfileFeature.getName());
                retMap.put("f141002", itemProfileFeature.getCategoryTag());
                retMap.put("f141003", itemProfileFeature.getBrand());
                retMap.put("f141004", itemProfileFeature.getShop());
                retMap.put("f141010", itemProfileFeature.getTopCategory());
                retMap.put("f141011", itemProfileFeature.getSecondCategory());
                retMap.put("f141012", itemProfileFeature.getTags());
                retMap.put("f141013", itemProfileFeature.getOriginalPrice() == null ? null : FeatureParse.bucket(itemProfileFeature.getOriginalPrice().longValue(), priceBucket).toString());
                retMap.put("f141014", itemProfileFeature.getDealPrice() == null ? null : FeatureParse.bucket(itemProfileFeature.getDealPrice().longValue(), priceBucket).toString());
                retMap.put("f141015", itemProfileFeature.getNumber() == null ? null : itemProfileFeature.getNumber().toString());
                retMap.put("f141016", FeatureParse.bucket(itemProfileFeature.getDeliveryDays(), cntBucket).toString());
                retMap.put("f141018", FeatureParse.bucket(itemProfileFeature.getDaysOnSale(), cntBucket).toString());
                retMap.put("f142001", itemProfileFeature.getDynamicType());
                retMap.put("f142002", itemProfileFeature.getInterestPoint());
                Map materialRGBMap = DataUtil.stringToMap((String)itemProfileFeature.getMaterialPictureRGB(), (Object)0);
                retMap.put("f142003", FeatureParse.getUserCategoryActLevelByBucket(materialRGBMap, colorCodes, colorRBGBucket));
                Map layerRGBMap = DataUtil.stringToMap((String)itemProfileFeature.getLayerPictureRGB(), (Object)0);
                retMap.put("f142004", FeatureParse.getUserCategoryActLevelByBucket(layerRGBMap, colorCodes, colorRBGBucket));
                Map pictureRGBMap = DataUtil.stringToMap((String)itemProfileFeature.getPictureRGB(), (Object)0);
                retMap.put("f142005", FeatureParse.getUserCategoryActLevelByBucket(pictureRGBMap, colorCodes, colorRBGBucket));
                retMap.put("f142006", itemProfileFeature.getPriceTag());
                retMap.put("f142007", itemProfileFeature.getRegionTag());
                retMap.put("f142008", itemProfileFeature.getHistorySeasonTag());
                retMap.put("f142009", itemProfileFeature.getHolidaySeasonTag());
                retMap.put("f142010", itemProfileFeature.getCrowdTag());
                retMap.put("f142011", itemProfileFeature.getPromotionStrength());
                retMap.put("f142012", itemProfileFeature.getKeyword());
                retMap.put("f143001", FeatureParse.bucket(itemProfileFeature.getClickCnt(), bigCntBucket).toString());
                retMap.put("f143002", FeatureParse.bucket(itemProfileFeature.getWeekClickCnt(), bigCntBucket).toString());
                retMap.put("f143003", FeatureParse.bucket(itemProfileFeature.getDayClickCnt(), bigCntBucket).toString());
                retMap.put("f143004", FeatureParse.bucket(itemProfileFeature.getEffectCnt(), bigCntBucket).toString());
                retMap.put("f143005", FeatureParse.bucket(itemProfileFeature.getWeekEffectCnt(), bigCntBucket).toString());
                retMap.put("f143006", FeatureParse.bucket(itemProfileFeature.getDayEffectCnt(), bigCntBucket).toString());
                retMap.put("f143007", FeatureParse.bucket(itemProfileFeature.getIssueEffectCnt(), bigCntBucket).toString());
                retMap.put("f143008", FeatureParse.bucket(itemProfileFeature.getWeekIssueEffectCnt(), bigCntBucket).toString());
                retMap.put("f143009", FeatureParse.bucket(itemProfileFeature.getSignEffectCnt(), bigCntBucket).toString());
                retMap.put("f143010", FeatureParse.bucket(itemProfileFeature.getWeekSignEffectCnt(), bigCntBucket).toString());
                retMap.put("f144001", FeatureParse.bucket(itemProfileFeature.getCtr(), statCtrBucket).toString());
                retMap.put("f144002", FeatureParse.bucket(itemProfileFeature.getWeekCtr(), statCtrBucket).toString());
                retMap.put("f144003", FeatureParse.bucket(itemProfileFeature.getDayCtr(), statCtrBucket).toString());
                retMap.put("f144004", FeatureParse.bucket(itemProfileFeature.getCvr(), statCvrBucket).toString());
                retMap.put("f144005", FeatureParse.bucket(itemProfileFeature.getWeekCvr(), statCvrBucket).toString());
                retMap.put("f144006", FeatureParse.bucket(itemProfileFeature.getDayCvr(), statCvrBucket).toString());
                retMap.put("f144007", FeatureParse.bucket(itemProfileFeature.getIecvr(), statCvrBucket).toString());
                retMap.put("f144008", FeatureParse.bucket(itemProfileFeature.getWeekIecvr(), statCvrBucket).toString());
                retMap.put("f144009", FeatureParse.bucket(itemProfileFeature.getSecvr(), statCvrBucket).toString());
                retMap.put("f144010", FeatureParse.bucket(itemProfileFeature.getWeekSecvr(), statCvrBucket).toString());
            }
        }
        catch (Exception e) {
            logger.error("FeatureParse.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static String getAdAndSubType(Long advertId, String subType) {
        String ret = null;
        if (advertId != null) {
            Long retTmp = advertId + (FeatureParse.getSubType(subType) + 1L) * 1000000L;
            ret = retTmp + "";
        }
        return ret;
    }

    public static Long getSubType(String subType) {
        Long ret = 0L;
        if (subType != null) {
            ret = Long.valueOf(subType);
        }
        return ret;
    }

    public static Long getCtrIntervelLevel(Double ctr) {
        Long ret = null;
        ret = ctr == null ? Long.valueOf(-1L) : (ctr <= 0.999 ? Long.valueOf(Math.round(ctr * 100.0 / 3.0)) : Long.valueOf(-1L));
        return ret;
    }

    public static Long getCvrIntervelLevel(Double cvr) {
        Long ret = null;
        ret = cvr == null ? Long.valueOf(-1L) : (cvr <= 0.04 ? Long.valueOf(Math.round(cvr * 1000.0 / 4.0)) : (cvr <= 0.999 ? Long.valueOf(11L + Math.round((cvr - 0.04) * 100.0 / 3.0)) : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getOrderGmtIntervel(String date, String otherDate) {
        return LocalDateUtil.getIntervalMinutes((String)date, (String)otherDate, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
    }

    public static Long getOrderGmtIntervelLevel(String date, String otherDate) {
        Long ret = null;
        Long minutes = LocalDateUtil.getIntervalMinutes((String)date, (String)otherDate, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
        ret = minutes == null ? Long.valueOf(-1L) : (minutes <= 5L ? Long.valueOf(1L) : (minutes <= 10L ? Long.valueOf(2L) : (minutes <= 30L ? Long.valueOf(3L) : (minutes <= 60L ? Long.valueOf(4L) : Long.valueOf(99L)))));
        return ret;
    }

    public static Long getDayRankLevel(Long rank) {
        Long ret = null;
        ret = rank == null ? null : (rank <= 7L ? rank : Long.valueOf(-1L));
        return ret;
    }

    public static Long getRankLevel(Long rank) {
        Long ret = null;
        ret = rank == null ? null : (rank <= 15L ? rank : Long.valueOf(-1L));
        return ret;
    }

    public static Long getChargeStatus(Long chargeNums) {
        Long ret = null;
        ret = chargeNums == null || chargeNums < 1L ? Long.valueOf(0L) : Long.valueOf(1L);
        return ret;
    }

    public static Long getActivityChangeStatus(Long operatingActivityId, Long lastOperatingActivityId) {
        Long ret = null;
        ret = operatingActivityId == null || lastOperatingActivityId == null ? Long.valueOf(0L) : (operatingActivityId.equals(lastOperatingActivityId) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long getLastTagChangeStatus(String matchTagNums, String lastMatchTagNums) {
        Long ret = null;
        ret = matchTagNums == null || lastMatchTagNums == null ? Long.valueOf(0L) : (matchTagNums.equals(lastMatchTagNums) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long isOld(Date userLastlogbigintime, Date userRegtime) {
        Long dayIntervals;
        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{userLastlogbigintime, userRegtime}) && (dayIntervals = LocalDateUtil.getIntervalDays((Date)userLastlogbigintime, (Date)userRegtime)) != null) {
            ret = dayIntervals > 1L ? 1L : 0L;
        }
        return ret;
    }

    public static Long getCost(Long cost, Long price) {
        Long ret = null;
        if (cost != null && price != null && cost > 0L) {
            ret = new Double(Math.ceil(((double)price.longValue() + 1.0E-6) / (double)cost.longValue())).intValue();
        }
        return ret;
    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0L) {
            ret = new Double(Math.ceil(FeatureParse.log(lvalue.doubleValue(), 2 / 0))).intValue();
        }
        return ret;
    }

    public static String getLevel(String key, String idlist, String valueList) {
        String[] valueArr;
        String s = "";
        if (idlist == null || valueList == null || idlist.isEmpty() || valueList.isEmpty()) {
            return null;
        }
        String[] idArr = idlist.split(",");
        if (idArr.length != (valueArr = valueList.split(",")).length) {
            return null;
        }
        for (int i = 0; i < idArr.length; ++i) {
            double value = 0.0;
            try {
                value = Double.parseDouble(valueArr[i]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            catch (NullPointerException e) {
                continue;
            }
            s = s + idArr[i] + "&" + String.valueOf(FeatureParse.discretization(key, value)) + ",";
        }
        if (!s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static int discretization(String key, double value) {
        int class_id = 0;
        switch (key) {
            case "launch_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 1.0 & value <= 2.0) {
                    class_id = 3;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 4;
                    break;
                }
                if (value > 3.0 & value <= 4.0) {
                    class_id = 5;
                    break;
                }
                if (value > 4.0 & value <= 5.0) {
                    class_id = 6;
                    break;
                }
                if (value > 5.0 & value <= 6.0) {
                    class_id = 7;
                    break;
                }
                if (value > 6.0 & value <= 7.0) {
                    class_id = 8;
                    break;
                }
                if (value > 7.0 & value <= 18.0) {
                    class_id = 9;
                    break;
                }
                if (value > 18.0 & value <= 50.0) {
                    class_id = 10;
                    break;
                }
                if (value > 50.0 & value <= 150.0) {
                    class_id = 11;
                    break;
                }
                if (value > 150.0 & value <= 300.0) {
                    class_id = 12;
                    break;
                }
                class_id = 13;
                break;
            }
            case "click_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 3;
                    break;
                }
                if (value > 3.0 & value <= 4.0) {
                    class_id = 4;
                    break;
                }
                if (value > 4.0 & value <= 5.0) {
                    class_id = 5;
                    break;
                }
                if (value > 5.0 & value <= 6.0) {
                    class_id = 6;
                    break;
                }
                if (value > 6.0 & value <= 8.0) {
                    class_id = 7;
                    break;
                }
                if (value > 8.0 & value <= 15.0) {
                    class_id = 8;
                    break;
                }
                if (value > 15.0 & value <= 80.0) {
                    class_id = 9;
                    break;
                }
                if (value > 80.0 & value <= 225.0) {
                    class_id = 10;
                    break;
                }
                class_id = 11;
                break;
            }
            case "effect_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 1.0 & value <= 2.0) {
                    class_id = 3;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 4;
                    break;
                }
                if (value > 4.0 & value <= 15.0) {
                    class_id = 5;
                    break;
                }
                if (value > 15.0 & value <= 25.0) {
                    class_id = 6;
                    break;
                }
                if (value > 25.0 & value <= 70.0) {
                    class_id = 7;
                    break;
                }
                if (value > 70.0 & value <= 150.0) {
                    class_id = 8;
                    break;
                }
                if (value > 150.0 & value <= 225.0) {
                    class_id = 9;
                    break;
                }
                class_id = 10;
                break;
            }
            case "score": {
                class_id = value > -1.0E8 & value <= -471.0 ? 1 : (value > -471.0 & value <= -331.0 ? 2 : (value > -331.0 & value <= -168.0 ? 3 : (value > -168.0 & value <= -52.0 ? 4 : (value > -52.0 & value <= -19.0 ? 5 : (value > -19.0 & value <= -8.0 ? 6 : (value > -8.0 & value <= -4.0 ? 7 : (value > -4.0 & value <= 1.0 ? 8 : (value > 1.0 & value <= 2.0 ? 9 : (value > 2.0 & value <= 17.0 ? 10 : (value > 17.0 & value <= 42.0 ? 11 : (value > 42.0 & value <= 73.0 ? 12 : (value > 73.0 & value <= 126.0 ? 13 : (value > 126.0 & value <= 284.0 ? 14 : 15)))))))))))));
            }
        }
        return class_id;
    }

    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {
        String ret = null;
        try {
            Object tag;
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String((Long)ubpMap.get(statType).get("0"));
            }
            if (dimType == 1 && ubpMap != null && (tag = FeatureParse.getTag(tags)) != null) {
                ret = ubpMap.get(statType).get(tag) + "";
                if (((String)tag).length() == 10 && ret == null) {
                    String string = ((String)tag).substring(0, 5);
                    ret = DataUtil.Long2String((Long)ubpMap.get(statType).get(string));
                }
            }
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry entry : ubpMap.get(statType).entrySet()) {
                    String string = (String)entry.getKey() + "_" + entry.getValue() + ",";
                    ret = ret + string;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                HashMap<Long, Long> levelCntMap = new HashMap<Long, Long>();
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag2 = entry.getKey();
                    Long ctrLevel = FeatureParse.bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel == null || tag2 == "0") continue;
                    if (!levelCntMap.containsKey(ctrLevel)) {
                        levelCntMap.put(ctrLevel, 0L);
                    }
                    levelCntMap.put(ctrLevel, (Long)levelCntMap.get(ctrLevel) + 1L);
                }
                for (Map.Entry entry : levelCntMap.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    Long cntLevel = FeatureParse.bucket((Long)entry.getValue(), cntBucket);
                    String v = (Long)entry.getKey() * 100L + cntLevel + ",";
                    ret = ret + v;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getTag(String tags) {
        Object[] tagArr;
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tags) && AssertUtil.isNotEmpty((Object[])(tagArr = tags.split(",")))) {
            for (int i = 0; i < tagArr.length; ++i) {
                String tmp = FeatureParse.validTag((String)tagArr[i]);
                if (tmp == null) continue;
                ret = FeatureParse.validTag((String)tagArr[i]);
            }
        }
        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tag) && tag.contains(".")) {
            ret = tag;
        }
        return ret;
    }

    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds, String uILaunchPv, String uIClickPv, String uIEffectPv) {
        HashMap<String, Map<String, Long>> ret = new HashMap<String, Map<String, Long>>();
        ret.put("ctr", new HashMap());
        ret.put("cvr", new HashMap());
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{uIIds, uILaunchPv, uIClickPv, uIEffectPv})) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");
            if (uIIdsArr.length > 0 && uIIdsArr.length == uILaunchPvArr.length && uIIdsArr.length == uIClickPvArr.length && uIIdsArr.length == uIEffectPvArr.length) {
                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;
                for (int i = 0; i < uIIdsArr.length; ++i) {
                    String id = uIIdsArr[i];
                    Long launchPv = DataUtil.str2Long((String)uILaunchPvArr[i], (Long)0L);
                    Long clickPv = DataUtil.str2Long((String)uIClickPvArr[i], (Long)0L);
                    Long effectPv = DataUtil.str2Long((String)uIEffectPvArr[i], (Long)0L);
                    Double ctr = FeatureParse.getCtrOrCvr(launchPv, clickPv);
                    Double cvr = FeatureParse.getCtrOrCvr(clickPv, effectPv);
                    Long ctrBucketLevel = FeatureParse.bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = FeatureParse.bucket(cvr, userCvrBucket);
                    ((Map)ret.get("ctr")).put(id, ctrBucketLevel);
                    ((Map)ret.get("cvr")).put(id, cvrBucketLevel);
                    launchAccPv = launchAccPv + launchPv;
                    clickAccPv = clickAccPv + clickPv;
                    effectAccPv = effectAccPv + effectPv;
                }
                Double ctr = FeatureParse.getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = FeatureParse.getCtrOrCvr(clickAccPv, effectAccPv);
                Long ctrBucketLevel = FeatureParse.bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = FeatureParse.bucket(cvr, userCvrBucket);
                ((Map)ret.get("ctr")).put("0", ctrBucketLevel);
                ((Map)ret.get("cvr")).put("0", cvrBucketLevel);
            }
        }
        return ret;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{firstPv, secondPv}) && firstPv > 0L) {
            ret = DataUtil.division((Long)secondPv, (Long)firstPv);
        }
        return ret;
    }

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > (long)bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    public static String getSlotAreaType(Integer slotLength, Integer slotWidth) {
        int ret1 = 12;
        if (slotLength == null || slotWidth == null) {
            return String.valueOf(ret1);
        }
        try {
            Integer area = slotLength * slotWidth;
            if (area >= 0 && area <= 500000) {
                ret1 = area / 50000;
            }
            if (area > 500000 && area != null) {
                ret1 = 11;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(ret1);
    }

    public static String categoryIdAndCnt(Map<String, Long> categoryCount, Integer categoryType) {
        String ret1 = null;
        if (categoryCount == null) {
            return ret1;
        }
        if (categoryType == 1) {
            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    valueRet = value >= 1L && value <= 3L ? "g1" : (value >= 4L && value <= 10L ? "g2" : (value >= 11L && value <= 20L ? "g3" : "g4"));
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    valueRet = value == 1L ? "g1" : (value == 2L || value == 3L ? "g2" : (value >= 4L && value <= 8L ? "g3" : "g4"));
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret1;
    }

    public static Long getResourceOrderRank(String operatingResource, Map<String, Long> dayResourceOrderRank) {
        Long rank;
        Long ret = null;
        ret = operatingResource == null || dayResourceOrderRank == null ? null : ((rank = dayResourceOrderRank.get(operatingResource + "-770101")) == null || rank < 1L ? Long.valueOf(1L) : (rank <= 7L ? Long.valueOf(rank + 1L) : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getResourceOrderGmtIntervelLevel(String operatingResource, String currentGmtCreateTime, Map<String, String> resourceLastGmtCreateTime) {
        Long ret = null;
        if (operatingResource == null || currentGmtCreateTime == null || resourceLastGmtCreateTime == null) {
            ret = null;
        } else {
            String lastGmtCreateTime = resourceLastGmtCreateTime.get(operatingResource + "-770201");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long timeStamp = LocalDateUtil.getTimeMillis((String)currentGmtCreateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);
                if (timeStamp == null || otherTimeStamp == null) {
                    return ret;
                }
                Long seconds = Math.abs((timeStamp - otherTimeStamp) / 1000L);
                ret = seconds == null ? Long.valueOf(-1L) : (seconds <= 5L ? Long.valueOf(1L) : (seconds <= 10L ? Long.valueOf(2L) : (seconds <= 30L ? Long.valueOf(3L) : (seconds <= 60L ? Long.valueOf(4L) : (seconds <= 300L ? Long.valueOf(5L) : (seconds <= 600L ? Long.valueOf(6L) : (seconds <= 1800L ? Long.valueOf(7L) : (seconds <= 3600L ? Long.valueOf(8L) : (seconds <= 18000L ? Long.valueOf(9L) : (seconds <= 36000L ? Long.valueOf(10L) : (seconds <= 54000L ? Long.valueOf(11L) : (seconds <= 72000L ? Long.valueOf(12L) : (seconds <= 86400L ? Long.valueOf(13L) : (seconds <= 129600L ? Long.valueOf(14L) : (seconds <= 172800L ? Long.valueOf(15L) : Long.valueOf(99L))))))))))))))));
            }
        }
        return ret;
    }

    public static Long getResourceLastOrderIsClick(String operatingResource, Map<String, String> resourceLastLaunchOrderId, Map<String, String> resourceLastClickOrderId) {
        Long ret = null;
        if (operatingResource == null || resourceLastLaunchOrderId == null || resourceLastClickOrderId == null) {
            ret = null;
        } else {
            String lastLaunchOrderId = resourceLastLaunchOrderId.get(operatingResource + "-770301_1");
            String lastClickOrderId = resourceLastClickOrderId.get(operatingResource + "-770301_2");
            ret = lastLaunchOrderId == null ? null : (lastClickOrderId == null ? Long.valueOf(0L) : (lastLaunchOrderId.equals(lastClickOrderId) ? Long.valueOf(1L) : Long.valueOf(0L)));
        }
        return ret;
    }

    public static Long getResourceLastOrderIsConvert(String operatingResource, Map<String, String> resourceLastLaunchOrderId, Map<String, String> resourceLastConvertOrderId) {
        Long ret = null;
        if (operatingResource == null || resourceLastLaunchOrderId == null || resourceLastConvertOrderId == null) {
            ret = null;
        } else {
            String lastLaunchOrderId = resourceLastLaunchOrderId.get(operatingResource + "-770301_1");
            String lastConvertOrderId = resourceLastConvertOrderId.get(operatingResource + "-770301_3");
            ret = lastLaunchOrderId == null ? null : (lastConvertOrderId == null ? Long.valueOf(0L) : (lastLaunchOrderId.equals(lastConvertOrderId) ? Long.valueOf(1L) : Long.valueOf(0L)));
        }
        return ret;
    }

    public static Long getResourceChargeCnt(String operatingResource, Map<String, Long> dayResourceChargeCnt) {
        Long cnt;
        Long ret = null;
        ret = operatingResource == null || dayResourceChargeCnt == null ? null : ((cnt = dayResourceChargeCnt.get(operatingResource + "-770401")) == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= 7L ? cnt : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getResourceConvertCnt(String operatingResource, Map<String, Long> dayResourceConvertCnt) {
        Long cnt;
        Long ret = null;
        ret = operatingResource == null || dayResourceConvertCnt == null ? null : ((cnt = dayResourceConvertCnt.get(operatingResource + "-770402")) == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= 7L ? cnt : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getLastResourceEqualStatus(String operatingResource, String lastOperatingResource) {
        Long ret = null;
        ret = operatingResource == null && lastOperatingResource == null ? null : (operatingResource != null && lastOperatingResource != null ? (operatingResource.equals(lastOperatingResource) ? Long.valueOf(1L) : Long.valueOf(0L)) : Long.valueOf(0L));
        return ret;
    }

    public static Long getNewTradeOrderRank(String operatingNewTrade, Map<String, Long> newTradeDayOrderRank) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, newTradeDayOrderRank})) {
            Long rank = newTradeDayOrderRank.get(operatingNewTrade + "-660101");
            ret = rank == null || rank < 1L ? Long.valueOf(1L) : (rank <= 7L ? Long.valueOf(rank + 1L) : Long.valueOf(99L));
        }
        return ret;
    }

    public static Long getLastNewTradeEqualStatus(String operatingNewTrade, String lastOperatingNewTrade) {
        Long ret = 0L;
        if (AssertUtil.isAllEmpty((Object[])new Object[]{operatingNewTrade, lastOperatingNewTrade})) {
            ret = null;
        } else if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, lastOperatingNewTrade})) {
            ret = operatingNewTrade.equals(lastOperatingNewTrade) ? Long.valueOf(1L) : Long.valueOf(0L);
        }
        return ret;
    }

    public static Long getLastNewTradeGmtIntervelLevel(String operatingNewTrade, String currentGmtCreateTime, Map<String, String> newTradeLastGmtCreateTime) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, currentGmtCreateTime, newTradeLastGmtCreateTime})) {
            String lastGmtCreateTime = newTradeLastGmtCreateTime.get(operatingNewTrade + "-660301");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long otherTimeStamp;
                Long timeStamp = LocalDateUtil.getTimeMillis((String)currentGmtCreateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                if (AssertUtil.isAnyEmpty((Object[])new Object[]{timeStamp, otherTimeStamp = Long.valueOf(lastGmtCreateTime)})) {
                    return ret;
                }
                Long seconds = Math.abs((timeStamp - otherTimeStamp) / 1000L);
                ret = seconds == null ? Long.valueOf(-1L) : (seconds <= 5L ? Long.valueOf(1L) : (seconds <= 10L ? Long.valueOf(2L) : (seconds <= 30L ? Long.valueOf(3L) : (seconds <= 60L ? Long.valueOf(4L) : (seconds <= 300L ? Long.valueOf(5L) : (seconds <= 600L ? Long.valueOf(6L) : (seconds <= 1800L ? Long.valueOf(7L) : (seconds <= 3600L ? Long.valueOf(8L) : (seconds <= 18000L ? Long.valueOf(9L) : (seconds <= 36000L ? Long.valueOf(10L) : (seconds <= 54000L ? Long.valueOf(11L) : (seconds <= 72000L ? Long.valueOf(12L) : (seconds <= 86400L ? Long.valueOf(13L) : Long.valueOf(99L))))))))))))));
            }
        }
        return ret;
    }

    public static String getCtrOrCvrInKey(Map<String, Long> firstMap, Map<String, Long> secondMap, double[] statCtrOrCvrBucket) {
        String ret = null;
        try {
            if (AssertUtil.isNotEmpty(firstMap)) {
                for (Map.Entry<String, Long> entry : firstMap.entrySet()) {
                    String key = entry.getKey();
                    if (key == null) continue;
                    Long firstPv = entry.getValue();
                    if (firstPv == null) {
                        firstPv = 0L;
                    }
                    Long secondPv = 0L;
                    if (AssertUtil.isNotEmpty(secondMap)) {
                        secondPv = secondMap.getOrDefault(key, 0L);
                    }
                    Double value = FeatureParse.getCtrOrCvr(firstPv, secondPv);
                    Long valueLevel = FeatureParse.bucket(value, statCtrOrCvrBucket);
                    String tmpRet = key + "&" + DataUtil.Long2String((Long)valueLevel);
                    ret = ret + "," + tmpRet;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getStatInNewTrade(String statType, Map<String, Map<String, Long>> newTradeMap) {
        String ret = null;
        try {
            if (AssertUtil.isNotEmpty(newTradeMap)) {
                Map<String, Long> launchMap = newTradeMap.get("launch");
                Map<String, Long> clickMap = newTradeMap.get("click");
                Map<String, Long> effectMap = newTradeMap.get("effect");
                if (statType == "ctr") {
                    if (AssertUtil.isNotEmpty(launchMap)) {
                        ret = FeatureParse.getCtrOrCvrInKey(launchMap, clickMap, statCtrBucket);
                    }
                } else if (statType == "cvr" && AssertUtil.isNotEmpty(clickMap)) {
                    ret = FeatureParse.getCtrOrCvrInKey(clickMap, effectMap, statCvrBucket);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getStatInAppTag(String statType, Map<String, Map<String, Long>> appTagMap) {
        String ret = null;
        try {
            if (AssertUtil.isNotEmpty(appTagMap)) {
                Map<String, Long> launchMap = appTagMap.get("launch");
                Map<String, Long> clickMap = appTagMap.get("click");
                Map<String, Long> effectMap = appTagMap.get("effect");
                if (statType == "ctr") {
                    if (AssertUtil.isNotEmpty(launchMap)) {
                        ret = FeatureParse.getCtrOrCvrInKey(launchMap, clickMap, statCtrBucket);
                    }
                } else if (statType == "cvr" && AssertUtil.isNotEmpty(clickMap)) {
                    ret = FeatureParse.getCtrOrCvrInKey(clickMap, effectMap, statCvrBucket);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getCrossFeature(String ids, String id0) {
        String ret = null;
        if (ids == null || "".equals(ids) || " ".equals(ids) || ",".equals(ids) || id0 == null || "".equals(id0) || " ".equals(id0)) {
            ret = "null";
        } else {
            ArrayList<String> crossFeature = new ArrayList<String>();
            try {
                for (String id : ids.split(",")) {
                    if (id == "" || id == " ") continue;
                    crossFeature.add(id + "_" + id0);
                }
                if (crossFeature.size() > 0) {
                    ret = Joiner.on((String)",").skipNulls().join(crossFeature);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ret == null || ret == "" || ret == " " || ret == ",") {
            ret = "null";
        }
        if (!ret.equalsIgnoreCase("null")) {
            ret = "null," + ret;
        }
        return ret;
    }

    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (Map.Entry<String, Integer> entry : actMap.entrySet()) {
                String cateKey = entry.getKey();
                Integer cateValue = entry.getValue();
                if (!category.containsKey(cateKey)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + FeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, double[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (String cateKey : actMap.keySet()) {
                Double cateValue = actMap.getDouble(cateKey);
                if (!category.containsKey(cateKey)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + FeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static Long getUserSignRatioBucket(Long signEffect, Long issueEffect, double[] bucket) {
        long ret = 0L;
        if (signEffect == null || issueEffect == null || bucket == null || issueEffect == 0L) {
            return ret;
        }
        return FeatureParse.bucket(signEffect.doubleValue() / (double)issueEffect.longValue(), bucket);
    }

    public static void main(String[] args) {
        FeatureDo featureDo = new FeatureDo();
        SlotActFeature slotActFeature = new SlotActFeature();
        slotActFeature.setCvrCate("{\"07.23.0009\":0.006623,\"07.23.0013\":0.003937,\"07.23.0008\":0.014913,\"07.23.0010\":0.007813}");
        slotActFeature.setConvertAdSet("52641,65586,49829,63525");
        slotActFeature.setIssueRatioAccount("{\"18943\":0.090909,\"18489\":0.142857}");
        slotActFeature.setPriceRegionCntRatio("{\"0\":0.333333,\"1\":0.333333,\"3\":0.333333}");
        slotActFeature.setRejectCntRatio(0.586207);
        slotActFeature.setClickCntRatioCate("{\"07.23.0008\":0}");
        slotActFeature.setCtrCate("{\"07.23.0008\":0.266129,\"07.23.0010\":0.333333,\"07.23.0009\":0.75,\"07.23.0013\":0.5}");
        slotActFeature.setConvertCntRatioCate("{\"07.23.0008\":1}");
        featureDo.setSlotActFeature(slotActFeature);
        ItemProfileFeature itemProfileFeature = new ItemProfileFeature();
        itemProfileFeature.setClickCnt(4503L);
        featureDo.setItemProfileFeature(itemProfileFeature);
        Map<String, String> res1 = FeatureParse.generateFeatureMapStatic(featureDo);
        Map<String, String> res2 = FeatureParse.generateFeatureMapDynamic(featureDo, featureDo);
        System.out.println(res1.get("f221003"));
        System.out.println(res1.get("f222001"));
        System.out.println(res2.get("f143001"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "123");
        map.put("b", "45");
        System.out.println(map.toString());
    }

    public static int countFeatures(String valueList) {
        if (valueList == null) {
            return -1;
        }
        if (valueList.isEmpty()) {
            return 0;
        }
        String[] idArr = valueList.split(",");
        if (idArr == null) {
            return -1;
        }
        return idArr.length;
    }
}

