package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.ActSubTitleNameParseVo;
import cn.com.duiba.nezha.alg.feature.vo.ActTitleFeatureDo;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by pc on 2019/2/21.
 */
public class ActTitleFeatureParse {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(ActTitleFeatureParse.class);


    public static Map<String, String> generateFeatureMapStatic(ActTitleFeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                retMap.put("f201001", DataUtil.Long2String(cf.getAppId()));
                retMap.put("f108002", DataUtil.Long2String(cf.getSlotId()));

                retMap.put("f301001", DataUtil.Long2String(cf.getActivityId()));
                retMap.put("f311001", DataUtil.Long2String(cf.getActivityPage()));
                retMap.put("f312001", DataUtil.Long2String(cf.getDsm2A()));
                retMap.put("f315001", cf.getActivitySkin());


                retMap.put("f4010030", DataUtil.Long2String(cf.getAreaCode()));

                /**
                 * 地域解析
                 */
                Long regionLevel = FeatureBaseParse.getRegionLevel(cf.getAreaCode());
                retMap.put("f4010031", DataUtil.Long2String(regionLevel)); // 地区级别（华北/东北/华东/华中/华南/西南/西北/港澳）
                Long tierCityLevel = FeatureBaseParse.getTierCityLevel(cf.getAreaCode());
                retMap.put("f4010032", DataUtil.Long2String(tierCityLevel)); // 城市级别（一线/二线/三线）


                Integer hour = LocalDateUtil.getHour(LocalDateTime.now());
                retMap.put("f502001", DataUtil.Integer2String(hour)); // 竞价请求创建时间-小时

                Integer weekDay = LocalDateUtil.getDayOfWeek(LocalDateTime.now());
                retMap.put("f502002", DataUtil.Integer2String(weekDay)); // 竞价请求创建时间-星期几


            }

        } catch (Exception e) {

            logger.error("ActFeatureParse.generateFeatureMapStatic error:" + e);
        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapPrizeId(Long activitySubTitlePrizeId) {

        Map<String, String> retMap = new HashMap<>(8);
        try {
            if (activitySubTitlePrizeId != null) {
                retMap.put("f322001", DataUtil.Long2String(activitySubTitlePrizeId));
            }
        } catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapPrizeId error:", e);

        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(ActTitleFeatureDo cf, ActTitleFeatureDo staticCf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                retMap.put("f316001", DataUtil.Long2String(cf.getActivityTitleId()));
                retMap.put("f317001", DataUtil.Long2String(cf.getActivitySubTitleId()));

                retMap.put("f318001", DataUtil.Long2String(cf.getActivityTitleTagId()));
                retMap.put("f319001", DataUtil.Long2String(cf.getActivitySubTitleTagId()));


                retMap.put("f320001", cf.getActivityTitleName());
                retMap.put("f321001", cf.getActivitySubTitleName());

                retMap.put("f322001", DataUtil.Long2String(cf.getActivitySubTitlePrizeId()));


                ActSubTitleNameParseVo actSubTitleNameParseVo = FeatureBaseParse.parseActTitleName(cf.getActivitySubTitleName());

                retMap.put("f321002", DataUtil.Long2String(actSubTitleNameParseVo.getWeekTypeNums()));//副标题标签是否含周几
                retMap.put("f321003", DataUtil.Long2String(actSubTitleNameParseVo.getFestivalTypeNums()));//副标题标签是否含节假日
                retMap.put("f321004", DataUtil.Long2String(actSubTitleNameParseVo.getAreaTypeNums()));//副标题标签是否含地域
                retMap.put("f321005", DataUtil.Long2String(actSubTitleNameParseVo.getDynamicTypeNums()));//副标题标签动态信息数量

                retMap.put("f321006", DataUtil.Long2String(actSubTitleNameParseVo.getSize()));//副标题标签长度

                ActSubTitleNameParseVo actTitleNameParseVo = FeatureBaseParse.parseActTitleName(cf.getActivityTitleName());

                retMap.put("f321007", DataUtil.Long2String(actTitleNameParseVo.getSize()));//标题标签长度

                retMap.put("f321008", DataUtil.Long2String(actSubTitleNameParseVo.getPrizeTypeNums()));//副标题标签是否含奖品
            }
        } catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapDynamic error:", e);

        }
        return retMap;
    }


    //测试
    public static void main(String[] args) {

        ActTitleFeatureDo actFeatureDo1 = new ActTitleFeatureDo();
        actFeatureDo1.setActivityId(1L);
        actFeatureDo1.setActivityPage(2L);
        actFeatureDo1.setAppId(3L);
        actFeatureDo1.setSlotId(5L);
        actFeatureDo1.setAreaCode(4L);
        actFeatureDo1.setActivityTitleId(100L);
        actFeatureDo1.setActivitySubTitleId(101L);
        actFeatureDo1.setActivityTitleTagId(201L);
        actFeatureDo1.setActivitySubTitleTagId(201L);
        actFeatureDo1.setActivityTitleName("主标题");
        actFeatureDo1.setActivitySubTitleName("副标题");
        actFeatureDo1.setDsm2A(6L);

        Map<String, String> staticFeatureMap = ActTitleFeatureParse.generateFeatureMapStatic(actFeatureDo1);
        Map<String, String> dynamicFeatureMap = ActTitleFeatureParse.generateFeatureMapDynamic(actFeatureDo1, actFeatureDo1);
        dynamicFeatureMap.putAll(staticFeatureMap);

        System.out.println(JSON.toJSONString(dynamicFeatureMap));

//        Map<String,String> map1 = ActTitleFeatureParse.generateFeatureMapStatic(actFeatureDo1);

//        ActFeatureDo actFeatureDo2 = new ActFeatureDo();
//        actFeatureDo2.setResPlugInId(8L);
//        actFeatureDo2.setResPlugInIndex(9L);

//
//        Map<String,String> map2 = ActTitleFeatureParse.generateFeatureMapDynamic(actFeatureDo2,actFeatureDo1);
//        System.out.println("staticMap1=" + JSON.toJSONString(map2));
//        map2.putAll(map1);
//
//        System.out.println("staticMap1=" + JSON.toJSONString(map2));
//
//

//        String name=null;
//        ActSubTitleNameParseVo actSubTitleNameParseVo = FeatureBaseParse.parseActTitleName(name);
//        System.out.println("staticMap1=" + JSON.toJSONString(actSubTitleNameParseVo));

    }

}