package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.*;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.*;

/**
 * @author lijingzhe
 * @description DPA活动解析
 * @date 2020/6/17
 */
public class DPAActFeatureParse {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DPAActFeatureParse.class);

    public static int F_MAX_SIZE = 64;
    public static int[] cntBucket = {0, 1, 3, 5, 10, 15, 20};
    public static int[] ctrAndCvrLevelBucket = {1, 4, 8};
    public static double[] userCtrBucket = {0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userCvrBucket = {0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static int[] videoDurationBucket = {0, 15, 30, 60, 5*60, 10*60, 15*60, 30*60, 45*60, 60*60, 90*60, 120*60};
    public static double[] cntRatioBucket = {0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
    public static double[] statCtrBucket = {0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.40, 0.45, 0.50, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] statCvrBucket = {0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.20, 0.25, 0.30, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static int[] cateScoreBucket = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20};

    public static Integer[] HUABEI_REGION = {80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = {81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = {82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = {83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = {84, 44, 45, 46};
    public static Integer[] XINAN_REGION = {85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = {86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = {87, 71, 8100, 8200};

    public static Integer[] FIRST_TIER_CITY = {11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = {1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = {1309,1303,1502,2202,3207,3209,3305,3412,3509,3611,3708,3703,4114,4110,4210,4307,4306,4407,4408,4601,5107,6104,1304,1302,1501,2306,3212,3210,3403,3407,3503,3607,3609,3713,4103,4107,4108,4206,4304,4302,4452,4412,4503,4602,5203,6301,1310,1305,2103,3208,3213,3211,3411,3402,3506,3604,3717,3710,4113,4115,4211,4205,4303,4451,4405,4404,4502,5106,5303,6401};


//    public static Map<String, String> generateDPAFeature(DPAFeature dpa) {
//        Map<String, String> retMap = new HashMap<>();
//        if (dpa != null) {
//
//
//            // 活动访问时间 !!!
////            Integer hour= LocalDateUtil.getHour(LocalDateTime.now());
////            retMap.put("f509001", DataUtil.Integer2String(hour)); // 访问请求创建时间-小时
////
////            Integer weekDay = LocalDateUtil.getDayOfWeek(LocalDateTime.now());
////            retMap.put("f509002", DataUtil.Integer2String(weekDay)); // 访问请求创建时间-星期几
//
//
//
////            retMap.put("f301009", dpa.getRoutineActSkinType());
////            // !!!
////            JSONObject routineActPrizeCategory = DataUtil.stringToJson(dpa.getRoutineActPrizeCategory());
////            retMap.put("f301010", getStringsToBuckets(routineActPrizeCategory, 50));
////            JSONObject routineActPrizeId = DataUtil.stringToJson(dpa.getRoutineActPrizeId());
////            retMap.put("f301011", getStringsToBuckets(routineActPrizeId, 5000));
////
////            retMap.put("f301012", DataUtil.Integer2String(dpa.getRoutineActSkinId()));
////            retMap.put("f301013", DataUtil.Integer2String(dpa.getRoutineActMainTitleId()));
////            retMap.put("f301014", DataUtil.Integer2String(dpa.getRoutineActSubTitleId()));
//
//
//
//        }
//
//        return retMap;
//    }

    public static Map<String, String> generateFeatureMapStatic(DPAActFeatureDo dpa) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if (dpa != null) {
            retMap.put("f201001",DataUtil.Long2String(dpa.getAppId()));
            retMap.put("f108001",DataUtil.Long2String(dpa.getSlotId()));
            retMap.put("f501001", dpa.getUa());
            retMap.put("f505001", dpa.getPriceSection());
            retMap.put("f503001",DataUtil.Long2String(dpa.getAreaCode()));
            // 素材特征
            retMap.put("390000", dpa.getMaterialId());
            /*
             * 地域解析
             */
            Long regionLevel = getRegionLevel(dpa.getAreaCode());
            retMap.put("f4010031", DataUtil.Long2String(regionLevel)); // 地区级别（华北/东北/华东/华中/华南/西南/西北/港澳）
            Long tierCityLevel = getTierCityLevel(dpa.getAreaCode());
            retMap.put("f4010032", DataUtil.Long2String(tierCityLevel)); // 城市级别（一线/二线/三线）

            Integer hour= LocalDateUtil.getHour(LocalDateTime.now());
            retMap.put("f502001", DataUtil.Integer2String(hour)); // 访问请求创建时间-小时

            Integer weekDay = LocalDateUtil.getDayOfWeek(LocalDateTime.now());
            retMap.put("f502002", DataUtil.Integer2String(weekDay)); // 访问请求创建时间-星期几
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapSlotAct(SlotActFeature slotActFeature) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if(slotActFeature != null) {
            // 点击
            JSONObject clickCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getClickCntRatioTrade());
            retMap.put("f211001", getUserCategoryActLevelByBucket(clickCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject clickCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getClickCntRatioAccount());
            retMap.put("f211002", getUserCategoryActLevelByBucket(clickCntRatioAccountMap, accountCodes, cntRatioBucket));
            JSONObject weekClickCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getWeekClickCntRatioTrade());
            retMap.put("f211003", getUserCategoryActLevelByBucket(weekClickCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject weekClickCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getWeekClickCntRatioAccount());
            retMap.put("f211004", getUserCategoryActLevelByBucket(weekClickCntRatioAccountMap, accountCodes, cntRatioBucket));

            JSONObject ctrTradeMap = DataUtil.stringToJson(slotActFeature.getCtrTrade());
            retMap.put("f212001", getUserCategoryActLevelByBucket(ctrTradeMap, tradeCodes, statCtrBucket));
            JSONObject ctrAccountMap = DataUtil.stringToJson(slotActFeature.getCtrAccount());
            retMap.put("f212002", getUserCategoryActLevelByBucket(ctrAccountMap, accountCodes, statCtrBucket));
            JSONObject weekCtrTradeMap = DataUtil.stringToJson(slotActFeature.getWeekCtrTrade());
            retMap.put("f212003", getUserCategoryActLevelByBucket(weekCtrTradeMap, tradeCodes, statCtrBucket));
            JSONObject weekCtrAccountMap = DataUtil.stringToJson(slotActFeature.getWeekCtrAccount());
            retMap.put("f212004", getUserCategoryActLevelByBucket(weekCtrAccountMap, accountCodes, statCtrBucket));

            // 前端转化
            JSONObject convertCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getConvertCntRatioTrade());
            retMap.put("f213001", getUserCategoryActLevelByBucket(convertCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject convertCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getConvertCntRatioAccount());
            retMap.put("f213002", getUserCategoryActLevelByBucket(convertCntRatioAccountMap, accountCodes, cntRatioBucket));
            JSONObject weekConvertCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getWeekConvertCntRatioTrade());
            retMap.put("f213003", getUserCategoryActLevelByBucket(weekConvertCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject weekConvertCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getWeekConvertCntRatioAccount());
            retMap.put("f213004", getUserCategoryActLevelByBucket(weekConvertCntRatioAccountMap, accountCodes, cntRatioBucket));

            JSONObject cvrTradeMap = DataUtil.stringToJson(slotActFeature.getCvrTrade());
            retMap.put("f214001", getUserCategoryActLevelByBucket(cvrTradeMap, tradeCodes, statCvrBucket));
            JSONObject cvrAccountMap = DataUtil.stringToJson(slotActFeature.getCvrAccount());
            retMap.put("f214002", getUserCategoryActLevelByBucket(cvrAccountMap, accountCodes, statCvrBucket));
            JSONObject weekCvrTradeMap = DataUtil.stringToJson(slotActFeature.getWeekCvrTrade());
            retMap.put("f214003", getUserCategoryActLevelByBucket(weekCvrTradeMap, tradeCodes, statCvrBucket));
            JSONObject weekCvrAccountMap = DataUtil.stringToJson(slotActFeature.getWeekCvrAccount());
            retMap.put("f214004", getUserCategoryActLevelByBucket(weekCvrAccountMap, accountCodes, statCvrBucket));

            // 流量行为 -- 活动参与

            // 活动类型
            JSONObject appSlotActsCateHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateHistClick());
            retMap.put("f230001", getCategoryJsonByBucket(appSlotActsCateHistClick, userCtrBucket));

            JSONObject appSlotActsCateWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateWeekClick());
            retMap.put("f230002", getCategoryJsonByBucket(appSlotActsCateWeekClick, userCtrBucket));

            retMap.put("f230003", getCategoryMapByBucket(slotActFeature.getAppSlotActsCateDayClick(), userCtrBucket));

            // 主标题
            JSONObject appSlotMainTitlesHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotMainTitlesHistClick());
            retMap.put("f230004", getCategoryJsonByBucket(appSlotMainTitlesHistClick, userCtrBucket));

            JSONObject appSlotMainTitlesWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotMainTitlesWeekClick());
            retMap.put("f230005", getCategoryJsonByBucket(appSlotMainTitlesWeekClick, userCtrBucket));

            retMap.put("f230006", getCategoryMapByBucket(slotActFeature.getAppSlotMainTitlesDayClick(), userCtrBucket));

            // 副标题
            JSONObject appSlotSubTitlesHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotSubTitlesHistClick());
            retMap.put("f230007", getCategoryJsonByBucket(appSlotSubTitlesHistClick, userCtrBucket));

            JSONObject appSlotSubTitlesWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotSubTitlesWeekClick());
            retMap.put("f230008", getCategoryJsonByBucket(appSlotSubTitlesWeekClick, userCtrBucket));

            retMap.put("f230009", getCategoryMapByBucket(slotActFeature.getAppSlotSubTitlesDayClick(), userCtrBucket));

            // 奖品
            JSONObject appSlotPrizeHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotPrizeHistClick());
            retMap.put("f230010", getCategoryJsonByBucket(appSlotPrizeHistClick, userCtrBucket));

            JSONObject appSlotPrizeWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotPrizeWeekClick());
            retMap.put("f230011", getCategoryJsonByBucket(appSlotPrizeWeekClick, userCtrBucket));

            retMap.put("f230012", getCategoryMapByBucket(slotActFeature.getAppSlotPrizeDayClick(), userCtrBucket));

            // 活动皮肤
            JSONObject appSlotSkinCateHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotSkinCateHistClick());
            retMap.put("f230013", getCategoryJsonByBucket(appSlotSkinCateHistClick, userCtrBucket));

            JSONObject appSlotSkinCateWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotSkinCateWeekClick());
            retMap.put("f230014", getCategoryJsonByBucket(appSlotSkinCateWeekClick, userCtrBucket));

            retMap.put("f230015", getCategoryMapByBucket(slotActFeature.getAppSlotSkinCateDayClick(), userCtrBucket));

            // 历史不同行业标签（媒体）类型上的参与率
            JSONObject appSlotMediaCateHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotMediaCateHistClick());
            retMap.put("f230016", getCategoryJsonByBucket(appSlotMediaCateHistClick, userCtrBucket));

            JSONObject appSlotMediaCateWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotMediaCateWeekClick());
            retMap.put("f230017", getCategoryJsonByBucket(appSlotMediaCateWeekClick, userCtrBucket));

            retMap.put("f230018", getCategoryMapByBucket(slotActFeature.getAppSlotMediaCateDayClick(), userCtrBucket));

            // 落地页转化/活动访问
            // 活动类型
            JSONObject appSlotActsCateHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateHistOrder());
            retMap.put("f231001", getCategoryJsonByBucket(appSlotActsCateHistOrder, userCtrBucket));

            JSONObject appSlotActsCateWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateWeekOrder());
            retMap.put("f231002", getCategoryJsonByBucket(appSlotActsCateWeekOrder, userCtrBucket));

            retMap.put("f231003", getCategoryMapByBucket(slotActFeature.getAppSlotActsCateDayOrder(), userCtrBucket));

            // 主标题
            JSONObject appSlotMainTitlesHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotMainTitlesHistOrder());
            retMap.put("f231004", getCategoryJsonByBucket(appSlotMainTitlesHistOrder, userCtrBucket));

            JSONObject appSlotMainTitlesWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotMainTitlesWeekOrder());
            retMap.put("f231005", getCategoryJsonByBucket(appSlotMainTitlesWeekOrder, userCtrBucket));

            retMap.put("f231006", getCategoryMapByBucket(slotActFeature.getAppSlotMainTitlesDayOrder(), userCtrBucket));

            // 副标题
            JSONObject appSlotSubTitlesHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotSubTitlesHistOrder());
            retMap.put("f231007", getCategoryJsonByBucket(appSlotSubTitlesHistOrder, userCtrBucket));

            JSONObject appSlotSubTitlesWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotSubTitlesWeekOrder());
            retMap.put("f231008", getCategoryJsonByBucket(appSlotSubTitlesWeekOrder, userCtrBucket));

            retMap.put("f231009", getCategoryMapByBucket(slotActFeature.getAppSlotSubTitlesDayOrder(), userCtrBucket));

            // 奖品
            JSONObject appSlotPrizeHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotPrizeHistOrder());
            retMap.put("f231010", getCategoryJsonByBucket(appSlotPrizeHistOrder, userCtrBucket));

            JSONObject appSlotPrizeWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotPrizeWeekOrder());
            retMap.put("f231011", getCategoryJsonByBucket(appSlotPrizeWeekOrder, userCtrBucket));

            retMap.put("f231012", getCategoryMapByBucket(slotActFeature.getAppSlotPrizeDayOrder(), userCtrBucket));

            // 活动皮肤
            JSONObject appSlotSkinCateHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotSkinCateHistOrder());
            retMap.put("f231013", getCategoryJsonByBucket(appSlotSkinCateHistOrder, userCtrBucket));

            JSONObject appSlotSkinCateWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotSkinCateWeekOrder());
            retMap.put("f231014", getCategoryJsonByBucket(appSlotSkinCateWeekOrder, userCtrBucket));

            retMap.put("f231015", getCategoryMapByBucket(slotActFeature.getAppSlotSkinCateDayOrder(), userCtrBucket));

            // 历史不同行业标签（媒体）类型上的参与率
            JSONObject appSlotMediaCateHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotMediaCateHistOrder());
            retMap.put("f231016", getCategoryJsonByBucket(appSlotMediaCateHistOrder, userCtrBucket));

            JSONObject appSlotMediaCateWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotMediaCateWeekOrder());
            retMap.put("f231017", getCategoryJsonByBucket(appSlotMediaCateWeekOrder, userCtrBucket));

            retMap.put("f231018", getCategoryMapByBucket(slotActFeature.getAppSlotMediaCateDayOrder(), userCtrBucket));

            // 活动类型
            JSONObject appSlotActsCateHistConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateHistConsumer());
            retMap.put("f232001", getCategoryJsonByBucket(appSlotActsCateHistConsumer, userCtrBucket));

            JSONObject appSlotActsCateWeekConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateWeekConsumer());
            retMap.put("f232002", getCategoryJsonByBucket(appSlotActsCateWeekConsumer, userCtrBucket));



            // 行业点击率
            retMap.put("f211005", getCategoryMapByBucket(slotActFeature.getDayTradeClickPart(), userCtrBucket));
            retMap.put("f211006", getCategoryMapByBucket(slotActFeature.getDayAccountClickPart(), userCtrBucket));
            retMap.put("f212005", getCategoryMapByBucket(slotActFeature.getDayTradeClickPart(), userCtrBucket));
            retMap.put("f212006", getCategoryMapByBucket(slotActFeature.getDayAccountClickPart(), userCtrBucket));
            retMap.put("f213005", getCategoryMapByBucket(slotActFeature.getDayTradeOrderPart(), userCtrBucket));
            retMap.put("f213006", getCategoryMapByBucket(slotActFeature.getDayAccountOrderPart(), userCtrBucket));
            retMap.put("f214005", getCategoryMapByBucket(slotActFeature.getDayTradeOrderRate(), userCtrBucket));
            retMap.put("f214006", getCategoryMapByBucket(slotActFeature.getDayAccountOrderRate(), userCtrBucket));

        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapUserProfile(UserProfileFeature userProfileFeature) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if(userProfileFeature != null) {
            retMap.put("f451001", userProfileFeature.getSex());
            retMap.put("f451002", userProfileFeature.getAge());
            retMap.put("f451003", userProfileFeature.getMarry());
            retMap.put("f451004", userProfileFeature.getConsumeLevel());
//            Map<String, Integer> appCatePrefMap = DataUtil.stringToMap(userProfileFeature.getAppCatePref(), 0);
//            retMap.put("f461001", getUserCategoryActLevelByBucket(appCatePrefMap, appCodes, cntBucket));
//            Map<String, Integer> recentAppCatePrefMap = DataUtil.stringToMap(userProfileFeature.getRecentAppCatePref(), 0);
//            retMap.put("f461002", getUserCategoryActLevelByBucket(recentAppCatePrefMap, appCodes, cntBucket));
//            Map<String, Integer> recentTextCatePrefMap = DataUtil.stringToMap(userProfileFeature.getRecentTextCatePref(), 0);
//            retMap.put("f461004", getUserCategoryActLevelByBucket(recentTextCatePrefMap, msgSigCodes, cntBucket));
//            Map<String, Integer> keywordCatePrefMap = DataUtil.stringToMap(userProfileFeature.getKeywordCatePref(), 0);
//            retMap.put("f461005", getUserCategoryActLevelByBucket(keywordCatePrefMap, keywordCodes, cntBucket));
//            retMap.put("f461011", userProfileFeature.getRecentVideoKeywordPref());
//            Map<String, Integer> scoreCateInterestMap = DataUtil.stringToMap(userProfileFeature.getScoreCateInterest(), 0);
//            retMap.put("f471003", getUserCategoryActLevelByBucket(scoreCateInterestMap, resourceCodes, cateScoreBucket));
        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapBase(FeatureDo fd) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if(fd != null) {
            retMap.put("f9921", fd.getUICtr());
            retMap.put("f9922", fd.getUICvr());
            retMap.put("f9923", fd.getUUnICtr());
            retMap.put("f9924", fd.getUUnICvr());
            Map<String, Map<String, Long>> ubpMap = getUserBehavioralPreference(
                    fd.getUIIds(), fd.getUILaunchPV(), fd.getUIClickPv(), fd.getUIEffectPv());

            retMap.put("f808001", getUserBehavioralPreference(2, "ctr", ubpMap, null));
            retMap.put("f809001", getUserBehavioralPreference(0, "ctr", ubpMap, null));
            retMap.put("f811001", getUserBehavioralPreference(3, "ctr", ubpMap, null));
            retMap.put("f808002", getUserBehavioralPreference(2, "cvr", ubpMap, null));
            retMap.put("f809002", getUserBehavioralPreference(0, "cvr", ubpMap, null));
            retMap.put("f811002", getUserBehavioralPreference(3, "cvr", ubpMap, null));

        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapUserAct(UserActFeature userActFeature) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if(userActFeature != null) {
            // 生命周期
            retMap.put("f410001", bucket(userActFeature.getUserActiveDays(), cntBucket).toString());

            // 活动访问
            retMap.put("f411001", bucket(userActFeature.getActivityRequest(), cntBucket).toString());
            retMap.put("f411002", bucket(userActFeature.getWeekActivityRequest(), cntBucket).toString());
            retMap.put("f411003", bucket(userActFeature.getDayActivityRequest(), cntBucket).toString());
            retMap.put("f411004", bucket(userActFeature.getIntervalActivityRequest(), cntBucket).toString());
            retMap.put("f411005", userActFeature.getPeriodActivityRequest());

            // 活动参与
            retMap.put("f412001", bucket(userActFeature.getActivityJoin(), cntBucket).toString());
            retMap.put("f412002", bucket(userActFeature.getWeekActivityJoin(), cntBucket).toString());
            retMap.put("f412003", bucket(userActFeature.getDayActivityJoin(), cntBucket).toString());
            retMap.put("f412004", bucket(userActFeature.getIntervalActivityJoin(), cntBucket).toString());
            retMap.put("f412005", userActFeature.getPeriodActivityJoin());

            // 点击
            Map<String, Integer> clickTraceActMap = DataUtil.stringToMap(userActFeature.getClickTrade(), 0);
            retMap.put("f414001", getUserCategoryActLevelByBucket(clickTraceActMap, tradeCodes, cntBucket));
            Map<String, Integer> weekClickTradeActMap = DataUtil.stringToMap(userActFeature.getWeekClickTrade(), 0);
            retMap.put("f414002", getUserCategoryActLevelByBucket(weekClickTradeActMap, tradeCodes, cntBucket));
            retMap.put("f414003", getUserCategoryActLevelByBucket(userActFeature.getDayClickTrade(), tradeCodes, cntBucket));
            retMap.put("f414004", bucket(userActFeature.getIntervalClickTrade(), cntBucket).toString());
            retMap.put("f414005", userActFeature.getPeriodClickTrade());
            retMap.put("f414007", userActFeature.getLastClickTrade());
            retMap.put("f414008", userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade().toString());

            // 转化
            Map<String, Integer> effectTradeActMap = DataUtil.stringToMap(userActFeature.getEffectTrade(), 0);
            retMap.put("f415001", getUserCategoryActLevelByBucket(effectTradeActMap, tradeCodes, cntBucket));
            Map<String, Integer> weekEffectTradeActMap = DataUtil.stringToMap(userActFeature.getWeekEffectTrade(), 0);
            retMap.put("f415002", getUserCategoryActLevelByBucket(weekEffectTradeActMap, tradeCodes, cntBucket));
            retMap.put("f415003", getUserCategoryActLevelByBucket(userActFeature.getDayEffectTrade(), tradeCodes, cntBucket));
            retMap.put("f415004", bucket(userActFeature.getIntervalEffectTrade(), cntBucket).toString());
            retMap.put("f415005", userActFeature.getPeriodEffectTrade());
            retMap.put("f415007", userActFeature.getLastEffectTrade());

//            retMap.put("f462002", bucket(userActFeature.getLastVideoTime(), videoDurationBucket).toString());
//            retMap.put("f462003", userActFeature.getLastVideoChannel());
//            retMap.put("f462004", userActFeature.getLastVideoInfo());

            // --- DPA 2期
            // 用户素材曝光行为
            JSONObject histEntrancesExposeTime = DataUtil.stringToJson(userActFeature.getHistEntrancesExposeTime());
            retMap.put("f481001", getCategoryJsonByBucket(histEntrancesExposeTime, cntBucket));

            JSONObject weekEntrancesExposeTime = DataUtil.stringToJson(userActFeature.getWeekEntrancesExposeTime());
            retMap.put("f481002", getCategoryJsonByBucket(weekEntrancesExposeTime, cntBucket));

            retMap.put("f481003", getCategoryMapByBucket(userActFeature.getDayEntrancesExposeTime(), cntBucket));

            JSONObject materialExposeInterval = DataUtil.stringToJson(userActFeature.getMaterialExposeInterval());
            retMap.put("f481004", getCategoryJsonByBucket(materialExposeInterval, cntBucket));

            JSONObject materialExposePeriod = DataUtil.stringToJson(userActFeature.getMaterialExposePeriod());
            retMap.put("f481005", getStringsToBuckets(materialExposePeriod, 7));

            // 用户素材点击行为
            JSONObject histEntrancesClickTime = DataUtil.stringToJson(userActFeature.getHistEntrancesClickTime());
            retMap.put("f482001", getCategoryJsonByBucket(histEntrancesClickTime, cntBucket));

            JSONObject weekEntrancesClickTime = DataUtil.stringToJson(userActFeature.getWeekEntrancesClickTime());
            retMap.put("f482002", getCategoryJsonByBucket(weekEntrancesClickTime, cntBucket));

            retMap.put("f482003", getCategoryMapByBucket(userActFeature.getDayEntrancesClickTime(), cntBucket));

            JSONObject materialClickInterval = DataUtil.stringToJson(userActFeature.getMaterialClickInterval());
            retMap.put("f482004", getCategoryJsonByBucket(materialClickInterval, cntBucket));

            JSONObject materialClickPeriod = DataUtil.stringToJson(userActFeature.getMaterialClickPeriod());
            retMap.put("f482005", getStringsToBuckets(materialClickPeriod, 7));

            // 用户组件曝光
            // 主标题
            JSONObject histMainTitlesExposeTime = DataUtil.stringToJson(userActFeature.getHistMainTitlesExposeTime());
            retMap.put("f483001", getCategoryJsonByBucket(histMainTitlesExposeTime, cntBucket));

            JSONObject weekMainTitlesExposeTime = DataUtil.stringToJson(userActFeature.getWeekMainTitlesExposeTime());
            retMap.put("f483001", getCategoryJsonByBucket(weekMainTitlesExposeTime, cntBucket));

            retMap.put("f483003", getCategoryMapByBucket(userActFeature.getDayMainTitlesExposeTime(), cntBucket));

            // 副标题
            JSONObject histSubTitlesExposeTime = DataUtil.stringToJson(userActFeature.getHistSubTitlesExposeTime());
            retMap.put("f483004", getCategoryJsonByBucket(histSubTitlesExposeTime, cntBucket));

            JSONObject weekSubTitlesExposeTime = DataUtil.stringToJson(userActFeature.getWeekSubTitlesExposeTime());
            retMap.put("f483005", getCategoryJsonByBucket(weekSubTitlesExposeTime, cntBucket));

            retMap.put("f483006", getCategoryMapByBucket(userActFeature.getDaySubTitlesExposeTime(), cntBucket));

            // 奖品
            JSONObject histPrizesExposeTime = DataUtil.stringToJson(userActFeature.getHistPrizesExposeTime());
            retMap.put("f483007", getCategoryJsonByBucket(histPrizesExposeTime, cntBucket));

            JSONObject weekPrizesExposeTime = DataUtil.stringToJson(userActFeature.getWeekPrizesExposeTime());
            retMap.put("f483008", getCategoryJsonByBucket(weekPrizesExposeTime, cntBucket));

            retMap.put("f483009", getCategoryMapByBucket(userActFeature.getDayPrizesExposeTime(), cntBucket));

            // 皮肤
            JSONObject histSkinsExposeTime = DataUtil.stringToJson(userActFeature.getHistSkinsExposeTime());
            retMap.put("f483010", getCategoryJsonByBucket(histSkinsExposeTime, cntBucket));

            JSONObject weekSkinsExposeTime = DataUtil.stringToJson(userActFeature.getWeekSkinsExposeTime());
            retMap.put("f483011", getCategoryJsonByBucket(weekSkinsExposeTime, cntBucket));

            retMap.put("f483012", getCategoryMapByBucket(userActFeature.getDaySkinsExposeTime(), cntBucket));

            // 用户组件活动参与
            // 主标题
            JSONObject histMainTitlesClickTime = DataUtil.stringToJson(userActFeature.getHistMainTitlesClickTime());
            retMap.put("f484001", getCategoryJsonByBucket(histMainTitlesClickTime, cntBucket));

            JSONObject weekMainTitlesClickTime = DataUtil.stringToJson(userActFeature.getWeekMainTitlesClickTime());
            retMap.put("f484001", getCategoryJsonByBucket(weekMainTitlesClickTime, cntBucket));

            retMap.put("f484003", getCategoryMapByBucket(userActFeature.getDayMainTitlesClickTime(), cntBucket));

            // 副标题
            JSONObject histSubTitlesClickTime = DataUtil.stringToJson(userActFeature.getHistSubTitlesClickTime());
            retMap.put("f484004", getCategoryJsonByBucket(histSubTitlesClickTime, cntBucket));

            JSONObject weekSubTitlesClickTime = DataUtil.stringToJson(userActFeature.getWeekSubTitlesClickTime());
            retMap.put("f484005", getCategoryJsonByBucket(weekSubTitlesClickTime, cntBucket));

            retMap.put("f484006", getCategoryMapByBucket(userActFeature.getDaySubTitlesClickTime(), cntBucket));

            // 奖品
            JSONObject histPrizesClickTime = DataUtil.stringToJson(userActFeature.getHistPrizesClickTime());
            retMap.put("f484007", getCategoryJsonByBucket(histPrizesClickTime, cntBucket));

            JSONObject weekPrizesClickTime = DataUtil.stringToJson(userActFeature.getWeekPrizesClickTime());
            retMap.put("f484008", getCategoryJsonByBucket(weekPrizesClickTime, cntBucket));

            retMap.put("f484009", getCategoryMapByBucket(userActFeature.getDayPrizesClickTime(), cntBucket));

            // 皮肤
            JSONObject histSkinsClickTime = DataUtil.stringToJson(userActFeature.getHistSkinsClickTime());
            retMap.put("f484010", getCategoryJsonByBucket(histSkinsClickTime, cntBucket));

            JSONObject weekSkinsClickTime = DataUtil.stringToJson(userActFeature.getWeekSkinsClickTime());
            retMap.put("f484011", getCategoryJsonByBucket(weekSkinsClickTime, cntBucket));

            retMap.put("f484012", getCategoryMapByBucket(userActFeature.getDaySkinsClickTime(), cntBucket));

            // 用户组件落地页转化
            // 主标题
            JSONObject histMainTitlesOrderTime = DataUtil.stringToJson(userActFeature.getHistMainTitlesOrderTime());
            retMap.put("f485001", getCategoryJsonByBucket(histMainTitlesOrderTime, cntBucket));

            JSONObject weekMainTitlesOrderTime = DataUtil.stringToJson(userActFeature.getWeekMainTitlesOrderTime());
            retMap.put("f485002", getCategoryJsonByBucket(weekMainTitlesOrderTime, cntBucket));

            retMap.put("f485003", getCategoryMapByBucket(userActFeature.getDayMainTitlesOrderTime(), cntBucket));

            // 副标题
            JSONObject histSubTitlesOrderTime = DataUtil.stringToJson(userActFeature.getHistSubTitlesOrderTime());
            retMap.put("f485004", getCategoryJsonByBucket(histSubTitlesOrderTime, cntBucket));

            JSONObject weekSubTitlesOrderTime = DataUtil.stringToJson(userActFeature.getWeekSubTitlesOrderTime());
            retMap.put("f485005", getCategoryJsonByBucket(weekSubTitlesOrderTime, cntBucket));

            retMap.put("f485006", getCategoryMapByBucket(userActFeature.getDaySubTitlesOrderTime(), cntBucket));

            // 奖品
            JSONObject histPrizesOrderTime = DataUtil.stringToJson(userActFeature.getHistPrizesOrderTime());
            retMap.put("f485007", getCategoryJsonByBucket(histPrizesOrderTime, cntBucket));

            JSONObject weekPrizesOrderTime = DataUtil.stringToJson(userActFeature.getWeekPrizesOrderTime());
            retMap.put("f485008", getCategoryJsonByBucket(weekPrizesOrderTime, cntBucket));

            retMap.put("f485009", getCategoryMapByBucket(userActFeature.getDayPrizesOrderTime(), cntBucket));

            // 皮肤
            JSONObject histSkinsOrderTime = DataUtil.stringToJson(userActFeature.getHistSkinsOrderTime());
            retMap.put("f485010", getCategoryJsonByBucket(histSkinsOrderTime, cntBucket));

            JSONObject weekSkinsOrderTime = DataUtil.stringToJson(userActFeature.getWeekSkinsOrderTime());
            retMap.put("f485011", getCategoryJsonByBucket(weekSkinsOrderTime, cntBucket));

            retMap.put("f485012", getCategoryMapByBucket(userActFeature.getDaySkinsOrderTime(), cntBucket));

        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(DPAActFeatureDo dpa) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if (dpa.getCandidateActivityDo() != null) {
            retMap.put("f301001", DataUtil.Long2String(dpa.getCandidateActivityDo().getActivityId()));
            retMap.put("f331001", DataUtil.Long2String(dpa.getCandidateActivityDo().getSkinId()));
            retMap.put("f331002", DataUtil.Long2String(dpa.getCandidateActivityDo().getTitleId()));
            retMap.put("f331003", DataUtil.Long2String(dpa.getCandidateActivityDo().getSubTitleId()));
            retMap.put("f331005", dpa.getCandidateActivityDo().getTitleTagId());
            retMap.put("f331006", dpa.getCandidateActivityDo().getSubTitleTagId());

            // 常规活动
            retMap.put("f341002", bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActHistClick(), userCtrBucket).toString());
            retMap.put("f341003", bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActWeekClick(), userCtrBucket).toString());
            retMap.put("f341004", bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActHistOrder(), userCtrBucket).toString());
            retMap.put("f341005", bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActWeekOrder(), userCtrBucket).toString());
            JSONObject routineActTradeVisitTime = DataUtil.stringToJson(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActTradeVisitTime());
            retMap.put("f341006", getCategoryJsonByBucket(routineActTradeVisitTime, cntBucket));
            JSONObject routineActTradeClickTime = DataUtil.stringToJson(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActTradeClickTime());
            retMap.put("f341007", getCategoryJsonByBucket(routineActTradeClickTime, cntBucket));
            retMap.put("f341008", dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActActType());


            // 主标题
            JSONObject componentMainTitleCategory = DataUtil.stringToJson(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleCategory());
            retMap.put("f351001", getStringsToBuckets(componentMainTitleCategory, 1000));

            retMap.put("f351002", bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleHistClick(), userCtrBucket).toString());
            retMap.put("f351003", bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleWeekClick(), userCtrBucket).toString());
            retMap.put("f351004", bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleDayClick(), userCtrBucket).toString());
            retMap.put("f351005", bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleHistOrder(), userCtrBucket).toString());
            retMap.put("f351006", bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleWeekOrder(), userCtrBucket).toString());
            retMap.put("f351007", bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleDayOrder(), userCtrBucket).toString());

            // 副标题
            JSONObject componentSubTitleCategory = DataUtil.stringToJson(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleCategory());
            retMap.put("f352001", getStringsToBuckets(componentSubTitleCategory, 1000));

            retMap.put("f352002", bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleHistClick(), userCtrBucket).toString());
            retMap.put("f352003", bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleWeekClick(), userCtrBucket).toString());
            retMap.put("f352004", bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleDayClick(), userCtrBucket).toString());
            retMap.put("f352005", bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleHistOrder(), userCtrBucket).toString());
            retMap.put("f352006", bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleWeekOrder(), userCtrBucket).toString());
            retMap.put("f352007", bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleDayOrder(), userCtrBucket).toString());

            // 奖品
            List<PrizeDo> prizeDos = dpa.getCandidateActivityDo().getPrizeGroup();
            if (prizeDos != null){
                for (int i = 0; i < prizeDos.size() && i < 6; i++) {
                    retMap.put(String.format("f3320%s1", i+1), DataUtil.Long2String(prizeDos.get(i).getId()));
                    retMap.put(String.format("f3320%s2", i+1), DataUtil.Long2String(prizeDos.get(i).isAd() ? 1L : 2L));
                    retMap.put(String.format("f3320%s3", i+1), prizeDos.get(i).getAdTagId());
                    retMap.put(String.format("f3530%s0", i+1), bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeHistClick(), userCtrBucket).toString());
                    retMap.put(String.format("f3530%s1", i+1), bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeWeekClick(), userCtrBucket).toString());
                    retMap.put(String.format("f3530%s2", i+1), bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeDayClick(), userCtrBucket).toString());
                    retMap.put(String.format("f3530%s3", i+1), bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeHistOrder(), userCtrBucket).toString());
                    retMap.put(String.format("f3530%s4", i+1), bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeWeekOrder(), userCtrBucket).toString());
                    retMap.put(String.format("f3530%s5", i+1), bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeDayOrder(), userCtrBucket).toString());
                    JSONObject componentPrizeTradeCategory = DataUtil.stringToJson(prizeDos.get(i).getPrizeFeature().getComponentPrizeTradeCategory());
                    retMap.put(String.format("f3530%s6", i+1), getStringsToBuckets(componentPrizeTradeCategory, 100));
                }
            }

            // 皮肤
            retMap.put("f354001", dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinCategory());
            retMap.put("f354004", bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinHistClick(), userCtrBucket).toString());
            retMap.put("f354005", bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinWeekClick(), userCtrBucket).toString());
            retMap.put("f354006", bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinDayClick(), userCtrBucket).toString());
            retMap.put("f354007", bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinHistOrder(), userCtrBucket).toString());
            retMap.put("f354008", bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinWeekOrder(), userCtrBucket).toString());
            retMap.put("f354009", bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinDayOrder(), userCtrBucket).toString());


        }
        return retMap;
    }

    //根据areaCode解析地区级别（华北/东北/华东/华中/华南/西南/西北/港澳） f4010031
    public static Long getRegionLevel(Long areaCode) {

        Long ret = null;

        if (AssertUtil.isNotEmpty(areaCode)) {

            int area = DataUtil.toInt(areaCode);
            if ( areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area =  DataUtil.toInt(areaCode / 100);
            }

            if (Arrays.asList(HUABEI_REGION).contains(area)) { ret = 80L; }
            else if (Arrays.asList(DONGBEI_REGION).contains(area)) { ret = 81L; }
            else if (Arrays.asList(HUADONG_REGION).contains(area)) { ret = 82L; }
            else if (Arrays.asList(HUAZHONG_REGION).contains(area)) { ret = 83L; }
            else if (Arrays.asList(HUANAN_REGION).contains(area)) { ret = 84L; }
            else if (Arrays.asList(XINAN_REGION).contains(area)) { ret = 85L; }
            else if (Arrays.asList(XIBEI_REGION).contains(area)) { ret = 86L; }
            else if (Arrays.asList(HMT_REGION).contains(area)) { ret = 87L; }

        }

        return ret;
    }

    //根据areaCode解析城市级别（一线/二线/三线） f4010032
    public static Long getTierCityLevel(Long areaCode) {

        Long ret = null;

        if (AssertUtil.isNotEmpty(areaCode)) {

            int area = DataUtil.toInt(areaCode);

            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) { ret = 1L; }
            else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) { ret = 2L; }
            else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) { ret = 3L; }

        }

        return ret;
    }

    // 行业标签编码
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>(){
        {
            put("8",0);
            put( "14",1);
            put( "15",2);
            put( "21",3);
            put( "20",4);
            put( "3",5);
            put( "5",6);
            put( "12",7);
            put( "2",8);
            put( "1",9);
            put( "24",10);
            put( "6",11);
            put( "7",12);
            put( "11",13);
            put( "13",14);
            put( "18",15);
            put( "22",16);
            put( "4",17);
            put( "17",18);
            put( "25",19);
            put( "10",20);
            put( "23",21);
            put( "9",22);
            put( "19",23);
            put( "16",24);
        }
    };

    /**
     * 分桶函数1
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    /**
     * 分桶函数2
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    /**
     * 分桶函数3
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }


    //
    public static String getCategoryMapByBucket(Map<String, Integer> actMap, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap)) return null;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (Map.Entry<String, Integer> entry: actMap.entrySet()) {
                Integer cateKey = Integer.parseInt(entry.getKey());
                Integer cateValue = entry.getValue();
                long value = cateKey * buckets.length + bucket(cateValue, buckets);
                tmp.add(value);
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }


    public static String getStringsToBuckets(JSONObject actMap, Integer limit) {

        if (AssertUtil.isAnyEmpty(actMap)) return null;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (String cKey: actMap.keySet()) {
                Integer cateKey = Integer.parseInt(cKey);
                Integer cateValue = actMap.getInteger(cKey);
                long value = cateKey * limit + cateValue;
                tmp.add(value);
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    public static String getCategoryMapByBucket(Map<String, Double> actMap, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap)) return null;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (Map.Entry<String, Double> entry: actMap.entrySet()) {
                Integer cateKey = Integer.parseInt(entry.getKey());
                Double cateValue = entry.getValue();
                long value = cateKey * buckets.length + bucket(cateValue, buckets);
                tmp.add(value);
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }


    //
    public static String getCategoryJsonByBucket(JSONObject actMap, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap)) return null;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (String cKey: actMap.keySet()) {
                Integer cateKey = Integer.parseInt(cKey);
                Integer cateValue = actMap.getInteger(cKey);
                long value = cateKey * buckets.length + bucket(cateValue, buckets);
                tmp.add(value);
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    public static String getCategoryJsonByBucket(JSONObject actMap, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap)) return null;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (String cKey: actMap.keySet()) {
                Integer cateKey = Integer.parseInt(cKey);
                Double cateValue = actMap.getDouble(cKey);
                long value = cateKey * buckets.length + bucket(cateValue, buckets);
                tmp.add(value);
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (Map.Entry<String, Integer> entry: actMap.entrySet()) {
                String cateKey = entry.getKey();
                Integer cateValue = entry.getValue();

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);
                    tmp.add(value);
                }
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (String cateKey: actMap.keySet()) {
                Double cateValue = actMap.getDouble(cateKey);

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);
                    tmp.add(value);
                }
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {

        String ret = null;
        try {
            // 全局
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String(ubpMap.get(statType).get("0"));


            }
            // 当前广告
            if (dimType == 1 && ubpMap != null) {
                String tag = getTag(tags);

                if (tag != null) {
                    ret = ubpMap.get(statType).get(tag) + "";

                    if (tag.length() == 10 && ret == null) {
                        String sTag = tag.substring(0, 5);
                        ret = DataUtil.Long2String(ubpMap.get(statType).get(sTag));
                    }


                }
            }

            // 其他行业
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String v = entry.getKey() + "_" + entry.getValue() + ",";
                    ret += v;
                }

                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }

            }


            //统计计数
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {

                ret = "";
                Map<Long, Long> levelCntMap = new HashMap<>();

//                System.out.println("statType=" + statType);

//                for (long i = 0; i < ctrAndCvrLevelBucket.length + 2; i++) {
//                    levelCntMap.put(i, 0L);
//                }


                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag = entry.getKey();
                    Long ctrLevel = bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel != null && tag != "0") {
                        if (!levelCntMap.containsKey(ctrLevel)) {
                            levelCntMap.put(ctrLevel, 0L);
                        }
                        levelCntMap.put(ctrLevel, levelCntMap.get(ctrLevel) + 1);
//                        System.out.println("entry.getValue()=" + entry.getValue() + ",ctrLevel=" + ctrLevel + ",+1");
                    }
                }

                for (Map.Entry<Long, Long> entry : levelCntMap.entrySet()) {
                    if (entry.getKey() != null && entry.getValue() != null) {

                        Long cntLevel = bucket(entry.getValue(), cntBucket);
//                        System.out.println("entry.getKey()=" + entry.getKey() + "entry.getValue()=" + entry.getValue() + ",cntLevel=" + cntLevel + "+1");
                        String v = entry.getKey() * 100 + cntLevel + ",";
                        ret += v;
                    }

                }


                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }

            }


        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    public static String getTag(String tags) {
        String ret = null;
        if (AssertUtil.isNotEmpty(tags)) {
            String[] tagArr = tags.split(",");
            if (AssertUtil.isNotEmpty(tagArr)) {
                for (int i = 0; i < tagArr.length; i++) {
                    String tmp = validTag(tagArr[i]);
                    if (tmp != null) {
                        ret = validTag(tagArr[i]);
                    }

                }
            }
        }

        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty(tag)) {
            if (tag.contains(".")) {
                ret = tag;
            }
        }
        return ret;
    }


    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds,
                                                                             String uILaunchPv,
                                                                             String uIClickPv,
                                                                             String uIEffectPv) {
        Map<String, Map<String, Long>> ret = new HashMap<>();
        ret.put("ctr", new HashMap<String, Long>());
        ret.put("cvr", new HashMap<String, Long>());
        if (AssertUtil.isAllNotEmpty(uIIds, uILaunchPv, uIClickPv, uIEffectPv)) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");

            if (uIIdsArr.length > 0 &&
                    uIIdsArr.length == uILaunchPvArr.length &&
                    uIIdsArr.length == uIClickPvArr.length &&
                    uIIdsArr.length == uIEffectPvArr.length) {

                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;


                for (int i = 0; i < uIIdsArr.length; i++) {
                    String id = uIIdsArr[i];
//                    System.out.println("uIIdsArr[i]=" + uIIdsArr[i]);
//                    System.out.println("uILaunchPvArr[i]=" + uILaunchPvArr[i]);
//                    System.out.println("uIClickPvArr[i]=" + uIClickPvArr[i]);
//                    System.out.println("uIEffectPvArr[i]=" + uIEffectPvArr[i]);

                    Long launchPv = DataUtil.str2Long(uILaunchPvArr[i], 0L);
                    Long clickPv = DataUtil.str2Long(uIClickPvArr[i], 0L);
                    Long effectPv = DataUtil.str2Long(uIEffectPvArr[i], 0L);

//                    System.out.println("launchPv=" + launchPv);
//                    System.out.println("clickPv=" + clickPv);
//                    System.out.println("effectPv=" + effectPv);

                    Double ctr = getCtrOrCvr(launchPv, clickPv);
                    Double cvr = getCtrOrCvr(clickPv, effectPv);

                    Long ctrBucketLevel = bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = bucket(cvr, userCvrBucket);

                    ret.get("ctr").put(id, ctrBucketLevel);
                    ret.get("cvr").put(id, cvrBucketLevel);

                    launchAccPv += launchPv;
                    clickAccPv += clickPv;
                    effectAccPv += effectPv;

                }
                Double ctr = getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = getCtrOrCvr(clickAccPv, effectAccPv);

                Long ctrBucketLevel = bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = bucket(cvr, userCvrBucket);

                ret.get("ctr").put("0", ctrBucketLevel);
                ret.get("cvr").put("0", cvrBucketLevel);

            }


        }

        return ret;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty(firstPv, secondPv) && firstPv > 0)
            ret = DataUtil.division(secondPv, firstPv);

        return ret;
    }

    // 广告主编码
    public static Map<String, Integer> accountCodes = new HashMap<String, Integer>(){
        {
            put("18125",0);
            put("18943",1);
            put("22005",2);
            put("21563",3);
            put("17196",4);
            put("29815",5);
            put("27419",6);
            put("25874",7);
            put("30539",8);
            put("27295",9);
            put("30037",10);
            put("24035",11);
            put("23882",12);
            put("29932",13);
            put("19317",14);
            put("10971",15);
            put("27486",16);
            put("12311",17);
            put("22597",18);
            put("21330",19);
            put("26598",20);
            put("30371",21);
            put("19941",22);
            put("27605",23);
            put("17270",24);
            put("12234",25);
            put("17878",26);
            put("28257",27);
            put("30632",28);
            put("25991",29);
            put("30701",30);
            put("30336",31);
            put("12796",32);
            put("29379",33);
            put("30495",34);
            put("29758",35);
            put("19316",36);
            put("14355",37);
            put("29001",38);
            put("30126",39);
            put("30892",40);
            put("26320",41);
            put("18489",42);
            put("14164",43);
            put("24696",44);
            put("28941",45);
            put("30511",46);
            put("5713",47);
            put("30928",48);
            put("19761",49);
            put("30592",50);
            put("30081",51);
            put("28769",52);
            put("29788",53);
            put("21133",54);
            put("30679",55);
            put("30393",56);
            put("26323",57);
            put("29336",58);
            put("29935",59);
            put("29030",60);
            put("26550",61);
            put("30394",62);
            put("30823",63);
            put("28466",64);
            put("8340",65);
            put("30460",66);
            put("30739",67);
            put("26048",68);
            put("30765",69);
            put("30596",70);
            put("25809",71);
            put("30808",72);
            put("30605",73);
            put("27165",74);
            put("30868",75);
            put("30518",76);
            put("29408",77);
            put("30601",78);
            put("30900",79);
            put("25984",80);
            put("27568",81);
            put("23937",82);
            put("15334",83);
            put("30345",84);
            put("26595",85);
            put("8154",86);
            put("28264",87);
            put("30848",88);
            put("13566",89);
            put("26726",90);
            put("8302",91);
            put("29406",92);
            put("16315",93);
            put("30625",94);
            put("20619",95);
            put("28528",96);
            put("30253",97);
            put("29808",98);
            put("30809",99);
            put("6286",100);
            put("22757",101);
            put("9876",102);
            put("24779",103);
            put("25806",104);
            put("30929",105);
            put("30956",106);
            put("30691",107);
            put("29706",108);
            put("29651",109);
            put("30438",110);
            put("27911",111);
            put("30493",112);
            put("29519",113);
            put("30220",114);
            put("30812",115);
            put("27684",116);
            put("30636",117);
            put("17638",118);
            put("28594",119);
            put("29558",120);
            put("27463",121);
            put("28925",122);
            put("28420",123);
            put("30099",124);
            put("28523",125);
            put("30688",126);
            put("28432",127);
            put("18028",128);
            put("6209",129);
            put("30783",130);
            put("22412",131);
            put("30684",132);
            put("30621",133);
            put("30734",134);
            put("30807",135);
            put("30794",136);
            put("28180",137);
            put("28544",138);
            put("30186",139);
            put("24090",140);
            put("30111",141);
            put("8657",142);
            put("23977",143);
            put("29491",144);
            put("30327",145);
            put("30249",146);
            put("23461",147);
            put("28597",148);
            put("30498",149);
            put("30109",150);
            put("30279",151);
            put("30100",152);
            put("30732",153);
            put("23031",154);
            put("30497",155);
            put("25886",156);
            put("27453",157);
            put("29845",158);
            put("30378",159);
            put("30257",160);
            put("28881",161);
            put("27241",162);
            put("30219",163);
            put("22006",164);
            put("30217",165);
            put("25215",166);
            put("19217",167);
            put("28515",168);
            put("30185",169);
            put("29858",170);
            put("27452",171);
            put("18089",172);
            put("30411",173);
            put("26151",174);
            put("29699",175);
            put("29889",176);
            put("30573",177);
            put("30017",178);
            put("2292",179);
            put("29427",180);
            put("30560",181);
            put("30626",182);
            put("28628",183);
            put("29534",184);
            put("30515",185);
            put("30023",186);
            put("30374",187);
            put("21271",188);
            put("27321",189);
            put("30290",190);
            put("28643",191);
            put("14356",192);
            put("23880",193);
            put("30836",194);
            put("30569",195);
            put("29900",196);
            put("29879",197);
            put("30499",198);
            put("29894",199);
            put("28970",200);
            put("21944",201);
            put("30705",202);
            put("30187",203);
            put("28503",204);
            put("29028",205);
            put("30128",206);
            put("30182",207);
            put("30237",208);
            put("29448",209);
            put("30825",210);
            put("27884",211);
            put("27932",212);
            put("30704",213);
            put("30695",214);
            put("30461",215);
            put("30218",216);
            put("29862",217);
            put("25509",218);
            put("30329",219);
            put("26077",220);
            put("25495",221);
            put("30115",222);
            put("27002",223);
            put("30935",224);
            put("23469",225);
            put("30331",226);
            put("30188",227);
            put("24296",228);
            put("22042",229);
            put("7962",230);
            put("323",231);
            put("30272",232);
            put("18071",233);
            put("18072",234);
            put("8220",235);
            put("8331",236);
            put("23680",237);
            put("6419",238);
        }
    };

    // App类目编码
    public static Map<String, Integer> appCodes = new HashMap<String, Integer>(){
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
        }
    };

    // 签名类目编码
    public static Map<String, Integer> msgSigCodes = new HashMap<String, Integer>(){
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
            put("15", 15);
            put("16", 16);
            put("17", 17);
            put("18", 18);
            put("19", 19);
            put("20", 20);
            put("21", 21);
            put("22", 22);
            put("23", 23);
            put("24", 24);
            put("25", 25);
            put("26", 26);
            put("27", 27);
            put("28", 28);
            put("29", 29);
            put("30", 30);
            put("31", 31);
            put("32", 32);
            put("33", 33);
            put("34", 34);
            put("35", 35);
            put("36", 36);
            put("37", 37);
            put("38", 38);
            put("39", 39);
            put("40", 40);
            put("41", 41);
            put("42", 42);
            put("43", 43);
        }
    };

    // 关键词类目编码
    public static Map<String, Integer> keywordCodes = new HashMap<String, Integer>(){
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
            put("15", 15);
            put("16", 16);
            put("17", 17);
            put("18", 18);
            put("19", 19);
            put("20", 20);
            put("21", 21);
            put("22", 22);
            put("23", 23);
            put("24", 24);
            put("25", 25);
            put("26", 26);
            put("27", 27);
            put("28", 28);
            put("29", 29);
            put("30", 30);
        }
    };

    // 视频类目编码 videoCate
    public static Map<String, Integer> videoCateCodes = new HashMap<String, Integer>(){
        {
            put("1273152", 0);
            put("1273153", 1);
            put("1273154", 2);
            put("1273155", 3);
            put("1273158", 4);
            put("1273163", 5);
            put("1273166", 6);
            put("1273190", 7);
            put("1273380", 8);
            put("1273399", 9);
            put("1275055", 10);
            put("1275060", 11);
            put("1275378", 12);
            put("1275381", 13);
            put("1275605", 14);
            put("1275609", 15);
            put("1275699", 16);
            put("1275850", 17);
            put("1276159", 18);
            put("1276427", 19);
            put("1277341", 20);
            put("1277350", 21);
            put("1277354", 22);
            put("1277360", 23);
            put("1277373", 24);
            put("1278212", 25);
            put("1279265", 26);
            put("1279863", 27);
            put("1281970", 28);
            put("1281978", 29);
            put("1282468", 30);
            put("1282983", 31);
            put("1283091", 32);
            put("1283242", 33);
            put("1284864", 34);
            put("1284891", 35);
            put("1284979", 36);
            put("1288586", 37);
            put("1289618", 38);
            put("1289633", 39);
            put("1289641", 40);
            put("1289642", 41);
            put("1291079", 42);
            put("1307098", 43);
            put("1307103", 44);
            put("1308055", 45);
            put("1310272", 46);
            put("1310276", 47);
            put("1311366", 48);
            put("1316217", 49);
            put("1323164", 50);
            put("1333414", 51);
            put("1343852", 52);
            put("1345203", 53);
            put("1345206", 54);
            put("1345801", 55);
            put("1347029", 56);
            put("1348464", 57);
            put("1348469", 58);
            put("1348589", 59);
            put("1348767", 60);
            put("1351397", 61);
            put("1362094", 62);
            put("1392855", 63);
            put("1399467", 64);
            put("1457705", 65);
            put("1506926", 66);
            put("1509530", 67);
            put("1652670", 68);
            put("1657117", 69);
            put("1657120", 70);
            put("1786669", 71);
            put("1791134", 72);
            put("1887279", 73);
            put("2289121", 74);
            put("2289182", 75);
            put("2289191", 76);
            put("2289194", 77);
            put("2289198", 78);
            put("2400701", 79);
            put("2422552", 80);
            put("2423962", 81);
            put("2425625", 82);
            put("2454957", 83);
            put("2456790", 84);
            put("2456802", 85);
            put("2456895", 86);
            put("2466968", 87);
            put("2469508", 88);
            put("2485369", 89);
            put("2577550", 90);
            put("2818641", 91);
            put("2820598", 92);
            put("2821045", 93);
            put("2821232", 94);
            put("2821234", 95);
            put("2823069", 96);
            put("2824674", 97);
            put("2825127", 98);
            put("2825132", 99);
            put("2825152", 100);
            put("2825153", 101);
            put("2825156", 102);
            put("2825165", 103);
            put("2825674", 104);
            put("2828097", 105);
            put("2829161", 106);
            put("2829647", 107);
            put("2830002", 108);
            put("2830311", 109);
            put("2830346", 110);
            put("2830613", 111);
            put("2830805", 112);
            put("2831234", 113);
            put("2831373", 114);
            put("2831480", 115);
            put("2832492", 116);
            put("2833635", 117);
            put("2834198", 118);
            put("2834248", 119);
            put("2834252", 120);
            put("2834254", 121);
            put("2834359", 122);
            put("2834697", 123);
            put("2834810", 124);
            put("2834931", 125);
            put("2835040", 126);
            put("2835116", 127);
            put("2835117", 128);
            put("2835164", 129);
            put("2835165", 130);
            put("2835495", 131);
            put("2835521", 132);
            put("2835645", 133);
            put("2835728", 134);
            put("2835738", 135);
            put("2835744", 136);
            put("2836094", 137);
            put("2836607", 138);
            put("2836677", 139);
            put("2837050", 140);
            put("2837679", 141);
            put("2837825", 142);
            put("2838438", 143);
            put("2838626", 144);
            put("2838627", 145);
            put("2838628", 146);
            put("2838680", 147);
            put("2839215", 148);
            put("2839217", 149);
            put("2839264", 150);
            put("2839388", 151);
            put("2840307", 152);
            put("2840460", 153);
            put("2840461", 154);
            put("2840492", 155);
            put("2840499", 156);
            put("2840500", 157);
            put("2840501", 158);
            put("2840502", 159);
            put("2840504", 160);
            put("2840944", 161);
            put("2841365", 162);
            put("2841425", 163);
            put("2841426", 164);
            put("2844458", 165);
            put("2844459", 166);
            put("2844461", 167);
            put("2844477", 168);
            put("2844488", 169);
            put("2844489", 170);
            put("2845047", 171);
            put("2847235", 172);
            put("2847874", 173);
            put("2847916", 174);
            put("2848190", 175);
            put("2848215", 176);
            put("2848229", 177);
            put("2848330", 178);
            put("2849576", 179);
            put("2850987", 180);
            put("2859501", 181);
            put("2859502", 182);
            put("2859503", 183);
            put("2859504", 184);
            put("2859505", 185);
            put("2859506", 186);
            put("2859507", 187);
            put("2859508", 188);
            put("2859509", 189);
            put("2859510", 190);
            put("2859511", 191);
            put("2859512", 192);
            put("2859513", 193);
            put("2859588", 194);
            put("2859785", 195);
            put("2860991", 196);
            put("2860992", 197);
            put("2923465", 198);
            put("2923466", 199);
            put("2924524", 200);
            put("2924526", 201);
            put("2924527", 202);
            put("2924539", 203);
            put("2924541", 204);
            put("2924542", 205);
            put("2924543", 206);
            put("2924965", 207);
            put("2924966", 208);
            put("2924967", 209);
            put("2924968", 210);
            put("2924969", 211);
            put("2924970", 212);
        }
    };

    // 视频频道编码 videoChannel
    public static Map<String, Integer> videoChannelCodes = new HashMap<String, Integer>(){
        {
            put("aiqiyi--1", 0);
            put("aiqiyi-0", 1);
            put("aiqiyi-1", 2);
            put("aiqiyi-10", 3);
            put("aiqiyi-11", 4);
            put("aiqiyi-12", 5);
            put("aiqiyi-13", 6);
            put("aiqiyi-14", 7);
            put("aiqiyi-15", 8);
            put("aiqiyi-16", 9);
            put("aiqiyi-17", 10);
            put("aiqiyi-18", 11);
            put("aiqiyi-19", 12);
            put("aiqiyi-2", 13);
            put("aiqiyi-20", 14);
            put("aiqiyi-21", 15);
            put("aiqiyi-22", 16);
            put("aiqiyi-23", 17);
            put("aiqiyi-24", 18);
            put("aiqiyi-25", 19);
            put("aiqiyi-26", 20);
            put("aiqiyi-27", 21);
            put("aiqiyi-28", 22);
            put("aiqiyi-29", 23);
            put("aiqiyi-3", 24);
            put("aiqiyi-30", 25);
            put("aiqiyi-30003", 26);
            put("aiqiyi-30005", 27);
            put("aiqiyi-30008", 28);
            put("aiqiyi-30010", 29);
            put("aiqiyi-31", 30);
            put("aiqiyi-32", 31);
            put("aiqiyi-33", 32);
            put("aiqiyi-34", 33);
            put("aiqiyi-4", 34);
            put("aiqiyi-40004", 35);
            put("aiqiyi-49999", 36);
            put("aiqiyi-5", 37);
            put("aiqiyi-6", 38);
            put("aiqiyi-7", 39);
            put("aiqiyi-8", 40);
            put("aiqiyi-9", 41);
            put("aiqiyi-97", 42);
            put("aiqiyi-99", 43);
            put("mango-0", 44);
            put("mango-1", 45);
            put("mango-105", 46);
            put("mango-111", 47);
            put("mango-116", 48);
            put("mango-117", 49);
            put("mango-120", 50);
            put("mango-2", 51);
            put("mango-20", 52);
            put("mango-3", 53);
            put("mango-50", 54);
        }
    };

    // 资源标签编码
    public static Map<String, Integer> resourceCodes = new HashMap<String, Integer>(){
        {
            put( "07.23.0008",0);
            put( "07.23.0019",1);
            put( "07.23.0010",2);
            put( "07.24.0001",3);
            put( "07.23.0013",4);
            put( "07.23.0018",5);
            put( "07.23.0009",6);
            put( "07.23.0030",7);
            put( "07.23.0012",8);
            put( "07.23.0036",9);
            put( "07.23.0021",10);
        }
    };


    public static void main(String[] args) {
        DPAFeature dpa = new DPAFeature();
//        dpa.setHistEntrancesExposeTime("{\"1\": 1, \"2\": 2}");
//        Map<String, String> retMap = generateDPAFeature(dpa);
//        System.out.println(retMap.toString());
    }
}


