package cn.com.duiba.nezha.alg.feature.vo;

import java.io.Serializable;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

@Data
public class UserProfileFeature implements Serializable {
    private static final long serialVersionUID = 6653753667287162448L;

    // 基本属性
    private String sex; // f451001 性别
    private String age; // f451002  年龄
    private String marry;  // f451003  婚恋
    private String marital; // 新版的婚育标签：http://cf.dui88.com/pages/viewpage.action?pageId=126037096
    private String consumeLevel;   // f451004  消费水平
    private String permanentProvince; // f451005  常住地（省份）
    private String permanentCity; // f451006  常住地（城市）


    public String getMarital() {
        if (StringUtils.isNotBlank(this.marital)) {
            return null;
        }
        return this.marital.substring(0, Math.min(this.marital.length(), 6));
    }

    public  String getConsumeLevel() {
        if (StringUtils.isNotBlank(this.consumeLevel)) {
            return null;
        }
        return this.consumeLevel.substring(0, Math.min(this.consumeLevel.length(), 6));
    }

    /**
     * 系统版本 格式化
     * @param osVersion
     * @return
     */
    public static String formatOsVersion(String osVersion) {
        if (StringUtils.isNotBlank(osVersion)) {
            return null;
        }
        return osVersion.split("\\.")[0].toUpperCase();
    }

    /**
     * 首发年份 格式化
     * @param firstShowTime
     * @return
     */
    public static String formatFirstShowTime(Integer firstShowTime){
        if (firstShowTime == null) {
            return null;
        }
        // 判断firstShowTime合法性
        if (firstShowTime<2000 || firstShowTime>2030) {
            return "-1";
        }
        return firstShowTime.toString();
    }

    public static String formatPhoneOs(String phoneOs) {
        if (StringUtils.isNotBlank(phoneOs)) {
            return null;
        }
        if (phoneOs.equalsIgnoreCase("android")) {
            return "android";
        }
        if (phoneOs.equalsIgnoreCase("ios")) {
            return "ios";
        }
        return null;
    }








}

