package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.vo.RtaFeatureDo;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by pzx on 2022/1/13.
 */
public class RtaFeatureParse {
    public static final int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(RtaFeatureParse.class);

    public static final Integer[] HUABEI_REGION = {80, 11, 12, 13, 14, 15};
    public static final Integer[] DONGBEI_REGION = {81, 21, 22, 23};

    public static Map<String, String> generateFeatureMapStatic(RtaFeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                // 实时用户属性特征，上次入口曝光的
                retMap.put("f1010010", cf.getSlotId()); // 广告位id

                // 实时用户统计特征
                retMap.put("f1010020", DataUtil.Long2String(cf.getUserExpPv())); // 用户当天入口曝光次数
            }
        } catch (Exception e) {
            logger.error("RtaFeatureParse.generateFeatureMapStatic error:", e);

        }
        return retMap;
    }
}