package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.vo.*;
import org.slf4j.LoggerFactory;

import java.util.*;

//import org.omg.PortableInterceptor.INACTIVE;

/**
 * 素材特征解析
 */
public class MaterialFeatureParse {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(MaterialFeatureParse.class);

    public static int F_MAX_SIZE = 64;

   //广告位+素材
    public static int[] sexpWeekBucket = {0,5,17,61,170,286,650,2446,14211,277794};
    public static int[] sexpDayBucket = {0,3,10,24,40,75,161,795,27479,120623};

    public static int[] sclickWeekBucket = {0,1 ,2 ,4 ,9 ,19 ,61,164,1165,8893};
    public static int[] sclickDayBucket = {0,1,1,2,3,9,24,140,1231,2740};


    //素材：
    public static int[] expWeekBucket = {0,3,10,46,156,369,875,4103,36319,431986};
    public static int[] expDayBucket = {0,3,9,24,43,87,201,1626,47910,126840};
    public static int[] clickWeekBucket = {0,1,3,7,14,44,123,379,3391,14571};
    public static int[] clickDayBucket = {0,1,2,3,4,10,35,199,1501,4698};

    public static int[] convertCntBucket = {0, 1, 2, 5, 10, 20, 50, 100,500,1000,2000};
    public static int[] bconvertCntBucket = {0, 1, 2, 5, 10, 20, 50, 100,500,1000,2000};

    public static double[] userCtrBucket = {0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.10, 0.15, 0.20,0.30,0.40,0.50,1.0};
    public static double[] slotCtrBucket = {0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.10, 0.15, 0.20,0.30,0.40,0.50,1.0};

    //时间间隔
    public static int[] timeBucket = {0, 1, 3, 5, 10, 15, 20, 50};


    public static Map<String, String> generateFeatureMapStatic(MaterialFeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                /**
                 * 用户特征
                 */
                // 用户画像特征解析
                UserFeature userFeature = Optional.ofNullable(cf.getUserFeature()).orElse(new UserFeature());

                // 基本属性
                retMap.put("f451001", userFeature.getSex());
                retMap.put("f451002", userFeature.getAge());
                retMap.put("f451003", userFeature.getMarry());
                retMap.put("f451004", userFeature.getConsumeLevel());
                retMap.put("f451005", userFeature.getPermanentProvince());
                retMap.put("f451006", userFeature.getPermanentCity());

                // 用户画像特征解析
                retMap.put("f9902", userFeature.getAppList());
                retMap.put("f9801", userFeature.getSigList());

                //截取30个
                List<String> expDayMaterials = Arrays.asList(userFeature.getExpDayMaterials().split(","));
                List<String> clickDayMaterials = Arrays.asList(userFeature.getClickDayMaterials().split(","));
                retMap.put("f390001", subList(expDayMaterials));
                retMap.put("f390002", subList(clickDayMaterials));

                retMap.put("f390003", sortSubList(userFeature.getExpWeekMaterials()));
                retMap.put("f390004", sortSubList(userFeature.getClickWeekMaterials()));

                //广告位
                SlotFeature slotFeature = Optional.ofNullable(cf.getSlotFeature()).orElse(new SlotFeature());

                retMap.put("f108001", DataUtil.Long2String(slotFeature.getSlotId()));
                retMap.put("f109001", DataUtil.Long2String(slotFeature.getSlotType()));

                retMap.put("f201001", DataUtil.Long2String(slotFeature.getAppId()));
                // 媒体标签
                retMap.put("f205001", slotFeature.getAppIndustryTagPid());
                retMap.put("f205002", slotFeature.getAppIndustryTagId());

                //上下文
                MaterialContextFeature contextFeature = Optional.ofNullable(cf.getMaterialContextFeature()).orElse(new MaterialContextFeature());


                retMap.put("f501001", contextFeature.getUa());
                retMap.put("f503001", DataUtil.Long2String(contextFeature.getCityId()));

                retMap.put("f503003", contextFeature.getProvinceCode());
                // 设备型号
                retMap.put("f504001", contextFeature.getModel());
                // 设备价格区间
//                retMap.put("f505001", cf.getPriceSection());
                retMap.put("f390017", contextFeature.getExposeHour());
                retMap.put("f390018", contextFeature.getExposeWeekDay());
                retMap.put("f390019", contextFeature.getExposeHolidays());




            }

        } catch (Exception e) {

            logger.error("MaterialFeatureParse.generateFeatureMapStatic error:" + e);
        }

        return retMap;
    }


    public static Map<String, String> generateFeatureMapDynamic(MaterialFeatureDo cf, MaterialFeatureDo staticCf,Long materialId) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                MaterialFeature materialFeature = Optional.ofNullable(cf.getMaterialFeatureMap().get(materialId)).orElse(new MaterialFeature());

                retMap.put("f390000", DataUtil.Long2String(materialId));
                retMap.put("f390005", materialFeature.getCustomization());
                retMap.put("f390006", materialFeature.getIndustry());
                retMap.put("f390007", materialFeature.getSlotNature());
                retMap.put("f390008", materialFeature.getDesignHue());

                retMap.put("f390047", materialFeature.getStrategy());
                retMap.put("f390048", materialFeature.getRewardElement());
                retMap.put("f390049", materialFeature.getDesignType());

                retMap.put("f390009",DataUtil.Long2String(bucket(materialFeature.getExposeWeekCnt(),expWeekBucket)));
                retMap.put("f390010",DataUtil.Long2String(bucket(materialFeature.getClickWeekCnt(),clickWeekBucket)));

                retMap.put("f390011",DataUtil.Long2String(bucket(materialFeature.getConvertWeekCnt(),convertCntBucket)));
                retMap.put("f390012",DataUtil.Long2String(bucket(materialFeature.getBConvertWeekCnt(),bconvertCntBucket)));

                retMap.put("f390013",DataUtil.Long2String(bucket(materialFeature.getExposeDayCnt(),expDayBucket)));
                retMap.put("f390014",DataUtil.Long2String(bucket(materialFeature.getClickDayCnt(),clickDayBucket)));

                Double weekCtr = calWilsonScore(materialFeature.getExposeWeekCnt(), materialFeature.getClickWeekCnt());
                Double dayCtr = calWilsonScore(materialFeature.getExposeDayCnt(), materialFeature.getClickDayCnt());
                retMap.put("f390042", DataUtil.Long2String(bucket(weekCtr,userCtrBucket)));
                retMap.put("f390043", DataUtil.Long2String(bucket(dayCtr,userCtrBucket)));


                //用户-素材
                UserMaterialFeature umFeature = Optional.ofNullable(cf.getUserMaterialFeatureMap().get(materialId)).orElse(new UserMaterialFeature());

                retMap.put("f390020",DataUtil.Long2String(Math.min(umFeature.getUExposeHistCnt(),100)));
                retMap.put("f390021",DataUtil.Long2String(Math.min(umFeature.getUExposeWeekCnt(),100)));

                retMap.put("f390022", bucket(umFeature.getUExposeInterval(), timeBucket).toString());


                retMap.put("f390023", DataUtil.Long2String(umFeature.getUExposePeriod()));

                retMap.put("f390024",DataUtil.Long2String(Math.min(umFeature.getUClickHistCnt(),100)));
                retMap.put("f390025",DataUtil.Long2String(Math.min(umFeature.getUClickWeekCnt(),100)));

                retMap.put("f390026", DataUtil.Long2String(Math.min(umFeature.getUClickDayCnt(),100)));
                retMap.put("f390027", DataUtil.Long2String(Math.min(umFeature.getUExposeDayCnt(),100)));

                retMap.put("f390028", bucket(umFeature.getUClickInterval(), timeBucket).toString());
                retMap.put("f390029", DataUtil.Long2String(umFeature.getUClickPeriod()));


                Double uhisCtr = calWilsonScore(umFeature.getUExposeHistCnt(), umFeature.getUClickHistCnt());
                Double uweekCtr = calWilsonScore(umFeature.getUExposeWeekCnt(), umFeature.getUClickWeekCnt());


                retMap.put("f390044", DataUtil.Long2String(bucket(uhisCtr,userCtrBucket)));


                //广告位-素材

                SlotMaterialFeature smFeature = Optional.ofNullable(cf.getSlotMaterialFeatureMap().get(materialId)).orElse(new SlotMaterialFeature());

                retMap.put("f390030", DataUtil.Long2String(bucket(smFeature.getSlotClickDayCnt(),sclickDayBucket)));
                retMap.put("f390031", DataUtil.Long2String(bucket(smFeature.getSlotClickWeekCnt(),sclickWeekBucket)));
                retMap.put("f390032", DataUtil.Long2String(bucket(smFeature.getSlotExposeWeekCnt(),sexpWeekBucket)));
                retMap.put("f390033", DataUtil.Long2String(bucket(smFeature.getSlotExposeDayCnt(),sexpDayBucket)));

                retMap.put("f390034", DataUtil.Long2String(smFeature.getSlotExposePeriod()));
                retMap.put("f390035", DataUtil.Long2String(smFeature.getSlotClickPeriod()));
                retMap.put("f390036", DataUtil.Integer2String(level(smFeature.getSlotConvertHistCnt(),50L,0,100)));
                retMap.put("f390037", DataUtil.Integer2String(level(smFeature.getSlotBConvertHistCnt(),50L,0,100)));
                retMap.put("f390038", DataUtil.Long2String(bucket(smFeature.getSlotConvertWeekCnt(),convertCntBucket)));
                retMap.put("f390039", DataUtil.Long2String(bucket(smFeature.getSlotBConvertWeekCnt(),bconvertCntBucket)));

                Double sweekCtr = calWilsonScore(smFeature.getSlotExposeWeekCnt(), smFeature.getSlotClickWeekCnt());
                Double sdayCtr = calWilsonScore(smFeature.getSlotExposeDayCnt(), smFeature.getSlotClickDayCnt());

                retMap.put("f390045", DataUtil.Long2String(bucket(sweekCtr,slotCtrBucket)));
                retMap.put("f390046", DataUtil.Long2String(bucket(sdayCtr,slotCtrBucket)));


            }
        } catch (Exception e) {
            logger.error("MaterialFeatureParse.generateFeatureMapDynamic error:", e);

        }
        return retMap;
    }



    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty(firstPv, secondPv) && firstPv > 0)
            ret = DataUtil.division(secondPv, firstPv);

        return ret;
    }

    private static double calWilsonScore(long exposeCnt, long clickCnt) {
        // 计算 wilson 置信分数，取99%置信度
        if (exposeCnt == 0) {
            return 0.0;
        }
        double ratio = clickCnt * 1.0 / exposeCnt;
        double faithLevel = 0.99;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + (faithSquare / (2 * exposeCnt)) - faithLevel * Math.sqrt(4 * exposeCnt * ratio * (1 - ratio) + faithSquare) / (2 * exposeCnt))
                / (1 + faithSquare / exposeCnt);
    }

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }


    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0) {
            ret = Math.round(log(lvalue.doubleValue(),500));
        }
        return ret;

    }
    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    public static Integer level(Long value, Long base,Integer min,Integer max) {
        Integer ret = null;
        if (value != null && value > 0) {
            ret = Math.round(value/base);
            ret =  Math.max(Math.min(ret,max),min);
        }
        return ret;
    }


    public static String subList(List<String> list) {
        List<String> subList = list;
        if (list.size() > 30) {
            subList = subList.subList(list.size() - 30, list.size());
            return subList.toString();
        } else {
            return list.toString();
        }
    }



    public static String sortSubList(String string) {
        List<String> list = Arrays.asList(string.split(","));

        Collections.sort(list, new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                String[] array1 = o1.split("-");
                String[] array2 = o2.split("-");
                return array1[0].compareTo(array2[0]);
            }
        });
        List<String> newArray = new ArrayList<>();
        for (String s:list) {
            newArray.add(s.split("-")[1]);
        }
        return subList(newArray);
    }

    public static void main(String[] args) {
        String string = "20100724201049-0716,20200727201101-01182,20250723201243-187751,20200723201049-716,20200723201101-1182,20200723201243-18751," +
                "20300723201349-7716,20200723201101-1182,20200723200843-187571,20200723201049-716,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-11782,20200723200843-18751,20200723201049-716,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-716,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-716,20200723201901-1182,20200723111243-18751,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-7146,20200723101901-1182,20200723201243-187251,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-716,20200723201901-11282,20200723201243-18751,20200723201349-716,20200723201101-1182,20200723200843-187251,20200723201049-7126,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-11822,20200723200843-187521,20200723201049-7126,20200723201901-1182,20200723201243-18752";
        System.out.println(sortSubList(string));


        String str = "1,2,2,3,2,2,2,2,1,2,3,4,5,6,7,56,6,7,8,89,12,3,4,5,1,2,3,45,89,78,76,56,56,43,53,2,2";
        List<String> list = Arrays.asList(str.split(","));
        System.out.println(subList(list));

    }

}

