package cn.com.duiba.nezha.alg.feature.vo;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureParse2;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import org.slf4j.LoggerFactory;

@Data
public class UserActFeature implements Serializable {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(UserActFeature.class);
    private static final long serialVersionUID = -2203632123858487448L;

    public static Double[] userCtrBucket = {0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    public static Double[] userCvrBucket = {0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};


    // 用户属性
    private Integer userActiveDays;  // f410001 用户生命周期（天）

    // 用户行为
    // 活动访问
    private Integer activityRequest;   //f411001 历史活动访问次数
    private Integer weekActivityRequest;   //f411002  一周内活动访问次数
    private Integer dayActivityRequest;    //f411003 当日活动访问次数
    private Integer intervalActivityRequest;   //f411004	 历史距离上一次活动访问时间间隔（天）
    private String periodActivityRequest;   //f411005 历史活动访问频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）

    // 活动参与
    private Integer activityJoin;  //f412001 历史活动参与次数
    private Integer weekActivityJoin;  //f412002 一周内活动参与次数
    private Integer dayActivityJoin;   //f412003 当日活动参与次数
    private Integer intervalActivityJoin;  //f412004 历史距离上一次活动参与时间间隔（天）
    private String periodActivityJoin;  //f412005 历史活动参与频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer activityPageStay;  //f412006 历史活动页平均停留时长（秒）

    // 发券
    private String launchTrade; //f413001 历史不同行业上发券数量
    private String weekLaunchTrade; //f413002 一周内不同行业发券数量
    private Map<String, Integer> dayLaunchTrade;  //f413003 当日不同行业发券数量
    private Integer intervalLaunchTrade;   //f413004 历史距离上一次发券时间间隔（天）
    private String periodLaunchTrade;   //f413005 历史发券频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer avgLaunchStay; //f413006 历史券展示平均时长（秒）
    private String lastLaunchTrade; //f413007 上一次发券行业
    private Integer clickLaunchTrade;   //f413008 上一次发券是否点击

    // 券点击
    private String clickTrade;  //f414001 历史不同行业上券点击数量
    private String weekClickTrade;  //f414002 一周内不同行业上券点击数量
    private Map<String, Integer> dayClickTrade;   //f414003 当日不同行业上券点击数量
    private Integer intervalClickTrade;    //f414004 历史距离上一次券点击时间间隔（天）
    private String periodClickTrade;    //f414005 历史券点击频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastClickTrade;  //f414007 上一次券点击行业
    private Integer effectClickTrade;   //f414008 上一次券点击是否转化

    // 转化
    private String effectTrade; //f415001 历史不同行业上转化数量
    private String weekEffectTrade; //f415002 一周内不同行业上转化数量
    private Map<String, Integer> dayEffectTrade;  //f415003 当日不同行业上转化数量
    private Integer intervalEffectTrade;   //f415004 历史距离上一次转化时间间隔（天）
    private String periodEffectTrade;   //f415005 历史转化频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastEffectTrade; //f415007 上一次转化行业

    // OneId用户行为数据

    private Long todayLaunch;   // 用户当日第几个订单个数
    private Long historyLaunch; // 用户全局第几个订单序列
    private Long todayActivityLaunch;   // 用户当日该活动第几个订单序列
    private Long historyActivityLaunch; // 用户全局该活动第几个订单序列
    private String lastLaunchTime;  // 用户全局上次发券时间
    private String lastActivityLaunchTime;  // 该活动下上次发券时间
    private String lastActivityLaunchOrder; // 该活动下上一次发券订单
    private String lastActivityClickOrder; // 该活动下上一次点击订单
    private String lastLaunchOrder; // 上一次发券订单
    private String lastClickOrder;  // 上一次点击订单
    private String lastActivity;    // 用户前一单活动
    private String lastAdvertMatchTag;  // 用户前一单广告二级行业标签


    private Map<String, Long> todayResourceLaunch; // 当天各资源下的发券数
    private Map<String, String> lastResourceLaunchTime; // 各资源上次发券时间
    private Map<String, String> lastResourceLaunchOrder;    // 各资源上一次发券订单
    private Map<String, String> lastResourceClickOrder; // 各资源上一次点击订单
    private Map<String, String> lastResourceEffectOrder;    // 各资源上一次转化订单
    private Map<String, Long> todayResourceClickAdvertCount;    // 用户当日各资源点击广告个数
    private Map<String, Long> todayResourceEffectAdvertCount;   // 用户当日各资源转化广告个数
    private String lastResource;    // 用户上一单资源
    private String lastLaunchAccount; // 用户上一单广告主
    private String lastLaunchPlan; // 用户上一单计划（计划id==广告id）

    private Set<Integer> advertExposureSet;  // 曝光广告集合

    private Set<Integer> advertClickSet;    // 点击广告集合
    private Set<Integer> accountClickSet;   // 点击广告主集合
    private Set<String> resourceClickSet;   // 点击资源集合
    private Set<Integer> tradeClickSet;     // 点击行业集合

    private Set<Integer> advertEffectSet;   // 转化广告集合
    private Set<Integer> accountEffectSet;  // 转化广告主集合
    private Set<String> resourceEffectSet;  // 转化资源集合
    private Set<Integer> tradeEffectSet;    // 转化行业集合

    // 广告维度 行为明细
    private Map<Integer, Long> todayAdvertLaunch;   // 用户当日广告发券次数
    private Map<Integer, Long> todayAdvertClick;    // 用户当日广告点击次数
    private Map<Integer, Long> todayAdvertEffect;   // 用户当日广告转化次数
    private Map<Integer, Long> historyAdvertLaunch; // 用户历史广告发券次数
    private Map<Integer, Long> historyAdvertClick;  // 用户历史广告点击次数
    private Map<Integer, Long> historyAdvertEffect; // 用户历史广告转化次数

    private Integer history30LaunchCount;   //历史=30，曝光PV
    private Integer history30ClickCount;    //历史=30，点击PV
    private Integer history30EffectCount;   //历史=30，转化PV
    private Integer todayLaunchCount;   //当日，曝光PV
    private Integer todayClickCount;   //当日，点击PV
    private Integer todayEffectCount;   //当日，转化PV


    // 广告行业维度 行为明细
    private String oUIIds;
    private String oUILaunchPV;
    private String oUIClickPv;
    private String oUIEffectPv;

    private Map<String, Long> historyTradeLaunch;// 用户历史广告行业发券次数
    private Map<String, Long> historyTradeClick;// 用户历史广告行业点击次数
    private Map<String, Long> historyTradeEffect;// 用户历史广告行业转化次数
    private Map<String, Map<String, Long>> historyTradeCtrCvr;

    public Map<String, Long> getHistoryTradeLaunch(){
        if (this.historyTradeLaunch!=null){
            return this.historyTradeLaunch;
        }
        Map<String, String> historyTradeLaunchMap = DataConverter.series2Map(this.oUIIds, this.oUILaunchPV, ",");

        Map<String, Long> historyTradeLaunchMapL =  new HashMap<>();
        try{
            for (Map.Entry<String, String> entry : historyTradeLaunchMap.entrySet()) {
                historyTradeLaunchMapL.put(entry.getKey(), DataUtil.str2Long(entry.getValue(), 0L));
            }
            this.historyTradeLaunch = historyTradeLaunchMapL;
        } catch (Exception e ) {
            logger.error("FeatureParse2.getHistoryTradeLaunch error", e);
            return historyTradeLaunchMapL;
        }
        return historyTradeLaunchMapL;
    }

    public Map<String, Long> getHistoryTradeClick(){
        if (this.historyTradeClick!=null){
            return this.historyTradeClick;
        }
        Map<String, String> historyTradeClickMap = DataConverter.series2Map(this.oUIIds, this.oUIClickPv, ",");
        Map<String, Long> historyTradeClickMapL =  new HashMap<>();
        try{
            for (Map.Entry<String, String> entry : historyTradeClickMap.entrySet()) {
                historyTradeClickMapL.put(entry.getKey(), DataUtil.str2Long(entry.getValue(), 0L));
            }
            this.historyTradeClick = historyTradeClickMapL;
        } catch (Exception e ) {
            logger.error("FeatureParse2.getHistoryTradeClick error", e);
            return historyTradeClickMapL;
        }
        return historyTradeClickMapL;

    }

    public Map<String, Long> getHistoryTradeEffect(){
        if (this.historyTradeEffect!=null){
            return this.historyTradeEffect;
        }
        Map<String, String> historyTradeEffectMap = DataConverter.series2Map(this.oUIIds, this.oUIEffectPv, ",");
        Map<String, Long> historyTradeEffectMapL =  new HashMap<>();
        try{
            for (Map.Entry<String, String> entry : historyTradeEffectMap.entrySet()) {
                historyTradeEffectMapL.put(entry.getKey(), DataUtil.str2Long(entry.getValue(), 0L));
            }
            this.historyTradeEffect = historyTradeEffectMapL;
        } catch (Exception e ) {
            logger.error("FeatureParse2.getHistoryTradeEffect error", e);
            return historyTradeEffectMapL;
        }
        return historyTradeEffectMapL;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty(firstPv, secondPv) && firstPv > 0)
            ret = DataUtil.division(secondPv, firstPv);
        return ret;
    }


    public Map<String, Map<String, Long>> getHistoryTradeCtrCvr(){
        if(this.historyTradeCtrCvr!=null) {
            return this.historyTradeCtrCvr;
        }

        // ret = {"ctr":{"0":ctr_level, "trade1":ctr_level..}, {"cvr":{"0":cvr_level, "trade1":.. }}}
        Map<String, Map<String, Long>> ret = new HashMap<>();
        ret.put("ctr", new HashMap<String, Long>());
        ret.put("cvr", new HashMap<String, Long>());
        Map<String, Long> historyTradeLaunch = this.getHistoryTradeLaunch();
        Map<String, Long> historyTradeClick = this.getHistoryTradeClick();
        Map<String, Long> historyTradeEffect = this.getHistoryTradeEffect();

        if (this.oUIIds == null || AssertUtil.isEmpty(this.oUIIds)) {
            return ret;
        }


        String [] oUIIdsArr = this.oUIIds.split(",");
        // 计算每个行业的ctr/cvr
        for (int i = 0; i < oUIIdsArr.length; i++) {
            String id = oUIIdsArr[i];
            Long launchPv = historyTradeLaunch.getOrDefault(id, 0L);
            Long clickPv = historyTradeClick.getOrDefault(id, 0L);
            Long effectPv = historyTradeEffect.getOrDefault(id, 0L);

            Double ctr = getCtrOrCvr(launchPv, clickPv);
            Double cvr = getCtrOrCvr(clickPv, effectPv);

            Long ctrBkt = DataUtil.str2Long(DataConverter.bucketRight(ctr, userCtrBucket),0L);
            Long cvrBkt = DataUtil.str2Long(DataConverter.bucketRight(cvr,userCvrBucket),0L);

            ret.get("ctr").put(id, ctrBkt);
            ret.get("cvr").put(id, cvrBkt);
        }
        // 计算整体的ctr/cvr
        Long launchAccPv = DataConverter.accumulateMapValues(historyTradeLaunch).longValue();
        Long clickAccPv = DataConverter.accumulateMapValues(historyTradeClick).longValue();
        Long effectAccPv = DataConverter.accumulateMapValues(historyTradeEffect).longValue();
        Double ctr = getCtrOrCvr(launchAccPv, clickAccPv);
        Double cvr = getCtrOrCvr(clickAccPv, effectAccPv);
        Long ctrBucketLevel = DataUtil.str2Long(DataConverter.bucketRight(ctr, userCtrBucket), 0L);
        Long cvrBucketLevel = DataUtil.str2Long(DataConverter.bucketRight(cvr, userCvrBucket), 0L);
        ret.get("ctr").put("0", ctrBucketLevel);// 整体ctr
        ret.get("cvr").put("0", cvrBucketLevel);// 整体cvr
        this.historyTradeCtrCvr = ret;
        return ret;
    }






    public Integer getHistory30LaunchCount(){
        if (this.history30LaunchCount!=null){
            return this.history30LaunchCount;
        }
        return DataConverter.accumulateMapValues(this.historyAdvertLaunch).intValue();
    }

    public Integer getHistory30ClickCount(){
        if (this.history30ClickCount!=null){
            return this.history30ClickCount;
        }
        return DataConverter.accumulateMapValues(this.historyAdvertClick).intValue();
    }

    public Integer getHistory30EffectCount(){
        if (this.history30EffectCount!=null){
            return this.history30EffectCount;
        }
        return DataConverter.accumulateMapValues(this.historyAdvertEffect).intValue();
    }

    public Integer getTodayLaunchCount(){
        if (this.todayLaunchCount!=null){
            return this.todayLaunchCount;
        }
        return DataConverter.accumulateMapValues(this.todayAdvertLaunch).intValue();
    }

    public Integer getTodayClickCount(){
        if (this.todayClickCount!=null){
            return this.todayClickCount;
        }
        return DataConverter.accumulateMapValues(this.todayAdvertClick).intValue();
    }

    public Integer getTodayEffectCount(){
        if (this.todayEffectCount!=null){
            return this.todayEffectCount;
        }
        return DataConverter.accumulateMapValues(this.todayAdvertEffect).intValue();

    }








}
