package cn.com.duiba.nezha.alg.feature.vo;

import java.io.Serializable;
import java.util.Map;

import lombok.Data;

/**
 * adx创意素材特征
 */

@Data
public class AdxIdeaMaterialDo implements Serializable {

    private static final long serialVersionUID = 1825123147647706974L;

    /**
     * 创意素材id--sck_id
     */
    private Long materialId;

    /**
     * 素材效果分类（动态，静态，视频）
     */
    private String effectType;

    /**
     * 素材类型（单图，组图）
     */
    private String figureType;

    /**
     *  是否定制
     */
    private String customType;

    /**
     * 素材行业标签
     */
    private String materialIndustryTag;

    /**
     * 广告位性质
     */
    private String slotType;

    /**
     * 优质素材策略
     */
    private String materialStrategy;

    /**
     * 奖品元素
     */
    private String prizeElement;

    /**
     * 设计色调
     */
    private String designColor;

    /**
     * 设计风格
     */
    private String designStyle;

    /**
     * 设计动效
     */
    private String dynamicEffect;

    /**
     * 文案元素
     */
    private String textElement;

    /**
     *  活动工具
     */
    private String activityTool;

    /**
     * 季节标签
     */
    private String season;

    /**
     * 节日标签
     */
    private String festival;

    /**
     * 时间标签（周末，月初，月中，月末）
     */
    private String timing;

    /**
     * 使用场景
     */
    private String scene;

    /**
     * 素材尺寸比例区间ID
     */
    private Long adxRatioType;


    //素材行为数据
    private Long maExpCntDay; //素材id 当天曝光次数
    private Long maClickCntDay; //素材id 当天点击次数
    private Long maExpCnt3Day; //素材id 近3天曝光次数
    private Long maClickCnt3Day; //素材id 近3天点击次数

    //素材+资源位行为数据
    private Long maResoExpCntDay; //素材id+资源位id 当天曝光次数
    private Long maResoClickCntDay; //素材id+资源位id 当天点击次数
    private Long maResoExpCnt3Day; //素材id+资源位id 近3天曝光次数
    private Long maResoClickCnt3Day; //素材id+资源位id 近3天点击次数



}
