package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class DmpFeature implements Serializable {

    private static final long serialVersionUID = 5425570671038350451L;

    //app安装列表
    private String appList;

    // 用户基础标签
    private String userBasicTags; //f9701, 人工打标的用户基础标签

    // 用户文本标签
    private String userContentTags; //9704, 用户文本标签列表

    // 短信签名列表
    private String sigList;  //f9801, 短信签名列表

    //有效app安装列表
    private String validAppList;

    //top app安装列表300
    private String topAppList;

    //top app安装列表500
    private String topAppList2;

    //top app安装列表1000
    private String topAppList3;

    //中长尾app安装列表
    private String midAppList;

    //近期安装app
    private String installAppList;

    //近期卸载app
    private String uninstallAppList;

    //每个类目下的app数 存储格式json
    private String appCategory;

    //广告行业对应的app 存储格式json
    private String tradeAppList;

    //app向量
    private String appVector;

    //每个类目下的短信签名数
    private String msgCategory;

    //短信签名关键字
    private String msgKeyword;

    //每个类目下标签数
    private String tagCategory;

    //短信签名向量
    private String msgVector;

    //    短信签名列表8维embedding
    private String msgListEmbed8;

    //    App列表32维embedding(包名、一、二、三级类目embedding拼接)
    private String appListEmbed32;





    //场景：ADX流量
    //设备号 当天竞价次数
    private Long imeiDayBidTimes;

    //设备号 当天曝光次数
    private Long imeiDayExpTimes;

    //资源位id+设备号 当天竞价次数
    private Long resoDayBidTimes;

    //资源位id+设备号 当天曝光次数
    private Long resoDayExpTimes;

    //imei+推广组 历史7天 竞价次数
    private Long historyGroBid;

    //imei+推广组 历史7天 曝光次数
    private Long historyGroExp;

    //imei+推广组 历史7天 点击次数
    private Long historyGroClick;

    //imei+资源位 历史7天 竞价次数
    private Long historyResoBid;

    //imei+资源位 历史7天 曝光次数
    private Long historyResoExp;

    //imei+资源位 历史7天 点击次数
    private Long historyResoClick;

    //imei 历史7天 竞价次数
    private Long historyImeiBid;

    //imei 历史7天 曝光次数
    private Long historyImeiExp;

    //imei 历史7天 点击次数
    private Long historyImeiClick;

    //爱奇艺用户人群标签
    private List<String> aiQiYiUserTag;


    //dmp用户画像&行为数据
    private String sex;                      //性别
    private String age;                      //年龄
    private String marry;                    //婚恋
    private String recentVideoCatePref;      //短期视频二级类目偏好（近14天）
    private String recentVideoChannelPref;   //短期视频频道偏好（近14天）
    private String lastVideoChannel;         //上一次观看视频频道
    private String lastVideoCategory;        //上一次观看视频二级分类id
    private Integer weekActivityRequest;     //一周内活动访问次数
    private Integer dayActivityRequest;      //当日活动访问次数
    private String periodActivityRequest;    //历史活动访问频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer weekActivityJoin;        //一周内活动参与次数
    private Integer dayActivityJoin;         //当日活动参与次数
    private String periodActivityJoin;       //历史活动参与频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String periodLaunchTrade;        //历史发券频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer clickLaunchTrade;        //上一次发券是否点击
    private String periodClickTrade;         //历史券点击频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer effectClickTrade;        //上一次券点击是否转化

    private Integer imeiResoDayClkTimes;    //用户+资源位id 当天点击次数
    private Integer imeiResoDayActReq;      //用户+资源位id 当天活动访问次数
    private Integer imeiResoDayActJoin;     //用户+资源位id 当天活动参与次数
    private Integer imeiResoDayAdvertExp;   //用户+资源位id 当天广告曝光次数
    private Integer imeiResoDayAdvertClk;   //用户+资源位id 当天广告点击次数
    private Integer imeiResoActReq7d;       //imei+资源位 历史7天 活动访问次数
    private Integer imeiResoActJoin7d;      //imei+资源位 历史7天 活动参与次数
    private Integer imeiResoAdvertExp7d;    //imei+资源位 历史7天 广告曝光次数
    private Integer imeiResoAdvertClk7d;    //imei+资源位 历史7天 广告点击次数
    private Integer imeiResoExp28d;         //imei+资源位 历史28天 曝光次数
    private Integer imeiResoClick28d;       //imei+资源位 历史28天 点击次数
    private Integer imeiResoActReq28d;      //imei+资源位 历史28天 活动访问次数
    private Integer imeiResoActJoin28d;     //imei+资源位 历史28天 活动参与次数
    private Integer imeiResoAdvertExp28d;   //imei+资源位 历史28天 广告曝光次数
    private Integer imeiResoAdvertClk28d;   //imei+资源位 历史28天 广告点击次数

    private Integer imeiDayClkTimes;        //imei 当天点击次数
    private Integer imeiAdvertExpDay;       //imei 当日广告曝光次数
    private Integer imeiAdvertClkDay;       //imei 当日广告点击次数
    private Integer imeiAdvertExp7d;        //imei 7日广告曝光次数
    private Integer imeiAdvertClk7d;        //imei 7日广告点击次数
    private Integer imeiExp28d;             //imei 历史28天 曝光次数
    private Integer imeiClick28d;           //imei 历史28天 点击次数
    private Integer imeiActReq28d;          //imei 历史28天 活动访问次数
    private Integer imeiActJoin28d;         //imei 历史28天 活动参与次数
    private Integer imeiAdvertExp28d;       //imei 28日广告曝光次数
    private Integer imeiAdvertClk28d;       //imei 28日广告点击次数

    private Integer intervalMaterialExp;       //f409004 历史距离上一次素材曝光时间间隔（天）
    private Integer intervalMaterialClk;       //f410004 历史距离上一次素材点击时间间隔（天）
    private Integer intervalActivityRequest;   //f411004 历史距离上一次活动访问时间间隔（天）
    private Integer intervalActivityJoin;      //f412004 历史距离上一次活动参与时间间隔（天）
    private Integer intervalLaunchTrade;       //f413004 历史距离上一次发券时间间隔（天）
    private Integer intervalClickTrade;        //f414004 历史距离上一次券点击时间间隔（天）

    private String imeiAdvertTradeExp7d;       //imei 7天内不同广告行业券曝光次数
    private String imeiAdvertTradeClk7d;       //imei 7天内不同广告行业券点击次数
    private String imeiAdvertTradeExp28d;      //imei 28天内不同广告行业券曝光次数
    private String imeiAdvertTradeClk28d;      //imei 28天内不同广告行业券点击次数

    private String imeiResoAdvertTradeExp7d;   //imei+资源位 7天内不同广告行业券曝光次数
    private String imeiResoAdvertTradeClk7d;   //imei+资源位 7天内不同广告行业券点击次数
    private String imeiResoAdvertTradeExp28d;  //imei+资源位 28天内不同广告行业券曝光次数
    private String imeiResoAdvertTradeClk28d;  //imei+资源位 28天内不同广告行业券点击次数


    // ADX频道id整合
    private String weekChannelIds;      // 用户一周内访问的频道ID
    private String halfMonthChannelIds; // 用户14天内访问的频道ID
    private String historyChannelIds;   // 用户历史天内访问的频道ID


    public String getValidAppList() {
        return validAppList;
    }

    public void setValidAppList(String validAppList) {
        this.validAppList = validAppList;
    }

    public String getTopAppList() {
        return topAppList;
    }

    public void setTopAppList(String topAppList) {
        this.topAppList = topAppList;
    }

    public String getMidAppList() {
        return midAppList;
    }

    public void setMidAppList(String midAppList) {
        this.midAppList = midAppList;
    }

    public String getInstallAppList() {
        return installAppList;
    }

    public void setInstallAppList(String installAppList) {
        this.installAppList = installAppList;
    }

    public String getUninstallAppList() {
        return uninstallAppList;
    }

    public void setUninstallAppList(String uninstallAppList) {
        this.uninstallAppList = uninstallAppList;
    }

    public String getAppCategory() {
        return appCategory;
    }

    public void setAppCategory(String appCategory) {
        this.appCategory = appCategory;
    }

    public String getTradeAppList() {
        return tradeAppList;
    }

    public void setTradeAppList(String tradeAppList) {
        this.tradeAppList = tradeAppList;
    }

    public String getAppVector() {
        return appVector;
    }

    public void setAppVector(String appVector) {
        this.appVector = appVector;
    }

    public String getMsgCategory() {
        return msgCategory;
    }

    public void setMsgCategory(String msgCategory) {
        this.msgCategory = msgCategory;
    }

    public String getMsgKeyword() {
        return msgKeyword;
    }

    public void setMsgKeyword(String msgKeyword) {
        this.msgKeyword = msgKeyword;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getAppList() {
        return appList;
    }

    public void setAppList(String appList) {
        this.appList = appList;
    }

    public String getUserBasicTags() {
        return userBasicTags;
    }

    public void setUserBasicTags(String userBasicTags) {
        this.userBasicTags = userBasicTags;
    }

    public String getUserContentTags() {
        return this.userContentTags;
    }

    public void setUserContentTags(String userContentTags) {
        this.userContentTags = userContentTags;
    }

    public String getSigList() {
        return sigList;
    }

    public void setSigList(String sigList) {
        this.sigList = sigList;
    }

    public String getTagCategory() {
        return tagCategory;
    }

    public void setTagCategory(String tagCategory) {
        this.tagCategory = tagCategory;
    }

    public String getTopAppList2() {
        return topAppList2;
    }

    public void setTopAppList2(String topAppList2) {
        this.topAppList2 = topAppList2;
    }

    public String getTopAppList3() {
        return topAppList3;
    }

    public void setTopAppList3(String topAppList3) {
        this.topAppList3 = topAppList3;
    }

    public String getMsgVector() {
        return msgVector;
    }

    public void setMsgVector(String msgVector) {
        this.msgVector = msgVector;
    }

    public String getmsgListEmbed8() {
        return msgListEmbed8;
    }

    public void setmsgListEmbed8(String msgListEmbed8) {
        this.msgListEmbed8 = msgListEmbed8;
    }

    public String getAppListEmbed32() {
        return appListEmbed32;
    }

    public void setAppListEmbed32(String appListEmbed32) {
        this.appListEmbed32 = appListEmbed32;
    }

    public Long getImeiDayBidTimes() {
        return imeiDayBidTimes;
    }

    public void setImeiDayBidTimes(Long imeiDayBidTimes) {
        this.imeiDayBidTimes = imeiDayBidTimes;
    }

    public Long getImeiDayExpTimes() {
        return imeiDayExpTimes;
    }

    public void setImeiDayExpTimes(Long imeiDayExpTimes) {
        this.imeiDayExpTimes = imeiDayExpTimes;
    }

    public Long getResoDayBidTimes() {
        return resoDayBidTimes;
    }

    public void setResoDayBidTimes(Long resoDayBidTimes) {
        this.resoDayBidTimes = resoDayBidTimes;
    }

    public Long getResoDayExpTimes() {
        return resoDayExpTimes;
    }

    public void setResoDayExpTimes(Long resoDayExpTimes) {
        this.resoDayExpTimes = resoDayExpTimes;
    }

    public Long getHistoryGroBid() {
        return historyGroBid;
    }

    public void setHistoryGroBid(Long historyGroBid) {
        this.historyGroBid = historyGroBid;
    }

    public Long getHistoryGroExp() {
        return historyGroExp;
    }

    public void setHistoryGroExp(Long historyGroExp) {
        this.historyGroExp = historyGroExp;
    }

    public Long getHistoryGroClick() {
        return historyGroClick;
    }

    public void setHistoryGroClick(Long historyGroClick) {
        this.historyGroClick = historyGroClick;
    }

    public Long getHistoryResoBid() {
        return historyResoBid;
    }

    public void setHistoryResoBid(Long historyResoBid) {
        this.historyResoBid = historyResoBid;
    }

    public Long getHistoryResoExp() {
        return historyResoExp;
    }

    public void setHistoryResoExp(Long historyResoExp) {
        this.historyResoExp = historyResoExp;
    }

    public Long getHistoryResoClick() {
        return historyResoClick;
    }

    public void setHistoryResoClick(Long historyResoClick) {
        this.historyResoClick = historyResoClick;
    }

    public Long getHistoryImeiBid() {
        return historyImeiBid;
    }

    public void setHistoryImeiBid(Long historyImeiBid) {
        this.historyImeiBid = historyImeiBid;
    }

    public Long getHistoryImeiExp() {
        return historyImeiExp;
    }

    public void setHistoryImeiExp(Long historyImeiExp) {
        this.historyImeiExp = historyImeiExp;
    }

    public Long getHistoryImeiClick() {
        return historyImeiClick;
    }

    public void setHistoryImeiClick(Long historyImeiClick) {
        this.historyImeiClick = historyImeiClick;
    }

    public List<String> getAiQiYiUserTag() { return aiQiYiUserTag; }

    public void setAiQiYiUserTag(List<String> aiQiYiUserTag) { this.aiQiYiUserTag = aiQiYiUserTag; }

    public String getSex() { return sex; }

    public void setSex(String sex) { this.sex = sex; }

    public String getAge() { return age; }

    public void setAge(String age) { this.age = age; }

    public String getMarry() { return marry; }

    public void setMarry(String marry) { this.marry = marry; }

    public String getRecentVideoCatePref() { return recentVideoCatePref; }

    public void setRecentVideoCatePref(String recentVideoCatePref) { this.recentVideoCatePref = recentVideoCatePref; }

    public String getRecentVideoChannelPref() { return recentVideoChannelPref; }

    public void setRecentVideoChannelPref(String recentVideoChannelPref) { this.recentVideoChannelPref = recentVideoChannelPref; }

    public String getLastVideoChannel() { return lastVideoChannel; }

    public void setLastVideoChannel(String lastVideoChannel) { this.lastVideoChannel = lastVideoChannel; }

    public String getLastVideoCategory() { return lastVideoCategory; }

    public void setLastVideoCategory(String lastVideoCategory) { this.lastVideoCategory = lastVideoCategory; }

    public Integer getWeekActivityRequest() { return weekActivityRequest; }

    public void setWeekActivityRequest(Integer weekActivityRequest) { this.weekActivityRequest = weekActivityRequest; }

    public Integer getDayActivityRequest() { return dayActivityRequest; }

    public void setDayActivityRequest(Integer dayActivityRequest) { this.dayActivityRequest = dayActivityRequest; }

    public String getPeriodActivityRequest() { return periodActivityRequest; }

    public void setPeriodActivityRequest(String periodActivityRequest) { this.periodActivityRequest = periodActivityRequest; }

    public Integer getWeekActivityJoin() { return weekActivityJoin; }

    public void setWeekActivityJoin(Integer weekActivityJoin) { this.weekActivityJoin = weekActivityJoin; }

    public Integer getDayActivityJoin() { return dayActivityJoin; }

    public void setDayActivityJoin(Integer dayActivityJoin) { this.dayActivityJoin = dayActivityJoin; }

    public String getPeriodActivityJoin() { return periodActivityJoin; }

    public void setPeriodActivityJoin(String periodActivityJoin) { this.periodActivityJoin = periodActivityJoin; }

    public String getPeriodLaunchTrade() { return periodLaunchTrade; }

    public void setPeriodLaunchTrade(String periodLaunchTrade) { this.periodLaunchTrade = periodLaunchTrade; }

    public Integer getClickLaunchTrade() { return clickLaunchTrade; }

    public void setClickLaunchTrade(Integer clickLaunchTrade) { this.clickLaunchTrade = clickLaunchTrade; }

    public String getPeriodClickTrade() { return periodClickTrade; }

    public void setPeriodClickTrade(String periodClickTrade) { this.periodClickTrade = periodClickTrade; }

    public Integer getEffectClickTrade() { return effectClickTrade; }

    public void setEffectClickTrade(Integer effectClickTrade) { this.effectClickTrade = effectClickTrade; }

    public String getWeekChannelIds() {
        return weekChannelIds;
    }

    public void setWeekChannelIds(String weekChannelIds) {
        this.weekChannelIds = weekChannelIds;
    }

    public String getHalfMonthChannelIds() {
        return halfMonthChannelIds;
    }

    public void setHalfMonthChannelIds(String halfMonthChannelIds) {
        this.halfMonthChannelIds = halfMonthChannelIds;
    }

    public String getHistoryChannelIds() {
        return historyChannelIds;
    }

    public void setHistoryChannelIds(String historyChannelIds) {
        this.historyChannelIds = historyChannelIds;
    }
}
