/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.DmpFeature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.ItemProfileFeature;
import cn.com.duiba.nezha.alg.feature.vo.LoadingPageFeature;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginalFeature {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(OriginalFeature.class);

    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                cf.setCurrentGmtCreateTime(LocalDateUtil.getCurrentLocalDateTime((String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
                retMap.put("f601001", DataUtil.Long2String((Long)cf.getDayOrderRank()));
                retMap.put("f602001", DataUtil.Long2String((Long)cf.getOrderRank()));
                retMap.put("f603001", DataUtil.Long2String((Long)cf.getDayActivityOrderRank()));
                retMap.put("f604001", DataUtil.Long2String((Long)cf.getActivityOrderRank()));
                Long orderIntervalMinutes = LocalDateUtil.getIntervalMinutes((String)cf.getCurrentGmtCreateTime(), (String)cf.getLastGmtCreateTime(), (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
                retMap.put("f605001", DataUtil.Long2String((Long)orderIntervalMinutes));
                Long activityOrderMinutes = LocalDateUtil.getIntervalMinutes((String)cf.getCurrentGmtCreateTime(), (String)cf.getActivityLastGmtCreateTime(), (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
                retMap.put("f606001", DataUtil.Long2String((Long)activityOrderMinutes));
                retMap.put("f607001", DataUtil.Long2String((Long)cf.getActivityLastChargeNums()));
                retMap.put("f608001", DataUtil.Long2String((Long)cf.getLastChargeNums()));
                retMap.put("f611001", DataUtil.Long2String((Long)cf.getPutIndex()));
                Long dayIntervals = LocalDateUtil.getIntervalDays((Date)cf.getUserLastlogbigintime(), (Date)cf.getUserRegtime());
                retMap.put("f403004", DataUtil.Long2String((Long)dayIntervals));
                retMap.put("f9916_a", cf.getUIIds());
                retMap.put("f9916", cf.getUILaunchPV());
                retMap.put("f9917", cf.getUIClickPv());
                retMap.put("f9918", cf.getUIEffectPv());
                retMap.put("f9919", cf.getUIScore());
                retMap.put("f601002", DataUtil.Long2String((Long)cf.getDayOrderRank()));
                retMap.put("f602002", DataUtil.Long2String((Long)cf.getOrderRank()));
                retMap.put("f603002", DataUtil.Long2String((Long)cf.getDayActivityOrderRank()));
                retMap.put("f604002", DataUtil.Long2String((Long)cf.getActivityOrderRank()));
                Long orderGmtIntervel = LocalDateUtil.getIntervalMinutes((String)cf.getCurrentGmtCreateTime(), (String)cf.getLastGmtCreateTime(), (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
                retMap.put("f605002", DataUtil.Long2String((Long)orderGmtIntervel));
                Long activityOrderGmtIntervel = LocalDateUtil.getIntervalMinutes((String)cf.getCurrentGmtCreateTime(), (String)cf.getActivityLastGmtCreateTime(), (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
                retMap.put("f606002", DataUtil.Long2String((Long)activityOrderGmtIntervel));
                retMap.put("f9925", JSON.toJSONString(cf.getCategory1idCntList()));
                retMap.put("f9926", JSON.toJSONString(cf.getCategory2idCntList()));
                Map<String, Map<String, Long>> ubpMap = FeatureParse.getUserBehavioralPreference(cf.getUIIds(), cf.getUILaunchPV(), cf.getUIClickPv(), cf.getUIEffectPv());
                retMap.put("f809001_a", JSON.toJSONString(ubpMap));
                retMap.put("f550101", JSON.toJSONString(cf.getAppTagInNewTrade()));
                retMap.put("f550102", JSON.toJSONString(cf.getAppTagInNewTrade()));
                retMap.put("f550301", JSON.toJSONString(cf.getAppInNewTrade()));
                retMap.put("f550302", JSON.toJSONString(cf.getAppInNewTrade()));
                DmpFeature dmpFeature = Optional.ofNullable(cf.getDmpFeature()).orElse(new DmpFeature());
                retMap.put("f9940", dmpFeature.getAppCategory());
                retMap.put("f9942", dmpFeature.getAppVector());
                retMap.put("f9805", dmpFeature.getMsgVector());
                retMap.put("f9816", dmpFeature.getmsgListEmbed8());
                retMap.put("f9817", dmpFeature.getAppListEmbed32());
                UserActFeature userActFeature = Optional.ofNullable(cf.getUserActFeature()).orElse(new UserActFeature());
                retMap.put("f410001", DataUtil.Integer2String((Integer)userActFeature.getUserActiveDays()));
                retMap.put("f411001", DataUtil.Integer2String((Integer)userActFeature.getActivityRequest()));
                retMap.put("f411002", DataUtil.Integer2String((Integer)userActFeature.getWeekActivityRequest()));
                retMap.put("f411003", DataUtil.Integer2String((Integer)userActFeature.getDayActivityRequest()));
                retMap.put("f411004", DataUtil.Integer2String((Integer)userActFeature.getIntervalActivityRequest()));
                retMap.put("f412001", DataUtil.Integer2String((Integer)userActFeature.getActivityJoin()));
                retMap.put("f412002", DataUtil.Integer2String((Integer)userActFeature.getWeekActivityJoin()));
                retMap.put("f412003", DataUtil.Integer2String((Integer)userActFeature.getDayActivityJoin()));
                retMap.put("f412004", DataUtil.Integer2String((Integer)userActFeature.getIntervalActivityJoin()));
                retMap.put("f412006", DataUtil.Integer2String((Integer)userActFeature.getActivityPageStay()));
                retMap.put("f413001", userActFeature.getLaunchTrade());
                retMap.put("f413002", userActFeature.getWeekLaunchTrade());
                retMap.put("f413003", JSON.toJSONString(userActFeature.getDayLaunchTrade()));
                retMap.put("f413004", JSON.toJSONString((Object)userActFeature.getIntervalLaunchTrade()));
                retMap.put("f413006", JSON.toJSONString((Object)userActFeature.getAvgLaunchStay()));
                retMap.put("f414001", userActFeature.getClickTrade());
                retMap.put("f414002", userActFeature.getWeekClickTrade());
                retMap.put("f414003", JSON.toJSONString(userActFeature.getDayClickTrade()));
                retMap.put("f414004", DataUtil.Integer2String((Integer)userActFeature.getIntervalClickTrade()));
                retMap.put("f415001", userActFeature.getEffectTrade());
                retMap.put("f415002", userActFeature.getWeekEffectTrade());
                retMap.put("f415003", JSON.toJSONString(userActFeature.getDayEffectTrade()));
                retMap.put("f415004", DataUtil.Integer2String((Integer)userActFeature.getIntervalEffectTrade()));
                SlotActFeature slotActFeature = Optional.ofNullable(cf.getSlotActFeature()).orElse(new SlotActFeature());
                retMap.put("f210001", slotActFeature.getLaunchCntRatioTrade());
                retMap.put("f210002", slotActFeature.getLaunchCntRatioAccount());
                retMap.put("f210003", slotActFeature.getWeekLaunchCntRatioTrade());
                retMap.put("f210004", slotActFeature.getWeekLaunchCntRatioAccount());
                JSONObject weekClickTradeCnt = DataUtil.stringToJson((String)slotActFeature.getWeekClickTradeCnt());
                JSONObject weekConversionTradeCnt = DataUtil.stringToJson((String)slotActFeature.getWeekConversionTradeCnt());
                retMap.put("f250301", JSON.toJSONString(OriginalFeature.getCategoryLevel(weekClickTradeCnt, weekConversionTradeCnt, FeatureParse.tradeCodes)));
                JSONObject weekClickAccountCnt = DataUtil.stringToJson((String)slotActFeature.getWeekClickAccountCnt());
                JSONObject weekConversionAccountCnt = DataUtil.stringToJson((String)slotActFeature.getWeekConversionAccountCnt());
                retMap.put("f250302", JSON.toJSONString(OriginalFeature.getCategoryLevel(weekClickAccountCnt, weekConversionAccountCnt, FeatureParse.accountCodes)));
                retMap.put("f211001", slotActFeature.getClickCntRatioTrade());
                retMap.put("f211002", slotActFeature.getClickCntRatioAccount());
                retMap.put("f211003", slotActFeature.getWeekClickCntRatioTrade());
                retMap.put("f211004", slotActFeature.getWeekClickCntRatioAccount());
                retMap.put("f212001", slotActFeature.getCtrTrade());
                retMap.put("f212002", slotActFeature.getCtrAccount());
                retMap.put("f212003", slotActFeature.getWeekCtrTrade());
                retMap.put("f212004", slotActFeature.getWeekCtrAccount());
                retMap.put("f213001", slotActFeature.getConvertCntRatioTrade());
                retMap.put("f213002", slotActFeature.getConvertCntRatioAccount());
                retMap.put("f213003", slotActFeature.getWeekConvertCntRatioTrade());
                retMap.put("f213004", slotActFeature.getWeekConvertCntRatioAccount());
                retMap.put("f214001", slotActFeature.getCvrTrade());
                retMap.put("f214002", slotActFeature.getCvrAccount());
                retMap.put("f214003", slotActFeature.getWeekCvrTrade());
                retMap.put("f214004", slotActFeature.getWeekCvrAccount());
                retMap.put("f680001", DataUtil.Long2String((Long)cf.getRequestCnt()));
                retMap.put("f680002", DataUtil.Long2String((Long)cf.getExposureCnt()));
                retMap.put("f680003", DataUtil.Long2String((Long)cf.getClickCnt()));
            }
        }
        catch (Exception e) {
            logger.error("OriginalFeature.generateFeatureMapStatic error:" + e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                LoadingPageFeature loadingPageFeature = Optional.ofNullable(cf.getLoadingPageFeature()).orElse(new LoadingPageFeature());
                retMap.put("f670002", DataUtil.double2String((Double)loadingPageFeature.getLoadingPageHistCvr()));
                retMap.put("f670003", loadingPageFeature.getLoadingPageTagsHistCvr());
                retMap.put("f804001", DataUtil.double2String((Double)cf.getAdvertCtr()));
                retMap.put("f804002", DataUtil.double2String((Double)cf.getAdvertCvr()));
                retMap.put("f805001", DataUtil.double2String((Double)cf.getAdvertAppCtr()));
                retMap.put("f805002", DataUtil.double2String((Double)cf.getAdvertAppCvr()));
                retMap.put("f806001", DataUtil.double2String((Double)cf.getAdvertSlotCtr()));
                retMap.put("f806002", DataUtil.double2String((Double)cf.getAdvertSlotCvr()));
                retMap.put("f807001", DataUtil.double2String((Double)cf.getAdvertActivityCtr()));
                retMap.put("f807002", DataUtil.double2String((Double)cf.getAdvertActivityCvr()));
                retMap.put("f804003", DataUtil.double2String((Double)cf.getAdvertCtr()));
                retMap.put("f804004", DataUtil.double2String((Double)cf.getAdvertCvr()));
                retMap.put("f805003", DataUtil.double2String((Double)cf.getAdvertAppCtr()));
                retMap.put("f805004", DataUtil.double2String((Double)cf.getAdvertAppCvr()));
                retMap.put("f806003", DataUtil.double2String((Double)cf.getAdvertSlotCtr()));
                retMap.put("f806004", DataUtil.double2String((Double)cf.getAdvertSlotCvr()));
                retMap.put("f807003", DataUtil.double2String((Double)cf.getAdvertActivityCtr()));
                retMap.put("f807004", DataUtil.double2String((Double)cf.getAdvertActivityCvr()));
                retMap.put("f812001", DataUtil.double2String((Double)cf.getAppTradeWeekCvr()));
                retMap.put("f812002", DataUtil.double2String((Double)cf.getAppTradeDayCvr()));
                retMap.put("f812003", DataUtil.double2String((Double)cf.getAppTagpidTradeWeekCvr()));
                retMap.put("f812004", DataUtil.double2String((Double)cf.getAppTagpidTradeDayCvr()));
                retMap.put("f812005", DataUtil.double2String((Double)cf.getAppTagidTradeWeekCvr()));
                retMap.put("f812006", DataUtil.double2String((Double)cf.getAppTagidTradeDayCvr()));
                retMap.put("f812007", DataUtil.double2String((Double)cf.getMaterialTradeWeekCvr()));
                retMap.put("f812008", DataUtil.double2String((Double)cf.getMaterialTradeDayCvr()));
                retMap.put("f812009", DataUtil.double2String((Double)cf.getAcctivityTradeWeekCvr()));
                retMap.put("f812010", DataUtil.double2String((Double)cf.getAcctivityTradeDayCvr()));
                Long dayResourceOrderRank = OriginalFeature.getResourceOrderRank(cf.getOperatingResource(), staticCf.getDayResourceOrderRank());
                retMap.put("f770102", DataUtil.Long2String((Long)dayResourceOrderRank));
                Long resourceOrderGmtIntervelLevel = OriginalFeature.getResourceOrderGmtIntervelLevel(cf.getOperatingResource(), staticCf.getCurrentGmtCreateTime(), staticCf.getResourceLastGmtCreateTime());
                retMap.put("f770202", DataUtil.Long2String((Long)resourceOrderGmtIntervelLevel));
                Long dayResourceChargeCnt = OriginalFeature.getResourceChargeCnt(cf.getOperatingResource(), staticCf.getDayResourceChargeCnt());
                retMap.put("f770401", DataUtil.Long2String((Long)dayResourceChargeCnt));
                Long dayResourceConvertCnt = OriginalFeature.getResourceConvertCnt(cf.getOperatingResource(), staticCf.getDayResourceConvertCnt());
                retMap.put("f770402", DataUtil.Long2String((Long)dayResourceConvertCnt));
                retMap.put("f660003", DataUtil.double2String((Double)cf.getNewTradeHistCtr()));
                retMap.put("f660004", DataUtil.double2String((Double)cf.getNewTradeHistCvr()));
                Long newTradeDayOrderRankLevel = OriginalFeature.getNewTradeOrderRank(cf.getOperatingNewTrade(), cf.getNewTradeDayOrderRank());
                retMap.put("f660102", DataUtil.Long2String((Long)newTradeDayOrderRankLevel));
                Long lastNewTradeGmtIntervelLevel = OriginalFeature.getLastNewTradeGmtIntervelLevel(cf.getOperatingNewTrade(), staticCf.getCurrentGmtCreateTime(), cf.getNewTradeLastGmtCreateTime());
                retMap.put("f660302", DataUtil.Long2String((Long)lastNewTradeGmtIntervelLevel));
                retMap.put("f550201_a", JSON.toJSONString(cf.getNewTradeInAppTag()));
                retMap.put("f550401_a", JSON.toJSONString(cf.getAdvertInAppTag()));
                ItemProfileFeature itemProfileFeature = Optional.ofNullable(cf.getItemProfileFeature()).orElse(new ItemProfileFeature());
                retMap.put("f141013", itemProfileFeature.getOriginalPrice() == null ? null : DataUtil.Long2String((Long)itemProfileFeature.getOriginalPrice().longValue()));
                retMap.put("f141014", itemProfileFeature.getDealPrice() == null ? null : DataUtil.Long2String((Long)itemProfileFeature.getDealPrice().longValue()));
                retMap.put("f141015", itemProfileFeature.getNumber());
                retMap.put("f141016", DataUtil.Integer2String((Integer)itemProfileFeature.getDeliveryDays()));
                retMap.put("f141018", DataUtil.Long2String((Long)itemProfileFeature.getDaysOnSale()));
                retMap.put("f142003", itemProfileFeature.getMaterialPictureRGB());
                retMap.put("f142004", itemProfileFeature.getLayerPictureRGB());
                retMap.put("f142005", itemProfileFeature.getPictureRGB());
                retMap.put("f143001", DataUtil.Long2String((Long)itemProfileFeature.getClickCnt()));
                retMap.put("f143002", DataUtil.Long2String((Long)itemProfileFeature.getWeekClickCnt()));
                retMap.put("f143003", DataUtil.Long2String((Long)itemProfileFeature.getDayClickCnt()));
                retMap.put("f143004", DataUtil.Long2String((Long)itemProfileFeature.getEffectCnt()));
                retMap.put("f143005", DataUtil.Long2String((Long)itemProfileFeature.getWeekEffectCnt()));
                retMap.put("f143006", DataUtil.Long2String((Long)itemProfileFeature.getDayEffectCnt()));
                retMap.put("f143007", DataUtil.Long2String((Long)itemProfileFeature.getIssueEffectCnt()));
                retMap.put("f143008", DataUtil.Long2String((Long)itemProfileFeature.getWeekIssueEffectCnt()));
                retMap.put("f143009", DataUtil.Long2String((Long)itemProfileFeature.getSignEffectCnt()));
                retMap.put("f143010", DataUtil.Long2String((Long)itemProfileFeature.getWeekSignEffectCnt()));
                retMap.put("f144001", DataUtil.double2String((Double)itemProfileFeature.getCtr()));
                retMap.put("f144002", DataUtil.double2String((Double)itemProfileFeature.getWeekCtr()));
                retMap.put("f144003", DataUtil.double2String((Double)itemProfileFeature.getDayCtr()));
                retMap.put("f144004", DataUtil.double2String((Double)itemProfileFeature.getCvr()));
                retMap.put("f144005", DataUtil.double2String((Double)itemProfileFeature.getWeekCvr()));
                retMap.put("f144006", DataUtil.double2String((Double)itemProfileFeature.getDayCvr()));
                retMap.put("f144007", DataUtil.double2String((Double)itemProfileFeature.getIecvr()));
                retMap.put("f144008", DataUtil.double2String((Double)itemProfileFeature.getWeekIecvr()));
                retMap.put("f144009", DataUtil.double2String((Double)itemProfileFeature.getSecvr()));
                retMap.put("f144010", DataUtil.double2String((Double)itemProfileFeature.getWeekSecvr()));
            }
        }
        catch (Exception e) {
            logger.error("OriginalFeature.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static Map<Integer, Double> getCategoryLevel(JSONObject actMap1, JSONObject actMap2, Map<String, Integer> category) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap1, actMap2, category})) {
            return null;
        }
        HashMap<Integer, Double> resMap = new HashMap<Integer, Double>();
        try {
            for (String cateKey : actMap1.keySet()) {
                double cateValue1 = Long.parseLong(actMap1.getOrDefault((Object)cateKey, (Object)0).toString());
                if (cateValue1 == 0.0) continue;
                double cateValue2 = Long.parseLong(actMap2.getOrDefault((Object)cateKey, (Object)0).toString());
                if (!category.containsKey(cateKey) || !(cateValue2 > 5.0)) continue;
                Integer i = category.get(cateKey);
                resMap.put(i, cateValue2 / cateValue1);
            }
        }
        catch (Exception e) {
            logger.warn("getCategoryLevel failed=" + actMap2);
            return null;
        }
        return resMap;
    }

    public static Long getResourceOrderRank(String operatingResource, Map<String, Long> dayResourceOrderRank) {
        Long ret = null;
        ret = operatingResource == null || dayResourceOrderRank == null ? null : dayResourceOrderRank.get(operatingResource + "-770101");
        return ret;
    }

    public static Long getResourceOrderGmtIntervelLevel(String operatingResource, String currentGmtCreateTime, Map<String, String> resourceLastGmtCreateTime) {
        Long ret = null;
        if (operatingResource == null || currentGmtCreateTime == null || resourceLastGmtCreateTime == null) {
            ret = null;
        } else {
            String lastGmtCreateTime = resourceLastGmtCreateTime.get(operatingResource + "-770201");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long seconds;
                Long timeStamp = LocalDateUtil.getTimeMillis((String)currentGmtCreateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);
                if (timeStamp == null || otherTimeStamp == null) {
                    return ret;
                }
                ret = seconds = Long.valueOf(Math.abs((timeStamp - otherTimeStamp) / 1000L));
            }
        }
        return ret;
    }

    public static Long getResourceChargeCnt(String operatingResource, Map<String, Long> dayResourceChargeCnt) {
        Long cnt;
        Long ret = null;
        ret = operatingResource == null || dayResourceChargeCnt == null ? null : (cnt = dayResourceChargeCnt.get(operatingResource + "-770401"));
        return ret;
    }

    public static Long getResourceConvertCnt(String operatingResource, Map<String, Long> dayResourceConvertCnt) {
        Long cnt;
        Long ret = null;
        ret = operatingResource == null || dayResourceConvertCnt == null ? null : (cnt = dayResourceConvertCnt.get(operatingResource + "-770402"));
        return ret;
    }

    public static Long getNewTradeOrderRank(String operatingNewTrade, Map<String, Long> newTradeDayOrderRank) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, newTradeDayOrderRank})) {
            Long rank;
            ret = rank = newTradeDayOrderRank.get(operatingNewTrade + "-660101");
        }
        return ret;
    }

    public static Long getLastNewTradeGmtIntervelLevel(String operatingNewTrade, String currentGmtCreateTime, Map<String, String> newTradeLastGmtCreateTime) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, currentGmtCreateTime, newTradeLastGmtCreateTime})) {
            String lastGmtCreateTime = newTradeLastGmtCreateTime.get(operatingNewTrade + "-660301");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long seconds;
                Long timeStamp = LocalDateUtil.getTimeMillis((String)currentGmtCreateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);
                if (AssertUtil.isAnyEmpty((Object[])new Object[]{timeStamp, otherTimeStamp})) {
                    return ret;
                }
                ret = seconds = Long.valueOf(Math.abs((timeStamp - otherTimeStamp) / 1000L));
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "1");
        map.put("2", "2");
        map.put("3", "3");
        System.out.println(map);
        String remove = (String)map.remove("4");
        System.out.println(remove);
        System.out.println(map);
    }
}

