package cn.com.duiba.nezha.alg.feature.coder;


import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.CoderFeature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.util.*;

public class FeatureNewCoder extends FeatureCoderBase {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureNewCoder.class);
    private static int F_MAX_SIZE = 128;

    public static Map tmpMap = new HashMap();


    public static <T> Map<T, CodeResult> code(List<FeatureBaseType> list, Map<T, FeatureMapDo> sampleMap) throws Exception {
        Map<T, CodeResult> ret = new HashMap<>();

        Map<String, Map<String, CoderFeature>> tmpCoderCache = new HashMap<>();
        if (AssertUtil.isNotEmpty(sampleMap)) {

            for (Map.Entry<T, FeatureMapDo> entry : sampleMap.entrySet()) {

                T key = entry.getKey();
                FeatureMapDo featureMapDo = entry.getValue();

                if (featureMapDo != null) {
                    CodeResult subRet = code(list, featureMapDo.getStaticFeatureMap(), featureMapDo.getDynamicFeatureMap(), tmpCoderCache);

                    if (subRet != null) {
                        ret.put(key, subRet);
//                        System.out.println("key=" + key +"，"+ JSON.toJSONString(subRet));
                    }
                }
            }
        }

        return ret;
    }


    public static <T> Map<T, CodeResult> codeOfEachField(List<FeatureBaseType> list, Map<T, FeatureMapDo> sampleMap) throws Exception {

        Map<T, CodeResult> ret = new HashMap<>();

        Map<String, Map<String, Set<Integer>>> tmpCoderCache = new HashMap<>();
        if (AssertUtil.isNotEmpty(sampleMap)) {

            for (Map.Entry<T, FeatureMapDo> entry : sampleMap.entrySet()) {

                T key = entry.getKey();
                FeatureMapDo featureMapDo = entry.getValue();

                if (featureMapDo != null) {
                    CodeResult subRet = codeOfEachField(list, featureMapDo.getStaticFeatureMap(), featureMapDo.getDynamicFeatureMap(), tmpCoderCache);

                    if (subRet != null) {
                        ret.put(key, subRet);

//                        System.out.println("key=" + key +"，"+ JSON.toJSONString(subRet));
                    }
                }
            }
        }

        return ret;

    }

//    public static <T> Map<T, Map<String, List<Integer>>> codeOfEachFieldWithSeq(List<FeatureBaseType> list, Map<T, FeatureMapDo> sampleMap) throws Exception {
//
//        Map<T, Map<String, List<Integer>>> ret = new HashMap<>();
//
//        Map<String, Map<String, List<Integer>>> tmpCoderCache = new HashMap<>();
//        if (AssertUtil.isNotEmpty(sampleMap)) {
//
//            for (Map.Entry<T, FeatureMapDo> entry : sampleMap.entrySet()) {
//
//                T key = entry.getKey();
//                FeatureMapDo featureMapDo = entry.getValue();
//
//                if (featureMapDo != null) {
//                    Map<String, List<Integer>> subRet = codeOfEachFieldWithSeq(list, featureMapDo.getStaticFeatureMap(), featureMapDo.getDynamicFeatureMap(), tmpCoderCache);
//
//                    if (subRet != null) {
//                        ret.put(key, subRet);
////                        System.out.println("key=" + key +"，"+ JSON.toJSONString(subRet));
//                    }
//                }
//            }
//        }
//
//        return ret;
//
//    }

    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap, Map<String, Map<String, CoderFeature>> tmpCoderCache) throws Exception {

        CodeResult codeResult = new CodeResult();

        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }
        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }

        List<Integer> indices = new ArrayList<>(F_MAX_SIZE);//field起始+field内编码
        List<Double> values = new ArrayList<>(F_MAX_SIZE);
        List<String> fields = new ArrayList<>(F_MAX_SIZE);
        List<Set<Integer>> ret = new ArrayList<>(F_MAX_SIZE);

        int startIndex = 0;
        for (int i = 0; i < list.size(); i++) {

            FeatureBaseType featureBaseType = list.get(i);

            String fieldName = featureBaseType.getName();

            String fieldValue = dynamicFeatureMap.get(fieldName) == null ? staticFeatureMap.get(fieldName) : dynamicFeatureMap.get(fieldName);


            if (tmpCoderCache.get(fieldName) == null) {
                tmpCoderCache.put(fieldName, new HashMap<>());
            }
            if (tmpCoderCache.get(fieldName).get(fieldValue) == null) {
                CoderFeature retTmp = featureBaseType.codeNew(fieldValue, startIndex);
                tmpCoderCache.get(fieldName).put(fieldValue, retTmp);
//              System.out.println("cache.add fieldName="+fieldName+",fieldValue="+fieldValue+","+JSON.toJSONString(retSub));
            }

            CoderFeature retSub = tmpCoderCache.get(fieldName).get(fieldValue);

//            System.out.println("fieldName="+fieldName+",fieldValue="+fieldValue+","+JSON.toJSONString(retSub));

            indices.addAll(retSub.indices);
            values.addAll(retSub.values);
            fields.addAll(retSub.fields);
            ret.add(retSub.fieldsSet);
            startIndex = retSub.getEndIndex();
        }

        codeResult.setFeature(FeatureCoderBase.toFeatureNew(startIndex, indices, values, fields));
        codeResult.setFeatureSet(ret);
        return codeResult;
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap, Map<String, Map<String, Set<Integer>>> tmpCoderCache) throws Exception {

        CodeResult codeResult = new CodeResult();

        List<Integer> indices = new ArrayList<>(F_MAX_SIZE);
        List<Double> values = new ArrayList<>(F_MAX_SIZE);
        List<String> fields = new ArrayList<>(F_MAX_SIZE);
        List<Set<Integer>> ret = new ArrayList<>(F_MAX_SIZE);

        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }
        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }

        Map<String, Map<Integer, Double>> fieldFeatureMap = new HashMap<>();

        for (FeatureBaseType featureBaseType : list) {

            String fieldName = featureBaseType.getName();

            String value = dynamicFeatureMap.get(fieldName) == null ? staticFeatureMap.get(fieldName) : dynamicFeatureMap.get(fieldName);


            if (tmpCoderCache.get(fieldName) == null) {
                tmpCoderCache.put(fieldName, new HashMap<>());
            }
            if (tmpCoderCache.get(fieldName).get(value) == null) {
                Set<Integer> retTmp = featureBaseType.code(value);
//                System.out.println("set="+JSON.toJSONString(retTmp));
                tmpCoderCache.get(fieldName).put(value, retTmp);
            }

            Set<Integer> retSub = tmpCoderCache.get(fieldName).get(value);

            ret.add(retSub);
            List<Integer> retSubList = new ArrayList<>(retSub);

            Map<Integer, Double> subFieldFeatureMap = new HashMap<>();

            double weight = MathUtil.reciprocalOfN(retSub.size());
            for (int i = 0; i < retSub.size(); i++) {

                indices.add(retSubList.get(i));

                values.add(weight);
                fields.add(featureBaseType.getName());

                subFieldFeatureMap.put(retSubList.get(i), weight);
            }
            fieldFeatureMap.put(featureBaseType.getName(), subFieldFeatureMap);
        }
        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, fields, 10000 * 1000));
        codeResult.setFeatureSet(ret);
        codeResult.setFieldFeatureMap(fieldFeatureMap);
        return codeResult;
    }



//
//    public static Map<String, List<Integer>> codeOfEachFieldWithSeqForOne(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, Map<String, List<Integer>>> tmpCoderCache) throws Exception {
//        Map<String, List<Integer>> ret = new HashMap<>(F_MAX_SIZE);
//
//        if (staticFeatureMap == null) {
//            staticFeatureMap = tmpMap;
//        }
//
//
//        for (FeatureBaseType featureBaseType : list) {
//
//            String fieldName = featureBaseType.getName();
//
//            String value = staticFeatureMap.get(fieldName);
//
//            if (tmpCoderCache.get(fieldName) == null) {
//                tmpCoderCache.put(fieldName, new HashMap<>());
//            }
//            if (tmpCoderCache.get(fieldName).get(value) == null) {
//                List<Integer> retTmp = featureBaseType.codeWithSeq(value);
//                tmpCoderCache.get(fieldName).put(value, retTmp);
//            }
//            List<Integer> retSub = tmpCoderCache.get(fieldName).get(value);
//            ret.put(fieldName, retSub);
//
//        }
//
//        return ret;
//    }

//    public static Map<String, List<Integer>> codeOfEachFieldWithSeqForOne(List<FeatureBaseType> list, Map<String, String> staticFeatureMap) throws Exception {
//        Map<String, List<Integer>> ret = new HashMap<>(F_MAX_SIZE);
//
//        if (staticFeatureMap == null) {
//            staticFeatureMap = tmpMap;
//        }
//
//
//        for (FeatureBaseType featureBaseType : list) {
//
//            String fieldName = featureBaseType.getName();
//
//            String value = staticFeatureMap.get(fieldName);
//
//            List<Integer> retTmp = featureBaseType.codeWithSeq(value);
//            ret.put(fieldName, retTmp);
//
//        }
//
//        return ret;
//    }

    public static Map<String, Set<String>> getFeatures(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        Map<String, Set<String>> ret = new HashMap<>();

        for (FeatureBaseType featureBaseType : list) {

            String value = featureMap.get(featureBaseType.getName());

            Set<String> retSub = featureBaseType.parseFeatureValues(value);

            ret.put(featureBaseType.getName(), retSub);
        }
        return ret;
    }

    public static void main(String[] args) {
        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f101001", "16601,18491,23105,24732,7967,300");
        featureMap.put("f101002", "100");
        featureMap.put("f305001", "8");
        featureMap.put("f501001", "UNKONWN");
        featureMap.put(null, "2");


        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f101001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");

        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(21);
        featureBaseType2.setName("f101002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(100000);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");


        List<FeatureBaseType> list = Arrays.asList(featureBaseType1, featureBaseType2);

        System.out.println(JSON.toJSONString(featureMap));

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        Map<String, FeatureMapDo> featureMapDoMap = new HashMap<>();

        featureMapDoMap.put("000", featureMapDo);
        try {

            System.out.println(JSON.toJSONString(FeatureNewCoder.codeOfEachField(list, featureMapDoMap)));
//
//            System.out.println(JSON.toJSONString(FeatureNewCoder.codeOfEachFieldWithSeq(list, featureMapDoMap)));
//
//            System.out.println(JSON.toJSONString(FeatureNewCoder.codeOfEachFieldWithSeqForOne(list, featureMap)));

        } catch (Exception e) {

        }


    }

}
