package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.vo.RtaFeatureDo;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by pzx on 2022/1/13.
 */
public class RtaFeatureParse {
    public static final int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(RtaFeatureParse.class);

    public static Map<String, String> generateFeatureMapStatic(RtaFeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                // DMP特征
                retMap.put("f00001", cf.getGender()); // 性别
                retMap.put("f00002", cf.getAge()); // 年龄
                retMap.put("f00003", cf.getMarital()); // 婚育情况
                retMap.put("f00004", cf.getIsp()); // 运营商（联通/移动/电信等）

                // 实时用户统计特征
                retMap.put("f00005", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv()))); // 用户当天入口曝光次数
                retMap.put("f00006", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv()))); // 用户当天活动访问次数
                retMap.put("f00007", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv()))); // 用户当天发券次数
                retMap.put("f00008", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv()))); // 用户当天券计费点击次数

                // 用户历史统计特征
                retMap.put("f00009", DataUtil.Long2String(MathUtil.log1p(cf.getUserReqPv1d())));        // 用户历史1天请求次数
                retMap.put("f00010", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv1d())));        // 用户历史1天入口曝光次数
                retMap.put("f00011", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv1d())));     // 用户历史1天活动访问次数
                retMap.put("f00012", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv1d())));  // 用户历史1天发券次数
                retMap.put("f00013", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv1d())));     // 用户历史1天券计费点击次数
                retMap.put("f00014", DataUtil.Long2String(MathUtil.log1p(cf.getUserReqPv7d())));        // 用户历史7天请求次数
                retMap.put("f00015", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv7d())));        // 用户历史7天入口曝光次数
                retMap.put("f00016", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv7d())));     // 用户历史7天活动访问次数
                retMap.put("f00017", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv7d())));  // 用户历史7天发券次数
                retMap.put("f00018", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv7d())));     // 用户历史7天券计费点击次数
                retMap.put("f00019", DataUtil.Long2String(MathUtil.log1p(cf.getUserReqPv14d())));       // 用户历史14天请求次数
                retMap.put("f00020", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv14d())));       // 用户历史14天入口曝光次数
                retMap.put("f00021", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv14d())));    // 用户历史14天活动访问次数
                retMap.put("f00022", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv14d()))); // 用户历史14天发券次数
                retMap.put("f00023", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv14d())));    // 用户历史14天券计费点击次数

                // 用户历史序列特征(截断到20个）
                retMap.put("f00024", DataUtil.listToString(cf.getUser_exp_list()));              // 用户历史创意id曝光列表
                retMap.put("f00025", DataUtil.listToString(cf.getUser_clk_list()));              // 用户历史创意id点击列表
                retMap.put("f00026", DataUtil.listToString(cf.getUser_act_req_list()));          // 用户历史活动id访问列表
                retMap.put("f00027", DataUtil.listToString(cf.getUser_act_join_list()));         // 用户历史活动id参与列表
                retMap.put("f00028", DataUtil.listToString(cf.getUser_adv_launch_list()));       // 用户历史券id曝光列表
                retMap.put("f00029", DataUtil.listToString(cf.getUser_adv_clk_list()));          // 用户历史券id计费点击列表
                retMap.put("f00030", DataUtil.listToString(cf.getUser_adv_launch_trade_list())); // 用户历史券行业id曝光列表
                retMap.put("f00031", DataUtil.listToString(cf.getUser_adv_clk_trade_list()));    // 用户历史券行业id计费点击列表


            }
        } catch (Exception e) {
            logger.error("RtaFeatureParse.generateFeatureMapStatic error:", e);

        }
        return retMap;
    }
}