package cn.com.duiba.nezha.alg.feature.vo.v2;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * Created by pc on 2019/2/21.
 */

/**
 * 上下文特征对象
 * 场景链路
 * 1、广告位素材推荐/RTB竞价
 * 2、活动推荐
 * 3、券推荐
 *
 */
@Data
public class ContextFeatureDoV2 implements Serializable {
    private static final long serialVersionUID = 6695201251295150673L;


    /**
     * 流量标识
     */

    private Long activityId;//ID  活动场景无该字段


    private Long activityPage;//ID  主活动ID


    /**
     * 分流标识
     */

    private Integer rcmdType;// 1算法，0人工
    private String abTestId;//分流ID,实验版本号

    /**
     * 一、使用场景：全链路
     */
    private Long appId; //媒体ID

    private Integer appType; //媒体类型：0-非程序化媒体，1-程序化媒体

    private Long slotId;  //广告位ID

    private Long slotSceneType;// 广告位类型（开屏/信息流/banner/icon等）

    private Long areaCode; // 地域，城市编码

    private String ip; // ip

    private String ipUsageType; // ip场景，家庭、机房、公用，企业等

    private String ua; // userAgent

    private String uaAppPackage; // 媒体包 示例 com.little.xxx
    private String uaAppPackageTrade1; // 媒体包行业类目，大类，网赚、计步等

    private String uaAppPackageTrade2; // 媒体包行业类目，小类，网赚、计步等

    private String phoneOs; // 操作系统

    private String osVersion; // 操作系统版本


    private String brandNameEn; // 设备品牌 英文名
    private String phoneModelCode; // 设备型号
    private String phonePriceLevel; // 设备价格区间


    private String operatorType; // 运营商（中国联通，中国移动，中国电信）
    private String connectionType; // 网络类型（2G，3G，4G）

    private String firstShowTime;//首发年份

    private String appIndustryTagPid; //媒体行业一级标签
    private String appIndustryTagId; //媒体行业二级标签


    /**
     * 二、使用场景：广告位素材推荐/RTB出价、活动推荐、券推荐
     */
    private Long groupId; //ADX流量，推广组
    private Long resourceId; //ADX流量，资源位


    /**
     * 开户
     */
    private String openAccountId; //快手-媒体开户账号id
    private String extUnionSlotId; //快手-联盟广告位id
    private String extAdvertGroupId; //快手-外部广告组id
    private String extIdeaId; //快手-外部创意id

    private String extMaterialTitle; //广告语 ，22.09.21
    private String extMaterialId; //外部素材ID，22.09.21
    private String extMaterialType; //外部素材类型 :横版图片、竖版图片、横版视频、竖版视频 ，09.21

    /**
     * ADX
     */
    private String extAppTrade;//联盟媒体行业id
    private String externalAdBlockId;//联盟流量广告位ID
    private String externalAdBlockTypeId;//外部广告位类型ID 区分 开屏 信息流等


    /**
     * 三、使用场景：活动推荐、券推荐
     */
    private Long slotMaterialId; //广告位曝光 素材ID
    private String materialTag; //广告位入口素材标签，红包、手机等，新增
    private Long dsm2A; //活动类型，是否返回拦截类型

    /**
     * 四、使用场景：券推荐
     */

//    private Long activityId; //活动IDf.请求 f301000-f301001
//    private Long activityPage; //自定义活动ID f.请求 新增，待编码 311001
//
//
//    private String activitySkinType; //活动皮肤类型，转盘、砸金蛋等
//    private String activitySourceType;//活动[进入当前券]的访问类型[广告位、浮标、返回拦截、弹层、区块]
//    private Long activityJoinTimes; //当前活动参与次数

//    /**
//     * 活动标签
//     *
//     * 是否有其他活动标签体系？需要更新迭代
//     */
//    private String actTradeTag; //1、行业标签；适配媒体行业，生活服务、工具、网赚、计步等；格式：1,3
//
//    private String actCrowdTag; //2、人群标签；女性、男性等；格式：1,3
//
//    private String actPrizeTag; //3、奖品标签；渔具周边、养生周边等；格式：1,3
//
//    private String actStyleTag; //4、设计风格标签；扁平、电商、卡通等；格式：1,3
//
//    private String actSeasonTag; //5、季节标签；春、夏、秋、冬；格式：1,3
//
//    private String actFestivalTag; //6、节日标签；双十一、双十二、春节等；格式：1,3
//
//    private String actInduceTag; //7、诱导标签；手机、红包、话费、盲盒等；格式：1,3【新增，系统暂无】
//

    /**
     * 广告语利益标签映射
     * 映射：939-红包，941-话费，942-手机
     *
     * @param str
     * @return
     */
    public static String formatInterestTag(String str) {
        if (StringUtils.isBlank(str)) {
            return null;
        }

        if (str.contains("红包") || str.contains("现金")) {
            return "939";

        } else if (str.contains("话费")) {
            return "941";

        } else if (str.contains("手机") || str.contains("苹果") || str.contains("华为") ||str.contains("小米") || str.contains("iPhone")) {
            return "942";
        }
        return null;
    }

}
