/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse.v2;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.ActFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserBehaviorSubFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserProfileSubFeature;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActFeatureParseV2
extends BaseParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(ActFeatureParseV2.class);

    public static Map<String, String> generateFeatureMapStatic(ContextFeatureDoV2 contextFeatureDoV2, UserFeatureDoV2 userFeatureDoV2) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        Map<String, String> contextFeature = ActFeatureParseV2.parseContextFeature(contextFeatureDoV2);
        retMap.putAll(contextFeature);
        Map<String, String> userFeature = ActFeatureParseV2.parseUserFeature(userFeatureDoV2);
        retMap.putAll(userFeature);
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(ActFeatureDoV2 data, UserFeatureDoV2 data2, ContextFeatureDoV2 data3) {
        HashMap<String, String> retMap = new HashMap(F_MAX_SIZE);
        retMap = ActFeatureParseV2.parseActFeature(data, data2, data3);
        return retMap;
    }

    public static Map<String, String> parseActFeature(ActFeatureDoV2 data, UserFeatureDoV2 data2, ContextFeatureDoV2 data3) {
        String hisLastActivity;
        HashMap<String, String> retMap = new HashMap<String, String>(16);
        ActFeatureParseV2.putMapNotNull(retMap, "ft300301", data.getActivityId());
        if (data.getActivityPage() != null) {
            ActFeatureParseV2.putMapNotNull(retMap, "ft300304", data.getActivityPage());
        }
        ActFeatureParseV2.putMapNotNull(retMap, "ft300305", data.getActivitySkinType());
        ActFeatureParseV2.putMapNotNull(retMap, "ft300309", data.getActivitySkinType2());
        ActFeatureParseV2.putMapNotNull(retMap, "ft300311", data.getActTradeTag());
        ActFeatureParseV2.putMapNotNull(retMap, "ft300312", data.getActCrowdTag());
        ActFeatureParseV2.putMapNotNull(retMap, "ft300313", data.getActInteresteTag());
        ActFeatureParseV2.putMapNotNull(retMap, "ft300314", data.getActStyleTag());
        ActFeatureParseV2.putMapNotNull(retMap, "ft300315", data.getActSeasonTag());
        ActFeatureParseV2.putMapNotNull(retMap, "ft300316", data.getActFestivalTag());
        ActFeatureParseV2.putMapNotNull(retMap, "ft300317", ActFeatureDoV2.interestTagValid(data.getActInteresteTag(), data3.getExtMaterialTitle()));
        UserBehaviorSubFeature userBehaviorSubFeature = Optional.ofNullable(data2.getUserActSubFeature()).orElse(new UserBehaviorSubFeature());
        List<String> userActReqList = userBehaviorSubFeature.getUserActReqList();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{data.getActivityId(), userActReqList}) && (hisLastActivity = userActReqList.get(userActReqList.size() - 1)) != null) {
            Long hisLastActivityLong = Long.valueOf(hisLastActivity);
            if (data.getActivityId().equals(hisLastActivityLong)) {
                retMap.put("ft110910", "1");
            }
        }
        return retMap;
    }

    public static Map<String, String> parseContextFeature(ContextFeatureDoV2 data) {
        HashMap<String, String> retMap = new HashMap<String, String>(64);
        if (data != null) {
            ActFeatureParseV2.putMapNotNull(retMap, "ft300101", data.getAppId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft300201", DataUtil.Long2String((Long)data.getSlotId()));
            ActFeatureParseV2.putMapNotNull(retMap, "ft300202", data.getSlotSceneType());
            String areaCode = DataUtil.Long2String((Long)data.getAreaCode());
            String provinceId = RegionConf.getProvince(areaCode);
            String regionId = RegionConf.getRegion(provinceId);
            String cityTier = RegionConf.getCityTier(areaCode);
            ActFeatureParseV2.putMapNotNull(retMap, "ft300901", regionId);
            ActFeatureParseV2.putMapNotNull(retMap, "ft300902", provinceId);
            ActFeatureParseV2.putMapNotNull(retMap, "ft300903", areaCode);
            ActFeatureParseV2.putMapNotNull(retMap, "ft300904", cityTier);
            ActFeatureParseV2.putMapNotNull(retMap, "ft100210", data.getIp());
            ActFeatureParseV2.putMapNotNull(retMap, "ft100209", data.getIpUsageType());
            ActFeatureParseV2.putMapNotNull(retMap, "ft100211", data.getUa());
            ActFeatureParseV2.putMapNotNull(retMap, "ft300104", data.getAppIndustryTagPid());
            ActFeatureParseV2.putMapNotNull(retMap, "ft300105", data.getAppIndustryTagId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft300109", data.getUaAppPackage());
            ActFeatureParseV2.putMapNotNull(retMap, "ft300110", data.getUaAppPackageTrade1());
            ActFeatureParseV2.putMapNotNull(retMap, "ft300111", data.getUaAppPackageTrade2());
            ActFeatureParseV2.putMapNotNull(retMap, "ft100208", data.getPhoneOs());
            ActFeatureParseV2.putMapNotNull(retMap, "ft100203", data.getOsVersion());
            ActFeatureParseV2.putMapNotNull(retMap, "ft100205", data.getBrandNameEn());
            ActFeatureParseV2.putMapNotNull(retMap, "ft100204", UserProfileFeature.formatPhoneModelCode(data.getPhoneModelCode()));
            ActFeatureParseV2.putMapNotNull(retMap, "ft100206", data.getPhonePriceLevel());
            ActFeatureParseV2.putMapNotNull(retMap, "ft100202", data.getOperatorType());
            ActFeatureParseV2.putMapNotNull(retMap, "ft100201", data.getConnectionType());
            ActFeatureParseV2.putMapNotNull(retMap, "ft100207", data.getFirstShowTime());
            ActFeatureParseV2.putMapNotNull(retMap, "ft600304", data.getGroupId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft600305", data.getResourceId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft600201", data.getOpenAccountId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft6002021", data.getExtUnionSlotId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft6002031", data.getExtAdvertGroupId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft6002041", data.getExtIdeaId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft600206", ContextFeatureDoV2.formatInterestTag(data.getExtMaterialTitle()));
            ActFeatureParseV2.putMapNotNull(retMap, "ft600207", data.getExtMaterialId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft600208", data.getExtMaterialType());
            ActFeatureParseV2.putMapNotNull(retMap, "ft600205", data.getMaterialTag());
            ActFeatureParseV2.putMapNotNull(retMap, "ft600301", data.getExtAppTrade());
            ActFeatureParseV2.putMapNotNull(retMap, "ft600302", data.getExternalAdBlockId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft600303", data.getExternalAdBlockTypeId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft300203", data.getSlotMaterialId());
            ActFeatureParseV2.putMapNotNull(retMap, "ft300303", data.getDsm2A());
            LocalDateTime time = LocalDateTime.now();
            ActFeatureParseV2.putMapNotNull(retMap, "ft301001", time.getHour());
            ActFeatureParseV2.putMapNotNull(retMap, "ft301002", time.getDayOfWeek().getValue());
            ActFeatureParseV2.putMapNotNull(retMap, "ft301003", time.getDayOfMonth());
        }
        return retMap;
    }

    public static Map<String, String> parseUserFeature(UserFeatureDoV2 data) {
        HashMap<String, String> retMap = new HashMap<String, String>(64);
        UserProfileSubFeature userProfileFeature = Optional.ofNullable(data.getUserProfileSubFeature()).orElse(new UserProfileSubFeature());
        ActFeatureParseV2.putMapNotNull(retMap, "ft100001", data.getOneId());
        ActFeatureParseV2.putMapNotNull(retMap, "ft100103", userProfileFeature.getMarital());
        ActFeatureParseV2.putMapNotNull(retMap, "ft100106", userProfileFeature.getAge());
        ActFeatureParseV2.putMapNotNull(retMap, "ft100107", userProfileFeature.getGender());
        ActFeatureParseV2.putMapNotNull(retMap, "ft100501", userProfileFeature.getBdFirstTag());
        ActFeatureParseV2.putMapNotNull(retMap, "ft100502", userProfileFeature.getBdSecondTag());
        ActFeatureParseV2.putMapNotNull(retMap, "ft1005031", userProfileFeature.getBdThirdTag());
        ActFeatureParseV2.putMapNotNull(retMap, "ft100504", userProfileFeature.getBdFourthTag());
        ActFeatureParseV2.putMapNotNull(retMap, "ft100603", userProfileFeature.getAppInstall());
        UserBehaviorSubFeature userBehaviorSubFeature = Optional.ofNullable(data.getUserActSubFeature()).orElse(new UserBehaviorSubFeature());
        retMap.put("f0201", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv())));
        retMap.put("f0202", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv())));
        retMap.put("f0203", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv())));
        retMap.put("f0204", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv())));
        retMap.put("f0205", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv())));
        retMap.put("f0413", DataUtil.listToString(userBehaviorSubFeature.getUserActReqList()));
        retMap.put("f0417", DataUtil.listToString(userBehaviorSubFeature.getUserAdvLaunchTradeList()));
        retMap.put("f0418", DataUtil.listToString(userBehaviorSubFeature.getUserAdvClkTradeList()));
        retMap.put("f0301", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserReqPv1d())));
        retMap.put("f0302", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv1d())));
        retMap.put("f0303", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv1d())));
        retMap.put("f0304", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv1d())));
        retMap.put("f0305", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv1d())));
        retMap.put("f0316", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv1d())));
        retMap.put("f0311", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserReqPv14d())));
        retMap.put("f0312", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv14d())));
        retMap.put("f0313", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv14d())));
        retMap.put("f0314", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv14d())));
        retMap.put("f0315", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv14d())));
        retMap.put("f0320", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv14d())));
        retMap.put("f0341", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserReqPv180d())));
        retMap.put("f0342", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv180d())));
        retMap.put("f0343", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv180d())));
        retMap.put("f0344", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv180d())));
        retMap.put("f0345", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv180d())));
        retMap.put("f0350", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv180d())));
        retMap.put("f0403", DataUtil.listToString(userBehaviorSubFeature.getUserActReqList14d()));
        retMap.put("f0407", DataUtil.listToString(userBehaviorSubFeature.getUserAdvLaunchTradeList14d()));
        retMap.put("f0408", DataUtil.listToString(userBehaviorSubFeature.getUserAdvClkTradeList14d()));
        return retMap;
    }

    public static void main(String[] args) {
        ArrayList<String> reqList = new ArrayList<String>();
        reqList.add("100");
        reqList.add("101");
        Long activityId = 101L;
        String hisLastActivity = (String)reqList.get(reqList.size() - 1);
        Long hisLastActivityLong = Long.valueOf(hisLastActivity);
        System.out.println("hisLastActivit=" + hisLastActivity);
        System.out.println("hisLastActivityLong=" + hisLastActivityLong);
        System.out.println("hisLastActivit=" + activityId.equals(hisLastActivity));
        System.out.println("hisLastActivityLong=" + activityId.equals(hisLastActivityLong));
    }
}

