package cn.com.duiba.nezha.alg.feature.vo.v2023;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOnlineDiDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserBehaviorSubFeature;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;


/**
 * 活动场景，动态特征
 */
@Data
public class ActFeatureDoV3 implements Serializable {
    private static final long serialVersionUID = 6695201251295150673L;


    private Long activityId; //活动IDf.请求 f301000-f301001

    private Long activityPage; //自定义活动ID f.请求 新增，待编码 311001

    private String activitySkinType; // 活动皮肤ID/Name（玩法，大转盘/翻牌子/扭蛋机等）
    private String activitySkinType2; //活动玩法ID/：刮卡/大转盘/翻牌子/扭蛋机等）

    // private String activitySourceType;//活动[进入当前券]的访问类型[广告位、浮标、返回拦截、弹层、区块]


    private String actTradeTag; //1、适用场景标签，休闲游戏-经营养成、休闲游戏-答题解密；格式：1,3

    private String actCrowdTag; //2、人群标签；女性、男性等；格式：1,3

    private String actInteresteTag; //3、权益标签；红包、话费、手机等；格式：1,3 映射：939-红包，941-话费，942-手机

    private String actStyleTag; //4、设计风格标签；扁平、电商、卡通等；格式：1,3

    private String actSeasonTag; //5、季节标签；春、夏、秋、冬；格式：1,3

    private String actFestivalTag; //6、节日标签；双十一、双十二、春节等；格式：1,3


    public Map<String, String> parse(DmpFeatureDto data2, ActContextFeatureDoV3 data3) {

        Map<String, String> retMap = new HashMap<>(16);

        putMap(retMap, "ft300301", activityId);//活动id（当前活动）
        putMap(retMap, "ft300304", activityPage);//自定义活动ID（主活动ID）
        putMap(retMap, "ft300305", activitySkinType);// 活动皮肤ID/Name（玩法，大转盘/翻牌子/扭蛋机等）
        putMap(retMap, "ft300309", activitySkinType2); //活动皮肤ID，具体活动皮肤，约1000+：刮卡/大转盘/翻牌子/扭蛋机等
        putMap(retMap, "ft300311", actTradeTag); //1、适用场景标签，休闲游戏-经营养成、休闲游戏-答题解密；格式：1,3
        putMap(retMap, "ft300313", actInteresteTag); //3、权益标签；红包、话费、手机等；格式：1,3 映射：939-红包，941-话费，942-手机

        putMap(retMap, "ft300317", ActFeatureDoV3.interestTagValid(actInteresteTag, data3.getExtMaterialTitle()));//7、活动利益点与外部素材广告语利益点是否一致


        /**
         * 用户行为与活动交叉特征
         */

        TBDeviceFeatureOnlineDiDto userBehaviorSubFeature = Optional.ofNullable(data2.getFeatureOnlineDto()).orElse(new TBDeviceFeatureOnlineDiDto());
        String hisLastActivity = userBehaviorSubFeature.getT1113();

        if (AssertUtil.isAllNotEmpty(activityId, hisLastActivity)) {
            Long hisLastActivityLong = Long.valueOf(hisLastActivity);
            if (activityId.equals(hisLastActivityLong)) {
                retMap.put("ft110910", "1");//上一次活动访问，与当前活动是否相同、
            }
        }
        return retMap;
    }


    public static <T> void putMap(Map<String, String> map, String key, T value) {

        if (value != null) {
            map.put(key, value.toString());
        }
    }

    /**
     * 活动利益点(多值)与外部素材广告语利益点是否一致
     * 映射：939-红包，941-话费，942-手机
     *
     * @param
     * @return
     */
    public static Long interestTagValid(String actInterestTag, String extMaterialTitle) {

        Long ret = 0L;
        String extTag = BaseParse.formatInterestTag(extMaterialTitle);
        if (StringUtils.isBlank(actInterestTag) || StringUtils.isBlank(extTag)) {
            return ret;
        }

        String[] actTags = actInterestTag.split(",");
        for (String actTag : actTags) {
            if (StringUtils.isNotBlank(actTag) && extTag.equals(actTag)) {
                ret = 1L;
                break;
            }
        }

        return ret;
    }

    public static void main(String[] args) {

        try {
            String actInterestTag = ",939,,";
            String extMaterialTitle = "有红包！有红包！有红包！签到真的有红包！";
            Long ret = interestTagValid(actInterestTag, extMaterialTitle);
            System.out.println(ret);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
