package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.vo.DmpFeature;
import cn.com.duiba.nezha.alg.feature.vo.RtaFeatureDo;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by pzx on 2022/1/13.
 */
public class RtaFeatureParse {
    public static final int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(RtaFeatureParse.class);

    public static Map<String, String> generateFeatureMapStatic(RtaFeatureDo cf, DmpFeature dcf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                // 上下文特征
                String currentTimeMillis = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                Integer hour = LocalDateUtil.getHour(currentTimeMillis, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer weekDay = LocalDateUtil.getDayOfWeek(currentTimeMillis, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
//                Integer dayOfMonth = LocalDateUtil.getDayOfMonthSafely(currentTimeMillis, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                // 去掉具体日期特征，使用"是否周末"特征
                Integer isWeekend = (weekDay.intValue() >= 1 && weekDay.intValue() <= 5) ? 0 : 1;
                retMap.put("f0001", DataUtil.Integer2String(hour));            // 请求时间 hour（时段）
                retMap.put("f0002", DataUtil.Integer2String(weekDay));         // 请求时间 weekday（周几）
                retMap.put("f0003", DataUtil.Integer2String(isWeekend));      // 是否周末
                retMap.put("f0004", DataUtil.featureFormat(cf.getExtIdeaId(), cf.getExtIdeaIdOffline()));               // 上次曝光的外部创意id
                retMap.put("f0005", DataUtil.featureFormat(cf.getExtAdPlace(), cf.getExtAdPlaceOffline()));             // 上次曝光的外部广告投放场景
                retMap.put("f0006", DataUtil.featureFormat(cf.getExtAdvertGroupId(), cf.getExtAdvertGroupIdOffline())); // 上次曝光的外部广告组id
                retMap.put("f0007", DataUtil.featureFormat(cf.getExtAdvertId(), cf.getExtAdvertIdOffline()));           // 上次曝光的外部广告计划id
                retMap.put("f0008", DataUtil.featureFormat(cf.getExtAccountId(), cf.getExtAccountIdOffline()));         // 上次曝光的媒体开户账号id
                retMap.put("f0009", DataUtil.featureFormat(cf.getExtUnionSlotId(), cf.getExtUnionSlotIdOffline()));     // 上次曝光的外部广告位id
                retMap.put("f0010", DataUtil.featureFormat(cf.getExtPlatform(), cf.getExtPlatformOffline()));           // 上次曝光的外部平台id

                // DMP特征
                retMap.put("f0101", cf.getGender());  // 性别
                retMap.put("f0102", cf.getAge());     // 年龄
                retMap.put("f0103", cf.getMarital()); // 婚育情况
                retMap.put("f0104", cf.getIsp());     // 运营商（联通/移动/电信等）

                retMap.put("f0105", cf.getCityIdPv180d());  // 性别
                retMap.put("f0106", cf.getLastestCityId());     // 年龄
                retMap.put("f0107", cf.getLastestCityLevel()); // 婚育情况
                retMap.put("f0108", cf.getStayCityId());     // 运营商（联通/移动/电信等）
                retMap.put("f0109", cf.getStayCityLevel());  // 性别
                retMap.put("f0110", cf.getStayWorkRegionId());     // 年龄
                retMap.put("f0111", cf.getStayLiveRegionId()); // 婚育情况
                retMap.put("f0112", cf.getHomeCityId());     // 运营商（联通/移动/电信等）
                retMap.put("f0113", cf.getHomeCityLevel());     // 运营商（联通/移动/电信等）

                // 实时用户统计特征
                retMap.put("f0201", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv())));       // 用户当天入口曝光次数
                retMap.put("f0202", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv())));    // 用户当天活动访问次数
                retMap.put("f0203", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv()))); // 用户当天发券次数
                retMap.put("f0204", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv())));    // 用户当天券计费点击次数

                // 用户历史统计特征
                retMap.put("f0301", DataUtil.Long2String(MathUtil.log1p(cf.getUserReqPv1d())));        // 用户历史1天请求次数
                retMap.put("f0302", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv1d())));        // 用户历史1天入口曝光次数
                retMap.put("f0303", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv1d())));     // 用户历史1天活动访问次数
                retMap.put("f0304", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv1d())));  // 用户历史1天发券次数
                retMap.put("f0305", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv1d())));     // 用户历史1天券计费点击次数
                retMap.put("f0306", DataUtil.Long2String(MathUtil.log1p(cf.getUserReqPv7d())));        // 用户历史7天请求次数
                retMap.put("f0307", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv7d())));        // 用户历史7天入口曝光次数
                retMap.put("f0308", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv7d())));     // 用户历史7天活动访问次数
                retMap.put("f0309", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv7d())));  // 用户历史7天发券次数
                retMap.put("f0310", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv7d())));     // 用户历史7天券计费点击次数
                retMap.put("f0311", DataUtil.Long2String(MathUtil.log1p(cf.getUserReqPv14d())));       // 用户历史14天请求次数
                retMap.put("f0312", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv14d())));       // 用户历史14天入口曝光次数
                retMap.put("f0313", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv14d())));    // 用户历史14天活动访问次数
                retMap.put("f0314", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv14d()))); // 用户历史14天发券次数
                retMap.put("f0315", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv14d())));    // 用户历史14天券计费点击次数

                retMap.put("f0316", DataUtil.Long2String(MathUtil.log1p(cf.getUserCvtPv1d())));        // 用户历史1天目标转化次数
                retMap.put("f0317", DataUtil.Long2String(MathUtil.log1p(cf.getUserConsume1d())));      // 用户历史1天消耗
                retMap.put("f0318", DataUtil.Long2String(MathUtil.log1p(cf.getUserCvtPv7d())));        // 用户历史7天目标转化次数
                retMap.put("f0319", DataUtil.Long2String(MathUtil.log1p(cf.getUserConsume7d())));      // 用户历史7天消耗
                retMap.put("f0320", DataUtil.Long2String(MathUtil.log1p(cf.getUserCvtPv14d())));       // 用户历史14天目标转化次数
                retMap.put("f0321", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv14d())));    // 用户历史14天消耗

                //用户历史统计原始值
                retMap.put("f03001", DataUtil.Long2String(cf.getUserReqPv1d()));        // 用户历史1天请求次数
                retMap.put("f03002", DataUtil.Long2String(cf.getUserExpPv1d()));        // 用户历史1天入口曝光次数
                retMap.put("f03003", DataUtil.Long2String(cf.getUserActReqPv1d()));     // 用户历史1天活动访问次数
                retMap.put("f03004", DataUtil.Long2String(cf.getUserAdvLaunchPv1d()));  // 用户历史1天发券次数
                retMap.put("f03005", DataUtil.Long2String(cf.getUserAdvClkPv1d()));     // 用户历史1天券计费点击次数
                retMap.put("f03006", DataUtil.Long2String(cf.getUserReqPv7d()));        // 用户历史7天请求次数
                retMap.put("f03007", DataUtil.Long2String(cf.getUserExpPv7d()));        // 用户历史7天入口曝光次数
                retMap.put("f03008", DataUtil.Long2String(cf.getUserActReqPv7d()));     // 用户历史7天活动访问次数
                retMap.put("f03009", DataUtil.Long2String(cf.getUserAdvLaunchPv7d()));  // 用户历史7天发券次数
                retMap.put("f03010", DataUtil.Long2String(cf.getUserAdvClkPv7d()));     // 用户历史7天券计费点击次数
                retMap.put("f03011", DataUtil.Long2String(cf.getUserReqPv14d()));       // 用户历史14天请求次数
                retMap.put("f03012", DataUtil.Long2String(cf.getUserExpPv14d()));       // 用户历史14天入口曝光次数
                retMap.put("f03013", DataUtil.Long2String(cf.getUserActReqPv14d()));    // 用户历史14天活动访问次数
                retMap.put("f03014", DataUtil.Long2String(cf.getUserAdvLaunchPv14d())); // 用户历史14天发券次数
                retMap.put("f03015", DataUtil.Long2String(cf.getUserAdvClkPv14d()));    // 用户历史14天券计费点击次数

                retMap.put("f03016", DataUtil.Long2String(cf.getUserCvtPv1d()));        // 用户历史1天目标转化次数
                retMap.put("f03017", DataUtil.Long2String(cf.getUserConsume1d()));      // 用户历史1天消耗
                retMap.put("f03018", DataUtil.Long2String(cf.getUserCvtPv7d()));        // 用户历史7天目标转化次数
                retMap.put("f03019", DataUtil.Long2String(cf.getUserConsume7d()));      // 用户历史7天消耗
                retMap.put("f03020", DataUtil.Long2String(cf.getUserCvtPv14d()));       // 用户历史14天目标转化次数
                retMap.put("f03021", DataUtil.Long2String(cf.getUserAdvClkPv14d()));    // 用户历史14天消耗

                // 用户历史序列特征(截断到20个）
                retMap.put("f0401", DataUtil.listToString(cf.getUser_exp_list()));              // 用户历史创意id曝光列表
                retMap.put("f0402", DataUtil.listToString(cf.getUser_clk_list()));              // 用户历史创意id点击列表
                retMap.put("f0403", DataUtil.listToString(cf.getUser_act_req_list()));          // 用户历史活动id访问列表
                retMap.put("f0404", DataUtil.listToString(cf.getUser_act_join_list()));         // 用户历史活动id参与列表
                retMap.put("f0405", DataUtil.listToString(cf.getUser_adv_launch_list()));       // 用户历史券id曝光列表
                retMap.put("f0406", DataUtil.listToString(cf.getUser_adv_clk_list()));          // 用户历史券id计费点击列表
                retMap.put("f0407", DataUtil.listToString(cf.getUser_adv_launch_trade_list())); // 用户历史券行业id曝光列表
                retMap.put("f0408", DataUtil.listToString(cf.getUser_adv_clk_trade_list()));    // 用户历史券行业id计费点击列表

            }
            if (dcf != null) {
                retMap.put("f0322", DataUtil.Long2String(MathUtil.log1p(dcf.getUserReqPv180d())));  // 用户历史半年天请求次数
                retMap.put("f0323", DataUtil.Long2String(MathUtil.log1p(dcf.getUserExpPv180d()))); // 用户历史半年入口曝光次数
                retMap.put("f0324", DataUtil.Long2String(MathUtil.log1p(dcf.getUserActReqPv180d()))); // 用户历史半年活动访问次数
                retMap.put("f0325", DataUtil.Long2String(MathUtil.log1p(dcf.getUserAdvLaunchPv180d()))); // 用户历史半年发券次数
                retMap.put("f0326", DataUtil.Long2String(MathUtil.log1p(dcf.getUserAdvClkPv180d()))); // 用户历史半年券计费点击次数
                retMap.put("f0327", DataUtil.Long2String(MathUtil.log1p(dcf.getUserCvtPv180d())));  // 用户历史半年目标转化次数


//                retMap.put("f0409", DataUtil.SetToString(dcf.getUserReqGroupidCurList()));          //用户当天请求的推广组id-List
//                retMap.put("f0410", DataUtil.SetToString(dcf.getUserReqResidCurList()));            //用户当天请求的资源位id-List
//                retMap.put("f0411", DataUtil.SetToString(dcf.getUserReqExtAppidCurList()));         //用户当天请求的外部联盟小媒体id-List
//                retMap.put("f0412", DataUtil.SetToString(dcf.getUserReqExtSlotidCurList()));        //用户当天请求的外部联盟广告位id-List
                retMap.put("f0413", DataUtil.SetToString(dcf.getUserBackGroupidCurList()));         //用户当天返回的推广组id-List
                retMap.put("f0414", DataUtil.SetToString(dcf.getUserBackResidCurList()));           //用户当天返回的资源位id-List
                retMap.put("f0415", DataUtil.SetToString(dcf.getUserBackExtAppidCurList()));        //用户当天返回的外部联盟小媒体id-List
                retMap.put("f0416", DataUtil.SetToString(dcf.getUserBackExtSlotidCurList()));       //用户当天返回的外部联盟广告位id-List
                retMap.put("f0417", DataUtil.SetToString(dcf.getUserExpGroupidCurList()));          //用户当天曝光的推广组id-List
                retMap.put("f0418", DataUtil.SetToString(dcf.getUserExpResidCurList()));            //用户当天曝光的资源位id-List
                retMap.put("f0419", DataUtil.SetToString(dcf.getUserExpExtAppidCurList()));         //用户当天曝光的外部联盟小媒体id-List
                retMap.put("f0420", DataUtil.SetToString(dcf.getUserExpExtSlotidCurList()));        //用户当天曝光的外部联盟广告位id-List
                retMap.put("f0421", DataUtil.SetToString(dcf.getUserActReqGroupidCurList()));       //用户当天活动请求的推广组id-List
                retMap.put("f0422", DataUtil.SetToString(dcf.getUserActReqResidCurList()));         //用户当天活动请求的资源位id-List
                retMap.put("f0423", DataUtil.SetToString(dcf.getUserActReqExtAppidCurList()));      //用户当天活动请求的外部联盟小媒体id-List
                retMap.put("f0424", DataUtil.SetToString(dcf.getUserActReqExtSlotidCurList()));     //用户当天活动请求的外部联盟广告位id-List
                retMap.put("f0425", DataUtil.SetToString(dcf.getUserActJoinGroupidCurList()));      //用户当天活动参与的推广组id-List
                retMap.put("f0426", DataUtil.SetToString(dcf.getUserActJoinResidCurList()));        //用户当天活动参与的资源位id-List
                retMap.put("f0427", DataUtil.SetToString(dcf.getUserActJoinExtAppidCurList()));     //用户当天活动参与的外部联盟小媒体id-List
                retMap.put("f0428", DataUtil.SetToString(dcf.getUserActJoinExtSlotidCurList()));    //用户当天活动参与的外部联盟广告位id-List
                retMap.put("f0429", DataUtil.SetToString(dcf.getUserCoupClickGroupidCurList()));    //用户当天点券的推广组id-List
                retMap.put("f0430", DataUtil.SetToString(dcf.getUserCoupClickResidCurList()));      //用户当天点券的资源位id-List
                retMap.put("f0431", DataUtil.SetToString(dcf.getUserCoupClickExtAppidCurList()));   //用户当天点券的外部联盟小媒体id-List
                retMap.put("f0432", DataUtil.SetToString(dcf.getUserCoupClickExtSlotidCurList()));  //用户当天点券的外部联盟广告位id-List
                retMap.put("f0433", DataUtil.SetToString(dcf.getUserConvGroupidCurList()));         //用户当天转化的推广组id-List
                retMap.put("f0434", DataUtil.SetToString(dcf.getUserConvResidCurList()));           //用户当天转化的资源位id-List
                retMap.put("f0435", DataUtil.SetToString(dcf.getUserConvExtAppidCurList()));        //用户当天转化的外部联盟小媒体id-List
                retMap.put("f0436", DataUtil.SetToString(dcf.getUserConvExtSlotidCurList()));       //用户当天转化的外部联盟广告位id-List

                retMap.put("f0437", DataUtil.SetToString(dcf.getUserReqGroupid1dList()));           //用户1天请求的推广组id-List
                retMap.put("f0438", DataUtil.SetToString(dcf.getUserReqResid1dList()));             //用户1天请求的资源位id-List
                retMap.put("f0439", DataUtil.SetToString(dcf.getUserReqExtAppid1dList()));          //用户1天请求的外部联盟小媒体id-List
                retMap.put("f0440", DataUtil.SetToString(dcf.getUserReqExtSlotid1dList()));         //用户1天请求的外部联盟广告位id-List
                retMap.put("f0441", DataUtil.SetToString(dcf.getUserBackGroupid1dList()));          //用户1天返回的推广组id-List
                retMap.put("f0442", DataUtil.SetToString(dcf.getUserBackResid1dList()));            //用户1天返回的资源位id-List
                retMap.put("f0443", DataUtil.SetToString(dcf.getUserBackExtAppid1dList()));         //用户1天返回的外部联盟小媒体id-List
                retMap.put("f0444", DataUtil.SetToString(dcf.getUserBackExtSlotid1dList()));        //用户1天返回的外部联盟广告位id-List
                retMap.put("f0445", DataUtil.SetToString(dcf.getUserExpGroupid1dList()));           //用户1天曝光的推广组id-List
                retMap.put("f0446", DataUtil.SetToString(dcf.getUserExpResid1dList()));             //用户1天曝光的资源位id-List
                retMap.put("f0447", DataUtil.SetToString(dcf.getUserExpExtAppid1dList()));          //用户1天曝光的外部联盟小媒体id-List
                retMap.put("f0448", DataUtil.SetToString(dcf.getUserExpExtSlotid1dList()));         //用户1天曝光的外部联盟广告位id-List
                retMap.put("f0449", DataUtil.SetToString(dcf.getUserActReqGroupid1dList()));        //用户1天活动请求的推广组id-List
                retMap.put("f0450", DataUtil.SetToString(dcf.getUserActReqResid1dList()));          //用户1天活动请求的资源位id-List
                retMap.put("f0451", DataUtil.SetToString(dcf.getUserActReqExtAppid1dList()));       //用户1天活动请求的外部联盟小媒体id-List
                retMap.put("f0452", DataUtil.SetToString(dcf.getUserActReqExtSlotid1dList()));      //用户1天活动请求的外部联盟广告位id-List
                retMap.put("f0453", DataUtil.SetToString(dcf.getUserActJoinGroupid1dList()));       //用户1天活动参与的推广组id-List
                retMap.put("f0454", DataUtil.SetToString(dcf.getUserActJoinResid1dList()));         //用户1天活动参与的资源位id-List
                retMap.put("f0455", DataUtil.SetToString(dcf.getUserActJoinExtAppid1dList()));      //用户1天活动参与的外部联盟小媒体id-List
                retMap.put("f0456", DataUtil.SetToString(dcf.getUserActJoinExtSlotid1dList()));     //用户1天活动参与的外部联盟广告位id-List
                retMap.put("f0457", DataUtil.SetToString(dcf.getUserCoupClickGroupid1dList()));     //用户1天点券的推广组id-List
                retMap.put("f0458", DataUtil.SetToString(dcf.getUserCoupClickResid1dList()));       //用户1天点券的资源位id-List
                retMap.put("f0459", DataUtil.SetToString(dcf.getUserCoupClickExtAppid1dList()));    //用户1天点券的外部联盟小媒体id-List
                retMap.put("f0460", DataUtil.SetToString(dcf.getUserCoupClickExtSlotid1dList()));   //用户1天点券的外部联盟广告位id-List
                retMap.put("f0461", DataUtil.SetToString(dcf.getUserConvGroupid1dList()));          //用户1天转化的推广组id-List
                retMap.put("f0462", DataUtil.SetToString(dcf.getUserConvResid1dList()));            //用户1天转化的资源位id-List
                retMap.put("f0463", DataUtil.SetToString(dcf.getUserConvExtAppid1dList()));         //用户1天转化的外部联盟小媒体id-List
                retMap.put("f0464", DataUtil.SetToString(dcf.getUserConvExtSlotid1dList()));        //用户1天转化的外部联盟广告位id-List

                retMap.put("f0465", DataUtil.SetToString(dcf.getUserReqGroupid7dList()));           //用户7天请求的推广组id-List
                retMap.put("f0466", DataUtil.SetToString(dcf.getUserReqResid7dList()));             //用户7天请求的资源位id-List
                retMap.put("f0467", DataUtil.SetToString(dcf.getUserReqExtAppid7dList()));          //用户7天请求的外部联盟小媒体id-List
                retMap.put("f0468", DataUtil.SetToString(dcf.getUserReqExtSlotid7dList()));         //用户7天请求的外部联盟广告位id-List
                retMap.put("f0469", DataUtil.SetToString(dcf.getUserBackGroupid7dList()));          //用户7天返回的推广组id-List
                retMap.put("f0470", DataUtil.SetToString(dcf.getUserBackResid7dList()));            //用户7天返回的资源位id-List
                retMap.put("f0471", DataUtil.SetToString(dcf.getUserBackExtAppid7dList()));         //用户7天返回的外部联盟小媒体id-List
                retMap.put("f0472", DataUtil.SetToString(dcf.getUserBackExtSlotid7dList()));        //用户7天返回的外部联盟广告位id-List
                retMap.put("f0473", DataUtil.SetToString(dcf.getUserExpGroupid7dList()));           //用户7天曝光的推广组id-List
                retMap.put("f0474", DataUtil.SetToString(dcf.getUserExpResid7dList()));             //用户7天曝光的资源位id-List
                retMap.put("f0475", DataUtil.SetToString(dcf.getUserExpExtAppid7dList()));          //用户7天曝光的外部联盟小媒体id-List
                retMap.put("f0476", DataUtil.SetToString(dcf.getUserExpExtSlotid7dList()));         //用户7天曝光的外部联盟广告位id-List
                retMap.put("f0477", DataUtil.SetToString(dcf.getUserActReqGroupid7dList()));        //用户7天活动请求的推广组id-List
                retMap.put("f0478", DataUtil.SetToString(dcf.getUserActReqResid7dList()));          //用户7天活动请求的资源位id-List
                retMap.put("f0479", DataUtil.SetToString(dcf.getUserActReqExtAppid7dList()));       //用户7天活动请求的外部联盟小媒体id-List
                retMap.put("f0480", DataUtil.SetToString(dcf.getUserActReqExtSlotid7dList()));      //用户7天活动请求的外部联盟广告位id-List
                retMap.put("f0481", DataUtil.SetToString(dcf.getUserActJoinGroupid7dList()));       //用户7天活动参与的推广组id-List
                retMap.put("f0482", DataUtil.SetToString(dcf.getUserActJoinResid7dList()));         //用户7天活动参与的资源位id-List
                retMap.put("f0483", DataUtil.SetToString(dcf.getUserActJoinExtAppid7dList()));      //用户7天活动参与的外部联盟小媒体id-List
                retMap.put("f0484", DataUtil.SetToString(dcf.getUserActJoinExtSlotid7dList()));     //用户7天活动参与的外部联盟广告位id-List
                retMap.put("f0485", DataUtil.SetToString(dcf.getUserCoupClickGroupid7dList()));     //用户7天点券的推广组id-List
                retMap.put("f0486", DataUtil.SetToString(dcf.getUserCoupClickResid7dList()));       //用户7天点券的资源位id-List
                retMap.put("f0487", DataUtil.SetToString(dcf.getUserCoupClickExtAppid7dList()));    //用户7天点券的外部联盟小媒体id-List
                retMap.put("f0488", DataUtil.SetToString(dcf.getUserCoupClickExtSlotid7dList()));   //用户7天点券的外部联盟广告位id-List
                retMap.put("f0489", DataUtil.SetToString(dcf.getUserConvGroupid7dList()));          //用户7天转化的推广组id-List
                retMap.put("f0490", DataUtil.SetToString(dcf.getUserConvResid7dList()));            //用户7天转化的资源位id-List
                retMap.put("f0491", DataUtil.SetToString(dcf.getUserConvExtAppid7dList()));         //用户7天转化的外部联盟小媒体id-List
                retMap.put("f0492", DataUtil.SetToString(dcf.getUserConvExtSlotid7dList()));        //用户7天转化的外部联盟广告位id-List

            }
        } catch (Exception e) {
            logger.error("RtaFeatureParse.generateFeatureMapStatic error:", e);

        }
        return retMap;
    }
}