/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse.v2;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOffline14dDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOffline180dDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOffline30dDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOffline7dDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOnlineDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceLabelDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDmpAdxResourceDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDmpAppPackageDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDmpSlotDiDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceFeatureParseV2
extends BaseParse {
    private static final Logger logger = LoggerFactory.getLogger(DeviceFeatureParseV2.class);

    public static Map<String, String> parse(DmpFeatureDto dmpFeatureDto, String externalAdBlockId) {
        HashMap<String, String> retMap = new HashMap<String, String>(100);
        if (dmpFeatureDto == null) {
            return retMap;
        }
        Map<String, String> labelDtoMap = DeviceFeatureParseV2.parseTBDeviceLabelDiDto(dmpFeatureDto.getLabelDto());
        retMap.putAll(labelDtoMap);
        Map<String, String> featureOnlineDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOnlineDiDto(dmpFeatureDto.getFeatureOnlineDto());
        retMap.putAll(featureOnlineDtoMap);
        Map<String, String> featureOffline7dDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOffline7dDiDto(dmpFeatureDto.getFeatureOffline7dDto());
        retMap.putAll(featureOffline7dDtoMap);
        Map<String, String> featureOffline14dDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOffline14dDiDto(dmpFeatureDto.getFeatureOffline14dDto());
        retMap.putAll(featureOffline14dDtoMap);
        Map<String, String> featureOffline30dDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOffline30dDiDto(dmpFeatureDto.getFeatureOffline30dDto());
        retMap.putAll(featureOffline30dDtoMap);
        Map<String, String> featureOffline180dDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOffline180dDiDto(dmpFeatureDto.getFeatureOffline180dDto());
        retMap.putAll(featureOffline180dDtoMap);
        Map<String, String> adxResourceDtoMap = DeviceFeatureParseV2.parseTBDmpAdxResourceDiDto(dmpFeatureDto.getAdxResourceDto(), externalAdBlockId);
        retMap.putAll(adxResourceDtoMap);
        Map<String, String> slotDtoMap = DeviceFeatureParseV2.parseTBDmpSlotDiDto(dmpFeatureDto.getSlotDto());
        retMap.putAll(slotDtoMap);
        Map<String, String> appPackageDtoMap = DeviceFeatureParseV2.parseAppPackageDto(dmpFeatureDto.getAppPackageDto());
        retMap.putAll(appPackageDtoMap);
        return retMap;
    }

    private static Map<String, String> parseTBDeviceLabelDiDto(TBDeviceLabelDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1001", data.getT1001());
        DeviceFeatureParseV2.putMap(retMap, "fd_1002", data.getT1002());
        DeviceFeatureParseV2.putMap(retMap, "fd_1003", data.getT1003());
        DeviceFeatureParseV2.putMap(retMap, "fd_1004", data.getT1004());
        DeviceFeatureParseV2.putMap(retMap, "fd_1005", data.getT1005());
        DeviceFeatureParseV2.putMap(retMap, "fd_1006", data.getT1006());
        DeviceFeatureParseV2.putMap(retMap, "fd_1007", data.getT1007());
        DeviceFeatureParseV2.putMap(retMap, "fd_1008", data.getT1008());
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOnlineDiDto(TBDeviceFeatureOnlineDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1101", data.getT1101());
        DeviceFeatureParseV2.putMap(retMap, "fd_1102", data.getT1102());
        DeviceFeatureParseV2.putMap(retMap, "fd_1103", data.getT1103());
        DeviceFeatureParseV2.putMap(retMap, "fd_1104", data.getT1104());
        DeviceFeatureParseV2.putMap(retMap, "fd_1105", data.getT1105());
        DeviceFeatureParseV2.putMap(retMap, "fd_1106", data.getT1106());
        DeviceFeatureParseV2.putMap(retMap, "fd_1107", data.getT1107());
        DeviceFeatureParseV2.putMap(retMap, "fd_1108", data.getT1108());
        DeviceFeatureParseV2.putMap(retMap, "fd_1109", data.getT1109());
        DeviceFeatureParseV2.putMap(retMap, "fd_1110", data.getT1110());
        DeviceFeatureParseV2.putMap(retMap, "fd_1011", data.getT1111());
        DeviceFeatureParseV2.putMap(retMap, "fd_1012", data.getT1112());
        DeviceFeatureParseV2.putMap(retMap, "fd_1013", data.getT1113());
        DeviceFeatureParseV2.putMap(retMap, "fd_1014", data.getT1114());
        DeviceFeatureParseV2.putMap(retMap, "fd_1015", data.getT1115());
        DeviceFeatureParseV2.putMap(retMap, "fd_1016", data.getT1116());
        DeviceFeatureParseV2.putMap(retMap, "fd_1017", DeviceFeatureParseV2.getTopN(data.getT1117(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1018", DeviceFeatureParseV2.getTopN(data.getT1118(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1020", DeviceFeatureParseV2.getTopN(data.getT1120(), 5));
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline7dDiDto(TBDeviceFeatureOffline7dDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1701", data.getT1701());
        DeviceFeatureParseV2.putMap(retMap, "fd_1702", data.getT1702());
        DeviceFeatureParseV2.putMap(retMap, "fd_1703", data.getT1703());
        DeviceFeatureParseV2.putMap(retMap, "fd_1704", data.getT1704());
        DeviceFeatureParseV2.putMap(retMap, "fd_1705", data.getT1705());
        DeviceFeatureParseV2.putMap(retMap, "fd_1706", data.getT1706());
        DeviceFeatureParseV2.putMap(retMap, "fd_1707", data.getT1707());
        DeviceFeatureParseV2.putMap(retMap, "fd_1708", data.getT1708());
        DeviceFeatureParseV2.putMap(retMap, "fd_1709", DeviceFeatureParseV2.getTopN(data.getT1709(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1710", DeviceFeatureParseV2.getTopN(data.getT1710(), 5));
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline14dDiDto(TBDeviceFeatureOffline14dDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1201", data.getT1201());
        DeviceFeatureParseV2.putMap(retMap, "fd_1202", data.getT1202());
        DeviceFeatureParseV2.putMap(retMap, "fd_1203", data.getT1203());
        DeviceFeatureParseV2.putMap(retMap, "fd_1204", data.getT1204());
        DeviceFeatureParseV2.putMap(retMap, "fd_1205", data.getT1205());
        DeviceFeatureParseV2.putMap(retMap, "fd_1206", data.getT1206());
        DeviceFeatureParseV2.putMap(retMap, "fd_1207", data.getT1207());
        DeviceFeatureParseV2.putMap(retMap, "fd_1208", data.getT1208());
        DeviceFeatureParseV2.putMap(retMap, "fd_1209", DeviceFeatureParseV2.getTopN(data.getT1209(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1210", DeviceFeatureParseV2.getTopN(data.getT1210(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1212", DeviceFeatureParseV2.getTopN(data.getT1212(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1213", DeviceFeatureParseV2.getTopN(data.getT1213(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1214", DeviceFeatureParseV2.getTopN(data.getT1214(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1215", DeviceFeatureParseV2.getTopN(data.getT1215(), 5));
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline30dDiDto(TBDeviceFeatureOffline30dDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1801", data.getT1801());
        DeviceFeatureParseV2.putMap(retMap, "fd_1802", data.getT1802());
        DeviceFeatureParseV2.putMap(retMap, "fd_1803", data.getT1803());
        DeviceFeatureParseV2.putMap(retMap, "fd_1804", data.getT1804());
        DeviceFeatureParseV2.putMap(retMap, "fd_1805", data.getT1805());
        DeviceFeatureParseV2.putMap(retMap, "fd_1806", data.getT1806());
        DeviceFeatureParseV2.putMap(retMap, "fd_1807", data.getT1807());
        DeviceFeatureParseV2.putMap(retMap, "fd_1808", data.getT1808());
        DeviceFeatureParseV2.putMap(retMap, "fd_1809", DeviceFeatureParseV2.getTopN(data.getT1809(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1810", DeviceFeatureParseV2.getTopN(data.getT1810(), 5));
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline180dDiDto(TBDeviceFeatureOffline180dDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1301", data.getT1301());
        DeviceFeatureParseV2.putMap(retMap, "fd_1302", data.getT1302());
        DeviceFeatureParseV2.putMap(retMap, "fd_1303", data.getT1303());
        DeviceFeatureParseV2.putMap(retMap, "fd_1304", data.getT1304());
        DeviceFeatureParseV2.putMap(retMap, "fd_1305", data.getT1305());
        DeviceFeatureParseV2.putMap(retMap, "fd_1306", data.getT1306());
        DeviceFeatureParseV2.putMap(retMap, "fd_1307", data.getT1307());
        DeviceFeatureParseV2.putMap(retMap, "fd_1308", data.getT1308());
        DeviceFeatureParseV2.putMap(retMap, "fd_1309", DeviceFeatureParseV2.getTopN(data.getT1309(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1310", DeviceFeatureParseV2.getTopN(data.getT1310(), 5));
        return retMap;
    }

    private static Map<String, String> parseTBDmpAdxResourceDiDto(TBDmpAdxResourceDiDto data, String externalAdBlockId) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null || externalAdBlockId == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1401_02", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1401(), data.getT1402(), 100, 0.05, externalAdBlockId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1402_03", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1402(), data.getT1403(), 100, 0.05, externalAdBlockId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1402_04", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1402(), data.getT1404(), 1000, 0.0015, externalAdBlockId));
        return retMap;
    }

    private static Map<String, String> parseTBDmpSlotDiDto(TBDmpSlotDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1501", DeviceFeatureParseV2.getTopN(data.getT1501(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1502", DeviceFeatureParseV2.getTopN(data.getT1502(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1503", DeviceFeatureParseV2.getTopN(data.getT1503(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1504", DeviceFeatureParseV2.getTopN(data.getT1504(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1505", DeviceFeatureParseV2.getTopN(data.getT1505(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1506", DeviceFeatureParseV2.getTopN(data.getT1506(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1507", DeviceFeatureParseV2.getTopN(data.getT1507(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1508", DeviceFeatureParseV2.getTopN(data.getT1508(), 5));
        return retMap;
    }

    public static Map<String, String> parseTBDmpSlotDiDto(TBDmpSlotDiDto data, Long advertId, String tradeId) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1501", DeviceFeatureParseV2.getTopN(data.getT1501(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1502", DeviceFeatureParseV2.getTopN(data.getT1502(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1503", DeviceFeatureParseV2.getTopN(data.getT1503(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1504", DeviceFeatureParseV2.getTopN(data.getT1504(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1505", DeviceFeatureParseV2.getTopN(data.getT1505(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1506", DeviceFeatureParseV2.getTopN(data.getT1506(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1507", DeviceFeatureParseV2.getTopN(data.getT1507(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1508", DeviceFeatureParseV2.getTopN(data.getT1508(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1505_06", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1505(), data.getT1506(), 100, 0.5, tradeId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1506_07", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1506(), data.getT1507(), 100, 0.03, tradeId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1506_08", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1506(), data.getT1508(), 100, 0.03, tradeId));
        return retMap;
    }

    private static Map<String, String> parseAppPackageDto(TBDmpAppPackageDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        return retMap;
    }

    public static Map<String, String> parseAppPackageDto(TBDmpAppPackageDiDto data, String tradeId) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1601_02", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1601(), data.getT1602(), 100, 0.5, tradeId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1601_02", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1602(), data.getT1603(), 100, 0.03, tradeId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1602_04", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1602(), data.getT1604(), 100, 0.03, tradeId));
        return retMap;
    }

    public static <T> void putMap(Map<String, String> map, String key, T value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, Set<T> value) {
        if (value != null) {
            map.put(key, JSON.toJSONString(value));
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, Map<String, T> value) {
        if (value != null) {
            map.put(key, JSON.toJSONString(value));
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, List<String> value) {
        if (value != null) {
            map.put(key, String.join((CharSequence)",", value));
        }
    }

    public static Map<String, Double> getMapRatio(Map<String, Long> map1, Map<String, Long> map2, int threshold, double biasRatio) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{map1, map2})) {
            return retMap;
        }
        for (Map.Entry<String, Long> entry : map1.entrySet()) {
            String key = entry.getKey();
            Long value1 = entry.getValue();
            Long value2 = map2.getOrDefault(key, 0L);
            Double ret = 0.0;
            if (value1 == null) {
                retMap.put(key, ret);
                continue;
            }
            ret = ((double)value2.longValue() + (double)threshold * biasRatio) / (double)(value1 + (long)threshold);
            ret = MathUtil.formatDouble((double)ret, (int)7);
            retMap.put(key, ret);
        }
        return retMap;
    }

    public static Double getMapRatioWithKey(Map<String, Long> map1, Map<String, Long> map2, int threshold, double biasRatio, String key) {
        Double ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{map1, map2})) {
            return ret;
        }
        Long value1 = map1.get(key);
        Long value2 = map2.getOrDefault(key, 0L);
        if (value1 != null) {
            ret = ((double)value2.longValue() + (double)threshold * biasRatio) / (double)(value1 + (long)threshold);
            ret = MathUtil.formatDouble((double)ret, (int)7);
        }
        return ret;
    }

    public static List<String> getTopN(Map<String, Long> map, int n) {
        ArrayList<String> ret = new ArrayList<String>();
        if (AssertUtil.isEmpty(map)) {
            return ret;
        }
        ArrayList<Map.Entry<String, Long>> list = new ArrayList<Map.Entry<String, Long>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                if (o1.getValue() != o2.getValue()) {
                    if (o1.getValue() == null) {
                        return 1;
                    }
                    if (o2.getValue() == null) {
                        return -1;
                    }
                    return o2.getValue().intValue() - o1.getValue().intValue();
                }
                return 0;
            }
        });
        for (int i = 0; i < Math.min(list.size(), n); ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            ret.add((String)e.getKey());
        }
        return ret;
    }
}

