/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureParse2;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(FeatureParse.class);
    public static int[] dayOrderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 60, 100};
    public static int[] orderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 25, 30, 35, 50, 70, 100, 200, 500};
    public static int[] dayActOrderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 20};
    public static int[] orderActRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 50};
    public static int[] orderGmtIntervelBucket = new int[]{1, 2, 3, 4, 5, 10, 60, 720, 1440, 10080};
    public static int[] orderActGmtIntervelBucket = new int[]{1, 2, 3, 4, 5, 10, 60, 720, 1440, 10080};
    public static double[] userCtrBucket = new double[]{0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userCvrBucket = new double[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userSignRatioBucket = new double[]{0.001, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 0.075, 0.1, 0.125, 0.15, 0.175, 0.2, 0.225, 0.25, 0.275, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static int[] cntBucket = new int[]{0, 1, 3, 5, 10, 15, 20};
    public static int[] bigCntBucket = new int[]{0, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 500000, 1000000};
    public static int[] ctrAndCvrLevelBucket = new int[]{1, 4, 8};
    public static int[] videoDurationBucket = new int[]{0, 15, 30, 60, 300, 600, 900, 1800, 2700, 3600, 5400, 7200};
    public static int[] colorRBGBucket = new int[]{0, 25, 50, 75, 100, 125, 150, 175, 200, 225};
    public static int[] priceBucket = new int[]{0, 5000, 10000, 20000, 50000, 100000, 200000};
    public static int[] totalPriceBucket = new int[]{0, 10000, 50000, 100000, 200000, 500000, 1000000};
    public static int[] cateScoreBucket = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    public static double[] statCtrBucket = new double[]{0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] statCvrBucket = new double[]{0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] statBCvrBucket = new double[]{0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007, 0.008, 0.009, 0.01, 0.011, 0.012, 0.013, 0.014, 0.015, 0.016, 0.017, 0.018, 0.019, 0.02, 0.021, 0.022, 0.023, 0.024, 0.025, 0.026, 0.027, 0.028, 0.029, 0.03, 0.031, 0.032, 0.033, 0.034, 0.035, 0.036, 0.037, 0.038, 0.039, 0.04, 0.041, 0.042, 0.043, 0.044, 0.045, 0.046, 0.047, 0.048, 0.049, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.12, 0.14, 0.16, 0.18, 0.2, 0.22, 0.24, 0.26, 0.28, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] cntRatioBucket = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
    public static final int[] cntMeituanBucket = new int[]{-1, 1, 2, 3, 4, 5, 10, 20, 30};
    public static final int[] cntMeituanBucket30d = new int[]{0, 1, 2, 3, 5, 10, 30, 90};
    public static int[] convertCntBucket = new int[]{0, 5, 10, 50, 100, 200, 500, 1000};
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>(){
        {
            this.put("8", 0);
            this.put("14", 1);
            this.put("15", 2);
            this.put("21", 3);
            this.put("20", 4);
            this.put("3", 5);
            this.put("5", 6);
            this.put("12", 7);
            this.put("2", 8);
            this.put("1", 9);
            this.put("24", 10);
            this.put("6", 11);
            this.put("7", 12);
            this.put("11", 13);
            this.put("13", 14);
            this.put("18", 15);
            this.put("22", 16);
            this.put("4", 17);
            this.put("17", 18);
            this.put("25", 19);
            this.put("10", 20);
            this.put("23", 21);
            this.put("9", 22);
            this.put("19", 23);
            this.put("16", 24);
        }
    };
    public static Map<String, Integer> loadingPageCodes = new HashMap<String, Integer>(){
        {
            this.put("04.01.0001", 0);
            this.put("04.01.0002", 1);
            this.put("04.01.0003", 2);
            this.put("04.01.0004", 3);
            this.put("04.01.0005", 4);
            this.put("04.01.0006", 5);
            this.put("04.01.0007", 6);
            this.put("04.01.0008", 7);
            this.put("04.01.0009", 8);
            this.put("04.01.0010", 9);
            this.put("04.02.0001", 10);
            this.put("04.03.0001", 11);
            this.put("04.03.0002", 12);
            this.put("04.03.0003", 13);
            this.put("04.03.0004", 14);
            this.put("04.03.0005", 15);
            this.put("04.03.0007", 16);
            this.put("04.03.0008", 17);
            this.put("04.03.0009", 18);
            this.put("04.03.0010", 19);
            this.put("04.03.0011", 20);
            this.put("04.03.0012", 21);
            this.put("04.03.0013", 22);
            this.put("04.03.0014", 23);
            this.put("04.03.0015", 24);
            this.put("04.03.0017", 25);
            this.put("04.03.0018", 26);
            this.put("04.03.0019", 27);
            this.put("04.03.0020", 28);
            this.put("04.03.0021", 29);
        }
    };
    public static Map<String, Integer> resourceCodes = new HashMap<String, Integer>(){
        {
            this.put("07.23.0008", 0);
            this.put("07.23.0019", 1);
            this.put("07.23.0010", 2);
            this.put("07.24.0001", 3);
            this.put("07.23.0013", 4);
            this.put("07.23.0018", 5);
            this.put("07.23.0009", 6);
            this.put("07.23.0030", 7);
            this.put("07.23.0012", 8);
            this.put("07.23.0036", 9);
            this.put("07.23.0021", 10);
        }
    };
    public static Map<String, Integer> appCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
            this.put("8", 8);
            this.put("9", 9);
            this.put("10", 10);
            this.put("11", 11);
            this.put("12", 12);
            this.put("13", 13);
            this.put("14", 14);
        }
    };
    public static Map<String, Integer> msgSigCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
            this.put("8", 8);
            this.put("9", 9);
            this.put("10", 10);
            this.put("11", 11);
            this.put("12", 12);
            this.put("13", 13);
            this.put("14", 14);
            this.put("15", 15);
            this.put("16", 16);
            this.put("17", 17);
            this.put("18", 18);
            this.put("19", 19);
            this.put("20", 20);
            this.put("21", 21);
            this.put("22", 22);
            this.put("23", 23);
            this.put("24", 24);
            this.put("25", 25);
            this.put("26", 26);
            this.put("27", 27);
            this.put("28", 28);
            this.put("29", 29);
            this.put("30", 30);
            this.put("31", 31);
            this.put("32", 32);
            this.put("33", 33);
            this.put("34", 34);
            this.put("35", 35);
            this.put("36", 36);
            this.put("37", 37);
            this.put("38", 38);
            this.put("39", 39);
            this.put("40", 40);
            this.put("41", 41);
            this.put("42", 42);
            this.put("43", 43);
        }
    };
    public static Map<String, Integer> keywordCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
            this.put("8", 8);
            this.put("9", 9);
            this.put("10", 10);
            this.put("11", 11);
            this.put("12", 12);
            this.put("13", 13);
            this.put("14", 14);
            this.put("15", 15);
            this.put("16", 16);
            this.put("17", 17);
            this.put("18", 18);
            this.put("19", 19);
            this.put("20", 20);
            this.put("21", 21);
            this.put("22", 22);
            this.put("23", 23);
            this.put("24", 24);
            this.put("25", 25);
            this.put("26", 26);
            this.put("27", 27);
            this.put("28", 28);
            this.put("29", 29);
            this.put("30", 30);
        }
    };
    public static Map<String, Integer> videoCateCodes = new HashMap<String, Integer>(){
        {
            this.put("1273152", 0);
            this.put("1273153", 1);
            this.put("1273154", 2);
            this.put("1273155", 3);
            this.put("1273158", 4);
            this.put("1273163", 5);
            this.put("1273166", 6);
            this.put("1273190", 7);
            this.put("1273380", 8);
            this.put("1273399", 9);
            this.put("1275055", 10);
            this.put("1275060", 11);
            this.put("1275378", 12);
            this.put("1275381", 13);
            this.put("1275605", 14);
            this.put("1275609", 15);
            this.put("1275699", 16);
            this.put("1275850", 17);
            this.put("1276159", 18);
            this.put("1276427", 19);
            this.put("1277341", 20);
            this.put("1277350", 21);
            this.put("1277354", 22);
            this.put("1277360", 23);
            this.put("1277373", 24);
            this.put("1278212", 25);
            this.put("1279265", 26);
            this.put("1279863", 27);
            this.put("1281970", 28);
            this.put("1281978", 29);
            this.put("1282468", 30);
            this.put("1282983", 31);
            this.put("1283091", 32);
            this.put("1283242", 33);
            this.put("1284864", 34);
            this.put("1284891", 35);
            this.put("1284979", 36);
            this.put("1288586", 37);
            this.put("1289618", 38);
            this.put("1289633", 39);
            this.put("1289641", 40);
            this.put("1289642", 41);
            this.put("1291079", 42);
            this.put("1307098", 43);
            this.put("1307103", 44);
            this.put("1308055", 45);
            this.put("1310272", 46);
            this.put("1310276", 47);
            this.put("1311366", 48);
            this.put("1316217", 49);
            this.put("1323164", 50);
            this.put("1333414", 51);
            this.put("1343852", 52);
            this.put("1345203", 53);
            this.put("1345206", 54);
            this.put("1345801", 55);
            this.put("1347029", 56);
            this.put("1348464", 57);
            this.put("1348469", 58);
            this.put("1348589", 59);
            this.put("1348767", 60);
            this.put("1351397", 61);
            this.put("1362094", 62);
            this.put("1392855", 63);
            this.put("1399467", 64);
            this.put("1457705", 65);
            this.put("1506926", 66);
            this.put("1509530", 67);
            this.put("1652670", 68);
            this.put("1657117", 69);
            this.put("1657120", 70);
            this.put("1786669", 71);
            this.put("1791134", 72);
            this.put("1887279", 73);
            this.put("2289121", 74);
            this.put("2289182", 75);
            this.put("2289191", 76);
            this.put("2289194", 77);
            this.put("2289198", 78);
            this.put("2400701", 79);
            this.put("2422552", 80);
            this.put("2423962", 81);
            this.put("2425625", 82);
            this.put("2454957", 83);
            this.put("2456790", 84);
            this.put("2456802", 85);
            this.put("2456895", 86);
            this.put("2466968", 87);
            this.put("2469508", 88);
            this.put("2485369", 89);
            this.put("2577550", 90);
            this.put("2818641", 91);
            this.put("2820598", 92);
            this.put("2821045", 93);
            this.put("2821232", 94);
            this.put("2821234", 95);
            this.put("2823069", 96);
            this.put("2824674", 97);
            this.put("2825127", 98);
            this.put("2825132", 99);
            this.put("2825152", 100);
            this.put("2825153", 101);
            this.put("2825156", 102);
            this.put("2825165", 103);
            this.put("2825674", 104);
            this.put("2828097", 105);
            this.put("2829161", 106);
            this.put("2829647", 107);
            this.put("2830002", 108);
            this.put("2830311", 109);
            this.put("2830346", 110);
            this.put("2830613", 111);
            this.put("2830805", 112);
            this.put("2831234", 113);
            this.put("2831373", 114);
            this.put("2831480", 115);
            this.put("2832492", 116);
            this.put("2833635", 117);
            this.put("2834198", 118);
            this.put("2834248", 119);
            this.put("2834252", 120);
            this.put("2834254", 121);
            this.put("2834359", 122);
            this.put("2834697", 123);
            this.put("2834810", 124);
            this.put("2834931", 125);
            this.put("2835040", 126);
            this.put("2835116", 127);
            this.put("2835117", 128);
            this.put("2835164", 129);
            this.put("2835165", 130);
            this.put("2835495", 131);
            this.put("2835521", 132);
            this.put("2835645", 133);
            this.put("2835728", 134);
            this.put("2835738", 135);
            this.put("2835744", 136);
            this.put("2836094", 137);
            this.put("2836607", 138);
            this.put("2836677", 139);
            this.put("2837050", 140);
            this.put("2837679", 141);
            this.put("2837825", 142);
            this.put("2838438", 143);
            this.put("2838626", 144);
            this.put("2838627", 145);
            this.put("2838628", 146);
            this.put("2838680", 147);
            this.put("2839215", 148);
            this.put("2839217", 149);
            this.put("2839264", 150);
            this.put("2839388", 151);
            this.put("2840307", 152);
            this.put("2840460", 153);
            this.put("2840461", 154);
            this.put("2840492", 155);
            this.put("2840499", 156);
            this.put("2840500", 157);
            this.put("2840501", 158);
            this.put("2840502", 159);
            this.put("2840504", 160);
            this.put("2840944", 161);
            this.put("2841365", 162);
            this.put("2841425", 163);
            this.put("2841426", 164);
            this.put("2844458", 165);
            this.put("2844459", 166);
            this.put("2844461", 167);
            this.put("2844477", 168);
            this.put("2844488", 169);
            this.put("2844489", 170);
            this.put("2845047", 171);
            this.put("2847235", 172);
            this.put("2847874", 173);
            this.put("2847916", 174);
            this.put("2848190", 175);
            this.put("2848215", 176);
            this.put("2848229", 177);
            this.put("2848330", 178);
            this.put("2849576", 179);
            this.put("2850987", 180);
            this.put("2859501", 181);
            this.put("2859502", 182);
            this.put("2859503", 183);
            this.put("2859504", 184);
            this.put("2859505", 185);
            this.put("2859506", 186);
            this.put("2859507", 187);
            this.put("2859508", 188);
            this.put("2859509", 189);
            this.put("2859510", 190);
            this.put("2859511", 191);
            this.put("2859512", 192);
            this.put("2859513", 193);
            this.put("2859588", 194);
            this.put("2859785", 195);
            this.put("2860991", 196);
            this.put("2860992", 197);
            this.put("2923465", 198);
            this.put("2923466", 199);
            this.put("2924524", 200);
            this.put("2924526", 201);
            this.put("2924527", 202);
            this.put("2924539", 203);
            this.put("2924541", 204);
            this.put("2924542", 205);
            this.put("2924543", 206);
            this.put("2924965", 207);
            this.put("2924966", 208);
            this.put("2924967", 209);
            this.put("2924968", 210);
            this.put("2924969", 211);
            this.put("2924970", 212);
        }
    };
    public static Map<String, Integer> videoChannelCodes = new HashMap<String, Integer>(){
        {
            this.put("aiqiyi--1", 0);
            this.put("aiqiyi-0", 1);
            this.put("aiqiyi-1", 2);
            this.put("aiqiyi-10", 3);
            this.put("aiqiyi-11", 4);
            this.put("aiqiyi-12", 5);
            this.put("aiqiyi-13", 6);
            this.put("aiqiyi-14", 7);
            this.put("aiqiyi-15", 8);
            this.put("aiqiyi-16", 9);
            this.put("aiqiyi-17", 10);
            this.put("aiqiyi-18", 11);
            this.put("aiqiyi-19", 12);
            this.put("aiqiyi-2", 13);
            this.put("aiqiyi-20", 14);
            this.put("aiqiyi-21", 15);
            this.put("aiqiyi-22", 16);
            this.put("aiqiyi-23", 17);
            this.put("aiqiyi-24", 18);
            this.put("aiqiyi-25", 19);
            this.put("aiqiyi-26", 20);
            this.put("aiqiyi-27", 21);
            this.put("aiqiyi-28", 22);
            this.put("aiqiyi-29", 23);
            this.put("aiqiyi-3", 24);
            this.put("aiqiyi-30", 25);
            this.put("aiqiyi-30003", 26);
            this.put("aiqiyi-30005", 27);
            this.put("aiqiyi-30008", 28);
            this.put("aiqiyi-30010", 29);
            this.put("aiqiyi-31", 30);
            this.put("aiqiyi-32", 31);
            this.put("aiqiyi-33", 32);
            this.put("aiqiyi-34", 33);
            this.put("aiqiyi-4", 34);
            this.put("aiqiyi-40004", 35);
            this.put("aiqiyi-49999", 36);
            this.put("aiqiyi-5", 37);
            this.put("aiqiyi-6", 38);
            this.put("aiqiyi-7", 39);
            this.put("aiqiyi-8", 40);
            this.put("aiqiyi-9", 41);
            this.put("aiqiyi-97", 42);
            this.put("aiqiyi-99", 43);
            this.put("mango-0", 44);
            this.put("mango-1", 45);
            this.put("mango-105", 46);
            this.put("mango-111", 47);
            this.put("mango-116", 48);
            this.put("mango-117", 49);
            this.put("mango-120", 50);
            this.put("mango-2", 51);
            this.put("mango-20", 52);
            this.put("mango-3", 53);
            this.put("mango-50", 54);
        }
    };
    public static Map<String, Integer> colorCodes = new HashMap<String, Integer>(){
        {
            this.put("color0_r", 0);
            this.put("color0_g", 1);
            this.put("color0_b", 2);
            this.put("color1_r", 3);
            this.put("color1_g", 4);
            this.put("color1_b", 5);
            this.put("color2_r", 6);
            this.put("color2_g", 7);
            this.put("color2_b", 8);
        }
    };
    public static Map<String, Integer> accountCodes = new HashMap<String, Integer>(){
        {
            this.put("18125", 0);
            this.put("18943", 1);
            this.put("22005", 2);
            this.put("21563", 3);
            this.put("17196", 4);
            this.put("29815", 5);
            this.put("27419", 6);
            this.put("25874", 7);
            this.put("30539", 8);
            this.put("27295", 9);
            this.put("30037", 10);
            this.put("24035", 11);
            this.put("23882", 12);
            this.put("29932", 13);
            this.put("19317", 14);
            this.put("10971", 15);
            this.put("27486", 16);
            this.put("12311", 17);
            this.put("22597", 18);
            this.put("21330", 19);
            this.put("26598", 20);
            this.put("30371", 21);
            this.put("19941", 22);
            this.put("27605", 23);
            this.put("17270", 24);
            this.put("12234", 25);
            this.put("17878", 26);
            this.put("28257", 27);
            this.put("30632", 28);
            this.put("25991", 29);
            this.put("30701", 30);
            this.put("30336", 31);
            this.put("12796", 32);
            this.put("29379", 33);
            this.put("30495", 34);
            this.put("29758", 35);
            this.put("19316", 36);
            this.put("14355", 37);
            this.put("29001", 38);
            this.put("30126", 39);
            this.put("30892", 40);
            this.put("26320", 41);
            this.put("18489", 42);
            this.put("14164", 43);
            this.put("24696", 44);
            this.put("28941", 45);
            this.put("30511", 46);
            this.put("5713", 47);
            this.put("30928", 48);
            this.put("19761", 49);
            this.put("30592", 50);
            this.put("30081", 51);
            this.put("28769", 52);
            this.put("29788", 53);
            this.put("21133", 54);
            this.put("30679", 55);
            this.put("30393", 56);
            this.put("26323", 57);
            this.put("29336", 58);
            this.put("29935", 59);
            this.put("29030", 60);
            this.put("26550", 61);
            this.put("30394", 62);
            this.put("30823", 63);
            this.put("28466", 64);
            this.put("8340", 65);
            this.put("30460", 66);
            this.put("30739", 67);
            this.put("26048", 68);
            this.put("30765", 69);
            this.put("30596", 70);
            this.put("25809", 71);
            this.put("30808", 72);
            this.put("30605", 73);
            this.put("27165", 74);
            this.put("30868", 75);
            this.put("30518", 76);
            this.put("29408", 77);
            this.put("30601", 78);
            this.put("30900", 79);
            this.put("25984", 80);
            this.put("27568", 81);
            this.put("23937", 82);
            this.put("15334", 83);
            this.put("30345", 84);
            this.put("26595", 85);
            this.put("8154", 86);
            this.put("28264", 87);
            this.put("30848", 88);
            this.put("13566", 89);
            this.put("26726", 90);
            this.put("8302", 91);
            this.put("29406", 92);
            this.put("16315", 93);
            this.put("30625", 94);
            this.put("20619", 95);
            this.put("28528", 96);
            this.put("30253", 97);
            this.put("29808", 98);
            this.put("30809", 99);
            this.put("6286", 100);
            this.put("22757", 101);
            this.put("9876", 102);
            this.put("24779", 103);
            this.put("25806", 104);
            this.put("30929", 105);
            this.put("30956", 106);
            this.put("30691", 107);
            this.put("29706", 108);
            this.put("29651", 109);
            this.put("30438", 110);
            this.put("27911", 111);
            this.put("30493", 112);
            this.put("29519", 113);
            this.put("30220", 114);
            this.put("30812", 115);
            this.put("27684", 116);
            this.put("30636", 117);
            this.put("17638", 118);
            this.put("28594", 119);
            this.put("29558", 120);
            this.put("27463", 121);
            this.put("28925", 122);
            this.put("28420", 123);
            this.put("30099", 124);
            this.put("28523", 125);
            this.put("30688", 126);
            this.put("28432", 127);
            this.put("18028", 128);
            this.put("6209", 129);
            this.put("30783", 130);
            this.put("22412", 131);
            this.put("30684", 132);
            this.put("30621", 133);
            this.put("30734", 134);
            this.put("30807", 135);
            this.put("30794", 136);
            this.put("28180", 137);
            this.put("28544", 138);
            this.put("30186", 139);
            this.put("24090", 140);
            this.put("30111", 141);
            this.put("8657", 142);
            this.put("23977", 143);
            this.put("29491", 144);
            this.put("30327", 145);
            this.put("30249", 146);
            this.put("23461", 147);
            this.put("28597", 148);
            this.put("30498", 149);
            this.put("30109", 150);
            this.put("30279", 151);
            this.put("30100", 152);
            this.put("30732", 153);
            this.put("23031", 154);
            this.put("30497", 155);
            this.put("25886", 156);
            this.put("27453", 157);
            this.put("29845", 158);
            this.put("30378", 159);
            this.put("30257", 160);
            this.put("28881", 161);
            this.put("27241", 162);
            this.put("30219", 163);
            this.put("22006", 164);
            this.put("30217", 165);
            this.put("25215", 166);
            this.put("19217", 167);
            this.put("28515", 168);
            this.put("30185", 169);
            this.put("29858", 170);
            this.put("27452", 171);
            this.put("18089", 172);
            this.put("30411", 173);
            this.put("26151", 174);
            this.put("29699", 175);
            this.put("29889", 176);
            this.put("30573", 177);
            this.put("30017", 178);
            this.put("2292", 179);
            this.put("29427", 180);
            this.put("30560", 181);
            this.put("30626", 182);
            this.put("28628", 183);
            this.put("29534", 184);
            this.put("30515", 185);
            this.put("30023", 186);
            this.put("30374", 187);
            this.put("21271", 188);
            this.put("27321", 189);
            this.put("30290", 190);
            this.put("28643", 191);
            this.put("14356", 192);
            this.put("23880", 193);
            this.put("30836", 194);
            this.put("30569", 195);
            this.put("29900", 196);
            this.put("29879", 197);
            this.put("30499", 198);
            this.put("29894", 199);
            this.put("28970", 200);
            this.put("21944", 201);
            this.put("30705", 202);
            this.put("30187", 203);
            this.put("28503", 204);
            this.put("29028", 205);
            this.put("30128", 206);
            this.put("30182", 207);
            this.put("30237", 208);
            this.put("29448", 209);
            this.put("30825", 210);
            this.put("27884", 211);
            this.put("27932", 212);
            this.put("30704", 213);
            this.put("30695", 214);
            this.put("30461", 215);
            this.put("30218", 216);
            this.put("29862", 217);
            this.put("25509", 218);
            this.put("30329", 219);
            this.put("26077", 220);
            this.put("25495", 221);
            this.put("30115", 222);
            this.put("27002", 223);
            this.put("30935", 224);
            this.put("23469", 225);
            this.put("30331", 226);
            this.put("30188", 227);
            this.put("24296", 228);
            this.put("22042", 229);
            this.put("7962", 230);
            this.put("323", 231);
            this.put("30272", 232);
            this.put("18071", 233);
            this.put("18072", 234);
            this.put("8220", 235);
            this.put("8331", 236);
            this.put("23680", 237);
            this.put("6419", 238);
        }
    };
    public static Map<String, Integer> priceCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
        }
    };

    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        HashMap<String, String> retMap = new HashMap(F_MAX_SIZE);
        try {
            retMap = FeatureParse2.generateFeatureMapStatic(cf);
        }
        catch (Exception e) {
            logger.error("FeatureParse.FeatureParse2 static error", (Throwable)e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap(F_MAX_SIZE);
        try {
            retMap = FeatureParse2.generateFeatureMapDynamic(cf, staticCf);
        }
        catch (Exception e) {
            logger.error("FeatureParse.FeatureParse2 error", (Throwable)e);
        }
        return retMap;
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "b");
        System.out.println((String)FeatureParse.getValueSafety("a", map));
        Object m = null;
        System.out.println((String)FeatureParse.getValueSafety(null, map));
    }

    public static <T> String setJoin(Set<T> set, String sep) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{set, sep})) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (T s : set) {
            res.append(s).append(sep);
        }
        if (res.length() > 0) {
            return res.substring(0, res.length() - 1);
        }
        return res.toString();
    }

    public static <T> String userBehaviourCross(String exposeTopTarget, Set<T> behaviour) {
        String res = null;
        if (exposeTopTarget != null && exposeTopTarget.length() > 0 && behaviour != null && behaviour.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (T advert : behaviour) {
                if (advert == null || advert.toString().trim().length() <= 0) continue;
                sb.append(advert).append("_").append(exposeTopTarget).append(",");
            }
            if (sb.length() > 0) {
                res = sb.substring(0, sb.length() - 1);
            }
        }
        return res;
    }

    public static String getOperatorBrandMatch(String operator, String brand, String trade) {
        if (trade != null && trade.equals("16")) {
            if (operator == null || brand == null) {
                return "0";
            }
            if (operator.equals(brand)) {
                return "1";
            }
            return "2";
        }
        return "4";
    }

    public static String getOperatorName(String op) {
        if (op == null) {
            return "\u672a\u77e5";
        }
        if (op.equals("1")) {
            return "\u79fb\u52a8";
        }
        if (op.equals("2")) {
            return "\u8054\u901a";
        }
        if (op.equals("3")) {
            return "\u7535\u4fe1";
        }
        return "\u672a\u77e5";
    }

    public static String advertTagConcat(String sep, String ... tags) {
        StringBuilder res = new StringBuilder();
        for (String tag : tags) {
            if (tag == null || tag.trim().length() <= 0 || tag.trim().equals("null")) continue;
            res.append(tag).append(sep);
        }
        if (res.length() > 0) {
            return res.substring(0, res.length() - 1);
        }
        return res.toString();
    }

    public static String getAdAndSubType(Long advertId, String subType) {
        String ret = null;
        if (advertId != null) {
            Long retTmp = advertId + (FeatureParse.getSubType(subType) + 1L) * 1000000L;
            ret = retTmp + "";
        }
        return ret;
    }

    public static Long getSubType(String subType) {
        Long ret = 0L;
        if (subType != null) {
            ret = Long.valueOf(subType);
        }
        return ret;
    }

    public static Long getCtrIntervelLevel(Double ctr) {
        Long ret = null;
        ret = ctr == null ? Long.valueOf(-1L) : (ctr <= 0.999 ? Long.valueOf(Math.round(ctr * 100.0 / 3.0)) : Long.valueOf(-1L));
        return ret;
    }

    public static Long getCvrIntervelLevel(Double cvr) {
        Long ret = null;
        ret = cvr == null ? Long.valueOf(-1L) : (cvr <= 0.04 ? Long.valueOf(Math.round(cvr * 1000.0 / 4.0)) : (cvr <= 0.999 ? Long.valueOf(11L + Math.round((cvr - 0.04) * 100.0 / 3.0)) : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getOrderGmtIntervel(String date, String otherDate) {
        return LocalDateUtil.getIntervalMinutes((String)date, (String)otherDate, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
    }

    public static Long getOrderGmtIntervelLevel(String date, String otherDate) {
        Long ret = null;
        Long minutes = LocalDateUtil.getIntervalMinutes((String)date, (String)otherDate, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
        ret = minutes == null ? Long.valueOf(-1L) : (minutes <= 5L ? Long.valueOf(1L) : (minutes <= 10L ? Long.valueOf(2L) : (minutes <= 30L ? Long.valueOf(3L) : (minutes <= 60L ? Long.valueOf(4L) : Long.valueOf(99L)))));
        return ret;
    }

    public static Long getDayRankLevel(Long rank) {
        Long ret = null;
        ret = rank == null ? null : (rank <= 7L ? rank : Long.valueOf(-1L));
        return ret;
    }

    public static Long getRankLevel(Long rank) {
        Long ret = null;
        ret = rank == null ? null : (rank <= 15L ? rank : Long.valueOf(-1L));
        return ret;
    }

    public static Long getChargeStatus(Long chargeNums) {
        Long ret = null;
        ret = chargeNums == null || chargeNums < 1L ? Long.valueOf(0L) : Long.valueOf(1L);
        return ret;
    }

    public static Long getMatchStatus(String s1, String s2) {
        if (s1 == null) {
            return 0L;
        }
        if (!s1.equals(s2)) {
            return 1L;
        }
        return 2L;
    }

    public static Long getActivityChangeStatus(Long operatingActivityId, Long lastOperatingActivityId) {
        Long ret = null;
        ret = operatingActivityId == null || lastOperatingActivityId == null ? Long.valueOf(0L) : (operatingActivityId.equals(lastOperatingActivityId) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long getLastTagChangeStatus(String matchTagNums, String lastMatchTagNums) {
        Long ret = null;
        ret = matchTagNums == null || lastMatchTagNums == null ? Long.valueOf(0L) : (matchTagNums.equals(lastMatchTagNums) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long isOld(Date userLastlogbigintime, Date userRegtime) {
        Long dayIntervals;
        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{userLastlogbigintime, userRegtime}) && (dayIntervals = LocalDateUtil.getIntervalDays((Date)userLastlogbigintime, (Date)userRegtime)) != null) {
            ret = dayIntervals > 1L ? 1L : 0L;
        }
        return ret;
    }

    public static Long getCost(Long cost, Long price) {
        Long ret = null;
        if (cost != null && price != null && cost > 0L) {
            ret = new Double(Math.ceil(((double)price.longValue() + 1.0E-6) / (double)cost.longValue())).intValue();
        }
        return ret;
    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0L) {
            ret = new Double(Math.ceil(FeatureParse.log(lvalue.doubleValue(), 2 / 0))).intValue();
        }
        return ret;
    }

    public static <K, V> V getValueSafety(K key, Map<K, V> map) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{key, map})) {
            return null;
        }
        return map.get(key);
    }

    public static Map<String, Long> getMap(String keyList, String valueList) {
        String[] values;
        HashMap<String, Long> resMap = new HashMap<String, Long>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{keyList, valueList})) {
            return resMap;
        }
        String[] keys = keyList.split(",");
        if (keys.length != (values = valueList.split(",")).length) {
            return resMap;
        }
        for (int i = 0; i < keys.length; ++i) {
            Long value = null;
            try {
                value = Long.parseLong(values[i]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            resMap.put(keys[i], value);
        }
        return resMap;
    }

    public static String getLevel(String key, String idlist, String valueList) {
        String[] valueArr;
        String s = "";
        if (idlist == null || valueList == null || idlist.isEmpty() || valueList.isEmpty()) {
            return null;
        }
        String[] idArr = idlist.split(",");
        if (idArr.length != (valueArr = valueList.split(",")).length) {
            return null;
        }
        for (int i = 0; i < idArr.length; ++i) {
            double value = 0.0;
            try {
                value = Double.parseDouble(valueArr[i]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            catch (NullPointerException e) {
                continue;
            }
            s = s + idArr[i] + "&" + String.valueOf(FeatureParse.discretization(key, value)) + ",";
        }
        if (!s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static int discretization(String key, double value) {
        int class_id = 0;
        switch (key) {
            case "launch_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 1.0 & value <= 2.0) {
                    class_id = 3;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 4;
                    break;
                }
                if (value > 3.0 & value <= 4.0) {
                    class_id = 5;
                    break;
                }
                if (value > 4.0 & value <= 5.0) {
                    class_id = 6;
                    break;
                }
                if (value > 5.0 & value <= 6.0) {
                    class_id = 7;
                    break;
                }
                if (value > 6.0 & value <= 7.0) {
                    class_id = 8;
                    break;
                }
                if (value > 7.0 & value <= 18.0) {
                    class_id = 9;
                    break;
                }
                if (value > 18.0 & value <= 50.0) {
                    class_id = 10;
                    break;
                }
                if (value > 50.0 & value <= 150.0) {
                    class_id = 11;
                    break;
                }
                if (value > 150.0 & value <= 300.0) {
                    class_id = 12;
                    break;
                }
                class_id = 13;
                break;
            }
            case "click_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 3;
                    break;
                }
                if (value > 3.0 & value <= 4.0) {
                    class_id = 4;
                    break;
                }
                if (value > 4.0 & value <= 5.0) {
                    class_id = 5;
                    break;
                }
                if (value > 5.0 & value <= 6.0) {
                    class_id = 6;
                    break;
                }
                if (value > 6.0 & value <= 8.0) {
                    class_id = 7;
                    break;
                }
                if (value > 8.0 & value <= 15.0) {
                    class_id = 8;
                    break;
                }
                if (value > 15.0 & value <= 80.0) {
                    class_id = 9;
                    break;
                }
                if (value > 80.0 & value <= 225.0) {
                    class_id = 10;
                    break;
                }
                class_id = 11;
                break;
            }
            case "effect_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 1.0 & value <= 2.0) {
                    class_id = 3;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 4;
                    break;
                }
                if (value > 4.0 & value <= 15.0) {
                    class_id = 5;
                    break;
                }
                if (value > 15.0 & value <= 25.0) {
                    class_id = 6;
                    break;
                }
                if (value > 25.0 & value <= 70.0) {
                    class_id = 7;
                    break;
                }
                if (value > 70.0 & value <= 150.0) {
                    class_id = 8;
                    break;
                }
                if (value > 150.0 & value <= 225.0) {
                    class_id = 9;
                    break;
                }
                class_id = 10;
                break;
            }
            case "score": {
                class_id = value > -1.0E8 & value <= -471.0 ? 1 : (value > -471.0 & value <= -331.0 ? 2 : (value > -331.0 & value <= -168.0 ? 3 : (value > -168.0 & value <= -52.0 ? 4 : (value > -52.0 & value <= -19.0 ? 5 : (value > -19.0 & value <= -8.0 ? 6 : (value > -8.0 & value <= -4.0 ? 7 : (value > -4.0 & value <= 1.0 ? 8 : (value > 1.0 & value <= 2.0 ? 9 : (value > 2.0 & value <= 17.0 ? 10 : (value > 17.0 & value <= 42.0 ? 11 : (value > 42.0 & value <= 73.0 ? 12 : (value > 73.0 & value <= 126.0 ? 13 : (value > 126.0 & value <= 284.0 ? 14 : 15)))))))))))));
            }
        }
        return class_id;
    }

    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {
        String ret = null;
        try {
            Object tag;
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String((Long)ubpMap.get(statType).get("0"));
            }
            if (dimType == 1 && ubpMap != null && (tag = FeatureParse.getTag(tags)) != null) {
                ret = ubpMap.get(statType).get(tag) + "";
                if (((String)tag).length() == 10 && ret == null) {
                    String string = ((String)tag).substring(0, 5);
                    ret = DataUtil.Long2String((Long)ubpMap.get(statType).get(string));
                }
            }
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry entry : ubpMap.get(statType).entrySet()) {
                    String string = (String)entry.getKey() + "_" + entry.getValue() + ",";
                    ret = ret + string;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                HashMap<Long, Long> levelCntMap = new HashMap<Long, Long>();
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag2 = entry.getKey();
                    Long ctrLevel = FeatureParse.bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel == null || tag2 == "0") continue;
                    if (!levelCntMap.containsKey(ctrLevel)) {
                        levelCntMap.put(ctrLevel, 0L);
                    }
                    levelCntMap.put(ctrLevel, (Long)levelCntMap.get(ctrLevel) + 1L);
                }
                for (Map.Entry entry : levelCntMap.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    Long cntLevel = FeatureParse.bucket((Long)entry.getValue(), cntBucket);
                    String v = (Long)entry.getKey() * 100L + cntLevel + ",";
                    ret = ret + v;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getTag(String tags) {
        Object[] tagArr;
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tags) && AssertUtil.isNotEmpty((Object[])(tagArr = tags.split(",")))) {
            for (int i = 0; i < tagArr.length; ++i) {
                String tmp = FeatureParse.validTag((String)tagArr[i]);
                if (tmp == null) continue;
                ret = FeatureParse.validTag((String)tagArr[i]);
            }
        }
        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tag) && tag.contains(".")) {
            ret = tag;
        }
        return ret;
    }

    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds, String uILaunchPv, String uIClickPv, String uIEffectPv) {
        HashMap<String, Map<String, Long>> ret = new HashMap<String, Map<String, Long>>();
        ret.put("ctr", new HashMap());
        ret.put("cvr", new HashMap());
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{uIIds, uILaunchPv, uIClickPv, uIEffectPv})) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");
            if (uIIdsArr.length > 0 && uIIdsArr.length == uILaunchPvArr.length && uIIdsArr.length == uIClickPvArr.length && uIIdsArr.length == uIEffectPvArr.length) {
                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;
                for (int i = 0; i < uIIdsArr.length; ++i) {
                    String id = uIIdsArr[i];
                    Long launchPv = DataUtil.str2Long((String)uILaunchPvArr[i], (Long)0L);
                    Long clickPv = DataUtil.str2Long((String)uIClickPvArr[i], (Long)0L);
                    Long effectPv = DataUtil.str2Long((String)uIEffectPvArr[i], (Long)0L);
                    Double ctr = FeatureParse.getCtrOrCvr(launchPv, clickPv);
                    Double cvr = FeatureParse.getCtrOrCvr(clickPv, effectPv);
                    Long ctrBucketLevel = FeatureParse.bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = FeatureParse.bucket(cvr, userCvrBucket);
                    ((Map)ret.get("ctr")).put(id, ctrBucketLevel);
                    ((Map)ret.get("cvr")).put(id, cvrBucketLevel);
                    launchAccPv = launchAccPv + launchPv;
                    clickAccPv = clickAccPv + clickPv;
                    effectAccPv = effectAccPv + effectPv;
                }
                Double ctr = FeatureParse.getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = FeatureParse.getCtrOrCvr(clickAccPv, effectAccPv);
                Long ctrBucketLevel = FeatureParse.bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = FeatureParse.bucket(cvr, userCvrBucket);
                ((Map)ret.get("ctr")).put("0", ctrBucketLevel);
                ((Map)ret.get("cvr")).put("0", cvrBucketLevel);
            }
        }
        return ret;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{firstPv, secondPv}) && firstPv > 0L) {
            ret = DataUtil.division((Long)secondPv, (Long)firstPv);
        }
        return ret;
    }

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > (long)bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucketBSearch(Double value, double[] arr) {
        if (value == null || arr == null || arr.length == 0) {
            return 0L;
        }
        int low = 0;
        int high = arr.length - 1;
        if (value > arr[arr.length - 1]) {
            return (long)arr.length + 1L;
        }
        while (low <= high) {
            int mid = low + (high - low >> 1);
            if (arr[mid] >= value) {
                if (mid == 0 || arr[mid - 1] < value) {
                    return (long)mid + 1L;
                }
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return 0L;
    }

    public static <T> Map<T, Long> mapBucket(Map<T, Double> map, double[] bucketList) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{map, bucketList})) {
            return null;
        }
        HashMap<T, Long> resMap = new HashMap<T, Long>();
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            resMap.put(entry.getKey(), FeatureParse.bucketBSearch(entry.getValue(), bucketList));
        }
        return resMap;
    }

    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    public static String getSlotAreaType(Integer slotLength, Integer slotWidth) {
        int ret1 = 12;
        if (slotLength == null || slotWidth == null) {
            return String.valueOf(ret1);
        }
        try {
            Integer area = slotLength * slotWidth;
            if (area >= 0 && area <= 500000) {
                ret1 = area / 50000;
            }
            if (area > 500000 && area != null) {
                ret1 = 11;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(ret1);
    }

    public static String categoryIdAndCnt(Map<String, Long> categoryCount, Integer categoryType) {
        String ret1 = null;
        if (categoryCount == null) {
            return ret1;
        }
        if (categoryType == 1) {
            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    valueRet = value >= 1L && value <= 3L ? "g1" : (value >= 4L && value <= 10L ? "g2" : (value >= 11L && value <= 20L ? "g3" : "g4"));
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    valueRet = value == 1L ? "g1" : (value == 2L || value == 3L ? "g2" : (value >= 4L && value <= 8L ? "g3" : "g4"));
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret1;
    }

    public static Long getResourceOrderRank(String operatingResource, Map<String, Long> dayResourceOrderRank) {
        Long rank;
        Long ret = null;
        ret = operatingResource == null || dayResourceOrderRank == null ? null : ((rank = dayResourceOrderRank.get(operatingResource)) == null || rank < 1L ? Long.valueOf(1L) : (rank <= 7L ? Long.valueOf(rank + 1L) : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getResourceOrderGmtIntervelLevel(String operatingResource, String currentGmtCreateTime, Map<String, String> resourceLastGmtCreateTime) {
        Long ret = null;
        if (operatingResource == null || currentGmtCreateTime == null || resourceLastGmtCreateTime == null) {
            ret = null;
        } else {
            String lastGmtCreateTime = resourceLastGmtCreateTime.get(operatingResource);
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long timeStamp = LocalDateUtil.getTimeMillis((String)currentGmtCreateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);
                if (timeStamp == null || otherTimeStamp == null) {
                    return ret;
                }
                Long seconds = Math.abs((timeStamp - otherTimeStamp) / 1000L);
                ret = seconds == null ? Long.valueOf(-1L) : (seconds <= 5L ? Long.valueOf(1L) : (seconds <= 10L ? Long.valueOf(2L) : (seconds <= 30L ? Long.valueOf(3L) : (seconds <= 60L ? Long.valueOf(4L) : (seconds <= 300L ? Long.valueOf(5L) : (seconds <= 600L ? Long.valueOf(6L) : (seconds <= 1800L ? Long.valueOf(7L) : (seconds <= 3600L ? Long.valueOf(8L) : (seconds <= 18000L ? Long.valueOf(9L) : (seconds <= 36000L ? Long.valueOf(10L) : (seconds <= 54000L ? Long.valueOf(11L) : (seconds <= 72000L ? Long.valueOf(12L) : (seconds <= 86400L ? Long.valueOf(13L) : (seconds <= 129600L ? Long.valueOf(14L) : (seconds <= 172800L ? Long.valueOf(15L) : Long.valueOf(99L))))))))))))))));
            }
        }
        return ret;
    }

    public static Long getResourceOrderGmtIntervelLevelOneId(String operatingResource, String currentGmtCreateTime, Map<String, String> resourceLastGmtCreateTime) {
        Long ret = null;
        if (operatingResource == null || currentGmtCreateTime == null || resourceLastGmtCreateTime == null) {
            ret = null;
        } else {
            String lastGmtCreateTime = resourceLastGmtCreateTime.get(operatingResource);
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long timeStamp = LocalDateUtil.getTimeMillis((String)currentGmtCreateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Long otherTimeStamp = LocalDateUtil.getTimeMillis((String)lastGmtCreateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                if (timeStamp == null || otherTimeStamp == null) {
                    return ret;
                }
                Long seconds = Math.abs((timeStamp - otherTimeStamp) / 1000L);
                ret = seconds == null ? Long.valueOf(-1L) : (seconds <= 5L ? Long.valueOf(1L) : (seconds <= 10L ? Long.valueOf(2L) : (seconds <= 30L ? Long.valueOf(3L) : (seconds <= 60L ? Long.valueOf(4L) : (seconds <= 300L ? Long.valueOf(5L) : (seconds <= 600L ? Long.valueOf(6L) : (seconds <= 1800L ? Long.valueOf(7L) : (seconds <= 3600L ? Long.valueOf(8L) : (seconds <= 18000L ? Long.valueOf(9L) : (seconds <= 36000L ? Long.valueOf(10L) : (seconds <= 54000L ? Long.valueOf(11L) : (seconds <= 72000L ? Long.valueOf(12L) : (seconds <= 86400L ? Long.valueOf(13L) : (seconds <= 129600L ? Long.valueOf(14L) : (seconds <= 172800L ? Long.valueOf(15L) : Long.valueOf(99L))))))))))))))));
            }
        }
        return ret;
    }

    public static Long getResourceLastOrderIsClick(String operatingResource, Map<String, String> resourceLastLaunchOrderId, Map<String, String> resourceLastClickOrderId) {
        Long ret = null;
        if (operatingResource == null || resourceLastLaunchOrderId == null || resourceLastClickOrderId == null) {
            ret = null;
        } else {
            String lastLaunchOrderId = resourceLastLaunchOrderId.get(operatingResource + "-770301_1");
            String lastClickOrderId = resourceLastClickOrderId.get(operatingResource + "-770301_2");
            ret = lastLaunchOrderId == null ? null : (lastClickOrderId == null ? Long.valueOf(0L) : (lastLaunchOrderId.equals(lastClickOrderId) ? Long.valueOf(1L) : Long.valueOf(0L)));
        }
        return ret;
    }

    public static Long getResourceLastOrderIsConvert(String operatingResource, Map<String, String> resourceLastLaunchOrderId, Map<String, String> resourceLastConvertOrderId) {
        Long ret = null;
        if (operatingResource == null || resourceLastLaunchOrderId == null || resourceLastConvertOrderId == null) {
            ret = null;
        } else {
            String lastLaunchOrderId = resourceLastLaunchOrderId.get(operatingResource + "-770301_1");
            String lastConvertOrderId = resourceLastConvertOrderId.get(operatingResource + "-770301_3");
            ret = lastLaunchOrderId == null ? null : (lastConvertOrderId == null ? Long.valueOf(0L) : (lastLaunchOrderId.equals(lastConvertOrderId) ? Long.valueOf(1L) : Long.valueOf(0L)));
        }
        return ret;
    }

    public static Long getResourceChargeCnt(String operatingResource, Map<String, Long> dayResourceChargeCnt) {
        Long cnt;
        Long ret = null;
        ret = operatingResource == null || dayResourceChargeCnt == null ? null : ((cnt = dayResourceChargeCnt.get(operatingResource)) == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= 7L ? cnt : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getResourceConvertCnt(String operatingResource, Map<String, Long> dayResourceConvertCnt) {
        Long cnt;
        Long ret = null;
        ret = operatingResource == null || dayResourceConvertCnt == null ? null : ((cnt = dayResourceConvertCnt.get(operatingResource)) == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= 7L ? cnt : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getLastResourceEqualStatus(String operatingResource, String lastOperatingResource) {
        Long ret = null;
        ret = operatingResource == null && lastOperatingResource == null ? null : (operatingResource != null && lastOperatingResource != null ? (operatingResource.equals(lastOperatingResource) ? Long.valueOf(1L) : Long.valueOf(0L)) : Long.valueOf(0L));
        return ret;
    }

    public static Long getNewTradeOrderRank(String operatingNewTrade, Map<String, Long> newTradeDayOrderRank) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, newTradeDayOrderRank})) {
            Long rank = newTradeDayOrderRank.get(operatingNewTrade + "-660101");
            ret = rank == null || rank < 1L ? Long.valueOf(1L) : (rank <= 7L ? Long.valueOf(rank + 1L) : Long.valueOf(99L));
        }
        return ret;
    }

    public static Long getLastNewTradeEqualStatus(String operatingNewTrade, String lastOperatingNewTrade) {
        Long ret = 0L;
        if (AssertUtil.isAllEmpty((Object[])new Object[]{operatingNewTrade, lastOperatingNewTrade})) {
            ret = null;
        } else if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, lastOperatingNewTrade})) {
            ret = operatingNewTrade.equals(lastOperatingNewTrade) ? Long.valueOf(1L) : Long.valueOf(0L);
        }
        return ret;
    }

    public static Long getLastNewTradeGmtIntervelLevel(String operatingNewTrade, String currentGmtCreateTime, Map<String, String> newTradeLastGmtCreateTime) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, currentGmtCreateTime, newTradeLastGmtCreateTime})) {
            String lastGmtCreateTime = newTradeLastGmtCreateTime.get(operatingNewTrade + "-660301");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long otherTimeStamp;
                Long timeStamp = LocalDateUtil.getTimeMillis((String)currentGmtCreateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                if (AssertUtil.isAnyEmpty((Object[])new Object[]{timeStamp, otherTimeStamp = Long.valueOf(lastGmtCreateTime)})) {
                    return ret;
                }
                Long seconds = Math.abs((timeStamp - otherTimeStamp) / 1000L);
                ret = seconds == null ? Long.valueOf(-1L) : (seconds <= 5L ? Long.valueOf(1L) : (seconds <= 10L ? Long.valueOf(2L) : (seconds <= 30L ? Long.valueOf(3L) : (seconds <= 60L ? Long.valueOf(4L) : (seconds <= 300L ? Long.valueOf(5L) : (seconds <= 600L ? Long.valueOf(6L) : (seconds <= 1800L ? Long.valueOf(7L) : (seconds <= 3600L ? Long.valueOf(8L) : (seconds <= 18000L ? Long.valueOf(9L) : (seconds <= 36000L ? Long.valueOf(10L) : (seconds <= 54000L ? Long.valueOf(11L) : (seconds <= 72000L ? Long.valueOf(12L) : (seconds <= 86400L ? Long.valueOf(13L) : Long.valueOf(99L))))))))))))));
            }
        }
        return ret;
    }

    public static String getCtrOrCvrInKey(Map<String, Long> firstMap, Map<String, Long> secondMap, double[] statCtrOrCvrBucket) {
        String ret = null;
        try {
            if (AssertUtil.isNotEmpty(firstMap)) {
                for (Map.Entry<String, Long> entry : firstMap.entrySet()) {
                    String key = entry.getKey();
                    if (key == null) continue;
                    Long firstPv = entry.getValue();
                    if (firstPv == null) {
                        firstPv = 0L;
                    }
                    Long secondPv = 0L;
                    if (AssertUtil.isNotEmpty(secondMap)) {
                        secondPv = secondMap.getOrDefault(key, 0L);
                    }
                    Double value = FeatureParse.getCtrOrCvr(firstPv, secondPv);
                    Long valueLevel = FeatureParse.bucket(value, statCtrOrCvrBucket);
                    String tmpRet = key + "&" + DataUtil.Long2String((Long)valueLevel);
                    ret = ret + "," + tmpRet;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getStatInNewTrade(String statType, Map<String, Map<String, Long>> newTradeMap) {
        String ret = null;
        try {
            if (AssertUtil.isNotEmpty(newTradeMap)) {
                Map<String, Long> launchMap = newTradeMap.get("launch");
                Map<String, Long> clickMap = newTradeMap.get("click");
                Map<String, Long> effectMap = newTradeMap.get("effect");
                if (statType == "ctr") {
                    if (AssertUtil.isNotEmpty(launchMap)) {
                        ret = FeatureParse.getCtrOrCvrInKey(launchMap, clickMap, statCtrBucket);
                    }
                } else if (statType == "cvr" && AssertUtil.isNotEmpty(clickMap)) {
                    ret = FeatureParse.getCtrOrCvrInKey(clickMap, effectMap, statCvrBucket);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getStatInAppTag(String statType, Map<String, Map<String, Long>> appTagMap) {
        String ret = null;
        try {
            if (AssertUtil.isNotEmpty(appTagMap)) {
                Map<String, Long> launchMap = appTagMap.get("launch");
                Map<String, Long> clickMap = appTagMap.get("click");
                Map<String, Long> effectMap = appTagMap.get("effect");
                if (statType == "ctr") {
                    if (AssertUtil.isNotEmpty(launchMap)) {
                        ret = FeatureParse.getCtrOrCvrInKey(launchMap, clickMap, statCtrBucket);
                    }
                } else if (statType == "cvr" && AssertUtil.isNotEmpty(clickMap)) {
                    ret = FeatureParse.getCtrOrCvrInKey(clickMap, effectMap, statCvrBucket);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getCrossFeature(String ids, String id0) {
        String ret = null;
        if (ids == null || "".equals(ids) || " ".equals(ids) || ",".equals(ids) || id0 == null || "".equals(id0) || " ".equals(id0)) {
            ret = "null";
        } else {
            ArrayList<String> crossFeature = new ArrayList<String>();
            try {
                for (String id : ids.split(",")) {
                    if (id == "" || id == " ") continue;
                    crossFeature.add(id + "_" + id0);
                }
                if (crossFeature.size() > 0) {
                    ret = Joiner.on((String)",").skipNulls().join(crossFeature);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ret == null || ret == "" || ret == " " || ret == ",") {
            ret = "null";
        }
        if (!ret.equalsIgnoreCase("null")) {
            ret = "null," + ret;
        }
        return ret;
    }

    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (String cateKey : actMap.keySet()) {
                Integer cateValue = actMap.getIntValue(cateKey);
                if (!category.containsKey(cateKey)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + FeatureParse.bucket(cateValue, buckets);
                stringBuilder.append(value);
                stringBuilder.append(",");
            }
        }
        catch (Exception e) {
            return null;
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    public static String getUserCategoryLaunchTrade(JSONObject actMap, String category) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category})) {
            return "-1";
        }
        if (actMap.getIntValue(category) <= 1) {
            return "0";
        }
        return "1";
    }

    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, Integer> entry : actMap.entrySet()) {
                String cateKey = entry.getKey();
                Integer cateValue = entry.getValue();
                if (!category.containsKey(cateKey)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + FeatureParse.bucket(cateValue, buckets);
                stringBuilder.append(value);
                stringBuilder.append(",");
            }
        }
        catch (Exception e) {
            return null;
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    public static String getCategoryLevelByCalcBucket(JSONObject actMap1, JSONObject actMap2, Map<String, Integer> category, double[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap1, actMap2, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (String cateKey : actMap1.keySet()) {
                double cateValue1 = Long.parseLong(actMap1.getOrDefault((Object)cateKey, (Object)0).toString());
                if (cateValue1 == 0.0) continue;
                double cateValue2 = Long.parseLong(actMap2.getOrDefault((Object)cateKey, (Object)0).toString());
                if (!category.containsKey(cateKey) || !(cateValue2 > 5.0)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + FeatureParse.bucket(cateValue2 / cateValue1, buckets);
                stringBuilder.append(value);
                stringBuilder.append(",");
            }
        }
        catch (Exception e) {
            logger.warn("getCategoryLevelByCalcBucket failed=" + actMap2);
            return null;
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, double[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (String cateKey : actMap.keySet()) {
                Double cateValue = actMap.getDouble(cateKey);
                if (!category.containsKey(cateKey)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + FeatureParse.bucket(cateValue, buckets);
                stringBuilder.append(value);
                stringBuilder.append(",");
            }
        }
        catch (Exception e) {
            return null;
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    public static Long getUserSignRatioBucket(Long signEffect, Long issueEffect, double[] bucket) {
        long ret = 0L;
        if (signEffect == null || issueEffect == null || bucket == null || issueEffect == 0L) {
            return ret;
        }
        return FeatureParse.bucket(signEffect.doubleValue() / (double)issueEffect.longValue(), bucket);
    }

    public static int countFeatures(String valueList) {
        if (valueList == null) {
            return -1;
        }
        if (valueList.isEmpty()) {
            return 0;
        }
        String[] idArr = valueList.split(",");
        if (idArr == null) {
            return -1;
        }
        return idArr.length;
    }

    private static <T> Set<String> getSetIntersection(Set<T> base, Set<String> rawSet) {
        HashSet<String> advertSet = new HashSet<String>();
        if (base != null && base.size() > 0 && rawSet != null && rawSet.size() > 0) {
            for (T b : base) {
                if (!rawSet.contains(b.toString())) continue;
                advertSet.add(b.toString());
            }
        }
        return advertSet;
    }

    private static <T> Set<T> getSetSubtract(Set<T> base, Set<T> exclude) {
        Set<T> res = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{base, exclude})) {
            res = new HashSet<T>();
            for (T b : base) {
                if (exclude.contains(b)) continue;
                res.add(b);
            }
        } else {
            res = base;
        }
        return res;
    }

    private static Set<String> getConvertAdvertSet(String convertStr, Set<String> rawSet) {
        HashSet<String> advertSet = new HashSet<String>();
        if (convertStr.length() > 0) {
            String[] tmpArray;
            String tmp = convertStr.replaceAll("[{}]", "");
            for (String arr : tmpArray = tmp.split(",")) {
                String[] tmpArray2;
                if (!arr.contains("=") && rawSet.contains(arr)) {
                    advertSet.add(arr);
                }
                if (!arr.contains("=") || (tmpArray2 = arr.split("=")).length < 2 || !rawSet.contains(tmpArray2[1])) continue;
                advertSet.add(tmpArray2[1]);
            }
        }
        return advertSet;
    }

    public static String getFeatureCross(String str0, String str1) {
        String tmp_str0 = str0 == null ? "nu" : str0;
        String tmp_str1 = str1 == null ? "nu" : str1;
        String ret = tmp_str0 + "_" + tmp_str1;
        return ret;
    }
}

