package cn.com.duiba.nezha.alg.feature.parse.v2;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;

import cn.com.duiba.nezha.alg.feature.vo.v2023.ActContextFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.ActFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdContextFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserBehaviorSubFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserProfileSubFeature;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.*;

/**
 * Created by pc on 2019/2/21.
 */
public class ActFeatureParseV2 extends BaseParse {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(ActFeatureParseV2.class);


    public static Map<String, String> generateFeatureMapStatic(ActContextFeatureDoV3 contextDo,
                                                               DmpFeatureDto dmpFeatureDto

    ) {

        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);


        if (contextDo == null) {
            return retMap;
        }

        // 1、解析上下文
        Map<String, String> contextFeatureMap = retMap = contextDo.parse();
        retMap.putAll(contextFeatureMap);

        // 2、解析用户DMP特征
        Map<String, String> deviceFeatureMap = DeviceFeatureParseV2.parse(dmpFeatureDto, contextDo.getExternalAdBlockId());
        retMap.putAll(deviceFeatureMap);

        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(ActFeatureDoV3 actFeatureDoV3, DmpFeatureDto  data2, ActContextFeatureDoV3 data3) {
        Map<String, String> retMap = new HashMap<>(100);
        if (actFeatureDoV3 == null) {
            return retMap;
        }
        // 1、活动特征
        Map<String, String> adFeatureMap = actFeatureDoV3.parse(data2, data3);
        retMap.putAll(adFeatureMap);
        // 2、活动交叉特征

        return retMap;
    }


    public static void main(String[] args) {
        List<String> reqList = new ArrayList<>();
        reqList.add("100");
        reqList.add("101");

        Long activityId = 101L;
        String hisLastActivity = reqList.get(reqList.size() - 1);

        Long hisLastActivityLong = Long.valueOf(hisLastActivity);

        System.out.println("hisLastActivit=" + hisLastActivity);
        System.out.println("hisLastActivityLong=" + hisLastActivityLong);

        System.out.println("hisLastActivit=" + activityId.equals(hisLastActivity));
        System.out.println("hisLastActivityLong=" + activityId.equals(hisLastActivityLong));
    }
}


