package cn.com.duiba.nezha.alg.feature.coder;


import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCodeInfo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSON;

import java.lang.reflect.Array;
import java.util.*;

public class FeatureCoder extends FeatureCoderBase {

    private static int F_MAX_SIZE = 64;

    public static Map tmpMap = new HashMap();


    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {

        return code(list, featureMap, null);
    }

    public static CodeResult code(List<FeatureBaseType> list, FeatureMapDo featureMap) throws Exception {

        if (featureMap == null) {
            return code(list, null, null);
        } else {
            return code(list, featureMap.staticFeatureMap, featureMap.dynamicFeatureMap);
        }
    }


    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap) throws Exception {

        CodeResult codeResult = new CodeResult();


        List<Integer> indices = new ArrayList<>(F_MAX_SIZE);//field起始+field内编码
        List<Double> values = new ArrayList<>(F_MAX_SIZE);
        List<String> fields = new ArrayList<>(F_MAX_SIZE);
        List<Integer> pLenList = new ArrayList<>(F_MAX_SIZE);//field起始
        List<Set<Integer>> ret = new ArrayList<>(F_MAX_SIZE);

        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }
        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }
        for (FeatureBaseType featureBaseType : list) {

            String value = dynamicFeatureMap.get(featureBaseType.getName());
            if (value == null) {
                value = staticFeatureMap.get(featureBaseType.getName());
            }


            Set<Integer> retSub = featureBaseType.code(value, pLenList, indices, values);
            ret.add(retSub);
            for (int i = 0; i < retSub.size(); i++) {
                fields.add(featureBaseType.getName());
            }
//            System.out.println("fieldName="+featureBaseType.getName()+",fieldValue="+value+","+JSON.toJSONString(pLenList)+","+JSON.toJSONString(indices));

        }

        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, pLenList, fields));
        codeResult.setFeatureSet(ret);
        return codeResult;
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap) throws Exception {

        CodeResult codeResult = new CodeResult();

        List<Integer> indices = new ArrayList<>(F_MAX_SIZE);
        List<Double> values = new ArrayList<>(F_MAX_SIZE);
        List<String> fields = new ArrayList<>(F_MAX_SIZE);
        List<Set<Integer>> ret = new ArrayList<>(F_MAX_SIZE);

        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }
        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }

        Map<String, Map<Integer, Double>> fieldFeatureMap = new HashMap<>();

        for (FeatureBaseType featureBaseType : list) {

            String value = dynamicFeatureMap.get(featureBaseType.getName());
            if (value == null) {
                value = staticFeatureMap.get(featureBaseType.getName());
            }


            Set<Integer> retSub = featureBaseType.code(value);
            ret.add(retSub);
            List<Integer> retSubList = new ArrayList<>(retSub);

            Map<Integer, Double> subFieldFeatureMap = new HashMap<>();
            for (int i = 0; i < retSub.size(); i++) {
                indices.add(retSubList.get(i));

                double weight = MathUtil.division(1.0, retSub.size(), 6);
                values.add(weight);
                fields.add(featureBaseType.getName());

                subFieldFeatureMap.put(retSubList.get(i), weight);

            }

            fieldFeatureMap.put(featureBaseType.getName(), subFieldFeatureMap);
        }

        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, fields, 10000 * 1000));
        codeResult.setFeatureSet(ret);
        codeResult.setFieldFeatureMap(fieldFeatureMap);
        return codeResult;
    }


    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        return codeOfEachField(list, featureMap, null);
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, FeatureMapDo featureMap) throws Exception {

        if (featureMap == null) {
            return codeOfEachField(list, null, null);
        } else {
            return codeOfEachField(list, featureMap.staticFeatureMap, featureMap.dynamicFeatureMap);
        }
    }

    public static Map<String, Set<String>> getFeatures(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        Map<String, Set<String>> ret = new HashMap<>();

        for (FeatureBaseType featureBaseType : list) {

            String value = featureMap.get(featureBaseType.getName());

            Set<String> retSub = featureBaseType.parseFeatureValues(value);

            ret.put(featureBaseType.getName(), retSub);
        }
        return ret;
    }

    public static void main(String[] args) {
        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f101001", "16601,18491,23105,24732,7967,300");
        featureMap.put("f101002", "100");
        featureMap.put("f305001", "8");
        featureMap.put("f501001", "UNKONWN");
        featureMap.put(null, "2");


        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f101001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");

        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(21);
        featureBaseType2.setName("f101002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(100000);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");


        String samples="{\"f431001\":\"1\",\"f431003\":\"0\",\"f431002\":\"1\",\"f213001\":\"109,225,1,241,37\",\"f213002\":\"109,229,2113\",\"f213003\":\"226,1,241,37\",\"f213004\":\"109,229\",\"f603002\":\"2\",\"f603001\":\"2\",\"f110001\":\"0\",\"f809001\":\"1\",\"f809002\":\"0\",\"f144009\":\"0\",\"f144007\":\"0\",\"f144008\":\"0\",\"f144005\":\"0\",\"f144006\":\"0\",\"f144003\":\"0\",\"f144004\":\"0\",\"f144001\":\"0\",\"f144002\":\"0\",\"f201001\":\"77197\",\"f660001\":\"8\",\"f144010\":\"0\",\"f810001\":\"1\",\"f810002\":\"0\",\"f306001\":\"2\",\"chargeType\":\"1\",\"f601001\":\"2\",\"f601002\":\"2\",\"f410001\":\"4\",\"f811001\":\"104\",\"f212004\":\"1940,1731,400,2776,458,628,1598,476,286,1902,173,933,3707,4372,306,325,135,40,4448,3346,4429,2415,819,4524,1540,667,59,705,363,192,496\",\"f212003\":\"249,40,458,344,173,97,211,230,2,420,78,382,59\",\"f212002\":\"1940,1731,3878,401,1141,895,2776,458,249,97,628,439,1408,1598,476,286,1902,3365,173,933,3707,2320,4144,4372,344,4504,306,325,135,40,4448,3346,4429,2415,819,4524,1540,229,667,59,705,363,192,495\",\"f212001\":\"249,40,458,344,173,97,211,230,2,420,78,382,59\",\"f602001\":\"9\",\"f211003\":\"157,25,289,217,109,63,133,145,8,265,49,241,37\",\"f211002\":\"1226,1093,2449,253,721,565,1753,289,157,61,397,277,889,1009,301,181,1201,2125,109,589,2341,1465,2617,2761,217,2845,193,205,85,25,2809,2113,2797,1525,517,2857,973,145,421,37,445,229,121,313\",\"f211001\":\"157,25,289,217,109,62,133,145,8,265,49,241,37\",\"f811002\":\"104\",\"f660201\":\"0\",\"f211004\":\"1227,1093,253,1753,289,397,1009,301,181,1201,109,589,2341,2761,193,205,85,25,2809,2113,2797,1525,517,2857,973,421,37,445,229,121,313\",\"f101001\":\"70381\",\"f432006\":\"0\",\"f432005\":\"0\",\"f432002\":\"0\",\"f432001\":\"0\",\"f432004\":\"0\",\"f432003\":\"0\",\"f602002\":\"9\",\"orderId\":\"taw-2000653607710957\",\"f113001\":\"04.03.0019,04.01.0001\",\"f502001\":\"0\",\"f502002\":\"1\",\"f770501\":\"0\",\"f606002\":\"7\",\"f606001\":\"3\",\"f102001\":\"02.01.0008\",\"f301001\":\"13113\",\"f221002\":\"5,16,73,50,25,85\",\"f221001\":\"4,18,73,50,25,85\",\"f221004\":\"1,21,115,78,39,135\",\"f221003\":\"2,21,115,78,39,135\",\"advertId\":\"70381\",\"f210001\":\"157,25,289,217,277,109,62,133,145,7,265,49,241,37\",\"f210002\":\"1226,1093,1621,2449,1861,253,721,565,1753,289,157,61,397,2833,277,889,1009,301,181,1201,2125,109,169,433,589,2341,1465,2617,2761,217,2845,193,205,85,25,769,2809,2113,2797,1525,517,2857,973,145,421,37,445,229,625,121,313\",\"f770401\":\"0\",\"f210003\":\"157,25,289,217,109,63,133,145,7,265,49,241,37\",\"f770402\":\"0\",\"f210004\":\"1227,1093,253,721,565,1753,289,397,277,1009,301,181,1201,109,169,589,2341,2761,193,205,85,25,2809,2113,2797,1525,517,2857,973,421,37,445,229,121,313\",\"f604002\":\"9\",\"f604001\":\"9\",\"f501001\":\"Android\",\"f303001\":\"0\",\"f462002\":\"0\",\"consumerId\":\"24155986877\",\"f406001\":\"3\",\"f462001\":\"爱看书免费小说\",\"f220001\":\"6,14,73,50,27,85\",\"f115001\":\"0\",\"f220002\":\"7,13,73,49,26,85\",\"f605001\":\"3\",\"f605002\":\"7\",\"f302001\":\"13113\",\"f608001\":\"0\",\"f425011\":\"0\",\"f425004\":\"0\",\"f414004\":\"0\",\"f425012\":\"0\",\"f505001\":\"其他\",\"f770102\":\"1\",\"f413002\":\"132,55,242,123,6,202\",\"f413003\":\"242\",\"f413001\":\"132,55,242,123,6,202\",\"f413006\":\"0\",\"f413007\":\"7\",\"f413004\":\"2\",\"f413005\":\"0\",\"f413008\":\"0\",\"f609001\":\"1\",\"f804004\":\"10\",\"f804003\":\"4\",\"f804002\":\"16\",\"f804001\":\"3\",\"f770001\":\"07.24.0001\",\"f415004\":\"0\",\"f206001\":\"262\",\"f504001\":\"LLD-TL10\",\"f607001\":\"0\",\"f206002\":\"260\",\"f403004\":\"0\",\"f805001\":\"0\",\"f805002\":\"14\",\"f805003\":\"2\",\"f805004\":\"8\",\"f9701\":\"010212,0110,011001,021119,0501101203\",\"f9702\":\"2\",\"f205002\":\"55\",\"f205001\":\"27\",\"f701001\":\"1070381\",\"f404003\":\"workother\",\"f106001\":\"33909\",\"f701002\":\"1077197\",\"f9607\":\"null\",\"f9608\":\"null\",\"f426004\":\"0\",\"f9609\":\"null\",\"f503001\":\"4509\",\"time\":\"20200831005939\",\"f9601\":\"null,010212_8,0110_8,011001_8,021119_8,0501101203_8\",\"f9602\":\"null,010212_07.24.0001,0110_07.24.0001,011001_07.24.0001,021119_07.24.0001,0501101203_07.24.0001\",\"f9603\":\"null,010212_70381,0110_70381,011001_70381,021119_70381,0501101203_70381\",\"f411001\":\"2\",\"f411003\":\"1\",\"f411002\":\"2\",\"f411005\":\"4\",\"f411004\":\"5\",\"f508002\":\"TL10\",\"f806001\":\"0\",\"f508001\":\"LLD\",\"f806002\":\"0\",\"f806003\":\"2\",\"f830101\":\"null\",\"f9916\":\"02.01.0008&10,02.22.0001&4,02.22.0006&4,02.19&4,02.11&7\",\"f806004\":\"1\",\"f830102\":\"null\",\"f9917\":\"02.01.0008&1,02.22.0001&1,02.22.0006&1,02.19&1,02.11&1\",\"f830103\":\"null\",\"f9918\":\"02.01.0008&1,02.22.0001&1,02.22.0006&1,02.19&1,02.11&1\",\"f830104\":\"null\",\"f508004\":\"TL10\",\"f9919\":\"02.01.0008&4,02.22.0001&6,02.22.0006&6,02.19&6,02.11&6\",\"f508003\":\"LLD\",\"f611001\":\"1\",\"f9903\":\"0\",\"f434009\":\"0\",\"f434007\":\"0\",\"f434008\":\"0\",\"f434005\":\"0\",\"f434006\":\"0\",\"f434003\":\"0\",\"f434004\":\"0\",\"f434001\":\"0\",\"f434002\":\"0\",\"f141016\":\"0\",\"f141018\":\"0\",\"f433008\":\"0\",\"f433006\":\"0\",\"f433007\":\"0\",\"f433004\":\"0\",\"f433005\":\"0\",\"f433002\":\"0\",\"f9930\":\"3\",\"f433003\":\"0\",\"f9931\":\"-1\",\"f9932\":\"-1\",\"f433001\":\"0\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"356834\",\"f807002\":\"14\",\"f9924\":\"02.01.0008,02.22.0006,02.19\",\"f807001\":\"0\",\"f507001\":\"2\",\"f807004\":\"8\",\"f830111\":\"null\",\"f807003\":\"2\",\"f830112\":\"null\",\"f9927\":\"0\",\"f830113\":\"null\",\"f9928\":\"0\",\"f830114\":\"null\",\"f9929\":\"2\",\"f9921\":\"\",\"f9922\":\"\",\"f9923\":\"02.22.0001,02.11\",\"f9802\":\"0\",\"f226007\":\"0\",\"f226006\":\"0\",\"f226005\":\"0\",\"f226004\":\"0\",\"f226003\":\"0\",\"f226002\":\"0\",\"f226001\":\"0\",\"f610001\":\"0\",\"f143010\":\"0\",\"f226008\":\"0\",\"f108003\":\"356834\",\"f830011\":\"{}\",\"f830012\":\"{}\",\"f830013\":\"{}\",\"f830014\":\"{}\",\"f424004\":\"0\",\"f424006\":\"0\",\"f109001\":\"8\",\"f808002\":\"0_0,02.22.0001_0,02.11_0,02.01.0008_0,02.22.0006_0,02.19_0\",\"f423004\":\"0\",\"f434018\":\"0\",\"f423006\":\"0\",\"f434016\":\"0\",\"f434017\":\"0\",\"f8807\":\"1\",\"f434014\":\"0\",\"f434015\":\"0\",\"f434012\":\"0\",\"f434013\":\"0\",\"f808001\":\"0_1,02.22.0001_1,02.11_1,02.01.0008_1,02.22.0006_1,02.19_1\",\"f8803\":\"1\",\"f434010\":\"0\",\"f434011\":\"0\",\"f143007\":\"0\",\"f225006\":\"0\",\"f143006\":\"0\",\"f225005\":\"0\",\"f143009\":\"0\",\"f412002\":\"0\",\"f225004\":\"0\",\"f143008\":\"0\",\"f412001\":\"0\",\"f225003\":\"0\",\"f143003\":\"0\",\"f412004\":\"0\",\"f143002\":\"0\",\"f412003\":\"1\",\"f143005\":\"0\",\"f412006\":\"0\",\"f143004\":\"0\",\"f412005\":\"0\",\"f143001\":\"0\",\"f214001\":\"210,421,1,476,76\",\"f214002\":\"228,458,4050\",\"f214003\":\"433,1,481,73\",\"f214004\":\"228,458\"}";
        featureMap =  (Map) JSON.parseObject(samples);
        List<FeatureBaseType> list = Arrays.asList(featureBaseType1, featureBaseType2);

        String f="[{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f101001\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f102001\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f106001\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":10,\"denseLen\":50000,\"hashNums\":1,\"name\":\"f108001\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f110001\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f201001\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":10,\"denseLen\":50000,\"hashNums\":1,\"name\":\"f301001\",\"seq\":\",\",\"subLen\":10000000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f306001\",\"seq\":\",\",\"subLen\":10},{\"codeType\":30,\"denseLen\":5000,\"dictList\":{\"unknow\":2,\"android\":0,\"ios\":1},\"hashNums\":1,\"name\":\"f501001\",\"seq\":\",\",\"subLen\":10},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f502001\",\"seq\":\",\",\"subLen\":25},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f502002\",\"seq\":\",\",\"subLen\":10},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f503001\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":30,\"denseLen\":5000,\"dictList\":{\"0-599\":0,\"600-1099\":1,\"1700-2699\":3,\"1100-1699\":2,\"2700-4499\":4,\"4500+\":5},\"hashNums\":1,\"name\":\"f505001\",\"seq\":\",\",\"subLen\":10},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f601002\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f602002\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f603002\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f604002\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f605002\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f606002\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f607001\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f608001\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f609001\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f610001\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f611001\",\"seq\":\",\",\"subLen\":1000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f808001\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":20,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f809001\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":20,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f810001\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f808002\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":20,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f809002\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":20,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f810002\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f9916\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f9917\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f9918\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f115001\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f104001\",\"seq\":\",\",\"subLen\":10000000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f804003\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f805003\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f806003\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f807003\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f804004\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f805004\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f806004\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f807004\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":50000,\"hashNums\":1,\"name\":\"f108003\",\"seq\":\",\",\"subLen\":10000000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f205001\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":10,\"denseLen\":50000,\"hashNums\":1,\"name\":\"f311001\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":10,\"denseLen\":500,\"hashNums\":1,\"name\":\"f312001\",\"seq\":\",\",\"subLen\":1000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f331001\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":20,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f508006\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f507001\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":20,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f507003\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":20,\"denseLen\":5000,\"hashNums\":3,\"name\":\"f504001\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f506001\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":10,\"denseLen\":100,\"hashNums\":1,\"name\":\"f411001\",\"seq\":\",\",\"subLen\":100},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f411005\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":10,\"denseLen\":100,\"hashNums\":1,\"name\":\"f412001\",\"seq\":\",\",\"subLen\":100},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f413007\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f413008\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f414007\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f414008\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f415007\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":10,\"denseLen\":100,\"hashNums\":1,\"name\":\"f434001\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":100,\"hashNums\":1,\"name\":\"f434004\",\"seq\":\",\",\"subLen\":100},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f141002\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f141003\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f141010\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f141012\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":10,\"denseLen\":100,\"hashNums\":1,\"name\":\"f144002\",\"seq\":\",\",\"subLen\":100},{\"codeType\":10,\"denseLen\":100,\"hashNums\":1,\"name\":\"f144005\",\"seq\":\",\",\"subLen\":100},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f451001\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":20,\"denseLen\":500,\"hashNums\":1,\"name\":\"f451005\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":11,\"denseLen\":500,\"hashNums\":1,\"name\":\"f461001\",\"seq\":\",\",\"subLen\":5000},{\"codeType\":11,\"denseLen\":500,\"hashNums\":1,\"name\":\"f461003\",\"seq\":\",\",\"subLen\":5000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f9903\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f9935\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f9940\",\"seq\":\",\",\"subLen\":500},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f9801\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":10,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f9802\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f9803\",\"seq\":\",\",\"subLen\":10000000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f9701\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":11,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f9806\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":41,\"denseLen\":8,\"hashNums\":1,\"name\":\"f9816\",\"seq\":\",\",\"subLen\":8},{\"codeType\":11,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f9807\",\"seq\":\",\",\"subLen\":10000},{\"codeType\":41,\"denseLen\":32,\"hashNums\":1,\"name\":\"f9817\",\"seq\":\",\",\"subLen\":32},{\"codeType\":11,\"denseLen\":500,\"hashNums\":1,\"name\":\"f214003\",\"seq\":\",\",\"subLen\":1000},{\"codeType\":11,\"denseLen\":500,\"hashNums\":1,\"name\":\"f222004\",\"seq\":\",\",\"subLen\":1000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f830001\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f830004\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f831001\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f831004\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f832001\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f832004\",\"seq\":\",\",\"subLen\":100000},{\"codeType\":21,\"denseLen\":5000,\"hashNums\":1,\"name\":\"f9944\",\"seq\":\",\",\"subLen\":1000000},{\"codeType\":21,\"denseLen\":10000,\"hashNums\":1,\"name\":\"f9704\",\"seq\":\",\",\"subLen\":1000000}]";

        list = JSON.parseArray(f,FeatureBaseType.class);
        System.out.println(JSON.toJSONString(featureMap));
        try {
            String a = null;
            String b = null;
            System.out.println(JSON.toJSONString(FeatureCoder.codeOfEachField(list, featureMap)));

        } catch (Exception e) {

            System.out.println(e);
        }


    }

}
