package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Data
public class BaseParse {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(BaseParse.class);


    public static Integer[] HUABEI_REGION = {80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = {81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = {82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = {83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = {84, 44, 45, 46};
    public static Integer[] XINAN_REGION = {85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = {86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = {87, 71, 8100, 8200};


    public static Integer[] FIRST_TIER_CITY = {11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = {1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = {1309, 1303, 1502, 2202, 3207, 3209, 3305, 3412, 3509, 3611, 3708, 3703, 4114, 4110, 4210, 4307, 4306, 4407, 4408, 4601, 5107, 6104, 1304, 1302, 1501, 2306, 3212, 3210, 3403, 3407, 3503, 3607, 3609, 3713, 4103, 4107, 4108, 4206, 4304, 4302, 4452, 4412, 4503, 4602, 5203, 6301, 1310, 1305, 2103, 3208, 3213, 3211, 3411, 3402, 3506, 3604, 3717, 3710, 4113, 4115, 4211, 4205, 4303, 4451, 4405, 4404, 4502, 5106, 5303, 6401};




    public static Integer[] orderGmtIntervelBucket = {0, 2, 5, 10, 60, 60 * 12, 60 * 24, 60 * 24 * 2, 60 * 24 * 4, 60 * 24 * 7, 60 * 24 * 30};// 时间间隔
    public static Integer[] orderActGmtIntervelBucket = {1, 2, 3, 4, 5, 10, 60, 60 * 12, 60 * 24, 60 * 24 * 7};
    public static Number[] cntBucket = {0, 1, 3, 5, 10, 15, 20};


    public static Number[] launchRankBucket = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 30, 50, 100, 200};
    public static Number[] clickRankBucket = {0, 1, 2, 3, 4, 5, 6, 8, 10, 15, 20, 30, 50};
    public static Number[] effectRankBucket = {0, 1, 2, 3, 4, 5, 10};

    public static Number[] dayLaunchRankBucket = {0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 15, 30};
    public static Number[] dayClickRankBucket = {0, 1, 2, 3, 4, 5, 10, 20};
    public static Number[] dayEffectRankBucket = {0, 1, 2, 3, 4, 5};

    public static Number[] statCtrBucket = {0.01, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.40, 0.45, 0.50, 0.55, 0.6, 0.63, 0.66, 0.7, 0.75, 0.8, 0.9};


    public static Number[] statCvrBucket = {0.0005, 0.001, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 0.07, 0.1, 0.15, 0.20, 0.25, 0.30, 0.5};

    public static Number[] statCtrBucketAct = {0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.40, 0.45, 0.50, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static Number[] statCvrBucketAct = {0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.20, 0.25, 0.30, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};


    public static final Number[] cntMeituanBucket30d = {0, 1, 2, 3, 5, 10, 20, 50};
    public static final Number[] cntMeituanBucket = {-1, 1, 2, 3, 4, 5, 10, 20, 30};



    /**
     * 方法1，地域解析
     *
     * @param areaCode //根据areaCode解析地区级别（华北/东北/华东/华中/华南/西南/西北/港澳）
     * @return
     */

    public static Long getRegionLevel(Long areaCode) {

        Long ret = null;

        if (AssertUtil.isNotEmpty(areaCode)) {

            int area = DataUtil.toInt(areaCode);
            if (areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area = DataUtil.toInt(Long.valueOf(areaCode / 100));
            }

            if (Arrays.asList(HUABEI_REGION).contains(area)) {
                ret = 80L;
            } else if (Arrays.asList(DONGBEI_REGION).contains(area)) {
                ret = 81L;
            } else if (Arrays.asList(HUADONG_REGION).contains(area)) {
                ret = 82L;
            } else if (Arrays.asList(HUAZHONG_REGION).contains(area)) {
                ret = 83L;
            } else if (Arrays.asList(HUANAN_REGION).contains(area)) {
                ret = 84L;
            } else if (Arrays.asList(XINAN_REGION).contains(area)) {
                ret = 85L;
            } else if (Arrays.asList(XIBEI_REGION).contains(area)) {
                ret = 86L;
            } else if (Arrays.asList(HMT_REGION).contains(area)) {
                ret = 87L;
            }

        }

        return ret;
    }


    /**
     * 方法2  //根据areaCode解析城市级别（一线/二线/三线）
     *
     * @param areaCode
     * @return
     */
    public static Long getTierCityLevel(Long areaCode) {

        Long ret = null;

        if (AssertUtil.isNotEmpty(areaCode)) {

            int area = DataUtil.toInt(areaCode);

            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) {
                ret = 1L;
            } else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) {
                ret = 2L;
            } else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) {
                ret = 3L;
            }

        }

        return ret;
    }


    /**
     * 仅非空值 存入map中
     *
     * @param map
     * @param key
     * @param value
     */
    public static void putMapNotNull(Map<String, String> map, String key, String value) {

        if (value != null) {
            map.put(key, value);
        }
    }

    /**
     * 仅非空值 存入map中
     *
     * @param map
     * @param key
     * @param value
     */
    public static void putMapNotNull(Map<String, String> map, String key, Long value) {

        if (value != null) {
            map.put(key, Long.toString(value));
        }
    }

    /**
     * 仅非空值 存入map中
     *
     * @param map
     * @param key
     * @param value
     */
    public static void putMapNotNull(Map<String, String> map, String key, Integer value) {

        if (value != null) {
            map.put(key, Integer.toString(value));
        }
    }


    /**
     * 系统版本 格式化
     *
     * @param osVersion
     * @return
     */
    public static String formatOsVersion(String osVersion) {
        if (StringUtils.isBlank(osVersion)) {
            return null;
        }
        return osVersion.split("\\.")[0].toUpperCase();
    }

    public static String formatPhoneModelCode(String phoneModel) {
        if (StringUtils.isBlank(phoneModel)) {
            return null;
        }
        // 字符过长截断
        return phoneModel.substring(0, Math.min(phoneModel.length(), 100));
    }


    public static String formatFirstShowTime(Integer firstShowTime) {
        if (firstShowTime == null) {
            return null;
        }
        // 判断firstShowTime合法性
        if (firstShowTime < 2000 || firstShowTime > 2030) {
            return "-1";
        }
        return firstShowTime.toString();
    }

    public static String formatPhoneOs(String phoneOs) {
        if (StringUtils.isBlank(phoneOs)) {
            return null;
        }
        if (phoneOs.equalsIgnoreCase("android")) {
            return "android";
        }
        if (phoneOs.equalsIgnoreCase("ios")) {
            return "ios";
        }
        return null;
    }
    /**
     * 广告语利益标签映射
     * 映射：939-红包，941-话费，942-手机
     *
     * @param str
     * @return
     */
    public static String formatInterestTag(String str) {
        if (StringUtils.isBlank(str)) {
            return null;
        }

        if (str.contains("红包") || str.contains("现金")) {
            return "939";

        } else if (str.contains("话费")) {
            return "941";

        } else if (str.contains("手机") || str.contains("苹果") || str.contains("华为") || str.contains("小米") || str.contains("iPhone")) {
            return "942";
        }
        return null;
    }

    /**
     * 分箱
     *
     * @param value
     * @param bucketList
     * @param <V1>
     * @param <V2>
     * @return
     */
    public static <V1 extends Number, V2 extends Number> String bucket(V1 value, V2[] bucketList) {
        if (value == null || bucketList == null || bucketList.length == 0) {
            return "";
        }
        int ret = bucketList.length;
        for (int i = 0; i < bucketList.length; i++) {
            Number bound = bucketList[i];
            if (value.doubleValue() <= bound.doubleValue()) {
                ret = i;
                break;
            }
        }
        return DataUtil.Integer2String(ret);
    }


    /**
     * 对map value 分箱
     *
     * @param map
     * @param <V>
     * @return
     */
    public static <V extends Number> String map2Bucket2Str(Map<?, V> map, Number[] bucketList) {
        if (map == null || AssertUtil.isEmpty(map)) {
            return null;
        }
        String ret = "";
        try {
            ret = map.keySet().stream().map(key -> key + "_" + bucket(map.get(key), bucketList)).collect(Collectors.joining(","));
        } catch (Exception e) {
            logger.error("BaseParse.json2Bucket2Str error", e);
        }
        return ret;


    }


    /**
     * set 转 str
     *
     * @param set
     * @param <T>
     * @return
     */
    public static <T> String set2Str(Set<T> set) {
        if (AssertUtil.isEmpty(set)) {
            return null;
        }
        String ret = "";
        try {
            ret = set.stream().map(Object::toString).collect(Collectors.joining(","));
        } catch (Exception e) {
            logger.error("BaseParse.set2Str error", e);
        }
        return ret;
    }
    /**
     * 计算集合差集
     *
     * @param base
     * @param exclude
     * @param <T>
     * @return
     */
    public static <T> Set<T> setDiff(Set<T> base, Set<T> exclude) {
        if (base == null) {
            return null;
        }
        if (exclude == null) {
            return base;
        }

        Set<T> res = new HashSet<>(base);// removeAll 是原地操作
        try {
            res.removeAll(exclude);
        } catch (Exception e) {
            logger.error("BaseParse.setDiff error", e);
        }

        return res;
    }

    /**
     * 对json value分箱
     *
     * @param ajson
     * @param bucketList
     * @return
     */
    public static String json2Bucket2Str(JSONObject ajson, Number[] bucketList) {
        if (ajson == null || AssertUtil.isEmpty(ajson)) {
            return null;
        }
        String ret = "";
        try {
            ret = ajson.keySet().stream().map(key -> key + "_" + bucket(ajson.getDouble(key), bucketList)).collect(Collectors.joining(","));
        } catch (Exception e) {
            logger.error("BaseParse.json2Bucket2Str error", e);
        }
        return ret;
    }

}
