package cn.com.duiba.nezha.alg.feature.vo.v2023;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.FeatureDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.BlowfishUtils;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.parse.v2.DeviceFeatureParseV2;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import cn.com.duiba.nezha.alg.feature.vo.AdvertTagFeature;
import cn.com.duiba.nezha.alg.feature.vo.LoadingPageFeature;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserBehaviorSubFeature;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static cn.com.duiba.wolf.utils.NumberUtils.isNumeric;

/**
 * Created by pc on 2019/2/21.
 */
@Data
public class AdFeatureDoV3 implements Serializable {
    private static final long serialVersionUID = 6695201251295150673L;

    // 广告侧 广告基本信息
    private Long advertId;// 广告ID

    private Long packageId;// 配置Id

    private Long accountId;// 广告主ID

    private String OperatingResource;//资源ID

    private String adNewTrade;// 广告行业ID（new_trade）

    private String adMatchTagNums;// 广告二级行业ID


    private Long landpageId; // 落地页Id
    private Long frontpageId; // 前置页Id
    private Long paypageId; // 支付页Id
    private Long formpageId; // 表单页Id
    private Long modelId; // 模型Id

    private String materialId;// 广告素材ID

    private String materialTags;// 广告素材标签

    private String materialCatg; // 广告素材类别

    private String materialAllCatg; //广告素材全类别, 模版id+主标题+副标题+一级利益点+二级利益点+商品图+行业+玩法

    private Long times;// 广告重复曝光次数

    private String targetConvertType;// 目标转化类型

    private String deepTargetConvertType;// 后端转化类型，值范围：1～30

    public Map<String, String> parse(AdContextFeatureDoV3 data3) {

        Map<String, String> retMap = new HashMap<>(32);

        putMap(retMap, "ft200101", advertId);
        putMap(retMap, "ft200110", packageId);//
        putMap(retMap, "ft200102", accountId);
        putMap(retMap, "ft200103", OperatingResource);
        putMap(retMap, "ft200104", adNewTrade);
        putMap(retMap, "ft200105", adMatchTagNums);

        putMap(retMap, "ft200106", materialId);//广告素材ID
        putMap(retMap, "ft200107", materialTags);//  广告素材标签
        putMap(retMap, "ft200109", times);//f110001 广告投放次数
        putMap(retMap, "ft200111", materialCatg); //广告素材类别


        putMapMatTag(retMap, materialCatg); //将素材新标签的子标签拆解
//        putMap(retMap, "ft200301", landpageId); // 落地页Id
//        putMap(retMap, "ft200302", frontpageId); // 前置页Id
//        putMap(retMap, "ft200303", paypageId); // 支付页Id
//        putMap(retMap, "ft200304", formpageId); // 表单页Id
//        putMap(retMap, "ft200305", modelId); // 模型Id


        retMap.put("ft200201", targetConvertType);//前端转化类型，值范围：0～10
        retMap.put("ft200202", deepTargetConvertType);//后端转化类型，值范围：1～30

        // 交叉
        retMap.put("ft500101", advertId + "_" + targetConvertType);// 广告 + 前端类型
        retMap.put("ft500201", advertId + "_" + deepTargetConvertType);// 广告 + 后端类型

        retMap.put("ft500103", adNewTrade + "_" + targetConvertType);// 行业 + 前端类型
        retMap.put("ft500203", adNewTrade + "_" + deepTargetConvertType);// 行业 + 后端类型


        // 用户侧 上一单数据
//        UserActFeature userActFeature = Optional.ofNullable(data3.getUserActFeature()).orElse(new UserActFeature());
//        String lastActivity = userActFeature.getLastActivity();
//        String lastLaunchTrade = userActFeature.getLastLaunchTrade();
//        String lastResource = userActFeature.getLastResource();
//        String lastAccount = userActFeature.getLastLaunchAccount();
//        String lastAdvert = userActFeature.getLastLaunchPlan();
//        String lastActivityLaunchOrder = userActFeature.getLastActivityLaunchOrder();
//        String lastActivityClickOrder = userActFeature.getLastActivityClickOrder();
//        retMap.put("ft110901", lastActivity);//上一单，活动ID
//        retMap.put("ft110902", lastLaunchTrade);
//        retMap.put("ft110903", lastResource);
//        retMap.put("ft110904", lastAccount);
//        retMap.put("ft110905", lastAdvert);
//        retMap.put("ft110906", userActFeature.getClickLaunchTrade() == null ? null : userActFeature.getClickLaunchTrade().toString());//上一单，是否点击
//        retMap.put("ft110907", userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade().toString());//上一单，是否转化
//        retMap.put("ft110908", DataConverter.getMatchStatus(lastLaunchTrade, adNewTrade));//上一单，与当前，行业是否相同
//        retMap.put("ft110909", DataConverter.getMatchStatus(lastAdvert, advertId.toString()));//上一单，与当前，计划是否相同
//        retMap.put("ft110910", DataConverter.getMatchStatus(lastActivity, data3.getActivityId().toString()));//上一单，与当前，活动是否相同、
//        String curOrderTime = data3.getCurrentGmtCreateTime();
//        String lastLaunchTime = userActFeature.getLastLaunchTime();
//        String lastActivityTime = userActFeature.getLastActivityLaunchTime();
//        retMap.put("ft110911", DataConverter.bucket(DataConverter.getTimeInterval(lastLaunchTime, curOrderTime, "m"), BaseParse.orderGmtIntervelBucket));//上一单，与当前发券，时间差
//        retMap.put("ft110912", DataConverter.bucketRight(DataConverter.getTimeInterval(lastActivityTime, curOrderTime, "m"), BaseParse.orderActGmtIntervelBucket));//上一次活动，与当前发券，时间差
//        retMap.put("ft110913", DataConverter.bucketRight(DataConverter.getTimeInterval(lastLaunchTime, curOrderTime, "m"), BaseParse.orderActGmtIntervelBucket));//上一单，与当前发券，时间差2
//        retMap.put("ft110914", DataConverter.getMatchStatus2(lastActivityLaunchOrder, lastActivityClickOrder));// 该活动下上一次发券是否点击


        // 6、媒体（媒体/广告位/媒体行业） 与当前广告（广告/广告行业/广告主等）交叉统计泛化
        // 广告位 交叉 当前广告行业

        return retMap;
    }

    public Map<String, String> parseDmpCross(DmpFeatureDto data) {

        Map<String, String> retMap = new HashMap<>(32);

        if (data == null || adNewTrade == null) {
            return retMap;
        }

        Map<String, String> appPackageDtoMap = DeviceFeatureParseV2.parseAppPackageDto(data.getAppPackageDto(), adNewTrade);
        retMap.putAll(appPackageDtoMap);

        Map<String, String> slotDtoMap = DeviceFeatureParseV2.parseTBDmpSlotDiDto(data.getSlotDto(), advertId.toString(), adNewTrade);
        retMap.putAll(slotDtoMap);
        retMap.put("fd_1011_01", DataConverter.getMatchStatus(data.getFeatureOnlineDto() == null ? null : data.getFeatureOnlineDto().getT1111(), adNewTrade));//上一单，与当前，行业是否相同

        return retMap;
    }


    public static <T> void putMap(Map<String, String> map, String key, T value) {

        if (value != null) {
            map.put(key, value.toString());
        }
    }

    public static <T> void putMapMatTag(Map<String, String> map, String materialCatg) {
        // 新素材标签的拼接规则：模版ID + 主标题 + 副标题 + 一级利益点ID + 二级利益点名称 + 商品图
        List<String> keyList = Arrays.asList("ft200113", "ft200114", "ft200115", "ft200112", "ft200116", "ft200117");
        if (materialCatg != null) {
            String firstEquity = BlowfishUtils.decryptBlowfish(materialCatg);
            String[] split = firstEquity.split("-");
            int curLength = 0;
            if (split.length >= 6) {
                for (int i = 0; i < split.length; ++i){
                    String subTagEncode = BlowfishUtils.encryptBlowfish(split[i]);
                    putMap(map, keyList.get(i), subTagEncode);
                    curLength += 1;
                }
            }
            // 如果素材标签解出来没有6个子标签，则认为当前标签有误，将所有子标签置为空；包括老标签"23", 编码截断，其他未知情况等。
            if (curLength < 6) {
                for (String s : keyList) {
                    putMap(map, s, null);
                }
            }
        }
        else {
            for (String s : keyList) {
                putMap(map, s, null);
            }
        }

    }


}
