package cn.com.duiba.nezha.alg.feature.parse.v2;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdContextFeatureDoV3;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.*;

/**
 * Created by pc on 2019/2/21.
 */
public class AdFeatureParseV2 extends BaseParse {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(AdFeatureParseV2.class);


    /**
     * @param contextDo     上下文特征
     * @param dmpFeatureDto dmp特征对象
     * @return
     */
    public static Map<String, String> generateFeatureMapStatic(AdContextFeatureDoV3 contextDo,
                                                               DmpFeatureDto dmpFeatureDto

    ) {

        Map<String, String> retMap = new HashMap<>(100);
        if (contextDo == null) {
            return retMap;
        }
        // 1、上下文特征
        Map<String, String> contextFeatureMap = contextDo.parse();
        retMap.putAll(contextFeatureMap);

        // 2、解析用户DMP特征
        Map<String, String> deviceFeatureMap = DeviceFeatureParseV2.parse(dmpFeatureDto, contextDo.getExternalAdBlockId());
        retMap.putAll(deviceFeatureMap);

        return retMap;
    }

    /**
     * @param contextDo     上下文特征
     * @param dmpFeatureDto dmp特征对象
     * @param adFeatureDoV3 广告特征对象
     * @return
     */
    public static Map<String, String> generateFeatureMapDynamic(AdContextFeatureDoV3 contextDo, DmpFeatureDto dmpFeatureDto, AdFeatureDoV3 adFeatureDoV3) {

        Map<String, String> retMap = new HashMap<>(100);


        if (adFeatureDoV3 == null) {
            return retMap;
        }
        // 1、广告特征
        Map<String, String> adFeatureMap = adFeatureDoV3.parse(contextDo);
        retMap.putAll(adFeatureMap);

        // 2、广告、设备交叉特征
        Map<String, String> dmpFeatureMap = adFeatureDoV3.parseDmpCross(dmpFeatureDto);
        retMap.putAll(dmpFeatureMap);
        return retMap;
    }


    public static void main(String[] args) {

        AdContextFeatureDoV3 contextDo = new AdContextFeatureDoV3();
        DmpFeatureDto dmpFeatureDto = new DmpFeatureDto();

        AdFeatureDoV3 adFeatureDoV3 = new AdFeatureDoV3();
        System.out.println("map1=" + JSON.toJSONString(AdFeatureParseV2.generateFeatureMapStatic(contextDo, dmpFeatureDto)));
        System.out.println("map2=" + JSON.toJSONString(AdFeatureParseV2.generateFeatureMapDynamic(contextDo, dmpFeatureDto, adFeatureDoV3)));

    }
}


