package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Data
public class FeatureMapDo implements Serializable {

    public Map<String, String> staticFeatureMap;
    public Map<String, String> dynamicFeatureMap;

    public String codeDoStr;


    public Map<String, String> getStaticFeatureMap() {
        return staticFeatureMap;
    }

    public void setStaticFeatureMap(Map<String, String> staticFeatureMap) {
        this.staticFeatureMap = staticFeatureMap;
    }

    public Map<String, String> getDynamicFeatureMap() {
        return dynamicFeatureMap;
    }

    public void setDynamicFeatureMap(Map<String, String> dynamicFeatureMap) {
        this.dynamicFeatureMap = dynamicFeatureMap;
    }

    public Map<String, String> getFeatureMap() {
        Map<String, String> combinedFeatureMap =
                Stream.concat(staticFeatureMap.entrySet().stream(), dynamicFeatureMap.entrySet().stream())
                        .filter(dto -> StringUtils.isNotEmpty(dto.getKey()) && StringUtils.isNotEmpty(dto.getValue())).collect(
                                Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (n, o) -> n)
                        );

        combinedFeatureMap.put("coder",codeDoStr);
        return combinedFeatureMap;
    }

}
