/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.vo.v2023;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOnlineDiDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.vo.v2023.ActContextFeatureDoV3;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class ActFeatureDoV3
implements Serializable {
    private static final long serialVersionUID = 6695201251295150673L;
    private Long activityId;
    private Long activityPage;
    private String activitySkinType;
    private String activitySkinType2;
    private String actTradeTag;
    private String actCrowdTag;
    private String actInteresteTag;
    private String actStyleTag;
    private String actSeasonTag;
    private String actFestivalTag;

    public Map<String, String> parse(DmpFeatureDto data2, ActContextFeatureDoV3 data3) {
        Long hisLastActivityLong;
        HashMap<String, String> retMap = new HashMap<String, String>(16);
        ActFeatureDoV3.putMap(retMap, "ft300301", this.activityId);
        ActFeatureDoV3.putMap(retMap, "ft300304", this.activityPage);
        ActFeatureDoV3.putMap(retMap, "ft300305", this.activitySkinType);
        ActFeatureDoV3.putMap(retMap, "ft300309", this.activitySkinType2);
        ActFeatureDoV3.putMap(retMap, "ft300311", this.actTradeTag);
        ActFeatureDoV3.putMap(retMap, "ft300313", this.actInteresteTag);
        ActFeatureDoV3.putMap(retMap, "ft300317", ActFeatureDoV3.interestTagValid(this.actInteresteTag, data3.getExtMaterialTitle()));
        TBDeviceFeatureOnlineDiDto userBehaviorSubFeature = Optional.ofNullable(data2.getFeatureOnlineDto()).orElse(new TBDeviceFeatureOnlineDiDto());
        String hisLastActivity = userBehaviorSubFeature.getT1113();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{this.activityId, hisLastActivity}) && this.activityId.equals(hisLastActivityLong = Long.valueOf(hisLastActivity))) {
            retMap.put("ft110910", "1");
        }
        return retMap;
    }

    public static <T> void putMap(Map<String, String> map, String key, T value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    public static Long interestTagValid(String actInterestTag, String extMaterialTitle) {
        String[] actTags;
        Long ret = 0L;
        String extTag = BaseParse.formatInterestTag(extMaterialTitle);
        if (StringUtils.isBlank((String)actInterestTag) || StringUtils.isBlank((String)extTag)) {
            return ret;
        }
        for (String actTag : actTags = actInterestTag.split(",")) {
            if (!StringUtils.isNotBlank((String)actTag) || !extTag.equals(actTag)) continue;
            ret = 1L;
            break;
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            String actInterestTag = ",939,,";
            String extMaterialTitle = "\u6709\u7ea2\u5305\uff01\u6709\u7ea2\u5305\uff01\u6709\u7ea2\u5305\uff01\u7b7e\u5230\u771f\u7684\u6709\u7ea2\u5305\uff01";
            Long ret = ActFeatureDoV3.interestTagValid(actInterestTag, extMaterialTitle);
            System.out.println(ret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public Long getActivityPage() {
        return this.activityPage;
    }

    public String getActivitySkinType() {
        return this.activitySkinType;
    }

    public String getActivitySkinType2() {
        return this.activitySkinType2;
    }

    public String getActTradeTag() {
        return this.actTradeTag;
    }

    public String getActCrowdTag() {
        return this.actCrowdTag;
    }

    public String getActInteresteTag() {
        return this.actInteresteTag;
    }

    public String getActStyleTag() {
        return this.actStyleTag;
    }

    public String getActSeasonTag() {
        return this.actSeasonTag;
    }

    public String getActFestivalTag() {
        return this.actFestivalTag;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public void setActivityPage(Long activityPage) {
        this.activityPage = activityPage;
    }

    public void setActivitySkinType(String activitySkinType) {
        this.activitySkinType = activitySkinType;
    }

    public void setActivitySkinType2(String activitySkinType2) {
        this.activitySkinType2 = activitySkinType2;
    }

    public void setActTradeTag(String actTradeTag) {
        this.actTradeTag = actTradeTag;
    }

    public void setActCrowdTag(String actCrowdTag) {
        this.actCrowdTag = actCrowdTag;
    }

    public void setActInteresteTag(String actInteresteTag) {
        this.actInteresteTag = actInteresteTag;
    }

    public void setActStyleTag(String actStyleTag) {
        this.actStyleTag = actStyleTag;
    }

    public void setActSeasonTag(String actSeasonTag) {
        this.actSeasonTag = actSeasonTag;
    }

    public void setActFestivalTag(String actFestivalTag) {
        this.actFestivalTag = actFestivalTag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActFeatureDoV3)) {
            return false;
        }
        ActFeatureDoV3 other = (ActFeatureDoV3)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$activityId = this.getActivityId();
        Long other$activityId = other.getActivityId();
        if (this$activityId == null ? other$activityId != null : !((Object)this$activityId).equals(other$activityId)) {
            return false;
        }
        Long this$activityPage = this.getActivityPage();
        Long other$activityPage = other.getActivityPage();
        if (this$activityPage == null ? other$activityPage != null : !((Object)this$activityPage).equals(other$activityPage)) {
            return false;
        }
        String this$activitySkinType = this.getActivitySkinType();
        String other$activitySkinType = other.getActivitySkinType();
        if (this$activitySkinType == null ? other$activitySkinType != null : !this$activitySkinType.equals(other$activitySkinType)) {
            return false;
        }
        String this$activitySkinType2 = this.getActivitySkinType2();
        String other$activitySkinType2 = other.getActivitySkinType2();
        if (this$activitySkinType2 == null ? other$activitySkinType2 != null : !this$activitySkinType2.equals(other$activitySkinType2)) {
            return false;
        }
        String this$actTradeTag = this.getActTradeTag();
        String other$actTradeTag = other.getActTradeTag();
        if (this$actTradeTag == null ? other$actTradeTag != null : !this$actTradeTag.equals(other$actTradeTag)) {
            return false;
        }
        String this$actCrowdTag = this.getActCrowdTag();
        String other$actCrowdTag = other.getActCrowdTag();
        if (this$actCrowdTag == null ? other$actCrowdTag != null : !this$actCrowdTag.equals(other$actCrowdTag)) {
            return false;
        }
        String this$actInteresteTag = this.getActInteresteTag();
        String other$actInteresteTag = other.getActInteresteTag();
        if (this$actInteresteTag == null ? other$actInteresteTag != null : !this$actInteresteTag.equals(other$actInteresteTag)) {
            return false;
        }
        String this$actStyleTag = this.getActStyleTag();
        String other$actStyleTag = other.getActStyleTag();
        if (this$actStyleTag == null ? other$actStyleTag != null : !this$actStyleTag.equals(other$actStyleTag)) {
            return false;
        }
        String this$actSeasonTag = this.getActSeasonTag();
        String other$actSeasonTag = other.getActSeasonTag();
        if (this$actSeasonTag == null ? other$actSeasonTag != null : !this$actSeasonTag.equals(other$actSeasonTag)) {
            return false;
        }
        String this$actFestivalTag = this.getActFestivalTag();
        String other$actFestivalTag = other.getActFestivalTag();
        return !(this$actFestivalTag == null ? other$actFestivalTag != null : !this$actFestivalTag.equals(other$actFestivalTag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActFeatureDoV3;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : ((Object)$activityId).hashCode());
        Long $activityPage = this.getActivityPage();
        result = result * 59 + ($activityPage == null ? 43 : ((Object)$activityPage).hashCode());
        String $activitySkinType = this.getActivitySkinType();
        result = result * 59 + ($activitySkinType == null ? 43 : $activitySkinType.hashCode());
        String $activitySkinType2 = this.getActivitySkinType2();
        result = result * 59 + ($activitySkinType2 == null ? 43 : $activitySkinType2.hashCode());
        String $actTradeTag = this.getActTradeTag();
        result = result * 59 + ($actTradeTag == null ? 43 : $actTradeTag.hashCode());
        String $actCrowdTag = this.getActCrowdTag();
        result = result * 59 + ($actCrowdTag == null ? 43 : $actCrowdTag.hashCode());
        String $actInteresteTag = this.getActInteresteTag();
        result = result * 59 + ($actInteresteTag == null ? 43 : $actInteresteTag.hashCode());
        String $actStyleTag = this.getActStyleTag();
        result = result * 59 + ($actStyleTag == null ? 43 : $actStyleTag.hashCode());
        String $actSeasonTag = this.getActSeasonTag();
        result = result * 59 + ($actSeasonTag == null ? 43 : $actSeasonTag.hashCode());
        String $actFestivalTag = this.getActFestivalTag();
        result = result * 59 + ($actFestivalTag == null ? 43 : $actFestivalTag.hashCode());
        return result;
    }

    public String toString() {
        return "ActFeatureDoV3(activityId=" + this.getActivityId() + ", activityPage=" + this.getActivityPage() + ", activitySkinType=" + this.getActivitySkinType() + ", activitySkinType2=" + this.getActivitySkinType2() + ", actTradeTag=" + this.getActTradeTag() + ", actCrowdTag=" + this.getActCrowdTag() + ", actInteresteTag=" + this.getActInteresteTag() + ", actStyleTag=" + this.getActStyleTag() + ", actSeasonTag=" + this.getActSeasonTag() + ", actFestivalTag=" + this.getActFestivalTag() + ")";
    }
}

