package cn.com.duiba.nezha.alg.feature.vo.v2023;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.*;

/**
 * Created by pc on 2019/2/21.
 */

/**
 * 上下文特征对象
 * 场景链路
 * 1、广告位素材推荐/RTB竞价
 * 2、活动推荐
 * 3、券推荐
 */
@Data
public class AdContextFeatureDoV3 implements Serializable {
    private static final long serialVersionUID = 6695201251295150673L;

    private String currentGmtCreateTime;//当前时间 格式：YYYY_MM_DD_HH_MM_SS

    /**
     * 活动信息
     */
    private Long activityId;//ID  活动ID
    private Long activityPage;//ID  主活动ID

    private String activitySkinType; // 活动皮肤类型，约40+（玩法，大转盘/翻牌子/扭蛋机等）
    private String activitySkinType2; //活动皮肤ID，具体活动皮肤，约1000+：刮卡/大转盘/翻牌子/扭蛋机等

    //private Integer putIndex;//当日发券次序
    private String actTradeTag; //1、适用场景标签，休闲游戏-经营养成、休闲游戏-答题解密；格式：1,3
    private String actInteresteTag; //3、权益标签；红包、话费、手机等；格式：1,3 映射：939-红包，941-话费，942-手机

    private Long activityNextAct; //运营商项目优化，用户在活动上的下一个行为数据，1、未曝光弹窗/曝光但没行为， 2、曝光关闭弹窗，3、曝光提交手机号


    /**
     * 上下文
     */
    private Long dsm2A; //活动类型，是否返回拦截类型
    private String activitySourceType;//活动[进入当前券]的访问类型[广告位、浮标、返回拦截、弹层、区块]todo 是否与 slotActivityType 相同
    private Long activityJoinTimes; //当前活动参与次数,发券次序 put_index
    private String slotActivityType; //1-配置包插件活动,2-活动工具,3-直投页,4-展示广告,5-浮标,6-增值广告,7-活动直投落地页,8-激励视屏,9-新激励视屏,10-增值,11-dp广告。现枚举值新增了几个类型需要加上：12-视频、13-dp广告(返回拦截场景)、14-广告位置直投落地页广告


    /**
     * 媒体信息
     */
    private Long appId; //媒体ID
    //private Integer appType; //媒体类型：0-非程序化媒体，1-程序化媒体
    private Long slotId;  //广告位ID
    private Long slotSceneType;// 广告位类型（开屏/信息流/banner/icon等）
    private String appIndustryTagPid; //媒体行业一级标签
    private String appIndustryTagId; //媒体行业二级标签

    private String appCarrierFlowTagId;//appCarrierFlowTagId, 671独立app,672独立app-sdk,673H5,674微信-H5,675支付宝-H5,693微信-小程序,694支付宝-小程序,695百度-小程序,696厂商,697联盟,699ott,701other,887回流媒体
    private String appFlowType; //appFlowType，WECHAT_H5(1, "微信H5"),QQ(2, "QQ"),ALIPAY_H5(3, "支付宝H5"),OTHER(4, "其他"),WECHAT_APPLET(5, "微信小程序"),ALIPAY_APPLET(6, "支付宝小程序"),WECHAT_QUICK_APP(7, "微信快应用")

    private String appTradeTypeTagId;//媒体交易方式（RTB/ADX/固价-cpm等）

    private String appChannel; //媒体渠道类型（快手, 百度, oppo, 爱奇艺等）

    /**
     * 媒体信息-ADX流量
     */
    private Long groupId;//推广组ID
    private Long resourceId;//资源位ID
    private String extAppTrade;//联盟媒体行业id
    private String externalAdBlockId;//联盟流量广告位ID
    private String externalAdBlockTypeId;//外部广告位类型ID 区分 开屏 信息流等

    private String unionAppId; // 联盟流量中的媒体ID，百度
    /**
     * 媒体信息-开户
     */
    private String openAccountId; //快手-媒体开户账号id
    private String extUnionSlotId; //快手-联盟广告位id
    private String extAdvertGroupId; //快手-外部广告组id
    private String extIdeaId; //快手-外部创意id

    private String extMaterialTitle; //广告语 ，22.09.21
    private String extMaterialId; //外部素材ID，22.09.21
    private String extMaterialType; //外部素材类型 :横版图片、竖版图片、横版视频、竖版视频 ，09.21
    private String extAdScenario; // 开户上的百度+快手联盟-广告位类型id，快手(1-优选广告，2-信息流广告(旧投放场景，含上下滑大屏广告),3-视频播放页广告,5-联盟广告,6-上下滑大屏广告，7-信息流广告(不含上下滑大屏广告)，27-开屏位置，39-搜索广告，24-激励视频）

    private String extUnionAppId; // 百度-联盟媒体id

    private String materialTag; //广告位入口素材标签，红包、手机等，新增

    private String slotMaterialId; //广告位曝光 素材ID todo

    /**
     * 设备信息、解析
     */

    private Long areaCode; // 地域，城市编码 city_id

    private String ip; // ip
    private String ipUsageType; // ip场景，家庭、机房、公用，企业等

    private String ua; // userAgent
    private String uaAppPackage; // 媒体包 示例 com.little.xxx，ua解析
    private String uaAppPackageTrade1; // 媒体包行业类目，大类，网赚、计步等，ua解析映射
    private String uaAppPackageTrade2; // 媒体包行业类目，小类，网赚、计步等，ua解析映射

    private String phoneOs; // 操作系统
    private String osVersion; // 操作系统版本
    private String brandNameEn; // 设备品牌 英文名
    private String phoneModelCode; // 设备型号
    private String phonePriceLevel; // 设备价格区间

    private String operatorType; // 运营商（中国联通，中国移动，中国电信）
    private String connectionType; // 网络类型（2G，3G，4G）

    private Integer firstShowTime;//首发年份

    private Integer havePhoneNum; // 是否携带手机号

    /**
     * 兼容旧版本 FeatureDo
     * 5.9 下线旧版特征
     */
//    private UserProfileFeature userProfileFeature; // 用户画像特征

//    private String bdFirstTag;  // 一级标签
//    private String bdSecondTag; // 二级标签
//    private String bdThirdTag;  // 三级标签
//    private String bdFourthTag; // 四级标签

//    private UserActFeature userActFeature;// 用户行为特征

//    private String appInstall;//app安装列表


    public Map<String, String> parse() {
        Map<String, String> retMap = new HashMap<>(100);

        /**
         * 时间
         */
        currentGmtCreateTime = LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        LocalDateTime currentGmtCreateTime = LocalDateTime.now();
        putMap(retMap, "ft301001", currentGmtCreateTime.getHour());//订单时间 hour（时段）
        putMap(retMap, "ft301002", currentGmtCreateTime.getDayOfWeek().getValue());// 订单时间 weekday（周几）
        putMap(retMap, "ft301003", currentGmtCreateTime.getDayOfMonth());// 订单时间 day（几号）

        /**
         * 活动信息
         */
        putMap(retMap, "ft300301", activityId);//活动id（当前活动）
        putMap(retMap, "ft300304", activityPage);//自定义活动ID（主活动ID）
        putMap(retMap, "ft300305", activitySkinType);// 活动皮肤ID/Name（玩法，大转盘/翻牌子/扭蛋机等）
        putMap(retMap, "ft300309", activitySkinType2); //活动皮肤ID，具体活动皮肤，约1000+：刮卡/大转盘/翻牌子/扭蛋机等
        putMap(retMap, "ft110014", BaseParse.bucket(activityJoinTimes, BaseParse.dayLaunchRankBucket)); //当前活动参与次数,发券次序 == put_index
        putMap(retMap, "ft300311", actTradeTag); //1、适用场景标签，休闲游戏-经营养成、休闲游戏-答题解密；格式：1,3
        putMap(retMap, "ft300310", activityNextAct); //运营商项目优化，参与活动后的弹窗用户行为，1、未曝光弹窗/曝光但没行为， 2、曝光关闭弹窗，3、曝光提交手机号


        /**
         * 上下文
         */
        putMap(retMap, "ft300303", dsm2A);// 活动访问类型（广告位/返回拦截）
        putMap(retMap, "ft300302", activitySourceType);//活动[进入当前券]的访问类型[广告位、浮标、返回拦截、弹层、区块]
        putMap(retMap, "ft300306", slotActivityType);//1-配置包插件活动,2-活动工具,3-直投页,4-展示广告,5-浮标,6-增值广告,7-活动直投落地页,8-激励视屏,9-新激励视屏,10-增值,11-dp广告。现枚举值新增了几个类型需要加上：12-视频、13-dp广告(返回拦截场景)、14-广告位置直投落地页广告
        putMap(retMap, "ft300313", actInteresteTag); //3、权益标签；红包、话费、手机等；格式：1,3 映射：939-红包，941-话费，942-手机


        /**
         * 媒体信息
         */
        putMap(retMap, "ft300101", appId);//媒体ID
        putMap(retMap, "ft300201", slotId);//广告位ID
        putMap(retMap, "ft300202", slotSceneType);// 广告位类型（开屏/信息流/banner/icon等）

        putMap(retMap, "ft300104", appIndustryTagPid);//媒体行业一级标签（视频/阅读等）
        putMap(retMap, "ft300105", appIndustryTagId);//媒体行业二级标签（短视频/新闻阅读等）
        putMap(retMap, "ft300107", appCarrierFlowTagId);//appCarrierFlowTagId , 671独立app,672独立app-sdk,673H5,674微信-H5,675支付宝-H5,693微信-小程序,694支付宝-小程序,695百度-小程序,696厂商,697联盟,699ott,701other,887回流媒体
        putMap(retMap, "ft300106", appTradeTypeTagId);// 媒体交易方式（RTB/ADX/固价-cpm等
        putMap(retMap, "ft300113", appFlowType); //WECHAT_H5(1, "微信H5"),QQ(2, "QQ"),ALIPAY_H5(3, "支付宝H5"),OTHER(4, "其他"),WECHAT_APPLET(5, "微信小程序"),ALIPAY_APPLET(6, "支付宝小程序"),WECHAT_QUICK_APP(7, "微信快应用")
        putMap(retMap, "ft300114", appChannel); //媒体渠道类型, 例如快手, 百度, oppo, 爱奇艺等


        /**
         * 媒体信息-ADX流量
         */
        putMap(retMap, "ft600304", groupId);//推广组ID
        putMap(retMap, "ft600305", resourceId);//资源位ID
        putMap(retMap, "ft600301", extAppTrade);//百度-联盟媒体行业id
        putMap(retMap, "ft600302", externalAdBlockId);//百度-联盟流量广告位ID
        putMap(retMap, "ft600303", externalAdBlockTypeId);//百度-外部广告位类型ID 区分 开屏 信息流等
        putMap(retMap, "ft600304", unionAppId);//百度-媒体联盟id

        /**
         * 媒体信息-开户
         */
        putMap(retMap, "ft600210", extUnionAppId);//百度-媒体联盟id
        putMap(retMap, "ft600201", openAccountId);   //快手-媒体开户账号id
        putMap(retMap, "ft6002021", extUnionSlotId); //快手-联盟广告位id
        putMap(retMap, "ft6002031", extAdvertGroupId);   //快手-外部广告组id
        putMap(retMap, "ft6002041", extIdeaId); //快手-外部创意id

        putMap(retMap, "ft600206", BaseParse.formatInterestTag(extMaterialTitle)); //外部素材广告语
        putMap(retMap, "ft600207", extMaterialId); //外部素材ID
        putMap(retMap, "ft600208", extMaterialType); //外部素材类型 :1-横版图片、2-竖版图片、3-横版视频、4-竖版视频
        putMap(retMap, "ft600205", materialTag); //入口素材标签，红包、手机、话费
        putMap(retMap, "ft600209", extAdScenario); // 开户上的百度+快手 ，流量广告位类型id
        /**
         * 设备信息、解析
         */

        String provinceId = RegionConf.getProvince(areaCode);
        String cityTier = RegionConf.getCityTier(areaCode);
        String regionId = RegionConf.getRegion(provinceId);

        putMap(retMap, "ft300901", regionId);//地域-地区（华北/华东等）
        putMap(retMap, "ft300902", provinceId);// 地域-省/直辖市
        putMap(retMap, "ft300903", areaCode);//地域-市
        putMap(retMap, "ft300904", cityTier);//地域-几线


        putMap(retMap, "ft300109", uaAppPackage); // 媒体包
        putMap(retMap, "ft300110", uaAppPackageTrade1); // 媒体包行业类目，大类，网赚、计步等
        putMap(retMap, "ft300111", uaAppPackageTrade2); // 媒体包行业类目，小类，网赚、计步等

        putMap(retMap, "ft100209", ipUsageType);//ip场景

        putMap(retMap, "ft100208", BaseParse.formatPhoneOs(phoneOs));//操作系统
        putMap(retMap, "ft100203", BaseParse.formatOsVersion(osVersion));//系统版本
        putMap(retMap, "ft100205", brandNameEn);//品牌英文名称
        putMap(retMap, "ft100204", BaseParse.formatPhoneModelCode(phoneModelCode));//设备型号
        putMap(retMap, "ft100206", phonePriceLevel);// 设备价格区间
        putMap(retMap, "ft100207", BaseParse.formatFirstShowTime(firstShowTime));//首发年份
        putMap(retMap, "ft100201", connectionType);// 网络类型（2G，3G，4G）
        putMap(retMap, "ft100202", operatorType);// 运营商（中国联通，中国移动，中国电信）

        putMap(retMap, "ft100301", havePhoneNum); //是否带有手机号



        return retMap;
    }

    /**
     * 兼容
     */
    public Map<String, String> parseDevice() {
        Map<String, String> retMap = new HashMap<>(100);


        // 2、用户侧 画像信息 --兼容旧版本
        /**
         * 旧版dmp特征下线
         */
//        if (userProfileFeature == null) {
//            userProfileFeature = new UserProfileFeature();
//        }
//        putMap(retMap, "ft100103", userProfileFeature.getMarital());//婚育情况
//        putMap(retMap, "ft100105", userProfileFeature.getInterestPreference());//兴趣标签
//        putMap(retMap, "ft100106", userProfileFeature.getAge());//dmp年龄
//        putMap(retMap, "ft100107", userProfileFeature.getGender());//dmp性别

//        putMap(retMap, "ft100501", bdFirstTag);// 百度兴趣标签 1级
//        putMap(retMap, "ft100502", bdSecondTag);// 百度兴趣标签 2级
//        putMap(retMap, "ft100503", bdThirdTag);// 百度兴趣标签 3级
//        putMap(retMap, "ft100504", bdFourthTag);// 百度兴趣标签 4级

        // app 分箱
//        putMap(retMap, "ft100603", appInstall);// app安装
        // 3、用户侧 行为 --兼容旧版本
//        if (userActFeature == null) {
//            userActFeature = new UserActFeature();
//        }
//        putMap(retMap, "ft110000", BaseParse.bucket(userActFeature.getUserActiveDays(), BaseParse.cntBucket));// 历史最早发券距今天数
//
//        putMap(retMap, "ft111021", BaseParse.bucket(userActFeature.getWeekActivityRequest(), BaseParse.cntBucket)); // 历史=7，活动访问PV
//        putMap(retMap, "ft111011", BaseParse.bucket(userActFeature.getDayActivityRequest(), BaseParse.cntBucket)); // 当日，活动访问PV
//        // 历史累计
//        putMap(retMap, "ft110001", BaseParse.bucket(userActFeature.getHistory30LaunchCount(), BaseParse.launchRankBucket));//历史=30，曝光PV
//        putMap(retMap, "ft110002", BaseParse.bucket(userActFeature.getHistory30ClickCount(), BaseParse.clickRankBucket)); //历史=30，点击PV
//        putMap(retMap, "ft110003", BaseParse.bucket(userActFeature.getHistory30EffectCount(), BaseParse.effectRankBucket));//历史=30，转化PV
//        // 当日累计
//        putMap(retMap, "ft110011", BaseParse.bucket(userActFeature.getTodayLaunchCount(), BaseParse.dayLaunchRankBucket));//当日，曝光PV
//        putMap(retMap, "ft110012", BaseParse.bucket(userActFeature.getTodayClickCount(), BaseParse.dayClickRankBucket));//当日，点击PV
//        putMap(retMap, "ft110013", BaseParse.bucket(userActFeature.getTodayEffectCount(), BaseParse.dayEffectRankBucket));//当日，转化PV
        putMap(retMap, "ft110014", BaseParse.bucket(activityJoinTimes, BaseParse.dayLaunchRankBucket));// 当日，发券putindex
//
//        putMap(retMap, "ft110301", BaseParse.map2Bucket2Str(userActFeature.getHistoryTradeLaunch(), BaseParse.launchRankBucket));//历史=30，不同行业，发券PV
//        putMap(retMap, "ft110302", BaseParse.map2Bucket2Str(userActFeature.getHistoryTradeClick(), BaseParse.clickRankBucket));//历史=30，不同行业，点击PV
//        putMap(retMap, "ft110303", BaseParse.map2Bucket2Str(userActFeature.getHistoryTradeEffect(), BaseParse.effectRankBucket));//历史=30，不同行业，转化PV
//
//        putMap(retMap, "ft110501", BaseParse.map2Bucket2Str(userActFeature.getHistoryAdvertLaunch(), BaseParse.dayLaunchRankBucket));// 历史=30，不同广告，发券PV
//        putMap(retMap, "ft110502", BaseParse.map2Bucket2Str(userActFeature.getHistoryAdvertClick(), BaseParse.dayClickRankBucket));// 历史=30，不同广告，点击PV
//        putMap(retMap, "ft110503", BaseParse.map2Bucket2Str(userActFeature.getHistoryAdvertEffect(), BaseParse.dayEffectRankBucket));// 历史=30，不同广告，转化PV

        // 4、用户行为集合 --兼容旧版本
//        Set<Integer> advertExposureSet = userActFeature.getAdvertExposureSet();
//        Set<Integer> advertClickSet = userActFeature.getAdvertClickSet();

//        putMap(retMap, "ft110601", BaseParse.set2Str(advertExposureSet));
//        putMap(retMap, "ft110602", BaseParse.set2Str(advertClickSet));
//        putMap(retMap, "ft110603", BaseParse.set2Str(BaseParse.setDiff(advertExposureSet, advertClickSet)));
//        putMap(retMap, "ft110604", BaseParse.set2Str(userActFeature.getAccountClickSet()));
//        putMap(retMap, "ft110605", BaseParse.set2Str(userActFeature.getResourceClickSet()));
//        putMap(retMap, "ft110606", BaseParse.set2Str(userActFeature.getTradeClickSet()));
//        putMap(retMap, "ft110607", BaseParse.set2Str(userActFeature.getAdvertEffectSet()));
//        putMap(retMap, "ft110608", BaseParse.set2Str(userActFeature.getAccountEffectSet()));
//        putMap(retMap, "ft110609", BaseParse.set2Str(userActFeature.getResourceEffectSet()));
//        putMap(retMap, "ft110610", BaseParse.set2Str(userActFeature.getTradeEffectSet()));


        // 用户行为ctr/cvr偏好
//        Map<String, Map<String, Long>> historyTradeCtrCvr = userActFeature.getHistoryTradeCtrCvr();

//        putMap(retMap, "ft110701", DataUtil.Long2String(historyTradeCtrCvr.get("ctr").get("0")));//整体ctr f8090011
//        putMap(retMap, "ft110702", DataUtil.Long2String(historyTradeCtrCvr.get("cvr").get("0")));//整体cvr f8090021
//        putMap(retMap, "ft110703", DataConverter.map2Str(historyTradeCtrCvr.get("ctr")));//行业ctr
//        putMap(retMap, "ft110704", DataConverter.map2Str(historyTradeCtrCvr.get("cvr")));//行业cvr

        return retMap;
    }


    public static <T> void putMap(Map<String, String> map, String key, T value) {

        if (value != null) {
            map.put(key, value.toString());
        }
    }
}
