/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse.v2;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDmpAppPackageDiDto;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.parse.v2.DeviceFeatureParseV2;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdContextFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdFeatureDoV3;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdFeatureParseV2
extends BaseParse {
    private static final Logger logger = LoggerFactory.getLogger(AdFeatureParseV2.class);

    public static Map<String, String> generateFeatureMapStatic(AdContextFeatureDoV3 contextDo, DmpFeatureDto dmpFeatureDto) {
        HashMap<String, String> retMap = new HashMap<String, String>(100);
        if (contextDo == null) {
            return retMap;
        }
        Map<String, String> contextFeatureMap = contextDo.parse();
        retMap.putAll(contextFeatureMap);
        Map<String, String> deviceFeatureMap = DeviceFeatureParseV2.parse(dmpFeatureDto, contextDo.getExternalAdBlockId());
        retMap.putAll(deviceFeatureMap);
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(AdContextFeatureDoV3 contextDo, DmpFeatureDto dmpFeatureDto, AdFeatureDoV3 adFeatureDoV3, TBDmpAppPackageDiDto newAppPackageDto) {
        HashMap<String, String> retMap = new HashMap<String, String>(100);
        if (adFeatureDoV3 == null) {
            return retMap;
        }
        Map<String, String> adFeatureMap = adFeatureDoV3.parse(contextDo);
        retMap.putAll(adFeatureMap);
        Map<String, String> dmpFeatureMap = adFeatureDoV3.parseDmpCross(dmpFeatureDto);
        retMap.putAll(dmpFeatureMap);
        Map<String, String> newAppPackageDtoMap = DeviceFeatureParseV2.parseNewAppPackageDto(newAppPackageDto, adFeatureDoV3.getAdNewTrade());
        retMap.putAll(newAppPackageDtoMap);
        return retMap;
    }

    public static void main(String[] args) {
        AdContextFeatureDoV3 contextDo = new AdContextFeatureDoV3();
        DmpFeatureDto dmpFeatureDto = new DmpFeatureDto();
        TBDmpAppPackageDiDto newAppPackageDto = new TBDmpAppPackageDiDto();
        AdFeatureDoV3 adFeatureDoV3 = new AdFeatureDoV3();
        System.out.println("map1=" + JSON.toJSONString(AdFeatureParseV2.generateFeatureMapStatic(contextDo, dmpFeatureDto)));
        System.out.println("map2=" + JSON.toJSONString(AdFeatureParseV2.generateFeatureMapDynamic(contextDo, dmpFeatureDto, adFeatureDoV3, newAppPackageDto)));
    }
}

