/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureBaseParse;
import cn.com.duiba.nezha.alg.feature.parse.FeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AppFeature;
import cn.com.duiba.nezha.alg.feature.vo.AppMaterialFeature;
import cn.com.duiba.nezha.alg.feature.vo.ComponentInfo;
import cn.com.duiba.nezha.alg.feature.vo.MaterialContextFeature;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeature;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeatureInfo;
import cn.com.duiba.nezha.alg.feature.vo.SlotFeature;
import cn.com.duiba.nezha.alg.feature.vo.SlotMaterialFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserMaterialFeature;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialFeatureParse {
    private static final Logger logger = LoggerFactory.getLogger(MaterialFeatureParse.class);
    public static int F_MAX_SIZE = 64;
    public static int[] appSckExpPvBucket = new int[]{3, 16, 128, 512, 2048, 8192, 20480, 40960, 81920, 163840};
    public static int[] appSckExpUvBucket = new int[]{2, 8, 32, 256, 1024, 4096, 16384, 32768, 65536, 98304};
    public static int[] appSckClkBucket = new int[]{0, 2, 8, 32, 128, 256, 512, 1024, 4096, 8192};
    public static int[] sexpWeekBucket = new int[]{0, 5, 17, 61, 170, 286, 650, 2446, 14211, 277794};
    public static int[] sexpDayBucket = new int[]{0, 3, 10, 24, 40, 75, 161, 795, 27479, 120623};
    public static int[] sclickWeekBucket = new int[]{0, 1, 2, 4, 9, 19, 61, 164, 1165, 8893};
    public static int[] sclickDayBucket = new int[]{0, 1, 1, 2, 3, 9, 24, 140, 1231, 2740};
    public static int[] slotSckExpUvBucket = new int[]{2, 8, 32, 256, 512, 1024, 4096, 16384, 65536};
    public static int[] slotSckClkUvBucket = new int[]{0, 2, 8, 32, 128, 256, 512, 1024, 2048, 3072};
    public static int[] expWeekBucket = new int[]{0, 3, 10, 46, 156, 369, 875, 4103, 36319, 431986};
    public static int[] expDayBucket = new int[]{0, 3, 9, 24, 43, 87, 201, 1626, 47910, 126840};
    public static int[] clickWeekBucket = new int[]{0, 1, 3, 7, 14, 44, 123, 379, 3391, 14571};
    public static int[] clickDayBucket = new int[]{0, 1, 2, 3, 4, 10, 35, 199, 1501, 4698};
    public static int[] convertCntBucket = new int[]{0, 1, 2, 5, 10, 20, 50, 100, 500, 1000, 2000};
    public static int[] bconvertCntBucket = new int[]{0, 1, 2, 5, 10, 20, 50, 100, 500, 1000, 2000};
    public static double[] userCtrBucket = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 1.0};
    public static double[] slotCtrBucket = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 1.0};
    public static int[] sckExpUvBucket = new int[]{3, 16, 128, 512, 2048, 8192, 20480, 40960, 81920, 163840};
    public static int[] sckClkUvBucket = new int[]{0, 4, 16, 64, 256, 1024, 4096, 8192, 16384, 32768};
    public static int[] userBehaviorBucket = new int[]{0, 1, 3, 5, 10, 15, 35, 50, 80};
    public static int[] slotMaterialTagExposeDayBucket = new int[]{3, 6, 10, 20, 50, 100, 500, 2000, 10000, 750000};
    public static int[] slotMaterialTagExposeSevenBucket = new int[]{3, 9, 23, 57, 138, 358, 1086, 4313, 23877, 1547838};
    public static int[] slotMaterialTagExposeHisBucket = new int[]{3, 12, 37, 103, 282, 843, 2612, 10716, 65838, 4978025};
    public static int[] slotMaterialTagClickDayBucket = new int[]{1, 2, 3, 5, 10, 20, 60, 180, 900, 3600};
    public static int[] slotMaterialTagClickSevenBucket = new int[]{1, 3, 6, 11, 24, 58, 153, 539, 2977, 135801};
    public static int[] slotMaterialTagClickHisBucket = new int[]{3, 12, 37, 103, 282, 843, 2612, 10716, 65838, 4978025};
    public static int[] slotSkinTypeExposeDayBucket = new int[]{1, 2, 5, 20, 80, 300, 1000, 2000, 8000, 30000};
    public static int[] slotSkinTypeExposeSevenBucket = new int[]{1, 4, 15, 63, 219, 770, 2293, 7241, 32396, 1026962};
    public static int[] slotSkinTypeExposeHisBucket = new int[]{1, 2, 4, 18, 111, 547, 2695, 11694, 57077, 3085582};
    public static int[] slotSkinTypeClickDayBucket = new int[]{1, 2, 3, 9, 28, 88, 180, 400, 1500, 5000};
    public static int[] slotSkinTypeClickSevenBucket = new int[]{2, 8, 24, 80, 272, 717, 1911, 5349, 22938, 864145};
    public static int[] slotSkinTypeClickHisBucket = new int[]{1, 4, 14, 54, 217, 896, 3155, 10601, 44939, 2458473};
    public static int[] slotRewardTagExposeDayBucket = new int[]{1, 2, 4, 8, 15, 30, 75, 220, 1200, 6000};
    public static int[] slotRewardTagExposeSevenBucket = new int[]{2, 4, 7, 14, 27, 58, 146, 507, 3001, 153710};
    public static int[] slotRewardTagExposeHisBucket = new int[]{2, 4, 9, 19, 39, 87, 226, 799, 6388, 448837};
    public static int[] slotRewardTagClickDayBucket = new int[]{1, 2, 3, 5, 10, 23, 60, 150, 800, 4800};
    public static int[] slotRewardTagClickSevenBucket = new int[]{2, 3, 7, 12, 23, 55, 132, 387, 2239, 126967};
    public static int[] slotRewardTagClickHisBucket = new int[]{2, 4, 9, 17, 35, 79, 199, 637, 4440, 220232};
    public static int[] appMaterialTagExposeDayBucket = new int[]{2, 7, 18, 40, 110, 300, 800, 3000, 18000, 120000};
    public static int[] appMaterialTagExposeSevenBucket = new int[]{3, 12, 33, 87, 231, 622, 1841, 6897, 40033, 2893258};
    public static int[] appMaterialTagExposeHisBucket = new int[]{4, 15, 54, 170, 532, 1568, 4889, 18573, 108078, 8423830};
    public static int[] appMaterialTagClickDayBucket = new int[]{1, 2, 4, 9, 20, 45, 120, 380, 1800, 9000};
    public static int[] appMaterialTagClickSevenBucket = new int[]{1, 3, 7, 15, 33, 84, 237, 847, 4832, 244629};
    public static int[] appMaterialTagClickHisBucket = new int[]{2, 5, 12, 30, 71, 187, 556, 2013, 12229, 827318};
    public static int[] appSkinTypeExposeDayBucket = new int[]{1, 2, 9, 35, 120, 400, 1200, 5000, 22000, 65000};
    public static int[] appSkinTypeExposeSevenBucket = new int[]{1, 3, 17, 83, 335, 1263, 3725, 12053, 59810, 1666682};
    public static int[] appSkinTypeExposeHisBucket = new int[]{1, 3, 17, 156, 823, 2025, 4229, 17325, 102025, 3854952};
    public static int[] appSkinTypeClickDayBucket = new int[]{1, 3, 9, 30, 100, 350, 700, 2100, 8500, 20000};
    public static int[] appSkinTypeClickSevenBucket = new int[]{2, 10, 34, 128, 408, 1058, 3607, 9581, 39887, 1055972};
    public static int[] appSkinTypeClickHisBucket = new int[]{1, 4, 18, 85, 356, 1317, 4375, 18299, 83998, 3017636};
    public static int[] appRewardTagExposeDayBucket = new int[]{1, 2, 5, 8, 15, 33, 120, 450, 2500, 100000};
    public static int[] appRewardTagExposeSevenBucket = new int[]{2, 4, 9, 17, 35, 82, 223, 837, 5324, 289787};
    public static int[] appRewardTagExposeHisBucket = new int[]{2, 4, 9, 23, 49, 119, 340, 1274, 11159, 682999};
    public static int[] appRewardTagClickDayBucket = new int[]{1, 2, 3, 5, 10, 23, 60, 150, 1000, 48000};
    public static int[] appRewardTagClickSevenBucket = new int[]{2, 4, 8, 15, 29, 70, 187, 599, 3560, 177802};
    public static int[] appRewardTagClickHisBucket = new int[]{2, 5, 10, 20, 42, 100, 303, 1025, 7421, 399933};
    public static int[] bigCntBucket = new int[]{0, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 500000, 1000000};
    public static int[] timeBucket = new int[]{0, 1, 3, 5, 10, 15, 20, 50};
    public static Map<String, String> AdvertIndustryCodes = new HashMap<String, String>(){
        {
            this.put("28548", "02.15.0007");
            this.put("28549", "02.15.0007");
            this.put("28550", "02.15.0007");
            this.put("28551", "02.15.0007");
            this.put("28552", "02.15.0007");
            this.put("28553", "02.15.0007");
            this.put("28562", "02.10.0005");
            this.put("28563", "02.10.0005");
            this.put("28564", "02.10.0005");
            this.put("28565", "02.10.0005");
            this.put("28566", "02.10.0005");
            this.put("28567", "02.10.0005");
            this.put("28966", "02.24.0003");
            this.put("28967", "02.24.0003");
            this.put("28968", "02.24.0003");
            this.put("28969", "02.24.0003");
            this.put("28970", "02.24.0003");
            this.put("28971", "02.24.0003");
            this.put("28574", "02.22.0001");
            this.put("28575", "02.22.0001");
            this.put("28576", "02.22.0001");
            this.put("28577", "02.22.0001");
            this.put("28578", "02.22.0001");
            this.put("28579", "02.22.0001");
            this.put("28985", "02.05.0002");
            this.put("28986", "02.05.0002");
            this.put("28987", "02.05.0002");
            this.put("28989", "02.05.0002");
            this.put("28990", "02.05.0002");
            this.put("28992", "02.05.0002");
            this.put("28614", "02.06.0004");
            this.put("28615", "02.06.0004");
            this.put("28616", "02.06.0004");
            this.put("28617", "02.06.0004");
            this.put("28618", "02.06.0004");
            this.put("28619", "02.06.0004");
            this.put("28622", "02.06.0003");
            this.put("28623", "02.06.0003");
            this.put("28624", "02.06.0003");
            this.put("28625", "02.06.0003");
            this.put("28626", "02.06.0003");
            this.put("28627", "02.06.0003");
            this.put("28654", "02.03.0007");
            this.put("28655", "02.03.0007");
            this.put("28656", "02.03.0007");
            this.put("28657", "02.03.0007");
            this.put("28658", "02.03.0007");
            this.put("28659", "02.03.0007");
            this.put("28661", "02.19.0001");
            this.put("28662", "02.19.0001");
            this.put("28663", "02.19.0001");
            this.put("28664", "02.19.0001");
            this.put("28665", "02.19.0001");
            this.put("28666", "02.19.0001");
            this.put("28874", "02.23.0001");
            this.put("28875", "02.23.0001");
            this.put("28876", "02.23.0001");
            this.put("28877", "02.23.0001");
            this.put("28878", "02.23.0001");
            this.put("28879", "02.23.0001");
            this.put("28880", "02.01.0002");
            this.put("28881", "02.01.0002");
            this.put("28882", "02.01.0002");
            this.put("28883", "02.01.0002");
            this.put("28884", "02.01.0002");
            this.put("28885", "02.01.0002");
            this.put("28892", "02.01.0007");
            this.put("28893", "02.01.0007");
            this.put("28894", "02.01.0007");
            this.put("28895", "02.01.0007");
            this.put("28914", "02.01.0007");
            this.put("28982", "02.01.0007");
            this.put("28896", "02.16.0002");
            this.put("28897", "02.16.0002");
            this.put("28898", "02.16.0002");
            this.put("28899", "02.16.0002");
            this.put("28900", "02.16.0002");
            this.put("28901", "02.16.0002");
            this.put("28902", "02.24.0001");
            this.put("28903", "02.24.0001");
            this.put("28904", "02.24.0001");
            this.put("28905", "02.24.0001");
            this.put("28906", "02.24.0001");
            this.put("28907", "02.24.0001");
            this.put("28960", "02.05.0001");
            this.put("28961", "02.05.0001");
            this.put("28962", "02.05.0001");
            this.put("28963", "02.05.0001");
            this.put("28964", "02.05.0001");
            this.put("28965", "02.05.0001");
            this.put("28921", "02.10.0002");
            this.put("28922", "02.10.0002");
            this.put("28923", "02.10.0002");
            this.put("28924", "02.10.0002");
            this.put("28925", "02.10.0002");
            this.put("28950", "02.10.0002");
            this.put("28983", "02.09.0001");
            this.put("28984", "02.09.0001");
            this.put("28988", "02.09.0001");
            this.put("28991", "02.09.0001");
            this.put("28993", "02.09.0001");
            this.put("28994", "02.09.0001");
            this.put("28932", "02.17.0003");
            this.put("28933", "02.17.0003");
            this.put("28934", "02.17.0003");
            this.put("28935", "02.17.0003");
            this.put("28936", "02.17.0003");
            this.put("28937", "02.17.0003");
            this.put("28938", "02.04.0001");
            this.put("28939", "02.04.0001");
            this.put("28940", "02.04.0001");
            this.put("28941", "02.04.0001");
            this.put("28942", "02.04.0001");
            this.put("28943", "02.04.0001");
            this.put("28954", "02.21.0009");
            this.put("28955", "02.21.0009");
            this.put("28956", "02.21.0009");
            this.put("28957", "02.21.0009");
            this.put("28958", "02.21.0009");
            this.put("28959", "02.21.0009");
        }
    };
    public static Map<String, Integer> actRewardCodes = new HashMap<String, Integer>(){
        {
            this.put("29", 0);
            this.put("30", 1);
            this.put("31", 2);
            this.put("32", 3);
            this.put("33", 4);
            this.put("34", 5);
            this.put("35", 6);
            this.put("36", 7);
            this.put("37", 8);
            this.put("38", 9);
            this.put("39", 10);
            this.put("40", 11);
            this.put("41", 12);
            this.put("42", 13);
            this.put("43", 14);
        }
    };
    public static Map<String, Integer> actSkinTypeCodes = new HashMap<String, Integer>(){
        {
            this.put("1", 0);
            this.put("2", 1);
            this.put("3", 2);
            this.put("4", 3);
            this.put("5", 4);
            this.put("6", 5);
            this.put("7", 6);
            this.put("8", 7);
            this.put("9", 8);
            this.put("10", 9);
            this.put("11", 10);
            this.put("12", 11);
            this.put("13", 12);
            this.put("14", 13);
            this.put("15", 14);
            this.put("16", 15);
            this.put("17", 16);
            this.put("18", 17);
            this.put("19", 18);
            this.put("20", 19);
            this.put("21", 20);
            this.put("22", 21);
            this.put("23", 22);
            this.put("24", 23);
            this.put("25", 24);
            this.put("26", 25);
            this.put("27", 26);
            this.put("28", 27);
            this.put("29", 28);
            this.put("30", 29);
            this.put("31", 30);
            this.put("32", 31);
            this.put("33", 32);
        }
    };
    public static Map<String, Integer> materialTagCodes = new HashMap<String, Integer>(){
        {
            this.put("1407", 0);
            this.put("1408", 1);
            this.put("1409", 2);
            this.put("1410", 3);
            this.put("1411", 4);
            this.put("1413", 5);
            this.put("1414", 6);
            this.put("1415", 7);
            this.put("1416", 8);
            this.put("1417", 9);
            this.put("1419", 10);
            this.put("1420", 11);
            this.put("1421", 12);
            this.put("1422", 13);
            this.put("1423", 14);
            this.put("1424", 15);
            this.put("1425", 16);
            this.put("1426", 17);
            this.put("1427", 18);
            this.put("1429", 19);
            this.put("1432", 20);
            this.put("1442", 21);
            this.put("1443", 22);
            this.put("1445", 23);
            this.put("1446", 24);
            this.put("1498", 25);
            this.put("1499", 26);
            this.put("1500", 27);
            this.put("1501", 28);
            this.put("1502", 29);
            this.put("1506", 30);
            this.put("1507", 31);
            this.put("1508", 32);
            this.put("1509", 33);
            this.put("1535", 34);
            this.put("1537", 35);
            this.put("1538", 36);
            this.put("1539", 37);
            this.put("1540", 38);
            this.put("1541", 39);
            this.put("1542", 40);
            this.put("1543", 41);
            this.put("1547", 42);
            this.put("1549", 43);
            this.put("1550", 44);
            this.put("1551", 45);
            this.put("1555", 46);
            this.put("1556", 47);
            this.put("1564", 48);
            this.put("1567", 49);
            this.put("1568", 50);
            this.put("1868", 51);
            this.put("1869", 52);
            this.put("1870", 53);
            this.put("1871", 54);
            this.put("1872", 55);
            this.put("1873", 56);
            this.put("1874", 57);
            this.put("1875", 58);
            this.put("1876", 59);
            this.put("1877", 60);
            this.put("1878", 61);
            this.put("1879", 62);
            this.put("1880", 63);
            this.put("1881", 64);
            this.put("1882", 65);
            this.put("1883", 66);
            this.put("1884", 67);
            this.put("1894", 68);
            this.put("1895", 69);
            this.put("1896", 70);
            this.put("1897", 71);
            this.put("1898", 72);
            this.put("1899", 73);
            this.put("1900", 74);
            this.put("1901", 75);
            this.put("1903", 76);
            this.put("1904", 77);
            this.put("1906", 78);
            this.put("1907", 79);
            this.put("1908", 80);
            this.put("1909", 81);
            this.put("1910", 82);
            this.put("1911", 83);
            this.put("1912", 84);
            this.put("1913", 85);
            this.put("1914", 86);
            this.put("1915", 87);
            this.put("1975", 88);
            this.put("1985", 89);
            this.put("1986", 90);
            this.put("1987", 91);
            this.put("1990", 92);
            this.put("1991", 93);
            this.put("1995", 94);
            this.put("1996", 95);
            this.put("1999", 96);
            this.put("2009", 97);
            this.put("2023", 98);
            this.put("2024", 99);
            this.put("2025", 100);
            this.put("2029", 101);
            this.put("2030", 102);
            this.put("2033", 103);
            this.put("2036", 104);
            this.put("2042", 105);
            this.put("2049", 106);
        }
    };

    public static Map<String, String> generateFeatureMapStatic(MaterialFeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                Map<String, ComponentInfo> appToRewardTagMap;
                Map<String, ComponentInfo> appToActSkinMap;
                Map<String, ComponentInfo> userToSlotRewardTagMap;
                Map<String, ComponentInfo> userToSlotActSkinMap;
                Map<String, ComponentInfo> userToSlotMatTagMap;
                Map<String, ComponentInfo> slotToRewardTagMap;
                Map<String, ComponentInfo> slotToActSkinMap;
                Map<String, ComponentInfo> userToRewardTagMap;
                UserFeature userFeature = Optional.ofNullable(cf.getUserFeature()).orElse(new UserFeature());
                retMap.put("f451001", userFeature.getSex());
                retMap.put("f451002", userFeature.getAge());
                retMap.put("f451003", userFeature.getMarry());
                retMap.put("f451004", userFeature.getConsumeLevel());
                retMap.put("f451005", userFeature.getPermanentProvince());
                retMap.put("f451006", userFeature.getPermanentCity());
                retMap.put("f9902", userFeature.getAppList());
                retMap.put("f9801", userFeature.getSigList());
                if (userFeature.getExpDayMaterials() != null) {
                    List<String> expDayMaterials = Arrays.asList(userFeature.getExpDayMaterials().split(","));
                    retMap.put("f390001", MaterialFeatureParse.subList(expDayMaterials));
                    retMap.put("f391001", FeatureParse.bucket(expDayMaterials.size(), userBehaviorBucket).toString());
                } else {
                    retMap.put("f390001", "null");
                    retMap.put("f391001", "null");
                }
                if (userFeature.getClickDayMaterials() != null) {
                    List<String> clickDayMaterials = Arrays.asList(userFeature.getClickDayMaterials().split(","));
                    retMap.put("f390002", MaterialFeatureParse.subList(clickDayMaterials));
                    retMap.put("f391002", FeatureParse.bucket(clickDayMaterials.size(), userBehaviorBucket).toString());
                } else {
                    retMap.put("f390002", "null");
                    retMap.put("f391002", "null");
                }
                retMap.put("f390003", MaterialFeatureParse.sortSubList(userFeature.getExpWeekMaterials()));
                retMap.put("f390004", MaterialFeatureParse.sortSubList(userFeature.getClickWeekMaterials()));
                SlotFeature slotFeature = Optional.ofNullable(cf.getSlotFeature()).orElse(new SlotFeature());
                retMap.put("f108001", DataUtil.Long2String((Long)slotFeature.getSlotId()));
                retMap.put("f109001", DataUtil.Long2String((Long)slotFeature.getSlotType()));
                AppFeature appFeature = Optional.ofNullable(cf.getAppFeature()).orElse(new AppFeature());
                retMap.put("f201001", DataUtil.Long2String((Long)appFeature.getAppId()));
                retMap.put("f205001", appFeature.getAppIndustryTagPid());
                retMap.put("f205002", appFeature.getAppIndustryTagId());
                MaterialContextFeature contextFeature = Optional.ofNullable(cf.getMaterialContextFeature()).orElse(new MaterialContextFeature());
                retMap.put("f501001", contextFeature.getUa());
                retMap.put("f503001", DataUtil.Long2String((Long)contextFeature.getCityId()));
                retMap.put("f503003", contextFeature.getProvinceCode());
                retMap.put("f504001", contextFeature.getModel());
                retMap.put("f390017", contextFeature.getExposeHour());
                retMap.put("f390018", contextFeature.getExposeWeekDay());
                retMap.put("f390019", contextFeature.getExposeHolidays());
                MaterialFeatureParse.putMapNotNull(retMap, "f508006", contextFeature.getDeviceTrademark());
                MaterialFeatureParse.putMapNotNull(retMap, "f507001", contextFeature.getOperatorType());
                MaterialFeatureParse.putMapNotNull(retMap, "f507003", contextFeature.getOsVersion());
                MaterialFeatureParse.putMapNotNull(retMap, "f506001", contextFeature.getConnectionType());
                JSONObject weekCvrTradeMap = DataUtil.stringToJson((String)slotFeature.getWeekCvrTrade());
                MaterialFeatureParse.putMapNotNull(retMap, "f214003", FeatureParse.getUserCategoryActLevelByBucket(weekCvrTradeMap, FeatureParse.tradeCodes, FeatureParse.statCvrBucket));
                JSONObject weekCvrCateMap = DataUtil.stringToJson((String)slotFeature.getWeekCvrCate());
                MaterialFeatureParse.putMapNotNull(retMap, "f222004", FeatureParse.getUserCategoryActLevelByBucket(weekCvrCateMap, FeatureParse.resourceCodes, FeatureParse.statCvrBucket));
                Map appCatePrefMap = DataUtil.stringToMap((String)userFeature.getAppCatePref(), (Object)0);
                MaterialFeatureParse.putMapNotNull(retMap, "f461001", FeatureParse.getUserCategoryActLevelByBucket(appCatePrefMap, FeatureParse.appCodes, FeatureParse.cntBucket));
                Map textCatePrefMap = DataUtil.stringToMap((String)userFeature.getTextCatePref(), (Object)0);
                MaterialFeatureParse.putMapNotNull(retMap, "f461003", FeatureParse.getUserCategoryActLevelByBucket(textCatePrefMap, FeatureParse.msgSigCodes, FeatureParse.cntBucket));
                MaterialFeatureParse.putMapNotNull(retMap, "f9701", userFeature.getUserBasicTags());
                MaterialFeatureParse.putMapNotNull(retMap, "f9802", FeatureBaseParse.getLengthLevel(userFeature.getSigList(), 15, 1));
                MaterialFeatureParse.putMapNotNull(retMap, "f9803", userFeature.getMsgCategory());
                MaterialFeatureParse.putMapNotNull(retMap, "f9903", FeatureBaseParse.getLengthLevel(userFeature.getAppList(), 5, 100, 5));
                MaterialFeatureParse.putMapNotNull(retMap, "f9935", userFeature.getAppList());
                String appCategoryLevel = FeatureBaseParse.getCategoryLevel(userFeature.getAppCategory(), 10, 1);
                MaterialFeatureParse.putMapNotNull(retMap, "f9940", appCategoryLevel);
                MaterialFeatureParse.putMapNotNull(retMap, "f9944", userFeature.getTopAppList3());
                MaterialFeatureParse.putMapNotNull(retMap, "f601002", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(userFeature.getDayOrderRank(), FeatureParse.dayOrderRankBucket)));
                MaterialFeatureParse.putMapNotNull(retMap, "f602002", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(userFeature.getOrderRank(), FeatureParse.orderRankBucket)));
                Long lastChargeStatus = FeatureParse.getChargeStatus(userFeature.getLastChargeNums());
                MaterialFeatureParse.putMapNotNull(retMap, "f608001", DataUtil.Long2String((Long)lastChargeStatus));
                MaterialFeatureParse.putMapNotNull(retMap, "f413007", userFeature.getLastLaunchTrade());
                MaterialFeatureParse.putMapNotNull(retMap, "f413008", DataUtil.Integer2String((Integer)userFeature.getClickLaunchTrade()));
                MaterialFeatureParse.putMapNotNull(retMap, "f414008", DataUtil.Integer2String((Integer)userFeature.getEffectClickTrade()));
                MaterialFeatureParse.putMapNotNull(retMap, "f434001", MaterialFeatureParse.bucket(userFeature.getVouchFailed(), FeatureParse.cntBucket).toString());
                MaterialFeatureParse.putMapNotNull(retMap, "f434004", MaterialFeatureParse.bucket(userFeature.getReject(), FeatureParse.cntBucket).toString());
                Map<String, Map<String, Long>> ubpMap = FeatureParse.getUserBehavioralPreference(userFeature.getUIIds(), userFeature.getUILaunchPV(), userFeature.getUIClickPv(), userFeature.getUIEffectPv());
                MaterialFeatureParse.putMapNotNull(retMap, "f808001", FeatureParse.getUserBehavioralPreference(2, "ctr", ubpMap, null));
                MaterialFeatureParse.putMapNotNull(retMap, "f809001", FeatureParse.getUserBehavioralPreference(0, "ctr", ubpMap, null));
                MaterialFeatureParse.putMapNotNull(retMap, "f808002", FeatureParse.getUserBehavioralPreference(2, "cvr", ubpMap, null));
                MaterialFeatureParse.putMapNotNull(retMap, "f809002", FeatureParse.getUserBehavioralPreference(0, "cvr", ubpMap, null));
                MaterialFeatureParse.putMapNotNull(retMap, "f830001", userFeature.getClickAdIds());
                MaterialFeatureParse.putMapNotNull(retMap, "f830004", userFeature.getClickTrIds());
                MaterialFeatureParse.putMapNotNull(retMap, "f831001", userFeature.getConvertAdverts());
                MaterialFeatureParse.putMapNotNull(retMap, "f831004", userFeature.getConvertTrades());
                MaterialFeatureParse.putMapNotNull(retMap, "f832001", userFeature.getBConvertAdverts());
                MaterialFeatureParse.putMapNotNull(retMap, "f832004", userFeature.getBConvertTrades());
                retMap.put("f411001", FeatureParse.bucket(userFeature.getActivityRequest(), FeatureParse.cntBucket).toString());
                retMap.put("f411002", FeatureParse.bucket(userFeature.getWeekActivityRequest(), FeatureParse.cntBucket).toString());
                retMap.put("f411004", FeatureParse.bucket(userFeature.getIntervalActivityRequest(), FeatureParse.cntBucket).toString());
                retMap.put("f411005", userFeature.getPeriodActivityRequest());
                retMap.put("f412001", FeatureParse.bucket(userFeature.getActivityJoin(), FeatureParse.cntBucket).toString());
                retMap.put("f412002", FeatureParse.bucket(userFeature.getWeekActivityJoin(), FeatureParse.cntBucket).toString());
                retMap.put("f412004", FeatureParse.bucket(userFeature.getIntervalActivityJoin(), FeatureParse.cntBucket).toString());
                retMap.put("f412005", userFeature.getPeriodActivityJoin());
                Map clickTraceActMap = DataUtil.stringToMap((String)userFeature.getClickTrade(), (Object)0);
                retMap.put("f414001", FeatureParse.getUserCategoryActLevelByBucket(clickTraceActMap, FeatureParse.tradeCodes, FeatureParse.cntBucket));
                Map weekClickTradeActMap = DataUtil.stringToMap((String)userFeature.getWeekClickTrade(), (Object)0);
                retMap.put("f414002", FeatureParse.getUserCategoryActLevelByBucket(weekClickTradeActMap, FeatureParse.tradeCodes, FeatureParse.cntBucket));
                retMap.put("f414004", FeatureParse.bucket(userFeature.getIntervalClickTrade(), FeatureParse.cntBucket).toString());
                retMap.put("f414005", userFeature.getPeriodClickTrade());
                retMap.put("f414007", userFeature.getLastClickTrade());
                Map effectTradeActMap = DataUtil.stringToMap((String)userFeature.getEffectTrade(), (Object)0);
                retMap.put("f415001", FeatureParse.getUserCategoryActLevelByBucket(effectTradeActMap, FeatureParse.tradeCodes, FeatureParse.cntBucket));
                Map weekEffectTradeActMap = DataUtil.stringToMap((String)userFeature.getWeekEffectTrade(), (Object)0);
                retMap.put("f415002", FeatureParse.getUserCategoryActLevelByBucket(weekEffectTradeActMap, FeatureParse.tradeCodes, FeatureParse.cntBucket));
                retMap.put("f415004", FeatureParse.bucket(userFeature.getIntervalEffectTrade(), FeatureParse.cntBucket).toString());
                retMap.put("f415005", userFeature.getPeriodEffectTrade());
                retMap.put("f415007", userFeature.getLastEffectTrade());
                retMap.put("f391003", FeatureParse.bucket(userFeature.getExpWeekCnt(), userBehaviorBucket).toString());
                retMap.put("f391004", FeatureParse.bucket(userFeature.getClickWeekCnt(), userBehaviorBucket).toString());
                retMap.put("f391005", FeatureParse.bucket(userFeature.getExpHisCnt(), userBehaviorBucket).toString());
                retMap.put("f391006", FeatureParse.bucket(userFeature.getClickHisCnt(), userBehaviorBucket).toString());
                Map<String, ComponentInfo> userToActSkinMap = userFeature.getUserToActSkinMap();
                if (!AssertUtil.isEmpty(userToActSkinMap)) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = MaterialFeatureParse.getSplitTimeMap(userToActSkinMap);
                    retMap.put("f391013", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391014", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391015", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391016", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391017", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391018", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, userBehaviorBucket));
                }
                if (!AssertUtil.isEmpty(userToRewardTagMap = userFeature.getUserToRewardTagMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = MaterialFeatureParse.getSplitTimeMap(userToRewardTagMap);
                    retMap.put("f391019", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391020", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391021", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391022", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391023", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391024", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, userBehaviorBucket));
                }
                if (!AssertUtil.isEmpty(slotToActSkinMap = slotFeature.getSlotToActSkinMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = MaterialFeatureParse.getSplitTimeMap(slotToActSkinMap);
                    retMap.put("f391031", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actSkinTypeCodes, slotSkinTypeExposeDayBucket));
                    retMap.put("f391032", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, slotSkinTypeExposeSevenBucket));
                    retMap.put("f391033", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, slotSkinTypeExposeHisBucket));
                    retMap.put("f391034", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actSkinTypeCodes, slotSkinTypeClickDayBucket));
                    retMap.put("f391035", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, slotSkinTypeClickSevenBucket));
                    retMap.put("f391036", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, slotSkinTypeClickHisBucket));
                }
                if (!AssertUtil.isEmpty(slotToRewardTagMap = slotFeature.getSlotToRewardTagMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = MaterialFeatureParse.getSplitTimeMap(slotToRewardTagMap);
                    retMap.put("f391037", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actRewardCodes, slotRewardTagExposeDayBucket));
                    retMap.put("f391038", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, slotRewardTagExposeSevenBucket));
                    retMap.put("f391039", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, slotRewardTagExposeHisBucket));
                    retMap.put("f391040", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actRewardCodes, slotRewardTagClickDayBucket));
                    retMap.put("f391041", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, slotRewardTagClickSevenBucket));
                    retMap.put("f391042", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, slotRewardTagClickHisBucket));
                }
                if (!AssertUtil.isEmpty(userToSlotMatTagMap = slotFeature.getUserToSlotMatTagMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = MaterialFeatureParse.getSplitTimeMap(userToSlotMatTagMap);
                    retMap.put("f391064", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), materialTagCodes, userBehaviorBucket));
                }
                if (!AssertUtil.isEmpty(userToSlotActSkinMap = slotFeature.getUserToSlotActSkinMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = MaterialFeatureParse.getSplitTimeMap(userToSlotActSkinMap);
                    retMap.put("f391065", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391066", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391067", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391068", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, userBehaviorBucket));
                }
                if (!AssertUtil.isEmpty(userToSlotRewardTagMap = slotFeature.getUserToSlotRewardTagMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = MaterialFeatureParse.getSplitTimeMap(userToSlotRewardTagMap);
                    retMap.put("f391069", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391070", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391071", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391072", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, userBehaviorBucket));
                }
                if (!AssertUtil.isEmpty(appToActSkinMap = appFeature.getAppToActSkinMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = MaterialFeatureParse.getSplitTimeMap(appToActSkinMap);
                    retMap.put("f391049", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actSkinTypeCodes, appSkinTypeExposeDayBucket));
                    retMap.put("f391050", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, appSkinTypeExposeSevenBucket));
                    retMap.put("f391051", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, appSkinTypeExposeHisBucket));
                    retMap.put("f391052", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actSkinTypeCodes, appSkinTypeClickDayBucket));
                    retMap.put("f391053", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, appSkinTypeClickSevenBucket));
                    retMap.put("f391054", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, appSkinTypeClickHisBucket));
                }
                if (!AssertUtil.isEmpty(appToRewardTagMap = appFeature.getAppToRewardTagMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = MaterialFeatureParse.getSplitTimeMap(appToRewardTagMap);
                    retMap.put("f391055", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actRewardCodes, appRewardTagExposeDayBucket));
                    retMap.put("f391056", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, appRewardTagExposeSevenBucket));
                    retMap.put("f391057", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, appRewardTagExposeHisBucket));
                    retMap.put("f391058", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actRewardCodes, appRewardTagClickDayBucket));
                    retMap.put("f391059", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, appRewardTagClickSevenBucket));
                    retMap.put("f391060", FeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, appRewardTagClickHisBucket));
                }
            }
        }
        catch (Exception e) {
            logger.error("MaterialFeatureParse.generateFeatureMapStatic error:", (Throwable)e);
            logger.error(JSONObject.toJSONString((Object)cf));
        }
        return retMap;
    }

    private static Map<Integer, Map<String, Integer>> getSplitTimeMap(Map<String, ComponentInfo> componentInfoMap) {
        HashMap<Integer, Map<String, Integer>> splitMap = new HashMap<Integer, Map<String, Integer>>();
        for (Map.Entry<String, ComponentInfo> entry : componentInfoMap.entrySet()) {
            String key = entry.getKey();
            ComponentInfo componentInfo = entry.getValue();
            Map firstMap = splitMap.getOrDefault(0, new HashMap());
            Map secMap = splitMap.getOrDefault(1, new HashMap());
            Map thirdMap = splitMap.getOrDefault(2, new HashMap());
            Map fourthMap = splitMap.getOrDefault(3, new HashMap());
            Map fifthMap = splitMap.getOrDefault(4, new HashMap());
            Map sixthMap = splitMap.getOrDefault(5, new HashMap());
            firstMap.put(key, MaterialFeatureParse.getValue(componentInfo.getCurrDayExpCnt()));
            secMap.put(key, MaterialFeatureParse.getValue(componentInfo.getCurrDayClickCnt()));
            thirdMap.put(key, MaterialFeatureParse.getValue(componentInfo.getLastSevenDaysExpCnt()));
            fourthMap.put(key, MaterialFeatureParse.getValue(componentInfo.getLastSevenDaysClickCnt()));
            fifthMap.put(key, MaterialFeatureParse.getValue(componentInfo.getHisExpCnt()));
            sixthMap.put(key, MaterialFeatureParse.getValue(componentInfo.getHisClickCnt()));
            splitMap.put(0, firstMap);
            splitMap.put(1, thirdMap);
            splitMap.put(2, fifthMap);
            splitMap.put(3, secMap);
            splitMap.put(4, fourthMap);
            splitMap.put(5, sixthMap);
        }
        return splitMap;
    }

    private static Integer getValue(Integer num) {
        if (num != null) {
            return num;
        }
        return 0;
    }

    public static Map<String, String> generateFeatureMapDynamic(MaterialFeatureDo cf, MaterialFeatureDo staticCf, Long materialId) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        if (cf == null) {
            return retMap;
        }
        try {
            Map<Long, MaterialFeatureInfo> featureInfoMap = cf.getMaterialFeatureInfoMap();
            if (null == featureInfoMap) {
                return retMap;
            }
            if (featureInfoMap.containsKey(materialId)) {
                MaterialFeatureInfo materialFeatureInfo;
                if (AdvertIndustryCodes.containsKey(String.valueOf(materialId))) {
                    retMap.put("f109002", AdvertIndustryCodes.get(String.valueOf(materialId)));
                }
                if (null != (materialFeatureInfo = featureInfoMap.get(materialId))) {
                    AppMaterialFeature amFeature;
                    SlotMaterialFeature smFeature;
                    UserMaterialFeature umFeature;
                    MaterialFeature materialFeature = materialFeatureInfo.getMaterialFeature();
                    if (null != materialFeature) {
                        retMap.put("f390000", DataUtil.Long2String((Long)materialId));
                        retMap.put("f390005", materialFeature.getCustomization());
                        retMap.put("f390006", materialFeature.getIndustry());
                        retMap.put("f390007", materialFeature.getSlotNature());
                        retMap.put("f390008", materialFeature.getDesignHue());
                        retMap.put("f390047", materialFeature.getStrategy());
                        retMap.put("f390048", materialFeature.getRewardElement());
                        retMap.put("f390049", materialFeature.getDesignType());
                        UserFeature userFeature = Optional.ofNullable(cf.getUserFeature()).orElse(new UserFeature());
                        Map<String, ComponentInfo> userToMatTagMap = userFeature.getUserToMatTagMap();
                        if (!AssertUtil.isEmpty(userToMatTagMap)) {
                            Map<Integer, Map<String, Integer>> splitTimeMap = MaterialFeatureParse.getSplitTimeMap(userToMatTagMap);
                            retMap.put("f391073", MaterialFeatureParse.getCurrMaterialTagInfo(materialFeature, splitTimeMap.get(0)));
                        }
                        retMap.put("f390009", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getExposeWeekCnt(), expWeekBucket)));
                        retMap.put("f390010", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getClickWeekCnt(), clickWeekBucket)));
                        retMap.put("f390011", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getConvertWeekCnt(), convertCntBucket)));
                        retMap.put("f390012", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getBConvertWeekCnt(), bconvertCntBucket)));
                        retMap.put("f390013", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getExposeDayCnt(), expDayBucket)));
                        retMap.put("f390014", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getClickDayCnt(), clickDayBucket)));
                        Double weekCtr = MaterialFeatureParse.calWilsonScore(materialFeature.getExposeWeekCnt(), materialFeature.getClickWeekCnt());
                        Double dayCtr = MaterialFeatureParse.calWilsonScore(materialFeature.getExposeDayCnt(), materialFeature.getClickDayCnt());
                        retMap.put("f390042", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(weekCtr, userCtrBucket)));
                        retMap.put("f390043", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(dayCtr, userCtrBucket)));
                        retMap.put("f390050", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getSckExpUV14D(), sckExpUvBucket)));
                        retMap.put("f390052", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getSckExpUV7D(), sckExpUvBucket)));
                        retMap.put("f390054", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getSckExpUV3D(), sckExpUvBucket)));
                        retMap.put("f390051", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getSckClkUV14D(), sckClkUvBucket)));
                        retMap.put("f390053", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getSckClkUV7D(), sckClkUvBucket)));
                        retMap.put("f390055", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getSckClkUV3D(), sckClkUvBucket)));
                    }
                    if (null != (umFeature = materialFeatureInfo.getUserMaterialFeature())) {
                        retMap.put("f390020", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUExposeHistCnt(), 100L)));
                        retMap.put("f390021", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUExposeWeekCnt(), 100L)));
                        retMap.put("f390022", MaterialFeatureParse.bucket(umFeature.getUExposeInterval(), timeBucket).toString());
                        retMap.put("f390023", DataUtil.Long2String((Long)umFeature.getUExposePeriod()));
                        retMap.put("f390024", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUClickHistCnt(), 100L)));
                        retMap.put("f390025", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUClickWeekCnt(), 100L)));
                        retMap.put("f390026", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUClickDayCnt(), 100L)));
                        retMap.put("f390027", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUExposeDayCnt(), 100L)));
                        retMap.put("f390028", MaterialFeatureParse.bucket(umFeature.getUClickInterval(), timeBucket).toString());
                        retMap.put("f390029", DataUtil.Long2String((Long)umFeature.getUClickPeriod()));
                        Double uhisCtr = MaterialFeatureParse.calWilsonScore(umFeature.getUExposeHistCnt(), umFeature.getUClickHistCnt());
                        Double uweekCtr = MaterialFeatureParse.calWilsonScore(umFeature.getUExposeWeekCnt(), umFeature.getUClickWeekCnt());
                        retMap.put("f390044", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(uhisCtr, userCtrBucket)));
                    }
                    if (null != (smFeature = materialFeatureInfo.getSlotMaterialFeature())) {
                        retMap.put("f390030", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotClickDayCnt(), sclickDayBucket)));
                        retMap.put("f390031", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotClickWeekCnt(), sclickWeekBucket)));
                        retMap.put("f390032", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotExposeWeekCnt(), sexpWeekBucket)));
                        retMap.put("f390033", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotExposeDayCnt(), sexpDayBucket)));
                        retMap.put("f390034", DataUtil.Long2String((Long)smFeature.getSlotExposePeriod()));
                        retMap.put("f390035", DataUtil.Long2String((Long)smFeature.getSlotClickPeriod()));
                        retMap.put("f390036", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotConvertHistCnt(), convertCntBucket)));
                        retMap.put("f390037", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotBConvertHistCnt(), bconvertCntBucket)));
                        retMap.put("f390038", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotConvertWeekCnt(), convertCntBucket)));
                        retMap.put("f390039", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotBConvertWeekCnt(), bconvertCntBucket)));
                        Double sweekCtr = MaterialFeatureParse.calWilsonScore(smFeature.getSlotExposeWeekCnt(), smFeature.getSlotClickWeekCnt());
                        Double sdayCtr = MaterialFeatureParse.calWilsonScore(smFeature.getSlotExposeDayCnt(), smFeature.getSlotClickDayCnt());
                        retMap.put("f390045", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(sweekCtr, slotCtrBucket)));
                        retMap.put("f390046", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(sdayCtr, slotCtrBucket)));
                        retMap.put("f390056", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotSckExpUV14D(), slotSckExpUvBucket)));
                        retMap.put("f390058", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotSckExpUV7D(), slotSckExpUvBucket)));
                        retMap.put("f390060", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotSckExpUV3D(), slotSckExpUvBucket)));
                        retMap.put("f390057", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotSckClkUV14D(), slotSckClkUvBucket)));
                        retMap.put("f390059", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotSckClkUV7D(), slotSckClkUvBucket)));
                        retMap.put("f390061", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotSckClkUV3D(), slotSckClkUvBucket)));
                    }
                    if (null != (amFeature = materialFeatureInfo.getAppMaterialFeature())) {
                        retMap.put("f215000", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckExpPV14D(), appSckExpPvBucket)));
                        retMap.put("f215104", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckExpPV7D(), appSckExpPvBucket)));
                        retMap.put("f215108", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckExpPV7D(), appSckExpPvBucket)));
                        retMap.put("f215102", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckExpPV14D(), appSckExpUvBucket)));
                        retMap.put("f215106", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckExpPV7D(), appSckExpUvBucket)));
                        retMap.put("f215110", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckExpPV7D(), appSckExpUvBucket)));
                        retMap.put("f215101", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckClkPV14D(), appSckClkBucket)));
                        retMap.put("f215103", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckClkUV14D(), appSckClkBucket)));
                        retMap.put("f215105", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckClkPV7D(), appSckClkBucket)));
                        retMap.put("f215107", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckClkUV7D(), appSckClkBucket)));
                        retMap.put("f215109", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckClkPV3D(), appSckClkBucket)));
                        retMap.put("f215111", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(amFeature.getAppSckClkUV3D(), appSckClkBucket)));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("MaterialFeatureParse.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static String getCurrMaterialTagInfo(MaterialFeature materialFeature, Map<String, Integer> tagMap) {
        if (AssertUtil.isEmpty(tagMap)) {
            return null;
        }
        HashMap<String, Integer> retMap = new HashMap<String, Integer>();
        MaterialFeatureParse.processTag(materialFeature.getDesignHue(), tagMap, retMap);
        MaterialFeatureParse.processTag(materialFeature.getDesignType(), tagMap, retMap);
        MaterialFeatureParse.processTag(materialFeature.getIndustry(), tagMap, retMap);
        MaterialFeatureParse.processTag(materialFeature.getRewardElement(), tagMap, retMap);
        MaterialFeatureParse.processTag(materialFeature.getStrategy(), tagMap, retMap);
        MaterialFeatureParse.processTag(materialFeature.getSlotNature(), tagMap, retMap);
        return FeatureParse.getUserCategoryActLevelByBucket(retMap, materialTagCodes, userBehaviorBucket);
    }

    private static void processTag(String tag, Map<String, Integer> tagMap, Map<String, Integer> retMap) {
        if (null != tag) {
            String[] tagList;
            for (String tmpTag : tagList = tag.split(",")) {
                retMap.put(tmpTag, tagMap.getOrDefault(tmpTag, 0));
            }
        }
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{firstPv, secondPv}) && firstPv > 0L) {
            ret = DataUtil.division((Long)secondPv, (Long)firstPv);
        }
        return ret;
    }

    private static double calWilsonScore(Long exposeCnt, Long clickCnt) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{exposeCnt, clickCnt})) {
            return 0.0;
        }
        if (exposeCnt == 0L) {
            return 0.0;
        }
        double ratio = (double)clickCnt.longValue() * 1.0 / (double)exposeCnt.longValue();
        double faithLevel = 1.645;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2L * exposeCnt) - faithLevel * Math.sqrt((double)(4L * exposeCnt) * ratio * (1.0 - ratio) + faithSquare) / (double)(2L * exposeCnt)) / (1.0 + faithSquare / (double)exposeCnt.longValue());
    }

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > (long)bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0L) {
            ret = Math.round(MaterialFeatureParse.log(lvalue.doubleValue(), 500.0));
        }
        return ret;
    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    public static Integer level(Long value, Long base, Integer min, Integer max) {
        Integer ret = null;
        if (value != null && value > 0L) {
            ret = Math.round(value / base);
            ret = Math.max(Math.min(ret, max), min);
        }
        return ret;
    }

    public static Long min(Long value, Long base) {
        if (AssertUtil.isEmpty((Object)value)) {
            return 0L;
        }
        if (value >= base) {
            value = base;
        }
        return value;
    }

    public static String subList(List<String> list) {
        if (AssertUtil.isEmpty(list)) {
            return null;
        }
        List<String> subList = list;
        if (list.size() > 30) {
            subList = subList.subList(list.size() - 30, list.size());
            return StringUtils.strip((String)subList.toString().replace(" ", ""), (String)"[]");
        }
        return StringUtils.strip((String)list.toString().replace(" ", ""), (String)"[]");
    }

    public static String sortSubList(String string) {
        if (AssertUtil.isEmpty((String)string)) {
            return null;
        }
        List<String> list = Arrays.asList(string.split(","));
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String[] array1 = o1.split("-");
                String[] array2 = o2.split("-");
                return array1[0].compareTo(array2[0]);
            }
        });
        ArrayList<String> newArray = new ArrayList<String>();
        for (String s : list) {
            if (s.split("-").length >= 2) {
                newArray.add(s.split("-")[1]);
                continue;
            }
            newArray.add(s);
        }
        return MaterialFeatureParse.subList(newArray);
    }

    public static void putMapNotNull(Map<String, String> map, String key, String value) {
        if (map == null || StringUtils.isBlank((String)value)) {
            return;
        }
        map.put(key, value);
    }

    public static void main(String[] args) {
        String string0 = "20100724201049-0716,20200727201101-01182,20250723201243-187751,20200723201049-716,20200723201101-1182,20200723201243-18751,20300723201349-7716,20200723201101-1182,20200723200843-187571,20200723201049-716,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-11782,20200723200843-18751,20200723201049-716,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-716,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-716,20200723201901-1182,20200723111243-18751,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-7146,20200723101901-1182,20200723201243-187251,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-716,20200723201901-11282,20200723201243-18751,20200723201349-716,20200723201101-1182,20200723200843-187251,20200723201049-7126,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-11822,20200723200843-187521,20200723201049-7126,20200723201901-1182,20200723201243-18752";
        String string = "1,2,2,3,2,2,2,2,1,2,3,4,5,6,7,56,6,7,8,89,12,3,4,5,1,2,3,45,89,78,76,56,56,43,53,2,2";
        System.out.println(MaterialFeatureParse.sortSubList(string0));
        String str = "1,2,2,3,2,2,2,2,1,2,3,4,5,6,7,56,6,7,8,89,12,3,4,5,1,2,3,45,89,78,76,56,56,43,53,2,2";
        List<String> list = Arrays.asList(str.split(","));
        System.out.println(MaterialFeatureParse.subList(list));
    }
}

