package cn.com.duiba.nezha.alg.feature.type;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;


@Data
public class FeatureBaseType2 implements Serializable {

    private static final long serialVersionUID = -8781145506799969883L;


    public Integer id;
    public String featureId;//特征ID
    public String featureName;// 特征名称
    public Integer codeType;//1: 单值 离散   2:多值 离散  3：浮点
    public String splitChar;//分隔符
    public String featureDesc;//特征描述
    public Integer multiValue;//是否多值
    public Integer denseLen;//稠密空间长度
    public Integer isDeleted;//是否下线
    public Integer encodeType;//特征类型，广告侧、媒体侧、衍生统计等

    public Integer featureScene;//广告、活动

    public int subLen = 1;//多值特征，最大长度

    public FeatureBaseType2() {
    }


    /**
     * 特征值解析，不支持浮点类型
     *
     * @param featureValueMap
     * @return
     * @throws Exception
     */
    public String[] splitFeature(Map<String, String> featureValueMap) throws Exception {

        return splitFeature(featureValueMap.get(featureName));
    }

    /**
     * 特征值解析，不支持浮点类型
     *
     * @param featureValue
     * @return
     * @throws Exception
     */
    public String[] splitFeature(String featureValue) throws Exception {
        String[] ret = new String[subLen];
        if (codeType == 1) {
            ret[0] = std(featureValue);
        } else if (codeType == 2) {

            String[] features = split(featureValue, this.splitChar);
            if (features != null) {
                ret = Arrays.copyOfRange(features, 0, subLen);
            } else {
                ret[0] = null;
            }


        } else {
            ret[0] = null;
        }

        return ret;
    }

    public String[] split(String str) throws Exception {
        String[] ret = null;
        if (std(str) != null) {
            ret = str.split(this.splitChar, 0);
        }
        return ret;
    }

    public static String[] split(String str, String seq) throws Exception {
        String[] ret = null;
        if (std(str) != null) {
            ret = str.split(seq, 0);
        }
        return ret;
    }

    public static String std(String oStr) {
        if (oStr == null) {
            return null;
        }
        String lowStr = oStr.toLowerCase().trim();

        if (lowStr.length() == 0 ||
                lowStr.equals("\\n") ||
                lowStr.equals("\n") ||
                lowStr.equals("null") ||
                lowStr.equals("none")
                ) {
            return null;
        }
        return lowStr;
    }


    public static void main(String[] args) {

        try {
            FeatureBaseType2 do1 = new FeatureBaseType2();
            do1.setSubLen(10);
            do1.setDenseLen(1000);
            do1.setFeatureName("f1001");
            System.out.println(Arrays.asList(do1.splitFeature("1")));
            System.out.println(Arrays.asList(do1.splitFeature("1,")));
            System.out.println(Arrays.asList(do1.splitFeature(",1")));
            System.out.println(Arrays.asList(do1.splitFeature("1,2")));
            System.out.println(Arrays.asList(do1.splitFeature("1,3,4,5")));
            System.out.println(Arrays.asList(do1.splitFeature("2,3,,4,5")));
            System.out.println(Arrays.asList(do1.splitFeature("")));
            System.out.println(Arrays.asList(do1.splitFeature("  ")));
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

}
