package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.*;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSON;

import org.slf4j.LoggerFactory;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.*;


import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;

import javax.xml.crypto.Data;


public class FeatureParse2 {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureParse2.class);
    public static int F_MAX_SIZE = 64;
    public static Integer[] orderGmtIntervelBucket = {1, 2, 3, 4, 5, 10, 60, 60 * 12, 60 * 24, 60 * 24 * 7};// 时间间隔
    public static Number[] cntBucket = {0, 1, 3, 5, 10, 15, 20};
    public static Number[] orderRankBucket = {0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 25, 30, 35, 50, 70, 100, 200, 500};
    public static Number[] dayOrderRankBucket = {0,1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 60, 100};

    public static Number[] statCtrBucket = {0,0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.40, 0.45, 0.50, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static Number[] statCvrBucket = {0,0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.20, 0.25, 0.30, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};


    public static final Number[] cntMeituanBucket30d = {0, 1, 2, 3, 5, 10, 20, 30, 90};


    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {
                // 1、用户侧 设备信息
                retMap.put("ft100201", cf.getConnectionType());// 网络类型（2G，3G，4G）
                retMap.put("ft100202", cf.getOperatorType());// 运营商（中国联通，中国移动，中国电信）
                retMap.put("ft100203", cf.getOsVersion());//系统版本
                retMap.put("ft100204", cf.getPhoneModelCode());//设备型号
                retMap.put("ft100205", cf.getBrandNameEn());//品牌英文名称
                retMap.put("ft100206", cf.getPhonePriceLevel());// 设备价格区间
                retMap.put("ft100207", DataUtil.Integer2String(cf.getFirstShowTime()));//首发年份
                retMap.put("ft100208", cf.getPhoneOs());//操作系统


                // 2、用户侧 画像信息
                UserProfileFeature userProfileFeature = Optional.ofNullable(cf.getUserProfileFeature()).orElse(new UserProfileFeature());
                retMap.put("ft100001", cf.getOneId());//
                retMap.put("ft100101", cf.getAqyGender());//性别
                retMap.put("ft100102", cf.getBdAge());//年龄
                retMap.put("ft100103", userProfileFeature.getMarital());//婚育情况
                retMap.put("ft100104", userProfileFeature.getConsumeLevel());//消费水平


                retMap.put("ft100501", cf.getBdFirstTag());// 百度兴趣标签 1级
                retMap.put("ft100502", cf.getBdSecondTag());// 百度兴趣标签 2级
                retMap.put("ft100503", cf.getBdThirdTag());// 百度兴趣标签 3级
                retMap.put("ft100504", cf.getBdFourthTag());// 百度兴趣标签 4级




                // 3、用户侧 行为信息
                UserActFeature userActFeature = Optional.ofNullable(cf.getUserActFeature()).orElse(new UserActFeature());
                retMap.put("ft110000", DataConverter.bucket(userActFeature.getUserActiveDays(), cntBucket));// 历史最早发券距今天数

                retMap.put("ft111021", DataConverter.bucket(userActFeature.getWeekActivityRequest(), cntBucket)); // 历史=7，活动访问PV
                retMap.put("ft111011", DataConverter.bucket(userActFeature.getDayActivityRequest(), cntBucket)); // 当日，活动访问PV
                // 历史累计
                retMap.put("ft110001", DataConverter.bucket(userActFeature.getHistory30LaunchCount(), orderRankBucket));//历史=30，曝光PV
                retMap.put("ft110002", DataConverter.bucket(userActFeature.getHistory30ClickCount(), orderRankBucket)); //历史=30，点击PV
                retMap.put("ft110003", DataConverter.bucket(userActFeature.getHistory30EffectCount(), orderRankBucket));//历史=30，转化PV
                // 当日累计
                retMap.put("ft110011", DataConverter.bucket(userActFeature.getTodayLaunchCount(), dayOrderRankBucket));//当日，曝光PV
                retMap.put("ft110012", DataConverter.bucket(userActFeature.getTodayClickCount(), dayOrderRankBucket));//当日，点击PV
                retMap.put("ft110013", DataConverter.bucket(userActFeature.getTodayEffectCount(), dayOrderRankBucket));//当日，转化PV

                //ft110201 历史=30，不同广告主，发券PV
                //ft110202 历史=30，不同广告主，点击PV
                //ft110203 历史=30，不同广告主，转化PV

                //ft110401 历史=30，不同资源，发券PV
                //ft110402 历史=30，不同资源，点击PV
                //ft110403 历史=30，不同资源，转化PV

                retMap.put("ft110301",DataConverter.map2Bucket2Str(userActFeature.getHistoryTradeLaunch(), orderRankBucket));//历史=30，不同行业，发券PV
                retMap.put("ft110302",DataConverter.map2Bucket2Str(userActFeature.getHistoryTradeClick(), orderRankBucket));//历史=30，不同行业，点击PV
                retMap.put("ft110303",DataConverter.map2Bucket2Str(userActFeature.getHistoryTradeEffect(), orderRankBucket));//历史=30，不同行业，转化PV

                retMap.put("ft110501", DataConverter.map2Bucket2Str(userActFeature.getHistoryAdvertLaunch(), orderRankBucket));// 历史=30，不同广告，发券PV
                retMap.put("ft110502", DataConverter.map2Bucket2Str(userActFeature.getHistoryAdvertClick(), orderRankBucket));// 历史=30，不同广告，点击PV
                retMap.put("ft110503", DataConverter.map2Bucket2Str(userActFeature.getHistoryAdvertEffect(), orderRankBucket));// 历史=30，不同广告，转化PV

//                // 用户行为集合
                Set<Integer> advertExposureSet = userActFeature.getAdvertExposureSet();
                Set<Integer> advertClickSet = userActFeature.getAdvertClickSet();

                retMap.put("ft110601", DataConverter.set2Str(advertExposureSet));
                retMap.put("ft110602", DataConverter.set2Str(advertClickSet));
                retMap.put("ft110603", DataConverter.set2Str(DataConverter.setDiff(advertExposureSet, advertClickSet)));
                retMap.put("ft110604", DataConverter.set2Str(userActFeature.getAccountClickSet()));
                retMap.put("ft110605", DataConverter.set2Str(userActFeature.getResourceClickSet()));
                retMap.put("ft110606", DataConverter.set2Str(userActFeature.getTradeClickSet()));
                retMap.put("ft110607", DataConverter.set2Str(userActFeature.getAdvertEffectSet()));
                retMap.put("ft110608", DataConverter.set2Str(userActFeature.getAccountEffectSet()));
                retMap.put("ft110609", DataConverter.set2Str(userActFeature.getResourceEffectSet()));
                retMap.put("ft110610", DataConverter.set2Str(userActFeature.getTradeEffectSet()));

                // 4、上下文 媒体
                String activityId = DataUtil.Long2String(cf.getOperatingActivityId());
                String sceneType = Objects.equals(activityId, "999999") ? "2" : "1";
                String appId = DataUtil.Long2String(cf.getAppId());
                String unionAppId = cf.getUnionAppId();
                retMap.put("ft300101", appId);//媒体ID
                retMap.put("ft300102", sceneType);// 场景 互动/直投, 活动id为999999为直投，其他为互动
                retMap.put("ft300103", unionAppId == null || unionAppId.trim().equals("") ? appId : appId + "_" + unionAppId);
                retMap.put("ft300104", cf.getAppIndustryTagPid());//媒体行业一级标签（视频/阅读等）
                retMap.put("ft300105", cf.getAppIndustryTagId());//媒体行业二级标签（短视频/新闻阅读等）
                retMap.put("ft300106", cf.getAppTradeTypeTagId());// todo 媒体交易方式（RTB/ADX/固价-cpm等）
                retMap.put("ft300107", cf.getAppCarrierFlowTagId());//todo 媒体流量载体（微信-小程序/支付宝/H5等）
                retMap.put("ft300108", cf.getMmoTag());// 是否网赚


                // 5、上下文 广告位
                retMap.put("ft300201", DataUtil.Long2String(cf.getSlotId()));//广告位ID
                retMap.put("ft300202", cf.getSlotSceneType());//todo 广告位类型（开屏/信息流/banner/icon等）
                retMap.put("ft300203", cf.getMaterailID());//广告位素材ID

                // 6、上下文 活动
                retMap.put("ft300301", activityId);//活动id（当前活动）
                retMap.put("ft300302", cf.getActivitySourceType());//活动[进入当前券]的访问类型[广告位、浮标、返回拦截、弹层、区块]
                retMap.put("ft300303", DataUtil.Long2String(cf.getDsm2A()));// 活动访问类型（广告位/返回拦截）
                retMap.put("ft300304", DataUtil.Long2String(cf.getActivityPage()));//自定义活动ID（主活动ID）
                retMap.put("ft300305", cf.getActivitySkinType());// todo 活动皮肤ID/Name（玩法，大转盘/翻牌子/扭蛋机等）


                // 6、上下文 实时ip解析地域
                String cityId = DataUtil.Long2String(cf.getCityId());
                String provinceId = RegionConf.getProvince(cityId);
                String regionId = RegionConf.getRegion(provinceId);
                String CityTier = RegionConf.getCityTier(cityId);
                retMap.put("ft300901", regionId);//地域-地区（华北/华东等）
                retMap.put("ft300902", provinceId);// 地域-省/直辖市
                retMap.put("ft300903", cityId);//地域-市
                retMap.put("ft300904", CityTier);//地域-几线


                // 上下文 订单时间
                Integer hour = LocalDateUtil.getHour(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer weekDay = LocalDateUtil.getDayOfWeek(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer dayOfMonth = LocalDateUtil.getDayOfMonthSafely(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                retMap.put("ft301001", DataUtil.Integer2String(hour));//订单时间 hour（时段）
                retMap.put("ft301002", DataUtil.Integer2String(weekDay));// 订单时间 weekday（周几）
                retMap.put("ft301003", DataUtil.Integer2String(dayOfMonth));// 订单时间 day（几号）

                // 6、媒体（媒体/广告位/媒体行业） 与广告（广告/广告行业/广告主等）交叉统计泛化
                // 广告位 交叉 广告行业
                SlotActFeature slotActFeature = Optional.ofNullable(cf.getSlotActFeature()).orElse(new SlotActFeature());
                JSONObject ctrTradeMap = DataUtil.stringToJson(slotActFeature.getCtrTrade());
                retMap.put("ft400101", DataConverter.json2Bucket2Str(ctrTradeMap, statCtrBucket));// 历史，广告位，广告行业CTR
                JSONObject cvrTradeMap = DataUtil.stringToJson(slotActFeature.getCvrTrade());
                retMap.put("ft400102", DataConverter.json2Bucket2Str(cvrTradeMap, statCvrBucket));//历史，广告位，当前广告行业CVR


                // 媒体 交叉广告行业
                // todo getAppInNewTrade 取值为空
//                String appInNewTradeCtr = getStatInNewTrade("ctr", cf.getAppInNewTrade());
//                retMap.put("ft400401", appInNewTradeCtr);//历史，媒体，广告行业CTR
//                String appInNewTradeCvr = getStatInNewTrade("cvr", cf.getAppInNewTrade());
//                retMap.put("ft400402", appInNewTradeCvr);//历史，媒体，广告行业CVR

                // 7、adx相关
                // adx-美团
//                retMap.put("f680001", bucket(cf.getRequestCnt(), cntMeituanBucket).toString());
                retMap.put("ft600101", DataConverter.bucket(cf.getRequestCnt30d(), cntMeituanBucket30d));
                retMap.put("ft600102", DataConverter.bucket(cf.getExposureCnt30d(), cntMeituanBucket30d));
                retMap.put("ft600103", DataConverter.bucket(cf.getClickCnt30d(), cntMeituanBucket30d));


                // adx-快手
                retMap.put("ft600201", cf.getOpenAccountId());  //媒体开户账号id
                retMap.put("ft600202", cf.getExtUnionSlotId());  //联盟广告位id
                retMap.put("ft600203", cf.getExtAdvertGroupId());  //外部广告组id
                retMap.put("ft600204", cf.getExtIdeaId());  //外部创意id

                // adx-百度联盟
                String extAppTrade = cf.getExtAppTrade();
                retMap.put("ft600301", extAppTrade);
                String externalAdBlockId = cf.getExternalAdBlockId();
                retMap.put("ft600302", externalAdBlockId);
                String externalAdBlockTypeId = cf.getExternalAdBlockTypeId();
                retMap.put("ft600303", externalAdBlockTypeId);
                String groupId = DataUtil.Long2String(cf.getGroupId());
                retMap.put("ft600304", groupId);
                String resourceId = DataUtil.Long2String(cf.getResourceId());
                retMap.put("ft600305", resourceId);

//                retMap.put("todayAdvertLaunch", DataConverter.map2Str(userActFeature.getTodayAdvertLaunch()));
//                retMap.put("todayAdvertClick", DataConverter.map2Str(userActFeature.getTodayAdvertClick()));
//                retMap.put("todayAdvertEffect", DataConverter.map2Str(userActFeature.getTodayAdvertEffect()));
//                retMap.put("historyAdvertLaunch", DataConverter.map2Str(userActFeature.getHistoryAdvertLaunch()));
//                retMap.put("historyAdvertClick", DataConverter.map2Str(userActFeature.getHistoryAdvertClick()));
//                retMap.put("historyAdvertEffect", DataConverter.map2Str(userActFeature.getHistoryAdvertEffect()));
//
//                retMap.put("AppTagInNewTrade1", JSON.toJSONString(cf.getAppTagInNewTrade()));
//                retMap.put("AppInNewTrade1", JSON.toJSONString(cf.getAppInNewTrade()));

            }
        } catch (Exception e) {
            logger.error("FeatureParse2.generateFeatureMapStatic error", e);
        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {
                // 广告侧 广告基本信息
                String advertId = DataUtil.Long2String(cf.getAdvertId());// 广告ID
                String accountId =  DataUtil.Long2String(cf.getAccountId());// 广告主ID
                String OperatingResource = cf.getOperatingResource();//资源ID
                String adNewTrade = cf.getOperatingNewTrade();// 广告行业ID（new_trade）
                LoadingPageFeature loadingPageFeature = Optional.ofNullable(cf.getLoadingPageFeature()).orElse(new LoadingPageFeature());
                String adTradeTag = cf.getMatchTagNums();

                retMap.put("ft200101", advertId);
                retMap.put("ft200102", accountId);
                retMap.put("ft200103", OperatingResource);
                retMap.put("ft200104", adNewTrade);
                retMap.put("ft200105", adTradeTag); // 广告行业标签
                retMap.put("ft200106", cf.getMaterialId());//广告素材ID
                retMap.put("ft200107", cf.getMaterialTags());//  广告素材标签
                retMap.put("ft200108", loadingPageFeature.getLoadingPageID());//落地页链接-MD5

                // 广告侧 转化类型
                String frontCvrType = cf.getBankEndType();
                String backCvrType = cf.getDeepConvertTypes();
                retMap.put("ft200201", frontCvrType);//前端转化类型，值范围：0～10
                retMap.put("ft200202", backCvrType);//后端转化类型，值范围：1～30


                // 用户侧 上一单数据
                UserActFeature userActFeature = Optional.ofNullable(staticCf.getUserActFeature()).orElse(new UserActFeature());
                String lastActivity = userActFeature.getLastActivity();
                String lastLaunchTrade = userActFeature.getLastLaunchTrade();
                String lastResource = userActFeature.getLastResource();
                String lastAccount = userActFeature.getLastLaunchAccount();
                String lastAdvert = userActFeature.getLastLaunchPlan();
                retMap.put("ft110901", lastActivity);//上一单，活动ID
                retMap.put("ft110902", lastLaunchTrade);
                retMap.put("ft110903", lastResource);
                retMap.put("ft110904", lastAccount);
                retMap.put("ft110905", lastAdvert);
                retMap.put("ft110906", userActFeature.getClickLaunchTrade() == null ? null : userActFeature.getClickLaunchTrade().toString());//上一单，是否点击
                retMap.put("ft110907", userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade().toString());//上一单，是否转化
                retMap.put("ft110908", DataConverter.getMatchStatus(lastLaunchTrade, adNewTrade));//上一单，与当前，行业是否相同
                retMap.put("ft110909", DataConverter.getMatchStatus(lastAdvert, advertId));//上一单，与当前，计划是否相同
                String activityId = DataUtil.Long2String(staticCf.getOperatingActivityId());
                retMap.put("ft110910", DataConverter.getMatchStatus(lastActivity, activityId));//上一单，与当前，活动是否相同、
                String curOrderTime = staticCf.getCurrentGmtCreateTime();
                String lastLaunchTime = userActFeature.getLastLaunchTime();
                retMap.put("ft110911", DataConverter.bucket(DataConverter.getTimeInterval(lastLaunchTime,curOrderTime,"m"), orderGmtIntervelBucket));//上一单，与当前发券，时间差

                // 6、媒体（媒体/广告位/媒体行业） 与当前广告（广告/广告行业/广告主等）交叉统计泛化
                // 广告位 交叉 当前广告行业
                SlotActFeature slotActFeature = Optional.ofNullable(staticCf.getSlotActFeature()).orElse(new SlotActFeature());

                JSONObject ctrTradeMap = DataUtil.stringToJson(slotActFeature.getCtrTrade());
                JSONObject cvrTradeMap = DataUtil.stringToJson(slotActFeature.getCvrTrade());
                retMap.put("ft400201", DataConverter.getCurTradeLevel(ctrTradeMap, adNewTrade, statCtrBucket));//历史，广告位，当前广告行业CTR
                retMap.put("ft400202", DataConverter.getCurTradeLevel(cvrTradeMap, adNewTrade, statCvrBucket));//历史，广告位，当前广告行业CVR


                // 广告位 交叉 当前广告
                retMap.put("ft400301", DataConverter.bucket(cf.getAdvertSlotCtr(), statCtrBucket));//历史，广告位，当前广告CTR
                retMap.put("ft400302", DataConverter.bucket(cf.getAdvertSlotCvr(), statCvrBucket));//历史，广告位，当前广告CTR




                // 媒体 交叉 当前广告行业
                // todo getAppInNewTrade 取值为空
//                String appInNewTradeCtr = getStatInNewTrade("ctr", staticCf.getAppInNewTrade());
//                String appInNewTradeCvr = getStatInNewTrade("cvr", staticCf.getAppInNewTrade());
//                retMap.put("ft400501", transJointStrToMap(appInNewTradeCtr, ",","&").getOrDefault(adNewTrade, "-1"));//历史，媒体，当前广告行业CTR
//                retMap.put("ft400502", transJointStrToMap(appInNewTradeCvr, ",","&").getOrDefault(adNewTrade, "-1"));//历史，媒体，当前广告行业CVR
//                retMap.put("AppTagInNewTrade2", JSON.toJSONString(staticCf.getAppTagInNewTrade()));
//                retMap.put("AppInNewTrade2", JSON.toJSONString(staticCf.getAppInNewTrade()));


                // 媒体 交叉 当前广告
                retMap.put("ft400601", DataConverter.bucket(cf.getAdvertAppCtr(), statCtrBucket));//历史，广告位，当前广告CTR
                retMap.put("ft400602", DataConverter.bucket(cf.getAdvertAppCvr(), statCvrBucket));//历史，广告位，当前广告CVR

                // 当前广告 统计ctr、cvr
                retMap.put("ft400701", DataConverter.bucket(cf.getAdvertCtr(), statCtrBucket));
                retMap.put("ft400702", DataConverter.bucket(cf.getAdvertCvr(), statCvrBucket));

                // 用户端 历史=30，当前广告行业 // 源数据使用的是adTradeTag作为key
                retMap.put("ft110101",DataConverter.bucket(userActFeature.getHistoryTradeLaunch().getOrDefault(adTradeTag, 0L), orderRankBucket));//历史=30，当前广告行业，曝光PV
                retMap.put("ft110102",DataConverter.bucket(userActFeature.getHistoryTradeClick().getOrDefault(adTradeTag, 0L), orderRankBucket));//历史=30，当前广告行业，点击PV
                retMap.put("ft110103",DataConverter.bucket(userActFeature.getHistoryTradeEffect().getOrDefault(adTradeTag, 0L), orderRankBucket));//历史=30，当前广告行业，转化PV

                // 8、字符交叉
                String advertIdString = advertId == null ? "ad" : advertId;
                retMap.put("ft500101", advertIdString+ "_" + frontCvrType);// 广告 + 前端类型
                retMap.put("ft500201", advertIdString + "_" + backCvrType);// 广告 + 后端类型

                String accountIdString = accountId == null ? "acc" : accountId;
                retMap.put("ft500102", accountIdString + "_" + frontCvrType);// 广告主 + 前端类型
                retMap.put("ft500202", accountIdString + "_" + backCvrType);// 广告主 + 后端类型

                String tradeIdString = adNewTrade == null ? "un" : adNewTrade;
                retMap.put("ft500103", tradeIdString + "_" + frontCvrType);// 行业 + 前端类型
                retMap.put("ft500203", tradeIdString + "_" + backCvrType);// 行业 + 后端类型


                String appIndustryTagPidString = staticCf.getAppIndustryTagPid() == null ? "un" : staticCf.getAppIndustryTagPid();
                retMap.put("ft500104", appIndustryTagPidString + "_" + frontCvrType);// 媒体行业 + 前端类型
                retMap.put("ft500204", appIndustryTagPidString + "_" + backCvrType);// 媒体行业 + 后端类型

            }
        } catch (Exception e) {
            logger.error("FeatureParse2.generateFeatureMapDynamic error", e);

        }

        return retMap;
    }







    //测试
    public static void main(String[] args) {

    }


}




