/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.vo;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserActFeature
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(UserActFeature.class);
    private static final long serialVersionUID = -2203632123858487448L;
    private Integer userActiveDays;
    private Integer activityRequest;
    private Integer weekActivityRequest;
    private Integer dayActivityRequest;
    private Integer intervalActivityRequest;
    private String periodActivityRequest;
    private Integer activityJoin;
    private Integer weekActivityJoin;
    private Integer dayActivityJoin;
    private Integer intervalActivityJoin;
    private String periodActivityJoin;
    private Integer activityPageStay;
    private String launchTrade;
    private String weekLaunchTrade;
    private Map<String, Integer> dayLaunchTrade;
    private Integer intervalLaunchTrade;
    private String periodLaunchTrade;
    private Integer avgLaunchStay;
    private String lastLaunchTrade;
    private Integer clickLaunchTrade;
    private String clickTrade;
    private String weekClickTrade;
    private Map<String, Integer> dayClickTrade;
    private Integer intervalClickTrade;
    private String periodClickTrade;
    private String lastClickTrade;
    private Integer effectClickTrade;
    private String effectTrade;
    private String weekEffectTrade;
    private Map<String, Integer> dayEffectTrade;
    private Integer intervalEffectTrade;
    private String periodEffectTrade;
    private String lastEffectTrade;
    private Long todayLaunch;
    private Long historyLaunch;
    private Long todayActivityLaunch;
    private Long historyActivityLaunch;
    private String lastLaunchTime;
    private String lastActivityLaunchTime;
    private String lastActivityLaunchOrder;
    private String lastActivityClickOrder;
    private String lastLaunchOrder;
    private String lastClickOrder;
    private String lastActivity;
    private String lastAdvertMatchTag;
    private Map<String, Long> todayResourceLaunch;
    private Map<String, String> lastResourceLaunchTime;
    private Map<String, String> lastResourceLaunchOrder;
    private Map<String, String> lastResourceClickOrder;
    private Map<String, String> lastResourceEffectOrder;
    private Map<String, Long> todayResourceClickAdvertCount;
    private Map<String, Long> todayResourceEffectAdvertCount;
    private String lastResource;
    private String lastLaunchAccount;
    private String lastLaunchPlan;
    private Set<Integer> advertExposureSet;
    private Set<Integer> advertClickSet;
    private Set<Integer> accountClickSet;
    private Set<String> resourceClickSet;
    private Set<Integer> tradeClickSet;
    private Set<Integer> advertEffectSet;
    private Set<Integer> accountEffectSet;
    private Set<String> resourceEffectSet;
    private Set<Integer> tradeEffectSet;
    private Map<Integer, Long> todayAdvertLaunch;
    private Map<Integer, Long> todayAdvertClick;
    private Map<Integer, Long> todayAdvertEffect;
    private Map<Integer, Long> historyAdvertLaunch;
    private Map<Integer, Long> historyAdvertClick;
    private Map<Integer, Long> historyAdvertEffect;
    private Integer history30LaunchCount;
    private Integer history30ClickCount;
    private Integer history30EffectCount;
    private Integer todayLaunchCount;
    private Integer todayClickCount;
    private Integer todayEffectCount;
    private String oUIIds;
    private String oUILaunchPV;
    private String oUIClickPv;
    private String oUIEffectPv;
    private Map<String, Long> historyTradeLaunch;
    private Map<String, Long> historyTradeClick;
    private Map<String, Long> historyTradeEffect;

    public Map<String, Long> getHistoryTradeLaunch() {
        if (this.historyTradeLaunch != null) {
            return this.historyTradeLaunch;
        }
        Map<String, String> historyTradeLaunchMap = DataConverter.series2Map(this.oUIIds, this.oUILaunchPV, ",");
        HashMap<String, Long> historyTradeLaunchMapL = new HashMap<String, Long>();
        try {
            for (Map.Entry<String, String> entry : historyTradeLaunchMap.entrySet()) {
                historyTradeLaunchMapL.put(entry.getKey(), DataUtil.str2Long((String)entry.getValue(), (Long)0L));
            }
            this.historyTradeLaunch = historyTradeLaunchMapL;
        }
        catch (Exception e) {
            logger.error("FeatureParse2.getHistoryTradeLaunch error", (Throwable)e);
            return historyTradeLaunchMapL;
        }
        return historyTradeLaunchMapL;
    }

    public Map<String, Long> getHistoryTradeClick() {
        if (this.historyTradeClick != null) {
            return this.historyTradeClick;
        }
        Map<String, String> historyTradeClickMap = DataConverter.series2Map(this.oUIIds, this.oUIClickPv, ",");
        HashMap<String, Long> historyTradeClickMapL = new HashMap<String, Long>();
        try {
            for (Map.Entry<String, String> entry : historyTradeClickMap.entrySet()) {
                historyTradeClickMapL.put(entry.getKey(), DataUtil.str2Long((String)entry.getValue(), (Long)0L));
            }
            this.historyTradeClick = historyTradeClickMapL;
        }
        catch (Exception e) {
            logger.error("FeatureParse2.getHistoryTradeClick error", (Throwable)e);
            return historyTradeClickMapL;
        }
        return historyTradeClickMapL;
    }

    public Map<String, Long> getHistoryTradeEffect() {
        if (this.historyTradeEffect != null) {
            return this.historyTradeEffect;
        }
        Map<String, String> historyTradeEffectMap = DataConverter.series2Map(this.oUIIds, this.oUIEffectPv, ",");
        HashMap<String, Long> historyTradeEffectMapL = new HashMap<String, Long>();
        try {
            for (Map.Entry<String, String> entry : historyTradeEffectMap.entrySet()) {
                historyTradeEffectMapL.put(entry.getKey(), DataUtil.str2Long((String)entry.getValue(), (Long)0L));
            }
            this.historyTradeEffect = historyTradeEffectMapL;
        }
        catch (Exception e) {
            logger.error("FeatureParse2.getHistoryTradeEffect error", (Throwable)e);
            return historyTradeEffectMapL;
        }
        return historyTradeEffectMapL;
    }

    public Integer getHistory30LaunchCount() {
        if (this.history30LaunchCount != null) {
            return this.history30LaunchCount;
        }
        return DataConverter.accumulateMapValues(this.historyAdvertLaunch).intValue();
    }

    public Integer getHistory30ClickCount() {
        if (this.history30ClickCount != null) {
            return this.history30ClickCount;
        }
        return DataConverter.accumulateMapValues(this.historyAdvertClick).intValue();
    }

    public Integer getHistory30EffectCount() {
        if (this.history30EffectCount != null) {
            return this.history30EffectCount;
        }
        return DataConverter.accumulateMapValues(this.historyAdvertEffect).intValue();
    }

    public Integer getTodayLaunchCount() {
        if (this.todayLaunchCount != null) {
            return this.todayLaunchCount;
        }
        return DataConverter.accumulateMapValues(this.todayAdvertLaunch).intValue();
    }

    public Integer getTodayClickCount() {
        if (this.todayClickCount != null) {
            return this.todayClickCount;
        }
        return DataConverter.accumulateMapValues(this.todayAdvertClick).intValue();
    }

    public Integer getTodayEffectCount() {
        if (this.todayEffectCount != null) {
            return this.todayEffectCount;
        }
        return DataConverter.accumulateMapValues(this.todayAdvertEffect).intValue();
    }

    public Integer getUserActiveDays() {
        return this.userActiveDays;
    }

    public Integer getActivityRequest() {
        return this.activityRequest;
    }

    public Integer getWeekActivityRequest() {
        return this.weekActivityRequest;
    }

    public Integer getDayActivityRequest() {
        return this.dayActivityRequest;
    }

    public Integer getIntervalActivityRequest() {
        return this.intervalActivityRequest;
    }

    public String getPeriodActivityRequest() {
        return this.periodActivityRequest;
    }

    public Integer getActivityJoin() {
        return this.activityJoin;
    }

    public Integer getWeekActivityJoin() {
        return this.weekActivityJoin;
    }

    public Integer getDayActivityJoin() {
        return this.dayActivityJoin;
    }

    public Integer getIntervalActivityJoin() {
        return this.intervalActivityJoin;
    }

    public String getPeriodActivityJoin() {
        return this.periodActivityJoin;
    }

    public Integer getActivityPageStay() {
        return this.activityPageStay;
    }

    public String getLaunchTrade() {
        return this.launchTrade;
    }

    public String getWeekLaunchTrade() {
        return this.weekLaunchTrade;
    }

    public Map<String, Integer> getDayLaunchTrade() {
        return this.dayLaunchTrade;
    }

    public Integer getIntervalLaunchTrade() {
        return this.intervalLaunchTrade;
    }

    public String getPeriodLaunchTrade() {
        return this.periodLaunchTrade;
    }

    public Integer getAvgLaunchStay() {
        return this.avgLaunchStay;
    }

    public String getLastLaunchTrade() {
        return this.lastLaunchTrade;
    }

    public Integer getClickLaunchTrade() {
        return this.clickLaunchTrade;
    }

    public String getClickTrade() {
        return this.clickTrade;
    }

    public String getWeekClickTrade() {
        return this.weekClickTrade;
    }

    public Map<String, Integer> getDayClickTrade() {
        return this.dayClickTrade;
    }

    public Integer getIntervalClickTrade() {
        return this.intervalClickTrade;
    }

    public String getPeriodClickTrade() {
        return this.periodClickTrade;
    }

    public String getLastClickTrade() {
        return this.lastClickTrade;
    }

    public Integer getEffectClickTrade() {
        return this.effectClickTrade;
    }

    public String getEffectTrade() {
        return this.effectTrade;
    }

    public String getWeekEffectTrade() {
        return this.weekEffectTrade;
    }

    public Map<String, Integer> getDayEffectTrade() {
        return this.dayEffectTrade;
    }

    public Integer getIntervalEffectTrade() {
        return this.intervalEffectTrade;
    }

    public String getPeriodEffectTrade() {
        return this.periodEffectTrade;
    }

    public String getLastEffectTrade() {
        return this.lastEffectTrade;
    }

    public Long getTodayLaunch() {
        return this.todayLaunch;
    }

    public Long getHistoryLaunch() {
        return this.historyLaunch;
    }

    public Long getTodayActivityLaunch() {
        return this.todayActivityLaunch;
    }

    public Long getHistoryActivityLaunch() {
        return this.historyActivityLaunch;
    }

    public String getLastLaunchTime() {
        return this.lastLaunchTime;
    }

    public String getLastActivityLaunchTime() {
        return this.lastActivityLaunchTime;
    }

    public String getLastActivityLaunchOrder() {
        return this.lastActivityLaunchOrder;
    }

    public String getLastActivityClickOrder() {
        return this.lastActivityClickOrder;
    }

    public String getLastLaunchOrder() {
        return this.lastLaunchOrder;
    }

    public String getLastClickOrder() {
        return this.lastClickOrder;
    }

    public String getLastActivity() {
        return this.lastActivity;
    }

    public String getLastAdvertMatchTag() {
        return this.lastAdvertMatchTag;
    }

    public Map<String, Long> getTodayResourceLaunch() {
        return this.todayResourceLaunch;
    }

    public Map<String, String> getLastResourceLaunchTime() {
        return this.lastResourceLaunchTime;
    }

    public Map<String, String> getLastResourceLaunchOrder() {
        return this.lastResourceLaunchOrder;
    }

    public Map<String, String> getLastResourceClickOrder() {
        return this.lastResourceClickOrder;
    }

    public Map<String, String> getLastResourceEffectOrder() {
        return this.lastResourceEffectOrder;
    }

    public Map<String, Long> getTodayResourceClickAdvertCount() {
        return this.todayResourceClickAdvertCount;
    }

    public Map<String, Long> getTodayResourceEffectAdvertCount() {
        return this.todayResourceEffectAdvertCount;
    }

    public String getLastResource() {
        return this.lastResource;
    }

    public String getLastLaunchAccount() {
        return this.lastLaunchAccount;
    }

    public String getLastLaunchPlan() {
        return this.lastLaunchPlan;
    }

    public Set<Integer> getAdvertExposureSet() {
        return this.advertExposureSet;
    }

    public Set<Integer> getAdvertClickSet() {
        return this.advertClickSet;
    }

    public Set<Integer> getAccountClickSet() {
        return this.accountClickSet;
    }

    public Set<String> getResourceClickSet() {
        return this.resourceClickSet;
    }

    public Set<Integer> getTradeClickSet() {
        return this.tradeClickSet;
    }

    public Set<Integer> getAdvertEffectSet() {
        return this.advertEffectSet;
    }

    public Set<Integer> getAccountEffectSet() {
        return this.accountEffectSet;
    }

    public Set<String> getResourceEffectSet() {
        return this.resourceEffectSet;
    }

    public Set<Integer> getTradeEffectSet() {
        return this.tradeEffectSet;
    }

    public Map<Integer, Long> getTodayAdvertLaunch() {
        return this.todayAdvertLaunch;
    }

    public Map<Integer, Long> getTodayAdvertClick() {
        return this.todayAdvertClick;
    }

    public Map<Integer, Long> getTodayAdvertEffect() {
        return this.todayAdvertEffect;
    }

    public Map<Integer, Long> getHistoryAdvertLaunch() {
        return this.historyAdvertLaunch;
    }

    public Map<Integer, Long> getHistoryAdvertClick() {
        return this.historyAdvertClick;
    }

    public Map<Integer, Long> getHistoryAdvertEffect() {
        return this.historyAdvertEffect;
    }

    public String getOUIIds() {
        return this.oUIIds;
    }

    public String getOUILaunchPV() {
        return this.oUILaunchPV;
    }

    public String getOUIClickPv() {
        return this.oUIClickPv;
    }

    public String getOUIEffectPv() {
        return this.oUIEffectPv;
    }

    public void setUserActiveDays(Integer userActiveDays) {
        this.userActiveDays = userActiveDays;
    }

    public void setActivityRequest(Integer activityRequest) {
        this.activityRequest = activityRequest;
    }

    public void setWeekActivityRequest(Integer weekActivityRequest) {
        this.weekActivityRequest = weekActivityRequest;
    }

    public void setDayActivityRequest(Integer dayActivityRequest) {
        this.dayActivityRequest = dayActivityRequest;
    }

    public void setIntervalActivityRequest(Integer intervalActivityRequest) {
        this.intervalActivityRequest = intervalActivityRequest;
    }

    public void setPeriodActivityRequest(String periodActivityRequest) {
        this.periodActivityRequest = periodActivityRequest;
    }

    public void setActivityJoin(Integer activityJoin) {
        this.activityJoin = activityJoin;
    }

    public void setWeekActivityJoin(Integer weekActivityJoin) {
        this.weekActivityJoin = weekActivityJoin;
    }

    public void setDayActivityJoin(Integer dayActivityJoin) {
        this.dayActivityJoin = dayActivityJoin;
    }

    public void setIntervalActivityJoin(Integer intervalActivityJoin) {
        this.intervalActivityJoin = intervalActivityJoin;
    }

    public void setPeriodActivityJoin(String periodActivityJoin) {
        this.periodActivityJoin = periodActivityJoin;
    }

    public void setActivityPageStay(Integer activityPageStay) {
        this.activityPageStay = activityPageStay;
    }

    public void setLaunchTrade(String launchTrade) {
        this.launchTrade = launchTrade;
    }

    public void setWeekLaunchTrade(String weekLaunchTrade) {
        this.weekLaunchTrade = weekLaunchTrade;
    }

    public void setDayLaunchTrade(Map<String, Integer> dayLaunchTrade) {
        this.dayLaunchTrade = dayLaunchTrade;
    }

    public void setIntervalLaunchTrade(Integer intervalLaunchTrade) {
        this.intervalLaunchTrade = intervalLaunchTrade;
    }

    public void setPeriodLaunchTrade(String periodLaunchTrade) {
        this.periodLaunchTrade = periodLaunchTrade;
    }

    public void setAvgLaunchStay(Integer avgLaunchStay) {
        this.avgLaunchStay = avgLaunchStay;
    }

    public void setLastLaunchTrade(String lastLaunchTrade) {
        this.lastLaunchTrade = lastLaunchTrade;
    }

    public void setClickLaunchTrade(Integer clickLaunchTrade) {
        this.clickLaunchTrade = clickLaunchTrade;
    }

    public void setClickTrade(String clickTrade) {
        this.clickTrade = clickTrade;
    }

    public void setWeekClickTrade(String weekClickTrade) {
        this.weekClickTrade = weekClickTrade;
    }

    public void setDayClickTrade(Map<String, Integer> dayClickTrade) {
        this.dayClickTrade = dayClickTrade;
    }

    public void setIntervalClickTrade(Integer intervalClickTrade) {
        this.intervalClickTrade = intervalClickTrade;
    }

    public void setPeriodClickTrade(String periodClickTrade) {
        this.periodClickTrade = periodClickTrade;
    }

    public void setLastClickTrade(String lastClickTrade) {
        this.lastClickTrade = lastClickTrade;
    }

    public void setEffectClickTrade(Integer effectClickTrade) {
        this.effectClickTrade = effectClickTrade;
    }

    public void setEffectTrade(String effectTrade) {
        this.effectTrade = effectTrade;
    }

    public void setWeekEffectTrade(String weekEffectTrade) {
        this.weekEffectTrade = weekEffectTrade;
    }

    public void setDayEffectTrade(Map<String, Integer> dayEffectTrade) {
        this.dayEffectTrade = dayEffectTrade;
    }

    public void setIntervalEffectTrade(Integer intervalEffectTrade) {
        this.intervalEffectTrade = intervalEffectTrade;
    }

    public void setPeriodEffectTrade(String periodEffectTrade) {
        this.periodEffectTrade = periodEffectTrade;
    }

    public void setLastEffectTrade(String lastEffectTrade) {
        this.lastEffectTrade = lastEffectTrade;
    }

    public void setTodayLaunch(Long todayLaunch) {
        this.todayLaunch = todayLaunch;
    }

    public void setHistoryLaunch(Long historyLaunch) {
        this.historyLaunch = historyLaunch;
    }

    public void setTodayActivityLaunch(Long todayActivityLaunch) {
        this.todayActivityLaunch = todayActivityLaunch;
    }

    public void setHistoryActivityLaunch(Long historyActivityLaunch) {
        this.historyActivityLaunch = historyActivityLaunch;
    }

    public void setLastLaunchTime(String lastLaunchTime) {
        this.lastLaunchTime = lastLaunchTime;
    }

    public void setLastActivityLaunchTime(String lastActivityLaunchTime) {
        this.lastActivityLaunchTime = lastActivityLaunchTime;
    }

    public void setLastActivityLaunchOrder(String lastActivityLaunchOrder) {
        this.lastActivityLaunchOrder = lastActivityLaunchOrder;
    }

    public void setLastActivityClickOrder(String lastActivityClickOrder) {
        this.lastActivityClickOrder = lastActivityClickOrder;
    }

    public void setLastLaunchOrder(String lastLaunchOrder) {
        this.lastLaunchOrder = lastLaunchOrder;
    }

    public void setLastClickOrder(String lastClickOrder) {
        this.lastClickOrder = lastClickOrder;
    }

    public void setLastActivity(String lastActivity) {
        this.lastActivity = lastActivity;
    }

    public void setLastAdvertMatchTag(String lastAdvertMatchTag) {
        this.lastAdvertMatchTag = lastAdvertMatchTag;
    }

    public void setTodayResourceLaunch(Map<String, Long> todayResourceLaunch) {
        this.todayResourceLaunch = todayResourceLaunch;
    }

    public void setLastResourceLaunchTime(Map<String, String> lastResourceLaunchTime) {
        this.lastResourceLaunchTime = lastResourceLaunchTime;
    }

    public void setLastResourceLaunchOrder(Map<String, String> lastResourceLaunchOrder) {
        this.lastResourceLaunchOrder = lastResourceLaunchOrder;
    }

    public void setLastResourceClickOrder(Map<String, String> lastResourceClickOrder) {
        this.lastResourceClickOrder = lastResourceClickOrder;
    }

    public void setLastResourceEffectOrder(Map<String, String> lastResourceEffectOrder) {
        this.lastResourceEffectOrder = lastResourceEffectOrder;
    }

    public void setTodayResourceClickAdvertCount(Map<String, Long> todayResourceClickAdvertCount) {
        this.todayResourceClickAdvertCount = todayResourceClickAdvertCount;
    }

    public void setTodayResourceEffectAdvertCount(Map<String, Long> todayResourceEffectAdvertCount) {
        this.todayResourceEffectAdvertCount = todayResourceEffectAdvertCount;
    }

    public void setLastResource(String lastResource) {
        this.lastResource = lastResource;
    }

    public void setLastLaunchAccount(String lastLaunchAccount) {
        this.lastLaunchAccount = lastLaunchAccount;
    }

    public void setLastLaunchPlan(String lastLaunchPlan) {
        this.lastLaunchPlan = lastLaunchPlan;
    }

    public void setAdvertExposureSet(Set<Integer> advertExposureSet) {
        this.advertExposureSet = advertExposureSet;
    }

    public void setAdvertClickSet(Set<Integer> advertClickSet) {
        this.advertClickSet = advertClickSet;
    }

    public void setAccountClickSet(Set<Integer> accountClickSet) {
        this.accountClickSet = accountClickSet;
    }

    public void setResourceClickSet(Set<String> resourceClickSet) {
        this.resourceClickSet = resourceClickSet;
    }

    public void setTradeClickSet(Set<Integer> tradeClickSet) {
        this.tradeClickSet = tradeClickSet;
    }

    public void setAdvertEffectSet(Set<Integer> advertEffectSet) {
        this.advertEffectSet = advertEffectSet;
    }

    public void setAccountEffectSet(Set<Integer> accountEffectSet) {
        this.accountEffectSet = accountEffectSet;
    }

    public void setResourceEffectSet(Set<String> resourceEffectSet) {
        this.resourceEffectSet = resourceEffectSet;
    }

    public void setTradeEffectSet(Set<Integer> tradeEffectSet) {
        this.tradeEffectSet = tradeEffectSet;
    }

    public void setTodayAdvertLaunch(Map<Integer, Long> todayAdvertLaunch) {
        this.todayAdvertLaunch = todayAdvertLaunch;
    }

    public void setTodayAdvertClick(Map<Integer, Long> todayAdvertClick) {
        this.todayAdvertClick = todayAdvertClick;
    }

    public void setTodayAdvertEffect(Map<Integer, Long> todayAdvertEffect) {
        this.todayAdvertEffect = todayAdvertEffect;
    }

    public void setHistoryAdvertLaunch(Map<Integer, Long> historyAdvertLaunch) {
        this.historyAdvertLaunch = historyAdvertLaunch;
    }

    public void setHistoryAdvertClick(Map<Integer, Long> historyAdvertClick) {
        this.historyAdvertClick = historyAdvertClick;
    }

    public void setHistoryAdvertEffect(Map<Integer, Long> historyAdvertEffect) {
        this.historyAdvertEffect = historyAdvertEffect;
    }

    public void setHistory30LaunchCount(Integer history30LaunchCount) {
        this.history30LaunchCount = history30LaunchCount;
    }

    public void setHistory30ClickCount(Integer history30ClickCount) {
        this.history30ClickCount = history30ClickCount;
    }

    public void setHistory30EffectCount(Integer history30EffectCount) {
        this.history30EffectCount = history30EffectCount;
    }

    public void setTodayLaunchCount(Integer todayLaunchCount) {
        this.todayLaunchCount = todayLaunchCount;
    }

    public void setTodayClickCount(Integer todayClickCount) {
        this.todayClickCount = todayClickCount;
    }

    public void setTodayEffectCount(Integer todayEffectCount) {
        this.todayEffectCount = todayEffectCount;
    }

    public void setOUIIds(String oUIIds) {
        this.oUIIds = oUIIds;
    }

    public void setOUILaunchPV(String oUILaunchPV) {
        this.oUILaunchPV = oUILaunchPV;
    }

    public void setOUIClickPv(String oUIClickPv) {
        this.oUIClickPv = oUIClickPv;
    }

    public void setOUIEffectPv(String oUIEffectPv) {
        this.oUIEffectPv = oUIEffectPv;
    }

    public void setHistoryTradeLaunch(Map<String, Long> historyTradeLaunch) {
        this.historyTradeLaunch = historyTradeLaunch;
    }

    public void setHistoryTradeClick(Map<String, Long> historyTradeClick) {
        this.historyTradeClick = historyTradeClick;
    }

    public void setHistoryTradeEffect(Map<String, Long> historyTradeEffect) {
        this.historyTradeEffect = historyTradeEffect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserActFeature)) {
            return false;
        }
        UserActFeature other = (UserActFeature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$userActiveDays = this.getUserActiveDays();
        Integer other$userActiveDays = other.getUserActiveDays();
        if (this$userActiveDays == null ? other$userActiveDays != null : !((Object)this$userActiveDays).equals(other$userActiveDays)) {
            return false;
        }
        Integer this$activityRequest = this.getActivityRequest();
        Integer other$activityRequest = other.getActivityRequest();
        if (this$activityRequest == null ? other$activityRequest != null : !((Object)this$activityRequest).equals(other$activityRequest)) {
            return false;
        }
        Integer this$weekActivityRequest = this.getWeekActivityRequest();
        Integer other$weekActivityRequest = other.getWeekActivityRequest();
        if (this$weekActivityRequest == null ? other$weekActivityRequest != null : !((Object)this$weekActivityRequest).equals(other$weekActivityRequest)) {
            return false;
        }
        Integer this$dayActivityRequest = this.getDayActivityRequest();
        Integer other$dayActivityRequest = other.getDayActivityRequest();
        if (this$dayActivityRequest == null ? other$dayActivityRequest != null : !((Object)this$dayActivityRequest).equals(other$dayActivityRequest)) {
            return false;
        }
        Integer this$intervalActivityRequest = this.getIntervalActivityRequest();
        Integer other$intervalActivityRequest = other.getIntervalActivityRequest();
        if (this$intervalActivityRequest == null ? other$intervalActivityRequest != null : !((Object)this$intervalActivityRequest).equals(other$intervalActivityRequest)) {
            return false;
        }
        String this$periodActivityRequest = this.getPeriodActivityRequest();
        String other$periodActivityRequest = other.getPeriodActivityRequest();
        if (this$periodActivityRequest == null ? other$periodActivityRequest != null : !this$periodActivityRequest.equals(other$periodActivityRequest)) {
            return false;
        }
        Integer this$activityJoin = this.getActivityJoin();
        Integer other$activityJoin = other.getActivityJoin();
        if (this$activityJoin == null ? other$activityJoin != null : !((Object)this$activityJoin).equals(other$activityJoin)) {
            return false;
        }
        Integer this$weekActivityJoin = this.getWeekActivityJoin();
        Integer other$weekActivityJoin = other.getWeekActivityJoin();
        if (this$weekActivityJoin == null ? other$weekActivityJoin != null : !((Object)this$weekActivityJoin).equals(other$weekActivityJoin)) {
            return false;
        }
        Integer this$dayActivityJoin = this.getDayActivityJoin();
        Integer other$dayActivityJoin = other.getDayActivityJoin();
        if (this$dayActivityJoin == null ? other$dayActivityJoin != null : !((Object)this$dayActivityJoin).equals(other$dayActivityJoin)) {
            return false;
        }
        Integer this$intervalActivityJoin = this.getIntervalActivityJoin();
        Integer other$intervalActivityJoin = other.getIntervalActivityJoin();
        if (this$intervalActivityJoin == null ? other$intervalActivityJoin != null : !((Object)this$intervalActivityJoin).equals(other$intervalActivityJoin)) {
            return false;
        }
        String this$periodActivityJoin = this.getPeriodActivityJoin();
        String other$periodActivityJoin = other.getPeriodActivityJoin();
        if (this$periodActivityJoin == null ? other$periodActivityJoin != null : !this$periodActivityJoin.equals(other$periodActivityJoin)) {
            return false;
        }
        Integer this$activityPageStay = this.getActivityPageStay();
        Integer other$activityPageStay = other.getActivityPageStay();
        if (this$activityPageStay == null ? other$activityPageStay != null : !((Object)this$activityPageStay).equals(other$activityPageStay)) {
            return false;
        }
        String this$launchTrade = this.getLaunchTrade();
        String other$launchTrade = other.getLaunchTrade();
        if (this$launchTrade == null ? other$launchTrade != null : !this$launchTrade.equals(other$launchTrade)) {
            return false;
        }
        String this$weekLaunchTrade = this.getWeekLaunchTrade();
        String other$weekLaunchTrade = other.getWeekLaunchTrade();
        if (this$weekLaunchTrade == null ? other$weekLaunchTrade != null : !this$weekLaunchTrade.equals(other$weekLaunchTrade)) {
            return false;
        }
        Map<String, Integer> this$dayLaunchTrade = this.getDayLaunchTrade();
        Map<String, Integer> other$dayLaunchTrade = other.getDayLaunchTrade();
        if (this$dayLaunchTrade == null ? other$dayLaunchTrade != null : !((Object)this$dayLaunchTrade).equals(other$dayLaunchTrade)) {
            return false;
        }
        Integer this$intervalLaunchTrade = this.getIntervalLaunchTrade();
        Integer other$intervalLaunchTrade = other.getIntervalLaunchTrade();
        if (this$intervalLaunchTrade == null ? other$intervalLaunchTrade != null : !((Object)this$intervalLaunchTrade).equals(other$intervalLaunchTrade)) {
            return false;
        }
        String this$periodLaunchTrade = this.getPeriodLaunchTrade();
        String other$periodLaunchTrade = other.getPeriodLaunchTrade();
        if (this$periodLaunchTrade == null ? other$periodLaunchTrade != null : !this$periodLaunchTrade.equals(other$periodLaunchTrade)) {
            return false;
        }
        Integer this$avgLaunchStay = this.getAvgLaunchStay();
        Integer other$avgLaunchStay = other.getAvgLaunchStay();
        if (this$avgLaunchStay == null ? other$avgLaunchStay != null : !((Object)this$avgLaunchStay).equals(other$avgLaunchStay)) {
            return false;
        }
        String this$lastLaunchTrade = this.getLastLaunchTrade();
        String other$lastLaunchTrade = other.getLastLaunchTrade();
        if (this$lastLaunchTrade == null ? other$lastLaunchTrade != null : !this$lastLaunchTrade.equals(other$lastLaunchTrade)) {
            return false;
        }
        Integer this$clickLaunchTrade = this.getClickLaunchTrade();
        Integer other$clickLaunchTrade = other.getClickLaunchTrade();
        if (this$clickLaunchTrade == null ? other$clickLaunchTrade != null : !((Object)this$clickLaunchTrade).equals(other$clickLaunchTrade)) {
            return false;
        }
        String this$clickTrade = this.getClickTrade();
        String other$clickTrade = other.getClickTrade();
        if (this$clickTrade == null ? other$clickTrade != null : !this$clickTrade.equals(other$clickTrade)) {
            return false;
        }
        String this$weekClickTrade = this.getWeekClickTrade();
        String other$weekClickTrade = other.getWeekClickTrade();
        if (this$weekClickTrade == null ? other$weekClickTrade != null : !this$weekClickTrade.equals(other$weekClickTrade)) {
            return false;
        }
        Map<String, Integer> this$dayClickTrade = this.getDayClickTrade();
        Map<String, Integer> other$dayClickTrade = other.getDayClickTrade();
        if (this$dayClickTrade == null ? other$dayClickTrade != null : !((Object)this$dayClickTrade).equals(other$dayClickTrade)) {
            return false;
        }
        Integer this$intervalClickTrade = this.getIntervalClickTrade();
        Integer other$intervalClickTrade = other.getIntervalClickTrade();
        if (this$intervalClickTrade == null ? other$intervalClickTrade != null : !((Object)this$intervalClickTrade).equals(other$intervalClickTrade)) {
            return false;
        }
        String this$periodClickTrade = this.getPeriodClickTrade();
        String other$periodClickTrade = other.getPeriodClickTrade();
        if (this$periodClickTrade == null ? other$periodClickTrade != null : !this$periodClickTrade.equals(other$periodClickTrade)) {
            return false;
        }
        String this$lastClickTrade = this.getLastClickTrade();
        String other$lastClickTrade = other.getLastClickTrade();
        if (this$lastClickTrade == null ? other$lastClickTrade != null : !this$lastClickTrade.equals(other$lastClickTrade)) {
            return false;
        }
        Integer this$effectClickTrade = this.getEffectClickTrade();
        Integer other$effectClickTrade = other.getEffectClickTrade();
        if (this$effectClickTrade == null ? other$effectClickTrade != null : !((Object)this$effectClickTrade).equals(other$effectClickTrade)) {
            return false;
        }
        String this$effectTrade = this.getEffectTrade();
        String other$effectTrade = other.getEffectTrade();
        if (this$effectTrade == null ? other$effectTrade != null : !this$effectTrade.equals(other$effectTrade)) {
            return false;
        }
        String this$weekEffectTrade = this.getWeekEffectTrade();
        String other$weekEffectTrade = other.getWeekEffectTrade();
        if (this$weekEffectTrade == null ? other$weekEffectTrade != null : !this$weekEffectTrade.equals(other$weekEffectTrade)) {
            return false;
        }
        Map<String, Integer> this$dayEffectTrade = this.getDayEffectTrade();
        Map<String, Integer> other$dayEffectTrade = other.getDayEffectTrade();
        if (this$dayEffectTrade == null ? other$dayEffectTrade != null : !((Object)this$dayEffectTrade).equals(other$dayEffectTrade)) {
            return false;
        }
        Integer this$intervalEffectTrade = this.getIntervalEffectTrade();
        Integer other$intervalEffectTrade = other.getIntervalEffectTrade();
        if (this$intervalEffectTrade == null ? other$intervalEffectTrade != null : !((Object)this$intervalEffectTrade).equals(other$intervalEffectTrade)) {
            return false;
        }
        String this$periodEffectTrade = this.getPeriodEffectTrade();
        String other$periodEffectTrade = other.getPeriodEffectTrade();
        if (this$periodEffectTrade == null ? other$periodEffectTrade != null : !this$periodEffectTrade.equals(other$periodEffectTrade)) {
            return false;
        }
        String this$lastEffectTrade = this.getLastEffectTrade();
        String other$lastEffectTrade = other.getLastEffectTrade();
        if (this$lastEffectTrade == null ? other$lastEffectTrade != null : !this$lastEffectTrade.equals(other$lastEffectTrade)) {
            return false;
        }
        Long this$todayLaunch = this.getTodayLaunch();
        Long other$todayLaunch = other.getTodayLaunch();
        if (this$todayLaunch == null ? other$todayLaunch != null : !((Object)this$todayLaunch).equals(other$todayLaunch)) {
            return false;
        }
        Long this$historyLaunch = this.getHistoryLaunch();
        Long other$historyLaunch = other.getHistoryLaunch();
        if (this$historyLaunch == null ? other$historyLaunch != null : !((Object)this$historyLaunch).equals(other$historyLaunch)) {
            return false;
        }
        Long this$todayActivityLaunch = this.getTodayActivityLaunch();
        Long other$todayActivityLaunch = other.getTodayActivityLaunch();
        if (this$todayActivityLaunch == null ? other$todayActivityLaunch != null : !((Object)this$todayActivityLaunch).equals(other$todayActivityLaunch)) {
            return false;
        }
        Long this$historyActivityLaunch = this.getHistoryActivityLaunch();
        Long other$historyActivityLaunch = other.getHistoryActivityLaunch();
        if (this$historyActivityLaunch == null ? other$historyActivityLaunch != null : !((Object)this$historyActivityLaunch).equals(other$historyActivityLaunch)) {
            return false;
        }
        String this$lastLaunchTime = this.getLastLaunchTime();
        String other$lastLaunchTime = other.getLastLaunchTime();
        if (this$lastLaunchTime == null ? other$lastLaunchTime != null : !this$lastLaunchTime.equals(other$lastLaunchTime)) {
            return false;
        }
        String this$lastActivityLaunchTime = this.getLastActivityLaunchTime();
        String other$lastActivityLaunchTime = other.getLastActivityLaunchTime();
        if (this$lastActivityLaunchTime == null ? other$lastActivityLaunchTime != null : !this$lastActivityLaunchTime.equals(other$lastActivityLaunchTime)) {
            return false;
        }
        String this$lastActivityLaunchOrder = this.getLastActivityLaunchOrder();
        String other$lastActivityLaunchOrder = other.getLastActivityLaunchOrder();
        if (this$lastActivityLaunchOrder == null ? other$lastActivityLaunchOrder != null : !this$lastActivityLaunchOrder.equals(other$lastActivityLaunchOrder)) {
            return false;
        }
        String this$lastActivityClickOrder = this.getLastActivityClickOrder();
        String other$lastActivityClickOrder = other.getLastActivityClickOrder();
        if (this$lastActivityClickOrder == null ? other$lastActivityClickOrder != null : !this$lastActivityClickOrder.equals(other$lastActivityClickOrder)) {
            return false;
        }
        String this$lastLaunchOrder = this.getLastLaunchOrder();
        String other$lastLaunchOrder = other.getLastLaunchOrder();
        if (this$lastLaunchOrder == null ? other$lastLaunchOrder != null : !this$lastLaunchOrder.equals(other$lastLaunchOrder)) {
            return false;
        }
        String this$lastClickOrder = this.getLastClickOrder();
        String other$lastClickOrder = other.getLastClickOrder();
        if (this$lastClickOrder == null ? other$lastClickOrder != null : !this$lastClickOrder.equals(other$lastClickOrder)) {
            return false;
        }
        String this$lastActivity = this.getLastActivity();
        String other$lastActivity = other.getLastActivity();
        if (this$lastActivity == null ? other$lastActivity != null : !this$lastActivity.equals(other$lastActivity)) {
            return false;
        }
        String this$lastAdvertMatchTag = this.getLastAdvertMatchTag();
        String other$lastAdvertMatchTag = other.getLastAdvertMatchTag();
        if (this$lastAdvertMatchTag == null ? other$lastAdvertMatchTag != null : !this$lastAdvertMatchTag.equals(other$lastAdvertMatchTag)) {
            return false;
        }
        Map<String, Long> this$todayResourceLaunch = this.getTodayResourceLaunch();
        Map<String, Long> other$todayResourceLaunch = other.getTodayResourceLaunch();
        if (this$todayResourceLaunch == null ? other$todayResourceLaunch != null : !((Object)this$todayResourceLaunch).equals(other$todayResourceLaunch)) {
            return false;
        }
        Map<String, String> this$lastResourceLaunchTime = this.getLastResourceLaunchTime();
        Map<String, String> other$lastResourceLaunchTime = other.getLastResourceLaunchTime();
        if (this$lastResourceLaunchTime == null ? other$lastResourceLaunchTime != null : !((Object)this$lastResourceLaunchTime).equals(other$lastResourceLaunchTime)) {
            return false;
        }
        Map<String, String> this$lastResourceLaunchOrder = this.getLastResourceLaunchOrder();
        Map<String, String> other$lastResourceLaunchOrder = other.getLastResourceLaunchOrder();
        if (this$lastResourceLaunchOrder == null ? other$lastResourceLaunchOrder != null : !((Object)this$lastResourceLaunchOrder).equals(other$lastResourceLaunchOrder)) {
            return false;
        }
        Map<String, String> this$lastResourceClickOrder = this.getLastResourceClickOrder();
        Map<String, String> other$lastResourceClickOrder = other.getLastResourceClickOrder();
        if (this$lastResourceClickOrder == null ? other$lastResourceClickOrder != null : !((Object)this$lastResourceClickOrder).equals(other$lastResourceClickOrder)) {
            return false;
        }
        Map<String, String> this$lastResourceEffectOrder = this.getLastResourceEffectOrder();
        Map<String, String> other$lastResourceEffectOrder = other.getLastResourceEffectOrder();
        if (this$lastResourceEffectOrder == null ? other$lastResourceEffectOrder != null : !((Object)this$lastResourceEffectOrder).equals(other$lastResourceEffectOrder)) {
            return false;
        }
        Map<String, Long> this$todayResourceClickAdvertCount = this.getTodayResourceClickAdvertCount();
        Map<String, Long> other$todayResourceClickAdvertCount = other.getTodayResourceClickAdvertCount();
        if (this$todayResourceClickAdvertCount == null ? other$todayResourceClickAdvertCount != null : !((Object)this$todayResourceClickAdvertCount).equals(other$todayResourceClickAdvertCount)) {
            return false;
        }
        Map<String, Long> this$todayResourceEffectAdvertCount = this.getTodayResourceEffectAdvertCount();
        Map<String, Long> other$todayResourceEffectAdvertCount = other.getTodayResourceEffectAdvertCount();
        if (this$todayResourceEffectAdvertCount == null ? other$todayResourceEffectAdvertCount != null : !((Object)this$todayResourceEffectAdvertCount).equals(other$todayResourceEffectAdvertCount)) {
            return false;
        }
        String this$lastResource = this.getLastResource();
        String other$lastResource = other.getLastResource();
        if (this$lastResource == null ? other$lastResource != null : !this$lastResource.equals(other$lastResource)) {
            return false;
        }
        String this$lastLaunchAccount = this.getLastLaunchAccount();
        String other$lastLaunchAccount = other.getLastLaunchAccount();
        if (this$lastLaunchAccount == null ? other$lastLaunchAccount != null : !this$lastLaunchAccount.equals(other$lastLaunchAccount)) {
            return false;
        }
        String this$lastLaunchPlan = this.getLastLaunchPlan();
        String other$lastLaunchPlan = other.getLastLaunchPlan();
        if (this$lastLaunchPlan == null ? other$lastLaunchPlan != null : !this$lastLaunchPlan.equals(other$lastLaunchPlan)) {
            return false;
        }
        Set<Integer> this$advertExposureSet = this.getAdvertExposureSet();
        Set<Integer> other$advertExposureSet = other.getAdvertExposureSet();
        if (this$advertExposureSet == null ? other$advertExposureSet != null : !((Object)this$advertExposureSet).equals(other$advertExposureSet)) {
            return false;
        }
        Set<Integer> this$advertClickSet = this.getAdvertClickSet();
        Set<Integer> other$advertClickSet = other.getAdvertClickSet();
        if (this$advertClickSet == null ? other$advertClickSet != null : !((Object)this$advertClickSet).equals(other$advertClickSet)) {
            return false;
        }
        Set<Integer> this$accountClickSet = this.getAccountClickSet();
        Set<Integer> other$accountClickSet = other.getAccountClickSet();
        if (this$accountClickSet == null ? other$accountClickSet != null : !((Object)this$accountClickSet).equals(other$accountClickSet)) {
            return false;
        }
        Set<String> this$resourceClickSet = this.getResourceClickSet();
        Set<String> other$resourceClickSet = other.getResourceClickSet();
        if (this$resourceClickSet == null ? other$resourceClickSet != null : !((Object)this$resourceClickSet).equals(other$resourceClickSet)) {
            return false;
        }
        Set<Integer> this$tradeClickSet = this.getTradeClickSet();
        Set<Integer> other$tradeClickSet = other.getTradeClickSet();
        if (this$tradeClickSet == null ? other$tradeClickSet != null : !((Object)this$tradeClickSet).equals(other$tradeClickSet)) {
            return false;
        }
        Set<Integer> this$advertEffectSet = this.getAdvertEffectSet();
        Set<Integer> other$advertEffectSet = other.getAdvertEffectSet();
        if (this$advertEffectSet == null ? other$advertEffectSet != null : !((Object)this$advertEffectSet).equals(other$advertEffectSet)) {
            return false;
        }
        Set<Integer> this$accountEffectSet = this.getAccountEffectSet();
        Set<Integer> other$accountEffectSet = other.getAccountEffectSet();
        if (this$accountEffectSet == null ? other$accountEffectSet != null : !((Object)this$accountEffectSet).equals(other$accountEffectSet)) {
            return false;
        }
        Set<String> this$resourceEffectSet = this.getResourceEffectSet();
        Set<String> other$resourceEffectSet = other.getResourceEffectSet();
        if (this$resourceEffectSet == null ? other$resourceEffectSet != null : !((Object)this$resourceEffectSet).equals(other$resourceEffectSet)) {
            return false;
        }
        Set<Integer> this$tradeEffectSet = this.getTradeEffectSet();
        Set<Integer> other$tradeEffectSet = other.getTradeEffectSet();
        if (this$tradeEffectSet == null ? other$tradeEffectSet != null : !((Object)this$tradeEffectSet).equals(other$tradeEffectSet)) {
            return false;
        }
        Map<Integer, Long> this$todayAdvertLaunch = this.getTodayAdvertLaunch();
        Map<Integer, Long> other$todayAdvertLaunch = other.getTodayAdvertLaunch();
        if (this$todayAdvertLaunch == null ? other$todayAdvertLaunch != null : !((Object)this$todayAdvertLaunch).equals(other$todayAdvertLaunch)) {
            return false;
        }
        Map<Integer, Long> this$todayAdvertClick = this.getTodayAdvertClick();
        Map<Integer, Long> other$todayAdvertClick = other.getTodayAdvertClick();
        if (this$todayAdvertClick == null ? other$todayAdvertClick != null : !((Object)this$todayAdvertClick).equals(other$todayAdvertClick)) {
            return false;
        }
        Map<Integer, Long> this$todayAdvertEffect = this.getTodayAdvertEffect();
        Map<Integer, Long> other$todayAdvertEffect = other.getTodayAdvertEffect();
        if (this$todayAdvertEffect == null ? other$todayAdvertEffect != null : !((Object)this$todayAdvertEffect).equals(other$todayAdvertEffect)) {
            return false;
        }
        Map<Integer, Long> this$historyAdvertLaunch = this.getHistoryAdvertLaunch();
        Map<Integer, Long> other$historyAdvertLaunch = other.getHistoryAdvertLaunch();
        if (this$historyAdvertLaunch == null ? other$historyAdvertLaunch != null : !((Object)this$historyAdvertLaunch).equals(other$historyAdvertLaunch)) {
            return false;
        }
        Map<Integer, Long> this$historyAdvertClick = this.getHistoryAdvertClick();
        Map<Integer, Long> other$historyAdvertClick = other.getHistoryAdvertClick();
        if (this$historyAdvertClick == null ? other$historyAdvertClick != null : !((Object)this$historyAdvertClick).equals(other$historyAdvertClick)) {
            return false;
        }
        Map<Integer, Long> this$historyAdvertEffect = this.getHistoryAdvertEffect();
        Map<Integer, Long> other$historyAdvertEffect = other.getHistoryAdvertEffect();
        if (this$historyAdvertEffect == null ? other$historyAdvertEffect != null : !((Object)this$historyAdvertEffect).equals(other$historyAdvertEffect)) {
            return false;
        }
        Integer this$history30LaunchCount = this.getHistory30LaunchCount();
        Integer other$history30LaunchCount = other.getHistory30LaunchCount();
        if (this$history30LaunchCount == null ? other$history30LaunchCount != null : !((Object)this$history30LaunchCount).equals(other$history30LaunchCount)) {
            return false;
        }
        Integer this$history30ClickCount = this.getHistory30ClickCount();
        Integer other$history30ClickCount = other.getHistory30ClickCount();
        if (this$history30ClickCount == null ? other$history30ClickCount != null : !((Object)this$history30ClickCount).equals(other$history30ClickCount)) {
            return false;
        }
        Integer this$history30EffectCount = this.getHistory30EffectCount();
        Integer other$history30EffectCount = other.getHistory30EffectCount();
        if (this$history30EffectCount == null ? other$history30EffectCount != null : !((Object)this$history30EffectCount).equals(other$history30EffectCount)) {
            return false;
        }
        Integer this$todayLaunchCount = this.getTodayLaunchCount();
        Integer other$todayLaunchCount = other.getTodayLaunchCount();
        if (this$todayLaunchCount == null ? other$todayLaunchCount != null : !((Object)this$todayLaunchCount).equals(other$todayLaunchCount)) {
            return false;
        }
        Integer this$todayClickCount = this.getTodayClickCount();
        Integer other$todayClickCount = other.getTodayClickCount();
        if (this$todayClickCount == null ? other$todayClickCount != null : !((Object)this$todayClickCount).equals(other$todayClickCount)) {
            return false;
        }
        Integer this$todayEffectCount = this.getTodayEffectCount();
        Integer other$todayEffectCount = other.getTodayEffectCount();
        if (this$todayEffectCount == null ? other$todayEffectCount != null : !((Object)this$todayEffectCount).equals(other$todayEffectCount)) {
            return false;
        }
        String this$oUIIds = this.getOUIIds();
        String other$oUIIds = other.getOUIIds();
        if (this$oUIIds == null ? other$oUIIds != null : !this$oUIIds.equals(other$oUIIds)) {
            return false;
        }
        String this$oUILaunchPV = this.getOUILaunchPV();
        String other$oUILaunchPV = other.getOUILaunchPV();
        if (this$oUILaunchPV == null ? other$oUILaunchPV != null : !this$oUILaunchPV.equals(other$oUILaunchPV)) {
            return false;
        }
        String this$oUIClickPv = this.getOUIClickPv();
        String other$oUIClickPv = other.getOUIClickPv();
        if (this$oUIClickPv == null ? other$oUIClickPv != null : !this$oUIClickPv.equals(other$oUIClickPv)) {
            return false;
        }
        String this$oUIEffectPv = this.getOUIEffectPv();
        String other$oUIEffectPv = other.getOUIEffectPv();
        if (this$oUIEffectPv == null ? other$oUIEffectPv != null : !this$oUIEffectPv.equals(other$oUIEffectPv)) {
            return false;
        }
        Map<String, Long> this$historyTradeLaunch = this.getHistoryTradeLaunch();
        Map<String, Long> other$historyTradeLaunch = other.getHistoryTradeLaunch();
        if (this$historyTradeLaunch == null ? other$historyTradeLaunch != null : !((Object)this$historyTradeLaunch).equals(other$historyTradeLaunch)) {
            return false;
        }
        Map<String, Long> this$historyTradeClick = this.getHistoryTradeClick();
        Map<String, Long> other$historyTradeClick = other.getHistoryTradeClick();
        if (this$historyTradeClick == null ? other$historyTradeClick != null : !((Object)this$historyTradeClick).equals(other$historyTradeClick)) {
            return false;
        }
        Map<String, Long> this$historyTradeEffect = this.getHistoryTradeEffect();
        Map<String, Long> other$historyTradeEffect = other.getHistoryTradeEffect();
        return !(this$historyTradeEffect == null ? other$historyTradeEffect != null : !((Object)this$historyTradeEffect).equals(other$historyTradeEffect));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserActFeature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $userActiveDays = this.getUserActiveDays();
        result = result * 59 + ($userActiveDays == null ? 43 : ((Object)$userActiveDays).hashCode());
        Integer $activityRequest = this.getActivityRequest();
        result = result * 59 + ($activityRequest == null ? 43 : ((Object)$activityRequest).hashCode());
        Integer $weekActivityRequest = this.getWeekActivityRequest();
        result = result * 59 + ($weekActivityRequest == null ? 43 : ((Object)$weekActivityRequest).hashCode());
        Integer $dayActivityRequest = this.getDayActivityRequest();
        result = result * 59 + ($dayActivityRequest == null ? 43 : ((Object)$dayActivityRequest).hashCode());
        Integer $intervalActivityRequest = this.getIntervalActivityRequest();
        result = result * 59 + ($intervalActivityRequest == null ? 43 : ((Object)$intervalActivityRequest).hashCode());
        String $periodActivityRequest = this.getPeriodActivityRequest();
        result = result * 59 + ($periodActivityRequest == null ? 43 : $periodActivityRequest.hashCode());
        Integer $activityJoin = this.getActivityJoin();
        result = result * 59 + ($activityJoin == null ? 43 : ((Object)$activityJoin).hashCode());
        Integer $weekActivityJoin = this.getWeekActivityJoin();
        result = result * 59 + ($weekActivityJoin == null ? 43 : ((Object)$weekActivityJoin).hashCode());
        Integer $dayActivityJoin = this.getDayActivityJoin();
        result = result * 59 + ($dayActivityJoin == null ? 43 : ((Object)$dayActivityJoin).hashCode());
        Integer $intervalActivityJoin = this.getIntervalActivityJoin();
        result = result * 59 + ($intervalActivityJoin == null ? 43 : ((Object)$intervalActivityJoin).hashCode());
        String $periodActivityJoin = this.getPeriodActivityJoin();
        result = result * 59 + ($periodActivityJoin == null ? 43 : $periodActivityJoin.hashCode());
        Integer $activityPageStay = this.getActivityPageStay();
        result = result * 59 + ($activityPageStay == null ? 43 : ((Object)$activityPageStay).hashCode());
        String $launchTrade = this.getLaunchTrade();
        result = result * 59 + ($launchTrade == null ? 43 : $launchTrade.hashCode());
        String $weekLaunchTrade = this.getWeekLaunchTrade();
        result = result * 59 + ($weekLaunchTrade == null ? 43 : $weekLaunchTrade.hashCode());
        Map<String, Integer> $dayLaunchTrade = this.getDayLaunchTrade();
        result = result * 59 + ($dayLaunchTrade == null ? 43 : ((Object)$dayLaunchTrade).hashCode());
        Integer $intervalLaunchTrade = this.getIntervalLaunchTrade();
        result = result * 59 + ($intervalLaunchTrade == null ? 43 : ((Object)$intervalLaunchTrade).hashCode());
        String $periodLaunchTrade = this.getPeriodLaunchTrade();
        result = result * 59 + ($periodLaunchTrade == null ? 43 : $periodLaunchTrade.hashCode());
        Integer $avgLaunchStay = this.getAvgLaunchStay();
        result = result * 59 + ($avgLaunchStay == null ? 43 : ((Object)$avgLaunchStay).hashCode());
        String $lastLaunchTrade = this.getLastLaunchTrade();
        result = result * 59 + ($lastLaunchTrade == null ? 43 : $lastLaunchTrade.hashCode());
        Integer $clickLaunchTrade = this.getClickLaunchTrade();
        result = result * 59 + ($clickLaunchTrade == null ? 43 : ((Object)$clickLaunchTrade).hashCode());
        String $clickTrade = this.getClickTrade();
        result = result * 59 + ($clickTrade == null ? 43 : $clickTrade.hashCode());
        String $weekClickTrade = this.getWeekClickTrade();
        result = result * 59 + ($weekClickTrade == null ? 43 : $weekClickTrade.hashCode());
        Map<String, Integer> $dayClickTrade = this.getDayClickTrade();
        result = result * 59 + ($dayClickTrade == null ? 43 : ((Object)$dayClickTrade).hashCode());
        Integer $intervalClickTrade = this.getIntervalClickTrade();
        result = result * 59 + ($intervalClickTrade == null ? 43 : ((Object)$intervalClickTrade).hashCode());
        String $periodClickTrade = this.getPeriodClickTrade();
        result = result * 59 + ($periodClickTrade == null ? 43 : $periodClickTrade.hashCode());
        String $lastClickTrade = this.getLastClickTrade();
        result = result * 59 + ($lastClickTrade == null ? 43 : $lastClickTrade.hashCode());
        Integer $effectClickTrade = this.getEffectClickTrade();
        result = result * 59 + ($effectClickTrade == null ? 43 : ((Object)$effectClickTrade).hashCode());
        String $effectTrade = this.getEffectTrade();
        result = result * 59 + ($effectTrade == null ? 43 : $effectTrade.hashCode());
        String $weekEffectTrade = this.getWeekEffectTrade();
        result = result * 59 + ($weekEffectTrade == null ? 43 : $weekEffectTrade.hashCode());
        Map<String, Integer> $dayEffectTrade = this.getDayEffectTrade();
        result = result * 59 + ($dayEffectTrade == null ? 43 : ((Object)$dayEffectTrade).hashCode());
        Integer $intervalEffectTrade = this.getIntervalEffectTrade();
        result = result * 59 + ($intervalEffectTrade == null ? 43 : ((Object)$intervalEffectTrade).hashCode());
        String $periodEffectTrade = this.getPeriodEffectTrade();
        result = result * 59 + ($periodEffectTrade == null ? 43 : $periodEffectTrade.hashCode());
        String $lastEffectTrade = this.getLastEffectTrade();
        result = result * 59 + ($lastEffectTrade == null ? 43 : $lastEffectTrade.hashCode());
        Long $todayLaunch = this.getTodayLaunch();
        result = result * 59 + ($todayLaunch == null ? 43 : ((Object)$todayLaunch).hashCode());
        Long $historyLaunch = this.getHistoryLaunch();
        result = result * 59 + ($historyLaunch == null ? 43 : ((Object)$historyLaunch).hashCode());
        Long $todayActivityLaunch = this.getTodayActivityLaunch();
        result = result * 59 + ($todayActivityLaunch == null ? 43 : ((Object)$todayActivityLaunch).hashCode());
        Long $historyActivityLaunch = this.getHistoryActivityLaunch();
        result = result * 59 + ($historyActivityLaunch == null ? 43 : ((Object)$historyActivityLaunch).hashCode());
        String $lastLaunchTime = this.getLastLaunchTime();
        result = result * 59 + ($lastLaunchTime == null ? 43 : $lastLaunchTime.hashCode());
        String $lastActivityLaunchTime = this.getLastActivityLaunchTime();
        result = result * 59 + ($lastActivityLaunchTime == null ? 43 : $lastActivityLaunchTime.hashCode());
        String $lastActivityLaunchOrder = this.getLastActivityLaunchOrder();
        result = result * 59 + ($lastActivityLaunchOrder == null ? 43 : $lastActivityLaunchOrder.hashCode());
        String $lastActivityClickOrder = this.getLastActivityClickOrder();
        result = result * 59 + ($lastActivityClickOrder == null ? 43 : $lastActivityClickOrder.hashCode());
        String $lastLaunchOrder = this.getLastLaunchOrder();
        result = result * 59 + ($lastLaunchOrder == null ? 43 : $lastLaunchOrder.hashCode());
        String $lastClickOrder = this.getLastClickOrder();
        result = result * 59 + ($lastClickOrder == null ? 43 : $lastClickOrder.hashCode());
        String $lastActivity = this.getLastActivity();
        result = result * 59 + ($lastActivity == null ? 43 : $lastActivity.hashCode());
        String $lastAdvertMatchTag = this.getLastAdvertMatchTag();
        result = result * 59 + ($lastAdvertMatchTag == null ? 43 : $lastAdvertMatchTag.hashCode());
        Map<String, Long> $todayResourceLaunch = this.getTodayResourceLaunch();
        result = result * 59 + ($todayResourceLaunch == null ? 43 : ((Object)$todayResourceLaunch).hashCode());
        Map<String, String> $lastResourceLaunchTime = this.getLastResourceLaunchTime();
        result = result * 59 + ($lastResourceLaunchTime == null ? 43 : ((Object)$lastResourceLaunchTime).hashCode());
        Map<String, String> $lastResourceLaunchOrder = this.getLastResourceLaunchOrder();
        result = result * 59 + ($lastResourceLaunchOrder == null ? 43 : ((Object)$lastResourceLaunchOrder).hashCode());
        Map<String, String> $lastResourceClickOrder = this.getLastResourceClickOrder();
        result = result * 59 + ($lastResourceClickOrder == null ? 43 : ((Object)$lastResourceClickOrder).hashCode());
        Map<String, String> $lastResourceEffectOrder = this.getLastResourceEffectOrder();
        result = result * 59 + ($lastResourceEffectOrder == null ? 43 : ((Object)$lastResourceEffectOrder).hashCode());
        Map<String, Long> $todayResourceClickAdvertCount = this.getTodayResourceClickAdvertCount();
        result = result * 59 + ($todayResourceClickAdvertCount == null ? 43 : ((Object)$todayResourceClickAdvertCount).hashCode());
        Map<String, Long> $todayResourceEffectAdvertCount = this.getTodayResourceEffectAdvertCount();
        result = result * 59 + ($todayResourceEffectAdvertCount == null ? 43 : ((Object)$todayResourceEffectAdvertCount).hashCode());
        String $lastResource = this.getLastResource();
        result = result * 59 + ($lastResource == null ? 43 : $lastResource.hashCode());
        String $lastLaunchAccount = this.getLastLaunchAccount();
        result = result * 59 + ($lastLaunchAccount == null ? 43 : $lastLaunchAccount.hashCode());
        String $lastLaunchPlan = this.getLastLaunchPlan();
        result = result * 59 + ($lastLaunchPlan == null ? 43 : $lastLaunchPlan.hashCode());
        Set<Integer> $advertExposureSet = this.getAdvertExposureSet();
        result = result * 59 + ($advertExposureSet == null ? 43 : ((Object)$advertExposureSet).hashCode());
        Set<Integer> $advertClickSet = this.getAdvertClickSet();
        result = result * 59 + ($advertClickSet == null ? 43 : ((Object)$advertClickSet).hashCode());
        Set<Integer> $accountClickSet = this.getAccountClickSet();
        result = result * 59 + ($accountClickSet == null ? 43 : ((Object)$accountClickSet).hashCode());
        Set<String> $resourceClickSet = this.getResourceClickSet();
        result = result * 59 + ($resourceClickSet == null ? 43 : ((Object)$resourceClickSet).hashCode());
        Set<Integer> $tradeClickSet = this.getTradeClickSet();
        result = result * 59 + ($tradeClickSet == null ? 43 : ((Object)$tradeClickSet).hashCode());
        Set<Integer> $advertEffectSet = this.getAdvertEffectSet();
        result = result * 59 + ($advertEffectSet == null ? 43 : ((Object)$advertEffectSet).hashCode());
        Set<Integer> $accountEffectSet = this.getAccountEffectSet();
        result = result * 59 + ($accountEffectSet == null ? 43 : ((Object)$accountEffectSet).hashCode());
        Set<String> $resourceEffectSet = this.getResourceEffectSet();
        result = result * 59 + ($resourceEffectSet == null ? 43 : ((Object)$resourceEffectSet).hashCode());
        Set<Integer> $tradeEffectSet = this.getTradeEffectSet();
        result = result * 59 + ($tradeEffectSet == null ? 43 : ((Object)$tradeEffectSet).hashCode());
        Map<Integer, Long> $todayAdvertLaunch = this.getTodayAdvertLaunch();
        result = result * 59 + ($todayAdvertLaunch == null ? 43 : ((Object)$todayAdvertLaunch).hashCode());
        Map<Integer, Long> $todayAdvertClick = this.getTodayAdvertClick();
        result = result * 59 + ($todayAdvertClick == null ? 43 : ((Object)$todayAdvertClick).hashCode());
        Map<Integer, Long> $todayAdvertEffect = this.getTodayAdvertEffect();
        result = result * 59 + ($todayAdvertEffect == null ? 43 : ((Object)$todayAdvertEffect).hashCode());
        Map<Integer, Long> $historyAdvertLaunch = this.getHistoryAdvertLaunch();
        result = result * 59 + ($historyAdvertLaunch == null ? 43 : ((Object)$historyAdvertLaunch).hashCode());
        Map<Integer, Long> $historyAdvertClick = this.getHistoryAdvertClick();
        result = result * 59 + ($historyAdvertClick == null ? 43 : ((Object)$historyAdvertClick).hashCode());
        Map<Integer, Long> $historyAdvertEffect = this.getHistoryAdvertEffect();
        result = result * 59 + ($historyAdvertEffect == null ? 43 : ((Object)$historyAdvertEffect).hashCode());
        Integer $history30LaunchCount = this.getHistory30LaunchCount();
        result = result * 59 + ($history30LaunchCount == null ? 43 : ((Object)$history30LaunchCount).hashCode());
        Integer $history30ClickCount = this.getHistory30ClickCount();
        result = result * 59 + ($history30ClickCount == null ? 43 : ((Object)$history30ClickCount).hashCode());
        Integer $history30EffectCount = this.getHistory30EffectCount();
        result = result * 59 + ($history30EffectCount == null ? 43 : ((Object)$history30EffectCount).hashCode());
        Integer $todayLaunchCount = this.getTodayLaunchCount();
        result = result * 59 + ($todayLaunchCount == null ? 43 : ((Object)$todayLaunchCount).hashCode());
        Integer $todayClickCount = this.getTodayClickCount();
        result = result * 59 + ($todayClickCount == null ? 43 : ((Object)$todayClickCount).hashCode());
        Integer $todayEffectCount = this.getTodayEffectCount();
        result = result * 59 + ($todayEffectCount == null ? 43 : ((Object)$todayEffectCount).hashCode());
        String $oUIIds = this.getOUIIds();
        result = result * 59 + ($oUIIds == null ? 43 : $oUIIds.hashCode());
        String $oUILaunchPV = this.getOUILaunchPV();
        result = result * 59 + ($oUILaunchPV == null ? 43 : $oUILaunchPV.hashCode());
        String $oUIClickPv = this.getOUIClickPv();
        result = result * 59 + ($oUIClickPv == null ? 43 : $oUIClickPv.hashCode());
        String $oUIEffectPv = this.getOUIEffectPv();
        result = result * 59 + ($oUIEffectPv == null ? 43 : $oUIEffectPv.hashCode());
        Map<String, Long> $historyTradeLaunch = this.getHistoryTradeLaunch();
        result = result * 59 + ($historyTradeLaunch == null ? 43 : ((Object)$historyTradeLaunch).hashCode());
        Map<String, Long> $historyTradeClick = this.getHistoryTradeClick();
        result = result * 59 + ($historyTradeClick == null ? 43 : ((Object)$historyTradeClick).hashCode());
        Map<String, Long> $historyTradeEffect = this.getHistoryTradeEffect();
        result = result * 59 + ($historyTradeEffect == null ? 43 : ((Object)$historyTradeEffect).hashCode());
        return result;
    }

    public String toString() {
        return "UserActFeature(userActiveDays=" + this.getUserActiveDays() + ", activityRequest=" + this.getActivityRequest() + ", weekActivityRequest=" + this.getWeekActivityRequest() + ", dayActivityRequest=" + this.getDayActivityRequest() + ", intervalActivityRequest=" + this.getIntervalActivityRequest() + ", periodActivityRequest=" + this.getPeriodActivityRequest() + ", activityJoin=" + this.getActivityJoin() + ", weekActivityJoin=" + this.getWeekActivityJoin() + ", dayActivityJoin=" + this.getDayActivityJoin() + ", intervalActivityJoin=" + this.getIntervalActivityJoin() + ", periodActivityJoin=" + this.getPeriodActivityJoin() + ", activityPageStay=" + this.getActivityPageStay() + ", launchTrade=" + this.getLaunchTrade() + ", weekLaunchTrade=" + this.getWeekLaunchTrade() + ", dayLaunchTrade=" + this.getDayLaunchTrade() + ", intervalLaunchTrade=" + this.getIntervalLaunchTrade() + ", periodLaunchTrade=" + this.getPeriodLaunchTrade() + ", avgLaunchStay=" + this.getAvgLaunchStay() + ", lastLaunchTrade=" + this.getLastLaunchTrade() + ", clickLaunchTrade=" + this.getClickLaunchTrade() + ", clickTrade=" + this.getClickTrade() + ", weekClickTrade=" + this.getWeekClickTrade() + ", dayClickTrade=" + this.getDayClickTrade() + ", intervalClickTrade=" + this.getIntervalClickTrade() + ", periodClickTrade=" + this.getPeriodClickTrade() + ", lastClickTrade=" + this.getLastClickTrade() + ", effectClickTrade=" + this.getEffectClickTrade() + ", effectTrade=" + this.getEffectTrade() + ", weekEffectTrade=" + this.getWeekEffectTrade() + ", dayEffectTrade=" + this.getDayEffectTrade() + ", intervalEffectTrade=" + this.getIntervalEffectTrade() + ", periodEffectTrade=" + this.getPeriodEffectTrade() + ", lastEffectTrade=" + this.getLastEffectTrade() + ", todayLaunch=" + this.getTodayLaunch() + ", historyLaunch=" + this.getHistoryLaunch() + ", todayActivityLaunch=" + this.getTodayActivityLaunch() + ", historyActivityLaunch=" + this.getHistoryActivityLaunch() + ", lastLaunchTime=" + this.getLastLaunchTime() + ", lastActivityLaunchTime=" + this.getLastActivityLaunchTime() + ", lastActivityLaunchOrder=" + this.getLastActivityLaunchOrder() + ", lastActivityClickOrder=" + this.getLastActivityClickOrder() + ", lastLaunchOrder=" + this.getLastLaunchOrder() + ", lastClickOrder=" + this.getLastClickOrder() + ", lastActivity=" + this.getLastActivity() + ", lastAdvertMatchTag=" + this.getLastAdvertMatchTag() + ", todayResourceLaunch=" + this.getTodayResourceLaunch() + ", lastResourceLaunchTime=" + this.getLastResourceLaunchTime() + ", lastResourceLaunchOrder=" + this.getLastResourceLaunchOrder() + ", lastResourceClickOrder=" + this.getLastResourceClickOrder() + ", lastResourceEffectOrder=" + this.getLastResourceEffectOrder() + ", todayResourceClickAdvertCount=" + this.getTodayResourceClickAdvertCount() + ", todayResourceEffectAdvertCount=" + this.getTodayResourceEffectAdvertCount() + ", lastResource=" + this.getLastResource() + ", lastLaunchAccount=" + this.getLastLaunchAccount() + ", lastLaunchPlan=" + this.getLastLaunchPlan() + ", advertExposureSet=" + this.getAdvertExposureSet() + ", advertClickSet=" + this.getAdvertClickSet() + ", accountClickSet=" + this.getAccountClickSet() + ", resourceClickSet=" + this.getResourceClickSet() + ", tradeClickSet=" + this.getTradeClickSet() + ", advertEffectSet=" + this.getAdvertEffectSet() + ", accountEffectSet=" + this.getAccountEffectSet() + ", resourceEffectSet=" + this.getResourceEffectSet() + ", tradeEffectSet=" + this.getTradeEffectSet() + ", todayAdvertLaunch=" + this.getTodayAdvertLaunch() + ", todayAdvertClick=" + this.getTodayAdvertClick() + ", todayAdvertEffect=" + this.getTodayAdvertEffect() + ", historyAdvertLaunch=" + this.getHistoryAdvertLaunch() + ", historyAdvertClick=" + this.getHistoryAdvertClick() + ", historyAdvertEffect=" + this.getHistoryAdvertEffect() + ", history30LaunchCount=" + this.getHistory30LaunchCount() + ", history30ClickCount=" + this.getHistory30ClickCount() + ", history30EffectCount=" + this.getHistory30EffectCount() + ", todayLaunchCount=" + this.getTodayLaunchCount() + ", todayClickCount=" + this.getTodayClickCount() + ", todayEffectCount=" + this.getTodayEffectCount() + ", oUIIds=" + this.getOUIIds() + ", oUILaunchPV=" + this.getOUILaunchPV() + ", oUIClickPv=" + this.getOUIClickPv() + ", oUIEffectPv=" + this.getOUIEffectPv() + ", historyTradeLaunch=" + this.getHistoryTradeLaunch() + ", historyTradeClick=" + this.getHistoryTradeClick() + ", historyTradeEffect=" + this.getHistoryTradeEffect() + ")";
    }
}

