package cn.com.duiba.nezha.alg.feature.vo.v2;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Created by pc on 2019/2/21.
 */

/**
 * 上下文特征对象
 * 场景链路
 * 1、广告位素材推荐/RTB竞价
 * 2、活动推荐
 * 3、券推荐
 *
 */
@Data
public class ContextFeatureDoV2 implements Serializable {
    private static final long serialVersionUID = 6695201251295150673L;


    /**
     * 一、使用场景：全链路
     */
    private Long appId; //媒体ID

    private Long slotId;  //广告位ID

    private Long slotSceneType;// 广告位类型（开屏/信息流/banner/icon等）

    private Long areaCode; // 地域，城市编码

    private String ip; // ip

    private String ipUsageType; // ip场景，家庭、机房、公用，企业等

    private String ua; // userAgent

    private String uaAppPackage; // 媒体包 示例 tuia.cn
    private String uaAppPackageTrade; // 媒体包行业类目，网赚、计步等

    private String phoneOs; // 操作系统

    private String osVersion; // 操作系统版本


    private String brandNameEn; // 设备品牌 英文名
    private String phoneModelCode; // 设备型号
    private String phonePriceLevel; // 设备价格区间


    private String operatorType; // 运营商（中国联通，中国移动，中国电信）
    private String connectionType; // 网络类型（2G，3G，4G）

    private String firstShowTime;//首发年份


    /**
     * 二、使用场景：广告位素材推荐/RTB出价、活动推荐、券推荐
     */
    private Long groupId; //ADX流量，推广组
    private Long resourceId; //ADX流量，资源位
    private Long sceneType;// 场景 互动/直投


    /**
     * 开户
     */
    private Long openAccountId; //快手-媒体开户账号id
    private Long extUnionSlotId; //快手-联盟广告位id
    private Long extAdvertGroupId; //快手-外部广告组id
    private Long extIdeaId; //快手-外部创意id

    /**
     * 开户/ADX
     */
    private String extAppTrade;//百度联盟-联盟媒体行业id
    private String externalAdBlockId;//百度联盟-联盟流量广告位ID
    private String externalAdBlockTypeId;//百度联盟-外部广告位类型ID 区分 开屏 信息流等


    /**
     * 三、使用场景：活动推荐、券推荐
     */
    private Long slotMaterailId; //广告位曝光 素材ID
    private Long dsm2A; //活动类型，是否返回拦截类型

    /**
     * 四、使用场景：券推荐
     */

    private Long activityId; //活动IDf.请求 f301000-f301001
    private Long activityPage; //自定义活动ID f.请求 新增，待编码 311001


    private String activitySkinType; //活动皮肤类型，转盘、砸金蛋等
    private String activitySourceType;//活动[进入当前券]的访问类型[广告位、浮标、返回拦截、弹层、区块]

    private String activityTagList; //活动标签，手机/红包/设计目标人群-网赚、计步等，格式 101,192,131

    private Long activityJoinTimes; //当前活动参与次数

}
