package cn.com.duiba.nezha.alg.feature.parse.v2;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserBehaviorSubFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserProfileSubFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2023.ActFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdContextFeatureDoV3;
import com.alibaba.fastjson.JSON;
import net.sf.cglib.core.CollectionUtils;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.*;

/**
 * Created by pc on 2019/2/21.
 */
public class DeviceFeatureParseV2 extends BaseParse {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DeviceFeatureParseV2.class);


    public static Map<String, String> parse(DmpFeatureDto dmpFeatureDto, String externalAdBlockId) {
        Map<String, String> retMap = new HashMap<>(100);

        if (dmpFeatureDto == null) {
            return retMap;
        }

        //DMP用户标签（只包含真实设备号）
        Map<String, String> labelDtoMap = parseTBDeviceLabelDiDto(dmpFeatureDto.getLabelDto());
        retMap.putAll(labelDtoMap);

        //实时特征（真实设备号+虚拟设备号）
        Map<String, String> featureOnlineDtoMap = parseTBDeviceFeatureOnlineDiDto(dmpFeatureDto.getFeatureOnlineDto());
        retMap.putAll(featureOnlineDtoMap);

        //离线特征-最近7天（真实设备号+虚拟设备号）
        Map<String, String> featureOffline7dDtoMap = parseTBDeviceFeatureOffline7dDiDto(dmpFeatureDto.getFeatureOffline7dDto());
        retMap.putAll(featureOffline7dDtoMap);

        //离线特征-最近14天（真实设备号+虚拟设备号）
        Map<String, String> featureOffline14dDtoMap = parseTBDeviceFeatureOffline14dDiDto(dmpFeatureDto.getFeatureOffline14dDto());
        retMap.putAll(featureOffline14dDtoMap);

        //离线特征-最近30天（只包含真实设备号）
        Map<String, String> featureOffline30dDtoMap = parseTBDeviceFeatureOffline30dDiDto(dmpFeatureDto.getFeatureOffline30dDto());
        retMap.putAll(featureOffline30dDtoMap);

        //离线特征-最近180天（只包含真实设备号）
        Map<String, String> featureOffline180dDtoMap = parseTBDeviceFeatureOffline180dDiDto(dmpFeatureDto.getFeatureOffline180dDto());
        retMap.putAll(featureOffline180dDtoMap);

        //离线特征-最近30天和最近180天融合（只包含真实设备号）
        Map<String, String> featureOfflineUnionDtoMap = parseTBDeviceFeatureOfflineUniondiDto(dmpFeatureDto.getFeatureOffline30dDto(), dmpFeatureDto.getFeatureOffline180dDto());
        retMap.putAll(featureOfflineUnionDtoMap);

        //全局特征-adx资源位数据
        Map<String, String> adxResourceDtoMap = parseTBDmpAdxResourceDiDto(dmpFeatureDto.getAdxResourceDto(), externalAdBlockId);
        retMap.putAll(adxResourceDtoMap);

        //全局特征-广告位数据
        Map<String, String> slotDtoMap = parseTBDmpSlotDiDto(dmpFeatureDto.getSlotDto());
        retMap.putAll(slotDtoMap);

        //全局特征-媒体包数据
        Map<String, String> appPackageDtoMap = parseAppPackageDto(dmpFeatureDto.getAppPackageDto());
        retMap.putAll(appPackageDtoMap);

        return retMap;

    }

    private static Map<String, String> parseTBDeviceLabelDiDto(TBDeviceLabelDiDto data) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }

        putMap(retMap, "fd_1001", data.getT1001());//性别
        putMap(retMap, "fd_1002", data.getT1002());//年龄
        putMap(retMap, "fd_1003", data.getT1003());//婚育情况
        putMap(retMap, "fd_1004", data.getT1004());//兴趣标签
        putMap(retMap, "fd_1005", data.getT1005());//用户安装的AppList
        putMap(retMap, "fd_1006", data.getT1006());//App一级分类
        putMap(retMap, "fd_1007", data.getT1007());//App二级分类
        putMap(retMap, "fd_1008", data.getT1008());//百度新版标签

        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOnlineDiDto(TBDeviceFeatureOnlineDiDto data) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }

        putMap(retMap, "fd_1101", data.getT1101());//adx竞价请求PV
        putMap(retMap, "fd_1102", data.getT1102());//adx竞价返回PV
        putMap(retMap, "fd_1103", data.getT1103());//adx曝光PV
        putMap(retMap, "fd_1104", data.getT1104());//adx入口素材点击PV
        putMap(retMap, "fd_1105", data.getT1105());//活动访问PV
        putMap(retMap, "fd_1106", data.getT1106());//活动参与PV
        putMap(retMap, "fd_1107", data.getT1107());//券曝光PV

        putMap(retMap, "fd_1108", data.getT1108());//券有效点击PV
        putMap(retMap, "fd_1109", data.getT1109());//首次adx竞价请求时间，unix时间戳(秒)
        putMap(retMap, "fd_1110", data.getT1110());//首次活动访问时间
        putMap(retMap, "fd_1111", data.getT1111());//广告行业ID (最新订单)
        putMap(retMap, "fd_1112", data.getT1112());//订单时间，unix时间戳(秒) (最新订单)
        putMap(retMap, "fd_1113", data.getT1113());//活动ID (最新订单)
        putMap(retMap, "fd_1114", data.getT1114());//曝光订单号 (最新订单)
        putMap(retMap, "fd_1115", data.getT1115());//计费订单号 (最新订单)
        putMap(retMap, "fd_1116", data.getT1116());//券是否点击 0:没有点击 1:点击 (最新订单)

        putMap(retMap, "fd_1117", getTopN(data.getT1117(), 5));//广告行业-落地页转化PV key:广告行业id  map
        //private Map<String, Long> T1117;

        putMap(retMap, "fd_1118", getTopN(data.getT1118(), 5));//广告行业-注册转化PV(type=3) key:广告行业id
        //private Map<String, Long> T1118;

        //putMap(retMap, "fd_1019", data.getT1119());//广告行业-理论消耗 key:广告行业id
        //private Map<String, Long> T1119;

        putMap(retMap, "fd_1120", getTopN(data.getT1120(), 5));//活动id-活动访问PV key:活动id
        //private Map<String, Long> T1120;
        putMap(retMap, "fd_1105_01", MathUtil.log2p(data.getT1105())); // 当日 经过log处理的活动访问pv
        putMap(retMap, "fd_1107_01", MathUtil.log2p(data.getT1107())); // 当日 经经过log处理的券曝光pv
        putMap(retMap, "fd_1108_01", MathUtil.log2p(data.getT1108())); // 当日 经经过log处理的券有效点击pv

        putMap(retMap, "fd_1108_02", BaseParse.bucket(data.getT1108(), BaseParse.dayClickRankBucket)); //经过分桶处理的当日券点击pv
        putMap(retMap, "fd_1106_02", BaseParse.bucket(data.getT1106(), BaseParse.dayLaunchRankBucket)); //经过分桶处理的当日活动参与pv
        putMap(retMap, "fd_1117_01", MathUtil.log2p(getTopSum(data.getT1117(), 99))); //当日 经所有广告行业上累计的落地页转化PV
        putMap(retMap, "fd_1118_01", MathUtil.log2p(getTopSum(data.getT1118(), 99))); //当日 经所有广告行业上累计的注册转化PV
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline7dDiDto(TBDeviceFeatureOffline7dDiDto data) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }


        putMap(retMap, "fd_1701", data.getT1701());//adx竞价请求PV
        putMap(retMap, "fd_1702", data.getT1702());//adx竞价返回PV
        putMap(retMap, "fd_1703", data.getT1703());//adx曝光PV
        putMap(retMap, "fd_1704", data.getT1704());//adx入口素材点击PV

        putMap(retMap, "fd_1705", data.getT1705());//活动访问PV	100
        putMap(retMap, "fd_1706", data.getT1706());//活动参与PV
        putMap(retMap, "fd_1707", data.getT1707());//券曝光PV
        putMap(retMap, "fd_1708", data.getT1708());//券有效点击PV


        putMap(retMap, "fd_1709", getTopN(data.getT1709(), 5));//广告行业-落地页转化PV key:广告行业id
        //private Map<String, Long> T1709;

        putMap(retMap, "fd_1710", getTopN(data.getT1710(), 5));//广告行业-注册转化PV(type=3) key:广告行业id
        //private Map<String, Long> T1710;

        //putMap(retMap, "fd_1711", data.getT1711());//广告行业-理论消耗 key:广告行业id
        //private Map<String, Long> T1711;
        putMap(retMap, "fd_1705_01", MathUtil.log2p(data.getT1705())); // 7日 经过log处理的活动访问pv
        putMap(retMap, "fd_1707_01", MathUtil.log2p(data.getT1707())); // 7日 经过log处理的券曝光pv
        putMap(retMap, "fd_1708_01", MathUtil.log2p(data.getT1708())); // 7日 经过log处理的券有效点击pv

        putMap(retMap, "fd_1709_01", MathUtil.log2p(getTopSum(data.getT1709(), 99))); // 7日 所有广告行业上累计的落地页转化PV
        putMap(retMap, "fd_1710_01", MathUtil.log2p(getTopSum(data.getT1710(), 99))); // 7日 所有广告行业上累计的注册转化PV
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline14dDiDto(TBDeviceFeatureOffline14dDiDto data) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }


        putMap(retMap, "fd_1201", data.getT1201());//adx竞价请求PV
        putMap(retMap, "fd_1202", data.getT1202());//adx竞价返回PV
        putMap(retMap, "fd_1203", data.getT1203());//adx曝光PV
        putMap(retMap, "fd_1204", data.getT1204());//adx入口素材点击PV

        putMap(retMap, "fd_1205", data.getT1205());//活动访问PV	100
        putMap(retMap, "fd_1206", data.getT1206());//活动参与PV
        putMap(retMap, "fd_1207", data.getT1207());//券曝光PV
        putMap(retMap, "fd_1208", data.getT1208());//券有效点击PV

        putMap(retMap, "fd_1209", getTopN(data.getT1209(), 5));//广告行业-落地页转化PV key:广告行业id
        //private Map<String, Long> T1209;

        putMap(retMap, "fd_1210", getTopN(data.getT1210(), 5));//广告行业-注册转化PV(type=3) key:广告行业id
        //private Map<String, Long> T1210;

        //广告行业-理论消耗(单位：分) key:广告行业id
        //private Map<String, Long> T1211;

        putMap(retMap, "fd_1212", getTopN(data.getT1212(), 5));//adx联盟媒体广告位-adx竞价请求PV
        //private Map<String, Long> T1212;

        putMap(retMap, "fd_1213", getTopN(data.getT1213(), 5));//adx资源位-adx竞价请求PV
        //private Map<String, Long> T1213;

        putMap(retMap, "fd_1214", getTopN(data.getT1214(), 5));//媒体包-活动访问PV
        //private Map<String, Long> T1214;

        putMap(retMap, "fd_1215", getTopN(data.getT1215(), 5));//媒体包二级分类-活动访问PV
        //private Map<String, Long> T1215;
        putMap(retMap, "fd_1205_01", MathUtil.log2p(data.getT1205())); // 14日 经过log处理的活动访问pv
        putMap(retMap, "fd_1207_01", MathUtil.log2p(data.getT1207())); // 14日 经过log处理的券曝光pv
        putMap(retMap, "fd_1208_01", MathUtil.log2p(data.getT1208())); // 14日 经过log处理的券有效点击pv

        putMap(retMap, "fd_1209_01", MathUtil.log2p(getTopSum(data.getT1209(), 99))); // 14日 所有广告行业上累计的落地页转化PV
        putMap(retMap, "fd_1210_01", MathUtil.log2p(getTopSum(data.getT1210(), 99))); // 14日 所有广告行业上累计的注册转化PV
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline30dDiDto(TBDeviceFeatureOffline30dDiDto data) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }


        putMap(retMap, "fd_1801", data.getT1801());//adx竞价请求PV
        putMap(retMap, "fd_1802", data.getT1802());//adx竞价返回PV
        putMap(retMap, "fd_1803", data.getT1803());//adx曝光PV
        putMap(retMap, "fd_1804", data.getT1804());//adx入口素材点击PV

        putMap(retMap, "fd_1805", data.getT1805());//活动访问PV	100
        putMap(retMap, "fd_1806", data.getT1806());//活动参与PV
        putMap(retMap, "fd_1807", data.getT1807());//券曝光PV
        putMap(retMap, "fd_1808", data.getT1808());//券有效点击PV

        putMap(retMap, "fd_1809", getTopN(data.getT1809(), 5));// 30日 广告行业-落地页转化PV key:广告行业id
        //private Map<String, Long> T1809;

        putMap(retMap, "fd_1810", getTopN(data.getT1810(), 5));// 30日 广告行业-注册转化PV(type=3) key:广告行业id
        //private Map<String, Long> T1810;

        //广告行业-理论消耗 key:广告行业id
        //private Map<String, Long> T1811;
        putMap(retMap, "fd_1805_01", MathUtil.log2p(data.getT1805())); // 30日 经过log处理的活动访问pv
        putMap(retMap, "fd_1807_01", MathUtil.log2p(data.getT1807())); // 30日 经过log处理的券曝光pv
        putMap(retMap, "fd_1808_01", MathUtil.log2p(data.getT1808())); // 30日 经过log处理的券有效点击pv

        putMap(retMap, "fd_1809_01", MathUtil.log2p(getTopSum(data.getT1809(), 99))); // 30日 所有广告行业上累计的落地页转化PV
        putMap(retMap, "fd_1810_01", MathUtil.log2p(getTopSum(data.getT1810(), 99))); // 30日 所有广告行业上累计的注册转化PV
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline180dDiDto(TBDeviceFeatureOffline180dDiDto data) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }


        putMap(retMap, "fd_1301", data.getT1301());//adx竞价请求PV
        putMap(retMap, "fd_1302", data.getT1302());//adx竞价返回PV
        putMap(retMap, "fd_1303", data.getT1303());//adx曝光PV
        putMap(retMap, "fd_1304", data.getT1304());//adx入口素材点击PV

        putMap(retMap, "fd_1305", data.getT1305());//活动访问PV	100
        putMap(retMap, "fd_1306", data.getT1306());//活动参与PV
        putMap(retMap, "fd_1307", data.getT1307());//券曝光PV
        putMap(retMap, "fd_1308", data.getT1308());//券有效点击PV

        putMap(retMap, "fd_1309", getTopN(data.getT1309(), 5));// 180日 广告行业-落地页转化PV key:广告行业id
        //private Map<String, Long> T1309;

        putMap(retMap, "fd_1310", getTopN(data.getT1310(), 5));// 180日 广告行业-注册转化PV(type=3) key:广告行业id
        //private Map<String, Long> T1310;
        putMap(retMap, "fd_1305_01", MathUtil.log2p(data.getT1305())); //  180日 经过log处理的活动访问pv
        putMap(retMap, "fd_1307_01", MathUtil.log2p(data.getT1307())); //  180日 经过log处理的券曝光pv
        putMap(retMap, "fd_1308_01", MathUtil.log2p(data.getT1308())); //  180日 经过log处理的券有效点击pv

        putMap(retMap, "fd_1308_02", BaseParse.bucket(data.getT1308(), BaseParse.clickRankBucket)); //经过分桶处理的半年券点击pv
        putMap(retMap, "fd_1310_02", BaseParse.bucket(getTopSum(data.getT1310(), 30), BaseParse.effectRankBucket)); //经过分桶处理的，Top30广告行业累计的转化pv
        putMap(retMap, "fd_1309_01", MathUtil.log2p(getTopSum(data.getT1309(), 99))); // 180日 所有广告行业上累计的落地页转化PV
        putMap(retMap, "fd_1310_01", MathUtil.log2p(getTopSum(data.getT1310(), 99))); // 180日 所有广告行业上累计的注册转化PV
        //广告行业-理论消耗 key:广告行业id
        //private Map<String, Long> T1311;
        return retMap;
    }

    public static Map<String, String> parseTBDeviceFeatureOfflineUniondiDto(TBDeviceFeatureOffline30dDiDto data30di ,TBDeviceFeatureOffline180dDiDto data180di) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data30di == null && data180di == null) {
            return retMap;
        }
        List<String> tradeConvertList = new ArrayList<>();
        List<String> tradeconvert1List30di = new ArrayList<>(); //历史30天TopN落地页转化pv的广告行业id
        List<String> tradeconvert2List30di = new ArrayList<>(); //历史30天TopN注册转化pv的广告行业id
        List<String> tradeconvert1List180di = new ArrayList<>(); //历史180天TopN落地页转化pv的广告行业id
        List<String> tradeconvert2List180di = new ArrayList<>(); //历史180天TopN注册转化pv的广告行业id
        if (data30di != null) {
            tradeconvert1List30di = getTopNV2(data30di.getT1809(), 5, "30_1_");
            tradeconvert2List30di = getTopNV2(data30di.getT1810(), 5, "30_2_");

        }
        if (data180di != null) {
            tradeconvert1List180di = getTopNV2(data180di.getT1309(), 5, "180_1_");
            tradeconvert2List180di = getTopNV2(data180di.getT1310(), 5, "180_2_");
        }

        tradeConvertList.addAll(tradeconvert1List30di);
        tradeConvertList.addAll(tradeconvert2List30di);
        tradeConvertList.addAll(tradeconvert1List180di);
        tradeConvertList.addAll(tradeconvert2List180di);
        putMap(retMap, "fd_1318", tradeConvertList); // 30di + 180di 前top5广告行业上的 落地页转化pv 和 注册转化pv，合并List
        return retMap;
    }
    private static Map<String, String> parseTBDmpAdxResourceDiDto(TBDmpAdxResourceDiDto data, String externalAdBlockId) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null || externalAdBlockId == null) {
            return retMap;
        }

        //adx资源位id
        //private Long resourceId;


        //adx联盟媒体广告位-入口素材曝光PV，取top50
        //private Map<String, Long> T1401;

        //adx联盟媒体广告位-入口素材点击PV，取top50
        //private Map<String, Long> T1402;

        //adx联盟媒体广告位-券有效点击PV，取top50
        //private Map<String, Long> T1403;

        //adx联盟媒体广告位-注册转化PV，取top50
        //private Map<String, Long> T1404;

        //adx联盟媒体广告位-理论消耗，取top50
        //private Map<String, Long> T1405;


        //联盟广告位，入口ctr=adx点击/adx曝光
        putMap(retMap, "fd_1401_02", getMapRatioWithKey(data.getT1401(), data.getT1402(), 100, 0.05, externalAdBlockId));

        //联盟广告位，click=券点击/adx点击
        putMap(retMap, "fd_1402_03", getMapRatioWithKey(data.getT1402(), data.getT1403(), 100, 0.05, externalAdBlockId));

        //联盟广告位，cvr= 注册转化PV/adx点击
        putMap(retMap, "fd_1402_04", getMapRatioWithKey(data.getT1402(), data.getT1404(), 1000, 0.05 * 0.03, externalAdBlockId));

        return retMap;
    }

    private static Map<String, String> parseTBDmpSlotDiDto(TBDmpSlotDiDto data) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }

        putMap(retMap, "fd_1501", getTopN(data.getT1501(), 1));//广告id-券曝光PV，取top50
        //private Map<String, Long> T1501;

        putMap(retMap, "fd_1502", getTopN(data.getT1502(), 1));//广告id-计费点击PV，取top50
        //private Map<String, Long> T1502;

        putMap(retMap, "fd_1503", getTopN(data.getT1503(), 1));//广告id-落地页转化PV，取top50
        //private Map<String, Long> T1503;

        putMap(retMap, "fd_1504", getTopN(data.getT1504(), 1));//广告id-注册转化PV，取top50
        //private Map<String, Long> T1504;

        putMap(retMap, "fd_1505", getTopN(data.getT1505(), 1));//广告行业-券曝光PV，取top50
        //private Map<String, Long> T1505;

        putMap(retMap, "fd_1506", getTopN(data.getT1506(), 1));//广告位，top广告行业-计费点击PV，取top50
        //private Map<String, Long> T1506;

        putMap(retMap, "fd_1507", getTopN(data.getT1507(), 1));//广告位，top广告行业-落地页转化PV，取top50
        //private Map<String, Long> T1507;

        putMap(retMap, "fd_1508", getTopN(data.getT1508(), 1));//广告位，top广告行业-注册转化PV，取top50
        //private Map<String, Long> T1508;


        return retMap;
    }

    public static Map<String, String> parseTBDmpSlotDiDto(TBDmpSlotDiDto data, String advertId, String tradeId) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }

        putMap(retMap, "fd_1501", getTopN(data.getT1501(), 5));//广告id-券曝光PV，取top50
        //private Map<String, Long> T1501;

        putMap(retMap, "fd_1502", getTopN(data.getT1502(), 5));//广告id-计费点击PV，取top50
        //private Map<String, Long> T1502;

        putMap(retMap, "fd_1503", getTopN(data.getT1503(), 5));//广告id-落地页转化PV，取top50
        //private Map<String, Long> T1503;

        putMap(retMap, "fd_1504", getTopN(data.getT1504(), 5));//广告id-注册转化PV，取top50
        //private Map<String, Long> T1504;


        putMap(retMap, "fd_1505", getTopN(data.getT1505(), 5));//广告行业-券曝光PV，取top50
        //private Map<String, Long> T1505;

        putMap(retMap, "fd_1506", getTopN(data.getT1506(), 5));//广告行业-计费点击PV，取top50
        //private Map<String, Long> T1506;

        putMap(retMap, "fd_1507", getTopN(data.getT1507(), 5));//广告行业-落地页转化PV，取top50
        //private Map<String, Long> T1507;

        putMap(retMap, "fd_1508", getTopN(data.getT1508(), 5));//广告行业-注册转化PV，取top50
        //private Map<String, Long> T1508;


        // 广告位+计划 ctr
        putMap(retMap, "fd_1501_02", getMapRatioWithKey(data.getT1501(), data.getT1502(), 100, 0.50, advertId));
        // 广告位+计划 转化-0
        putMap(retMap, "fd_1502_03", getMapRatioWithKey(data.getT1502(), data.getT1503(), 100, 0.03, advertId));

        // 广告位+计划 转化-3
        putMap(retMap, "fd_1502_04", getMapRatioWithKey(data.getT1502(), data.getT1504(), 100, 0.03, advertId));


        // 广告位+行业 ctr
        putMap(retMap, "fd_1505_06", getMapRatioWithKey(data.getT1505(), data.getT1506(), 100, 0.50, tradeId));

        // 广告位+行业转化 -0
        putMap(retMap, "fd_1506_07", getMapRatioWithKey(data.getT1506(), data.getT1507(), 100, 0.03, tradeId));

        // 广告位+行业转化 -3
        putMap(retMap, "fd_1506_08", getMapRatioWithKey(data.getT1506(), data.getT1508(), 100, 0.03, tradeId));


        return retMap;
    }

    private static Map<String, String> parseAppPackageDto(TBDmpAppPackageDiDto data) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }
        //广告行业-券曝光PV，取top50
        //private Map<String, Long> T1601;

        //广告行业-计费点击PV，取top50
        //private Map<String, Long> T1602;

        //广告行业-落地页转化PV，取top50
        //private Map<String, Long> T1603;

        //广告行业-注册转化PV，取top50
        //private Map<String, Long> T1604;

        return retMap;
    }

    public static Map<String, String> parseAppPackageDto(TBDmpAppPackageDiDto data, String tradeId) {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }

        //广告行业-券曝光PV，取top50
        //private Map<String, Long> T1601;

        //广告行业-计费点击PV，取top50
        //private Map<String, Long> T1602;

        //广告行业-落地页转化PV，取top50
        //private Map<String, Long> T1603;

        //广告行业-注册转化PV，取top50
        //private Map<String, Long> T1604;

        // 媒体包，行业 ctr
        putMap(retMap, "fd_1601_02", getMapRatioWithKey(data.getT1601(), data.getT1602(), 100, 0.50, tradeId));

        // 媒体包，行业转化-0
        putMap(retMap, "fd_1602_03", getMapRatioWithKey(data.getT1602(), data.getT1603(), 100, 0.10, tradeId));

        // 媒体包，行业转化-3
        putMap(retMap, "fd_1602_04", getMapRatioWithKey(data.getT1602(), data.getT1604(), 100, 0.01, tradeId));

        return retMap;
    }


    public static <T> void putMap(Map<String, String> map, String key, T value) {

        if (value != null) {
            map.put(key, value.toString());
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, Set<String> value) {

        if (value != null) {
            List<String> list2 = new ArrayList<String>();
            list2.addAll(value);
            map.put(key, String.join(",", list2));
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, Map<String, T> value) {

        if (value != null) {
            List<String> list2 = new ArrayList<String>();
            list2.addAll(value.keySet());
            map.put(key, String.join(",", list2));
        }
    }


    public static <T> void putMap(Map<String, String> map, String key, List<String> value) {

        if (value != null) {
            map.put(key, String.join(",", value));
        }
    }

    /**
     * 返回map,key来自map1，value=map2.get()/map1.get()
     *
     * @param map1
     * @param map2
     * @return
     */
    public static Map<String, Double> getMapRatio(Map<String, Long> map1, Map<String, Long> map2, int threshold, double biasRatio) {
        Map<String, Double> retMap = new HashMap<>();

        if (AssertUtil.isAnyEmpty(map1, map2)) {
            return retMap;
        }
        for (Map.Entry<String, Long> entry : map1.entrySet()) {
            String key = entry.getKey();
            Long value1 = entry.getValue();
            Long value2 = map2.getOrDefault(key, 0L);
            Double ret = 0D;

            if (value1 == null) {
                retMap.put(key, ret);
                continue;
            }
            ret = (value2 + threshold * biasRatio) / (value1 + threshold);

            ret = MathUtil.formatDouble(ret, 7);

            retMap.put(key, ret);
        }


        return retMap;
    }

    /**
     * 返回map,key来自map1，value=map2.get()/map1.get()
     *
     * @param map1
     * @param map2
     * @return
     */
    public static Double getMapRatioWithKey(Map<String, Long> map1, Map<String, Long> map2, int threshold, double biasRatio, String key) {
        Double ret = null;

        if (AssertUtil.isAnyEmpty(map1, map2)) {
            return ret;
        }
        Long value1 = map1.get(key);
        Long value2 = map2.getOrDefault(key, 0L);
        if (value1 != null && value1 > 50) {
            ret = (value2 + threshold * biasRatio) / (value1 + threshold);
            ret = MathUtil.formatDouble(ret, 7);
        } else {
            ret = 0.0;
        }
        return ret;
    }


    /**
     * 返回值topN
     *
     * @param map
     * @param n
     * @return
     */
    public static List<String> getTopN(Map<String, Long> map, int n) {
        List<String> ret = new ArrayList<>();

        if (AssertUtil.isEmpty(map)) {
            return ret;
        }

        List<Map.Entry<String, Long>> list = new ArrayList<Map.Entry<String, Long>>(map.entrySet());

        Collections.sort(list, new Comparator<Map.Entry<String, Long>>() {
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                if (o1.getValue() != o2.getValue()) {
                    if (o1.getValue() == null) {
                        return 1;
                    }
                    if (o2.getValue() == null) {
                        return -1;
                    }
                    return o2.getValue().intValue() - o1.getValue().intValue();
                } else {
                    return 0;
                }
            }
        });

        for (int i = 0; i < Math.min(list.size(), n); i++) {
            Map.Entry<String, Long> e = list.get(i);
            ret.add(e.getKey());
        }

        return ret;
    }

    /**
     * 计算map中TopN的value值
     *
     * @param map
     * @param n
     * @return
     */
    public static Long getTopSum(Map<String, Long> map, int n) {
        Long ret = 0L;

        if (AssertUtil.isEmpty(map)) {
            return ret;
        }

        List<Map.Entry<String, Long>> list = new ArrayList<Map.Entry<String, Long>>(map.entrySet());

        Collections.sort(list, new Comparator<Map.Entry<String, Long>>() {
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                if (o1.getValue() != o2.getValue()) {
                    if (o1.getValue() == null) {
                        return 1;
                    }
                    if (o2.getValue() == null) {
                        return -1;
                    }
                    return o2.getValue().intValue() - o1.getValue().intValue();
                } else {
                    return 0;
                }
            }
        });

        for (int i = 0; i < Math.min(list.size(), n); i++) {
            Map.Entry<String, Long> e = list.get(i);
            ret += e.getValue();
        }

        return ret;
    }


    /**
     *
     */
    public static List<String> getTopNV2(Map<String, Long> mp, int n, String tag) {
        List<String> ret = new ArrayList<>();

        if (AssertUtil.isEmpty(mp)) {
            return ret;
        }
        List<Map.Entry<String, Long>> list1 = new ArrayList<Map.Entry<String, Long>>(mp.entrySet());
        Collections.sort(list1, new Comparator<Map.Entry<String, Long>>() {
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                if (o1.getValue() != o2.getValue()) {
                    if (o1.getValue() == null) {
                        return 1;
                    }
                    if (o2.getValue() == null) {
                        return -1;
                    }
                    return o2.getValue().intValue() - o1.getValue().intValue();
                } else {
                    return 0;
                }
            }
        });

        // 特征值构造含义，180_1_广告行业id_转化pv, 180代表历史天数，1代表落地页转化， 2代表注册转化，广告行业id，转化pv即指对应的(1落地页,2注册)转化pv值
        // 30_1_广告行业id_转化pv, 历史30天 广告行业id上的 转化pv值
        for (int i = 0; i < Math.min(list1.size(), n); i++) {
            Map.Entry<String, Long> e = list1.get(i);
            Integer rank = i + 1;
            String st = tag + e.getKey() + "_" + rank.toString();
            ret.add(st);
        }


        return ret;
    }
}


