/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.vo.v2023;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.nezha.alg.feature.parse.v2.DeviceFeatureParseV2;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdContextFeatureDoV3;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AdFeatureDoV3
implements Serializable {
    private static final long serialVersionUID = 6695201251295150673L;
    private Long advertId;
    private Long packageId;
    private Long accountId;
    private String OperatingResource;
    private String adNewTrade;
    private String adMatchTagNums;
    private Long landpageId;
    private Long frontpageId;
    private Long paypageId;
    private Long formpageId;
    private Long modelId;
    private String materialId;
    private String materialTags;
    private String materialCatg;
    private Long times;
    private String targetConvertType;
    private String deepTargetConvertType;

    public Map<String, String> parse(AdContextFeatureDoV3 data3) {
        HashMap<String, String> retMap = new HashMap<String, String>(32);
        AdFeatureDoV3.putMap(retMap, "ft200101", this.advertId);
        AdFeatureDoV3.putMap(retMap, "ft200110", this.packageId);
        AdFeatureDoV3.putMap(retMap, "ft200102", this.accountId);
        AdFeatureDoV3.putMap(retMap, "ft200103", this.OperatingResource);
        AdFeatureDoV3.putMap(retMap, "ft200104", this.adNewTrade);
        AdFeatureDoV3.putMap(retMap, "ft200105", this.adMatchTagNums);
        AdFeatureDoV3.putMap(retMap, "ft200106", this.materialId);
        AdFeatureDoV3.putMap(retMap, "ft200107", this.materialTags);
        AdFeatureDoV3.putMap(retMap, "ft200109", this.times);
        AdFeatureDoV3.putMap(retMap, "ft200111", this.materialCatg);
        retMap.put("ft200201", this.targetConvertType);
        retMap.put("ft200202", this.deepTargetConvertType);
        retMap.put("ft500101", this.advertId + "_" + this.targetConvertType);
        retMap.put("ft500201", this.advertId + "_" + this.deepTargetConvertType);
        retMap.put("ft500103", this.adNewTrade + "_" + this.targetConvertType);
        retMap.put("ft500203", this.adNewTrade + "_" + this.deepTargetConvertType);
        return retMap;
    }

    public Map<String, String> parseDmpCross(DmpFeatureDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(32);
        if (data == null || this.adNewTrade == null) {
            return retMap;
        }
        Map<String, String> appPackageDtoMap = DeviceFeatureParseV2.parseAppPackageDto(data.getAppPackageDto(), this.adNewTrade);
        retMap.putAll(appPackageDtoMap);
        Map<String, String> slotDtoMap = DeviceFeatureParseV2.parseTBDmpSlotDiDto(data.getSlotDto(), this.advertId.toString(), this.adNewTrade);
        retMap.putAll(slotDtoMap);
        retMap.put("fd_1011_01", DataConverter.getMatchStatus(data.getFeatureOnlineDto() == null ? null : data.getFeatureOnlineDto().getT1111(), this.adNewTrade));
        return retMap;
    }

    public static <T> void putMap(Map<String, String> map, String key, T value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    public Long getAdvertId() {
        return this.advertId;
    }

    public Long getPackageId() {
        return this.packageId;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public String getOperatingResource() {
        return this.OperatingResource;
    }

    public String getAdNewTrade() {
        return this.adNewTrade;
    }

    public String getAdMatchTagNums() {
        return this.adMatchTagNums;
    }

    public Long getLandpageId() {
        return this.landpageId;
    }

    public Long getFrontpageId() {
        return this.frontpageId;
    }

    public Long getPaypageId() {
        return this.paypageId;
    }

    public Long getFormpageId() {
        return this.formpageId;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public String getMaterialId() {
        return this.materialId;
    }

    public String getMaterialTags() {
        return this.materialTags;
    }

    public String getMaterialCatg() {
        return this.materialCatg;
    }

    public Long getTimes() {
        return this.times;
    }

    public String getTargetConvertType() {
        return this.targetConvertType;
    }

    public String getDeepTargetConvertType() {
        return this.deepTargetConvertType;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public void setOperatingResource(String OperatingResource) {
        this.OperatingResource = OperatingResource;
    }

    public void setAdNewTrade(String adNewTrade) {
        this.adNewTrade = adNewTrade;
    }

    public void setAdMatchTagNums(String adMatchTagNums) {
        this.adMatchTagNums = adMatchTagNums;
    }

    public void setLandpageId(Long landpageId) {
        this.landpageId = landpageId;
    }

    public void setFrontpageId(Long frontpageId) {
        this.frontpageId = frontpageId;
    }

    public void setPaypageId(Long paypageId) {
        this.paypageId = paypageId;
    }

    public void setFormpageId(Long formpageId) {
        this.formpageId = formpageId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public void setMaterialTags(String materialTags) {
        this.materialTags = materialTags;
    }

    public void setMaterialCatg(String materialCatg) {
        this.materialCatg = materialCatg;
    }

    public void setTimes(Long times) {
        this.times = times;
    }

    public void setTargetConvertType(String targetConvertType) {
        this.targetConvertType = targetConvertType;
    }

    public void setDeepTargetConvertType(String deepTargetConvertType) {
        this.deepTargetConvertType = deepTargetConvertType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdFeatureDoV3)) {
            return false;
        }
        AdFeatureDoV3 other = (AdFeatureDoV3)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$advertId = this.getAdvertId();
        Long other$advertId = other.getAdvertId();
        if (this$advertId == null ? other$advertId != null : !((Object)this$advertId).equals(other$advertId)) {
            return false;
        }
        Long this$packageId = this.getPackageId();
        Long other$packageId = other.getPackageId();
        if (this$packageId == null ? other$packageId != null : !((Object)this$packageId).equals(other$packageId)) {
            return false;
        }
        Long this$accountId = this.getAccountId();
        Long other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !((Object)this$accountId).equals(other$accountId)) {
            return false;
        }
        String this$OperatingResource = this.getOperatingResource();
        String other$OperatingResource = other.getOperatingResource();
        if (this$OperatingResource == null ? other$OperatingResource != null : !this$OperatingResource.equals(other$OperatingResource)) {
            return false;
        }
        String this$adNewTrade = this.getAdNewTrade();
        String other$adNewTrade = other.getAdNewTrade();
        if (this$adNewTrade == null ? other$adNewTrade != null : !this$adNewTrade.equals(other$adNewTrade)) {
            return false;
        }
        String this$adMatchTagNums = this.getAdMatchTagNums();
        String other$adMatchTagNums = other.getAdMatchTagNums();
        if (this$adMatchTagNums == null ? other$adMatchTagNums != null : !this$adMatchTagNums.equals(other$adMatchTagNums)) {
            return false;
        }
        Long this$landpageId = this.getLandpageId();
        Long other$landpageId = other.getLandpageId();
        if (this$landpageId == null ? other$landpageId != null : !((Object)this$landpageId).equals(other$landpageId)) {
            return false;
        }
        Long this$frontpageId = this.getFrontpageId();
        Long other$frontpageId = other.getFrontpageId();
        if (this$frontpageId == null ? other$frontpageId != null : !((Object)this$frontpageId).equals(other$frontpageId)) {
            return false;
        }
        Long this$paypageId = this.getPaypageId();
        Long other$paypageId = other.getPaypageId();
        if (this$paypageId == null ? other$paypageId != null : !((Object)this$paypageId).equals(other$paypageId)) {
            return false;
        }
        Long this$formpageId = this.getFormpageId();
        Long other$formpageId = other.getFormpageId();
        if (this$formpageId == null ? other$formpageId != null : !((Object)this$formpageId).equals(other$formpageId)) {
            return false;
        }
        Long this$modelId = this.getModelId();
        Long other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !((Object)this$modelId).equals(other$modelId)) {
            return false;
        }
        String this$materialId = this.getMaterialId();
        String other$materialId = other.getMaterialId();
        if (this$materialId == null ? other$materialId != null : !this$materialId.equals(other$materialId)) {
            return false;
        }
        String this$materialTags = this.getMaterialTags();
        String other$materialTags = other.getMaterialTags();
        if (this$materialTags == null ? other$materialTags != null : !this$materialTags.equals(other$materialTags)) {
            return false;
        }
        String this$materialCatg = this.getMaterialCatg();
        String other$materialCatg = other.getMaterialCatg();
        if (this$materialCatg == null ? other$materialCatg != null : !this$materialCatg.equals(other$materialCatg)) {
            return false;
        }
        Long this$times = this.getTimes();
        Long other$times = other.getTimes();
        if (this$times == null ? other$times != null : !((Object)this$times).equals(other$times)) {
            return false;
        }
        String this$targetConvertType = this.getTargetConvertType();
        String other$targetConvertType = other.getTargetConvertType();
        if (this$targetConvertType == null ? other$targetConvertType != null : !this$targetConvertType.equals(other$targetConvertType)) {
            return false;
        }
        String this$deepTargetConvertType = this.getDeepTargetConvertType();
        String other$deepTargetConvertType = other.getDeepTargetConvertType();
        return !(this$deepTargetConvertType == null ? other$deepTargetConvertType != null : !this$deepTargetConvertType.equals(other$deepTargetConvertType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdFeatureDoV3;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $advertId = this.getAdvertId();
        result = result * 59 + ($advertId == null ? 43 : ((Object)$advertId).hashCode());
        Long $packageId = this.getPackageId();
        result = result * 59 + ($packageId == null ? 43 : ((Object)$packageId).hashCode());
        Long $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : ((Object)$accountId).hashCode());
        String $OperatingResource = this.getOperatingResource();
        result = result * 59 + ($OperatingResource == null ? 43 : $OperatingResource.hashCode());
        String $adNewTrade = this.getAdNewTrade();
        result = result * 59 + ($adNewTrade == null ? 43 : $adNewTrade.hashCode());
        String $adMatchTagNums = this.getAdMatchTagNums();
        result = result * 59 + ($adMatchTagNums == null ? 43 : $adMatchTagNums.hashCode());
        Long $landpageId = this.getLandpageId();
        result = result * 59 + ($landpageId == null ? 43 : ((Object)$landpageId).hashCode());
        Long $frontpageId = this.getFrontpageId();
        result = result * 59 + ($frontpageId == null ? 43 : ((Object)$frontpageId).hashCode());
        Long $paypageId = this.getPaypageId();
        result = result * 59 + ($paypageId == null ? 43 : ((Object)$paypageId).hashCode());
        Long $formpageId = this.getFormpageId();
        result = result * 59 + ($formpageId == null ? 43 : ((Object)$formpageId).hashCode());
        Long $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : ((Object)$modelId).hashCode());
        String $materialId = this.getMaterialId();
        result = result * 59 + ($materialId == null ? 43 : $materialId.hashCode());
        String $materialTags = this.getMaterialTags();
        result = result * 59 + ($materialTags == null ? 43 : $materialTags.hashCode());
        String $materialCatg = this.getMaterialCatg();
        result = result * 59 + ($materialCatg == null ? 43 : $materialCatg.hashCode());
        Long $times = this.getTimes();
        result = result * 59 + ($times == null ? 43 : ((Object)$times).hashCode());
        String $targetConvertType = this.getTargetConvertType();
        result = result * 59 + ($targetConvertType == null ? 43 : $targetConvertType.hashCode());
        String $deepTargetConvertType = this.getDeepTargetConvertType();
        result = result * 59 + ($deepTargetConvertType == null ? 43 : $deepTargetConvertType.hashCode());
        return result;
    }

    public String toString() {
        return "AdFeatureDoV3(advertId=" + this.getAdvertId() + ", packageId=" + this.getPackageId() + ", accountId=" + this.getAccountId() + ", OperatingResource=" + this.getOperatingResource() + ", adNewTrade=" + this.getAdNewTrade() + ", adMatchTagNums=" + this.getAdMatchTagNums() + ", landpageId=" + this.getLandpageId() + ", frontpageId=" + this.getFrontpageId() + ", paypageId=" + this.getPaypageId() + ", formpageId=" + this.getFormpageId() + ", modelId=" + this.getModelId() + ", materialId=" + this.getMaterialId() + ", materialTags=" + this.getMaterialTags() + ", materialCatg=" + this.getMaterialCatg() + ", times=" + this.getTimes() + ", targetConvertType=" + this.getTargetConvertType() + ", deepTargetConvertType=" + this.getDeepTargetConvertType() + ")";
    }
}

