package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;


/**
 * @Description 素材纬度特征类
 * @Author lan
 * @Date 2020-07-21 6:40 下午
 */
@Data
public class MaterialFeature {
    //素材id
    private Long materialId;
    //素材标签1-是否定制,多值的话逗号分隔
    private String customization;
    //素材标签2-素材行业标签,多值的话逗号分隔
    private String industry;
    //素材标签3-广告位性质,多值的话逗号分隔
    private String slotNature;
    //素材标签4-设计色调,多值的话逗号分隔
    private String designHue;
    // 素材标签5-素材策略,多值的话逗号分隔
    private String strategy;
    // 素材标签6-奖品元素,多值的话逗号分隔
    private String rewardElement;
    // 素材标签7-设计动效,多值的话逗号分隔
    private String designType;
    //素材的历史7天曝光次数（流量来源sdk）
    private Long exposeWeekCnt;
    //素材的历史7天点击次数
    private Long clickWeekCnt;
    //素材的历史7天前端转化/后端转化次数 
    private Long convertWeekCnt;
    private Long bConvertWeekCnt;
    //素材今日的曝光次数
    private Long exposeDayCnt;
    //素材今日的点击次数
    private Long clickDayCnt;

    private Long sckExpUV14D; //  素材过去14天曝光uv
    private Long sckClkUV14D; //  素材过去14天点击uv
    private Long sckExpUV7D; //  素材过去7天曝光uv
    private Long sckClkUV7D; //  素材过去7天点击uv
    private Long sckExpUV3D; //  素材过去3天曝光uv
    private Long sckClkUV3D; //  素材过去3天点击uv
}
