/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RegionConf {
    private static Map<String, String> provinceMap = new HashMap<String, String>();
    public static final Set<String> HUABEI_REGION = new HashSet<String>(Arrays.asList("11", "12", "13", "14", "15"));
    public static final Set<String> DONGBEI_REGION = new HashSet<String>(Arrays.asList("21", "22", "23"));
    public static final Set<String> HUADONG_REGION = new HashSet<String>(Arrays.asList("31", "32", "33", "34", "35", "36", "37"));
    public static final Set<String> HUAZHONG_REGION = new HashSet<String>(Arrays.asList("41", "42", "43"));
    public static final Set<String> HUANAN_REGION = new HashSet<String>(Arrays.asList("44", "45", "46"));
    public static final Set<String> XINAN_REGION = new HashSet<String>(Arrays.asList("50", "51", "52", "53", "54"));
    public static final Set<String> XIBEI_REGION = new HashSet<String>(Arrays.asList("61", "62", "63", "64", "65"));
    public static final Set<String> HMT_REGION = new HashSet<String>(Arrays.asList("71", "81", "82"));
    public static final Set<String> HMT_TIER_CITY = new HashSet<String>(Arrays.asList("71", "81", "82"));
    public static final Set<String> FIRST_TIER_CITY = new HashSet<String>(Arrays.asList("11", "12", "31", "50", "2101", "3201", "3202", "3205", "3301", "3302", "3702", "4101", "4201", "4301", "4401", "4403", "4419", "5101", "6101"));
    public static final Set<String> SECOND_TIER_CITY = new HashSet<String>(Arrays.asList("1301", "1306", "1401", "2102", "2201", "2301", "3203", "3204", "3206", "3303", "3304", "3306", "3307", "3310", "3401", "3501", "3502", "3505", "3601", "3701", "3706", "3707", "4406", "4413", "4420", "4501", "5201", "5301", "6201", "6501"));
    public static final Set<String> THIRD_TIER_CITY = new HashSet<String>(Arrays.asList("1309", "1303", "1502", "2202", "3207", "3209", "3305", "3412", "3509", "3611", "3708", "3703", "4114", "4110", "4210", "4307", "4306", "4407", "4408", "4601", "5107", "6104", "1304", "1302", "1501", "2306", "3212", "3210", "3403", "3407", "3503", "3607", "3609", "3713", "4103", "4107", "4108", "4206", "4304", "4302", "4452", "4412", "4503", "4602", "5203", "6301", "1310", "1305", "2103", "3208", "3213", "3211", "3411", "3402", "3506", "3604", "3717", "3710", "4113", "4115", "4211", "4205", "4303", "4451", "4405", "4404", "4502", "5106", "5303", "6401"));

    public static String getProvince(String cityId) {
        if (cityId == null || cityId.trim().equals("")) {
            return null;
        }
        return cityId.substring(0, Math.min(cityId.length(), 2));
    }

    public static String getProvince(Long cityId) {
        if (cityId == null) {
            return null;
        }
        return RegionConf.getProvince(Long.toString(cityId));
    }

    public static String getRegion(String provinceId) {
        if (provinceId == null || provinceId.trim().equals("")) {
            return null;
        }
        if (HUABEI_REGION.contains(provinceId)) {
            return "1";
        }
        if (DONGBEI_REGION.contains(provinceId)) {
            return "2";
        }
        if (HUADONG_REGION.contains(provinceId)) {
            return "3";
        }
        if (HUAZHONG_REGION.contains(provinceId)) {
            return "4";
        }
        if (HUANAN_REGION.contains(provinceId)) {
            return "5";
        }
        if (XINAN_REGION.contains(provinceId)) {
            return "6";
        }
        if (XIBEI_REGION.contains(provinceId)) {
            return "7";
        }
        if (HMT_REGION.contains(provinceId)) {
            return "8";
        }
        return "-1";
    }

    public static String getCityTier(String cityId) {
        if (cityId == null || cityId.trim().equals("")) {
            return null;
        }
        if (HMT_TIER_CITY.contains(cityId.substring(0, Math.min(cityId.length(), 2)))) {
            return "9";
        }
        if (FIRST_TIER_CITY.contains(cityId)) {
            return "1";
        }
        if (SECOND_TIER_CITY.contains(cityId)) {
            return "2";
        }
        if (THIRD_TIER_CITY.contains(cityId)) {
            return "3";
        }
        return "4";
    }
}

