/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ESMM
implements Serializable {
    private static final long serialVersionUID = -316102112618444131L;
    private int PB_MAX_SIZE = 128;
    private IModel ctrModel;
    private IModel cvrModel;
    private IModel bCvrModel;
    private TFServingClient ctrTFServingClient;
    private TFServingClient cvrTFServingClient;
    private MutModelType mutModelType;

    public IModel getCtrModel() {
        return this.ctrModel;
    }

    public void setCtrModel(IModel ctrModel) {
        this.ctrModel = ctrModel;
    }

    public IModel getCvrModel() {
        return this.cvrModel;
    }

    public void setCvrModel(IModel cvrModel) {
        this.cvrModel = cvrModel;
    }

    public IModel getBCvrModel() {
        return this.bCvrModel;
    }

    public void setBCvrModel(IModel bCvrModel) {
        this.bCvrModel = bCvrModel;
    }

    public TFServingClient getCtrTFServingClient() {
        return this.ctrTFServingClient;
    }

    public void setCtrTFServingClient(TFServingClient ctrTFServingClient) {
        this.ctrTFServingClient = ctrTFServingClient;
    }

    public TFServingClient getCvrTFServingClient() {
        return this.cvrTFServingClient;
    }

    public void setCvrTFServingClient(TFServingClient cvrTFServingClient) {
        this.cvrTFServingClient = cvrTFServingClient;
    }

    public MutModelType getMutModelType() {
        return this.mutModelType;
    }

    public void setMutModelType(MutModelType mutModelType) {
        this.mutModelType = mutModelType;
    }

    public ESMM(IModel ctrModel, IModel cvrModel, IModel bCvrModel, TFServingClient ctrTFServingClient, TFServingClient cvrTFServingClient, MutModelType mutModelType) {
        this.ctrModel = ctrModel;
        this.cvrModel = cvrModel;
        this.bCvrModel = bCvrModel;
        this.ctrTFServingClient = ctrTFServingClient;
        this.cvrTFServingClient = cvrTFServingClient;
        this.mutModelType = mutModelType;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsWithTF(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<PredictResultType, Map<T, Double>> ret = null;
        ret = MutModelType.DEEP_ESMM == this.mutModelType ? this.ctrTFServingClient.predictMut(this.getParams(featureMap)) : this.predictCTRsAndCVRs(featureMap);
        return ret;
    }

    public <T> Map<T, Double> predictBCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        return this.bCvrModel.predicts(featureMap);
    }

    private <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        ret.put(PredictResultType.CTR, this.ctrModel.predictWithTF(featureMap, this.ctrTFServingClient));
        ret.put(PredictResultType.CVR, this.cvrModel.predictWithTF(featureMap, this.cvrTFServingClient));
        return ret;
    }

    private <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                List<Float> ctrP = this.ctrModel.getParam(entry.getValue());
                List<Float> cvrP = this.cvrModel.getParam(entry.getValue());
                ret.put(entry.getKey(), this.paramsSplicing(ctrP, cvrP));
            }
        }
        return ret;
    }

    private List<Float> paramsSplicing(List<Float> ctrP, List<Float> cvrP) {
        ctrP.addAll(cvrP);
        return ctrP;
    }
}

