/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FM
implements Serializable,
IModel {
    private static final long serialVersionUID = -316102112618444130L;
    private static final Logger logger = LoggerFactory.getLogger(FM.class);
    private String modelId;
    private String updateTime;
    private ParamsDo paramsDo;
    private int FBT_MAX_SIZE = 64;
    private int PB_MAX_SIZE = 128;
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(this.FBT_MAX_SIZE);

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    @Override
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;
        CodeResult codeResult = FeatureCoder.code(this.getFeatureBaseType(), featureMap);
        if (codeResult != null) {
            ret = this.predict(codeResult.getFeature());
        }
        return ret;
    }

    public double[] getParam2(Map<String, String> featureMap) throws Exception {
        double[] ret = null;
        CodeResult codeResult = FeatureCoder.code(this.getFeatureBaseType(), featureMap);
        if (codeResult != null) {
            ret = this.getModelParams(codeResult.getFeatureSet());
        }
        if (!this.modelId.startsWith("fm_ctr_v007") && !this.modelId.startsWith("fm_cvr_v007")) {
            String subNetIdStr = featureMap.getOrDefault("sub_net_id", "0.0");
            Double subNetId = DataUtil.string2Double((String)subNetIdStr);
            if (subNetId == null) {
                subNetId = 0.0;
            }
            ret = DataUtil.insertElement((double[])ret, (double)subNetId, (int)0);
        }
        return ret;
    }

    @Override
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        ArrayList<Float> ret = null;
        double[] value = this.getParam2(featureMap);
        if (value != null) {
            ret = new ArrayList<Float>();
            for (int i = 0; i < value.length; ++i) {
                ret.add(Float.valueOf((float)value[i]));
            }
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, Double> ret = new HashMap<T, Double>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.predict(entry.getValue()));
            }
        }
        return ret;
    }

    public <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.getParam(entry.getValue()));
            }
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null || featureMap != null && featureMap.size() > 70) {
            ret = this.predicts(featureMap);
        } else {
            try {
                ret = tfServingClient.predict(this.getParams(featureMap));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.warn("predictWithTF warn " + e);
                ret = this.predicts(featureMap);
            }
        }
        return ret;
    }

    public Double predict(Feature feature) throws Exception {
        try {
            double ret = 0.0;
            double retw0 = 0.0;
            double retw = 0.0;
            double retv = 0.0;
            long factorNum = this.paramsDo.getFactorNum();
            HashMap tmpMap = new HashMap(1);
            if (feature != null) {
                retw0 += this.paramsDo.getWeight0().doubleValue();
                for (int i = 0; i < feature.indices.length; ++i) {
                    Long fId = 0L + (long)feature.indices[i];
                    Double value = feature.values[i];
                    retw += this.paramsDo.getWeight().getOrDefault(fId, 0.0) * value;
                }
                int j = 0;
                while ((long)j < factorNum) {
                    Map parMap = this.paramsDo.getVector().getOrDefault(0L + (long)j, tmpMap);
                    double retvp1 = 0.0;
                    double retvp2 = 0.0;
                    for (int i = 0; i < feature.indices.length; ++i) {
                        Long fId = 0L + (long)feature.indices[i];
                        Double value = feature.values[i];
                        Double vif = parMap.getOrDefault(fId, 0.0);
                        retvp1 += value * vif;
                        retvp2 += Math.pow(value, 2.0) * Math.pow(vif, 2.0);
                    }
                    retv += 0.5 * (Math.pow(retvp1, 2.0) - retvp2);
                    ++j;
                }
                ret = retw0 + retw + retv;
            }
            double pValue = MathUtil.sigmoid((double)ret);
            double pCValue = this.correctValue(pValue, this.paramsDo.getCorrect());
            return DataUtil.formatdouble((double)pCValue, (int)5);
        }
        catch (Exception e) {
            System.out.println("FM.predict error");
            throw e;
        }
    }

    public double correctValue(double pre_, Double correct) {
        double ret = pre_;
        if (correct != null) {
            ret = correct / (1.0 / pre_ - 1.0 + correct);
        }
        return ret;
    }

    public double[] getModelParams(List<Set<Long>> codeSetList) throws Exception {
        try {
            boolean status = true;
            double[] ret = null;
            HashMap tmpMap = new HashMap(1);
            if (codeSetList != null) {
                int factorNum = this.paramsDo.getFactorNum().intValue();
                int fSize = codeSetList.size();
                double retw0 = 0.0;
                double[] retw = new double[fSize];
                double[] retv = new double[fSize * factorNum];
                ret = new double[1 + fSize + fSize * factorNum];
                retw0 = this.paramsDo.getWeight0();
                for (int i = 0; i < fSize; ++i) {
                    Set<Long> fSet = codeSetList.get(i);
                    if (fSet != null) {
                        double subw = 0.0;
                        int setSize = fSet.size();
                        for (Long f : fSet) {
                            subw += this.paramsDo.getWeight().getOrDefault(f, 0.0) / (double)setSize;
                        }
                        retw[i] = subw;
                        continue;
                    }
                    status = false;
                }
                for (int j = 0; j < factorNum; ++j) {
                    Map parMap = this.paramsDo.getVector().getOrDefault(0L + (long)j, tmpMap);
                    for (int i = 0; i < fSize; ++i) {
                        Set<Long> fSet = codeSetList.get(i);
                        if (fSet == null) continue;
                        double subv = 0.0;
                        int setSize = fSet.size();
                        for (Long f : fSet) {
                            subv += parMap.getOrDefault(f, 0.0) / (double)setSize;
                        }
                        retv[i * factorNum + j] = subv;
                    }
                }
                ret[0] = retw0;
                System.arraycopy(retw, 0, ret, 1, fSize);
                System.arraycopy(retv, 0, ret, 1 + fSize, fSize * factorNum);
            }
            return ret;
        }
        catch (Exception e) {
            System.out.println("FM.predict error");
            throw new Exception(e);
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>(100);
        ArrayList<Long> list = new ArrayList<Long>(100);
        for (int j = 0; j < 200; ++j) {
            map.put(j + "-", j + "--");
            list.add((long)j + 0L);
            System.out.println("map.size=" + map.size() + ",list.size=" + list.size());
        }
    }
}

