package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
//import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.*;

public class CODER implements Serializable, IModel {
//    private static final long serialVersionUID = -316102112618444130L;

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CODER.class);

    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 模型参数
     */
    private ParamsDo paramsDo;


    private Map<String, Map<Long, Long>> coderMap;

    private int FBT_MAX_SIZE = 64;

    private int PB_MAX_SIZE = 128;

    /**
     * 特征
     */
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(FBT_MAX_SIZE);
    ;

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }


    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }


    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }


    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    public Map<String, Map<Long, Long>> getCoderMap() {
        return coderMap;
    }

    public void setCoderMap(Map<String, Map<Long, Long>> coderMap) {
        this.coderMap = coderMap;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;

        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public String getCode(Map<String, String> featureMap) throws Exception {
        String ret = null;


        try {

            CodeResult codeResult = FeatureCoder.codeOfEachField(getFeatureBaseType(), featureMap);

            Map<String, Map<Long, Double>> fieldFeatureMap = codeResult.getFieldFeatureMap();


            List<String> fieldStringList = new ArrayList<>();
            for (FeatureBaseType featureBaseType : featureBaseType) {


                String field = featureBaseType.getName();

                List<Long> fCode = new ArrayList<>();

                Map<Long, Double> sparceCode = fieldFeatureMap.get(field);
                Map<Long, Long> denseCodeMap = coderMap.get(field);
                List<Long> sparceCodeKeyList = new ArrayList<>(sparceCode.keySet());

                Long filedDefaultValue = denseCodeMap.getOrDefault(0L, 0L);

                for (int i = 0; i < sparceCodeKeyList.size(); i++) {
                    Long codeDense = denseCodeMap.getOrDefault(sparceCodeKeyList.get(i), filedDefaultValue);
                    fCode.add(codeDense);
                }


                // 输出：特征拼接
                String fCodeString = CollectionUtil.toString(fCode, ",");

                // 输出：域拼接
                String fieldString = field + ":" + fCodeString;

                fieldStringList.add(fieldString);


            }

            // 输出：样本拼接
            ret = CollectionUtil.toString(fieldStringList, ";");

        } catch (Exception e) {
            logger.warn("getCode is invalid ", e);
        }


        return ret;
    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, Double> ret = new HashMap<>(PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), predict(entry.getValue()));
            }
        }

        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, List<Float>> ret = new HashMap<>(PB_MAX_SIZE);

        return ret;

    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, String> getCodes(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, String> ret = new HashMap<>(PB_MAX_SIZE);


        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), getCode(entry.getValue()));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }

        return ret;

    }

    /**
     * @param featureMap
     * @param tfServingClient
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null || (featureMap != null && featureMap.size() > 70)) {

            ret = null;
        } else {

            try {

//                System.out.println(JSON.toJSONString(getCodes(featureMap)));

                ret = tfServingClient.predictString(getCodes(featureMap));
//                System.out.println("dd="+JSON.toJSONString(ret));
            } catch (Exception e) {
                e.printStackTrace();
                String logInfo = tfServingClient.modelName + " predictWithTF warn ";
                logger.warn(logInfo + e);
                ret = null;
            }


        }


        return ret;
    }


    /**
     * @param featureMap
     * @param localTFModel
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {
//            DBTimeProfile.enter("CODER.predictWithLocalTF");
            if (AssertUtil.isNotEmpty(featureMap)) {
//                getCodes(featureMap);
//                System.out.println(JSON.toJSONString(getCodes(featureMap)));
//                System.out.println(JSON.toJSONString(featureMap));

                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }
                Map<T, String> fMap = getCodes(featureMap);
                if(AssertUtil.isEmpty(fMap)){
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(fMap);

//                System.out.println(JSON.toJSONString(ret));
            }
        } catch (Exception e) {

            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, e);
            ret = predicts(featureMap);
        }finally {
//            DBTimeProfile.release();
        }

        return ret;
    }


}
